# Roadmap

Doccano is a fast-moving, community supported project. This roadmap provides guidance about priorities and focus areas of the doccano team and lists the functionality expected in upcoming releases of doccano. Many of these areas are driven by community use cases, and we welcome further contributions to doccano.

## Current status

Doccano is now able to:

* Annotate a text classification task.
* Annotate a sequence labeling task.
* Annotate a sequence to sequence task.
* Deploy on Azure, AWS and Heroku by 1-click.
* Deploy anywhere by Docker.
* Colaborate with many people.
* Upload a labeled file.
* Download a labeled dataset.
* Delete an uploaded document.
* Confirm annotation statistics.
* Access via web API.

## Roadmap

This is a list of features on the short term roadmap and beyond:

### APIs

* Implement login and registration API.
* Implement OAuth 2.0 API.
* Devide AnnotationList API into each task API.
* Devide AnnotationDetail API into each task API.
* Enable to search documents by annotated labels.
* Optimize performance for statistics API.
* More documentation and tutorials.

### Project management

* Enable to manage user by project administrators.
* Implement RBAC and enable to assign a role to a user by project administrators.
* Enhance annotation statistics.

### Annotation

* Increase the number of annotation tasks such as relation extraction, entity linking, aspect-based sentiment analysis, visual question answering and so on.
* Introduce a plugin feature to define custom tasks by a user.
* Enable to automate labeling by using some technologies such as active learning or auto labeling.
* Enable to annotate by keyword search or some rules.
* Control sort order on the frontend.
* More documentation and tutorials.

### Upload and download

* Enable to import data from cloud storage like s3.
* Improve UX by showing progress bar.
* Support for downloading label definition.
* Support for custom tokenization.
* More performance optimizations.

### Accessibility

* Support smartphone to enable anyone to annotate anywhere.
* Enable to customize font and font-family.
* Enable to customize label color per user.
* Enable to customize site theme per user.

### Entire project

* Design Vue component and use it to implement frontend.
* Introduce frontend testing framework.
* Writing frontend testing.
* Automate frontend testing.
* Introduce pipenv and separate production and development environment.
* Enhance backend project structure.
* Improve project management structure to accelerate the project improvement.
* Create GitHub page by using mkdocs and move wiki contents to it.

### Community and engagement

* New resources for community discussion and feedback.
* Gather and highlight novel doccano use cases.

Track the progress of these features in the GitHub project tracker.
