# coding=utf-8

import textwrap
import unittest

from conans.model.ref import ConanFileReference
from conans.test.utils.tools import TestClient, create_local_git_repo


class RemoveCredentials(unittest.TestCase):

    conanfile = textwrap.dedent("""\
        from conans import ConanFile
        
        class Lib(ConanFile):
            scm = {"type": "git", "url": "auto"}
            
    """)

    def setUp(self):
        self.ref = ConanFileReference.loads("lib/1.0@lasote/testing")
        self.path, _ = create_local_git_repo({"conanfile.py": self.conanfile})
        self.client = TestClient()
        self.client.current_folder = self.path
        self.client.runner("git remote add origin https://url.to.be.sustituted", cwd=self.path)

    def test_https(self):
        expected_url = 'https://myrepo.com.git'
        origin_url = 'https://username:password@myrepo.com.git'

        self.client.runner("git remote set-url origin {}".format(origin_url), cwd=self.path)
        self.client.run("export . {}".format(self.ref))
        self.assertIn("Repo origin deduced by 'auto': {}".format(expected_url), self.client.out)
