﻿// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the Apache License, Version 2.0.  See License.txt in the project root for license information.

using System.Collections.Generic;
using Microsoft.CodeAnalysis.CSharp;
using Microsoft.CodeAnalysis.Editor.UnitTests.KeywordHighlighting;
using Microsoft.CodeAnalysis.Editor.UnitTests.Workspaces;

namespace Microsoft.CodeAnalysis.Editor.CSharp.UnitTests.KeywordHighlighting
{
    public abstract class AbstractCSharpKeywordHighlighterTests
        : AbstractKeywordHighlighterTests
    {
        protected override TestWorkspace CreateWorkspaceFromFile(string code, ParseOptions options)
        {
            return CSharpWorkspaceFactory.CreateWorkspaceFromFile(code, (CSharpParseOptions)options);
        }

        protected override IEnumerable<ParseOptions> GetOptions()
        {
            yield return Options.Regular;
            yield return Options.Script;
        }
    }
}
