/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.zip;

import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public abstract class ZipUtils {
    public static final short COMPRESSION_METHOD_STORED = 0;
    public static final short COMPRESSION_METHOD_DEFLATED = 8;
    public static final short GP_FLAG_DATA_DESCRIPTOR_USED = 8;
    public static final short GP_FLAG_EFS = 2048;
    private static final int ZIP_EOCD_REC_MIN_SIZE = 22;
    private static final int ZIP_EOCD_REC_SIG = 101010256;
    private static final int ZIP_EOCD_CENTRAL_DIR_TOTAL_RECORD_COUNT_OFFSET = 10;
    private static final int ZIP_EOCD_CENTRAL_DIR_SIZE_FIELD_OFFSET = 12;
    private static final int ZIP_EOCD_CENTRAL_DIR_OFFSET_FIELD_OFFSET = 16;
    private static final int ZIP_EOCD_COMMENT_LENGTH_FIELD_OFFSET = 20;
    private static final int ZIP64_EOCD_LOCATOR_SIZE = 20;
    private static final int ZIP64_EOCD_LOCATOR_SIG = 117853008;
    private static final int UINT16_MAX_VALUE = 65535;

    private ZipUtils() {
    }

    public static void setZipEocdCentralDirectoryOffset(ByteBuffer byteBuffer, long l) {
        ZipUtils.assertByteOrderLittleEndian(byteBuffer);
        ZipUtils.setUnsignedInt32(byteBuffer, byteBuffer.position() + 16, l);
    }

    public static long getZipEocdCentralDirectoryOffset(ByteBuffer byteBuffer) {
        ZipUtils.assertByteOrderLittleEndian(byteBuffer);
        return ZipUtils.getUnsignedInt32(byteBuffer, byteBuffer.position() + 16);
    }

    public static long getZipEocdCentralDirectorySizeBytes(ByteBuffer byteBuffer) {
        ZipUtils.assertByteOrderLittleEndian(byteBuffer);
        return ZipUtils.getUnsignedInt32(byteBuffer, byteBuffer.position() + 12);
    }

    public static int getZipEocdCentralDirectoryTotalRecordCount(ByteBuffer byteBuffer) {
        ZipUtils.assertByteOrderLittleEndian(byteBuffer);
        return ZipUtils.getUnsignedInt16(byteBuffer, byteBuffer.position() + 10);
    }

    public static Pair<ByteBuffer, Long> findZipEndOfCentralDirectoryRecord(DataSource dataSource) throws IOException {
        long l = dataSource.size();
        if (l < 22L) {
            return null;
        }
        Pair<ByteBuffer, Long> pair = ZipUtils.findZipEndOfCentralDirectoryRecord(dataSource, 0);
        if (pair != null) {
            return pair;
        }
        return ZipUtils.findZipEndOfCentralDirectoryRecord(dataSource, 65535);
    }

    private static Pair<ByteBuffer, Long> findZipEndOfCentralDirectoryRecord(DataSource dataSource, int n) throws IOException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("maxCommentSize: " + n);
        }
        long l = dataSource.size();
        if (l < 22L) {
            return null;
        }
        n = (int)Math.min((long)n, l - 22L);
        int n2 = 22 + n;
        long l2 = l - (long)n2;
        ByteBuffer byteBuffer = dataSource.getByteBuffer(l2, n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n3 = ZipUtils.findZipEndOfCentralDirectoryRecord(byteBuffer);
        if (n3 == -1) {
            return null;
        }
        byteBuffer.position(n3);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        return Pair.of(byteBuffer2, l2 + (long)n3);
    }

    private static int findZipEndOfCentralDirectoryRecord(ByteBuffer byteBuffer) {
        ZipUtils.assertByteOrderLittleEndian(byteBuffer);
        int n = byteBuffer.capacity();
        if (n < 22) {
            return -1;
        }
        int n2 = Math.min(n - 22, 65535);
        int n3 = n - 22;
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5 = n3 - i;
            if (byteBuffer.getInt(n5) != 101010256 || (n4 = ZipUtils.getUnsignedInt16(byteBuffer, n5 + 20)) != i) continue;
            return n5;
        }
        return -1;
    }

    public static final boolean isZip64EndOfCentralDirectoryLocatorPresent(DataSource dataSource, long l) throws IOException {
        long l2 = l - 20L;
        if (l2 < 0L) {
            return false;
        }
        ByteBuffer byteBuffer = dataSource.getByteBuffer(l2, 4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getInt(0) == 117853008;
    }

    static void assertByteOrderLittleEndian(ByteBuffer byteBuffer) {
        if (byteBuffer.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("ByteBuffer byte order must be little endian");
        }
    }

    public static int getUnsignedInt16(ByteBuffer byteBuffer, int n) {
        return byteBuffer.getShort(n) & 0xFFFF;
    }

    public static int getUnsignedInt16(ByteBuffer byteBuffer) {
        return byteBuffer.getShort() & 0xFFFF;
    }

    static void setUnsignedInt16(ByteBuffer byteBuffer, int n, int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("uint16 value of out range: " + n2);
        }
        byteBuffer.putShort(n, (short)n2);
    }

    static void setUnsignedInt32(ByteBuffer byteBuffer, int n, long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("uint32 value of out range: " + l);
        }
        byteBuffer.putInt(n, (int)l);
    }

    public static void putUnsignedInt16(ByteBuffer byteBuffer, int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("uint16 value of out range: " + n);
        }
        byteBuffer.putShort((short)n);
    }

    static long getUnsignedInt32(ByteBuffer byteBuffer, int n) {
        return (long)byteBuffer.getInt(n) & 0xFFFFFFFFL;
    }

    static long getUnsignedInt32(ByteBuffer byteBuffer) {
        return (long)byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    static void putUnsignedInt32(ByteBuffer byteBuffer, long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("uint32 value of out range: " + l);
        }
        byteBuffer.putInt((int)l);
    }

    public static DeflateResult deflate(ByteBuffer byteBuffer) {
        int n;
        byte[] byArray;
        int n2 = byteBuffer.remaining();
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
            n = byteBuffer.arrayOffset() + byteBuffer.position();
            byteBuffer.position(byteBuffer.limit());
        } else {
            byArray = new byte[n2];
            n = 0;
            byteBuffer.get(byArray);
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, n, n2);
        long l = cRC32.getValue();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(9, true);
        deflater.setInput(byArray, n, n2);
        deflater.finish();
        byte[] byArray2 = new byte[65536];
        while (!deflater.finished()) {
            int n3 = deflater.deflate(byArray2);
            byteArrayOutputStream.write(byArray2, 0, n3);
        }
        return new DeflateResult(n2, l, byteArrayOutputStream.toByteArray());
    }

    public static class DeflateResult {
        public final int inputSizeBytes;
        public final long inputCrc32;
        public final byte[] output;

        public DeflateResult(int n, long l, byte[] byArray) {
            this.inputSizeBytes = n;
            this.inputCrc32 = l;
            this.output = byArray;
        }
    }
}

