import { babel } from '@rollup/plugin-babel';
import commonjs from '@rollup/plugin-commonjs';
import { nodeResolve } from '@rollup/plugin-node-resolve';

export default {
  input: 'build/scripts/test-inputs.js', // Input file generated by gulp task
  output: {
    file: 'build/scripts/tests.bundle.js',
    format: 'es',
    sourcemap: true,
  },
  treeshake: false,
  plugins: [
    nodeResolve({
      browser: true,

      // Disallow use of browser polyfills for Node builtin modules. We're
      // trying to avoid dependencies which rely on these.
      //
      // There are a couple of references to Node builtins that are stubbed by
      // configuration for the `virtual` plugin above.
      preferBuiltins: false,
    }),
    commonjs(),
    babel({
      babelHelpers: 'bundled',
      exclude: 'node_modules/**',
      plugins: ['mockable-imports'],
    }),
  ],
};
