// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.24.3
// source: messages-management.proto

package trezor

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// *
// Type of the mnemonic backup given/received by the device during reset/recovery.
type BackupType int32

const (
	BackupType_Bip39           BackupType = 0 // also called "Single Backup", see BIP-0039
	BackupType_Slip39_Basic    BackupType = 1 // also called "Shamir Backup", see SLIP-0039
	BackupType_Slip39_Advanced BackupType = 2 // also called "Super Shamir" or "Shamir with Groups", see SLIP-0039#two-level-scheme
)

// Enum value maps for BackupType.
var (
	BackupType_name = map[int32]string{
		0: "Bip39",
		1: "Slip39_Basic",
		2: "Slip39_Advanced",
	}
	BackupType_value = map[string]int32{
		"Bip39":           0,
		"Slip39_Basic":    1,
		"Slip39_Advanced": 2,
	}
)

func (x BackupType) Enum() *BackupType {
	p := new(BackupType)
	*p = x
	return p
}

func (x BackupType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupType) Descriptor() protoreflect.EnumDescriptor {
	return file_messages_management_proto_enumTypes[0].Descriptor()
}

func (BackupType) Type() protoreflect.EnumType {
	return &file_messages_management_proto_enumTypes[0]
}

func (x BackupType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *BackupType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = BackupType(num)
	return nil
}

// Deprecated: Use BackupType.Descriptor instead.
func (BackupType) EnumDescriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{0}
}

// *
// Level of safety checks for unsafe actions like spending from invalid path namespace or setting high transaction fee.
type SafetyCheckLevel int32

const (
	SafetyCheckLevel_Strict            SafetyCheckLevel = 0 // disallow unsafe actions, this is the default
	SafetyCheckLevel_PromptAlways      SafetyCheckLevel = 1 // ask user before unsafe action
	SafetyCheckLevel_PromptTemporarily SafetyCheckLevel = 2 // like PromptAlways but reverts to Strict after reboot
)

// Enum value maps for SafetyCheckLevel.
var (
	SafetyCheckLevel_name = map[int32]string{
		0: "Strict",
		1: "PromptAlways",
		2: "PromptTemporarily",
	}
	SafetyCheckLevel_value = map[string]int32{
		"Strict":            0,
		"PromptAlways":      1,
		"PromptTemporarily": 2,
	}
)

func (x SafetyCheckLevel) Enum() *SafetyCheckLevel {
	p := new(SafetyCheckLevel)
	*p = x
	return p
}

func (x SafetyCheckLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafetyCheckLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_messages_management_proto_enumTypes[1].Descriptor()
}

func (SafetyCheckLevel) Type() protoreflect.EnumType {
	return &file_messages_management_proto_enumTypes[1]
}

func (x SafetyCheckLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *SafetyCheckLevel) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = SafetyCheckLevel(num)
	return nil
}

// Deprecated: Use SafetyCheckLevel.Descriptor instead.
func (SafetyCheckLevel) EnumDescriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{1}
}

// *
// Format of the homescreen image
type HomescreenFormat int32

const (
	HomescreenFormat_Toif HomescreenFormat = 1 // full-color toif
	HomescreenFormat_Jpeg HomescreenFormat = 2 // jpeg
	HomescreenFormat_ToiG HomescreenFormat = 3 // greyscale toif
)

// Enum value maps for HomescreenFormat.
var (
	HomescreenFormat_name = map[int32]string{
		1: "Toif",
		2: "Jpeg",
		3: "ToiG",
	}
	HomescreenFormat_value = map[string]int32{
		"Toif": 1,
		"Jpeg": 2,
		"ToiG": 3,
	}
)

func (x HomescreenFormat) Enum() *HomescreenFormat {
	p := new(HomescreenFormat)
	*p = x
	return p
}

func (x HomescreenFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HomescreenFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_messages_management_proto_enumTypes[2].Descriptor()
}

func (HomescreenFormat) Type() protoreflect.EnumType {
	return &file_messages_management_proto_enumTypes[2]
}

func (x HomescreenFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *HomescreenFormat) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = HomescreenFormat(num)
	return nil
}

// Deprecated: Use HomescreenFormat.Descriptor instead.
func (HomescreenFormat) EnumDescriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{2}
}

type Features_Capability int32

const (
	Features_Capability_Bitcoin      Features_Capability = 1
	Features_Capability_Bitcoin_like Features_Capability = 2 // Altcoins based on the Bitcoin source code
	Features_Capability_Binance      Features_Capability = 3
	Features_Capability_Cardano      Features_Capability = 4
	Features_Capability_Crypto       Features_Capability = 5 // generic crypto operations for GPG, SSH, etc.
	Features_Capability_EOS          Features_Capability = 6
	Features_Capability_Ethereum     Features_Capability = 7
	// Deprecated: Marked as deprecated in messages-management.proto.
	Features_Capability_Lisk            Features_Capability = 8
	Features_Capability_Monero          Features_Capability = 9
	Features_Capability_NEM             Features_Capability = 10
	Features_Capability_Ripple          Features_Capability = 11
	Features_Capability_Stellar         Features_Capability = 12
	Features_Capability_Tezos           Features_Capability = 13
	Features_Capability_U2F             Features_Capability = 14
	Features_Capability_Shamir          Features_Capability = 15
	Features_Capability_ShamirGroups    Features_Capability = 16
	Features_Capability_PassphraseEntry Features_Capability = 17 // the device is capable of passphrase entry directly on the device
	Features_Capability_Solana          Features_Capability = 18
	Features_Capability_Translations    Features_Capability = 19
)

// Enum value maps for Features_Capability.
var (
	Features_Capability_name = map[int32]string{
		1:  "Capability_Bitcoin",
		2:  "Capability_Bitcoin_like",
		3:  "Capability_Binance",
		4:  "Capability_Cardano",
		5:  "Capability_Crypto",
		6:  "Capability_EOS",
		7:  "Capability_Ethereum",
		8:  "Capability_Lisk",
		9:  "Capability_Monero",
		10: "Capability_NEM",
		11: "Capability_Ripple",
		12: "Capability_Stellar",
		13: "Capability_Tezos",
		14: "Capability_U2F",
		15: "Capability_Shamir",
		16: "Capability_ShamirGroups",
		17: "Capability_PassphraseEntry",
		18: "Capability_Solana",
		19: "Capability_Translations",
	}
	Features_Capability_value = map[string]int32{
		"Capability_Bitcoin":         1,
		"Capability_Bitcoin_like":    2,
		"Capability_Binance":         3,
		"Capability_Cardano":         4,
		"Capability_Crypto":          5,
		"Capability_EOS":             6,
		"Capability_Ethereum":        7,
		"Capability_Lisk":            8,
		"Capability_Monero":          9,
		"Capability_NEM":             10,
		"Capability_Ripple":          11,
		"Capability_Stellar":         12,
		"Capability_Tezos":           13,
		"Capability_U2F":             14,
		"Capability_Shamir":          15,
		"Capability_ShamirGroups":    16,
		"Capability_PassphraseEntry": 17,
		"Capability_Solana":          18,
		"Capability_Translations":    19,
	}
)

func (x Features_Capability) Enum() *Features_Capability {
	p := new(Features_Capability)
	*p = x
	return p
}

func (x Features_Capability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Features_Capability) Descriptor() protoreflect.EnumDescriptor {
	return file_messages_management_proto_enumTypes[3].Descriptor()
}

func (Features_Capability) Type() protoreflect.EnumType {
	return &file_messages_management_proto_enumTypes[3]
}

func (x Features_Capability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Features_Capability) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Features_Capability(num)
	return nil
}

// Deprecated: Use Features_Capability.Descriptor instead.
func (Features_Capability) EnumDescriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{2, 0}
}

// *
// Structure representing SD card protection operation
type SdProtect_SdProtectOperationType int32

const (
	SdProtect_DISABLE SdProtect_SdProtectOperationType = 0
	SdProtect_ENABLE  SdProtect_SdProtectOperationType = 1
	SdProtect_REFRESH SdProtect_SdProtectOperationType = 2
)

// Enum value maps for SdProtect_SdProtectOperationType.
var (
	SdProtect_SdProtectOperationType_name = map[int32]string{
		0: "DISABLE",
		1: "ENABLE",
		2: "REFRESH",
	}
	SdProtect_SdProtectOperationType_value = map[string]int32{
		"DISABLE": 0,
		"ENABLE":  1,
		"REFRESH": 2,
	}
)

func (x SdProtect_SdProtectOperationType) Enum() *SdProtect_SdProtectOperationType {
	p := new(SdProtect_SdProtectOperationType)
	*p = x
	return p
}

func (x SdProtect_SdProtectOperationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SdProtect_SdProtectOperationType) Descriptor() protoreflect.EnumDescriptor {
	return file_messages_management_proto_enumTypes[4].Descriptor()
}

func (SdProtect_SdProtectOperationType) Type() protoreflect.EnumType {
	return &file_messages_management_proto_enumTypes[4]
}

func (x SdProtect_SdProtectOperationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *SdProtect_SdProtectOperationType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = SdProtect_SdProtectOperationType(num)
	return nil
}

// Deprecated: Use SdProtect_SdProtectOperationType.Descriptor instead.
func (SdProtect_SdProtectOperationType) EnumDescriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{13, 0}
}

// *
// Type of recovery procedure. These should be used as bitmask, e.g.,
// `RecoveryDeviceType_ScrambledWords | RecoveryDeviceType_Matrix`
// listing every method supported by the host computer.
//
// Note that ScrambledWords must be supported by every implementation
// for backward compatibility; there is no way to not support it.
type RecoveryDevice_RecoveryDeviceType int32

const (
	// use powers of two when extending this field
	RecoveryDevice_RecoveryDeviceType_ScrambledWords RecoveryDevice_RecoveryDeviceType = 0 // words in scrambled order
	RecoveryDevice_RecoveryDeviceType_Matrix         RecoveryDevice_RecoveryDeviceType = 1 // matrix recovery type
)

// Enum value maps for RecoveryDevice_RecoveryDeviceType.
var (
	RecoveryDevice_RecoveryDeviceType_name = map[int32]string{
		0: "RecoveryDeviceType_ScrambledWords",
		1: "RecoveryDeviceType_Matrix",
	}
	RecoveryDevice_RecoveryDeviceType_value = map[string]int32{
		"RecoveryDeviceType_ScrambledWords": 0,
		"RecoveryDeviceType_Matrix":         1,
	}
)

func (x RecoveryDevice_RecoveryDeviceType) Enum() *RecoveryDevice_RecoveryDeviceType {
	p := new(RecoveryDevice_RecoveryDeviceType)
	*p = x
	return p
}

func (x RecoveryDevice_RecoveryDeviceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecoveryDevice_RecoveryDeviceType) Descriptor() protoreflect.EnumDescriptor {
	return file_messages_management_proto_enumTypes[5].Descriptor()
}

func (RecoveryDevice_RecoveryDeviceType) Type() protoreflect.EnumType {
	return &file_messages_management_proto_enumTypes[5]
}

func (x RecoveryDevice_RecoveryDeviceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *RecoveryDevice_RecoveryDeviceType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = RecoveryDevice_RecoveryDeviceType(num)
	return nil
}

// Deprecated: Use RecoveryDevice_RecoveryDeviceType.Descriptor instead.
func (RecoveryDevice_RecoveryDeviceType) EnumDescriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{28, 0}
}

// *
// Type of Recovery Word request
type WordRequest_WordRequestType int32

const (
	WordRequest_WordRequestType_Plain   WordRequest_WordRequestType = 0
	WordRequest_WordRequestType_Matrix9 WordRequest_WordRequestType = 1
	WordRequest_WordRequestType_Matrix6 WordRequest_WordRequestType = 2
)

// Enum value maps for WordRequest_WordRequestType.
var (
	WordRequest_WordRequestType_name = map[int32]string{
		0: "WordRequestType_Plain",
		1: "WordRequestType_Matrix9",
		2: "WordRequestType_Matrix6",
	}
	WordRequest_WordRequestType_value = map[string]int32{
		"WordRequestType_Plain":   0,
		"WordRequestType_Matrix9": 1,
		"WordRequestType_Matrix6": 2,
	}
)

func (x WordRequest_WordRequestType) Enum() *WordRequest_WordRequestType {
	p := new(WordRequest_WordRequestType)
	*p = x
	return p
}

func (x WordRequest_WordRequestType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WordRequest_WordRequestType) Descriptor() protoreflect.EnumDescriptor {
	return file_messages_management_proto_enumTypes[6].Descriptor()
}

func (WordRequest_WordRequestType) Type() protoreflect.EnumType {
	return &file_messages_management_proto_enumTypes[6]
}

func (x WordRequest_WordRequestType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *WordRequest_WordRequestType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = WordRequest_WordRequestType(num)
	return nil
}

// Deprecated: Use WordRequest_WordRequestType.Descriptor instead.
func (WordRequest_WordRequestType) EnumDescriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{29, 0}
}

type RebootToBootloader_BootCommand int32

const (
	// Go to bootloader menu
	RebootToBootloader_STOP_AND_WAIT RebootToBootloader_BootCommand = 0
	// Connect to host and wait for firmware update
	RebootToBootloader_INSTALL_UPGRADE RebootToBootloader_BootCommand = 1
)

// Enum value maps for RebootToBootloader_BootCommand.
var (
	RebootToBootloader_BootCommand_name = map[int32]string{
		0: "STOP_AND_WAIT",
		1: "INSTALL_UPGRADE",
	}
	RebootToBootloader_BootCommand_value = map[string]int32{
		"STOP_AND_WAIT":   0,
		"INSTALL_UPGRADE": 1,
	}
)

func (x RebootToBootloader_BootCommand) Enum() *RebootToBootloader_BootCommand {
	p := new(RebootToBootloader_BootCommand)
	*p = x
	return p
}

func (x RebootToBootloader_BootCommand) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RebootToBootloader_BootCommand) Descriptor() protoreflect.EnumDescriptor {
	return file_messages_management_proto_enumTypes[7].Descriptor()
}

func (RebootToBootloader_BootCommand) Type() protoreflect.EnumType {
	return &file_messages_management_proto_enumTypes[7]
}

func (x RebootToBootloader_BootCommand) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *RebootToBootloader_BootCommand) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = RebootToBootloader_BootCommand(num)
	return nil
}

// Deprecated: Use RebootToBootloader_BootCommand.Descriptor instead.
func (RebootToBootloader_BootCommand) EnumDescriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{37, 0}
}

// *
// Request: Reset device to default state and ask for device details
// @start
// @next Features
type Initialize struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SessionId []byte `protobuf:"bytes,1,opt,name=session_id,json=sessionId" json:"session_id,omitempty"` // assumed device session id; Trezor clears caches if it is different or empty
	// Deprecated: Marked as deprecated in messages-management.proto.
	XSkipPassphrase *bool `protobuf:"varint,2,opt,name=_skip_passphrase,json=SkipPassphrase" json:"_skip_passphrase,omitempty"` // removed as part of passphrase redesign
	DeriveCardano   *bool `protobuf:"varint,3,opt,name=derive_cardano,json=deriveCardano" json:"derive_cardano,omitempty"`      // whether to derive Cardano Icarus root keys in this session
}

func (x *Initialize) Reset() {
	*x = Initialize{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Initialize) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Initialize) ProtoMessage() {}

func (x *Initialize) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Initialize.ProtoReflect.Descriptor instead.
func (*Initialize) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{0}
}

func (x *Initialize) GetSessionId() []byte {
	if x != nil {
		return x.SessionId
	}
	return nil
}

// Deprecated: Marked as deprecated in messages-management.proto.
func (x *Initialize) GetXSkipPassphrase() bool {
	if x != nil && x.XSkipPassphrase != nil {
		return *x.XSkipPassphrase
	}
	return false
}

func (x *Initialize) GetDeriveCardano() bool {
	if x != nil && x.DeriveCardano != nil {
		return *x.DeriveCardano
	}
	return false
}

// *
// Request: Ask for device details (no device reset)
// @start
// @next Features
type GetFeatures struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetFeatures) Reset() {
	*x = GetFeatures{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFeatures) ProtoMessage() {}

func (x *GetFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFeatures.ProtoReflect.Descriptor instead.
func (*GetFeatures) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{1}
}

// *
// Response: Reports various information about the device
// @end
type Features struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Vendor               *string `protobuf:"bytes,1,opt,name=vendor" json:"vendor,omitempty"`                                                          // name of the manufacturer, e.g. "trezor.io"
	MajorVersion         *uint32 `protobuf:"varint,2,req,name=major_version,json=majorVersion" json:"major_version,omitempty"`                         // major version of the firmware/bootloader, e.g. 1
	MinorVersion         *uint32 `protobuf:"varint,3,req,name=minor_version,json=minorVersion" json:"minor_version,omitempty"`                         // minor version of the firmware/bootloader, e.g. 0
	PatchVersion         *uint32 `protobuf:"varint,4,req,name=patch_version,json=patchVersion" json:"patch_version,omitempty"`                         // patch version of the firmware/bootloader, e.g. 0
	BootloaderMode       *bool   `protobuf:"varint,5,opt,name=bootloader_mode,json=bootloaderMode" json:"bootloader_mode,omitempty"`                   // is device in bootloader mode?
	DeviceId             *string `protobuf:"bytes,6,opt,name=device_id,json=deviceId" json:"device_id,omitempty"`                                      // device's unique identifier
	PinProtection        *bool   `protobuf:"varint,7,opt,name=pin_protection,json=pinProtection" json:"pin_protection,omitempty"`                      // is device protected by PIN?
	PassphraseProtection *bool   `protobuf:"varint,8,opt,name=passphrase_protection,json=passphraseProtection" json:"passphrase_protection,omitempty"` // is node/mnemonic encrypted using passphrase?
	Language             *string `protobuf:"bytes,9,opt,name=language" json:"language,omitempty"`                                                      // device language
	Label                *string `protobuf:"bytes,10,opt,name=label" json:"label,omitempty"`                                                           // device description label
	Initialized          *bool   `protobuf:"varint,12,opt,name=initialized" json:"initialized,omitempty"`                                              // does device contain seed?
	Revision             []byte  `protobuf:"bytes,13,opt,name=revision" json:"revision,omitempty"`                                                     // SCM revision of firmware
	BootloaderHash       []byte  `protobuf:"bytes,14,opt,name=bootloader_hash,json=bootloaderHash" json:"bootloader_hash,omitempty"`                   // hash of the bootloader
	Imported             *bool   `protobuf:"varint,15,opt,name=imported" json:"imported,omitempty"`                                                    // was storage imported from an external source?
	Unlocked             *bool   `protobuf:"varint,16,opt,name=unlocked" json:"unlocked,omitempty"`                                                    // is the device unlocked? called "pin_cached" previously
	// Deprecated: Marked as deprecated in messages-management.proto.
	XPassphraseCached *bool   `protobuf:"varint,17,opt,name=_passphrase_cached,json=PassphraseCached" json:"_passphrase_cached,omitempty"` // is passphrase already cached in session?
	FirmwarePresent   *bool   `protobuf:"varint,18,opt,name=firmware_present,json=firmwarePresent" json:"firmware_present,omitempty"`      // is valid firmware loaded?
	NeedsBackup       *bool   `protobuf:"varint,19,opt,name=needs_backup,json=needsBackup" json:"needs_backup,omitempty"`                  // does storage need backup? (equals to Storage.needs_backup)
	Flags             *uint32 `protobuf:"varint,20,opt,name=flags" json:"flags,omitempty"`                                                 // device flags (equals to Storage.flags)
	Model             *string `protobuf:"bytes,21,opt,name=model" json:"model,omitempty"`                                                  // device hardware model
	FwMajor           *uint32 `protobuf:"varint,22,opt,name=fw_major,json=fwMajor" json:"fw_major,omitempty"`                              // reported firmware version if in bootloader mode
	FwMinor           *uint32 `protobuf:"varint,23,opt,name=fw_minor,json=fwMinor" json:"fw_minor,omitempty"`                              // reported firmware version if in bootloader mode
	FwPatch           *uint32 `protobuf:"varint,24,opt,name=fw_patch,json=fwPatch" json:"fw_patch,omitempty"`                              // reported firmware version if in bootloader mode
	FwVendor          *string `protobuf:"bytes,25,opt,name=fw_vendor,json=fwVendor" json:"fw_vendor,omitempty"`                            // reported firmware vendor if in bootloader mode
	// optional bytes fw_vendor_keys = 26;      // obsoleted, use fw_vendor
	UnfinishedBackup         *bool                 `protobuf:"varint,27,opt,name=unfinished_backup,json=unfinishedBackup" json:"unfinished_backup,omitempty"`                             // report unfinished backup (equals to Storage.unfinished_backup)
	NoBackup                 *bool                 `protobuf:"varint,28,opt,name=no_backup,json=noBackup" json:"no_backup,omitempty"`                                                     // report no backup (equals to Storage.no_backup)
	RecoveryMode             *bool                 `protobuf:"varint,29,opt,name=recovery_mode,json=recoveryMode" json:"recovery_mode,omitempty"`                                         // is recovery mode in progress
	Capabilities             []Features_Capability `protobuf:"varint,30,rep,name=capabilities,enum=hw.trezor.messages.management.Features_Capability" json:"capabilities,omitempty"`      // list of supported capabilities
	BackupType               *BackupType           `protobuf:"varint,31,opt,name=backup_type,json=backupType,enum=hw.trezor.messages.management.BackupType" json:"backup_type,omitempty"` // type of device backup (BIP-39 / SLIP-39 basic / SLIP-39 advanced)
	SdCardPresent            *bool                 `protobuf:"varint,32,opt,name=sd_card_present,json=sdCardPresent" json:"sd_card_present,omitempty"`                                    // is SD card present
	SdProtection             *bool                 `protobuf:"varint,33,opt,name=sd_protection,json=sdProtection" json:"sd_protection,omitempty"`                                         // is SD Protect enabled
	WipeCodeProtection       *bool                 `protobuf:"varint,34,opt,name=wipe_code_protection,json=wipeCodeProtection" json:"wipe_code_protection,omitempty"`                     // is wipe code protection enabled
	SessionId                []byte                `protobuf:"bytes,35,opt,name=session_id,json=sessionId" json:"session_id,omitempty"`
	PassphraseAlwaysOnDevice *bool                 `protobuf:"varint,36,opt,name=passphrase_always_on_device,json=passphraseAlwaysOnDevice" json:"passphrase_always_on_device,omitempty"`                         // device enforces passphrase entry on Trezor
	SafetyChecks             *SafetyCheckLevel     `protobuf:"varint,37,opt,name=safety_checks,json=safetyChecks,enum=hw.trezor.messages.management.SafetyCheckLevel" json:"safety_checks,omitempty"`             // safety check level, set to Prompt to limit path namespace enforcement
	AutoLockDelayMs          *uint32               `protobuf:"varint,38,opt,name=auto_lock_delay_ms,json=autoLockDelayMs" json:"auto_lock_delay_ms,omitempty"`                                                    // number of milliseconds after which the device locks itself
	DisplayRotation          *uint32               `protobuf:"varint,39,opt,name=display_rotation,json=displayRotation" json:"display_rotation,omitempty"`                                                        // in degrees from North
	ExperimentalFeatures     *bool                 `protobuf:"varint,40,opt,name=experimental_features,json=experimentalFeatures" json:"experimental_features,omitempty"`                                         // are experimental message types enabled?
	Busy                     *bool                 `protobuf:"varint,41,opt,name=busy" json:"busy,omitempty"`                                                                                                     // is the device busy, showing "Do not disconnect"?
	HomescreenFormat         *HomescreenFormat     `protobuf:"varint,42,opt,name=homescreen_format,json=homescreenFormat,enum=hw.trezor.messages.management.HomescreenFormat" json:"homescreen_format,omitempty"` // format of the homescreen, 1 = TOIf, 2 = jpg, 3 = TOIG
	HidePassphraseFromHost   *bool                 `protobuf:"varint,43,opt,name=hide_passphrase_from_host,json=hidePassphraseFromHost" json:"hide_passphrase_from_host,omitempty"`                               // should we hide the passphrase when it comes from host?
	InternalModel            *string               `protobuf:"bytes,44,opt,name=internal_model,json=internalModel" json:"internal_model,omitempty"`                                                               // internal model name
	UnitColor                *uint32               `protobuf:"varint,45,opt,name=unit_color,json=unitColor" json:"unit_color,omitempty"`                                                                          // color of the unit/device
	UnitBtconly              *bool                 `protobuf:"varint,46,opt,name=unit_btconly,json=unitBtconly" json:"unit_btconly,omitempty"`                                                                    // unit/device is intended as bitcoin only
	HomescreenWidth          *uint32               `protobuf:"varint,47,opt,name=homescreen_width,json=homescreenWidth" json:"homescreen_width,omitempty"`                                                        // homescreen width in pixels
	HomescreenHeight         *uint32               `protobuf:"varint,48,opt,name=homescreen_height,json=homescreenHeight" json:"homescreen_height,omitempty"`                                                     // homescreen height in pixels
	BootloaderLocked         *bool                 `protobuf:"varint,49,opt,name=bootloader_locked,json=bootloaderLocked" json:"bootloader_locked,omitempty"`                                                     // bootloader is locked
	LanguageVersionMatches   *bool                 `protobuf:"varint,50,opt,name=language_version_matches,json=languageVersionMatches,def=1" json:"language_version_matches,omitempty"`                           // translation blob version matches firmware version
}

// Default values for Features fields.
const (
	Default_Features_LanguageVersionMatches = bool(true)
)

func (x *Features) Reset() {
	*x = Features{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Features) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Features) ProtoMessage() {}

func (x *Features) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Features.ProtoReflect.Descriptor instead.
func (*Features) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{2}
}

func (x *Features) GetVendor() string {
	if x != nil && x.Vendor != nil {
		return *x.Vendor
	}
	return ""
}

func (x *Features) GetMajorVersion() uint32 {
	if x != nil && x.MajorVersion != nil {
		return *x.MajorVersion
	}
	return 0
}

func (x *Features) GetMinorVersion() uint32 {
	if x != nil && x.MinorVersion != nil {
		return *x.MinorVersion
	}
	return 0
}

func (x *Features) GetPatchVersion() uint32 {
	if x != nil && x.PatchVersion != nil {
		return *x.PatchVersion
	}
	return 0
}

func (x *Features) GetBootloaderMode() bool {
	if x != nil && x.BootloaderMode != nil {
		return *x.BootloaderMode
	}
	return false
}

func (x *Features) GetDeviceId() string {
	if x != nil && x.DeviceId != nil {
		return *x.DeviceId
	}
	return ""
}

func (x *Features) GetPinProtection() bool {
	if x != nil && x.PinProtection != nil {
		return *x.PinProtection
	}
	return false
}

func (x *Features) GetPassphraseProtection() bool {
	if x != nil && x.PassphraseProtection != nil {
		return *x.PassphraseProtection
	}
	return false
}

func (x *Features) GetLanguage() string {
	if x != nil && x.Language != nil {
		return *x.Language
	}
	return ""
}

func (x *Features) GetLabel() string {
	if x != nil && x.Label != nil {
		return *x.Label
	}
	return ""
}

func (x *Features) GetInitialized() bool {
	if x != nil && x.Initialized != nil {
		return *x.Initialized
	}
	return false
}

func (x *Features) GetRevision() []byte {
	if x != nil {
		return x.Revision
	}
	return nil
}

func (x *Features) GetBootloaderHash() []byte {
	if x != nil {
		return x.BootloaderHash
	}
	return nil
}

func (x *Features) GetImported() bool {
	if x != nil && x.Imported != nil {
		return *x.Imported
	}
	return false
}

func (x *Features) GetUnlocked() bool {
	if x != nil && x.Unlocked != nil {
		return *x.Unlocked
	}
	return false
}

// Deprecated: Marked as deprecated in messages-management.proto.
func (x *Features) GetXPassphraseCached() bool {
	if x != nil && x.XPassphraseCached != nil {
		return *x.XPassphraseCached
	}
	return false
}

func (x *Features) GetFirmwarePresent() bool {
	if x != nil && x.FirmwarePresent != nil {
		return *x.FirmwarePresent
	}
	return false
}

func (x *Features) GetNeedsBackup() bool {
	if x != nil && x.NeedsBackup != nil {
		return *x.NeedsBackup
	}
	return false
}

func (x *Features) GetFlags() uint32 {
	if x != nil && x.Flags != nil {
		return *x.Flags
	}
	return 0
}

func (x *Features) GetModel() string {
	if x != nil && x.Model != nil {
		return *x.Model
	}
	return ""
}

func (x *Features) GetFwMajor() uint32 {
	if x != nil && x.FwMajor != nil {
		return *x.FwMajor
	}
	return 0
}

func (x *Features) GetFwMinor() uint32 {
	if x != nil && x.FwMinor != nil {
		return *x.FwMinor
	}
	return 0
}

func (x *Features) GetFwPatch() uint32 {
	if x != nil && x.FwPatch != nil {
		return *x.FwPatch
	}
	return 0
}

func (x *Features) GetFwVendor() string {
	if x != nil && x.FwVendor != nil {
		return *x.FwVendor
	}
	return ""
}

func (x *Features) GetUnfinishedBackup() bool {
	if x != nil && x.UnfinishedBackup != nil {
		return *x.UnfinishedBackup
	}
	return false
}

func (x *Features) GetNoBackup() bool {
	if x != nil && x.NoBackup != nil {
		return *x.NoBackup
	}
	return false
}

func (x *Features) GetRecoveryMode() bool {
	if x != nil && x.RecoveryMode != nil {
		return *x.RecoveryMode
	}
	return false
}

func (x *Features) GetCapabilities() []Features_Capability {
	if x != nil {
		return x.Capabilities
	}
	return nil
}

func (x *Features) GetBackupType() BackupType {
	if x != nil && x.BackupType != nil {
		return *x.BackupType
	}
	return BackupType_Bip39
}

func (x *Features) GetSdCardPresent() bool {
	if x != nil && x.SdCardPresent != nil {
		return *x.SdCardPresent
	}
	return false
}

func (x *Features) GetSdProtection() bool {
	if x != nil && x.SdProtection != nil {
		return *x.SdProtection
	}
	return false
}

func (x *Features) GetWipeCodeProtection() bool {
	if x != nil && x.WipeCodeProtection != nil {
		return *x.WipeCodeProtection
	}
	return false
}

func (x *Features) GetSessionId() []byte {
	if x != nil {
		return x.SessionId
	}
	return nil
}

func (x *Features) GetPassphraseAlwaysOnDevice() bool {
	if x != nil && x.PassphraseAlwaysOnDevice != nil {
		return *x.PassphraseAlwaysOnDevice
	}
	return false
}

func (x *Features) GetSafetyChecks() SafetyCheckLevel {
	if x != nil && x.SafetyChecks != nil {
		return *x.SafetyChecks
	}
	return SafetyCheckLevel_Strict
}

func (x *Features) GetAutoLockDelayMs() uint32 {
	if x != nil && x.AutoLockDelayMs != nil {
		return *x.AutoLockDelayMs
	}
	return 0
}

func (x *Features) GetDisplayRotation() uint32 {
	if x != nil && x.DisplayRotation != nil {
		return *x.DisplayRotation
	}
	return 0
}

func (x *Features) GetExperimentalFeatures() bool {
	if x != nil && x.ExperimentalFeatures != nil {
		return *x.ExperimentalFeatures
	}
	return false
}

func (x *Features) GetBusy() bool {
	if x != nil && x.Busy != nil {
		return *x.Busy
	}
	return false
}

func (x *Features) GetHomescreenFormat() HomescreenFormat {
	if x != nil && x.HomescreenFormat != nil {
		return *x.HomescreenFormat
	}
	return HomescreenFormat_Toif
}

func (x *Features) GetHidePassphraseFromHost() bool {
	if x != nil && x.HidePassphraseFromHost != nil {
		return *x.HidePassphraseFromHost
	}
	return false
}

func (x *Features) GetInternalModel() string {
	if x != nil && x.InternalModel != nil {
		return *x.InternalModel
	}
	return ""
}

func (x *Features) GetUnitColor() uint32 {
	if x != nil && x.UnitColor != nil {
		return *x.UnitColor
	}
	return 0
}

func (x *Features) GetUnitBtconly() bool {
	if x != nil && x.UnitBtconly != nil {
		return *x.UnitBtconly
	}
	return false
}

func (x *Features) GetHomescreenWidth() uint32 {
	if x != nil && x.HomescreenWidth != nil {
		return *x.HomescreenWidth
	}
	return 0
}

func (x *Features) GetHomescreenHeight() uint32 {
	if x != nil && x.HomescreenHeight != nil {
		return *x.HomescreenHeight
	}
	return 0
}

func (x *Features) GetBootloaderLocked() bool {
	if x != nil && x.BootloaderLocked != nil {
		return *x.BootloaderLocked
	}
	return false
}

func (x *Features) GetLanguageVersionMatches() bool {
	if x != nil && x.LanguageVersionMatches != nil {
		return *x.LanguageVersionMatches
	}
	return Default_Features_LanguageVersionMatches
}

// *
// Request: soft-lock the device. Following actions will require PIN. Passphrases remain cached.
// @start
// @next Success
type LockDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LockDevice) Reset() {
	*x = LockDevice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LockDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LockDevice) ProtoMessage() {}

func (x *LockDevice) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LockDevice.ProtoReflect.Descriptor instead.
func (*LockDevice) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{3}
}

// *
// Request: Show a "Do not disconnect" dialog instead of the standard homescreen.
// @start
// @next Success
type SetBusy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ExpiryMs *uint32 `protobuf:"varint,1,opt,name=expiry_ms,json=expiryMs" json:"expiry_ms,omitempty"` // The time in milliseconds after which the dialog will automatically disappear. Overrides any previously set expiry. If not set, then the dialog is hidden.
}

func (x *SetBusy) Reset() {
	*x = SetBusy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetBusy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetBusy) ProtoMessage() {}

func (x *SetBusy) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetBusy.ProtoReflect.Descriptor instead.
func (*SetBusy) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{4}
}

func (x *SetBusy) GetExpiryMs() uint32 {
	if x != nil && x.ExpiryMs != nil {
		return *x.ExpiryMs
	}
	return 0
}

// *
// Request: end the current sesson. Following actions must call Initialize again.
// Cache for the current session is discarded, other sessions remain intact.
// Device is not PIN-locked.
// @start
// @next Success
type EndSession struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *EndSession) Reset() {
	*x = EndSession{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndSession) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndSession) ProtoMessage() {}

func (x *EndSession) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndSession.ProtoReflect.Descriptor instead.
func (*EndSession) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{5}
}

// *
// Request: change some property of the device, e.g. label or homescreen
// @start
// @next Success
// @next Failure
type ApplySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated: Marked as deprecated in messages-management.proto.
	Language      *string `protobuf:"bytes,1,opt,name=language" json:"language,omitempty"`
	Label         *string `protobuf:"bytes,2,opt,name=label" json:"label,omitempty"`
	UsePassphrase *bool   `protobuf:"varint,3,opt,name=use_passphrase,json=usePassphrase" json:"use_passphrase,omitempty"`
	Homescreen    []byte  `protobuf:"bytes,4,opt,name=homescreen" json:"homescreen,omitempty"`
	// Deprecated: Marked as deprecated in messages-management.proto.
	XPassphraseSource        *uint32           `protobuf:"varint,5,opt,name=_passphrase_source,json=PassphraseSource" json:"_passphrase_source,omitempty"` // ASK = 0; DEVICE = 1; HOST = 2;
	AutoLockDelayMs          *uint32           `protobuf:"varint,6,opt,name=auto_lock_delay_ms,json=autoLockDelayMs" json:"auto_lock_delay_ms,omitempty"`
	DisplayRotation          *uint32           `protobuf:"varint,7,opt,name=display_rotation,json=displayRotation" json:"display_rotation,omitempty"`                                            // in degrees from North
	PassphraseAlwaysOnDevice *bool             `protobuf:"varint,8,opt,name=passphrase_always_on_device,json=passphraseAlwaysOnDevice" json:"passphrase_always_on_device,omitempty"`             // do not prompt for passphrase, enforce device entry
	SafetyChecks             *SafetyCheckLevel `protobuf:"varint,9,opt,name=safety_checks,json=safetyChecks,enum=hw.trezor.messages.management.SafetyCheckLevel" json:"safety_checks,omitempty"` // Safety check level, set to Prompt to limit path namespace enforcement
	ExperimentalFeatures     *bool             `protobuf:"varint,10,opt,name=experimental_features,json=experimentalFeatures" json:"experimental_features,omitempty"`                            // enable experimental message types
	HidePassphraseFromHost   *bool             `protobuf:"varint,11,opt,name=hide_passphrase_from_host,json=hidePassphraseFromHost" json:"hide_passphrase_from_host,omitempty"`                  // do not show passphrase coming from host
}

func (x *ApplySettings) Reset() {
	*x = ApplySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplySettings) ProtoMessage() {}

func (x *ApplySettings) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplySettings.ProtoReflect.Descriptor instead.
func (*ApplySettings) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{6}
}

// Deprecated: Marked as deprecated in messages-management.proto.
func (x *ApplySettings) GetLanguage() string {
	if x != nil && x.Language != nil {
		return *x.Language
	}
	return ""
}

func (x *ApplySettings) GetLabel() string {
	if x != nil && x.Label != nil {
		return *x.Label
	}
	return ""
}

func (x *ApplySettings) GetUsePassphrase() bool {
	if x != nil && x.UsePassphrase != nil {
		return *x.UsePassphrase
	}
	return false
}

func (x *ApplySettings) GetHomescreen() []byte {
	if x != nil {
		return x.Homescreen
	}
	return nil
}

// Deprecated: Marked as deprecated in messages-management.proto.
func (x *ApplySettings) GetXPassphraseSource() uint32 {
	if x != nil && x.XPassphraseSource != nil {
		return *x.XPassphraseSource
	}
	return 0
}

func (x *ApplySettings) GetAutoLockDelayMs() uint32 {
	if x != nil && x.AutoLockDelayMs != nil {
		return *x.AutoLockDelayMs
	}
	return 0
}

func (x *ApplySettings) GetDisplayRotation() uint32 {
	if x != nil && x.DisplayRotation != nil {
		return *x.DisplayRotation
	}
	return 0
}

func (x *ApplySettings) GetPassphraseAlwaysOnDevice() bool {
	if x != nil && x.PassphraseAlwaysOnDevice != nil {
		return *x.PassphraseAlwaysOnDevice
	}
	return false
}

func (x *ApplySettings) GetSafetyChecks() SafetyCheckLevel {
	if x != nil && x.SafetyChecks != nil {
		return *x.SafetyChecks
	}
	return SafetyCheckLevel_Strict
}

func (x *ApplySettings) GetExperimentalFeatures() bool {
	if x != nil && x.ExperimentalFeatures != nil {
		return *x.ExperimentalFeatures
	}
	return false
}

func (x *ApplySettings) GetHidePassphraseFromHost() bool {
	if x != nil && x.HidePassphraseFromHost != nil {
		return *x.HidePassphraseFromHost
	}
	return false
}

// *
// Request: change the device language via translation data.
// Does not send the translation data itself, as they are too large for one message.
// Device will request the translation data in chunks.
// @start
// @next TranslationDataRequest
// @next Failure
type ChangeLanguage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// byte length of the whole translation blob (set to 0 for default language - english)
	DataLength *uint32 `protobuf:"varint,1,req,name=data_length,json=dataLength" json:"data_length,omitempty"`
	// Prompt the user on screen.
	// In certain conditions (such as freshly installed device), the confirmation prompt
	// is not mandatory. Setting show_display=false will skip the prompt if that's
	// the case. If the device does not allow skipping the prompt, a request with
	// show_display=false will return a failure. (This way the host can safely try
	// to change the language without invoking a prompt.)
	// Setting show_display to true will always show the prompt.
	// Leaving the option unset will show the prompt only when necessary.
	ShowDisplay *bool `protobuf:"varint,2,opt,name=show_display,json=showDisplay" json:"show_display,omitempty"`
}

func (x *ChangeLanguage) Reset() {
	*x = ChangeLanguage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeLanguage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeLanguage) ProtoMessage() {}

func (x *ChangeLanguage) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeLanguage.ProtoReflect.Descriptor instead.
func (*ChangeLanguage) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{7}
}

func (x *ChangeLanguage) GetDataLength() uint32 {
	if x != nil && x.DataLength != nil {
		return *x.DataLength
	}
	return 0
}

func (x *ChangeLanguage) GetShowDisplay() bool {
	if x != nil && x.ShowDisplay != nil {
		return *x.ShowDisplay
	}
	return false
}

// *
// Response: Device asks for more data from transaction payload.
// @end
// @next TranslationDataAck
type TranslationDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataLength *uint32 `protobuf:"varint,1,req,name=data_length,json=dataLength" json:"data_length,omitempty"` // Number of bytes being requested
	DataOffset *uint32 `protobuf:"varint,2,req,name=data_offset,json=dataOffset" json:"data_offset,omitempty"` // Offset of the first byte being requested
}

func (x *TranslationDataRequest) Reset() {
	*x = TranslationDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslationDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslationDataRequest) ProtoMessage() {}

func (x *TranslationDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslationDataRequest.ProtoReflect.Descriptor instead.
func (*TranslationDataRequest) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{8}
}

func (x *TranslationDataRequest) GetDataLength() uint32 {
	if x != nil && x.DataLength != nil {
		return *x.DataLength
	}
	return 0
}

func (x *TranslationDataRequest) GetDataOffset() uint32 {
	if x != nil && x.DataOffset != nil {
		return *x.DataOffset
	}
	return 0
}

// *
// Request: Translation payload data.
// @next TranslationDataRequest
// @next Success
type TranslationDataAck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataChunk []byte `protobuf:"bytes,1,req,name=data_chunk,json=dataChunk" json:"data_chunk,omitempty"` // Bytes from translation payload
}

func (x *TranslationDataAck) Reset() {
	*x = TranslationDataAck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TranslationDataAck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslationDataAck) ProtoMessage() {}

func (x *TranslationDataAck) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslationDataAck.ProtoReflect.Descriptor instead.
func (*TranslationDataAck) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{9}
}

func (x *TranslationDataAck) GetDataChunk() []byte {
	if x != nil {
		return x.DataChunk
	}
	return nil
}

// *
// Request: set flags of the device
// @start
// @next Success
// @next Failure
type ApplyFlags struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Flags *uint32 `protobuf:"varint,1,req,name=flags" json:"flags,omitempty"` // bitmask, can only set bits, not unset
}

func (x *ApplyFlags) Reset() {
	*x = ApplyFlags{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyFlags) ProtoMessage() {}

func (x *ApplyFlags) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyFlags.ProtoReflect.Descriptor instead.
func (*ApplyFlags) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{10}
}

func (x *ApplyFlags) GetFlags() uint32 {
	if x != nil && x.Flags != nil {
		return *x.Flags
	}
	return 0
}

// *
// Request: Starts workflow for setting/changing/removing the PIN
// @start
// @next Success
// @next Failure
type ChangePin struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Remove *bool `protobuf:"varint,1,opt,name=remove" json:"remove,omitempty"` // is PIN removal requested?
}

func (x *ChangePin) Reset() {
	*x = ChangePin{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangePin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangePin) ProtoMessage() {}

func (x *ChangePin) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangePin.ProtoReflect.Descriptor instead.
func (*ChangePin) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{11}
}

func (x *ChangePin) GetRemove() bool {
	if x != nil && x.Remove != nil {
		return *x.Remove
	}
	return false
}

// *
// Request: Starts workflow for setting/removing the wipe code
// @start
// @next Success
// @next Failure
type ChangeWipeCode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Remove *bool `protobuf:"varint,1,opt,name=remove" json:"remove,omitempty"` // is wipe code removal requested?
}

func (x *ChangeWipeCode) Reset() {
	*x = ChangeWipeCode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeWipeCode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeWipeCode) ProtoMessage() {}

func (x *ChangeWipeCode) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeWipeCode.ProtoReflect.Descriptor instead.
func (*ChangeWipeCode) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{12}
}

func (x *ChangeWipeCode) GetRemove() bool {
	if x != nil && x.Remove != nil {
		return *x.Remove
	}
	return false
}

// *
// Request: Starts workflow for enabling/regenerating/disabling SD card protection
// @start
// @next Success
// @next Failure
type SdProtect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Operation *SdProtect_SdProtectOperationType `protobuf:"varint,1,req,name=operation,enum=hw.trezor.messages.management.SdProtect_SdProtectOperationType" json:"operation,omitempty"`
}

func (x *SdProtect) Reset() {
	*x = SdProtect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SdProtect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SdProtect) ProtoMessage() {}

func (x *SdProtect) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SdProtect.ProtoReflect.Descriptor instead.
func (*SdProtect) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{13}
}

func (x *SdProtect) GetOperation() SdProtect_SdProtectOperationType {
	if x != nil && x.Operation != nil {
		return *x.Operation
	}
	return SdProtect_DISABLE
}

// *
// Request: Test if the device is alive, device sends back the message in Success response
// @start
// @next Success
type Ping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Message          *string `protobuf:"bytes,1,opt,name=message,def=" json:"message,omitempty"`                                       // message to send back in Success message
	ButtonProtection *bool   `protobuf:"varint,2,opt,name=button_protection,json=buttonProtection" json:"button_protection,omitempty"` // ask for button press
}

// Default values for Ping fields.
const (
	Default_Ping_Message = string("")
)

func (x *Ping) Reset() {
	*x = Ping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Ping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Ping) ProtoMessage() {}

func (x *Ping) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Ping.ProtoReflect.Descriptor instead.
func (*Ping) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{14}
}

func (x *Ping) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return Default_Ping_Message
}

func (x *Ping) GetButtonProtection() bool {
	if x != nil && x.ButtonProtection != nil {
		return *x.ButtonProtection
	}
	return false
}

// *
// Request: Abort last operation that required user interaction
// @start
// @next Failure
type Cancel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Cancel) Reset() {
	*x = Cancel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cancel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cancel) ProtoMessage() {}

func (x *Cancel) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cancel.ProtoReflect.Descriptor instead.
func (*Cancel) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{15}
}

// *
// Request: Request a sample of random data generated by hardware RNG. May be used for testing.
// @start
// @next Entropy
// @next Failure
type GetEntropy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Size *uint32 `protobuf:"varint,1,req,name=size" json:"size,omitempty"` // size of requested entropy
}

func (x *GetEntropy) Reset() {
	*x = GetEntropy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntropy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntropy) ProtoMessage() {}

func (x *GetEntropy) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntropy.ProtoReflect.Descriptor instead.
func (*GetEntropy) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{16}
}

func (x *GetEntropy) GetSize() uint32 {
	if x != nil && x.Size != nil {
		return *x.Size
	}
	return 0
}

// *
// Response: Reply with random data generated by internal RNG
// @end
type Entropy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Entropy []byte `protobuf:"bytes,1,req,name=entropy" json:"entropy,omitempty"` // chunk of random generated bytes
}

func (x *Entropy) Reset() {
	*x = Entropy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entropy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entropy) ProtoMessage() {}

func (x *Entropy) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entropy.ProtoReflect.Descriptor instead.
func (*Entropy) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{17}
}

func (x *Entropy) GetEntropy() []byte {
	if x != nil {
		return x.Entropy
	}
	return nil
}

// *
// Request: Get a hash of the installed firmware combined with an optional challenge.
// @start
// @next FirmwareHash
// @next Failure
type GetFirmwareHash struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Challenge []byte `protobuf:"bytes,1,opt,name=challenge" json:"challenge,omitempty"` // Blake2s key up to 32 bytes in length.
}

func (x *GetFirmwareHash) Reset() {
	*x = GetFirmwareHash{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFirmwareHash) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFirmwareHash) ProtoMessage() {}

func (x *GetFirmwareHash) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFirmwareHash.ProtoReflect.Descriptor instead.
func (*GetFirmwareHash) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{18}
}

func (x *GetFirmwareHash) GetChallenge() []byte {
	if x != nil {
		return x.Challenge
	}
	return nil
}

// *
// Response: Hash of the installed firmware combined with the optional challenge.
// @end
type FirmwareHash struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Hash []byte `protobuf:"bytes,1,req,name=hash" json:"hash,omitempty"`
}

func (x *FirmwareHash) Reset() {
	*x = FirmwareHash{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirmwareHash) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirmwareHash) ProtoMessage() {}

func (x *FirmwareHash) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirmwareHash.ProtoReflect.Descriptor instead.
func (*FirmwareHash) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{19}
}

func (x *FirmwareHash) GetHash() []byte {
	if x != nil {
		return x.Hash
	}
	return nil
}

// *
// Request: Request a signature of the provided challenge.
// @start
// @next AuthenticityProof
// @next Failure
type AuthenticateDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Challenge []byte `protobuf:"bytes,1,req,name=challenge" json:"challenge,omitempty"` // A random challenge to sign.
}

func (x *AuthenticateDevice) Reset() {
	*x = AuthenticateDevice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthenticateDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticateDevice) ProtoMessage() {}

func (x *AuthenticateDevice) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticateDevice.ProtoReflect.Descriptor instead.
func (*AuthenticateDevice) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{20}
}

func (x *AuthenticateDevice) GetChallenge() []byte {
	if x != nil {
		return x.Challenge
	}
	return nil
}

// *
// Response: Signature of the provided challenge along with a certificate issued by the Trezor company.
// @end
type AuthenticityProof struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Certificates [][]byte `protobuf:"bytes,1,rep,name=certificates" json:"certificates,omitempty"` // A certificate chain starting with the device certificate, followed by intermediate CA certificates, the last of which is signed by Trezor company's root CA.
	Signature    []byte   `protobuf:"bytes,2,req,name=signature" json:"signature,omitempty"`       // A DER-encoded signature of "\0x13AuthenticateDevice:" + length-prefixed challenge that should be verified using the device certificate.
}

func (x *AuthenticityProof) Reset() {
	*x = AuthenticityProof{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthenticityProof) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticityProof) ProtoMessage() {}

func (x *AuthenticityProof) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticityProof.ProtoReflect.Descriptor instead.
func (*AuthenticityProof) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{21}
}

func (x *AuthenticityProof) GetCertificates() [][]byte {
	if x != nil {
		return x.Certificates
	}
	return nil
}

func (x *AuthenticityProof) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

// *
// Request: Request device to wipe all sensitive data and settings
// @start
// @next Success
// @next Failure
type WipeDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WipeDevice) Reset() {
	*x = WipeDevice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WipeDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WipeDevice) ProtoMessage() {}

func (x *WipeDevice) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WipeDevice.ProtoReflect.Descriptor instead.
func (*WipeDevice) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{22}
}

// *
// Request: Load seed and related internal settings from the computer
// @start
// @next Success
// @next Failure
type LoadDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mnemonics            []string `protobuf:"bytes,1,rep,name=mnemonics" json:"mnemonics,omitempty"`                                                    // seed encoded as mnemonic (12, 18 or 24 words for BIP39, 20 or 33 for SLIP39)
	Pin                  *string  `protobuf:"bytes,3,opt,name=pin" json:"pin,omitempty"`                                                                // set PIN protection
	PassphraseProtection *bool    `protobuf:"varint,4,opt,name=passphrase_protection,json=passphraseProtection" json:"passphrase_protection,omitempty"` // enable master node encryption using passphrase
	// Deprecated: Marked as deprecated in messages-management.proto.
	Language     *string `protobuf:"bytes,5,opt,name=language" json:"language,omitempty"`                              // deprecated (use ChangeLanguage)
	Label        *string `protobuf:"bytes,6,opt,name=label" json:"label,omitempty"`                                    // device label
	SkipChecksum *bool   `protobuf:"varint,7,opt,name=skip_checksum,json=skipChecksum" json:"skip_checksum,omitempty"` // do not test mnemonic for valid BIP-39 checksum
	U2FCounter   *uint32 `protobuf:"varint,8,opt,name=u2f_counter,json=u2fCounter" json:"u2f_counter,omitempty"`       // U2F counter
	NeedsBackup  *bool   `protobuf:"varint,9,opt,name=needs_backup,json=needsBackup" json:"needs_backup,omitempty"`    // set "needs backup" flag
	NoBackup     *bool   `protobuf:"varint,10,opt,name=no_backup,json=noBackup" json:"no_backup,omitempty"`            // indicate that no backup is going to be made
}

func (x *LoadDevice) Reset() {
	*x = LoadDevice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadDevice) ProtoMessage() {}

func (x *LoadDevice) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadDevice.ProtoReflect.Descriptor instead.
func (*LoadDevice) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{23}
}

func (x *LoadDevice) GetMnemonics() []string {
	if x != nil {
		return x.Mnemonics
	}
	return nil
}

func (x *LoadDevice) GetPin() string {
	if x != nil && x.Pin != nil {
		return *x.Pin
	}
	return ""
}

func (x *LoadDevice) GetPassphraseProtection() bool {
	if x != nil && x.PassphraseProtection != nil {
		return *x.PassphraseProtection
	}
	return false
}

// Deprecated: Marked as deprecated in messages-management.proto.
func (x *LoadDevice) GetLanguage() string {
	if x != nil && x.Language != nil {
		return *x.Language
	}
	return ""
}

func (x *LoadDevice) GetLabel() string {
	if x != nil && x.Label != nil {
		return *x.Label
	}
	return ""
}

func (x *LoadDevice) GetSkipChecksum() bool {
	if x != nil && x.SkipChecksum != nil {
		return *x.SkipChecksum
	}
	return false
}

func (x *LoadDevice) GetU2FCounter() uint32 {
	if x != nil && x.U2FCounter != nil {
		return *x.U2FCounter
	}
	return 0
}

func (x *LoadDevice) GetNeedsBackup() bool {
	if x != nil && x.NeedsBackup != nil {
		return *x.NeedsBackup
	}
	return false
}

func (x *LoadDevice) GetNoBackup() bool {
	if x != nil && x.NoBackup != nil {
		return *x.NoBackup
	}
	return false
}

// *
// Request: Ask device to do initialization involving user interaction
// @start
// @next EntropyRequest
// @next Failure
type ResetDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DisplayRandom        *bool   `protobuf:"varint,1,opt,name=display_random,json=displayRandom" json:"display_random,omitempty"`                      // display entropy generated by the device before asking for additional entropy
	Strength             *uint32 `protobuf:"varint,2,opt,name=strength,def=256" json:"strength,omitempty"`                                             // strength of seed in bits
	PassphraseProtection *bool   `protobuf:"varint,3,opt,name=passphrase_protection,json=passphraseProtection" json:"passphrase_protection,omitempty"` // enable master node encryption using passphrase
	PinProtection        *bool   `protobuf:"varint,4,opt,name=pin_protection,json=pinProtection" json:"pin_protection,omitempty"`                      // enable PIN protection
	// Deprecated: Marked as deprecated in messages-management.proto.
	Language   *string     `protobuf:"bytes,5,opt,name=language" json:"language,omitempty"`                                                                             // deprecated (use ChangeLanguage)
	Label      *string     `protobuf:"bytes,6,opt,name=label" json:"label,omitempty"`                                                                                   // device label
	U2FCounter *uint32     `protobuf:"varint,7,opt,name=u2f_counter,json=u2fCounter" json:"u2f_counter,omitempty"`                                                      // U2F counter
	SkipBackup *bool       `protobuf:"varint,8,opt,name=skip_backup,json=skipBackup" json:"skip_backup,omitempty"`                                                      // postpone seed backup to BackupDevice workflow
	NoBackup   *bool       `protobuf:"varint,9,opt,name=no_backup,json=noBackup" json:"no_backup,omitempty"`                                                            // indicate that no backup is going to be made
	BackupType *BackupType `protobuf:"varint,10,opt,name=backup_type,json=backupType,enum=hw.trezor.messages.management.BackupType,def=0" json:"backup_type,omitempty"` // type of the mnemonic backup
}

// Default values for ResetDevice fields.
const (
	Default_ResetDevice_Strength   = uint32(256)
	Default_ResetDevice_BackupType = BackupType_Bip39
)

func (x *ResetDevice) Reset() {
	*x = ResetDevice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetDevice) ProtoMessage() {}

func (x *ResetDevice) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetDevice.ProtoReflect.Descriptor instead.
func (*ResetDevice) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{24}
}

func (x *ResetDevice) GetDisplayRandom() bool {
	if x != nil && x.DisplayRandom != nil {
		return *x.DisplayRandom
	}
	return false
}

func (x *ResetDevice) GetStrength() uint32 {
	if x != nil && x.Strength != nil {
		return *x.Strength
	}
	return Default_ResetDevice_Strength
}

func (x *ResetDevice) GetPassphraseProtection() bool {
	if x != nil && x.PassphraseProtection != nil {
		return *x.PassphraseProtection
	}
	return false
}

func (x *ResetDevice) GetPinProtection() bool {
	if x != nil && x.PinProtection != nil {
		return *x.PinProtection
	}
	return false
}

// Deprecated: Marked as deprecated in messages-management.proto.
func (x *ResetDevice) GetLanguage() string {
	if x != nil && x.Language != nil {
		return *x.Language
	}
	return ""
}

func (x *ResetDevice) GetLabel() string {
	if x != nil && x.Label != nil {
		return *x.Label
	}
	return ""
}

func (x *ResetDevice) GetU2FCounter() uint32 {
	if x != nil && x.U2FCounter != nil {
		return *x.U2FCounter
	}
	return 0
}

func (x *ResetDevice) GetSkipBackup() bool {
	if x != nil && x.SkipBackup != nil {
		return *x.SkipBackup
	}
	return false
}

func (x *ResetDevice) GetNoBackup() bool {
	if x != nil && x.NoBackup != nil {
		return *x.NoBackup
	}
	return false
}

func (x *ResetDevice) GetBackupType() BackupType {
	if x != nil && x.BackupType != nil {
		return *x.BackupType
	}
	return Default_ResetDevice_BackupType
}

// *
// Request: Perform backup of the device seed if not backed up using ResetDevice
// @start
// @next Success
type BackupDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BackupDevice) Reset() {
	*x = BackupDevice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupDevice) ProtoMessage() {}

func (x *BackupDevice) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupDevice.ProtoReflect.Descriptor instead.
func (*BackupDevice) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{25}
}

// *
// Response: Ask for additional entropy from host computer
// @next EntropyAck
type EntropyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *EntropyRequest) Reset() {
	*x = EntropyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntropyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntropyRequest) ProtoMessage() {}

func (x *EntropyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntropyRequest.ProtoReflect.Descriptor instead.
func (*EntropyRequest) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{26}
}

// *
// Request: Provide additional entropy for seed generation function
// @next Success
type EntropyAck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Entropy []byte `protobuf:"bytes,1,req,name=entropy" json:"entropy,omitempty"` // 256 bits (32 bytes) of random data
}

func (x *EntropyAck) Reset() {
	*x = EntropyAck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntropyAck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntropyAck) ProtoMessage() {}

func (x *EntropyAck) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntropyAck.ProtoReflect.Descriptor instead.
func (*EntropyAck) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{27}
}

func (x *EntropyAck) GetEntropy() []byte {
	if x != nil {
		return x.Entropy
	}
	return nil
}

// *
// Request: Start recovery workflow asking user for specific words of mnemonic
// Used to recovery device safely even on untrusted computer.
// @start
// @next WordRequest
type RecoveryDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	WordCount            *uint32 `protobuf:"varint,1,opt,name=word_count,json=wordCount" json:"word_count,omitempty"`                                  // number of words in BIP-39 mnemonic
	PassphraseProtection *bool   `protobuf:"varint,2,opt,name=passphrase_protection,json=passphraseProtection" json:"passphrase_protection,omitempty"` // enable master node encryption using passphrase
	PinProtection        *bool   `protobuf:"varint,3,opt,name=pin_protection,json=pinProtection" json:"pin_protection,omitempty"`                      // enable PIN protection
	// Deprecated: Marked as deprecated in messages-management.proto.
	Language        *string `protobuf:"bytes,4,opt,name=language" json:"language,omitempty"`                                       // deprecated (use ChangeLanguage)
	Label           *string `protobuf:"bytes,5,opt,name=label" json:"label,omitempty"`                                             // device label
	EnforceWordlist *bool   `protobuf:"varint,6,opt,name=enforce_wordlist,json=enforceWordlist" json:"enforce_wordlist,omitempty"` // enforce BIP-39 wordlist during the process
	// 7 reserved for unused recovery method
	Type       *RecoveryDevice_RecoveryDeviceType `protobuf:"varint,8,opt,name=type,enum=hw.trezor.messages.management.RecoveryDevice_RecoveryDeviceType" json:"type,omitempty"` // supported recovery type
	U2FCounter *uint32                            `protobuf:"varint,9,opt,name=u2f_counter,json=u2fCounter" json:"u2f_counter,omitempty"`                                        // U2F counter
	DryRun     *bool                              `protobuf:"varint,10,opt,name=dry_run,json=dryRun" json:"dry_run,omitempty"`                                                   // perform dry-run recovery workflow (for safe mnemonic validation)
}

func (x *RecoveryDevice) Reset() {
	*x = RecoveryDevice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecoveryDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecoveryDevice) ProtoMessage() {}

func (x *RecoveryDevice) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecoveryDevice.ProtoReflect.Descriptor instead.
func (*RecoveryDevice) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{28}
}

func (x *RecoveryDevice) GetWordCount() uint32 {
	if x != nil && x.WordCount != nil {
		return *x.WordCount
	}
	return 0
}

func (x *RecoveryDevice) GetPassphraseProtection() bool {
	if x != nil && x.PassphraseProtection != nil {
		return *x.PassphraseProtection
	}
	return false
}

func (x *RecoveryDevice) GetPinProtection() bool {
	if x != nil && x.PinProtection != nil {
		return *x.PinProtection
	}
	return false
}

// Deprecated: Marked as deprecated in messages-management.proto.
func (x *RecoveryDevice) GetLanguage() string {
	if x != nil && x.Language != nil {
		return *x.Language
	}
	return ""
}

func (x *RecoveryDevice) GetLabel() string {
	if x != nil && x.Label != nil {
		return *x.Label
	}
	return ""
}

func (x *RecoveryDevice) GetEnforceWordlist() bool {
	if x != nil && x.EnforceWordlist != nil {
		return *x.EnforceWordlist
	}
	return false
}

func (x *RecoveryDevice) GetType() RecoveryDevice_RecoveryDeviceType {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return RecoveryDevice_RecoveryDeviceType_ScrambledWords
}

func (x *RecoveryDevice) GetU2FCounter() uint32 {
	if x != nil && x.U2FCounter != nil {
		return *x.U2FCounter
	}
	return 0
}

func (x *RecoveryDevice) GetDryRun() bool {
	if x != nil && x.DryRun != nil {
		return *x.DryRun
	}
	return false
}

// *
// Response: Device is waiting for user to enter word of the mnemonic
// Its position is shown only on device's internal display.
// @next WordAck
type WordRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type *WordRequest_WordRequestType `protobuf:"varint,1,req,name=type,enum=hw.trezor.messages.management.WordRequest_WordRequestType" json:"type,omitempty"`
}

func (x *WordRequest) Reset() {
	*x = WordRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WordRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WordRequest) ProtoMessage() {}

func (x *WordRequest) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WordRequest.ProtoReflect.Descriptor instead.
func (*WordRequest) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{29}
}

func (x *WordRequest) GetType() WordRequest_WordRequestType {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return WordRequest_WordRequestType_Plain
}

// *
// Request: Computer replies with word from the mnemonic
// @next WordRequest
// @next Success
// @next Failure
type WordAck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Word *string `protobuf:"bytes,1,req,name=word" json:"word,omitempty"` // one word of mnemonic on asked position
}

func (x *WordAck) Reset() {
	*x = WordAck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WordAck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WordAck) ProtoMessage() {}

func (x *WordAck) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WordAck.ProtoReflect.Descriptor instead.
func (*WordAck) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{30}
}

func (x *WordAck) GetWord() string {
	if x != nil && x.Word != nil {
		return *x.Word
	}
	return ""
}

// *
// Request: Set U2F counter
// @start
// @next Success
type SetU2FCounter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	U2FCounter *uint32 `protobuf:"varint,1,req,name=u2f_counter,json=u2fCounter" json:"u2f_counter,omitempty"`
}

func (x *SetU2FCounter) Reset() {
	*x = SetU2FCounter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetU2FCounter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetU2FCounter) ProtoMessage() {}

func (x *SetU2FCounter) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetU2FCounter.ProtoReflect.Descriptor instead.
func (*SetU2FCounter) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{31}
}

func (x *SetU2FCounter) GetU2FCounter() uint32 {
	if x != nil && x.U2FCounter != nil {
		return *x.U2FCounter
	}
	return 0
}

// *
// Request: Set U2F counter
// @start
// @next NextU2FCounter
type GetNextU2FCounter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetNextU2FCounter) Reset() {
	*x = GetNextU2FCounter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNextU2FCounter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNextU2FCounter) ProtoMessage() {}

func (x *GetNextU2FCounter) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNextU2FCounter.ProtoReflect.Descriptor instead.
func (*GetNextU2FCounter) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{32}
}

// *
// Request: Set U2F counter
// @end
type NextU2FCounter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	U2FCounter *uint32 `protobuf:"varint,1,req,name=u2f_counter,json=u2fCounter" json:"u2f_counter,omitempty"`
}

func (x *NextU2FCounter) Reset() {
	*x = NextU2FCounter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NextU2FCounter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NextU2FCounter) ProtoMessage() {}

func (x *NextU2FCounter) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NextU2FCounter.ProtoReflect.Descriptor instead.
func (*NextU2FCounter) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{33}
}

func (x *NextU2FCounter) GetU2FCounter() uint32 {
	if x != nil && x.U2FCounter != nil {
		return *x.U2FCounter
	}
	return 0
}

// *
// Request: Ask device to prepare for a preauthorized operation.
// @start
// @next PreauthorizedRequest
// @next Failure
type DoPreauthorized struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DoPreauthorized) Reset() {
	*x = DoPreauthorized{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoPreauthorized) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoPreauthorized) ProtoMessage() {}

func (x *DoPreauthorized) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoPreauthorized.ProtoReflect.Descriptor instead.
func (*DoPreauthorized) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{34}
}

// *
// Request: Device awaits a preauthorized operation.
// @start
// @next SignTx
// @next GetOwnershipProof
type PreauthorizedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PreauthorizedRequest) Reset() {
	*x = PreauthorizedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreauthorizedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreauthorizedRequest) ProtoMessage() {}

func (x *PreauthorizedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreauthorizedRequest.ProtoReflect.Descriptor instead.
func (*PreauthorizedRequest) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{35}
}

// *
// Request: Cancel any outstanding authorization in the current session.
// @start
// @next Success
// @next Failure
type CancelAuthorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CancelAuthorization) Reset() {
	*x = CancelAuthorization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelAuthorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelAuthorization) ProtoMessage() {}

func (x *CancelAuthorization) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelAuthorization.ProtoReflect.Descriptor instead.
func (*CancelAuthorization) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{36}
}

// *
// Request: Reboot firmware to bootloader
// @start
// @next Success
type RebootToBootloader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Action to be performed after rebooting to bootloader
	BootCommand *RebootToBootloader_BootCommand `protobuf:"varint,1,opt,name=boot_command,json=bootCommand,enum=hw.trezor.messages.management.RebootToBootloader_BootCommand,def=0" json:"boot_command,omitempty"`
	// Firmware header to be flashed after rebooting to bootloader
	FirmwareHeader []byte `protobuf:"bytes,2,opt,name=firmware_header,json=firmwareHeader" json:"firmware_header,omitempty"`
	// Length of language blob to be installed before upgrading firmware
	LanguageDataLength *uint32 `protobuf:"varint,3,opt,name=language_data_length,json=languageDataLength,def=0" json:"language_data_length,omitempty"`
}

// Default values for RebootToBootloader fields.
const (
	Default_RebootToBootloader_BootCommand        = RebootToBootloader_STOP_AND_WAIT
	Default_RebootToBootloader_LanguageDataLength = uint32(0)
)

func (x *RebootToBootloader) Reset() {
	*x = RebootToBootloader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RebootToBootloader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RebootToBootloader) ProtoMessage() {}

func (x *RebootToBootloader) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RebootToBootloader.ProtoReflect.Descriptor instead.
func (*RebootToBootloader) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{37}
}

func (x *RebootToBootloader) GetBootCommand() RebootToBootloader_BootCommand {
	if x != nil && x.BootCommand != nil {
		return *x.BootCommand
	}
	return Default_RebootToBootloader_BootCommand
}

func (x *RebootToBootloader) GetFirmwareHeader() []byte {
	if x != nil {
		return x.FirmwareHeader
	}
	return nil
}

func (x *RebootToBootloader) GetLanguageDataLength() uint32 {
	if x != nil && x.LanguageDataLength != nil {
		return *x.LanguageDataLength
	}
	return Default_RebootToBootloader_LanguageDataLength
}

// *
// Request: Ask device to generate a random nonce and store it in the session's cache
// @start
// @next Nonce
type GetNonce struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetNonce) Reset() {
	*x = GetNonce{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNonce) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNonce) ProtoMessage() {}

func (x *GetNonce) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNonce.ProtoReflect.Descriptor instead.
func (*GetNonce) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{38}
}

// *
// Response: Contains a random nonce
// @end
type Nonce struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Nonce []byte `protobuf:"bytes,1,req,name=nonce" json:"nonce,omitempty"` // a 32-byte random value generated by Trezor
}

func (x *Nonce) Reset() {
	*x = Nonce{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Nonce) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Nonce) ProtoMessage() {}

func (x *Nonce) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Nonce.ProtoReflect.Descriptor instead.
func (*Nonce) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{39}
}

func (x *Nonce) GetNonce() []byte {
	if x != nil {
		return x.Nonce
	}
	return nil
}

// *
// Request: Ask device to unlock a subtree of the keychain.
// @start
// @next UnlockedPathRequest
// @next Failure
type UnlockPath struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AddressN []uint32 `protobuf:"varint,1,rep,name=address_n,json=addressN" json:"address_n,omitempty"` // prefix of the BIP-32 path leading to the account (m / purpose')
	Mac      []byte   `protobuf:"bytes,2,opt,name=mac" json:"mac,omitempty"`                            // the MAC returned by UnlockedPathRequest
}

func (x *UnlockPath) Reset() {
	*x = UnlockPath{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnlockPath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnlockPath) ProtoMessage() {}

func (x *UnlockPath) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnlockPath.ProtoReflect.Descriptor instead.
func (*UnlockPath) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{40}
}

func (x *UnlockPath) GetAddressN() []uint32 {
	if x != nil {
		return x.AddressN
	}
	return nil
}

func (x *UnlockPath) GetMac() []byte {
	if x != nil {
		return x.Mac
	}
	return nil
}

// *
// Request: Device awaits an operation.
// @start
// @next SignTx
// @next GetPublicKey
// @next GetAddress
type UnlockedPathRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mac []byte `protobuf:"bytes,1,opt,name=mac" json:"mac,omitempty"` // authentication code for future UnlockPath calls
}

func (x *UnlockedPathRequest) Reset() {
	*x = UnlockedPathRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnlockedPathRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnlockedPathRequest) ProtoMessage() {}

func (x *UnlockedPathRequest) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnlockedPathRequest.ProtoReflect.Descriptor instead.
func (*UnlockedPathRequest) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{41}
}

func (x *UnlockedPathRequest) GetMac() []byte {
	if x != nil {
		return x.Mac
	}
	return nil
}

// *
// Request: Show tutorial screens on the device
// @start
// @next Success
type ShowDeviceTutorial struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ShowDeviceTutorial) Reset() {
	*x = ShowDeviceTutorial{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShowDeviceTutorial) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShowDeviceTutorial) ProtoMessage() {}

func (x *ShowDeviceTutorial) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShowDeviceTutorial.ProtoReflect.Descriptor instead.
func (*ShowDeviceTutorial) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{42}
}

// *
// Request: Unlocks bootloader, !irreversible!
// @start
// @next Success
// @next Failure
type UnlockBootloader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UnlockBootloader) Reset() {
	*x = UnlockBootloader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_messages_management_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnlockBootloader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnlockBootloader) ProtoMessage() {}

func (x *UnlockBootloader) ProtoReflect() protoreflect.Message {
	mi := &file_messages_management_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnlockBootloader.ProtoReflect.Descriptor instead.
func (*UnlockBootloader) Descriptor() ([]byte, []int) {
	return file_messages_management_proto_rawDescGZIP(), []int{43}
}

var File_messages_management_proto protoreflect.FileDescriptor

var file_messages_management_proto_rawDesc = []byte{
	0x0a, 0x19, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2d, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x68, 0x77, 0x2e,
	0x74, 0x72, 0x65, 0x7a, 0x6f, 0x72, 0x2e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x0e, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x80, 0x01, 0x0a, 0x0a, 0x49,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x10, 0x5f, 0x73, 0x6b, 0x69,
	0x70, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x53, 0x6b, 0x69, 0x70, 0x50, 0x61, 0x73, 0x73,
	0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x65, 0x72, 0x69, 0x76, 0x65,
	0x5f, 0x63, 0x61, 0x72, 0x64, 0x61, 0x6e, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d,
	0x64, 0x65, 0x72, 0x69, 0x76, 0x65, 0x43, 0x61, 0x72, 0x64, 0x61, 0x6e, 0x6f, 0x22, 0x0d, 0x0a,
	0x0b, 0x47, 0x65, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22, 0xd3, 0x13, 0x0a,
	0x08, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x65, 0x6e,
	0x64, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x65, 0x6e, 0x64, 0x6f,
	0x72, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0c, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0c, 0x6d,
	0x69, 0x6e, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x70,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x02,
	0x28, 0x0d, 0x52, 0x0c, 0x70, 0x61, 0x74, 0x63, 0x68, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x27, 0x0a, 0x0f, 0x62, 0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x62, 0x6f, 0x6f, 0x74, 0x6c,
	0x6f, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x69, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d,
	0x70, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a,
	0x15, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x70, 0x61,
	0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x12, 0x20, 0x0a, 0x0b, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x62, 0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72,
	0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x62, 0x6f, 0x6f,
	0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x48, 0x61, 0x73, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x6e, 0x6c, 0x6f, 0x63,
	0x6b, 0x65, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x75, 0x6e, 0x6c, 0x6f, 0x63,
	0x6b, 0x65, 0x64, 0x12, 0x30, 0x0a, 0x12, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x10, 0x50, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
	0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x65, 0x65, 0x64, 0x73, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x6e, 0x65, 0x65, 0x64, 0x73, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x19, 0x0a, 0x08, 0x66, 0x77, 0x5f, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x18, 0x16, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x07, 0x66, 0x77, 0x4d, 0x61, 0x6a, 0x6f, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x66, 0x77,
	0x5f, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x66, 0x77,
	0x4d, 0x69, 0x6e, 0x6f, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x66, 0x77, 0x5f, 0x70, 0x61, 0x74, 0x63,
	0x68, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x66, 0x77, 0x50, 0x61, 0x74, 0x63, 0x68,
	0x12, 0x1b, 0x0a, 0x09, 0x66, 0x77, 0x5f, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x18, 0x19, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x77, 0x56, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x12, 0x2b, 0x0a,
	0x11, 0x75, 0x6e, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x75, 0x6e, 0x66, 0x69, 0x6e, 0x69,
	0x73, 0x68, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x6f,
	0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e,
	0x6f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x56, 0x0a, 0x0c,
	0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x1e, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x32, 0x2e, 0x68, 0x77, 0x2e, 0x74, 0x72, 0x65, 0x7a, 0x6f, 0x72, 0x2e, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x68, 0x77, 0x2e, 0x74,
	0x72, 0x65, 0x7a, 0x6f, 0x72, 0x2e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x26, 0x0a, 0x0f, 0x73, 0x64, 0x5f, 0x63, 0x61, 0x72, 0x64, 0x5f, 0x70, 0x72, 0x65, 0x73,
	0x65, 0x6e, 0x74, 0x18, 0x20, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x73, 0x64, 0x43, 0x61, 0x72,
	0x64, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x64, 0x5f, 0x70,
	0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x21, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x73, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a,
	0x14, 0x77, 0x69, 0x70, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x22, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x77, 0x69, 0x70,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x23, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x3d,
	0x0a, 0x1b, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x61, 0x6c, 0x77,
	0x61, 0x79, 0x73, 0x5f, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x24, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x18, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x41,
	0x6c, 0x77, 0x61, 0x79, 0x73, 0x4f, 0x6e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x54, 0x0a,
	0x0d, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x18, 0x25,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x68, 0x77, 0x2e, 0x74, 0x72, 0x65, 0x7a, 0x6f, 0x72,
	0x2e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0c, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x73, 0x12, 0x2b, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x6c, 0x6f, 0x63, 0x6b,
	0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x6d, 0x73, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0f, 0x61, 0x75, 0x74, 0x6f, 0x4c, 0x6f, 0x63, 0x6b, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x4d, 0x73,
	0x12, 0x29, 0x0a, 0x10, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x72, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x15, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x18, 0x28, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x12, 0x12, 0x0a, 0x04, 0x62, 0x75, 0x73, 0x79, 0x18, 0x29, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04,
	0x62, 0x75, 0x73, 0x79, 0x12, 0x5c, 0x0a, 0x11, 0x68, 0x6f, 0x6d, 0x65, 0x73, 0x63, 0x72, 0x65,
	0x65, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2f, 0x2e, 0x68, 0x77, 0x2e, 0x74, 0x72, 0x65, 0x7a, 0x6f, 0x72, 0x2e, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x48, 0x6f, 0x6d, 0x65, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x52, 0x10, 0x68, 0x6f, 0x6d, 0x65, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x12, 0x39, 0x0a, 0x19, 0x68, 0x69, 0x64, 0x65, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x18,
	0x2b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x68, 0x69, 0x64, 0x65, 0x50, 0x61, 0x73, 0x73, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x25, 0x0a,
	0x0e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18,
	0x2c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x6c,
	0x6f, 0x72, 0x18, 0x2d, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x75, 0x6e, 0x69, 0x74, 0x43, 0x6f,
	0x6c, 0x6f, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x62, 0x74, 0x63, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x75, 0x6e, 0x69, 0x74, 0x42,
	0x74, 0x63, 0x6f, 0x6e, 0x6c, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x68, 0x6f, 0x6d, 0x65, 0x73, 0x63,
	0x72, 0x65, 0x65, 0x6e, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0f, 0x68, 0x6f, 0x6d, 0x65, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x57, 0x69, 0x64, 0x74,
	0x68, 0x12, 0x2b, 0x0a, 0x11, 0x68, 0x6f, 0x6d, 0x65, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x5f,
	0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x30, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x10, 0x68, 0x6f,
	0x6d, 0x65, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x2b,
	0x0a, 0x11, 0x62, 0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x63,
	0x6b, 0x65, 0x64, 0x18, 0x31, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x62, 0x6f, 0x6f, 0x74, 0x6c,
	0x6f, 0x61, 0x64, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x12, 0x3e, 0x0a, 0x18, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x32, 0x20, 0x01, 0x28, 0x08, 0x3a, 0x04, 0x74,
	0x72, 0x75, 0x65, 0x52, 0x16, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x22, 0x84, 0x04, 0x0a, 0x0a,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1c, 0x0a, 0x12, 0x43, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x42, 0x69, 0x74, 0x63, 0x6f, 0x69, 0x6e,
	0x10, 0x01, 0x1a, 0x04, 0x80, 0xa6, 0x1d, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x42, 0x69, 0x74, 0x63, 0x6f, 0x69, 0x6e, 0x5f, 0x6c,
	0x69, 0x6b, 0x65, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x42, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x10, 0x03, 0x12, 0x16, 0x0a,
	0x12, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x43, 0x61, 0x72, 0x64,
	0x61, 0x6e, 0x6f, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x11, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x10, 0x05, 0x1a, 0x04, 0x80, 0xa6,
	0x1d, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x5f, 0x45, 0x4f, 0x53, 0x10, 0x06, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x5f, 0x45, 0x74, 0x68, 0x65, 0x72, 0x65, 0x75, 0x6d, 0x10, 0x07, 0x12,
	0x17, 0x0a, 0x0f, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x4c, 0x69,
	0x73, 0x6b, 0x10, 0x08, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x4d, 0x6f, 0x6e, 0x65, 0x72, 0x6f, 0x10, 0x09, 0x12,
	0x12, 0x0a, 0x0e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x4e, 0x45,
	0x4d, 0x10, 0x0a, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x5f, 0x52, 0x69, 0x70, 0x70, 0x6c, 0x65, 0x10, 0x0b, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x53, 0x74, 0x65, 0x6c, 0x6c, 0x61, 0x72,
	0x10, 0x0c, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x5f, 0x54, 0x65, 0x7a, 0x6f, 0x73, 0x10, 0x0d, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x55, 0x32, 0x46, 0x10, 0x0e, 0x12, 0x1b, 0x0a, 0x11,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x53, 0x68, 0x61, 0x6d, 0x69,
	0x72, 0x10, 0x0f, 0x1a, 0x04, 0x80, 0xa6, 0x1d, 0x01, 0x12, 0x21, 0x0a, 0x17, 0x43, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x53, 0x68, 0x61, 0x6d, 0x69, 0x72, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x10, 0x10, 0x1a, 0x04, 0x80, 0xa6, 0x1d, 0x01, 0x12, 0x24, 0x0a, 0x1a,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x50, 0x61, 0x73, 0x73, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x10, 0x11, 0x1a, 0x04, 0x80, 0xa6,
	0x1d, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x5f, 0x53, 0x6f, 0x6c, 0x61, 0x6e, 0x61, 0x10, 0x12, 0x12, 0x21, 0x0a, 0x17, 0x43, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x10, 0x13, 0x1a, 0x04, 0x80, 0xa6, 0x1d, 0x01, 0x1a, 0x04, 0xc8, 0xf3,
	0x18, 0x01, 0x22, 0x0c, 0x0a, 0x0a, 0x4c, 0x6f, 0x63, 0x6b, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x22, 0x26, 0x0a, 0x07, 0x53, 0x65, 0x74, 0x42, 0x75, 0x73, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x79, 0x5f, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x79, 0x4d, 0x73, 0x22, 0x0c, 0x0a, 0x0a, 0x45, 0x6e, 0x64, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x04, 0x0a, 0x0d, 0x41, 0x70, 0x70, 0x6c, 0x79,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1e, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x25,
	0x0a, 0x0e, 0x75, 0x73, 0x65, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x75, 0x73, 0x65, 0x50, 0x61, 0x73, 0x73, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x68, 0x6f, 0x6d, 0x65, 0x73, 0x63, 0x72,
	0x65, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x68, 0x6f, 0x6d, 0x65, 0x73,
	0x63, 0x72, 0x65, 0x65, 0x6e, 0x12, 0x30, 0x0a, 0x12, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0d, 0x42, 0x02, 0x18, 0x01, 0x52, 0x10, 0x50, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2b, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x5f,
	0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x6d, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x0f, 0x61, 0x75, 0x74, 0x6f, 0x4c, 0x6f, 0x63, 0x6b, 0x44, 0x65, 0x6c,
	0x61, 0x79, 0x4d, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3d, 0x0a, 0x1b, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x61, 0x6c,
	0x77, 0x61, 0x79, 0x73, 0x5f, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x41, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x4f, 0x6e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x54,
	0x0a, 0x0d, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x68, 0x77, 0x2e, 0x74, 0x72, 0x65, 0x7a, 0x6f,
	0x72, 0x2e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0c, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x73, 0x12, 0x33, 0x0a, 0x15, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x14, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x39, 0x0a, 0x19, 0x68, 0x69, 0x64,
	0x65, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x66, 0x72, 0x6f,
	0x6d, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x68, 0x69,
	0x64, 0x65, 0x50, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x46, 0x72, 0x6f, 0x6d,
	0x48, 0x6f, 0x73, 0x74, 0x22, 0x54, 0x0a, 0x0e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0a, 0x64, 0x61, 0x74,
	0x61, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73,
	0x68, 0x6f, 0x77, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x22, 0x5a, 0x0a, 0x16, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x4c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61,
	0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x33, 0x0a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x41, 0x63, 0x6b, 0x12, 0x1d, 0x0a, 0x0a,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0c,
	0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x22, 0x22, 0x0a, 0x0a, 0x41,
	0x70, 0x70, 0x6c, 0x79, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6c, 0x61,
	0x67, 0x73, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x05, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x22,
	0x23, 0x0a, 0x09, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x69, 0x6e, 0x12, 0x16, 0x0a, 0x06,
	0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x22, 0x28, 0x0a, 0x0e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x57, 0x69,
	0x70, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x22, 0xaa,
	0x01, 0x0a, 0x09, 0x53, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x12, 0x5d, 0x0a, 0x09,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32,
	0x3f, 0x2e, 0x68, 0x77, 0x2e, 0x74, 0x72, 0x65, 0x7a, 0x6f, 0x72, 0x2e, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x53, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x2e, 0x53, 0x64, 0x50, 0x72, 0x6f, 0x74,
	0x65, 0x63, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0x0a, 0x16, 0x53,
	0x64, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x52, 0x45, 0x46, 0x52, 0x45, 0x53, 0x48, 0x10, 0x02, 0x22, 0x4f, 0x0a, 0x04, 0x50,
	0x69, 0x6e, 0x67, 0x12, 0x1a, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x3a, 0x00, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x2b, 0x0a, 0x11, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x62, 0x75, 0x74, 0x74,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x08, 0x0a, 0x06,
	0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x22, 0x20, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74,
	0x72, 0x6f, 0x70, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x02,
	0x28, 0x0d, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x22, 0x23, 0x0a, 0x07, 0x45, 0x6e, 0x74, 0x72,
	0x6f, 0x70, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x70, 0x79, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x0c, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x70, 0x79, 0x22, 0x2f, 0x0a,
	0x0f, 0x47, 0x65, 0x74, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x48, 0x61, 0x73, 0x68,
	0x12, 0x1c, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x22, 0x22,
	0x0a, 0x0c, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x48, 0x61, 0x73, 0x68, 0x12, 0x12,
	0x0a, 0x04, 0x68, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x04, 0x68, 0x61,
	0x73, 0x68, 0x22, 0x32, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x6c,
	0x6c, 0x65, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x09, 0x63, 0x68, 0x61,
	0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x22, 0x55, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e,
	0x74, 0x69, 0x63, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x22, 0x0a, 0x0c, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0c, 0x52, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12,
	0x1c, 0x0a, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x02,
	0x28, 0x0c, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x0c, 0x0a,
	0x0a, 0x57, 0x69, 0x70, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x22, 0xad, 0x02, 0x0a, 0x0a,
	0x4c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x6e,
	0x65, 0x6d, 0x6f, 0x6e, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x6d,
	0x6e, 0x65, 0x6d, 0x6f, 0x6e, 0x69, 0x63, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x70, 0x69, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x70, 0x69, 0x6e, 0x12, 0x33, 0x0a, 0x15, 0x70, 0x61,
	0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x70, 0x61, 0x73, 0x73, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1e, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x73, 0x6b,
	0x69, 0x70, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x12, 0x1f, 0x0a, 0x0b, 0x75, 0x32,
	0x66, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0a, 0x75, 0x32, 0x66, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x6e,
	0x65, 0x65, 0x64, 0x73, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0b, 0x6e, 0x65, 0x65, 0x64, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x1b,
	0x0a, 0x09, 0x6e, 0x6f, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x08, 0x6e, 0x6f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x22, 0x99, 0x03, 0x0a, 0x0b,
	0x52, 0x65, 0x73, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x52, 0x61, 0x6e, 0x64,
	0x6f, 0x6d, 0x12, 0x1f, 0x0a, 0x08, 0x73, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x3a, 0x03, 0x32, 0x35, 0x36, 0x52, 0x08, 0x73, 0x74, 0x72, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x12, 0x33, 0x0a, 0x15, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x14, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x69, 0x6e, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x70, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1e, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x75, 0x32, 0x66, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x75, 0x32, 0x66, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x6b, 0x69,
	0x70, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x6f, 0x5f, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e, 0x6f, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x12, 0x51, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x68, 0x77, 0x2e, 0x74,
	0x72, 0x65, 0x7a, 0x6f, 0x72, 0x2e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x54, 0x79, 0x70, 0x65, 0x3a, 0x05, 0x42, 0x69, 0x70, 0x33, 0x39, 0x52, 0x0a, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x22, 0x0e, 0x0a, 0x0c, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x22, 0x10, 0x0a, 0x0e, 0x45, 0x6e, 0x74, 0x72, 0x6f,
	0x70, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x26, 0x0a, 0x0a, 0x45, 0x6e, 0x74,
	0x72, 0x6f, 0x70, 0x79, 0x41, 0x63, 0x6b, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x6f,
	0x70, 0x79, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x70,
	0x79, 0x22, 0xd8, 0x03, 0x0a, 0x0e, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x64, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x15, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x14, 0x70, 0x61, 0x73, 0x73, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x69, 0x6e, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x70, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1e, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x5f, 0x77, 0x6f, 0x72, 0x64, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x57, 0x6f, 0x72, 0x64, 0x6c, 0x69, 0x73, 0x74,
	0x12, 0x54, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40,
	0x2e, 0x68, 0x77, 0x2e, 0x74, 0x72, 0x65, 0x7a, 0x6f, 0x72, 0x2e, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52,
	0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x52, 0x65,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x75, 0x32, 0x66, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x75, 0x32, 0x66,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x72, 0x79, 0x5f, 0x72,
	0x75, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x72, 0x79, 0x52, 0x75, 0x6e,
	0x22, 0x5a, 0x0a, 0x12, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x5f, 0x53, 0x63, 0x72,
	0x61, 0x6d, 0x62, 0x6c, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x64, 0x73, 0x10, 0x00, 0x12, 0x1d, 0x0a,
	0x19, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x5f, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x10, 0x01, 0x22, 0xc5, 0x01, 0x0a,
	0x0b, 0x57, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x68, 0x77, 0x2e,
	0x74, 0x72, 0x65, 0x7a, 0x6f, 0x72, 0x2e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x57, 0x6f, 0x72, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x57, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x66, 0x0a, 0x0f,
	0x57, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x19, 0x0a, 0x15, 0x57, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x5f, 0x50, 0x6c, 0x61, 0x69, 0x6e, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x57, 0x6f,
	0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x5f, 0x4d, 0x61,
	0x74, 0x72, 0x69, 0x78, 0x39, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x57, 0x6f, 0x72, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x5f, 0x4d, 0x61, 0x74, 0x72, 0x69,
	0x78, 0x36, 0x10, 0x02, 0x22, 0x1d, 0x0a, 0x07, 0x57, 0x6f, 0x72, 0x64, 0x41, 0x63, 0x6b, 0x12,
	0x12, 0x0a, 0x04, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x77,
	0x6f, 0x72, 0x64, 0x22, 0x30, 0x0a, 0x0d, 0x53, 0x65, 0x74, 0x55, 0x32, 0x46, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x75, 0x32, 0x66, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0d, 0x52, 0x0a, 0x75, 0x32, 0x66, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x65, 0x72, 0x22, 0x13, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x4e, 0x65, 0x78, 0x74,
	0x55, 0x32, 0x46, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x22, 0x31, 0x0a, 0x0e, 0x4e, 0x65,
	0x78, 0x74, 0x55, 0x32, 0x46, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b,
	0x75, 0x32, 0x66, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x02, 0x28,
	0x0d, 0x52, 0x0a, 0x75, 0x32, 0x66, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x22, 0x11, 0x0a,
	0x0f, 0x44, 0x6f, 0x50, 0x72, 0x65, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
	0x22, 0x16, 0x0a, 0x14, 0x50, 0x72, 0x65, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x15, 0x0a, 0x13, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x9a, 0x02, 0x0a, 0x12, 0x52, 0x65, 0x62, 0x6f, 0x6f, 0x74, 0x54, 0x6f, 0x42, 0x6f, 0x6f, 0x74,
	0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x12, 0x6f, 0x0a, 0x0c, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x68,
	0x77, 0x2e, 0x74, 0x72, 0x65, 0x7a, 0x6f, 0x72, 0x2e, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x73, 0x2e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x62,
	0x6f, 0x6f, 0x74, 0x54, 0x6f, 0x42, 0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x2e,
	0x42, 0x6f, 0x6f, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x3a, 0x0d, 0x53, 0x54, 0x4f,
	0x50, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x57, 0x41, 0x49, 0x54, 0x52, 0x0b, 0x62, 0x6f, 0x6f, 0x74,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x66, 0x69, 0x72, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0e, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x33, 0x0a, 0x14, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x3a, 0x01,
	0x30, 0x52, 0x12, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x44, 0x61, 0x74, 0x61, 0x4c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0x35, 0x0a, 0x0b, 0x42, 0x6f, 0x6f, 0x74, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x4f, 0x50, 0x5f, 0x41, 0x4e, 0x44,
	0x5f, 0x57, 0x41, 0x49, 0x54, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x49, 0x4e, 0x53, 0x54, 0x41,
	0x4c, 0x4c, 0x5f, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x10, 0x01, 0x22, 0x10, 0x0a, 0x08,
	0x47, 0x65, 0x74, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x3a, 0x04, 0x88, 0xb2, 0x19, 0x01, 0x22, 0x23,
	0x0a, 0x05, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x02, 0x28, 0x0c, 0x52, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x3a, 0x04, 0x88,
	0xb2, 0x19, 0x01, 0x22, 0x3b, 0x0a, 0x0a, 0x55, 0x6e, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6e, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0d, 0x52, 0x08, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4e, 0x12, 0x10,
	0x0a, 0x03, 0x6d, 0x61, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6d, 0x61, 0x63,
	0x22, 0x27, 0x0a, 0x13, 0x55, 0x6e, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x50, 0x61, 0x74, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x61, 0x63, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6d, 0x61, 0x63, 0x22, 0x14, 0x0a, 0x12, 0x53, 0x68, 0x6f,
	0x77, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x54, 0x75, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x22,
	0x12, 0x0a, 0x10, 0x55, 0x6e, 0x6c, 0x6f, 0x63, 0x6b, 0x42, 0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61,
	0x64, 0x65, 0x72, 0x2a, 0x3e, 0x0a, 0x0a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x69, 0x70, 0x33, 0x39, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c,
	0x53, 0x6c, 0x69, 0x70, 0x33, 0x39, 0x5f, 0x42, 0x61, 0x73, 0x69, 0x63, 0x10, 0x01, 0x12, 0x13,
	0x0a, 0x0f, 0x53, 0x6c, 0x69, 0x70, 0x33, 0x39, 0x5f, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65,
	0x64, 0x10, 0x02, 0x2a, 0x47, 0x0a, 0x10, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x41, 0x6c, 0x77,
	0x61, 0x79, 0x73, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54,
	0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x69, 0x6c, 0x79, 0x10, 0x02, 0x2a, 0x30, 0x0a, 0x10,
	0x48, 0x6f, 0x6d, 0x65, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x12, 0x08, 0x0a, 0x04, 0x54, 0x6f, 0x69, 0x66, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x70,
	0x65, 0x67, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x6f, 0x69, 0x47, 0x10, 0x03, 0x42, 0x5f,
	0x80, 0xa6, 0x1d, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x73, 0x61, 0x74, 0x6f, 0x73, 0x68,
	0x69, 0x6c, 0x61, 0x62, 0x73, 0x2e, 0x74, 0x72, 0x65, 0x7a, 0x6f, 0x72, 0x2e, 0x6c, 0x69, 0x62,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x42, 0x17, 0x54, 0x72, 0x65, 0x7a, 0x6f,
	0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5a, 0x1b, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2d, 0x74, 0x72, 0x65, 0x7a, 0x6f, 0x72, 0x2f, 0x74, 0x72, 0x65, 0x7a, 0x6f, 0x72,
}

var (
	file_messages_management_proto_rawDescOnce sync.Once
	file_messages_management_proto_rawDescData = file_messages_management_proto_rawDesc
)

func file_messages_management_proto_rawDescGZIP() []byte {
	file_messages_management_proto_rawDescOnce.Do(func() {
		file_messages_management_proto_rawDescData = protoimpl.X.CompressGZIP(file_messages_management_proto_rawDescData)
	})
	return file_messages_management_proto_rawDescData
}

var (
	file_messages_management_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
	file_messages_management_proto_msgTypes  = make([]protoimpl.MessageInfo, 44)
	file_messages_management_proto_goTypes   = []interface{}{
		(BackupType)(0),                        // 0: hw.trezor.messages.management.BackupType
		(SafetyCheckLevel)(0),                  // 1: hw.trezor.messages.management.SafetyCheckLevel
		(HomescreenFormat)(0),                  // 2: hw.trezor.messages.management.HomescreenFormat
		(Features_Capability)(0),               // 3: hw.trezor.messages.management.Features.Capability
		(SdProtect_SdProtectOperationType)(0),  // 4: hw.trezor.messages.management.SdProtect.SdProtectOperationType
		(RecoveryDevice_RecoveryDeviceType)(0), // 5: hw.trezor.messages.management.RecoveryDevice.RecoveryDeviceType
		(WordRequest_WordRequestType)(0),       // 6: hw.trezor.messages.management.WordRequest.WordRequestType
		(RebootToBootloader_BootCommand)(0),    // 7: hw.trezor.messages.management.RebootToBootloader.BootCommand
		(*Initialize)(nil),                     // 8: hw.trezor.messages.management.Initialize
		(*GetFeatures)(nil),                    // 9: hw.trezor.messages.management.GetFeatures
		(*Features)(nil),                       // 10: hw.trezor.messages.management.Features
		(*LockDevice)(nil),                     // 11: hw.trezor.messages.management.LockDevice
		(*SetBusy)(nil),                        // 12: hw.trezor.messages.management.SetBusy
		(*EndSession)(nil),                     // 13: hw.trezor.messages.management.EndSession
		(*ApplySettings)(nil),                  // 14: hw.trezor.messages.management.ApplySettings
		(*ChangeLanguage)(nil),                 // 15: hw.trezor.messages.management.ChangeLanguage
		(*TranslationDataRequest)(nil),         // 16: hw.trezor.messages.management.TranslationDataRequest
		(*TranslationDataAck)(nil),             // 17: hw.trezor.messages.management.TranslationDataAck
		(*ApplyFlags)(nil),                     // 18: hw.trezor.messages.management.ApplyFlags
		(*ChangePin)(nil),                      // 19: hw.trezor.messages.management.ChangePin
		(*ChangeWipeCode)(nil),                 // 20: hw.trezor.messages.management.ChangeWipeCode
		(*SdProtect)(nil),                      // 21: hw.trezor.messages.management.SdProtect
		(*Ping)(nil),                           // 22: hw.trezor.messages.management.Ping
		(*Cancel)(nil),                         // 23: hw.trezor.messages.management.Cancel
		(*GetEntropy)(nil),                     // 24: hw.trezor.messages.management.GetEntropy
		(*Entropy)(nil),                        // 25: hw.trezor.messages.management.Entropy
		(*GetFirmwareHash)(nil),                // 26: hw.trezor.messages.management.GetFirmwareHash
		(*FirmwareHash)(nil),                   // 27: hw.trezor.messages.management.FirmwareHash
		(*AuthenticateDevice)(nil),             // 28: hw.trezor.messages.management.AuthenticateDevice
		(*AuthenticityProof)(nil),              // 29: hw.trezor.messages.management.AuthenticityProof
		(*WipeDevice)(nil),                     // 30: hw.trezor.messages.management.WipeDevice
		(*LoadDevice)(nil),                     // 31: hw.trezor.messages.management.LoadDevice
		(*ResetDevice)(nil),                    // 32: hw.trezor.messages.management.ResetDevice
		(*BackupDevice)(nil),                   // 33: hw.trezor.messages.management.BackupDevice
		(*EntropyRequest)(nil),                 // 34: hw.trezor.messages.management.EntropyRequest
		(*EntropyAck)(nil),                     // 35: hw.trezor.messages.management.EntropyAck
		(*RecoveryDevice)(nil),                 // 36: hw.trezor.messages.management.RecoveryDevice
		(*WordRequest)(nil),                    // 37: hw.trezor.messages.management.WordRequest
		(*WordAck)(nil),                        // 38: hw.trezor.messages.management.WordAck
		(*SetU2FCounter)(nil),                  // 39: hw.trezor.messages.management.SetU2FCounter
		(*GetNextU2FCounter)(nil),              // 40: hw.trezor.messages.management.GetNextU2FCounter
		(*NextU2FCounter)(nil),                 // 41: hw.trezor.messages.management.NextU2FCounter
		(*DoPreauthorized)(nil),                // 42: hw.trezor.messages.management.DoPreauthorized
		(*PreauthorizedRequest)(nil),           // 43: hw.trezor.messages.management.PreauthorizedRequest
		(*CancelAuthorization)(nil),            // 44: hw.trezor.messages.management.CancelAuthorization
		(*RebootToBootloader)(nil),             // 45: hw.trezor.messages.management.RebootToBootloader
		(*GetNonce)(nil),                       // 46: hw.trezor.messages.management.GetNonce
		(*Nonce)(nil),                          // 47: hw.trezor.messages.management.Nonce
		(*UnlockPath)(nil),                     // 48: hw.trezor.messages.management.UnlockPath
		(*UnlockedPathRequest)(nil),            // 49: hw.trezor.messages.management.UnlockedPathRequest
		(*ShowDeviceTutorial)(nil),             // 50: hw.trezor.messages.management.ShowDeviceTutorial
		(*UnlockBootloader)(nil),               // 51: hw.trezor.messages.management.UnlockBootloader
	}
)

var file_messages_management_proto_depIdxs = []int32{
	3,  // 0: hw.trezor.messages.management.Features.capabilities:type_name -> hw.trezor.messages.management.Features.Capability
	0,  // 1: hw.trezor.messages.management.Features.backup_type:type_name -> hw.trezor.messages.management.BackupType
	1,  // 2: hw.trezor.messages.management.Features.safety_checks:type_name -> hw.trezor.messages.management.SafetyCheckLevel
	2,  // 3: hw.trezor.messages.management.Features.homescreen_format:type_name -> hw.trezor.messages.management.HomescreenFormat
	1,  // 4: hw.trezor.messages.management.ApplySettings.safety_checks:type_name -> hw.trezor.messages.management.SafetyCheckLevel
	4,  // 5: hw.trezor.messages.management.SdProtect.operation:type_name -> hw.trezor.messages.management.SdProtect.SdProtectOperationType
	0,  // 6: hw.trezor.messages.management.ResetDevice.backup_type:type_name -> hw.trezor.messages.management.BackupType
	5,  // 7: hw.trezor.messages.management.RecoveryDevice.type:type_name -> hw.trezor.messages.management.RecoveryDevice.RecoveryDeviceType
	6,  // 8: hw.trezor.messages.management.WordRequest.type:type_name -> hw.trezor.messages.management.WordRequest.WordRequestType
	7,  // 9: hw.trezor.messages.management.RebootToBootloader.boot_command:type_name -> hw.trezor.messages.management.RebootToBootloader.BootCommand
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_messages_management_proto_init() }
func file_messages_management_proto_init() {
	if File_messages_management_proto != nil {
		return
	}
	file_messages_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_messages_management_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Initialize); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFeatures); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Features); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LockDevice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetBusy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndSession); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplySettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeLanguage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TranslationDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TranslationDataAck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyFlags); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangePin); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeWipeCode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SdProtect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Ping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cancel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntropy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entropy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFirmwareHash); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FirmwareHash); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthenticateDevice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthenticityProof); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WipeDevice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadDevice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetDevice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupDevice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntropyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntropyAck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecoveryDevice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WordRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WordAck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetU2FCounter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNextU2FCounter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NextU2FCounter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DoPreauthorized); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreauthorizedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelAuthorization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RebootToBootloader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNonce); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Nonce); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnlockPath); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnlockedPathRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShowDeviceTutorial); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_messages_management_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnlockBootloader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_messages_management_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   44,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_messages_management_proto_goTypes,
		DependencyIndexes: file_messages_management_proto_depIdxs,
		EnumInfos:         file_messages_management_proto_enumTypes,
		MessageInfos:      file_messages_management_proto_msgTypes,
	}.Build()
	File_messages_management_proto = out.File
	file_messages_management_proto_rawDesc = nil
	file_messages_management_proto_goTypes = nil
	file_messages_management_proto_depIdxs = nil
}
