module testbench (
	input clk, resetn,
	output mem_valid,
	output mem_instr,
	output reg  mem_ready,
	output [31:0] mem_addr,
	output [31:0] mem_wdata,
	output [ 3:0] mem_wstrb,
	output reg  [31:0] mem_rdata
);
	picorv32 uut (
		.clk       (clk      ),
		.resetn    (resetn   ),
		.mem_valid (mem_valid),
		.mem_instr (mem_instr),
		.mem_ready (mem_ready),
		.mem_addr  (mem_addr ),
		.mem_wdata (mem_wdata),
		.mem_wstrb (mem_wstrb),
		.mem_rdata (mem_rdata)
	);

	always @* begin
		mem_ready = mem_valid;
		mem_rdata = 32'b 0000000_00000_00000_000_00000_0010011; // ADDI x0,x0,0
		case (mem_addr)
			32'h 0000_0000: mem_rdata = 32'b 0000001_00001_00000_000_00001_0010011; // ADDI x1,x0,33
			32'h 0000_0004: mem_rdata = 32'b 0000010_00001_00000_000_00010_0010011; // ADDI x2,x0,65
			32'h 0000_0008: mem_rdata = 32'b 0000100_00001_00000_000_00011_0010011; // ADDI x3,x0,129
			32'h 0000_000C: mem_rdata = 32'b 0001000_00001_00000_000_00100_0010011; // ADDI x4,x0,257
			32'h 0000_0010: mem_rdata = 32'b 0010000_00001_00000_000_00101_0010011; // ADDI x5,x0,513
			32'h 0000_0014: mem_rdata = 32'b 0100000_00001_00000_000_00110_0010011; // ADDI x6,x0,1025
			32'h 0000_0018: mem_rdata = 32'b 0000001_00010_00000_000_00111_0010011; // ADDI x7,x0,34
			32'h 0000_001C: mem_rdata = 32'b 0000010_00010_00000_000_01000_0010011; // ADDI x8,x0,66
			32'h 0000_0020: mem_rdata = 32'b 0000100_00010_00000_000_01001_0010011; // ADDI x9,x0,130
			32'h 0000_0024: mem_rdata = 32'b 0001000_00010_00000_000_01010_0010011; // ADDI x10,x0,258
			32'h 0000_0028: mem_rdata = 32'b 0010000_00010_00000_000_01011_0010011; // ADDI x11,x0,514
			32'h 0000_002C: mem_rdata = 32'b 0100000_00010_00000_000_01100_0010011; // ADDI x12,x0,1026
			32'h 0000_0030: mem_rdata = 32'b 0000001_00100_00000_000_01101_0010011; // ADDI x13,x0,36
			32'h 0000_0034: mem_rdata = 32'b 0000010_00100_00000_000_01110_0010011; // ADDI x14,x0,68
			32'h 0000_0038: mem_rdata = 32'b 0000100_00100_00000_000_01111_0010011; // ADDI x15,x0,132
			32'h 0000_003C: mem_rdata = 32'b 0001000_00100_00000_000_10000_0010011; // ADDI x16,x0,260
			32'h 0000_0040: mem_rdata = 32'b 0010000_00100_00000_000_10001_0010011; // ADDI x17,x0,516
			32'h 0000_0044: mem_rdata = 32'b 0100000_00100_00000_000_10010_0010011; // ADDI x18,x0,1028
			32'h 0000_0048: mem_rdata = 32'b 0000001_01000_00000_000_10011_0010011; // ADDI x19,x0,40
			32'h 0000_004C: mem_rdata = 32'b 0000010_01000_00000_000_10100_0010011; // ADDI x20,x0,72
			32'h 0000_0050: mem_rdata = 32'b 0000100_01000_00000_000_10101_0010011; // ADDI x21,x0,136
			32'h 0000_0054: mem_rdata = 32'b 0001000_01000_00000_000_10110_0010011; // ADDI x22,x0,264
			32'h 0000_0058: mem_rdata = 32'b 0010000_01000_00000_000_10111_0010011; // ADDI x23,x0,520
			32'h 0000_005C: mem_rdata = 32'b 0100000_01000_00000_000_11000_0010011; // ADDI x24,x0,1032
			32'h 0000_0060: mem_rdata = 32'b 0000001_10000_00000_000_11001_0010011; // ADDI x25,x0,48
			32'h 0000_0064: mem_rdata = 32'b 0000010_10000_00000_000_11010_0010011; // ADDI x26,x0,80
			32'h 0000_0068: mem_rdata = 32'b 0000100_10000_00000_000_11011_0010011; // ADDI x27,x0,144
			32'h 0000_006C: mem_rdata = 32'b 0001000_10000_00000_000_11100_0010011; // ADDI x28,x0,272
			32'h 0000_0070: mem_rdata = 32'b 0010000_10000_00000_000_11101_0010011; // ADDI x29,x0,528
			32'h 0000_0074: mem_rdata = 32'b 0100000_10000_00000_000_11110_0010011; // ADDI x30,x0,1040
			32'h 0000_0078: mem_rdata = 32'b 1111111_11111_00000_000_11111_0010011; // ADDI x31,x0,-1
		endcase
	end
endmodule
