/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.remote;

import com.android.annotations.NonNull;
import com.android.sdklib.internal.repository.IDescription;
import com.android.sdklib.internal.repository.IListDescription;
import com.android.sdklib.repository.descriptors.IPkgDesc;

public class RemotePkgInfo
implements IDescription,
IListDescription,
Comparable<RemotePkgInfo> {
    @NonNull
    private final IPkgDesc mPkgDesc;
    @NonNull
    private final IDescription mSourceUri;

    public RemotePkgInfo(@NonNull IPkgDesc pkgDesc, @NonNull IDescription sourceUri) {
        this.mPkgDesc = pkgDesc;
        this.mSourceUri = sourceUri;
    }

    @NonNull
    public IPkgDesc getDesc() {
        return this.mPkgDesc;
    }

    @NonNull
    public IDescription getSourceUri() {
        return this.mSourceUri;
    }

    @Override
    public int compareTo(@NonNull RemotePkgInfo o) {
        return this.mPkgDesc.compareTo(o.mPkgDesc);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mPkgDesc == null ? 0 : this.mPkgDesc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof RemotePkgInfo && this.compareTo((RemotePkgInfo)obj) == 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<RemotePkgInfo Source:").append(this.mSourceUri.getShortDescription());
        builder.append(' ').append(this.mPkgDesc.toString()).append('>');
        return builder.toString();
    }

    @Override
    public String getListDescription() {
        return this.getDesc().getListDescription();
    }

    @Override
    public String getShortDescription() {
        return this.getListDescription();
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        IPkgDesc desc = this.getDesc();
        sb.append(desc.getListDescription()).append('\n');
        if (desc.hasVendor()) {
            assert (desc.getVendor() != null);
            sb.append("By ").append(desc.getVendor().getDisplay()).append('\n');
        }
        if (desc.hasMinPlatformToolsRev()) {
            assert (desc.getMinPlatformToolsRev() != null);
            sb.append("Requires Platform-Tools revision ").append(desc.getMinPlatformToolsRev().toShortString()).append('\n');
        }
        if (desc.hasMinToolsRev()) {
            assert (desc.getMinToolsRev() != null);
            sb.append("Requires Tools revision ").append(desc.getMinToolsRev().toShortString()).append('\n');
        }
        return sb.toString();
    }
}

