/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.collection.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.collection.common.DataAwareItemEvent;
import com.hazelcast.collection.impl.collection.CollectionEventFilter;
import com.hazelcast.collection.impl.collection.CollectionPortableHook;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.ListPermission;
import com.hazelcast.security.permission.SetPermission;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.impl.PortableItemEvent;
import java.io.IOException;
import java.security.Permission;

public class CollectionAddListenerRequest
extends CallableClientRequest
implements RetryableRequest {
    private String name;
    private boolean includeValue;
    private String serviceName;

    public CollectionAddListenerRequest() {
    }

    public CollectionAddListenerRequest(String name, boolean includeValue) {
        this.name = name;
        this.includeValue = includeValue;
    }

    public Object call() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        ClientEngine clientEngine = this.getClientEngine();
        Object partitionKey = this.serializationService.toData(this.name);
        ItemListener listener = this.createItemListener(endpoint, (Data)partitionKey);
        EventService eventService = clientEngine.getEventService();
        CollectionEventFilter filter = new CollectionEventFilter(this.includeValue);
        EventRegistration registration = eventService.registerListener(this.getServiceName(), this.name, filter, listener);
        String registrationId = registration.getId();
        endpoint.addListenerDestroyAction(this.getServiceName(), this.name, registrationId);
        return registrationId;
    }

    private ItemListener createItemListener(final ClientEndpoint endpoint, final Data partitionKey) {
        return new ItemListener(){

            public void itemAdded(ItemEvent item) {
                this.send(item);
            }

            public void itemRemoved(ItemEvent item) {
                this.send(item);
            }

            private void send(ItemEvent event) {
                if (endpoint.isAlive()) {
                    if (!(event instanceof DataAwareItemEvent)) {
                        throw new IllegalArgumentException("Expecting: DataAwareItemEvent, Found: " + event.getClass().getSimpleName());
                    }
                    DataAwareItemEvent dataAwareItemEvent = (DataAwareItemEvent)event;
                    Data item = dataAwareItemEvent.getItemData();
                    PortableItemEvent portableItemEvent = new PortableItemEvent(item, event.getEventType(), event.getMember().getUuid());
                    endpoint.sendEvent(partitionKey, portableItemEvent, CollectionAddListenerRequest.this.getCallId());
                }
            }
        };
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public int getFactoryId() {
        return CollectionPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeBoolean("i", this.includeValue);
        writer.writeUTF("s", this.serviceName);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.includeValue = reader.readBoolean("i");
        this.serviceName = reader.readUTF("s");
    }

    @Override
    public Permission getRequiredPermission() {
        if ("hz:impl:listService".equals(this.serviceName)) {
            return new ListPermission(this.name, "listen");
        }
        if ("hz:impl:setService".equals(this.serviceName)) {
            return new SetPermission(this.name, "listen");
        }
        throw new IllegalArgumentException("No service matched!!!");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "addItemListener";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{null, this.includeValue};
    }
}

