/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerAdapter;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;

class StreamSerializerAdapter
implements SerializerAdapter {
    protected final SerializationService service;
    protected final StreamSerializer serializer;

    public StreamSerializerAdapter(SerializationService service, StreamSerializer serializer) {
        this.service = service;
        this.serializer = serializer;
    }

    @Override
    public void write(ObjectDataOutput out, Object object) throws IOException {
        this.serializer.write(out, object);
    }

    @Override
    public Object read(ObjectDataInput in) throws IOException {
        return this.serializer.read(in);
    }

    @Override
    public int getTypeId() {
        return this.serializer.getTypeId();
    }

    @Override
    public void destroy() {
        this.serializer.destroy();
    }

    @Override
    public Serializer getImpl() {
        return this.serializer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SerializerAdapter{");
        sb.append("serializer=").append(this.serializer);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSerializerAdapter that = (StreamSerializerAdapter)o;
        return !(this.serializer != null ? !this.serializer.equals(that.serializer) : that.serializer != null);
    }

    public int hashCode() {
        return this.serializer != null ? this.serializer.hashCode() : 0;
    }
}

