/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.client;

import com.hazelcast.core.IFunction;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.impl.client.PortableReadResultSet;
import com.hazelcast.ringbuffer.impl.client.RingbufferRequest;
import com.hazelcast.ringbuffer.impl.operations.ReadManyOperation;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;

public class ReadManyRequest
extends RingbufferRequest {
    private long startSequence;
    private int minCount;
    private int maxCount;
    private Data filterData;

    public ReadManyRequest() {
    }

    public ReadManyRequest(String name, long startSequence, int minCount, int maxCount, Data filter) {
        this.name = name;
        this.startSequence = startSequence;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.filterData = filter;
    }

    @Override
    protected Operation prepareOperation() {
        SerializationService serializationService = this.getClientEngine().getSerializationService();
        IFunction filter = (IFunction)serializationService.toObject(this.filterData);
        return new ReadManyOperation(this.name, this.startSequence, this.minCount, this.maxCount, filter);
    }

    @Override
    public int getClassId() {
        return 6;
    }

    @Override
    protected Object filter(Object response) {
        ReadResultSet readResultSet = (ReadResultSet)response;
        int readCount = readResultSet.readCount();
        ArrayList items = new ArrayList(readCount);
        for (Object item : readResultSet) {
            items.add(item);
        }
        return new PortableReadResultSet(readCount, items);
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeLong("s", this.startSequence);
        writer.writeInt("i", this.minCount);
        writer.writeInt("a", this.maxCount);
        writer.getRawDataOutput().writeData(this.filterData);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.startSequence = reader.readLong("s");
        this.minCount = reader.readInt("i");
        this.maxCount = reader.readInt("a");
        this.filterData = reader.getRawDataInput().readData();
    }
}

