/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.IOException;

public class NSNumber
extends NSObject
implements Comparable<Object> {
    public static final int INTEGER = 0;
    public static final int REAL = 1;
    public static final int BOOLEAN = 2;
    private int type;
    private long longValue;
    private double doubleValue;
    private boolean boolValue;

    public NSNumber(byte[] bytes, int type) {
        switch (type) {
            case 0: {
                this.longValue = BinaryPropertyListParser.parseLong(bytes);
                this.doubleValue = this.longValue;
                break;
            }
            case 1: {
                this.doubleValue = BinaryPropertyListParser.parseDouble(bytes);
                this.longValue = Math.round(this.doubleValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type argument is not valid.");
            }
        }
        this.type = type;
    }

    public NSNumber(String text) {
        if (text == null) {
            throw new IllegalArgumentException("The given string is null and cannot be parsed as number.");
        }
        try {
            long l;
            this.longValue = l = Long.parseLong(text);
            this.doubleValue = this.longValue;
            this.type = 0;
        }
        catch (Exception ex) {
            try {
                this.doubleValue = Double.parseDouble(text);
                this.longValue = Math.round(this.doubleValue);
                this.type = 1;
            }
            catch (Exception ex2) {
                try {
                    boolean bl = this.boolValue = text.toLowerCase().equals("true") || text.toLowerCase().equals("yes");
                    if (!(this.boolValue || text.toLowerCase().equals("false") || text.toLowerCase().equals("no"))) {
                        throw new Exception("not a boolean");
                    }
                    this.type = 2;
                    this.longValue = this.boolValue ? 1L : 0L;
                    this.doubleValue = this.longValue;
                }
                catch (Exception ex3) {
                    throw new IllegalArgumentException("The given string neither represents a double, an int nor a boolean value.");
                }
            }
        }
    }

    public NSNumber(int i) {
        this.longValue = i;
        this.doubleValue = this.longValue;
        this.type = 0;
    }

    public NSNumber(long l) {
        this.longValue = l;
        this.doubleValue = this.longValue;
        this.type = 0;
    }

    public NSNumber(double d) {
        this.doubleValue = d;
        this.longValue = (long)this.doubleValue;
        this.type = 1;
    }

    public NSNumber(boolean b) {
        this.boolValue = b;
        this.longValue = b ? 1L : 0L;
        this.doubleValue = this.longValue;
        this.type = 2;
    }

    public int type() {
        return this.type;
    }

    public boolean isBoolean() {
        return this.type == 2;
    }

    public boolean isInteger() {
        return this.type == 0;
    }

    public boolean isReal() {
        return this.type == 1;
    }

    public boolean boolValue() {
        if (this.type == 2) {
            return this.boolValue;
        }
        return this.longValue != 0L;
    }

    public long longValue() {
        return this.longValue;
    }

    public int intValue() {
        return (int)this.longValue;
    }

    public double doubleValue() {
        return this.doubleValue;
    }

    public float floatValue() {
        return (float)this.doubleValue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NSNumber)) {
            return false;
        }
        NSNumber n = (NSNumber)obj;
        return this.type == n.type && this.longValue == n.longValue && this.doubleValue == n.doubleValue && this.boolValue == n.boolValue;
    }

    public int hashCode() {
        int hash = this.type;
        hash = 37 * hash + (int)(this.longValue ^ this.longValue >>> 32);
        hash = 37 * hash + (int)(Double.doubleToLongBits(this.doubleValue) ^ Double.doubleToLongBits(this.doubleValue) >>> 32);
        hash = 37 * hash + (this.boolValue() ? 1 : 0);
        return hash;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return String.valueOf(this.longValue());
            }
            case 1: {
                return String.valueOf(this.doubleValue());
            }
            case 2: {
                return String.valueOf(this.boolValue());
            }
        }
        return super.toString();
    }

    @Override
    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        switch (this.type) {
            case 0: {
                xml.append("<integer>");
                xml.append(this.longValue());
                xml.append("</integer>");
                break;
            }
            case 1: {
                xml.append("<real>");
                xml.append(this.doubleValue());
                xml.append("</real>");
                break;
            }
            case 2: {
                if (this.boolValue()) {
                    xml.append("<true/>");
                    break;
                }
                xml.append("<false/>");
            }
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter out) throws IOException {
        switch (this.type()) {
            case 0: {
                if (this.longValue() < 0L) {
                    out.write(19);
                    out.writeBytes(this.longValue(), 8);
                    break;
                }
                if (this.longValue() <= 255L) {
                    out.write(16);
                    out.writeBytes(this.longValue(), 1);
                    break;
                }
                if (this.longValue() <= 65535L) {
                    out.write(17);
                    out.writeBytes(this.longValue(), 2);
                    break;
                }
                if (this.longValue() <= 0xFFFFFFFFL) {
                    out.write(18);
                    out.writeBytes(this.longValue(), 4);
                    break;
                }
                out.write(19);
                out.writeBytes(this.longValue(), 8);
                break;
            }
            case 1: {
                out.write(35);
                out.writeDouble(this.doubleValue());
                break;
            }
            case 2: {
                out.write(this.boolValue() ? 9 : 8);
            }
        }
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        if (this.type == 2) {
            ascii.append(this.boolValue ? "YES" : "NO");
        } else {
            ascii.append(this.toString());
        }
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        switch (this.type) {
            case 0: {
                ascii.append("<*I");
                ascii.append(this.toString());
                ascii.append(">");
                break;
            }
            case 1: {
                ascii.append("<*R");
                ascii.append(this.toString());
                ascii.append(">");
                break;
            }
            case 2: {
                if (this.boolValue) {
                    ascii.append("<*BY>");
                    break;
                }
                ascii.append("<*BN>");
            }
        }
    }

    @Override
    public int compareTo(Object o) {
        double x = this.doubleValue();
        if (o instanceof NSNumber) {
            NSNumber num = (NSNumber)o;
            double y = num.doubleValue();
            return x < y ? -1 : (x == y ? 0 : 1);
        }
        if (o instanceof Number) {
            double y = ((Number)o).doubleValue();
            return x < y ? -1 : (x == y ? 0 : 1);
        }
        return -1;
    }
}

