/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.IOException;

public class UID
extends NSObject {
    private byte[] bytes;
    private String name;

    public UID(String name, byte[] bytes) {
        this.name = name;
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getName() {
        return this.name;
    }

    @Override
    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        xml.append("<string>");
        for (int i = 0; i < this.bytes.length; ++i) {
            byte b = this.bytes[i];
            if (b < 16) {
                xml.append("0");
            }
            xml.append(Integer.toHexString(b));
        }
        xml.append("</string>");
    }

    @Override
    void toBinary(BinaryPropertyListWriter out) throws IOException {
        out.write(128 + this.bytes.length - 1);
        out.write(this.bytes);
    }

    @Override
    protected void toASCII(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append("\"");
        for (int i = 0; i < this.bytes.length; ++i) {
            byte b = this.bytes[i];
            if (b < 16) {
                ascii.append("0");
            }
            ascii.append(Integer.toHexString(b));
        }
        ascii.append("\"");
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        this.toASCII(ascii, level);
    }
}

