/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.JavacErrorDescriptionListener;
import com.google.errorprone.SubContext;
import com.google.errorprone.scanner.ErrorProneScannerTransformer;
import com.google.errorprone.scanner.Scanner;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.util.HashSet;
import java.util.Set;

public class ErrorProneAnalyzer
implements TaskListener {
    private final CodeTransformer transformer;
    private final Set<Tree> seen = new HashSet<Tree>();
    private Context context;
    private ErrorProneOptions errorProneOptions;
    private Log log;
    private JavaCompiler compiler;
    private boolean initialized = false;

    public static ErrorProneAnalyzer create(Scanner scanner) {
        return ErrorProneAnalyzer.create(ErrorProneScannerTransformer.create(scanner));
    }

    public static ErrorProneAnalyzer create(CodeTransformer transformer) {
        return new ErrorProneAnalyzer(transformer);
    }

    public ErrorProneAnalyzer init(Context context, ErrorProneOptions errorProneOptions) {
        this.initialized = true;
        this.context = context;
        this.errorProneOptions = errorProneOptions;
        this.log = Log.instance(context);
        this.compiler = JavaCompiler.instance(context);
        return this;
    }

    public ErrorProneAnalyzer register(Context context, ErrorProneOptions errorProneOptions) {
        this.init(context, errorProneOptions);
        MultiTaskListener.instance(context).add(this);
        return this;
    }

    private ErrorProneAnalyzer(CodeTransformer transformer) {
        this.transformer = (CodeTransformer)Preconditions.checkNotNull((Object)transformer);
    }

    @Override
    public void started(TaskEvent taskEvent) {
        Preconditions.checkState((boolean)this.initialized);
    }

    @Override
    public void finished(TaskEvent taskEvent) {
        if (taskEvent.getKind() == TaskEvent.Kind.ANALYZE) {
            JCTree.JCClassDecl currentClassTree = null;
            for (Tree tree : taskEvent.getCompilationUnit().getTypeDecls()) {
                if (!(tree instanceof JCTree.JCClassDecl)) continue;
                JCTree.JCClassDecl classTree = (JCTree.JCClassDecl)tree;
                if (!Objects.equal((Object)classTree.sym, (Object)taskEvent.getTypeElement())) continue;
                currentClassTree = classTree;
            }
            TreePath path = currentClassTree != null ? TreePath.getPath(taskEvent.getCompilationUnit(), currentClassTree) : new TreePath(taskEvent.getCompilationUnit());
            this.reportReadyForAnalysis(taskEvent, path, this.compiler.errorCount() > 0);
        }
    }

    private boolean finishedCompilation(CompilationUnitTree tree) {
        block4: for (Tree tree2 : tree.getTypeDecls()) {
            switch (tree2.getKind()) {
                case EMPTY_STATEMENT: {
                    continue block4;
                }
                case IMPORT: {
                    continue block4;
                }
            }
            if (this.seen.contains(tree2)) continue;
            return false;
        }
        return true;
    }

    public void reportReadyForAnalysis(TaskEvent taskEvent, TreePath path, boolean hasErrors) {
        block6: {
            try {
                Verify.verify((boolean)this.seen.add(path.getLeaf()), (String)"Duplicate FLOW event for: %s", (Object[])new Object[]{taskEvent.getTypeElement()});
                SubContext subContext = new SubContext(this.context);
                subContext.put(ErrorProneOptions.class, this.errorProneOptions);
                CompilationUnitTree compilation = path.getCompilationUnit();
                JavacErrorDescriptionListener logReporter = new JavacErrorDescriptionListener(this.log, ((JCTree.JCCompilationUnit)compilation).endPositions, compilation.getSourceFile());
                if (path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                    this.transformer.apply(path, subContext, logReporter);
                } else if (this.finishedCompilation(path.getCompilationUnit())) {
                    this.transformer.apply(new TreePath(compilation), subContext, logReporter);
                }
            }
            catch (Symbol.CompletionFailure e) {
                this.log.error("proc.cant.access", e.sym, e.getDetailValue(), Throwables.getStackTraceAsString((Throwable)e));
            }
            catch (RuntimeException e) {
                if (hasErrors) break block6;
                throw e;
            }
        }
    }
}

