/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="ArrayEquals", summary="Reference equality used to compare arrays", explanation="Generally when comparing arrays for equality, the programmer intends to check that the the contents of the arrays are equal rather than that they are actually the same object.  But many commonly used equals methods compare arrays for reference equality rather than content equality. These include the instance .equals() method, Guava's com.google.common.base.Objects#equal(), and the JDK's java.util.Objects#equals().\n\nIf reference equality is needed, == should be used instead for clarity. Otherwise, use java.util.Arrays#equals() to compare the contents of the arrays.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class ArrayEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> instanceEqualsMatcher = Matchers.allOf(Matchers.instanceMethod().onClass(TypePredicates.isArray()).named("equals"), Matchers.argument(0, Matchers.isArrayType()));
    private static final Matcher<MethodInvocationTree> staticEqualsMatcher = Matchers.allOf(Matchers.anyOf(Matchers.staticMethod().onClass("com.google.common.base.Objects").named("equal"), Matchers.staticMethod().onClass("java.util.Objects").named("equals")), Matchers.argument(0, Matchers.isArrayType()), Matchers.argument(1, Matchers.isArrayType()));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree t, VisitorState state) {
        String arg2;
        String arg1;
        if (instanceEqualsMatcher.matches(t, state)) {
            arg1 = ((JCTree.JCFieldAccess)t.getMethodSelect()).getExpression().toString();
            arg2 = t.getArguments().get(0).toString();
        } else if (staticEqualsMatcher.matches(t, state)) {
            arg1 = t.getArguments().get(0).toString();
            arg2 = t.getArguments().get(1).toString();
        } else {
            return Description.NO_MATCH;
        }
        Fix fix = SuggestedFix.builder().replace(t, "Arrays.equals(" + arg1 + ", " + arg2 + ")").addImport("java.util.Arrays").build();
        return this.describeMatch(t, fix);
    }
}

