/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(name="ArrayToString", summary="Calling toString on an array does not provide useful information", explanation="The toString method on an array will print its identity, such as [I@4488aabb. This is almost never needed. Use Arrays.toString to print a human-readable array summary.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class ArrayToString
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> getStackTraceMatcher = Matchers.instanceMethod().onDescendantOf("java.lang.Throwable").named("getStackTrace");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree methodTree, VisitorState state) {
        Fix fix;
        if (!Matchers.instanceMethod().onClass(TypePredicates.isArray()).named("toString").matches(methodTree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiverTree = ASTHelpers.getReceiver(methodTree);
        if (receiverTree instanceof MethodInvocationTree && getStackTraceMatcher.matches(receiverTree, state)) {
            String throwable = ASTHelpers.getReceiver(receiverTree).toString();
            fix = SuggestedFix.builder().replace(methodTree, "Throwables.getStackTraceAsString(" + throwable + ")").addImport("com.google.common.base.Throwables").build();
        } else {
            fix = SuggestedFix.builder().replace(methodTree, "Arrays.toString(" + receiverTree + ")").addImport("java.util.Arrays").build();
        }
        return this.describeMatch(methodTree, fix);
    }
}

