/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.Tree;

@BugPattern(name="EmptyIf", altNames={"empty"}, summary="Empty statement after if", explanation="An if statement contains an empty statement as the then clause. A semicolon may have been inserted by accident.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class EmptyIfStatement
extends BugChecker
implements BugChecker.EmptyStatementTreeMatcher {
    @Override
    public Description matchEmptyStatement(EmptyStatementTree tree, VisitorState state) {
        boolean matches = false;
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent.getKind() == Tree.Kind.IF) {
            IfTree parentAsIf = (IfTree)parent;
            boolean bl = matches = parentAsIf.getThenStatement() instanceof EmptyStatementTree && parentAsIf.getElseStatement() == null;
        }
        if (!matches) {
            return Description.NO_MATCH;
        }
        boolean nextStmtIsNull = Matchers.parentNode(Matchers.nextStatement(Matchers.isSame(null))).matches(tree, state);
        assert (state.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.IF);
        IfTree ifParent = (IfTree)state.getPath().getParentPath().getLeaf();
        if (nextStmtIsNull) {
            return this.describeMatch(parent, SuggestedFix.delete(parent));
        }
        return this.describeMatch(ifParent.getThenStatement(), SuggestedFix.delete(ifParent.getThenStatement()));
    }
}

