/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="AssistedInjectAndInjectOnSameConstructor", summary="@AssistedInject and @Inject cannot be used on the same constructor.", explanation="Using @AssistedInject and @Inject on the same constructor is a runtimeerror in Guice.", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class InjectAssistedInjectAndInjectOnSameConstructor
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final String GUICE_INJECT_ANNOTATION = "com.google.inject.Inject";
    private static final String JAVAX_INJECT_ANNOTATION = "javax.inject.Inject";
    private static final String ASSISTED_INJECT_ANNOTATION = "com.google.inject.assistedinject.AssistedInject";
    private Matcher<MethodTree> constructorWithInjectMatcher = Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.Inject"), Matchers.hasAnnotation("javax.inject.Inject"));
    private Matcher<MethodTree> constructorWithAssistedInjectMatcher = Matchers.hasAnnotation("com.google.inject.assistedinject.AssistedInject");
    private Matcher<AnnotationTree> injectOrAssistedInjectMatcher = new Matcher<AnnotationTree>(){

        @Override
        public boolean matches(AnnotationTree annotationTree, VisitorState state) {
            Symbol annotationSymbol = ASTHelpers.getSymbol(annotationTree);
            return annotationSymbol.equals(state.getSymbolFromString(InjectAssistedInjectAndInjectOnSameConstructor.JAVAX_INJECT_ANNOTATION)) || annotationSymbol.equals(state.getSymbolFromString(InjectAssistedInjectAndInjectOnSameConstructor.GUICE_INJECT_ANNOTATION)) || annotationSymbol.equals(state.getSymbolFromString(InjectAssistedInjectAndInjectOnSameConstructor.ASSISTED_INJECT_ANNOTATION));
        }
    };

    @Override
    public Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        Tree treeWithAnnotation;
        if (this.injectOrAssistedInjectMatcher.matches(annotationTree, state) && ASTHelpers.getSymbol(treeWithAnnotation = state.getPath().getParentPath().getParentPath().getLeaf()).isConstructor() && this.constructorWithInjectMatcher.matches((MethodTree)treeWithAnnotation, state) && this.constructorWithAssistedInjectMatcher.matches((MethodTree)treeWithAnnotation, state)) {
            return this.describeMatch(annotationTree, SuggestedFix.delete(annotationTree));
        }
        return Description.NO_MATCH;
    }
}

