/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.Modifier;

@BugPattern(name="InjectScopeAnnotationOnInterfaceOrAbstractClass", summary="Scope annotation on an interface or abstact class is not allowed", explanation="Scoping annotations are not allowed on abstract types.", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class InjectScopeAnnotationOnInterfaceOrAbstractClass
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final String GUICE_SCOPE_ANNOTATION = "com.google.inject.ScopeAnnotation";
    private static final String JAVAX_SCOPE_ANNOTATION = "javax.inject.Scope";
    private static final Matcher<AnnotationTree> SCOPE_ANNOTATION_MATCHER = Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.ScopeAnnotation"), Matchers.hasAnnotation("javax.inject.Scope"));
    private static final Matcher<ClassTree> INTERFACE_AND_ABSTRACT_TYPE_MATCHER = new Matcher<ClassTree>(){

        @Override
        public boolean matches(ClassTree classTree, VisitorState state) {
            return classTree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) || (ASTHelpers.getSymbol(classTree).flags() & 0x200L) != 0L;
        }
    };

    @Override
    public final Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        Tree modified = this.getCurrentlyAnnotatedNode(state);
        if (SCOPE_ANNOTATION_MATCHER.matches(annotationTree, state) && modified instanceof ClassTree && INTERFACE_AND_ABSTRACT_TYPE_MATCHER.matches((ClassTree)modified, state)) {
            return this.describeMatch(annotationTree, SuggestedFix.delete(annotationTree));
        }
        return Description.NO_MATCH;
    }

    private Tree getCurrentlyAnnotatedNode(VisitorState state) {
        return state.getPath().getParentPath().getParentPath().getLeaf();
    }
}

