/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.SwitchTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.lang.model.element.ElementKind;

@BugPattern(name="MissingCasesInEnumSwitch", summary="Enum switch statement is missing cases", explanation="Enums on switches should either handle all possible values of the enum, or have an explicit 'default' case.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class MissingCasesInEnumSwitch
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    @Override
    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        Symbol.TypeSymbol switchType = ((JCTree.JCSwitch)tree).getExpression().type.tsym;
        if (switchType.getKind() != ElementKind.ENUM) {
            return Description.NO_MATCH;
        }
        if (MissingCasesInEnumSwitch.hasDefaultCase(tree)) {
            return Description.NO_MATCH;
        }
        LinkedHashSet<String> unhandled = MissingCasesInEnumSwitch.setDifference(ASTHelpers.enumValues(switchType), MissingCasesInEnumSwitch.collectEnumSwitchCases(tree));
        if (unhandled.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(this.buildMessage(unhandled)).build();
    }

    private String buildMessage(LinkedHashSet<String> unhandled) {
        int maxCasesToPrint = 5;
        StringBuilder message = new StringBuilder("Non-exhaustive switch, expected cases for: ");
        boolean tooManyCasesToPrint = unhandled.size() > 5;
        int numberToShow = tooManyCasesToPrint ? 3 : unhandled.size();
        Iterator it = unhandled.iterator();
        for (int i = 0; i < numberToShow; ++i) {
            if (i != 0) {
                message.append(", ");
            }
            message.append((String)it.next());
        }
        if (tooManyCasesToPrint) {
            message.append(String.format(", and %d others. Did you mean to include a 'default' case?", unhandled.size() - numberToShow));
        } else {
            message.append(".");
        }
        return message.toString();
    }

    private static LinkedHashSet<String> collectEnumSwitchCases(SwitchTree tree) {
        LinkedHashSet<String> cases = new LinkedHashSet<String>();
        for (CaseTree caseTree : tree.getCases()) {
            ExpressionTree pat = caseTree.getExpression();
            if (!(pat instanceof IdentifierTree)) continue;
            cases.add(((IdentifierTree)pat).getName().toString());
        }
        return cases;
    }

    private static <T> LinkedHashSet<T> setDifference(LinkedHashSet<T> ax, LinkedHashSet<T> bx) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(ax);
        result.removeAll(bx);
        return result;
    }

    private static boolean hasDefaultCase(SwitchTree tree) {
        for (CaseTree caseTree : tree.getCases()) {
            if (!MissingCasesInEnumSwitch.isDefaultCase(caseTree)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDefaultCase(CaseTree tree) {
        return tree.getExpression() == null;
    }
}

