/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@BugPattern(name="TypeParameterUnusedInFormals", summary="Declaring a type parameter that is only used in the return type is a misuse of generics: operations on the type parameter are unchecked, it hides unsafe casts at invocations of the method, and it interacts badly with method overload resolution. NOTE: correcting this issue is often an incompatible API change; you should check that all dependent code still compiles succesfully.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.MATURE)
public class TypeParameterUnusedInFormals
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Type.TypeVar retType;
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(tree);
        if (methodSymbol == null) {
            return Description.NO_MATCH;
        }
        switch (methodSymbol.getReturnType().getKind()) {
            case TYPEVAR: {
                retType = (Type.TypeVar)methodSymbol.getReturnType();
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        if (retType.bound != null && TypeParameterFinder.visit(retType.bound).contains(retType)) {
            return Description.NO_MATCH;
        }
        for (Symbol.VarSymbol formalParam : methodSymbol.getParameters()) {
            if (!TypeParameterFinder.visit(formalParam.type).contains(retType)) continue;
            return Description.NO_MATCH;
        }
        return this.attemptFix(retType, tree, state);
    }

    private Description attemptFix(Type.TypeVar retType, MethodTree tree, VisitorState state) {
        String source = state.getSourceForNode((JCTree)((Object)tree));
        if (source == null) {
            return this.describeMatch(tree);
        }
        int paramIndex = -1;
        for (int idx = 0; idx < tree.getTypeParameters().size(); ++idx) {
            if (!((JCTree.JCTypeParameter)tree.getTypeParameters().get((int)idx)).type.equals(retType)) continue;
            paramIndex = idx;
            break;
        }
        if (paramIndex == -1) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix = this.removeTypeParam(paramIndex, tree.getTypeParameters(), state, fix);
        String qualifiedName = retType.bound != null ? retType.bound.toString() : "Object";
        String newType = (String)Iterables.getLast((Iterable)Splitter.on((char)'.').split((CharSequence)qualifiedName));
        TypeParameterUnusedInFormals.rewriteTypeUsages(retType, tree.getBody(), newType, fix, state);
        TypeParameterUnusedInFormals.rewriteTypeUsages(retType, tree.getReturnType(), newType, fix, state);
        return this.describeMatch(tree, fix.build());
    }

    private SuggestedFix.Builder removeTypeParam(int paramIndex, List<? extends TypeParameterTree> tyParams, VisitorState state, SuggestedFix.Builder fix) {
        String replacement;
        JCTree typeParam = (JCTree)((Object)tyParams.get(paramIndex));
        boolean isFirst = paramIndex == 0;
        boolean isLast = paramIndex == tyParams.size() - 1;
        int startDeletion = isFirst ? typeParam.getStartPosition() : state.getEndPosition((JCTree)((Object)tyParams.get(paramIndex - 1)));
        int endDeletion = isLast ? state.getEndPosition(typeParam) : ((JCTree)((Object)tyParams.get(paramIndex + 1))).getStartPosition();
        String string = replacement = isFirst || isLast ? "" : ", ";
        if (isFirst && isLast) {
            --startDeletion;
            endDeletion += 2;
        }
        fix = fix.replace(startDeletion, endDeletion, replacement);
        return fix;
    }

    private static void rewriteTypeUsages(final Type.TypeVar retType, Tree tree, final String newType, final SuggestedFix.Builder fix, final VisitorState state) {
        if (tree == null) {
            return;
        }
        ((JCTree)tree).accept(new TreeScanner(){

            @Override
            public void visitIdent(JCTree.JCIdent node) {
                if (retType.tsym.equals(node.sym)) {
                    fix.replace(node, newType);
                }
            }

            @Override
            public void visitTypeCast(JCTree.JCTypeCast node) {
                if (ASTHelpers.isSameType(retType.tsym.type, node.type.tsym.type, state) && newType.equals("Object")) {
                    fix.replace(node, state.getSourceForNode(node.getExpression()).toString());
                } else {
                    super.visitTypeCast(node);
                }
            }
        });
    }

    private static class TypeParameterFinder
    extends Types.DefaultTypeVisitor<Void, Void> {
        private Set<Type.TypeVar> seen = new HashSet<Type.TypeVar>();

        private TypeParameterFinder() {
        }

        static Set<Type.TypeVar> visit(Type type) {
            TypeParameterFinder visitor = new TypeParameterFinder();
            type.accept(visitor, null);
            return visitor.seen;
        }

        @Override
        public Void visitClassType(Type.ClassType type, Void unused) {
            if (type instanceof Type.IntersectionClassType) {
                this.visitIntersectionClassType((Type.IntersectionClassType)type);
            } else {
                for (Type t : type.getTypeArguments()) {
                    t.accept(this, null);
                }
            }
            return null;
        }

        public void visitIntersectionClassType(Type.IntersectionClassType type) {
            for (Type component : type.getComponents()) {
                component.accept(this, null);
            }
        }

        @Override
        public Void visitWildcardType(Type.WildcardType type, Void unused) {
            if (type.getSuperBound() != null) {
                type.getSuperBound().accept(this, null);
            }
            if (type.getExtendsBound() != null) {
                type.getExtendsBound().accept(this, null);
            }
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType type, Void unused) {
            type.elemtype.accept(this, null);
            return null;
        }

        @Override
        public Void visitTypeVar(Type.TypeVar type, Void unused) {
            if (!this.seen.add(type)) {
                return null;
            }
            if (type.bound != null) {
                type.bound.accept(this, null);
            }
            return null;
        }

        @Override
        public Void visitType(Type type, Void unused) {
            return null;
        }
    }
}

