/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByBinder;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.IllegalGuardedBy;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import javax.lang.model.element.ElementKind;

public class GuardedBySymbolResolver
implements GuardedByBinder.Resolver {
    private final Symbol.ClassSymbol enclosingClass;
    private final Tree decl;
    private final JCTree.JCCompilationUnit compilationUnit;
    private final Context context;
    private final Types types;

    public static GuardedBySymbolResolver from(Tree tree, VisitorState visitorState) {
        return GuardedBySymbolResolver.from((Symbol.ClassSymbol)ASTHelpers.getSymbol((Tree)tree).owner, visitorState.getPath().getCompilationUnit(), visitorState.context, tree);
    }

    public static GuardedBySymbolResolver from(Symbol.ClassSymbol owner, CompilationUnitTree compilationUnit, Context context, Tree leaf) {
        return new GuardedBySymbolResolver(owner, compilationUnit, context, leaf);
    }

    private GuardedBySymbolResolver(Symbol.ClassSymbol enclosingClass, CompilationUnitTree compilationUnit, Context context, Tree leaf) {
        this.compilationUnit = (JCTree.JCCompilationUnit)compilationUnit;
        this.enclosingClass = enclosingClass;
        this.context = context;
        this.types = Types.instance(context);
        this.decl = leaf;
    }

    public Context context() {
        return this.context;
    }

    public Symbol.ClassSymbol enclosingClass() {
        return this.enclosingClass;
    }

    @Override
    public Symbol resolveIdentifier(IdentifierTree node) {
        String name = node.getName().toString();
        if (name.equals("this")) {
            return this.enclosingClass;
        }
        if (name.equals("itself")) {
            if (this.decl instanceof VariableTree) {
                name = ((VariableTree)this.decl).getName().toString();
            } else if (this.decl instanceof MethodTree) {
                name = ((MethodTree)this.decl).getName().toString();
            } else {
                throw new IllegalGuardedBy(this.decl.getClass().toString());
            }
            return this.getField(this.enclosingClass, name);
        }
        Symbol.VarSymbol field = this.getField(this.enclosingClass, name);
        if (field != null) {
            return field;
        }
        Symbol type = this.resolveType(name, SearchSuperTypes.YES);
        if (type != null) {
            return type;
        }
        throw new IllegalGuardedBy(name);
    }

    @Override
    public Symbol.MethodSymbol resolveMethod(MethodInvocationTree node, javax.lang.model.element.Name name) {
        return this.getMethod(this.enclosingClass, name.toString());
    }

    @Override
    public Symbol.MethodSymbol resolveMethod(MethodInvocationTree node, GuardedByExpression base, javax.lang.model.element.Name identifier) {
        Symbol.TypeSymbol baseSym = base.kind() == GuardedByExpression.Kind.THIS ? this.enclosingClass : base.type().asElement();
        return this.getMethod(baseSym, identifier.toString());
    }

    private Symbol.MethodSymbol getMethod(Symbol classSymbol, String name) {
        return this.getMember(Symbol.MethodSymbol.class, ElementKind.METHOD, classSymbol, name);
    }

    @Override
    public Symbol resolveSelect(GuardedByExpression base, MemberSelectTree node) {
        Symbol.TypeSymbol baseSym = base.kind() == GuardedByExpression.Kind.THIS ? this.enclosingClass : base.type().asElement();
        return this.getField(baseSym, node.getIdentifier().toString());
    }

    private Symbol.VarSymbol getField(Symbol classSymbol, String name) {
        return this.getMember(Symbol.VarSymbol.class, ElementKind.FIELD, classSymbol, name);
    }

    private <T extends Symbol> T getMember(Class<T> type, ElementKind kind, Symbol classSymbol, String name) {
        T sym;
        if (classSymbol.type == null) {
            return null;
        }
        for (Type t : this.types.closure(classSymbol.type)) {
            Scope.WriteableScope scope = t.tsym.members();
            for (Symbol sym2 : scope.getSymbolsByName(this.getName(name))) {
                if (!sym2.getKind().equals((Object)kind)) continue;
                return (T)((Symbol)type.cast(sym2));
            }
        }
        if (classSymbol.owner != null && classSymbol != classSymbol.owner && classSymbol.owner instanceof Symbol.ClassSymbol && (sym = this.getMember(type, kind, classSymbol.owner, name)) != null) {
            return sym;
        }
        if (classSymbol.hasOuterInstance() && (sym = this.getMember(type, kind, classSymbol.type.getEnclosingType().asElement(), name)) != null) {
            return sym;
        }
        return null;
    }

    @Override
    public Symbol resolveTypeLiteral(ExpressionTree expr) {
        IllegalGuardedBy.checkGuardedBy(expr instanceof IdentifierTree, "bad type literal: %s", expr);
        IdentifierTree ident = (IdentifierTree)expr;
        Symbol type = this.resolveType(ident.getName().toString(), SearchSuperTypes.YES);
        if (type instanceof Symbol.ClassSymbol) {
            return type;
        }
        return null;
    }

    private Symbol resolveType(String name, SearchSuperTypes searchSuperTypes) {
        Symbol type = null;
        if (searchSuperTypes == SearchSuperTypes.YES) {
            type = this.getSuperType(this.enclosingClass, name);
        }
        if (this.enclosingClass.getSimpleName().contentEquals(name)) {
            type = this.enclosingClass;
        }
        if (type == null) {
            type = this.getLexicallyEnclosing(this.enclosingClass, name);
        }
        if (type == null) {
            type = this.attribIdent(name);
        }
        IllegalGuardedBy.checkGuardedBy(!(type instanceof Symbol.PackageSymbol), "All we could find for '%s' was a package symbol.", name);
        return type;
    }

    private Symbol getSuperType(Symbol symbol, String name) {
        for (Type t : this.types.closure(symbol.type)) {
            if (!((Name)t.asElement().getSimpleName()).contentEquals(name)) continue;
            return t.asElement();
        }
        return null;
    }

    private Symbol getLexicallyEnclosing(Symbol.ClassSymbol symbol, String name) {
        Symbol current = symbol.owner;
        while (true) {
            if (current == null || current.getSimpleName().contentEquals(name)) {
                return current;
            }
            if (current == current.owner || !(current.owner instanceof Symbol.ClassSymbol)) break;
            current = current.owner;
        }
        return null;
    }

    private Symbol attribIdent(String name) {
        Attr attr = Attr.instance(this.context);
        TreeMaker tm = TreeMaker.instance(this.context);
        return attr.attribIdent((JCTree)tm.Ident(this.getName(name)), this.compilationUnit);
    }

    private Name getName(String name) {
        return Names.instance(this.context).fromString(name);
    }

    @Override
    public Symbol resolveEnclosingClass(ExpressionTree expr) {
        IllegalGuardedBy.checkGuardedBy(expr instanceof IdentifierTree, "bad type literal: %s", expr);
        IdentifierTree ident = (IdentifierTree)expr;
        Symbol type = this.resolveType(ident.getName().toString(), SearchSuperTypes.NO);
        if (type instanceof Symbol.ClassSymbol) {
            return type;
        }
        return null;
    }

    private static enum SearchSuperTypes {
        YES,
        NO;

    }
}

