/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.NonNull;
import com.android.builder.model.ApiVersion;
import com.android.builder.testing.api.DeviceConnector;
import com.android.sdklib.SdkVersionInfo;
import com.android.utils.ILogger;

public class InstallUtils {
    public static boolean checkDeviceApiLevel(@NonNull DeviceConnector device, @NonNull ApiVersion appMinSdkVersion, @NonNull ILogger logger, @NonNull String projectName, @NonNull String variantName) {
        int deviceApiLevel = device.getApiLevel();
        if (deviceApiLevel == 0) {
            logger.info("Skipping device '%1$s' for '%2$s:%3$s': Unknown API Level", new Object[]{device.getName(), projectName, variantName});
            return false;
        }
        int minSdkVersion = appMinSdkVersion.getApiLevel();
        if (appMinSdkVersion.getCodename() != null) {
            String deviceCodeName = device.getApiCodeName();
            if (deviceCodeName != null) {
                if (deviceCodeName.equals(appMinSdkVersion.getCodename())) {
                    logger.info("Skipping device '%1$s', due to different API preview '%2$s' and '%3$s'", new Object[]{device.getName(), deviceCodeName, appMinSdkVersion.getCodename()});
                    return false;
                }
            } else {
                minSdkVersion = SdkVersionInfo.getApiByBuildCode((String)appMinSdkVersion.getCodename(), (boolean)true);
                if (minSdkVersion > deviceApiLevel) {
                    logger.info("Skipping device '%s' for '%s:%s'", new Object[]{device.getName(), projectName, variantName});
                    return false;
                }
            }
        } else if (minSdkVersion > deviceApiLevel) {
            logger.info("Skipping device '%s' for '%s:%s'", new Object[]{device.getName(), projectName, variantName});
            return false;
        }
        return true;
    }
}

