/*
 * Decompiled with CFR 0.152.
 */
package android.databinding;

import android.databinding.cli.ProcessXmlOptions;
import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.util.L;
import android.databinding.tool.writer.JavaFileWriter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;

public class AndroidDataBinding {
    public static void main(String[] args) throws Throwable {
        ProcessXmlOptions processXmlOptions = new ProcessXmlOptions();
        JCommander jCommander = new JCommander((Object)processXmlOptions);
        try {
            jCommander.parse(args);
        }
        catch (ParameterException ex) {
            jCommander.usage();
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        AndroidDataBinding.doRun(processXmlOptions);
    }

    public static void doRun(ProcessXmlOptions processXmlOptions) throws Throwable {
        System.out.println(processXmlOptions);
        LayoutXmlProcessor processor = AndroidDataBinding.createXmlProcessor(processXmlOptions);
        LayoutXmlProcessor.ResourceInput input = new LayoutXmlProcessor.ResourceInput(false, processXmlOptions.getResInput(), processXmlOptions.getResOutput());
        L.setDebugLog((boolean)true);
        processor.processResources(input);
        if (processXmlOptions.shouldZipLayoutInfo()) {
            File outZip = new File(processXmlOptions.getLayoutInfoOutput(), "layout-info.zip");
            FileUtils.forceMkdir((File)processXmlOptions.getLayoutInfoOutput());
            ZipFileWriter zfw = new ZipFileWriter(outZip);
            processor.writeLayoutInfoFiles(processXmlOptions.getLayoutInfoOutput(), (JavaFileWriter)zfw);
            zfw.close();
        } else {
            processor.writeLayoutInfoFiles(processXmlOptions.getLayoutInfoOutput());
        }
    }

    private static LayoutXmlProcessor createXmlProcessor(ProcessXmlOptions processXmlOptions) {
        ExecFileWriter fileWriter = new ExecFileWriter(processXmlOptions.getResOutput());
        return new LayoutXmlProcessor(processXmlOptions.getAppId(), (JavaFileWriter)fileWriter, processXmlOptions.getMinSdk(), processXmlOptions.isLibrary(), (LayoutXmlProcessor.OriginalFileLookup)new MyFileLookup());
    }

    static class ExecFileWriter
    extends JavaFileWriter {
        private final File base;

        public ExecFileWriter(File base) {
            this.base = base;
        }

        public void writeToFile(String canonicalName, String contents) {
            String asPath = canonicalName.replace('.', '/');
            File f = new File(this.base, asPath + ".java");
            this.writeToFile(f, contents);
        }
    }

    static class ZipFileWriter
    extends JavaFileWriter {
        ZipOutputStream zos;

        public ZipFileWriter(File outZipFile) throws FileNotFoundException {
            FileOutputStream fos = new FileOutputStream(outZipFile);
            this.zos = new ZipOutputStream(fos);
        }

        public void writeToFile(String canonicalName, String contents) {
            throw new RuntimeException("this is only for files not classes");
        }

        public void writeToFile(File exactPath, String contents) {
            ZipEntry entry = new ZipEntry(exactPath.getName());
            try {
                this.zos.putNextEntry(entry);
                this.zos.write(contents.getBytes(Charsets.UTF_16));
                this.zos.closeEntry();
            }
            catch (Throwable t) {
                L.e((Throwable)t, (String)"cannot write zip file. Filed on %s", (Object[])new Object[]{exactPath});
            }
        }

        public void close() throws IOException {
            this.zos.close();
        }
    }

    static class MyFileLookup
    implements LayoutXmlProcessor.OriginalFileLookup {
        MyFileLookup() {
        }

        public File getOriginalFileFor(File file) {
            return file;
        }
    }
}

