/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.apk;

import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ApkUtils {
    private ApkUtils() {
    }

    public static ZipSections findZipSections(DataSource dataSource) throws IOException, ZipFormatException {
        Pair<ByteBuffer, Long> pair = ZipUtils.findZipEndOfCentralDirectoryRecord(dataSource);
        if (pair == null) {
            throw new ZipFormatException("ZIP End of Central Directory record not found");
        }
        ByteBuffer byteBuffer = pair.getFirst();
        long l = pair.getSecond();
        if (ZipUtils.isZip64EndOfCentralDirectoryLocatorPresent(dataSource, l)) {
            throw new ZipFormatException("ZIP64 APK not supported");
        }
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long l2 = ZipUtils.getZipEocdCentralDirectoryOffset(byteBuffer);
        if (l2 >= l) {
            throw new ZipFormatException("ZIP Central Directory start offset out of range: " + l2 + ". ZIP End of Central Directory offset: " + l);
        }
        long l3 = ZipUtils.getZipEocdCentralDirectorySizeBytes(byteBuffer);
        long l4 = l2 + l3;
        if (l4 > l) {
            throw new ZipFormatException("ZIP Central Directory overlaps with End of Central Directory. CD end: " + l4 + ", EoCD start: " + l);
        }
        int n = ZipUtils.getZipEocdCentralDirectoryTotalRecordCount(byteBuffer);
        return new ZipSections(l2, l3, n, l, byteBuffer);
    }

    public static void setZipEocdCentralDirectoryOffset(ByteBuffer byteBuffer, long l) {
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        ZipUtils.setZipEocdCentralDirectoryOffset(byteBuffer2, l);
    }

    public static class ZipSections {
        private final long mCentralDirectoryOffset;
        private final long mCentralDirectorySizeBytes;
        private final int mCentralDirectoryRecordCount;
        private final long mEocdOffset;
        private final ByteBuffer mEocd;

        public ZipSections(long l, long l2, int n, long l3, ByteBuffer byteBuffer) {
            this.mCentralDirectoryOffset = l;
            this.mCentralDirectorySizeBytes = l2;
            this.mCentralDirectoryRecordCount = n;
            this.mEocdOffset = l3;
            this.mEocd = byteBuffer;
        }

        public long getZipCentralDirectoryOffset() {
            return this.mCentralDirectoryOffset;
        }

        public long getZipCentralDirectorySizeBytes() {
            return this.mCentralDirectorySizeBytes;
        }

        public int getZipCentralDirectoryRecordCount() {
            return this.mCentralDirectoryRecordCount;
        }

        public long getZipEndOfCentralDirectoryOffset() {
            return this.mEocdOffset;
        }

        public ByteBuffer getZipEndOfCentralDirectory() {
            return this.mEocd;
        }
    }
}

