/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapEntrySetCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAllPartitionsMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.EntrySetOperationFactory;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapEntrySetMessageTask
extends AbstractAllPartitionsMessageTask<MapEntrySetCodec.RequestParameters> {
    public MapEntrySetMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new EntrySetOperationFactory(((MapEntrySetCodec.RequestParameters)this.parameters).name);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        HashMap<Data, Data> dataMap = new HashMap<Data, Data>();
        MapService service = (MapService)this.getService("hz:impl:mapService");
        for (Object result : map.values()) {
            Set<Map.Entry<Data, Data>> entries = ((MapEntrySet)service.getMapServiceContext().toObject(result)).getEntrySet();
            for (Map.Entry<Data, Data> entry : entries) {
                dataMap.put(entry.getKey(), entry.getValue());
            }
        }
        return dataMap;
    }

    @Override
    protected MapEntrySetCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapEntrySetCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapEntrySetCodec.encodeResponse((Map)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapEntrySetCodec.RequestParameters)this.parameters).name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapEntrySetCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "entrySet";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

