% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash_sentiment_emojis.R
\docType{data}
\name{emojis_sentiment}
\alias{emojis_sentiment}
\title{Emoji Sentiment Data}
\format{
A data frame with 734 rows and 10 variables
}
\usage{
data(emojis_sentiment)
}
\description{
A slightly modified version of Novak, Smailovic, Sluban, & Mozetic's (2015)
emoji sentiment data.  The authors used Twitter data and 83 coders to rate
each of the the emoji uses as negative, neutral, or positive to form a
probability distribution (\eqn{p_{-}, p_{0}, p_{+}})
(\url{https://journals.plos.org/plosone/article/file?id=10.1371/journal.pone.0144296&type=printable})..
The sentiment score is calculated via the authors' formula:
\eqn{\frac{\sum{(-1*p_{-}, 0 * p_{0}, p_{+}})}{\sum{(p_{-}, p_{0}, p_{+}})}}.
}
\details{
\itemize{
  \item byte. Byte code representation of emojis
  \item name. Description of the emoji
  \item id. An id for the emoji
  \item sentiment. Sentiment score of the emoji
  \item polarity. The direction of the sentiment
  \item category. A category for the emoji
  \item frequency. How often the emoji occurred in Novak et. al.'s (2015) data
  \item negative. How often Novak et al. (2015) observed the emoji being used negatively
  \item neutral. How often Novak et al. (2015) observed the emoji being used neutrally
  \item positive. How often Novak et al. (2015) observed the emoji being used positively
}
}
\section{Copyright}{
 2015 - Department of Knowledge Technologies
}

\references{
Novak, P. K., Smailovic, J., Sluban, B., and Mozetic, I. (2015)
Sentiment of emojis. PLoS ONE 10(12). doi:10.1371/journal.pone.0144296 \cr \cr
http://kt.ijs.si/data/Emoji_sentiment_ranking/index.html \cr \cr
https://creativecommons.org/licenses/by-sa/4.0/
}
\keyword{datasets}
