% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash_grady_pos.R
\docType{data}
\name{hash_grady_pos}
\alias{hash_grady_pos}
\alias{grady_pos_feature}
\title{Grady Ward's Moby Parts of Speech}
\format{
A data frame with 246,691 rows and 3 variables
}
\source{
Originally downloaded from: http://icon.shef.ac.uk/Moby
}
\usage{
data(hash_grady_pos)

grady_pos_feature(data)
}
\arguments{
\item{data}{This should be \code{lexicon::hash_grady_pos}.}
}
\description{
A dataset containing a hash lookup of Grady Ward's parts of speech from the
Moby project.  The words with non-ASCII characters removed.

\code{grady_pos_feature} - A function for augmenting \code{hash_grady_pos}
with 3 additional columns: (1) \code{n_pos} - the number of parts of speech
a word has, (2) \code{space} - logical; indicating if a word contains a space,
& (3) \code{primary} - logical; indicating if this is the most likely part of
speech given the word.
}
\details{
\itemize{
  \item word. The word.
  \item pos. The part of speech; one of :\code{Adjective}, \code{Adverb}, \code{Conjunction}, \code{Definite Article}, \code{Interjection}, \code{Noun}, \code{Noun Phrase}, \code{Plural}, \code{Preposition}, \code{Pronoun}, \code{Verb (intransitive)}, \code{Verb (transitive)}, or \code{Verb (usu participle)}.  Note that the first part of speech for a word is its primary use; all other uses are secondary.
}
}
\examples{
\dontrun{
library(data.table)

hash_grady_pos <- grady_pos_feature(hash_grady_pos)
hash_grady_pos['dog']
hash_grady_pos[primary == TRUE, ]
hash_grady_pos[primary == TRUE & space == FALSE, ]
}
}
\keyword{datasets}
