Documents Index
===============

Intro to .NET Core
==================

.NET Core is a self-contained .NET runtime and framework that implements ECMA 335. It can be (and has been) ported to multiple architectures and platforms. It support a variety of installation options, having no specific deployment requirements itself.

Learn about .NET Core
====================

- [[WIP] Official .NET Core Docs](http://dotnet.readthedocs.org)

Get .NET Core
=============

- [Get .NET Core DNX SDK on Windows](https://github.com/dotnet/coreclr/blob/master/Documentation/install/get-dotnetcore-dnx-windows.md)
- [Get .NET Core DNX SDK on OS X](https://github.com/dotnet/coreclr/blob/master/Documentation/install/get-dotnetcore-dnx-osx.md)
- [Get .NET Core DNX SDK on Linux](https://github.com/dotnet/coreclr/blob/master/Documentation/install/get-dotnetcore-dnx-linux.md)
- [Get .NET Core (Raw) on Windows](https://github.com/dotnet/coreclr/blob/master/Documentation/install/get-dotnetcore-windows.md)

Project Docs
============

- [Developer Guide](project-docs/developer-guide.md)
- [Performance Testing](project-docs/performance-tests.md)
- [Project priorities](https://github.com/dotnet/coreclr/blob/master/Documentation/project-docs/project-priorities.md)
- [Contributing to CoreFX](project-docs/contributing.md)
- [Contributing to .NET Core](https://github.com/dotnet/coreclr/blob/master/Documentation/project-docs/contributing.md)
- [Contributing Workflow](https://github.com/dotnet/coreclr/blob/master/Documentation/project-docs/contributing-workflow.md)
- [Issue Guide](project-docs/issue-guide.md)
- [Branching Guide](project-docs/branching-guide.md)
- [API Review Process](project-docs/api-review-process.md)
- [Strong Name Signing](project-docs/strong-name-signing.md)
- [Open Source Signing](project-docs/oss-signing.md)
- [Repo Organization](project-docs/repo-organization.md)

Coding Guidelines
=================

- [C# coding style](coding-guidelines/coding-style.md)
- [Framework Design Guidelines](coding-guidelines/framework-design-guidelines-digest.md)
- [Cross-Platform Guidelines](coding-guidelines/cross-platform-guidelines.md)
- [Performance Guidelines](coding-guidelines/performance-guidelines.md)
- [Interop Guidelines](coding-guidelines/interop-guidelines.md)
- [Breaking Changes](coding-guidelines/breaking-changes.md)
- [Breaking Change Definitions](coding-guidelines/breaking-change-definitions.md)
- [Breaking Change Rules](coding-guidelines/breaking-change-rules.md)

Building from Source
====================

- [Building CoreFX on FreeBSD, Linux and OS X](building/unix-instructions.md)
- [Code Coverage](building/code-coverage.md)

Other Information
=================

- [CoreCLR Repo documentation](https://github.com/dotnet/coreclr/tree/master/Documentation)
- [Porting to .NET Core](project-docs/support-dotnet-core-instructions.md)
- [.NET Standards (Ecma)](https://github.com/dotnet/coreclr/blob/master/Documentation/project-docs/dotnet-standards.md)
- [MSDN Entry for the CLR](http://msdn.microsoft.com/library/8bs2ecf4.aspx)
- [Wikipedia Entry for the CLR](http://en.wikipedia.org/wiki/Common_Language_Runtime)
