// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/m3db/m3/src/cluster/generated/proto/placementpb/placement.proto

// Copyright (c) 2018 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/*
	Package placementpb is a generated protocol buffer package.

	It is generated from these files:
		github.com/m3db/m3/src/cluster/generated/proto/placementpb/placement.proto

	It has these top-level messages:
		Placement
		Instance
		Shard
		PlacementSnapshots
*/
package placementpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type ShardState int32

const (
	ShardState_INITIALIZING ShardState = 0
	ShardState_AVAILABLE    ShardState = 1
	ShardState_LEAVING      ShardState = 2
)

var ShardState_name = map[int32]string{
	0: "INITIALIZING",
	1: "AVAILABLE",
	2: "LEAVING",
}
var ShardState_value = map[string]int32{
	"INITIALIZING": 0,
	"AVAILABLE":    1,
	"LEAVING":      2,
}

func (x ShardState) String() string {
	return proto.EnumName(ShardState_name, int32(x))
}
func (ShardState) EnumDescriptor() ([]byte, []int) { return fileDescriptorPlacement, []int{0} }

type Placement struct {
	Instances     map[string]*Instance `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	ReplicaFactor uint32               `protobuf:"varint,2,opt,name=replica_factor,json=replicaFactor,proto3" json:"replica_factor,omitempty"`
	NumShards     uint32               `protobuf:"varint,3,opt,name=num_shards,json=numShards,proto3" json:"num_shards,omitempty"`
	IsSharded     bool                 `protobuf:"varint,4,opt,name=is_sharded,json=isSharded,proto3" json:"is_sharded,omitempty"`
	// cutover_time is the placement-level cutover time and determines when the clients
	// watching the placement deems the placement as "in effect" and can use it to determine
	// shard placement.
	CutoverTime int64 `protobuf:"varint,5,opt,name=cutover_time,json=cutoverTime,proto3" json:"cutover_time,omitempty"`
	IsMirrored  bool  `protobuf:"varint,6,opt,name=is_mirrored,json=isMirrored,proto3" json:"is_mirrored,omitempty"`
	// max_shard_set_id stores the maximum shard set id used to guarantee unique
	// shard set id generations across placement changes.
	MaxShardSetId uint32 `protobuf:"varint,7,opt,name=max_shard_set_id,json=maxShardSetId,proto3" json:"max_shard_set_id,omitempty"`
}

func (m *Placement) Reset()                    { *m = Placement{} }
func (m *Placement) String() string            { return proto.CompactTextString(m) }
func (*Placement) ProtoMessage()               {}
func (*Placement) Descriptor() ([]byte, []int) { return fileDescriptorPlacement, []int{0} }

func (m *Placement) GetInstances() map[string]*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *Placement) GetReplicaFactor() uint32 {
	if m != nil {
		return m.ReplicaFactor
	}
	return 0
}

func (m *Placement) GetNumShards() uint32 {
	if m != nil {
		return m.NumShards
	}
	return 0
}

func (m *Placement) GetIsSharded() bool {
	if m != nil {
		return m.IsSharded
	}
	return false
}

func (m *Placement) GetCutoverTime() int64 {
	if m != nil {
		return m.CutoverTime
	}
	return 0
}

func (m *Placement) GetIsMirrored() bool {
	if m != nil {
		return m.IsMirrored
	}
	return false
}

func (m *Placement) GetMaxShardSetId() uint32 {
	if m != nil {
		return m.MaxShardSetId
	}
	return 0
}

type Instance struct {
	Id             string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	IsolationGroup string   `protobuf:"bytes,2,opt,name=isolation_group,json=isolationGroup,proto3" json:"isolation_group,omitempty"`
	Zone           string   `protobuf:"bytes,3,opt,name=zone,proto3" json:"zone,omitempty"`
	Weight         uint32   `protobuf:"varint,4,opt,name=weight,proto3" json:"weight,omitempty"`
	Endpoint       string   `protobuf:"bytes,5,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Shards         []*Shard `protobuf:"bytes,6,rep,name=shards" json:"shards,omitempty"`
	ShardSetId     uint32   `protobuf:"varint,7,opt,name=shard_set_id,json=shardSetId,proto3" json:"shard_set_id,omitempty"`
	Hostname       string   `protobuf:"bytes,8,opt,name=hostname,proto3" json:"hostname,omitempty"`
	Port           uint32   `protobuf:"varint,9,opt,name=port,proto3" json:"port,omitempty"`
}

func (m *Instance) Reset()                    { *m = Instance{} }
func (m *Instance) String() string            { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()               {}
func (*Instance) Descriptor() ([]byte, []int) { return fileDescriptorPlacement, []int{1} }

func (m *Instance) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Instance) GetIsolationGroup() string {
	if m != nil {
		return m.IsolationGroup
	}
	return ""
}

func (m *Instance) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Instance) GetWeight() uint32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

func (m *Instance) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Instance) GetShards() []*Shard {
	if m != nil {
		return m.Shards
	}
	return nil
}

func (m *Instance) GetShardSetId() uint32 {
	if m != nil {
		return m.ShardSetId
	}
	return 0
}

func (m *Instance) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *Instance) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

type Shard struct {
	Id       uint32     `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	State    ShardState `protobuf:"varint,2,opt,name=state,proto3,enum=placementpb.ShardState" json:"state,omitempty"`
	SourceId string     `protobuf:"bytes,3,opt,name=source_id,json=sourceId,proto3" json:"source_id,omitempty"`
	// Shard-level cutover and cutoff times determine when the shards have been cut over or
	// cut off from the source instance to the destination instance. The placement-level
	// cutover times are usually (but not required to be) earlier than shard-level cutover
	// times if the clients watching the placement need to send traffic to the shards before
	// they are ready to cut over or after they are ready to cut off (e.g., for warmup purposes).
	CutoverNanos int64 `protobuf:"varint,4,opt,name=cutover_nanos,json=cutoverNanos,proto3" json:"cutover_nanos,omitempty"`
	CutoffNanos  int64 `protobuf:"varint,5,opt,name=cutoff_nanos,json=cutoffNanos,proto3" json:"cutoff_nanos,omitempty"`
}

func (m *Shard) Reset()                    { *m = Shard{} }
func (m *Shard) String() string            { return proto.CompactTextString(m) }
func (*Shard) ProtoMessage()               {}
func (*Shard) Descriptor() ([]byte, []int) { return fileDescriptorPlacement, []int{2} }

func (m *Shard) GetId() uint32 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Shard) GetState() ShardState {
	if m != nil {
		return m.State
	}
	return ShardState_INITIALIZING
}

func (m *Shard) GetSourceId() string {
	if m != nil {
		return m.SourceId
	}
	return ""
}

func (m *Shard) GetCutoverNanos() int64 {
	if m != nil {
		return m.CutoverNanos
	}
	return 0
}

func (m *Shard) GetCutoffNanos() int64 {
	if m != nil {
		return m.CutoffNanos
	}
	return 0
}

type PlacementSnapshots struct {
	Snapshots []*Placement `protobuf:"bytes,1,rep,name=snapshots" json:"snapshots,omitempty"`
}

func (m *PlacementSnapshots) Reset()                    { *m = PlacementSnapshots{} }
func (m *PlacementSnapshots) String() string            { return proto.CompactTextString(m) }
func (*PlacementSnapshots) ProtoMessage()               {}
func (*PlacementSnapshots) Descriptor() ([]byte, []int) { return fileDescriptorPlacement, []int{3} }

func (m *PlacementSnapshots) GetSnapshots() []*Placement {
	if m != nil {
		return m.Snapshots
	}
	return nil
}

func init() {
	proto.RegisterType((*Placement)(nil), "placementpb.Placement")
	proto.RegisterType((*Instance)(nil), "placementpb.Instance")
	proto.RegisterType((*Shard)(nil), "placementpb.Shard")
	proto.RegisterType((*PlacementSnapshots)(nil), "placementpb.PlacementSnapshots")
	proto.RegisterEnum("placementpb.ShardState", ShardState_name, ShardState_value)
}
func (m *Placement) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Placement) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for k, _ := range m.Instances {
			dAtA[i] = 0xa
			i++
			v := m.Instances[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovPlacement(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovPlacement(uint64(len(k))) + msgSize
			i = encodeVarintPlacement(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintPlacement(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintPlacement(dAtA, i, uint64(v.Size()))
				n1, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n1
			}
		}
	}
	if m.ReplicaFactor != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.ReplicaFactor))
	}
	if m.NumShards != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.NumShards))
	}
	if m.IsSharded {
		dAtA[i] = 0x20
		i++
		if m.IsSharded {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.CutoverTime != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.CutoverTime))
	}
	if m.IsMirrored {
		dAtA[i] = 0x30
		i++
		if m.IsMirrored {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.MaxShardSetId != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.MaxShardSetId))
	}
	return i, nil
}

func (m *Instance) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Instance) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.IsolationGroup) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(len(m.IsolationGroup)))
		i += copy(dAtA[i:], m.IsolationGroup)
	}
	if len(m.Zone) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(len(m.Zone)))
		i += copy(dAtA[i:], m.Zone)
	}
	if m.Weight != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.Weight))
	}
	if len(m.Endpoint) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(len(m.Endpoint)))
		i += copy(dAtA[i:], m.Endpoint)
	}
	if len(m.Shards) > 0 {
		for _, msg := range m.Shards {
			dAtA[i] = 0x32
			i++
			i = encodeVarintPlacement(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ShardSetId != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.ShardSetId))
	}
	if len(m.Hostname) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(len(m.Hostname)))
		i += copy(dAtA[i:], m.Hostname)
	}
	if m.Port != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.Port))
	}
	return i, nil
}

func (m *Shard) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Shard) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.Id))
	}
	if m.State != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.State))
	}
	if len(m.SourceId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(len(m.SourceId)))
		i += copy(dAtA[i:], m.SourceId)
	}
	if m.CutoverNanos != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.CutoverNanos))
	}
	if m.CutoffNanos != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.CutoffNanos))
	}
	return i, nil
}

func (m *PlacementSnapshots) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PlacementSnapshots) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Snapshots) > 0 {
		for _, msg := range m.Snapshots {
			dAtA[i] = 0xa
			i++
			i = encodeVarintPlacement(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeVarintPlacement(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Placement) Size() (n int) {
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for k, v := range m.Instances {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovPlacement(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovPlacement(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovPlacement(uint64(mapEntrySize))
		}
	}
	if m.ReplicaFactor != 0 {
		n += 1 + sovPlacement(uint64(m.ReplicaFactor))
	}
	if m.NumShards != 0 {
		n += 1 + sovPlacement(uint64(m.NumShards))
	}
	if m.IsSharded {
		n += 2
	}
	if m.CutoverTime != 0 {
		n += 1 + sovPlacement(uint64(m.CutoverTime))
	}
	if m.IsMirrored {
		n += 2
	}
	if m.MaxShardSetId != 0 {
		n += 1 + sovPlacement(uint64(m.MaxShardSetId))
	}
	return n
}

func (m *Instance) Size() (n int) {
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovPlacement(uint64(l))
	}
	l = len(m.IsolationGroup)
	if l > 0 {
		n += 1 + l + sovPlacement(uint64(l))
	}
	l = len(m.Zone)
	if l > 0 {
		n += 1 + l + sovPlacement(uint64(l))
	}
	if m.Weight != 0 {
		n += 1 + sovPlacement(uint64(m.Weight))
	}
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovPlacement(uint64(l))
	}
	if len(m.Shards) > 0 {
		for _, e := range m.Shards {
			l = e.Size()
			n += 1 + l + sovPlacement(uint64(l))
		}
	}
	if m.ShardSetId != 0 {
		n += 1 + sovPlacement(uint64(m.ShardSetId))
	}
	l = len(m.Hostname)
	if l > 0 {
		n += 1 + l + sovPlacement(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovPlacement(uint64(m.Port))
	}
	return n
}

func (m *Shard) Size() (n int) {
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovPlacement(uint64(m.Id))
	}
	if m.State != 0 {
		n += 1 + sovPlacement(uint64(m.State))
	}
	l = len(m.SourceId)
	if l > 0 {
		n += 1 + l + sovPlacement(uint64(l))
	}
	if m.CutoverNanos != 0 {
		n += 1 + sovPlacement(uint64(m.CutoverNanos))
	}
	if m.CutoffNanos != 0 {
		n += 1 + sovPlacement(uint64(m.CutoffNanos))
	}
	return n
}

func (m *PlacementSnapshots) Size() (n int) {
	var l int
	_ = l
	if len(m.Snapshots) > 0 {
		for _, e := range m.Snapshots {
			l = e.Size()
			n += 1 + l + sovPlacement(uint64(l))
		}
	}
	return n
}

func sovPlacement(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozPlacement(x uint64) (n int) {
	return sovPlacement(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Placement) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlacement
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Placement: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Placement: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Instances == nil {
				m.Instances = make(map[string]*Instance)
			}
			var mapkey string
			var mapvalue *Instance
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPlacement
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlacement
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthPlacement
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPlacement
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthPlacement
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthPlacement
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Instance{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipPlacement(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthPlacement
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Instances[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaFactor", wireType)
			}
			m.ReplicaFactor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicaFactor |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumShards", wireType)
			}
			m.NumShards = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumShards |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsSharded", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsSharded = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CutoverTime", wireType)
			}
			m.CutoverTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CutoverTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsMirrored", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsMirrored = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxShardSetId", wireType)
			}
			m.MaxShardSetId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxShardSetId |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlacement(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlacement
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Instance) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlacement
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Instance: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Instance: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsolationGroup", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IsolationGroup = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Zone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Zone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			m.Weight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Weight |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Shards", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Shards = append(m.Shards, &Shard{})
			if err := m.Shards[len(m.Shards)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardSetId", wireType)
			}
			m.ShardSetId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ShardSetId |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlacement(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlacement
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Shard) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlacement
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Shard: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Shard: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (ShardState(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CutoverNanos", wireType)
			}
			m.CutoverNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CutoverNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CutoffNanos", wireType)
			}
			m.CutoffNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CutoffNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlacement(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlacement
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PlacementSnapshots) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlacement
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlacementSnapshots: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlacementSnapshots: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Snapshots", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Snapshots = append(m.Snapshots, &Placement{})
			if err := m.Snapshots[len(m.Snapshots)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlacement(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlacement
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPlacement(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPlacement
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthPlacement
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowPlacement
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipPlacement(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthPlacement = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPlacement   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("github.com/m3db/m3/src/cluster/generated/proto/placementpb/placement.proto", fileDescriptorPlacement)
}

var fileDescriptorPlacement = []byte{
	// 628 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x53, 0xdf, 0x6e, 0xd3, 0x3e,
	0x14, 0x5e, 0xd2, 0xb5, 0x6b, 0x4e, 0xd7, 0xfe, 0x2a, 0x4b, 0xbf, 0x11, 0x0d, 0x51, 0x4a, 0xd1,
	0x44, 0x35, 0x44, 0x23, 0x6d, 0x5c, 0xa0, 0xdd, 0x75, 0x68, 0x4c, 0x99, 0xca, 0x84, 0xdc, 0x69,
	0x17, 0xdc, 0x44, 0x6e, 0xe2, 0xb6, 0x16, 0x8d, 0x1d, 0xd9, 0xce, 0xd8, 0x78, 0x03, 0xee, 0x78,
	0x0f, 0x5e, 0x84, 0x4b, 0x1e, 0x01, 0x8d, 0x87, 0xe0, 0x16, 0xc5, 0x49, 0xfa, 0x47, 0xec, 0xee,
	0x9c, 0xef, 0x7c, 0xf6, 0xf9, 0xfc, 0xf9, 0x1c, 0xb8, 0x98, 0x31, 0x3d, 0x4f, 0x27, 0x83, 0x50,
	0xc4, 0x5e, 0x7c, 0x1c, 0x4d, 0xbc, 0xf8, 0xd8, 0x53, 0x32, 0xf4, 0xc2, 0x45, 0xaa, 0x34, 0x95,
	0xde, 0x8c, 0x72, 0x2a, 0x89, 0xa6, 0x91, 0x97, 0x48, 0xa1, 0x85, 0x97, 0x2c, 0x48, 0x48, 0x63,
	0xca, 0x75, 0x32, 0x59, 0xc5, 0x03, 0x53, 0x43, 0x8d, 0xb5, 0x62, 0xef, 0x8f, 0x0d, 0xce, 0x87,
	0x32, 0x47, 0x6f, 0xc1, 0x61, 0x5c, 0x69, 0xc2, 0x43, 0xaa, 0x5c, 0xab, 0x5b, 0xe9, 0x37, 0x8e,
	0x0e, 0x06, 0x6b, 0xf4, 0xc1, 0x92, 0x3a, 0xf0, 0x4b, 0xde, 0x19, 0xd7, 0xf2, 0x0e, 0xaf, 0xce,
	0xa1, 0x03, 0x68, 0x49, 0x9a, 0x2c, 0x58, 0x48, 0x82, 0x29, 0x09, 0xb5, 0x90, 0xae, 0xdd, 0xb5,
	0xfa, 0x4d, 0xdc, 0x2c, 0xd0, 0x77, 0x06, 0x44, 0x4f, 0x00, 0x78, 0x1a, 0x07, 0x6a, 0x4e, 0x64,
	0xa4, 0xdc, 0x8a, 0xa1, 0x38, 0x3c, 0x8d, 0xc7, 0x06, 0xc8, 0xca, 0x4c, 0xe5, 0x55, 0x1a, 0xb9,
	0xdb, 0x5d, 0xab, 0x5f, 0xc7, 0x0e, 0x53, 0xe3, 0x1c, 0x40, 0xcf, 0x60, 0x37, 0x4c, 0xb5, 0xb8,
	0xa1, 0x32, 0xd0, 0x2c, 0xa6, 0x6e, 0xb5, 0x6b, 0xf5, 0x2b, 0xb8, 0x51, 0x60, 0x57, 0x2c, 0xa6,
	0xe8, 0x29, 0x34, 0x98, 0x0a, 0x62, 0x26, 0xa5, 0x90, 0x34, 0x72, 0x6b, 0xe6, 0x0a, 0x60, 0xea,
	0x7d, 0x81, 0xa0, 0x17, 0xd0, 0x8e, 0xc9, 0x6d, 0xde, 0x23, 0x50, 0x54, 0x07, 0x2c, 0x72, 0x77,
	0x72, 0xa9, 0x31, 0xb9, 0x35, 0x9d, 0xc6, 0x54, 0xfb, 0xd1, 0xfe, 0x18, 0x5a, 0x9b, 0xcf, 0x45,
	0x6d, 0xa8, 0x7c, 0xa2, 0x77, 0xae, 0xd5, 0xb5, 0xfa, 0x0e, 0xce, 0x42, 0xf4, 0x12, 0xaa, 0x37,
	0x64, 0x91, 0x52, 0xf3, 0xd8, 0xc6, 0xd1, 0xff, 0x1b, 0xb6, 0x95, 0xa7, 0x71, 0xce, 0x39, 0xb1,
	0xdf, 0x58, 0xbd, 0xaf, 0x36, 0xd4, 0x4b, 0x1c, 0xb5, 0xc0, 0x66, 0x51, 0x71, 0x9d, 0xcd, 0x32,
	0x69, 0xff, 0x31, 0x25, 0x16, 0x44, 0x33, 0xc1, 0x83, 0x99, 0x14, 0x69, 0x62, 0xee, 0x75, 0x70,
	0x6b, 0x09, 0x9f, 0x67, 0x28, 0x42, 0xb0, 0xfd, 0x45, 0x70, 0x6a, 0xfc, 0x73, 0xb0, 0x89, 0xd1,
	0x1e, 0xd4, 0x3e, 0x53, 0x36, 0x9b, 0x6b, 0x63, 0x5b, 0x13, 0x17, 0x19, 0xda, 0x87, 0x3a, 0xe5,
	0x51, 0x22, 0x18, 0xd7, 0xc6, 0x2f, 0x07, 0x2f, 0x73, 0x74, 0x08, 0xb5, 0xe2, 0x27, 0x6a, 0xe6,
	0xdb, 0xd1, 0x86, 0x7e, 0xe3, 0x05, 0x2e, 0x18, 0xa8, 0x0b, 0xbb, 0x0f, 0x78, 0x06, 0x6a, 0x69,
	0x58, 0xd6, 0x69, 0x2e, 0x94, 0xe6, 0x24, 0xa6, 0x6e, 0x3d, 0xef, 0x54, 0xe6, 0x99, 0xe2, 0x44,
	0x48, 0xed, 0x3a, 0xe6, 0x94, 0x89, 0x7b, 0xdf, 0x2d, 0xa8, 0x9a, 0x1e, 0x6b, 0x46, 0x34, 0x8d,
	0x11, 0xaf, 0xa0, 0xaa, 0x34, 0xd1, 0xb9, 0xad, 0xad, 0xa3, 0x47, 0xff, 0xca, 0x1a, 0x67, 0x65,
	0x9c, 0xb3, 0xd0, 0x63, 0x70, 0x94, 0x48, 0x65, 0x48, 0x33, 0x5d, 0xb9, 0x27, 0xf5, 0x1c, 0xf0,
	0x23, 0xf4, 0x1c, 0x9a, 0xe5, 0xcc, 0x70, 0xc2, 0x85, 0x32, 0xf6, 0x54, 0x70, 0x39, 0x48, 0x97,
	0x19, 0x56, 0x0e, 0xd6, 0x74, 0x5a, 0x70, 0xd6, 0x06, 0x6b, 0x3a, 0x35, 0x94, 0xde, 0x05, 0xa0,
	0xe5, 0x1e, 0x8c, 0x39, 0x49, 0xd4, 0x5c, 0x68, 0x85, 0x5e, 0x83, 0xa3, 0xca, 0xa4, 0xd8, 0x9d,
	0xbd, 0x87, 0x77, 0x07, 0xaf, 0x88, 0x87, 0x27, 0x00, 0xab, 0x57, 0xa0, 0x36, 0xec, 0xfa, 0x97,
	0xfe, 0x95, 0x3f, 0x1c, 0xf9, 0x1f, 0xfd, 0xcb, 0xf3, 0xf6, 0x16, 0x6a, 0x82, 0x33, 0xbc, 0x1e,
	0xfa, 0xa3, 0xe1, 0xe9, 0xe8, 0xac, 0x6d, 0xa1, 0x06, 0xec, 0x8c, 0xce, 0x86, 0xd7, 0x59, 0xcd,
	0x3e, 0x6d, 0xff, 0xb8, 0xef, 0x58, 0x3f, 0xef, 0x3b, 0xd6, 0xaf, 0xfb, 0x8e, 0xf5, 0xed, 0x77,
	0x67, 0x6b, 0x52, 0x33, 0x1b, 0x7e, 0xfc, 0x37, 0x00, 0x00, 0xff, 0xff, 0x38, 0x9b, 0x13, 0x65,
	0x2f, 0x04, 0x00, 0x00,
}
