// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/m3db/m3/src/cluster/placement/types.go

// Copyright (c) 2019 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Package placement is a generated GoMock package.
package placement

import (
	"reflect"
	"time"

	"github.com/m3db/m3/src/cluster/generated/proto/placementpb"
	"github.com/m3db/m3/src/cluster/kv"
	"github.com/m3db/m3/src/cluster/shard"
	"github.com/m3db/m3/src/x/clock"
	"github.com/m3db/m3/src/x/instrument"

	"github.com/golang/mock/gomock"
	"github.com/golang/protobuf/proto"
)

// MockInstance is a mock of Instance interface
type MockInstance struct {
	ctrl     *gomock.Controller
	recorder *MockInstanceMockRecorder
}

// MockInstanceMockRecorder is the mock recorder for MockInstance
type MockInstanceMockRecorder struct {
	mock *MockInstance
}

// NewMockInstance creates a new mock instance
func NewMockInstance(ctrl *gomock.Controller) *MockInstance {
	mock := &MockInstance{ctrl: ctrl}
	mock.recorder = &MockInstanceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockInstance) EXPECT() *MockInstanceMockRecorder {
	return m.recorder
}

// String mocks base method
func (m *MockInstance) String() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "String")
	ret0, _ := ret[0].(string)
	return ret0
}

// String indicates an expected call of String
func (mr *MockInstanceMockRecorder) String() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "String", reflect.TypeOf((*MockInstance)(nil).String))
}

// ID mocks base method
func (m *MockInstance) ID() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ID")
	ret0, _ := ret[0].(string)
	return ret0
}

// ID indicates an expected call of ID
func (mr *MockInstanceMockRecorder) ID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ID", reflect.TypeOf((*MockInstance)(nil).ID))
}

// SetID mocks base method
func (m *MockInstance) SetID(id string) Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetID", id)
	ret0, _ := ret[0].(Instance)
	return ret0
}

// SetID indicates an expected call of SetID
func (mr *MockInstanceMockRecorder) SetID(id interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetID", reflect.TypeOf((*MockInstance)(nil).SetID), id)
}

// IsolationGroup mocks base method
func (m *MockInstance) IsolationGroup() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsolationGroup")
	ret0, _ := ret[0].(string)
	return ret0
}

// IsolationGroup indicates an expected call of IsolationGroup
func (mr *MockInstanceMockRecorder) IsolationGroup() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsolationGroup", reflect.TypeOf((*MockInstance)(nil).IsolationGroup))
}

// SetIsolationGroup mocks base method
func (m *MockInstance) SetIsolationGroup(r string) Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIsolationGroup", r)
	ret0, _ := ret[0].(Instance)
	return ret0
}

// SetIsolationGroup indicates an expected call of SetIsolationGroup
func (mr *MockInstanceMockRecorder) SetIsolationGroup(r interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIsolationGroup", reflect.TypeOf((*MockInstance)(nil).SetIsolationGroup), r)
}

// Zone mocks base method
func (m *MockInstance) Zone() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Zone")
	ret0, _ := ret[0].(string)
	return ret0
}

// Zone indicates an expected call of Zone
func (mr *MockInstanceMockRecorder) Zone() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Zone", reflect.TypeOf((*MockInstance)(nil).Zone))
}

// SetZone mocks base method
func (m *MockInstance) SetZone(z string) Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetZone", z)
	ret0, _ := ret[0].(Instance)
	return ret0
}

// SetZone indicates an expected call of SetZone
func (mr *MockInstanceMockRecorder) SetZone(z interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetZone", reflect.TypeOf((*MockInstance)(nil).SetZone), z)
}

// Weight mocks base method
func (m *MockInstance) Weight() uint32 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Weight")
	ret0, _ := ret[0].(uint32)
	return ret0
}

// Weight indicates an expected call of Weight
func (mr *MockInstanceMockRecorder) Weight() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Weight", reflect.TypeOf((*MockInstance)(nil).Weight))
}

// SetWeight mocks base method
func (m *MockInstance) SetWeight(w uint32) Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWeight", w)
	ret0, _ := ret[0].(Instance)
	return ret0
}

// SetWeight indicates an expected call of SetWeight
func (mr *MockInstanceMockRecorder) SetWeight(w interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWeight", reflect.TypeOf((*MockInstance)(nil).SetWeight), w)
}

// Endpoint mocks base method
func (m *MockInstance) Endpoint() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Endpoint")
	ret0, _ := ret[0].(string)
	return ret0
}

// Endpoint indicates an expected call of Endpoint
func (mr *MockInstanceMockRecorder) Endpoint() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Endpoint", reflect.TypeOf((*MockInstance)(nil).Endpoint))
}

// SetEndpoint mocks base method
func (m *MockInstance) SetEndpoint(ip string) Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetEndpoint", ip)
	ret0, _ := ret[0].(Instance)
	return ret0
}

// SetEndpoint indicates an expected call of SetEndpoint
func (mr *MockInstanceMockRecorder) SetEndpoint(ip interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetEndpoint", reflect.TypeOf((*MockInstance)(nil).SetEndpoint), ip)
}

// Shards mocks base method
func (m *MockInstance) Shards() shard.Shards {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Shards")
	ret0, _ := ret[0].(shard.Shards)
	return ret0
}

// Shards indicates an expected call of Shards
func (mr *MockInstanceMockRecorder) Shards() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Shards", reflect.TypeOf((*MockInstance)(nil).Shards))
}

// SetShards mocks base method
func (m *MockInstance) SetShards(s shard.Shards) Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetShards", s)
	ret0, _ := ret[0].(Instance)
	return ret0
}

// SetShards indicates an expected call of SetShards
func (mr *MockInstanceMockRecorder) SetShards(s interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetShards", reflect.TypeOf((*MockInstance)(nil).SetShards), s)
}

// ShardSetID mocks base method
func (m *MockInstance) ShardSetID() uint32 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ShardSetID")
	ret0, _ := ret[0].(uint32)
	return ret0
}

// ShardSetID indicates an expected call of ShardSetID
func (mr *MockInstanceMockRecorder) ShardSetID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ShardSetID", reflect.TypeOf((*MockInstance)(nil).ShardSetID))
}

// SetShardSetID mocks base method
func (m *MockInstance) SetShardSetID(value uint32) Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetShardSetID", value)
	ret0, _ := ret[0].(Instance)
	return ret0
}

// SetShardSetID indicates an expected call of SetShardSetID
func (mr *MockInstanceMockRecorder) SetShardSetID(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetShardSetID", reflect.TypeOf((*MockInstance)(nil).SetShardSetID), value)
}

// Hostname mocks base method
func (m *MockInstance) Hostname() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Hostname")
	ret0, _ := ret[0].(string)
	return ret0
}

// Hostname indicates an expected call of Hostname
func (mr *MockInstanceMockRecorder) Hostname() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Hostname", reflect.TypeOf((*MockInstance)(nil).Hostname))
}

// SetHostname mocks base method
func (m *MockInstance) SetHostname(value string) Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHostname", value)
	ret0, _ := ret[0].(Instance)
	return ret0
}

// SetHostname indicates an expected call of SetHostname
func (mr *MockInstanceMockRecorder) SetHostname(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHostname", reflect.TypeOf((*MockInstance)(nil).SetHostname), value)
}

// Port mocks base method
func (m *MockInstance) Port() uint32 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Port")
	ret0, _ := ret[0].(uint32)
	return ret0
}

// Port indicates an expected call of Port
func (mr *MockInstanceMockRecorder) Port() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Port", reflect.TypeOf((*MockInstance)(nil).Port))
}

// SetPort mocks base method
func (m *MockInstance) SetPort(value uint32) Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetPort", value)
	ret0, _ := ret[0].(Instance)
	return ret0
}

// SetPort indicates an expected call of SetPort
func (mr *MockInstanceMockRecorder) SetPort(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetPort", reflect.TypeOf((*MockInstance)(nil).SetPort), value)
}

// Proto mocks base method
func (m *MockInstance) Proto() (*placementpb.Instance, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Proto")
	ret0, _ := ret[0].(*placementpb.Instance)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Proto indicates an expected call of Proto
func (mr *MockInstanceMockRecorder) Proto() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Proto", reflect.TypeOf((*MockInstance)(nil).Proto))
}

// IsLeaving mocks base method
func (m *MockInstance) IsLeaving() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsLeaving")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsLeaving indicates an expected call of IsLeaving
func (mr *MockInstanceMockRecorder) IsLeaving() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsLeaving", reflect.TypeOf((*MockInstance)(nil).IsLeaving))
}

// IsInitializing mocks base method
func (m *MockInstance) IsInitializing() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsInitializing")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsInitializing indicates an expected call of IsInitializing
func (mr *MockInstanceMockRecorder) IsInitializing() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsInitializing", reflect.TypeOf((*MockInstance)(nil).IsInitializing))
}

// IsAvailable mocks base method
func (m *MockInstance) IsAvailable() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsAvailable")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsAvailable indicates an expected call of IsAvailable
func (mr *MockInstanceMockRecorder) IsAvailable() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsAvailable", reflect.TypeOf((*MockInstance)(nil).IsAvailable))
}

// Clone mocks base method
func (m *MockInstance) Clone() Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Clone")
	ret0, _ := ret[0].(Instance)
	return ret0
}

// Clone indicates an expected call of Clone
func (mr *MockInstanceMockRecorder) Clone() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Clone", reflect.TypeOf((*MockInstance)(nil).Clone))
}

// MockPlacement is a mock of Placement interface
type MockPlacement struct {
	ctrl     *gomock.Controller
	recorder *MockPlacementMockRecorder
}

// MockPlacementMockRecorder is the mock recorder for MockPlacement
type MockPlacementMockRecorder struct {
	mock *MockPlacement
}

// NewMockPlacement creates a new mock instance
func NewMockPlacement(ctrl *gomock.Controller) *MockPlacement {
	mock := &MockPlacement{ctrl: ctrl}
	mock.recorder = &MockPlacementMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockPlacement) EXPECT() *MockPlacementMockRecorder {
	return m.recorder
}

// InstancesForShard mocks base method
func (m *MockPlacement) InstancesForShard(shard uint32) []Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InstancesForShard", shard)
	ret0, _ := ret[0].([]Instance)
	return ret0
}

// InstancesForShard indicates an expected call of InstancesForShard
func (mr *MockPlacementMockRecorder) InstancesForShard(shard interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InstancesForShard", reflect.TypeOf((*MockPlacement)(nil).InstancesForShard), shard)
}

// Instances mocks base method
func (m *MockPlacement) Instances() []Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Instances")
	ret0, _ := ret[0].([]Instance)
	return ret0
}

// Instances indicates an expected call of Instances
func (mr *MockPlacementMockRecorder) Instances() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Instances", reflect.TypeOf((*MockPlacement)(nil).Instances))
}

// SetInstances mocks base method
func (m *MockPlacement) SetInstances(instances []Instance) Placement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetInstances", instances)
	ret0, _ := ret[0].(Placement)
	return ret0
}

// SetInstances indicates an expected call of SetInstances
func (mr *MockPlacementMockRecorder) SetInstances(instances interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetInstances", reflect.TypeOf((*MockPlacement)(nil).SetInstances), instances)
}

// NumInstances mocks base method
func (m *MockPlacement) NumInstances() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NumInstances")
	ret0, _ := ret[0].(int)
	return ret0
}

// NumInstances indicates an expected call of NumInstances
func (mr *MockPlacementMockRecorder) NumInstances() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NumInstances", reflect.TypeOf((*MockPlacement)(nil).NumInstances))
}

// Instance mocks base method
func (m *MockPlacement) Instance(id string) (Instance, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Instance", id)
	ret0, _ := ret[0].(Instance)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// Instance indicates an expected call of Instance
func (mr *MockPlacementMockRecorder) Instance(id interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Instance", reflect.TypeOf((*MockPlacement)(nil).Instance), id)
}

// ReplicaFactor mocks base method
func (m *MockPlacement) ReplicaFactor() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplicaFactor")
	ret0, _ := ret[0].(int)
	return ret0
}

// ReplicaFactor indicates an expected call of ReplicaFactor
func (mr *MockPlacementMockRecorder) ReplicaFactor() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplicaFactor", reflect.TypeOf((*MockPlacement)(nil).ReplicaFactor))
}

// SetReplicaFactor mocks base method
func (m *MockPlacement) SetReplicaFactor(rf int) Placement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetReplicaFactor", rf)
	ret0, _ := ret[0].(Placement)
	return ret0
}

// SetReplicaFactor indicates an expected call of SetReplicaFactor
func (mr *MockPlacementMockRecorder) SetReplicaFactor(rf interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetReplicaFactor", reflect.TypeOf((*MockPlacement)(nil).SetReplicaFactor), rf)
}

// Shards mocks base method
func (m *MockPlacement) Shards() []uint32 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Shards")
	ret0, _ := ret[0].([]uint32)
	return ret0
}

// Shards indicates an expected call of Shards
func (mr *MockPlacementMockRecorder) Shards() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Shards", reflect.TypeOf((*MockPlacement)(nil).Shards))
}

// SetShards mocks base method
func (m *MockPlacement) SetShards(s []uint32) Placement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetShards", s)
	ret0, _ := ret[0].(Placement)
	return ret0
}

// SetShards indicates an expected call of SetShards
func (mr *MockPlacementMockRecorder) SetShards(s interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetShards", reflect.TypeOf((*MockPlacement)(nil).SetShards), s)
}

// NumShards mocks base method
func (m *MockPlacement) NumShards() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NumShards")
	ret0, _ := ret[0].(int)
	return ret0
}

// NumShards indicates an expected call of NumShards
func (mr *MockPlacementMockRecorder) NumShards() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NumShards", reflect.TypeOf((*MockPlacement)(nil).NumShards))
}

// IsSharded mocks base method
func (m *MockPlacement) IsSharded() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsSharded")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsSharded indicates an expected call of IsSharded
func (mr *MockPlacementMockRecorder) IsSharded() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsSharded", reflect.TypeOf((*MockPlacement)(nil).IsSharded))
}

// SetIsSharded mocks base method
func (m *MockPlacement) SetIsSharded(v bool) Placement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIsSharded", v)
	ret0, _ := ret[0].(Placement)
	return ret0
}

// SetIsSharded indicates an expected call of SetIsSharded
func (mr *MockPlacementMockRecorder) SetIsSharded(v interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIsSharded", reflect.TypeOf((*MockPlacement)(nil).SetIsSharded), v)
}

// CutoverNanos mocks base method
func (m *MockPlacement) CutoverNanos() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CutoverNanos")
	ret0, _ := ret[0].(int64)
	return ret0
}

// CutoverNanos indicates an expected call of CutoverNanos
func (mr *MockPlacementMockRecorder) CutoverNanos() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CutoverNanos", reflect.TypeOf((*MockPlacement)(nil).CutoverNanos))
}

// SetCutoverNanos mocks base method
func (m *MockPlacement) SetCutoverNanos(cutoverNanos int64) Placement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetCutoverNanos", cutoverNanos)
	ret0, _ := ret[0].(Placement)
	return ret0
}

// SetCutoverNanos indicates an expected call of SetCutoverNanos
func (mr *MockPlacementMockRecorder) SetCutoverNanos(cutoverNanos interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetCutoverNanos", reflect.TypeOf((*MockPlacement)(nil).SetCutoverNanos), cutoverNanos)
}

// IsMirrored mocks base method
func (m *MockPlacement) IsMirrored() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsMirrored")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsMirrored indicates an expected call of IsMirrored
func (mr *MockPlacementMockRecorder) IsMirrored() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsMirrored", reflect.TypeOf((*MockPlacement)(nil).IsMirrored))
}

// SetIsMirrored mocks base method
func (m *MockPlacement) SetIsMirrored(v bool) Placement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIsMirrored", v)
	ret0, _ := ret[0].(Placement)
	return ret0
}

// SetIsMirrored indicates an expected call of SetIsMirrored
func (mr *MockPlacementMockRecorder) SetIsMirrored(v interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIsMirrored", reflect.TypeOf((*MockPlacement)(nil).SetIsMirrored), v)
}

// MaxShardSetID mocks base method
func (m *MockPlacement) MaxShardSetID() uint32 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MaxShardSetID")
	ret0, _ := ret[0].(uint32)
	return ret0
}

// MaxShardSetID indicates an expected call of MaxShardSetID
func (mr *MockPlacementMockRecorder) MaxShardSetID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MaxShardSetID", reflect.TypeOf((*MockPlacement)(nil).MaxShardSetID))
}

// SetMaxShardSetID mocks base method
func (m *MockPlacement) SetMaxShardSetID(value uint32) Placement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetMaxShardSetID", value)
	ret0, _ := ret[0].(Placement)
	return ret0
}

// SetMaxShardSetID indicates an expected call of SetMaxShardSetID
func (mr *MockPlacementMockRecorder) SetMaxShardSetID(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetMaxShardSetID", reflect.TypeOf((*MockPlacement)(nil).SetMaxShardSetID), value)
}

// String mocks base method
func (m *MockPlacement) String() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "String")
	ret0, _ := ret[0].(string)
	return ret0
}

// String indicates an expected call of String
func (mr *MockPlacementMockRecorder) String() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "String", reflect.TypeOf((*MockPlacement)(nil).String))
}

// Version mocks base method
func (m *MockPlacement) Version() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Version")
	ret0, _ := ret[0].(int)
	return ret0
}

// Version indicates an expected call of Version
func (mr *MockPlacementMockRecorder) Version() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Version", reflect.TypeOf((*MockPlacement)(nil).Version))
}

// SetVersion mocks base method
func (m *MockPlacement) SetVersion(v int) Placement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetVersion", v)
	ret0, _ := ret[0].(Placement)
	return ret0
}

// SetVersion indicates an expected call of SetVersion
func (mr *MockPlacementMockRecorder) SetVersion(v interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetVersion", reflect.TypeOf((*MockPlacement)(nil).SetVersion), v)
}

// Proto mocks base method
func (m *MockPlacement) Proto() (*placementpb.Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Proto")
	ret0, _ := ret[0].(*placementpb.Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Proto indicates an expected call of Proto
func (mr *MockPlacementMockRecorder) Proto() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Proto", reflect.TypeOf((*MockPlacement)(nil).Proto))
}

// Clone mocks base method
func (m *MockPlacement) Clone() Placement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Clone")
	ret0, _ := ret[0].(Placement)
	return ret0
}

// Clone indicates an expected call of Clone
func (mr *MockPlacementMockRecorder) Clone() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Clone", reflect.TypeOf((*MockPlacement)(nil).Clone))
}

// MockWatch is a mock of Watch interface
type MockWatch struct {
	ctrl     *gomock.Controller
	recorder *MockWatchMockRecorder
}

// MockWatchMockRecorder is the mock recorder for MockWatch
type MockWatchMockRecorder struct {
	mock *MockWatch
}

// NewMockWatch creates a new mock instance
func NewMockWatch(ctrl *gomock.Controller) *MockWatch {
	mock := &MockWatch{ctrl: ctrl}
	mock.recorder = &MockWatchMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockWatch) EXPECT() *MockWatchMockRecorder {
	return m.recorder
}

// C mocks base method
func (m *MockWatch) C() <-chan struct{} {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "C")
	ret0, _ := ret[0].(<-chan struct{})
	return ret0
}

// C indicates an expected call of C
func (mr *MockWatchMockRecorder) C() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "C", reflect.TypeOf((*MockWatch)(nil).C))
}

// Get mocks base method
func (m *MockWatch) Get() (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Get")
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Get indicates an expected call of Get
func (mr *MockWatchMockRecorder) Get() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Get", reflect.TypeOf((*MockWatch)(nil).Get))
}

// Close mocks base method
func (m *MockWatch) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close
func (mr *MockWatchMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockWatch)(nil).Close))
}

// MockStagedPlacementWatcher is a mock of StagedPlacementWatcher interface
type MockStagedPlacementWatcher struct {
	ctrl     *gomock.Controller
	recorder *MockStagedPlacementWatcherMockRecorder
}

// MockStagedPlacementWatcherMockRecorder is the mock recorder for MockStagedPlacementWatcher
type MockStagedPlacementWatcherMockRecorder struct {
	mock *MockStagedPlacementWatcher
}

// NewMockStagedPlacementWatcher creates a new mock instance
func NewMockStagedPlacementWatcher(ctrl *gomock.Controller) *MockStagedPlacementWatcher {
	mock := &MockStagedPlacementWatcher{ctrl: ctrl}
	mock.recorder = &MockStagedPlacementWatcherMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockStagedPlacementWatcher) EXPECT() *MockStagedPlacementWatcherMockRecorder {
	return m.recorder
}

// Watch mocks base method
func (m *MockStagedPlacementWatcher) Watch() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Watch")
	ret0, _ := ret[0].(error)
	return ret0
}

// Watch indicates an expected call of Watch
func (mr *MockStagedPlacementWatcherMockRecorder) Watch() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Watch", reflect.TypeOf((*MockStagedPlacementWatcher)(nil).Watch))
}

// ActiveStagedPlacement mocks base method
func (m *MockStagedPlacementWatcher) ActiveStagedPlacement() (ActiveStagedPlacement, DoneFn, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ActiveStagedPlacement")
	ret0, _ := ret[0].(ActiveStagedPlacement)
	ret1, _ := ret[1].(DoneFn)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ActiveStagedPlacement indicates an expected call of ActiveStagedPlacement
func (mr *MockStagedPlacementWatcherMockRecorder) ActiveStagedPlacement() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ActiveStagedPlacement", reflect.TypeOf((*MockStagedPlacementWatcher)(nil).ActiveStagedPlacement))
}

// Unwatch mocks base method
func (m *MockStagedPlacementWatcher) Unwatch() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Unwatch")
	ret0, _ := ret[0].(error)
	return ret0
}

// Unwatch indicates an expected call of Unwatch
func (mr *MockStagedPlacementWatcherMockRecorder) Unwatch() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Unwatch", reflect.TypeOf((*MockStagedPlacementWatcher)(nil).Unwatch))
}

// MockStagedPlacementWatcherOptions is a mock of StagedPlacementWatcherOptions interface
type MockStagedPlacementWatcherOptions struct {
	ctrl     *gomock.Controller
	recorder *MockStagedPlacementWatcherOptionsMockRecorder
}

// MockStagedPlacementWatcherOptionsMockRecorder is the mock recorder for MockStagedPlacementWatcherOptions
type MockStagedPlacementWatcherOptionsMockRecorder struct {
	mock *MockStagedPlacementWatcherOptions
}

// NewMockStagedPlacementWatcherOptions creates a new mock instance
func NewMockStagedPlacementWatcherOptions(ctrl *gomock.Controller) *MockStagedPlacementWatcherOptions {
	mock := &MockStagedPlacementWatcherOptions{ctrl: ctrl}
	mock.recorder = &MockStagedPlacementWatcherOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockStagedPlacementWatcherOptions) EXPECT() *MockStagedPlacementWatcherOptionsMockRecorder {
	return m.recorder
}

// SetClockOptions mocks base method
func (m *MockStagedPlacementWatcherOptions) SetClockOptions(value clock.Options) StagedPlacementWatcherOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetClockOptions", value)
	ret0, _ := ret[0].(StagedPlacementWatcherOptions)
	return ret0
}

// SetClockOptions indicates an expected call of SetClockOptions
func (mr *MockStagedPlacementWatcherOptionsMockRecorder) SetClockOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetClockOptions", reflect.TypeOf((*MockStagedPlacementWatcherOptions)(nil).SetClockOptions), value)
}

// ClockOptions mocks base method
func (m *MockStagedPlacementWatcherOptions) ClockOptions() clock.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ClockOptions")
	ret0, _ := ret[0].(clock.Options)
	return ret0
}

// ClockOptions indicates an expected call of ClockOptions
func (mr *MockStagedPlacementWatcherOptionsMockRecorder) ClockOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClockOptions", reflect.TypeOf((*MockStagedPlacementWatcherOptions)(nil).ClockOptions))
}

// SetInstrumentOptions mocks base method
func (m *MockStagedPlacementWatcherOptions) SetInstrumentOptions(value instrument.Options) StagedPlacementWatcherOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetInstrumentOptions", value)
	ret0, _ := ret[0].(StagedPlacementWatcherOptions)
	return ret0
}

// SetInstrumentOptions indicates an expected call of SetInstrumentOptions
func (mr *MockStagedPlacementWatcherOptionsMockRecorder) SetInstrumentOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetInstrumentOptions", reflect.TypeOf((*MockStagedPlacementWatcherOptions)(nil).SetInstrumentOptions), value)
}

// InstrumentOptions mocks base method
func (m *MockStagedPlacementWatcherOptions) InstrumentOptions() instrument.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InstrumentOptions")
	ret0, _ := ret[0].(instrument.Options)
	return ret0
}

// InstrumentOptions indicates an expected call of InstrumentOptions
func (mr *MockStagedPlacementWatcherOptionsMockRecorder) InstrumentOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InstrumentOptions", reflect.TypeOf((*MockStagedPlacementWatcherOptions)(nil).InstrumentOptions))
}

// SetActiveStagedPlacementOptions mocks base method
func (m *MockStagedPlacementWatcherOptions) SetActiveStagedPlacementOptions(value ActiveStagedPlacementOptions) StagedPlacementWatcherOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetActiveStagedPlacementOptions", value)
	ret0, _ := ret[0].(StagedPlacementWatcherOptions)
	return ret0
}

// SetActiveStagedPlacementOptions indicates an expected call of SetActiveStagedPlacementOptions
func (mr *MockStagedPlacementWatcherOptionsMockRecorder) SetActiveStagedPlacementOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetActiveStagedPlacementOptions", reflect.TypeOf((*MockStagedPlacementWatcherOptions)(nil).SetActiveStagedPlacementOptions), value)
}

// ActiveStagedPlacementOptions mocks base method
func (m *MockStagedPlacementWatcherOptions) ActiveStagedPlacementOptions() ActiveStagedPlacementOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ActiveStagedPlacementOptions")
	ret0, _ := ret[0].(ActiveStagedPlacementOptions)
	return ret0
}

// ActiveStagedPlacementOptions indicates an expected call of ActiveStagedPlacementOptions
func (mr *MockStagedPlacementWatcherOptionsMockRecorder) ActiveStagedPlacementOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ActiveStagedPlacementOptions", reflect.TypeOf((*MockStagedPlacementWatcherOptions)(nil).ActiveStagedPlacementOptions))
}

// SetStagedPlacementKey mocks base method
func (m *MockStagedPlacementWatcherOptions) SetStagedPlacementKey(value string) StagedPlacementWatcherOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetStagedPlacementKey", value)
	ret0, _ := ret[0].(StagedPlacementWatcherOptions)
	return ret0
}

// SetStagedPlacementKey indicates an expected call of SetStagedPlacementKey
func (mr *MockStagedPlacementWatcherOptionsMockRecorder) SetStagedPlacementKey(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetStagedPlacementKey", reflect.TypeOf((*MockStagedPlacementWatcherOptions)(nil).SetStagedPlacementKey), value)
}

// StagedPlacementKey mocks base method
func (m *MockStagedPlacementWatcherOptions) StagedPlacementKey() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StagedPlacementKey")
	ret0, _ := ret[0].(string)
	return ret0
}

// StagedPlacementKey indicates an expected call of StagedPlacementKey
func (mr *MockStagedPlacementWatcherOptionsMockRecorder) StagedPlacementKey() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StagedPlacementKey", reflect.TypeOf((*MockStagedPlacementWatcherOptions)(nil).StagedPlacementKey))
}

// SetStagedPlacementStore mocks base method
func (m *MockStagedPlacementWatcherOptions) SetStagedPlacementStore(store kv.Store) StagedPlacementWatcherOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetStagedPlacementStore", store)
	ret0, _ := ret[0].(StagedPlacementWatcherOptions)
	return ret0
}

// SetStagedPlacementStore indicates an expected call of SetStagedPlacementStore
func (mr *MockStagedPlacementWatcherOptionsMockRecorder) SetStagedPlacementStore(store interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetStagedPlacementStore", reflect.TypeOf((*MockStagedPlacementWatcherOptions)(nil).SetStagedPlacementStore), store)
}

// StagedPlacementStore mocks base method
func (m *MockStagedPlacementWatcherOptions) StagedPlacementStore() kv.Store {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StagedPlacementStore")
	ret0, _ := ret[0].(kv.Store)
	return ret0
}

// StagedPlacementStore indicates an expected call of StagedPlacementStore
func (mr *MockStagedPlacementWatcherOptionsMockRecorder) StagedPlacementStore() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StagedPlacementStore", reflect.TypeOf((*MockStagedPlacementWatcherOptions)(nil).StagedPlacementStore))
}

// SetInitWatchTimeout mocks base method
func (m *MockStagedPlacementWatcherOptions) SetInitWatchTimeout(value time.Duration) StagedPlacementWatcherOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetInitWatchTimeout", value)
	ret0, _ := ret[0].(StagedPlacementWatcherOptions)
	return ret0
}

// SetInitWatchTimeout indicates an expected call of SetInitWatchTimeout
func (mr *MockStagedPlacementWatcherOptionsMockRecorder) SetInitWatchTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetInitWatchTimeout", reflect.TypeOf((*MockStagedPlacementWatcherOptions)(nil).SetInitWatchTimeout), value)
}

// InitWatchTimeout mocks base method
func (m *MockStagedPlacementWatcherOptions) InitWatchTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InitWatchTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// InitWatchTimeout indicates an expected call of InitWatchTimeout
func (mr *MockStagedPlacementWatcherOptionsMockRecorder) InitWatchTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InitWatchTimeout", reflect.TypeOf((*MockStagedPlacementWatcherOptions)(nil).InitWatchTimeout))
}

// MockActiveStagedPlacement is a mock of ActiveStagedPlacement interface
type MockActiveStagedPlacement struct {
	ctrl     *gomock.Controller
	recorder *MockActiveStagedPlacementMockRecorder
}

// MockActiveStagedPlacementMockRecorder is the mock recorder for MockActiveStagedPlacement
type MockActiveStagedPlacementMockRecorder struct {
	mock *MockActiveStagedPlacement
}

// NewMockActiveStagedPlacement creates a new mock instance
func NewMockActiveStagedPlacement(ctrl *gomock.Controller) *MockActiveStagedPlacement {
	mock := &MockActiveStagedPlacement{ctrl: ctrl}
	mock.recorder = &MockActiveStagedPlacementMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockActiveStagedPlacement) EXPECT() *MockActiveStagedPlacementMockRecorder {
	return m.recorder
}

// ActivePlacement mocks base method
func (m *MockActiveStagedPlacement) ActivePlacement() (Placement, DoneFn, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ActivePlacement")
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(DoneFn)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ActivePlacement indicates an expected call of ActivePlacement
func (mr *MockActiveStagedPlacementMockRecorder) ActivePlacement() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ActivePlacement", reflect.TypeOf((*MockActiveStagedPlacement)(nil).ActivePlacement))
}

// Close mocks base method
func (m *MockActiveStagedPlacement) Close() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Close")
	ret0, _ := ret[0].(error)
	return ret0
}

// Close indicates an expected call of Close
func (mr *MockActiveStagedPlacementMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockActiveStagedPlacement)(nil).Close))
}

// MockActiveStagedPlacementOptions is a mock of ActiveStagedPlacementOptions interface
type MockActiveStagedPlacementOptions struct {
	ctrl     *gomock.Controller
	recorder *MockActiveStagedPlacementOptionsMockRecorder
}

// MockActiveStagedPlacementOptionsMockRecorder is the mock recorder for MockActiveStagedPlacementOptions
type MockActiveStagedPlacementOptionsMockRecorder struct {
	mock *MockActiveStagedPlacementOptions
}

// NewMockActiveStagedPlacementOptions creates a new mock instance
func NewMockActiveStagedPlacementOptions(ctrl *gomock.Controller) *MockActiveStagedPlacementOptions {
	mock := &MockActiveStagedPlacementOptions{ctrl: ctrl}
	mock.recorder = &MockActiveStagedPlacementOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockActiveStagedPlacementOptions) EXPECT() *MockActiveStagedPlacementOptionsMockRecorder {
	return m.recorder
}

// SetClockOptions mocks base method
func (m *MockActiveStagedPlacementOptions) SetClockOptions(value clock.Options) ActiveStagedPlacementOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetClockOptions", value)
	ret0, _ := ret[0].(ActiveStagedPlacementOptions)
	return ret0
}

// SetClockOptions indicates an expected call of SetClockOptions
func (mr *MockActiveStagedPlacementOptionsMockRecorder) SetClockOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetClockOptions", reflect.TypeOf((*MockActiveStagedPlacementOptions)(nil).SetClockOptions), value)
}

// ClockOptions mocks base method
func (m *MockActiveStagedPlacementOptions) ClockOptions() clock.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ClockOptions")
	ret0, _ := ret[0].(clock.Options)
	return ret0
}

// ClockOptions indicates an expected call of ClockOptions
func (mr *MockActiveStagedPlacementOptionsMockRecorder) ClockOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClockOptions", reflect.TypeOf((*MockActiveStagedPlacementOptions)(nil).ClockOptions))
}

// SetOnPlacementsAddedFn mocks base method
func (m *MockActiveStagedPlacementOptions) SetOnPlacementsAddedFn(value OnPlacementsAddedFn) ActiveStagedPlacementOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetOnPlacementsAddedFn", value)
	ret0, _ := ret[0].(ActiveStagedPlacementOptions)
	return ret0
}

// SetOnPlacementsAddedFn indicates an expected call of SetOnPlacementsAddedFn
func (mr *MockActiveStagedPlacementOptionsMockRecorder) SetOnPlacementsAddedFn(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetOnPlacementsAddedFn", reflect.TypeOf((*MockActiveStagedPlacementOptions)(nil).SetOnPlacementsAddedFn), value)
}

// OnPlacementsAddedFn mocks base method
func (m *MockActiveStagedPlacementOptions) OnPlacementsAddedFn() OnPlacementsAddedFn {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "OnPlacementsAddedFn")
	ret0, _ := ret[0].(OnPlacementsAddedFn)
	return ret0
}

// OnPlacementsAddedFn indicates an expected call of OnPlacementsAddedFn
func (mr *MockActiveStagedPlacementOptionsMockRecorder) OnPlacementsAddedFn() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "OnPlacementsAddedFn", reflect.TypeOf((*MockActiveStagedPlacementOptions)(nil).OnPlacementsAddedFn))
}

// SetOnPlacementsRemovedFn mocks base method
func (m *MockActiveStagedPlacementOptions) SetOnPlacementsRemovedFn(value OnPlacementsRemovedFn) ActiveStagedPlacementOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetOnPlacementsRemovedFn", value)
	ret0, _ := ret[0].(ActiveStagedPlacementOptions)
	return ret0
}

// SetOnPlacementsRemovedFn indicates an expected call of SetOnPlacementsRemovedFn
func (mr *MockActiveStagedPlacementOptionsMockRecorder) SetOnPlacementsRemovedFn(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetOnPlacementsRemovedFn", reflect.TypeOf((*MockActiveStagedPlacementOptions)(nil).SetOnPlacementsRemovedFn), value)
}

// OnPlacementsRemovedFn mocks base method
func (m *MockActiveStagedPlacementOptions) OnPlacementsRemovedFn() OnPlacementsRemovedFn {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "OnPlacementsRemovedFn")
	ret0, _ := ret[0].(OnPlacementsRemovedFn)
	return ret0
}

// OnPlacementsRemovedFn indicates an expected call of OnPlacementsRemovedFn
func (mr *MockActiveStagedPlacementOptionsMockRecorder) OnPlacementsRemovedFn() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "OnPlacementsRemovedFn", reflect.TypeOf((*MockActiveStagedPlacementOptions)(nil).OnPlacementsRemovedFn))
}

// MockStagedPlacement is a mock of StagedPlacement interface
type MockStagedPlacement struct {
	ctrl     *gomock.Controller
	recorder *MockStagedPlacementMockRecorder
}

// MockStagedPlacementMockRecorder is the mock recorder for MockStagedPlacement
type MockStagedPlacementMockRecorder struct {
	mock *MockStagedPlacement
}

// NewMockStagedPlacement creates a new mock instance
func NewMockStagedPlacement(ctrl *gomock.Controller) *MockStagedPlacement {
	mock := &MockStagedPlacement{ctrl: ctrl}
	mock.recorder = &MockStagedPlacementMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockStagedPlacement) EXPECT() *MockStagedPlacementMockRecorder {
	return m.recorder
}

// ActiveStagedPlacement mocks base method
func (m *MockStagedPlacement) ActiveStagedPlacement(timeNanos int64) ActiveStagedPlacement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ActiveStagedPlacement", timeNanos)
	ret0, _ := ret[0].(ActiveStagedPlacement)
	return ret0
}

// ActiveStagedPlacement indicates an expected call of ActiveStagedPlacement
func (mr *MockStagedPlacementMockRecorder) ActiveStagedPlacement(timeNanos interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ActiveStagedPlacement", reflect.TypeOf((*MockStagedPlacement)(nil).ActiveStagedPlacement), timeNanos)
}

// Version mocks base method
func (m *MockStagedPlacement) Version() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Version")
	ret0, _ := ret[0].(int)
	return ret0
}

// Version indicates an expected call of Version
func (mr *MockStagedPlacementMockRecorder) Version() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Version", reflect.TypeOf((*MockStagedPlacement)(nil).Version))
}

// SetVersion mocks base method
func (m *MockStagedPlacement) SetVersion(version int) StagedPlacement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetVersion", version)
	ret0, _ := ret[0].(StagedPlacement)
	return ret0
}

// SetVersion indicates an expected call of SetVersion
func (mr *MockStagedPlacementMockRecorder) SetVersion(version interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetVersion", reflect.TypeOf((*MockStagedPlacement)(nil).SetVersion), version)
}

// Placements mocks base method
func (m *MockStagedPlacement) Placements() Placements {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Placements")
	ret0, _ := ret[0].(Placements)
	return ret0
}

// Placements indicates an expected call of Placements
func (mr *MockStagedPlacementMockRecorder) Placements() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Placements", reflect.TypeOf((*MockStagedPlacement)(nil).Placements))
}

// SetPlacements mocks base method
func (m *MockStagedPlacement) SetPlacements(placements []Placement) StagedPlacement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetPlacements", placements)
	ret0, _ := ret[0].(StagedPlacement)
	return ret0
}

// SetPlacements indicates an expected call of SetPlacements
func (mr *MockStagedPlacementMockRecorder) SetPlacements(placements interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetPlacements", reflect.TypeOf((*MockStagedPlacement)(nil).SetPlacements), placements)
}

// ActiveStagedPlacementOptions mocks base method
func (m *MockStagedPlacement) ActiveStagedPlacementOptions() ActiveStagedPlacementOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ActiveStagedPlacementOptions")
	ret0, _ := ret[0].(ActiveStagedPlacementOptions)
	return ret0
}

// ActiveStagedPlacementOptions indicates an expected call of ActiveStagedPlacementOptions
func (mr *MockStagedPlacementMockRecorder) ActiveStagedPlacementOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ActiveStagedPlacementOptions", reflect.TypeOf((*MockStagedPlacement)(nil).ActiveStagedPlacementOptions))
}

// SetActiveStagedPlacementOptions mocks base method
func (m *MockStagedPlacement) SetActiveStagedPlacementOptions(opts ActiveStagedPlacementOptions) StagedPlacement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetActiveStagedPlacementOptions", opts)
	ret0, _ := ret[0].(StagedPlacement)
	return ret0
}

// SetActiveStagedPlacementOptions indicates an expected call of SetActiveStagedPlacementOptions
func (mr *MockStagedPlacementMockRecorder) SetActiveStagedPlacementOptions(opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetActiveStagedPlacementOptions", reflect.TypeOf((*MockStagedPlacement)(nil).SetActiveStagedPlacementOptions), opts)
}

// Proto mocks base method
func (m *MockStagedPlacement) Proto() (*placementpb.PlacementSnapshots, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Proto")
	ret0, _ := ret[0].(*placementpb.PlacementSnapshots)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Proto indicates an expected call of Proto
func (mr *MockStagedPlacementMockRecorder) Proto() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Proto", reflect.TypeOf((*MockStagedPlacement)(nil).Proto))
}

// MockOptions is a mock of Options interface
type MockOptions struct {
	ctrl     *gomock.Controller
	recorder *MockOptionsMockRecorder
}

// MockOptionsMockRecorder is the mock recorder for MockOptions
type MockOptionsMockRecorder struct {
	mock *MockOptions
}

// NewMockOptions creates a new mock instance
func NewMockOptions(ctrl *gomock.Controller) *MockOptions {
	mock := &MockOptions{ctrl: ctrl}
	mock.recorder = &MockOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockOptions) EXPECT() *MockOptionsMockRecorder {
	return m.recorder
}

// AllowPartialReplace mocks base method
func (m *MockOptions) AllowPartialReplace() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AllowPartialReplace")
	ret0, _ := ret[0].(bool)
	return ret0
}

// AllowPartialReplace indicates an expected call of AllowPartialReplace
func (mr *MockOptionsMockRecorder) AllowPartialReplace() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AllowPartialReplace", reflect.TypeOf((*MockOptions)(nil).AllowPartialReplace))
}

// SetAllowPartialReplace mocks base method
func (m *MockOptions) SetAllowPartialReplace(allowPartialReplace bool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetAllowPartialReplace", allowPartialReplace)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetAllowPartialReplace indicates an expected call of SetAllowPartialReplace
func (mr *MockOptionsMockRecorder) SetAllowPartialReplace(allowPartialReplace interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetAllowPartialReplace", reflect.TypeOf((*MockOptions)(nil).SetAllowPartialReplace), allowPartialReplace)
}

// AllowAllZones mocks base method
func (m *MockOptions) AllowAllZones() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AllowAllZones")
	ret0, _ := ret[0].(bool)
	return ret0
}

// AllowAllZones indicates an expected call of AllowAllZones
func (mr *MockOptionsMockRecorder) AllowAllZones() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AllowAllZones", reflect.TypeOf((*MockOptions)(nil).AllowAllZones))
}

// SetAllowAllZones mocks base method
func (m *MockOptions) SetAllowAllZones(allowAllZones bool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetAllowAllZones", allowAllZones)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetAllowAllZones indicates an expected call of SetAllowAllZones
func (mr *MockOptionsMockRecorder) SetAllowAllZones(allowAllZones interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetAllowAllZones", reflect.TypeOf((*MockOptions)(nil).SetAllowAllZones), allowAllZones)
}

// AddAllCandidates mocks base method
func (m *MockOptions) AddAllCandidates() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddAllCandidates")
	ret0, _ := ret[0].(bool)
	return ret0
}

// AddAllCandidates indicates an expected call of AddAllCandidates
func (mr *MockOptionsMockRecorder) AddAllCandidates() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddAllCandidates", reflect.TypeOf((*MockOptions)(nil).AddAllCandidates))
}

// SetAddAllCandidates mocks base method
func (m *MockOptions) SetAddAllCandidates(addAllCandidates bool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetAddAllCandidates", addAllCandidates)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetAddAllCandidates indicates an expected call of SetAddAllCandidates
func (mr *MockOptionsMockRecorder) SetAddAllCandidates(addAllCandidates interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetAddAllCandidates", reflect.TypeOf((*MockOptions)(nil).SetAddAllCandidates), addAllCandidates)
}

// IsSharded mocks base method
func (m *MockOptions) IsSharded() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsSharded")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsSharded indicates an expected call of IsSharded
func (mr *MockOptionsMockRecorder) IsSharded() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsSharded", reflect.TypeOf((*MockOptions)(nil).IsSharded))
}

// SetIsSharded mocks base method
func (m *MockOptions) SetIsSharded(sharded bool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIsSharded", sharded)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetIsSharded indicates an expected call of SetIsSharded
func (mr *MockOptionsMockRecorder) SetIsSharded(sharded interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIsSharded", reflect.TypeOf((*MockOptions)(nil).SetIsSharded), sharded)
}

// ShardStateMode mocks base method
func (m *MockOptions) ShardStateMode() ShardStateMode {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ShardStateMode")
	ret0, _ := ret[0].(ShardStateMode)
	return ret0
}

// ShardStateMode indicates an expected call of ShardStateMode
func (mr *MockOptionsMockRecorder) ShardStateMode() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ShardStateMode", reflect.TypeOf((*MockOptions)(nil).ShardStateMode))
}

// SetShardStateMode mocks base method
func (m *MockOptions) SetShardStateMode(value ShardStateMode) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetShardStateMode", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetShardStateMode indicates an expected call of SetShardStateMode
func (mr *MockOptionsMockRecorder) SetShardStateMode(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetShardStateMode", reflect.TypeOf((*MockOptions)(nil).SetShardStateMode), value)
}

// Dryrun mocks base method
func (m *MockOptions) Dryrun() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Dryrun")
	ret0, _ := ret[0].(bool)
	return ret0
}

// Dryrun indicates an expected call of Dryrun
func (mr *MockOptionsMockRecorder) Dryrun() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Dryrun", reflect.TypeOf((*MockOptions)(nil).Dryrun))
}

// SetDryrun mocks base method
func (m *MockOptions) SetDryrun(d bool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetDryrun", d)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetDryrun indicates an expected call of SetDryrun
func (mr *MockOptionsMockRecorder) SetDryrun(d interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetDryrun", reflect.TypeOf((*MockOptions)(nil).SetDryrun), d)
}

// IsMirrored mocks base method
func (m *MockOptions) IsMirrored() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsMirrored")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsMirrored indicates an expected call of IsMirrored
func (mr *MockOptionsMockRecorder) IsMirrored() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsMirrored", reflect.TypeOf((*MockOptions)(nil).IsMirrored))
}

// SetIsMirrored mocks base method
func (m_2 *MockOptions) SetIsMirrored(m bool) Options {
	m_2.ctrl.T.Helper()
	ret := m_2.ctrl.Call(m_2, "SetIsMirrored", m)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetIsMirrored indicates an expected call of SetIsMirrored
func (mr *MockOptionsMockRecorder) SetIsMirrored(m interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIsMirrored", reflect.TypeOf((*MockOptions)(nil).SetIsMirrored), m)
}

// IsStaged mocks base method
func (m *MockOptions) IsStaged() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsStaged")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsStaged indicates an expected call of IsStaged
func (mr *MockOptionsMockRecorder) IsStaged() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsStaged", reflect.TypeOf((*MockOptions)(nil).IsStaged))
}

// SetIsStaged mocks base method
func (m *MockOptions) SetIsStaged(v bool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIsStaged", v)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetIsStaged indicates an expected call of SetIsStaged
func (mr *MockOptionsMockRecorder) SetIsStaged(v interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIsStaged", reflect.TypeOf((*MockOptions)(nil).SetIsStaged), v)
}

// InstrumentOptions mocks base method
func (m *MockOptions) InstrumentOptions() instrument.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InstrumentOptions")
	ret0, _ := ret[0].(instrument.Options)
	return ret0
}

// InstrumentOptions indicates an expected call of InstrumentOptions
func (mr *MockOptionsMockRecorder) InstrumentOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InstrumentOptions", reflect.TypeOf((*MockOptions)(nil).InstrumentOptions))
}

// SetInstrumentOptions mocks base method
func (m *MockOptions) SetInstrumentOptions(iopts instrument.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetInstrumentOptions", iopts)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetInstrumentOptions indicates an expected call of SetInstrumentOptions
func (mr *MockOptionsMockRecorder) SetInstrumentOptions(iopts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetInstrumentOptions", reflect.TypeOf((*MockOptions)(nil).SetInstrumentOptions), iopts)
}

// ValidZone mocks base method
func (m *MockOptions) ValidZone() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ValidZone")
	ret0, _ := ret[0].(string)
	return ret0
}

// ValidZone indicates an expected call of ValidZone
func (mr *MockOptionsMockRecorder) ValidZone() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ValidZone", reflect.TypeOf((*MockOptions)(nil).ValidZone))
}

// SetValidZone mocks base method
func (m *MockOptions) SetValidZone(z string) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetValidZone", z)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetValidZone indicates an expected call of SetValidZone
func (mr *MockOptionsMockRecorder) SetValidZone(z interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetValidZone", reflect.TypeOf((*MockOptions)(nil).SetValidZone), z)
}

// PlacementCutoverNanosFn mocks base method
func (m *MockOptions) PlacementCutoverNanosFn() TimeNanosFn {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PlacementCutoverNanosFn")
	ret0, _ := ret[0].(TimeNanosFn)
	return ret0
}

// PlacementCutoverNanosFn indicates an expected call of PlacementCutoverNanosFn
func (mr *MockOptionsMockRecorder) PlacementCutoverNanosFn() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PlacementCutoverNanosFn", reflect.TypeOf((*MockOptions)(nil).PlacementCutoverNanosFn))
}

// SetPlacementCutoverNanosFn mocks base method
func (m *MockOptions) SetPlacementCutoverNanosFn(fn TimeNanosFn) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetPlacementCutoverNanosFn", fn)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetPlacementCutoverNanosFn indicates an expected call of SetPlacementCutoverNanosFn
func (mr *MockOptionsMockRecorder) SetPlacementCutoverNanosFn(fn interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetPlacementCutoverNanosFn", reflect.TypeOf((*MockOptions)(nil).SetPlacementCutoverNanosFn), fn)
}

// ShardCutoverNanosFn mocks base method
func (m *MockOptions) ShardCutoverNanosFn() TimeNanosFn {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ShardCutoverNanosFn")
	ret0, _ := ret[0].(TimeNanosFn)
	return ret0
}

// ShardCutoverNanosFn indicates an expected call of ShardCutoverNanosFn
func (mr *MockOptionsMockRecorder) ShardCutoverNanosFn() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ShardCutoverNanosFn", reflect.TypeOf((*MockOptions)(nil).ShardCutoverNanosFn))
}

// SetShardCutoverNanosFn mocks base method
func (m *MockOptions) SetShardCutoverNanosFn(fn TimeNanosFn) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetShardCutoverNanosFn", fn)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetShardCutoverNanosFn indicates an expected call of SetShardCutoverNanosFn
func (mr *MockOptionsMockRecorder) SetShardCutoverNanosFn(fn interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetShardCutoverNanosFn", reflect.TypeOf((*MockOptions)(nil).SetShardCutoverNanosFn), fn)
}

// ShardCutoffNanosFn mocks base method
func (m *MockOptions) ShardCutoffNanosFn() TimeNanosFn {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ShardCutoffNanosFn")
	ret0, _ := ret[0].(TimeNanosFn)
	return ret0
}

// ShardCutoffNanosFn indicates an expected call of ShardCutoffNanosFn
func (mr *MockOptionsMockRecorder) ShardCutoffNanosFn() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ShardCutoffNanosFn", reflect.TypeOf((*MockOptions)(nil).ShardCutoffNanosFn))
}

// SetShardCutoffNanosFn mocks base method
func (m *MockOptions) SetShardCutoffNanosFn(fn TimeNanosFn) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetShardCutoffNanosFn", fn)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetShardCutoffNanosFn indicates an expected call of SetShardCutoffNanosFn
func (mr *MockOptionsMockRecorder) SetShardCutoffNanosFn(fn interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetShardCutoffNanosFn", reflect.TypeOf((*MockOptions)(nil).SetShardCutoffNanosFn), fn)
}

// IsShardCutoverFn mocks base method
func (m *MockOptions) IsShardCutoverFn() ShardValidateFn {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsShardCutoverFn")
	ret0, _ := ret[0].(ShardValidateFn)
	return ret0
}

// IsShardCutoverFn indicates an expected call of IsShardCutoverFn
func (mr *MockOptionsMockRecorder) IsShardCutoverFn() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsShardCutoverFn", reflect.TypeOf((*MockOptions)(nil).IsShardCutoverFn))
}

// SetIsShardCutoverFn mocks base method
func (m *MockOptions) SetIsShardCutoverFn(fn ShardValidateFn) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIsShardCutoverFn", fn)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetIsShardCutoverFn indicates an expected call of SetIsShardCutoverFn
func (mr *MockOptionsMockRecorder) SetIsShardCutoverFn(fn interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIsShardCutoverFn", reflect.TypeOf((*MockOptions)(nil).SetIsShardCutoverFn), fn)
}

// IsShardCutoffFn mocks base method
func (m *MockOptions) IsShardCutoffFn() ShardValidateFn {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsShardCutoffFn")
	ret0, _ := ret[0].(ShardValidateFn)
	return ret0
}

// IsShardCutoffFn indicates an expected call of IsShardCutoffFn
func (mr *MockOptionsMockRecorder) IsShardCutoffFn() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsShardCutoffFn", reflect.TypeOf((*MockOptions)(nil).IsShardCutoffFn))
}

// SetIsShardCutoffFn mocks base method
func (m *MockOptions) SetIsShardCutoffFn(fn ShardValidateFn) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIsShardCutoffFn", fn)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetIsShardCutoffFn indicates an expected call of SetIsShardCutoffFn
func (mr *MockOptionsMockRecorder) SetIsShardCutoffFn(fn interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIsShardCutoffFn", reflect.TypeOf((*MockOptions)(nil).SetIsShardCutoffFn), fn)
}

// ValidateFnBeforeUpdate mocks base method
func (m *MockOptions) ValidateFnBeforeUpdate() ValidateFn {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ValidateFnBeforeUpdate")
	ret0, _ := ret[0].(ValidateFn)
	return ret0
}

// ValidateFnBeforeUpdate indicates an expected call of ValidateFnBeforeUpdate
func (mr *MockOptionsMockRecorder) ValidateFnBeforeUpdate() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ValidateFnBeforeUpdate", reflect.TypeOf((*MockOptions)(nil).ValidateFnBeforeUpdate))
}

// SetValidateFnBeforeUpdate mocks base method
func (m *MockOptions) SetValidateFnBeforeUpdate(fn ValidateFn) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetValidateFnBeforeUpdate", fn)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetValidateFnBeforeUpdate indicates an expected call of SetValidateFnBeforeUpdate
func (mr *MockOptionsMockRecorder) SetValidateFnBeforeUpdate(fn interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetValidateFnBeforeUpdate", reflect.TypeOf((*MockOptions)(nil).SetValidateFnBeforeUpdate), fn)
}

// NowFn mocks base method
func (m *MockOptions) NowFn() clock.NowFn {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NowFn")
	ret0, _ := ret[0].(clock.NowFn)
	return ret0
}

// NowFn indicates an expected call of NowFn
func (mr *MockOptionsMockRecorder) NowFn() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NowFn", reflect.TypeOf((*MockOptions)(nil).NowFn))
}

// SetNowFn mocks base method
func (m *MockOptions) SetNowFn(fn clock.NowFn) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetNowFn", fn)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetNowFn indicates an expected call of SetNowFn
func (mr *MockOptionsMockRecorder) SetNowFn(fn interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetNowFn", reflect.TypeOf((*MockOptions)(nil).SetNowFn), fn)
}

// MockStorage is a mock of Storage interface
type MockStorage struct {
	ctrl     *gomock.Controller
	recorder *MockStorageMockRecorder
}

// MockStorageMockRecorder is the mock recorder for MockStorage
type MockStorageMockRecorder struct {
	mock *MockStorage
}

// NewMockStorage creates a new mock instance
func NewMockStorage(ctrl *gomock.Controller) *MockStorage {
	mock := &MockStorage{ctrl: ctrl}
	mock.recorder = &MockStorageMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockStorage) EXPECT() *MockStorageMockRecorder {
	return m.recorder
}

// Set mocks base method
func (m *MockStorage) Set(p Placement) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Set", p)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Set indicates an expected call of Set
func (mr *MockStorageMockRecorder) Set(p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Set", reflect.TypeOf((*MockStorage)(nil).Set), p)
}

// CheckAndSet mocks base method
func (m *MockStorage) CheckAndSet(p Placement, version int) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CheckAndSet", p, version)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CheckAndSet indicates an expected call of CheckAndSet
func (mr *MockStorageMockRecorder) CheckAndSet(p, version interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CheckAndSet", reflect.TypeOf((*MockStorage)(nil).CheckAndSet), p, version)
}

// SetIfNotExist mocks base method
func (m *MockStorage) SetIfNotExist(p Placement) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIfNotExist", p)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetIfNotExist indicates an expected call of SetIfNotExist
func (mr *MockStorageMockRecorder) SetIfNotExist(p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIfNotExist", reflect.TypeOf((*MockStorage)(nil).SetIfNotExist), p)
}

// Placement mocks base method
func (m *MockStorage) Placement() (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Placement")
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Placement indicates an expected call of Placement
func (mr *MockStorageMockRecorder) Placement() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Placement", reflect.TypeOf((*MockStorage)(nil).Placement))
}

// Watch mocks base method
func (m *MockStorage) Watch() (Watch, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Watch")
	ret0, _ := ret[0].(Watch)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Watch indicates an expected call of Watch
func (mr *MockStorageMockRecorder) Watch() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Watch", reflect.TypeOf((*MockStorage)(nil).Watch))
}

// Delete mocks base method
func (m *MockStorage) Delete() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Delete")
	ret0, _ := ret[0].(error)
	return ret0
}

// Delete indicates an expected call of Delete
func (mr *MockStorageMockRecorder) Delete() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Delete", reflect.TypeOf((*MockStorage)(nil).Delete))
}

// SetProto mocks base method
func (m *MockStorage) SetProto(p proto.Message) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetProto", p)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetProto indicates an expected call of SetProto
func (mr *MockStorageMockRecorder) SetProto(p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetProto", reflect.TypeOf((*MockStorage)(nil).SetProto), p)
}

// CheckAndSetProto mocks base method
func (m *MockStorage) CheckAndSetProto(p proto.Message, version int) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CheckAndSetProto", p, version)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CheckAndSetProto indicates an expected call of CheckAndSetProto
func (mr *MockStorageMockRecorder) CheckAndSetProto(p, version interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CheckAndSetProto", reflect.TypeOf((*MockStorage)(nil).CheckAndSetProto), p, version)
}

// Proto mocks base method
func (m *MockStorage) Proto() (proto.Message, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Proto")
	ret0, _ := ret[0].(proto.Message)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// Proto indicates an expected call of Proto
func (mr *MockStorageMockRecorder) Proto() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Proto", reflect.TypeOf((*MockStorage)(nil).Proto))
}

// PlacementForVersion mocks base method
func (m *MockStorage) PlacementForVersion(version int) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PlacementForVersion", version)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PlacementForVersion indicates an expected call of PlacementForVersion
func (mr *MockStorageMockRecorder) PlacementForVersion(version interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PlacementForVersion", reflect.TypeOf((*MockStorage)(nil).PlacementForVersion), version)
}

// MockService is a mock of Service interface
type MockService struct {
	ctrl     *gomock.Controller
	recorder *MockServiceMockRecorder
}

// MockServiceMockRecorder is the mock recorder for MockService
type MockServiceMockRecorder struct {
	mock *MockService
}

// NewMockService creates a new mock instance
func NewMockService(ctrl *gomock.Controller) *MockService {
	mock := &MockService{ctrl: ctrl}
	mock.recorder = &MockServiceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockService) EXPECT() *MockServiceMockRecorder {
	return m.recorder
}

// Set mocks base method
func (m *MockService) Set(p Placement) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Set", p)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Set indicates an expected call of Set
func (mr *MockServiceMockRecorder) Set(p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Set", reflect.TypeOf((*MockService)(nil).Set), p)
}

// CheckAndSet mocks base method
func (m *MockService) CheckAndSet(p Placement, version int) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CheckAndSet", p, version)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CheckAndSet indicates an expected call of CheckAndSet
func (mr *MockServiceMockRecorder) CheckAndSet(p, version interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CheckAndSet", reflect.TypeOf((*MockService)(nil).CheckAndSet), p, version)
}

// SetIfNotExist mocks base method
func (m *MockService) SetIfNotExist(p Placement) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIfNotExist", p)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetIfNotExist indicates an expected call of SetIfNotExist
func (mr *MockServiceMockRecorder) SetIfNotExist(p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIfNotExist", reflect.TypeOf((*MockService)(nil).SetIfNotExist), p)
}

// Placement mocks base method
func (m *MockService) Placement() (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Placement")
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Placement indicates an expected call of Placement
func (mr *MockServiceMockRecorder) Placement() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Placement", reflect.TypeOf((*MockService)(nil).Placement))
}

// Watch mocks base method
func (m *MockService) Watch() (Watch, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Watch")
	ret0, _ := ret[0].(Watch)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Watch indicates an expected call of Watch
func (mr *MockServiceMockRecorder) Watch() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Watch", reflect.TypeOf((*MockService)(nil).Watch))
}

// Delete mocks base method
func (m *MockService) Delete() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Delete")
	ret0, _ := ret[0].(error)
	return ret0
}

// Delete indicates an expected call of Delete
func (mr *MockServiceMockRecorder) Delete() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Delete", reflect.TypeOf((*MockService)(nil).Delete))
}

// SetProto mocks base method
func (m *MockService) SetProto(p proto.Message) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetProto", p)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SetProto indicates an expected call of SetProto
func (mr *MockServiceMockRecorder) SetProto(p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetProto", reflect.TypeOf((*MockService)(nil).SetProto), p)
}

// CheckAndSetProto mocks base method
func (m *MockService) CheckAndSetProto(p proto.Message, version int) (int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CheckAndSetProto", p, version)
	ret0, _ := ret[0].(int)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// CheckAndSetProto indicates an expected call of CheckAndSetProto
func (mr *MockServiceMockRecorder) CheckAndSetProto(p, version interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CheckAndSetProto", reflect.TypeOf((*MockService)(nil).CheckAndSetProto), p, version)
}

// Proto mocks base method
func (m *MockService) Proto() (proto.Message, int, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Proto")
	ret0, _ := ret[0].(proto.Message)
	ret1, _ := ret[1].(int)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// Proto indicates an expected call of Proto
func (mr *MockServiceMockRecorder) Proto() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Proto", reflect.TypeOf((*MockService)(nil).Proto))
}

// PlacementForVersion mocks base method
func (m *MockService) PlacementForVersion(version int) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PlacementForVersion", version)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PlacementForVersion indicates an expected call of PlacementForVersion
func (mr *MockServiceMockRecorder) PlacementForVersion(version interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PlacementForVersion", reflect.TypeOf((*MockService)(nil).PlacementForVersion), version)
}

// BuildInitialPlacement mocks base method
func (m *MockService) BuildInitialPlacement(instances []Instance, numShards, rf int) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BuildInitialPlacement", instances, numShards, rf)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BuildInitialPlacement indicates an expected call of BuildInitialPlacement
func (mr *MockServiceMockRecorder) BuildInitialPlacement(instances, numShards, rf interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BuildInitialPlacement", reflect.TypeOf((*MockService)(nil).BuildInitialPlacement), instances, numShards, rf)
}

// AddReplica mocks base method
func (m *MockService) AddReplica() (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddReplica")
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddReplica indicates an expected call of AddReplica
func (mr *MockServiceMockRecorder) AddReplica() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddReplica", reflect.TypeOf((*MockService)(nil).AddReplica))
}

// AddInstances mocks base method
func (m *MockService) AddInstances(candidates []Instance) (Placement, []Instance, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddInstances", candidates)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].([]Instance)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// AddInstances indicates an expected call of AddInstances
func (mr *MockServiceMockRecorder) AddInstances(candidates interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddInstances", reflect.TypeOf((*MockService)(nil).AddInstances), candidates)
}

// RemoveInstances mocks base method
func (m *MockService) RemoveInstances(leavingInstanceIDs []string) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RemoveInstances", leavingInstanceIDs)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RemoveInstances indicates an expected call of RemoveInstances
func (mr *MockServiceMockRecorder) RemoveInstances(leavingInstanceIDs interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveInstances", reflect.TypeOf((*MockService)(nil).RemoveInstances), leavingInstanceIDs)
}

// ReplaceInstances mocks base method
func (m *MockService) ReplaceInstances(leavingInstanceIDs []string, candidates []Instance) (Placement, []Instance, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplaceInstances", leavingInstanceIDs, candidates)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].([]Instance)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// ReplaceInstances indicates an expected call of ReplaceInstances
func (mr *MockServiceMockRecorder) ReplaceInstances(leavingInstanceIDs, candidates interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplaceInstances", reflect.TypeOf((*MockService)(nil).ReplaceInstances), leavingInstanceIDs, candidates)
}

// MarkShardsAvailable mocks base method
func (m *MockService) MarkShardsAvailable(instanceID string, shardIDs ...uint32) (Placement, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{instanceID}
	for _, a := range shardIDs {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "MarkShardsAvailable", varargs...)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MarkShardsAvailable indicates an expected call of MarkShardsAvailable
func (mr *MockServiceMockRecorder) MarkShardsAvailable(instanceID interface{}, shardIDs ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{instanceID}, shardIDs...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MarkShardsAvailable", reflect.TypeOf((*MockService)(nil).MarkShardsAvailable), varargs...)
}

// MarkInstanceAvailable mocks base method
func (m *MockService) MarkInstanceAvailable(instanceID string) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MarkInstanceAvailable", instanceID)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MarkInstanceAvailable indicates an expected call of MarkInstanceAvailable
func (mr *MockServiceMockRecorder) MarkInstanceAvailable(instanceID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MarkInstanceAvailable", reflect.TypeOf((*MockService)(nil).MarkInstanceAvailable), instanceID)
}

// MarkAllShardsAvailable mocks base method
func (m *MockService) MarkAllShardsAvailable() (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MarkAllShardsAvailable")
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MarkAllShardsAvailable indicates an expected call of MarkAllShardsAvailable
func (mr *MockServiceMockRecorder) MarkAllShardsAvailable() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MarkAllShardsAvailable", reflect.TypeOf((*MockService)(nil).MarkAllShardsAvailable))
}

// MockAlgorithm is a mock of Algorithm interface
type MockAlgorithm struct {
	ctrl     *gomock.Controller
	recorder *MockAlgorithmMockRecorder
}

// MockAlgorithmMockRecorder is the mock recorder for MockAlgorithm
type MockAlgorithmMockRecorder struct {
	mock *MockAlgorithm
}

// NewMockAlgorithm creates a new mock instance
func NewMockAlgorithm(ctrl *gomock.Controller) *MockAlgorithm {
	mock := &MockAlgorithm{ctrl: ctrl}
	mock.recorder = &MockAlgorithmMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockAlgorithm) EXPECT() *MockAlgorithmMockRecorder {
	return m.recorder
}

// InitialPlacement mocks base method
func (m *MockAlgorithm) InitialPlacement(instances []Instance, shards []uint32, rf int) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InitialPlacement", instances, shards, rf)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// InitialPlacement indicates an expected call of InitialPlacement
func (mr *MockAlgorithmMockRecorder) InitialPlacement(instances, shards, rf interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InitialPlacement", reflect.TypeOf((*MockAlgorithm)(nil).InitialPlacement), instances, shards, rf)
}

// AddReplica mocks base method
func (m *MockAlgorithm) AddReplica(p Placement) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddReplica", p)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddReplica indicates an expected call of AddReplica
func (mr *MockAlgorithmMockRecorder) AddReplica(p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddReplica", reflect.TypeOf((*MockAlgorithm)(nil).AddReplica), p)
}

// AddInstances mocks base method
func (m *MockAlgorithm) AddInstances(p Placement, instances []Instance) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AddInstances", p, instances)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AddInstances indicates an expected call of AddInstances
func (mr *MockAlgorithmMockRecorder) AddInstances(p, instances interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AddInstances", reflect.TypeOf((*MockAlgorithm)(nil).AddInstances), p, instances)
}

// RemoveInstances mocks base method
func (m *MockAlgorithm) RemoveInstances(p Placement, leavingInstanceIDs []string) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RemoveInstances", p, leavingInstanceIDs)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// RemoveInstances indicates an expected call of RemoveInstances
func (mr *MockAlgorithmMockRecorder) RemoveInstances(p, leavingInstanceIDs interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RemoveInstances", reflect.TypeOf((*MockAlgorithm)(nil).RemoveInstances), p, leavingInstanceIDs)
}

// ReplaceInstances mocks base method
func (m *MockAlgorithm) ReplaceInstances(p Placement, leavingInstanecIDs []string, addingInstances []Instance) (Placement, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReplaceInstances", p, leavingInstanecIDs, addingInstances)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReplaceInstances indicates an expected call of ReplaceInstances
func (mr *MockAlgorithmMockRecorder) ReplaceInstances(p, leavingInstanecIDs, addingInstances interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReplaceInstances", reflect.TypeOf((*MockAlgorithm)(nil).ReplaceInstances), p, leavingInstanecIDs, addingInstances)
}

// IsCompatibleWith mocks base method
func (m *MockAlgorithm) IsCompatibleWith(p Placement) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsCompatibleWith", p)
	ret0, _ := ret[0].(error)
	return ret0
}

// IsCompatibleWith indicates an expected call of IsCompatibleWith
func (mr *MockAlgorithmMockRecorder) IsCompatibleWith(p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsCompatibleWith", reflect.TypeOf((*MockAlgorithm)(nil).IsCompatibleWith), p)
}

// MarkShardsAvailable mocks base method
func (m *MockAlgorithm) MarkShardsAvailable(p Placement, instanceID string, shardIDs ...uint32) (Placement, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{p, instanceID}
	for _, a := range shardIDs {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "MarkShardsAvailable", varargs...)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// MarkShardsAvailable indicates an expected call of MarkShardsAvailable
func (mr *MockAlgorithmMockRecorder) MarkShardsAvailable(p, instanceID interface{}, shardIDs ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{p, instanceID}, shardIDs...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MarkShardsAvailable", reflect.TypeOf((*MockAlgorithm)(nil).MarkShardsAvailable), varargs...)
}

// MarkAllShardsAvailable mocks base method
func (m *MockAlgorithm) MarkAllShardsAvailable(p Placement) (Placement, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MarkAllShardsAvailable", p)
	ret0, _ := ret[0].(Placement)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// MarkAllShardsAvailable indicates an expected call of MarkAllShardsAvailable
func (mr *MockAlgorithmMockRecorder) MarkAllShardsAvailable(p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MarkAllShardsAvailable", reflect.TypeOf((*MockAlgorithm)(nil).MarkAllShardsAvailable), p)
}

// MockInstanceSelector is a mock of InstanceSelector interface
type MockInstanceSelector struct {
	ctrl     *gomock.Controller
	recorder *MockInstanceSelectorMockRecorder
}

// MockInstanceSelectorMockRecorder is the mock recorder for MockInstanceSelector
type MockInstanceSelectorMockRecorder struct {
	mock *MockInstanceSelector
}

// NewMockInstanceSelector creates a new mock instance
func NewMockInstanceSelector(ctrl *gomock.Controller) *MockInstanceSelector {
	mock := &MockInstanceSelector{ctrl: ctrl}
	mock.recorder = &MockInstanceSelectorMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockInstanceSelector) EXPECT() *MockInstanceSelectorMockRecorder {
	return m.recorder
}

// SelectInitialInstances mocks base method
func (m *MockInstanceSelector) SelectInitialInstances(candidates []Instance, rf int) ([]Instance, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SelectInitialInstances", candidates, rf)
	ret0, _ := ret[0].([]Instance)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SelectInitialInstances indicates an expected call of SelectInitialInstances
func (mr *MockInstanceSelectorMockRecorder) SelectInitialInstances(candidates, rf interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SelectInitialInstances", reflect.TypeOf((*MockInstanceSelector)(nil).SelectInitialInstances), candidates, rf)
}

// SelectAddingInstances mocks base method
func (m *MockInstanceSelector) SelectAddingInstances(candidates []Instance, p Placement) ([]Instance, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SelectAddingInstances", candidates, p)
	ret0, _ := ret[0].([]Instance)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SelectAddingInstances indicates an expected call of SelectAddingInstances
func (mr *MockInstanceSelectorMockRecorder) SelectAddingInstances(candidates, p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SelectAddingInstances", reflect.TypeOf((*MockInstanceSelector)(nil).SelectAddingInstances), candidates, p)
}

// SelectReplaceInstances mocks base method
func (m *MockInstanceSelector) SelectReplaceInstances(candidates []Instance, leavingInstanceIDs []string, p Placement) ([]Instance, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SelectReplaceInstances", candidates, leavingInstanceIDs, p)
	ret0, _ := ret[0].([]Instance)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SelectReplaceInstances indicates an expected call of SelectReplaceInstances
func (mr *MockInstanceSelectorMockRecorder) SelectReplaceInstances(candidates, leavingInstanceIDs, p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SelectReplaceInstances", reflect.TypeOf((*MockInstanceSelector)(nil).SelectReplaceInstances), candidates, leavingInstanceIDs, p)
}

// MockDeploymentPlanner is a mock of DeploymentPlanner interface
type MockDeploymentPlanner struct {
	ctrl     *gomock.Controller
	recorder *MockDeploymentPlannerMockRecorder
}

// MockDeploymentPlannerMockRecorder is the mock recorder for MockDeploymentPlanner
type MockDeploymentPlannerMockRecorder struct {
	mock *MockDeploymentPlanner
}

// NewMockDeploymentPlanner creates a new mock instance
func NewMockDeploymentPlanner(ctrl *gomock.Controller) *MockDeploymentPlanner {
	mock := &MockDeploymentPlanner{ctrl: ctrl}
	mock.recorder = &MockDeploymentPlannerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockDeploymentPlanner) EXPECT() *MockDeploymentPlannerMockRecorder {
	return m.recorder
}

// DeploymentSteps mocks base method
func (m *MockDeploymentPlanner) DeploymentSteps(p Placement) [][]Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeploymentSteps", p)
	ret0, _ := ret[0].([][]Instance)
	return ret0
}

// DeploymentSteps indicates an expected call of DeploymentSteps
func (mr *MockDeploymentPlannerMockRecorder) DeploymentSteps(p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeploymentSteps", reflect.TypeOf((*MockDeploymentPlanner)(nil).DeploymentSteps), p)
}

// MockDeploymentOptions is a mock of DeploymentOptions interface
type MockDeploymentOptions struct {
	ctrl     *gomock.Controller
	recorder *MockDeploymentOptionsMockRecorder
}

// MockDeploymentOptionsMockRecorder is the mock recorder for MockDeploymentOptions
type MockDeploymentOptionsMockRecorder struct {
	mock *MockDeploymentOptions
}

// NewMockDeploymentOptions creates a new mock instance
func NewMockDeploymentOptions(ctrl *gomock.Controller) *MockDeploymentOptions {
	mock := &MockDeploymentOptions{ctrl: ctrl}
	mock.recorder = &MockDeploymentOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockDeploymentOptions) EXPECT() *MockDeploymentOptionsMockRecorder {
	return m.recorder
}

// MaxStepSize mocks base method
func (m *MockDeploymentOptions) MaxStepSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MaxStepSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// MaxStepSize indicates an expected call of MaxStepSize
func (mr *MockDeploymentOptionsMockRecorder) MaxStepSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MaxStepSize", reflect.TypeOf((*MockDeploymentOptions)(nil).MaxStepSize))
}

// SetMaxStepSize mocks base method
func (m *MockDeploymentOptions) SetMaxStepSize(stepSize int) DeploymentOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetMaxStepSize", stepSize)
	ret0, _ := ret[0].(DeploymentOptions)
	return ret0
}

// SetMaxStepSize indicates an expected call of SetMaxStepSize
func (mr *MockDeploymentOptionsMockRecorder) SetMaxStepSize(stepSize interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetMaxStepSize", reflect.TypeOf((*MockDeploymentOptions)(nil).SetMaxStepSize), stepSize)
}
