// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/m3db/m3/src/cluster/services/types.go

// Copyright (c) 2019 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Package services is a generated GoMock package.
package services

import (
	"reflect"
	"time"

	"github.com/m3db/m3/src/cluster/generated/proto/metadatapb"
	"github.com/m3db/m3/src/cluster/placement"
	"github.com/m3db/m3/src/cluster/services/leader/campaign"
	"github.com/m3db/m3/src/cluster/shard"
	"github.com/m3db/m3/src/x/instrument"
	"github.com/m3db/m3/src/x/watch"

	"github.com/golang/mock/gomock"
)

// MockServices is a mock of Services interface
type MockServices struct {
	ctrl     *gomock.Controller
	recorder *MockServicesMockRecorder
}

// MockServicesMockRecorder is the mock recorder for MockServices
type MockServicesMockRecorder struct {
	mock *MockServices
}

// NewMockServices creates a new mock instance
func NewMockServices(ctrl *gomock.Controller) *MockServices {
	mock := &MockServices{ctrl: ctrl}
	mock.recorder = &MockServicesMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockServices) EXPECT() *MockServicesMockRecorder {
	return m.recorder
}

// Advertise mocks base method
func (m *MockServices) Advertise(ad Advertisement) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Advertise", ad)
	ret0, _ := ret[0].(error)
	return ret0
}

// Advertise indicates an expected call of Advertise
func (mr *MockServicesMockRecorder) Advertise(ad interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Advertise", reflect.TypeOf((*MockServices)(nil).Advertise), ad)
}

// Unadvertise mocks base method
func (m *MockServices) Unadvertise(service ServiceID, id string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Unadvertise", service, id)
	ret0, _ := ret[0].(error)
	return ret0
}

// Unadvertise indicates an expected call of Unadvertise
func (mr *MockServicesMockRecorder) Unadvertise(service, id interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Unadvertise", reflect.TypeOf((*MockServices)(nil).Unadvertise), service, id)
}

// Query mocks base method
func (m *MockServices) Query(service ServiceID, opts QueryOptions) (Service, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Query", service, opts)
	ret0, _ := ret[0].(Service)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Query indicates an expected call of Query
func (mr *MockServicesMockRecorder) Query(service, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Query", reflect.TypeOf((*MockServices)(nil).Query), service, opts)
}

// Watch mocks base method
func (m *MockServices) Watch(service ServiceID, opts QueryOptions) (Watch, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Watch", service, opts)
	ret0, _ := ret[0].(Watch)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Watch indicates an expected call of Watch
func (mr *MockServicesMockRecorder) Watch(service, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Watch", reflect.TypeOf((*MockServices)(nil).Watch), service, opts)
}

// Metadata mocks base method
func (m *MockServices) Metadata(sid ServiceID) (Metadata, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Metadata", sid)
	ret0, _ := ret[0].(Metadata)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Metadata indicates an expected call of Metadata
func (mr *MockServicesMockRecorder) Metadata(sid interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Metadata", reflect.TypeOf((*MockServices)(nil).Metadata), sid)
}

// SetMetadata mocks base method
func (m_2 *MockServices) SetMetadata(sid ServiceID, m Metadata) error {
	m_2.ctrl.T.Helper()
	ret := m_2.ctrl.Call(m_2, "SetMetadata", sid, m)
	ret0, _ := ret[0].(error)
	return ret0
}

// SetMetadata indicates an expected call of SetMetadata
func (mr *MockServicesMockRecorder) SetMetadata(sid, m interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetMetadata", reflect.TypeOf((*MockServices)(nil).SetMetadata), sid, m)
}

// DeleteMetadata mocks base method
func (m *MockServices) DeleteMetadata(sid ServiceID) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DeleteMetadata", sid)
	ret0, _ := ret[0].(error)
	return ret0
}

// DeleteMetadata indicates an expected call of DeleteMetadata
func (mr *MockServicesMockRecorder) DeleteMetadata(sid interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DeleteMetadata", reflect.TypeOf((*MockServices)(nil).DeleteMetadata), sid)
}

// PlacementService mocks base method
func (m *MockServices) PlacementService(sid ServiceID, popts placement.Options) (placement.Service, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PlacementService", sid, popts)
	ret0, _ := ret[0].(placement.Service)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PlacementService indicates an expected call of PlacementService
func (mr *MockServicesMockRecorder) PlacementService(sid, popts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PlacementService", reflect.TypeOf((*MockServices)(nil).PlacementService), sid, popts)
}

// HeartbeatService mocks base method
func (m *MockServices) HeartbeatService(service ServiceID) (HeartbeatService, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HeartbeatService", service)
	ret0, _ := ret[0].(HeartbeatService)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// HeartbeatService indicates an expected call of HeartbeatService
func (mr *MockServicesMockRecorder) HeartbeatService(service interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HeartbeatService", reflect.TypeOf((*MockServices)(nil).HeartbeatService), service)
}

// LeaderService mocks base method
func (m *MockServices) LeaderService(service ServiceID, opts ElectionOptions) (LeaderService, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LeaderService", service, opts)
	ret0, _ := ret[0].(LeaderService)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// LeaderService indicates an expected call of LeaderService
func (mr *MockServicesMockRecorder) LeaderService(service, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LeaderService", reflect.TypeOf((*MockServices)(nil).LeaderService), service, opts)
}

// MockOptions is a mock of Options interface
type MockOptions struct {
	ctrl     *gomock.Controller
	recorder *MockOptionsMockRecorder
}

// MockOptionsMockRecorder is the mock recorder for MockOptions
type MockOptionsMockRecorder struct {
	mock *MockOptions
}

// NewMockOptions creates a new mock instance
func NewMockOptions(ctrl *gomock.Controller) *MockOptions {
	mock := &MockOptions{ctrl: ctrl}
	mock.recorder = &MockOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockOptions) EXPECT() *MockOptionsMockRecorder {
	return m.recorder
}

// InitTimeout mocks base method
func (m *MockOptions) InitTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InitTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// InitTimeout indicates an expected call of InitTimeout
func (mr *MockOptionsMockRecorder) InitTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InitTimeout", reflect.TypeOf((*MockOptions)(nil).InitTimeout))
}

// SetInitTimeout mocks base method
func (m *MockOptions) SetInitTimeout(t time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetInitTimeout", t)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetInitTimeout indicates an expected call of SetInitTimeout
func (mr *MockOptionsMockRecorder) SetInitTimeout(t interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetInitTimeout", reflect.TypeOf((*MockOptions)(nil).SetInitTimeout), t)
}

// KVGen mocks base method
func (m *MockOptions) KVGen() KVGen {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "KVGen")
	ret0, _ := ret[0].(KVGen)
	return ret0
}

// KVGen indicates an expected call of KVGen
func (mr *MockOptionsMockRecorder) KVGen() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "KVGen", reflect.TypeOf((*MockOptions)(nil).KVGen))
}

// SetKVGen mocks base method
func (m *MockOptions) SetKVGen(gen KVGen) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetKVGen", gen)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetKVGen indicates an expected call of SetKVGen
func (mr *MockOptionsMockRecorder) SetKVGen(gen interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetKVGen", reflect.TypeOf((*MockOptions)(nil).SetKVGen), gen)
}

// HeartbeatGen mocks base method
func (m *MockOptions) HeartbeatGen() HeartbeatGen {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HeartbeatGen")
	ret0, _ := ret[0].(HeartbeatGen)
	return ret0
}

// HeartbeatGen indicates an expected call of HeartbeatGen
func (mr *MockOptionsMockRecorder) HeartbeatGen() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HeartbeatGen", reflect.TypeOf((*MockOptions)(nil).HeartbeatGen))
}

// SetHeartbeatGen mocks base method
func (m *MockOptions) SetHeartbeatGen(gen HeartbeatGen) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHeartbeatGen", gen)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetHeartbeatGen indicates an expected call of SetHeartbeatGen
func (mr *MockOptionsMockRecorder) SetHeartbeatGen(gen interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHeartbeatGen", reflect.TypeOf((*MockOptions)(nil).SetHeartbeatGen), gen)
}

// LeaderGen mocks base method
func (m *MockOptions) LeaderGen() LeaderGen {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LeaderGen")
	ret0, _ := ret[0].(LeaderGen)
	return ret0
}

// LeaderGen indicates an expected call of LeaderGen
func (mr *MockOptionsMockRecorder) LeaderGen() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LeaderGen", reflect.TypeOf((*MockOptions)(nil).LeaderGen))
}

// SetLeaderGen mocks base method
func (m *MockOptions) SetLeaderGen(gen LeaderGen) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetLeaderGen", gen)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetLeaderGen indicates an expected call of SetLeaderGen
func (mr *MockOptionsMockRecorder) SetLeaderGen(gen interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetLeaderGen", reflect.TypeOf((*MockOptions)(nil).SetLeaderGen), gen)
}

// InstrumentsOptions mocks base method
func (m *MockOptions) InstrumentsOptions() instrument.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InstrumentsOptions")
	ret0, _ := ret[0].(instrument.Options)
	return ret0
}

// InstrumentsOptions indicates an expected call of InstrumentsOptions
func (mr *MockOptionsMockRecorder) InstrumentsOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InstrumentsOptions", reflect.TypeOf((*MockOptions)(nil).InstrumentsOptions))
}

// SetInstrumentsOptions mocks base method
func (m *MockOptions) SetInstrumentsOptions(iopts instrument.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetInstrumentsOptions", iopts)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetInstrumentsOptions indicates an expected call of SetInstrumentsOptions
func (mr *MockOptionsMockRecorder) SetInstrumentsOptions(iopts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetInstrumentsOptions", reflect.TypeOf((*MockOptions)(nil).SetInstrumentsOptions), iopts)
}

// NamespaceOptions mocks base method
func (m *MockOptions) NamespaceOptions() NamespaceOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NamespaceOptions")
	ret0, _ := ret[0].(NamespaceOptions)
	return ret0
}

// NamespaceOptions indicates an expected call of NamespaceOptions
func (mr *MockOptionsMockRecorder) NamespaceOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NamespaceOptions", reflect.TypeOf((*MockOptions)(nil).NamespaceOptions))
}

// SetNamespaceOptions mocks base method
func (m *MockOptions) SetNamespaceOptions(opts NamespaceOptions) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetNamespaceOptions", opts)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetNamespaceOptions indicates an expected call of SetNamespaceOptions
func (mr *MockOptionsMockRecorder) SetNamespaceOptions(opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetNamespaceOptions", reflect.TypeOf((*MockOptions)(nil).SetNamespaceOptions), opts)
}

// Validate mocks base method
func (m *MockOptions) Validate() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Validate")
	ret0, _ := ret[0].(error)
	return ret0
}

// Validate indicates an expected call of Validate
func (mr *MockOptionsMockRecorder) Validate() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Validate", reflect.TypeOf((*MockOptions)(nil).Validate))
}

// MockNamespaceOptions is a mock of NamespaceOptions interface
type MockNamespaceOptions struct {
	ctrl     *gomock.Controller
	recorder *MockNamespaceOptionsMockRecorder
}

// MockNamespaceOptionsMockRecorder is the mock recorder for MockNamespaceOptions
type MockNamespaceOptionsMockRecorder struct {
	mock *MockNamespaceOptions
}

// NewMockNamespaceOptions creates a new mock instance
func NewMockNamespaceOptions(ctrl *gomock.Controller) *MockNamespaceOptions {
	mock := &MockNamespaceOptions{ctrl: ctrl}
	mock.recorder = &MockNamespaceOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockNamespaceOptions) EXPECT() *MockNamespaceOptionsMockRecorder {
	return m.recorder
}

// PlacementNamespace mocks base method
func (m *MockNamespaceOptions) PlacementNamespace() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PlacementNamespace")
	ret0, _ := ret[0].(string)
	return ret0
}

// PlacementNamespace indicates an expected call of PlacementNamespace
func (mr *MockNamespaceOptionsMockRecorder) PlacementNamespace() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PlacementNamespace", reflect.TypeOf((*MockNamespaceOptions)(nil).PlacementNamespace))
}

// SetPlacementNamespace mocks base method
func (m *MockNamespaceOptions) SetPlacementNamespace(v string) NamespaceOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetPlacementNamespace", v)
	ret0, _ := ret[0].(NamespaceOptions)
	return ret0
}

// SetPlacementNamespace indicates an expected call of SetPlacementNamespace
func (mr *MockNamespaceOptionsMockRecorder) SetPlacementNamespace(v interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetPlacementNamespace", reflect.TypeOf((*MockNamespaceOptions)(nil).SetPlacementNamespace), v)
}

// MetadataNamespace mocks base method
func (m *MockNamespaceOptions) MetadataNamespace() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MetadataNamespace")
	ret0, _ := ret[0].(string)
	return ret0
}

// MetadataNamespace indicates an expected call of MetadataNamespace
func (mr *MockNamespaceOptionsMockRecorder) MetadataNamespace() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MetadataNamespace", reflect.TypeOf((*MockNamespaceOptions)(nil).MetadataNamespace))
}

// SetMetadataNamespace mocks base method
func (m *MockNamespaceOptions) SetMetadataNamespace(v string) NamespaceOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetMetadataNamespace", v)
	ret0, _ := ret[0].(NamespaceOptions)
	return ret0
}

// SetMetadataNamespace indicates an expected call of SetMetadataNamespace
func (mr *MockNamespaceOptionsMockRecorder) SetMetadataNamespace(v interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetMetadataNamespace", reflect.TypeOf((*MockNamespaceOptions)(nil).SetMetadataNamespace), v)
}

// MockOverrideOptions is a mock of OverrideOptions interface
type MockOverrideOptions struct {
	ctrl     *gomock.Controller
	recorder *MockOverrideOptionsMockRecorder
}

// MockOverrideOptionsMockRecorder is the mock recorder for MockOverrideOptions
type MockOverrideOptionsMockRecorder struct {
	mock *MockOverrideOptions
}

// NewMockOverrideOptions creates a new mock instance
func NewMockOverrideOptions(ctrl *gomock.Controller) *MockOverrideOptions {
	mock := &MockOverrideOptions{ctrl: ctrl}
	mock.recorder = &MockOverrideOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockOverrideOptions) EXPECT() *MockOverrideOptionsMockRecorder {
	return m.recorder
}

// NamespaceOptions mocks base method
func (m *MockOverrideOptions) NamespaceOptions() NamespaceOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NamespaceOptions")
	ret0, _ := ret[0].(NamespaceOptions)
	return ret0
}

// NamespaceOptions indicates an expected call of NamespaceOptions
func (mr *MockOverrideOptionsMockRecorder) NamespaceOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NamespaceOptions", reflect.TypeOf((*MockOverrideOptions)(nil).NamespaceOptions))
}

// SetNamespaceOptions mocks base method
func (m *MockOverrideOptions) SetNamespaceOptions(opts NamespaceOptions) OverrideOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetNamespaceOptions", opts)
	ret0, _ := ret[0].(OverrideOptions)
	return ret0
}

// SetNamespaceOptions indicates an expected call of SetNamespaceOptions
func (mr *MockOverrideOptionsMockRecorder) SetNamespaceOptions(opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetNamespaceOptions", reflect.TypeOf((*MockOverrideOptions)(nil).SetNamespaceOptions), opts)
}

// MockWatch is a mock of Watch interface
type MockWatch struct {
	ctrl     *gomock.Controller
	recorder *MockWatchMockRecorder
}

// MockWatchMockRecorder is the mock recorder for MockWatch
type MockWatchMockRecorder struct {
	mock *MockWatch
}

// NewMockWatch creates a new mock instance
func NewMockWatch(ctrl *gomock.Controller) *MockWatch {
	mock := &MockWatch{ctrl: ctrl}
	mock.recorder = &MockWatchMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockWatch) EXPECT() *MockWatchMockRecorder {
	return m.recorder
}

// Close mocks base method
func (m *MockWatch) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close
func (mr *MockWatchMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockWatch)(nil).Close))
}

// C mocks base method
func (m *MockWatch) C() <-chan struct{} {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "C")
	ret0, _ := ret[0].(<-chan struct{})
	return ret0
}

// C indicates an expected call of C
func (mr *MockWatchMockRecorder) C() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "C", reflect.TypeOf((*MockWatch)(nil).C))
}

// Get mocks base method
func (m *MockWatch) Get() Service {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Get")
	ret0, _ := ret[0].(Service)
	return ret0
}

// Get indicates an expected call of Get
func (mr *MockWatchMockRecorder) Get() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Get", reflect.TypeOf((*MockWatch)(nil).Get))
}

// MockService is a mock of Service interface
type MockService struct {
	ctrl     *gomock.Controller
	recorder *MockServiceMockRecorder
}

// MockServiceMockRecorder is the mock recorder for MockService
type MockServiceMockRecorder struct {
	mock *MockService
}

// NewMockService creates a new mock instance
func NewMockService(ctrl *gomock.Controller) *MockService {
	mock := &MockService{ctrl: ctrl}
	mock.recorder = &MockServiceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockService) EXPECT() *MockServiceMockRecorder {
	return m.recorder
}

// Instance mocks base method
func (m *MockService) Instance(instanceID string) (ServiceInstance, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Instance", instanceID)
	ret0, _ := ret[0].(ServiceInstance)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Instance indicates an expected call of Instance
func (mr *MockServiceMockRecorder) Instance(instanceID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Instance", reflect.TypeOf((*MockService)(nil).Instance), instanceID)
}

// Instances mocks base method
func (m *MockService) Instances() []ServiceInstance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Instances")
	ret0, _ := ret[0].([]ServiceInstance)
	return ret0
}

// Instances indicates an expected call of Instances
func (mr *MockServiceMockRecorder) Instances() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Instances", reflect.TypeOf((*MockService)(nil).Instances))
}

// SetInstances mocks base method
func (m *MockService) SetInstances(insts []ServiceInstance) Service {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetInstances", insts)
	ret0, _ := ret[0].(Service)
	return ret0
}

// SetInstances indicates an expected call of SetInstances
func (mr *MockServiceMockRecorder) SetInstances(insts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetInstances", reflect.TypeOf((*MockService)(nil).SetInstances), insts)
}

// Replication mocks base method
func (m *MockService) Replication() ServiceReplication {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Replication")
	ret0, _ := ret[0].(ServiceReplication)
	return ret0
}

// Replication indicates an expected call of Replication
func (mr *MockServiceMockRecorder) Replication() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Replication", reflect.TypeOf((*MockService)(nil).Replication))
}

// SetReplication mocks base method
func (m *MockService) SetReplication(r ServiceReplication) Service {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetReplication", r)
	ret0, _ := ret[0].(Service)
	return ret0
}

// SetReplication indicates an expected call of SetReplication
func (mr *MockServiceMockRecorder) SetReplication(r interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetReplication", reflect.TypeOf((*MockService)(nil).SetReplication), r)
}

// Sharding mocks base method
func (m *MockService) Sharding() ServiceSharding {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Sharding")
	ret0, _ := ret[0].(ServiceSharding)
	return ret0
}

// Sharding indicates an expected call of Sharding
func (mr *MockServiceMockRecorder) Sharding() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Sharding", reflect.TypeOf((*MockService)(nil).Sharding))
}

// SetSharding mocks base method
func (m *MockService) SetSharding(s ServiceSharding) Service {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetSharding", s)
	ret0, _ := ret[0].(Service)
	return ret0
}

// SetSharding indicates an expected call of SetSharding
func (mr *MockServiceMockRecorder) SetSharding(s interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSharding", reflect.TypeOf((*MockService)(nil).SetSharding), s)
}

// MockServiceReplication is a mock of ServiceReplication interface
type MockServiceReplication struct {
	ctrl     *gomock.Controller
	recorder *MockServiceReplicationMockRecorder
}

// MockServiceReplicationMockRecorder is the mock recorder for MockServiceReplication
type MockServiceReplicationMockRecorder struct {
	mock *MockServiceReplication
}

// NewMockServiceReplication creates a new mock instance
func NewMockServiceReplication(ctrl *gomock.Controller) *MockServiceReplication {
	mock := &MockServiceReplication{ctrl: ctrl}
	mock.recorder = &MockServiceReplicationMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockServiceReplication) EXPECT() *MockServiceReplicationMockRecorder {
	return m.recorder
}

// Replicas mocks base method
func (m *MockServiceReplication) Replicas() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Replicas")
	ret0, _ := ret[0].(int)
	return ret0
}

// Replicas indicates an expected call of Replicas
func (mr *MockServiceReplicationMockRecorder) Replicas() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Replicas", reflect.TypeOf((*MockServiceReplication)(nil).Replicas))
}

// SetReplicas mocks base method
func (m *MockServiceReplication) SetReplicas(r int) ServiceReplication {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetReplicas", r)
	ret0, _ := ret[0].(ServiceReplication)
	return ret0
}

// SetReplicas indicates an expected call of SetReplicas
func (mr *MockServiceReplicationMockRecorder) SetReplicas(r interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetReplicas", reflect.TypeOf((*MockServiceReplication)(nil).SetReplicas), r)
}

// MockServiceSharding is a mock of ServiceSharding interface
type MockServiceSharding struct {
	ctrl     *gomock.Controller
	recorder *MockServiceShardingMockRecorder
}

// MockServiceShardingMockRecorder is the mock recorder for MockServiceSharding
type MockServiceShardingMockRecorder struct {
	mock *MockServiceSharding
}

// NewMockServiceSharding creates a new mock instance
func NewMockServiceSharding(ctrl *gomock.Controller) *MockServiceSharding {
	mock := &MockServiceSharding{ctrl: ctrl}
	mock.recorder = &MockServiceShardingMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockServiceSharding) EXPECT() *MockServiceShardingMockRecorder {
	return m.recorder
}

// NumShards mocks base method
func (m *MockServiceSharding) NumShards() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NumShards")
	ret0, _ := ret[0].(int)
	return ret0
}

// NumShards indicates an expected call of NumShards
func (mr *MockServiceShardingMockRecorder) NumShards() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NumShards", reflect.TypeOf((*MockServiceSharding)(nil).NumShards))
}

// SetNumShards mocks base method
func (m *MockServiceSharding) SetNumShards(n int) ServiceSharding {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetNumShards", n)
	ret0, _ := ret[0].(ServiceSharding)
	return ret0
}

// SetNumShards indicates an expected call of SetNumShards
func (mr *MockServiceShardingMockRecorder) SetNumShards(n interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetNumShards", reflect.TypeOf((*MockServiceSharding)(nil).SetNumShards), n)
}

// IsSharded mocks base method
func (m *MockServiceSharding) IsSharded() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsSharded")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsSharded indicates an expected call of IsSharded
func (mr *MockServiceShardingMockRecorder) IsSharded() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsSharded", reflect.TypeOf((*MockServiceSharding)(nil).IsSharded))
}

// SetIsSharded mocks base method
func (m *MockServiceSharding) SetIsSharded(s bool) ServiceSharding {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIsSharded", s)
	ret0, _ := ret[0].(ServiceSharding)
	return ret0
}

// SetIsSharded indicates an expected call of SetIsSharded
func (mr *MockServiceShardingMockRecorder) SetIsSharded(s interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIsSharded", reflect.TypeOf((*MockServiceSharding)(nil).SetIsSharded), s)
}

// MockServiceInstance is a mock of ServiceInstance interface
type MockServiceInstance struct {
	ctrl     *gomock.Controller
	recorder *MockServiceInstanceMockRecorder
}

// MockServiceInstanceMockRecorder is the mock recorder for MockServiceInstance
type MockServiceInstanceMockRecorder struct {
	mock *MockServiceInstance
}

// NewMockServiceInstance creates a new mock instance
func NewMockServiceInstance(ctrl *gomock.Controller) *MockServiceInstance {
	mock := &MockServiceInstance{ctrl: ctrl}
	mock.recorder = &MockServiceInstanceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockServiceInstance) EXPECT() *MockServiceInstanceMockRecorder {
	return m.recorder
}

// ServiceID mocks base method
func (m *MockServiceInstance) ServiceID() ServiceID {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ServiceID")
	ret0, _ := ret[0].(ServiceID)
	return ret0
}

// ServiceID indicates an expected call of ServiceID
func (mr *MockServiceInstanceMockRecorder) ServiceID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ServiceID", reflect.TypeOf((*MockServiceInstance)(nil).ServiceID))
}

// SetServiceID mocks base method
func (m *MockServiceInstance) SetServiceID(service ServiceID) ServiceInstance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetServiceID", service)
	ret0, _ := ret[0].(ServiceInstance)
	return ret0
}

// SetServiceID indicates an expected call of SetServiceID
func (mr *MockServiceInstanceMockRecorder) SetServiceID(service interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetServiceID", reflect.TypeOf((*MockServiceInstance)(nil).SetServiceID), service)
}

// InstanceID mocks base method
func (m *MockServiceInstance) InstanceID() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InstanceID")
	ret0, _ := ret[0].(string)
	return ret0
}

// InstanceID indicates an expected call of InstanceID
func (mr *MockServiceInstanceMockRecorder) InstanceID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InstanceID", reflect.TypeOf((*MockServiceInstance)(nil).InstanceID))
}

// SetInstanceID mocks base method
func (m *MockServiceInstance) SetInstanceID(id string) ServiceInstance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetInstanceID", id)
	ret0, _ := ret[0].(ServiceInstance)
	return ret0
}

// SetInstanceID indicates an expected call of SetInstanceID
func (mr *MockServiceInstanceMockRecorder) SetInstanceID(id interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetInstanceID", reflect.TypeOf((*MockServiceInstance)(nil).SetInstanceID), id)
}

// Endpoint mocks base method
func (m *MockServiceInstance) Endpoint() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Endpoint")
	ret0, _ := ret[0].(string)
	return ret0
}

// Endpoint indicates an expected call of Endpoint
func (mr *MockServiceInstanceMockRecorder) Endpoint() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Endpoint", reflect.TypeOf((*MockServiceInstance)(nil).Endpoint))
}

// SetEndpoint mocks base method
func (m *MockServiceInstance) SetEndpoint(e string) ServiceInstance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetEndpoint", e)
	ret0, _ := ret[0].(ServiceInstance)
	return ret0
}

// SetEndpoint indicates an expected call of SetEndpoint
func (mr *MockServiceInstanceMockRecorder) SetEndpoint(e interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetEndpoint", reflect.TypeOf((*MockServiceInstance)(nil).SetEndpoint), e)
}

// Shards mocks base method
func (m *MockServiceInstance) Shards() shard.Shards {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Shards")
	ret0, _ := ret[0].(shard.Shards)
	return ret0
}

// Shards indicates an expected call of Shards
func (mr *MockServiceInstanceMockRecorder) Shards() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Shards", reflect.TypeOf((*MockServiceInstance)(nil).Shards))
}

// SetShards mocks base method
func (m *MockServiceInstance) SetShards(s shard.Shards) ServiceInstance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetShards", s)
	ret0, _ := ret[0].(ServiceInstance)
	return ret0
}

// SetShards indicates an expected call of SetShards
func (mr *MockServiceInstanceMockRecorder) SetShards(s interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetShards", reflect.TypeOf((*MockServiceInstance)(nil).SetShards), s)
}

// MockAdvertisement is a mock of Advertisement interface
type MockAdvertisement struct {
	ctrl     *gomock.Controller
	recorder *MockAdvertisementMockRecorder
}

// MockAdvertisementMockRecorder is the mock recorder for MockAdvertisement
type MockAdvertisementMockRecorder struct {
	mock *MockAdvertisement
}

// NewMockAdvertisement creates a new mock instance
func NewMockAdvertisement(ctrl *gomock.Controller) *MockAdvertisement {
	mock := &MockAdvertisement{ctrl: ctrl}
	mock.recorder = &MockAdvertisementMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockAdvertisement) EXPECT() *MockAdvertisementMockRecorder {
	return m.recorder
}

// ServiceID mocks base method
func (m *MockAdvertisement) ServiceID() ServiceID {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ServiceID")
	ret0, _ := ret[0].(ServiceID)
	return ret0
}

// ServiceID indicates an expected call of ServiceID
func (mr *MockAdvertisementMockRecorder) ServiceID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ServiceID", reflect.TypeOf((*MockAdvertisement)(nil).ServiceID))
}

// SetServiceID mocks base method
func (m *MockAdvertisement) SetServiceID(service ServiceID) Advertisement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetServiceID", service)
	ret0, _ := ret[0].(Advertisement)
	return ret0
}

// SetServiceID indicates an expected call of SetServiceID
func (mr *MockAdvertisementMockRecorder) SetServiceID(service interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetServiceID", reflect.TypeOf((*MockAdvertisement)(nil).SetServiceID), service)
}

// Health mocks base method
func (m *MockAdvertisement) Health() func() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Health")
	ret0, _ := ret[0].(func() error)
	return ret0
}

// Health indicates an expected call of Health
func (mr *MockAdvertisementMockRecorder) Health() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Health", reflect.TypeOf((*MockAdvertisement)(nil).Health))
}

// SetHealth mocks base method
func (m *MockAdvertisement) SetHealth(health func() error) Advertisement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHealth", health)
	ret0, _ := ret[0].(Advertisement)
	return ret0
}

// SetHealth indicates an expected call of SetHealth
func (mr *MockAdvertisementMockRecorder) SetHealth(health interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHealth", reflect.TypeOf((*MockAdvertisement)(nil).SetHealth), health)
}

// PlacementInstance mocks base method
func (m *MockAdvertisement) PlacementInstance() placement.Instance {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PlacementInstance")
	ret0, _ := ret[0].(placement.Instance)
	return ret0
}

// PlacementInstance indicates an expected call of PlacementInstance
func (mr *MockAdvertisementMockRecorder) PlacementInstance() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PlacementInstance", reflect.TypeOf((*MockAdvertisement)(nil).PlacementInstance))
}

// SetPlacementInstance mocks base method
func (m *MockAdvertisement) SetPlacementInstance(p placement.Instance) Advertisement {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetPlacementInstance", p)
	ret0, _ := ret[0].(Advertisement)
	return ret0
}

// SetPlacementInstance indicates an expected call of SetPlacementInstance
func (mr *MockAdvertisementMockRecorder) SetPlacementInstance(p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetPlacementInstance", reflect.TypeOf((*MockAdvertisement)(nil).SetPlacementInstance), p)
}

// MockServiceID is a mock of ServiceID interface
type MockServiceID struct {
	ctrl     *gomock.Controller
	recorder *MockServiceIDMockRecorder
}

// MockServiceIDMockRecorder is the mock recorder for MockServiceID
type MockServiceIDMockRecorder struct {
	mock *MockServiceID
}

// NewMockServiceID creates a new mock instance
func NewMockServiceID(ctrl *gomock.Controller) *MockServiceID {
	mock := &MockServiceID{ctrl: ctrl}
	mock.recorder = &MockServiceIDMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockServiceID) EXPECT() *MockServiceIDMockRecorder {
	return m.recorder
}

// Name mocks base method
func (m *MockServiceID) Name() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Name")
	ret0, _ := ret[0].(string)
	return ret0
}

// Name indicates an expected call of Name
func (mr *MockServiceIDMockRecorder) Name() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Name", reflect.TypeOf((*MockServiceID)(nil).Name))
}

// SetName mocks base method
func (m *MockServiceID) SetName(s string) ServiceID {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetName", s)
	ret0, _ := ret[0].(ServiceID)
	return ret0
}

// SetName indicates an expected call of SetName
func (mr *MockServiceIDMockRecorder) SetName(s interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetName", reflect.TypeOf((*MockServiceID)(nil).SetName), s)
}

// Environment mocks base method
func (m *MockServiceID) Environment() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Environment")
	ret0, _ := ret[0].(string)
	return ret0
}

// Environment indicates an expected call of Environment
func (mr *MockServiceIDMockRecorder) Environment() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Environment", reflect.TypeOf((*MockServiceID)(nil).Environment))
}

// SetEnvironment mocks base method
func (m *MockServiceID) SetEnvironment(env string) ServiceID {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetEnvironment", env)
	ret0, _ := ret[0].(ServiceID)
	return ret0
}

// SetEnvironment indicates an expected call of SetEnvironment
func (mr *MockServiceIDMockRecorder) SetEnvironment(env interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetEnvironment", reflect.TypeOf((*MockServiceID)(nil).SetEnvironment), env)
}

// Zone mocks base method
func (m *MockServiceID) Zone() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Zone")
	ret0, _ := ret[0].(string)
	return ret0
}

// Zone indicates an expected call of Zone
func (mr *MockServiceIDMockRecorder) Zone() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Zone", reflect.TypeOf((*MockServiceID)(nil).Zone))
}

// SetZone mocks base method
func (m *MockServiceID) SetZone(zone string) ServiceID {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetZone", zone)
	ret0, _ := ret[0].(ServiceID)
	return ret0
}

// SetZone indicates an expected call of SetZone
func (mr *MockServiceIDMockRecorder) SetZone(zone interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetZone", reflect.TypeOf((*MockServiceID)(nil).SetZone), zone)
}

// Equal mocks base method
func (m *MockServiceID) Equal(value ServiceID) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Equal", value)
	ret0, _ := ret[0].(bool)
	return ret0
}

// Equal indicates an expected call of Equal
func (mr *MockServiceIDMockRecorder) Equal(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Equal", reflect.TypeOf((*MockServiceID)(nil).Equal), value)
}

// String mocks base method
func (m *MockServiceID) String() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "String")
	ret0, _ := ret[0].(string)
	return ret0
}

// String indicates an expected call of String
func (mr *MockServiceIDMockRecorder) String() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "String", reflect.TypeOf((*MockServiceID)(nil).String))
}

// MockQueryOptions is a mock of QueryOptions interface
type MockQueryOptions struct {
	ctrl     *gomock.Controller
	recorder *MockQueryOptionsMockRecorder
}

// MockQueryOptionsMockRecorder is the mock recorder for MockQueryOptions
type MockQueryOptionsMockRecorder struct {
	mock *MockQueryOptions
}

// NewMockQueryOptions creates a new mock instance
func NewMockQueryOptions(ctrl *gomock.Controller) *MockQueryOptions {
	mock := &MockQueryOptions{ctrl: ctrl}
	mock.recorder = &MockQueryOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockQueryOptions) EXPECT() *MockQueryOptionsMockRecorder {
	return m.recorder
}

// IncludeUnhealthy mocks base method
func (m *MockQueryOptions) IncludeUnhealthy() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IncludeUnhealthy")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IncludeUnhealthy indicates an expected call of IncludeUnhealthy
func (mr *MockQueryOptionsMockRecorder) IncludeUnhealthy() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IncludeUnhealthy", reflect.TypeOf((*MockQueryOptions)(nil).IncludeUnhealthy))
}

// SetIncludeUnhealthy mocks base method
func (m *MockQueryOptions) SetIncludeUnhealthy(h bool) QueryOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIncludeUnhealthy", h)
	ret0, _ := ret[0].(QueryOptions)
	return ret0
}

// SetIncludeUnhealthy indicates an expected call of SetIncludeUnhealthy
func (mr *MockQueryOptionsMockRecorder) SetIncludeUnhealthy(h interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIncludeUnhealthy", reflect.TypeOf((*MockQueryOptions)(nil).SetIncludeUnhealthy), h)
}

// MockMetadata is a mock of Metadata interface
type MockMetadata struct {
	ctrl     *gomock.Controller
	recorder *MockMetadataMockRecorder
}

// MockMetadataMockRecorder is the mock recorder for MockMetadata
type MockMetadataMockRecorder struct {
	mock *MockMetadata
}

// NewMockMetadata creates a new mock instance
func NewMockMetadata(ctrl *gomock.Controller) *MockMetadata {
	mock := &MockMetadata{ctrl: ctrl}
	mock.recorder = &MockMetadataMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockMetadata) EXPECT() *MockMetadataMockRecorder {
	return m.recorder
}

// String mocks base method
func (m *MockMetadata) String() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "String")
	ret0, _ := ret[0].(string)
	return ret0
}

// String indicates an expected call of String
func (mr *MockMetadataMockRecorder) String() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "String", reflect.TypeOf((*MockMetadata)(nil).String))
}

// Port mocks base method
func (m *MockMetadata) Port() uint32 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Port")
	ret0, _ := ret[0].(uint32)
	return ret0
}

// Port indicates an expected call of Port
func (mr *MockMetadataMockRecorder) Port() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Port", reflect.TypeOf((*MockMetadata)(nil).Port))
}

// SetPort mocks base method
func (m *MockMetadata) SetPort(p uint32) Metadata {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetPort", p)
	ret0, _ := ret[0].(Metadata)
	return ret0
}

// SetPort indicates an expected call of SetPort
func (mr *MockMetadataMockRecorder) SetPort(p interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetPort", reflect.TypeOf((*MockMetadata)(nil).SetPort), p)
}

// LivenessInterval mocks base method
func (m *MockMetadata) LivenessInterval() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LivenessInterval")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// LivenessInterval indicates an expected call of LivenessInterval
func (mr *MockMetadataMockRecorder) LivenessInterval() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LivenessInterval", reflect.TypeOf((*MockMetadata)(nil).LivenessInterval))
}

// SetLivenessInterval mocks base method
func (m *MockMetadata) SetLivenessInterval(l time.Duration) Metadata {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetLivenessInterval", l)
	ret0, _ := ret[0].(Metadata)
	return ret0
}

// SetLivenessInterval indicates an expected call of SetLivenessInterval
func (mr *MockMetadataMockRecorder) SetLivenessInterval(l interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetLivenessInterval", reflect.TypeOf((*MockMetadata)(nil).SetLivenessInterval), l)
}

// HeartbeatInterval mocks base method
func (m *MockMetadata) HeartbeatInterval() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HeartbeatInterval")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// HeartbeatInterval indicates an expected call of HeartbeatInterval
func (mr *MockMetadataMockRecorder) HeartbeatInterval() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HeartbeatInterval", reflect.TypeOf((*MockMetadata)(nil).HeartbeatInterval))
}

// SetHeartbeatInterval mocks base method
func (m *MockMetadata) SetHeartbeatInterval(h time.Duration) Metadata {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHeartbeatInterval", h)
	ret0, _ := ret[0].(Metadata)
	return ret0
}

// SetHeartbeatInterval indicates an expected call of SetHeartbeatInterval
func (mr *MockMetadataMockRecorder) SetHeartbeatInterval(h interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHeartbeatInterval", reflect.TypeOf((*MockMetadata)(nil).SetHeartbeatInterval), h)
}

// Proto mocks base method
func (m *MockMetadata) Proto() (*metadatapb.Metadata, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Proto")
	ret0, _ := ret[0].(*metadatapb.Metadata)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Proto indicates an expected call of Proto
func (mr *MockMetadataMockRecorder) Proto() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Proto", reflect.TypeOf((*MockMetadata)(nil).Proto))
}

// MockHeartbeatService is a mock of HeartbeatService interface
type MockHeartbeatService struct {
	ctrl     *gomock.Controller
	recorder *MockHeartbeatServiceMockRecorder
}

// MockHeartbeatServiceMockRecorder is the mock recorder for MockHeartbeatService
type MockHeartbeatServiceMockRecorder struct {
	mock *MockHeartbeatService
}

// NewMockHeartbeatService creates a new mock instance
func NewMockHeartbeatService(ctrl *gomock.Controller) *MockHeartbeatService {
	mock := &MockHeartbeatService{ctrl: ctrl}
	mock.recorder = &MockHeartbeatServiceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockHeartbeatService) EXPECT() *MockHeartbeatServiceMockRecorder {
	return m.recorder
}

// Heartbeat mocks base method
func (m *MockHeartbeatService) Heartbeat(instance placement.Instance, ttl time.Duration) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Heartbeat", instance, ttl)
	ret0, _ := ret[0].(error)
	return ret0
}

// Heartbeat indicates an expected call of Heartbeat
func (mr *MockHeartbeatServiceMockRecorder) Heartbeat(instance, ttl interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Heartbeat", reflect.TypeOf((*MockHeartbeatService)(nil).Heartbeat), instance, ttl)
}

// Get mocks base method
func (m *MockHeartbeatService) Get() ([]string, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Get")
	ret0, _ := ret[0].([]string)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Get indicates an expected call of Get
func (mr *MockHeartbeatServiceMockRecorder) Get() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Get", reflect.TypeOf((*MockHeartbeatService)(nil).Get))
}

// GetInstances mocks base method
func (m *MockHeartbeatService) GetInstances() ([]placement.Instance, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetInstances")
	ret0, _ := ret[0].([]placement.Instance)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetInstances indicates an expected call of GetInstances
func (mr *MockHeartbeatServiceMockRecorder) GetInstances() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetInstances", reflect.TypeOf((*MockHeartbeatService)(nil).GetInstances))
}

// Delete mocks base method
func (m *MockHeartbeatService) Delete(instance string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Delete", instance)
	ret0, _ := ret[0].(error)
	return ret0
}

// Delete indicates an expected call of Delete
func (mr *MockHeartbeatServiceMockRecorder) Delete(instance interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Delete", reflect.TypeOf((*MockHeartbeatService)(nil).Delete), instance)
}

// Watch mocks base method
func (m *MockHeartbeatService) Watch() (watch.Watch, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Watch")
	ret0, _ := ret[0].(watch.Watch)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Watch indicates an expected call of Watch
func (mr *MockHeartbeatServiceMockRecorder) Watch() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Watch", reflect.TypeOf((*MockHeartbeatService)(nil).Watch))
}

// MockElectionOptions is a mock of ElectionOptions interface
type MockElectionOptions struct {
	ctrl     *gomock.Controller
	recorder *MockElectionOptionsMockRecorder
}

// MockElectionOptionsMockRecorder is the mock recorder for MockElectionOptions
type MockElectionOptionsMockRecorder struct {
	mock *MockElectionOptions
}

// NewMockElectionOptions creates a new mock instance
func NewMockElectionOptions(ctrl *gomock.Controller) *MockElectionOptions {
	mock := &MockElectionOptions{ctrl: ctrl}
	mock.recorder = &MockElectionOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockElectionOptions) EXPECT() *MockElectionOptionsMockRecorder {
	return m.recorder
}

// LeaderTimeout mocks base method
func (m *MockElectionOptions) LeaderTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LeaderTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// LeaderTimeout indicates an expected call of LeaderTimeout
func (mr *MockElectionOptionsMockRecorder) LeaderTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LeaderTimeout", reflect.TypeOf((*MockElectionOptions)(nil).LeaderTimeout))
}

// SetLeaderTimeout mocks base method
func (m *MockElectionOptions) SetLeaderTimeout(t time.Duration) ElectionOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetLeaderTimeout", t)
	ret0, _ := ret[0].(ElectionOptions)
	return ret0
}

// SetLeaderTimeout indicates an expected call of SetLeaderTimeout
func (mr *MockElectionOptionsMockRecorder) SetLeaderTimeout(t interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetLeaderTimeout", reflect.TypeOf((*MockElectionOptions)(nil).SetLeaderTimeout), t)
}

// ResignTimeout mocks base method
func (m *MockElectionOptions) ResignTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ResignTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// ResignTimeout indicates an expected call of ResignTimeout
func (mr *MockElectionOptionsMockRecorder) ResignTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ResignTimeout", reflect.TypeOf((*MockElectionOptions)(nil).ResignTimeout))
}

// SetResignTimeout mocks base method
func (m *MockElectionOptions) SetResignTimeout(t time.Duration) ElectionOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetResignTimeout", t)
	ret0, _ := ret[0].(ElectionOptions)
	return ret0
}

// SetResignTimeout indicates an expected call of SetResignTimeout
func (mr *MockElectionOptionsMockRecorder) SetResignTimeout(t interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetResignTimeout", reflect.TypeOf((*MockElectionOptions)(nil).SetResignTimeout), t)
}

// TTLSecs mocks base method
func (m *MockElectionOptions) TTLSecs() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TTLSecs")
	ret0, _ := ret[0].(int)
	return ret0
}

// TTLSecs indicates an expected call of TTLSecs
func (mr *MockElectionOptionsMockRecorder) TTLSecs() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TTLSecs", reflect.TypeOf((*MockElectionOptions)(nil).TTLSecs))
}

// SetTTLSecs mocks base method
func (m *MockElectionOptions) SetTTLSecs(ttl int) ElectionOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTTLSecs", ttl)
	ret0, _ := ret[0].(ElectionOptions)
	return ret0
}

// SetTTLSecs indicates an expected call of SetTTLSecs
func (mr *MockElectionOptionsMockRecorder) SetTTLSecs(ttl interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTTLSecs", reflect.TypeOf((*MockElectionOptions)(nil).SetTTLSecs), ttl)
}

// MockCampaignOptions is a mock of CampaignOptions interface
type MockCampaignOptions struct {
	ctrl     *gomock.Controller
	recorder *MockCampaignOptionsMockRecorder
}

// MockCampaignOptionsMockRecorder is the mock recorder for MockCampaignOptions
type MockCampaignOptionsMockRecorder struct {
	mock *MockCampaignOptions
}

// NewMockCampaignOptions creates a new mock instance
func NewMockCampaignOptions(ctrl *gomock.Controller) *MockCampaignOptions {
	mock := &MockCampaignOptions{ctrl: ctrl}
	mock.recorder = &MockCampaignOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockCampaignOptions) EXPECT() *MockCampaignOptionsMockRecorder {
	return m.recorder
}

// LeaderValue mocks base method
func (m *MockCampaignOptions) LeaderValue() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LeaderValue")
	ret0, _ := ret[0].(string)
	return ret0
}

// LeaderValue indicates an expected call of LeaderValue
func (mr *MockCampaignOptionsMockRecorder) LeaderValue() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LeaderValue", reflect.TypeOf((*MockCampaignOptions)(nil).LeaderValue))
}

// SetLeaderValue mocks base method
func (m *MockCampaignOptions) SetLeaderValue(v string) CampaignOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetLeaderValue", v)
	ret0, _ := ret[0].(CampaignOptions)
	return ret0
}

// SetLeaderValue indicates an expected call of SetLeaderValue
func (mr *MockCampaignOptionsMockRecorder) SetLeaderValue(v interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetLeaderValue", reflect.TypeOf((*MockCampaignOptions)(nil).SetLeaderValue), v)
}

// MockLeaderService is a mock of LeaderService interface
type MockLeaderService struct {
	ctrl     *gomock.Controller
	recorder *MockLeaderServiceMockRecorder
}

// MockLeaderServiceMockRecorder is the mock recorder for MockLeaderService
type MockLeaderServiceMockRecorder struct {
	mock *MockLeaderService
}

// NewMockLeaderService creates a new mock instance
func NewMockLeaderService(ctrl *gomock.Controller) *MockLeaderService {
	mock := &MockLeaderService{ctrl: ctrl}
	mock.recorder = &MockLeaderServiceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockLeaderService) EXPECT() *MockLeaderServiceMockRecorder {
	return m.recorder
}

// Close mocks base method
func (m *MockLeaderService) Close() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Close")
	ret0, _ := ret[0].(error)
	return ret0
}

// Close indicates an expected call of Close
func (mr *MockLeaderServiceMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockLeaderService)(nil).Close))
}

// Campaign mocks base method
func (m *MockLeaderService) Campaign(electionID string, opts CampaignOptions) (<-chan campaign.Status, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Campaign", electionID, opts)
	ret0, _ := ret[0].(<-chan campaign.Status)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Campaign indicates an expected call of Campaign
func (mr *MockLeaderServiceMockRecorder) Campaign(electionID, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Campaign", reflect.TypeOf((*MockLeaderService)(nil).Campaign), electionID, opts)
}

// Resign mocks base method
func (m *MockLeaderService) Resign(electionID string) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Resign", electionID)
	ret0, _ := ret[0].(error)
	return ret0
}

// Resign indicates an expected call of Resign
func (mr *MockLeaderServiceMockRecorder) Resign(electionID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Resign", reflect.TypeOf((*MockLeaderService)(nil).Resign), electionID)
}

// Leader mocks base method
func (m *MockLeaderService) Leader(electionID string) (string, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Leader", electionID)
	ret0, _ := ret[0].(string)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Leader indicates an expected call of Leader
func (mr *MockLeaderServiceMockRecorder) Leader(electionID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Leader", reflect.TypeOf((*MockLeaderService)(nil).Leader), electionID)
}

// Observe mocks base method
func (m *MockLeaderService) Observe(electionID string) (<-chan string, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Observe", electionID)
	ret0, _ := ret[0].(<-chan string)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Observe indicates an expected call of Observe
func (mr *MockLeaderServiceMockRecorder) Observe(electionID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Observe", reflect.TypeOf((*MockLeaderService)(nil).Observe), electionID)
}
