# verify_index_files

`verify_index_files` is a utility to verify a set of index files to ensure that they are congruent with each other. Primarily, we sometimes use it as a final sanity test when making changes to the peer bootstrapping process. We can force a new node to join, and when its done we can verify that its index file matches that of its peers (they should have all the same series / checksums).

# Usage

```bash
$ git clone git@github.com:m3db/m3.git
$ make verify_index_files
$ ./bin/verify_index_files -h
```

# Example usage

```bash
./verify_index_files \
  -path-prefix ./hosts-data \
  -namespace metrics \
  -blocks 1513756800,1513764000,1513771200 \
  -shards 0,1,2,3,4,5
```

The directory that `path-prefix` points to must be a directory where each subdirectory is the name of the host and within each of those subdirectories is the "data" directory for that host, exactly as generated by M3DB itself.

Example:

```
/hosts-data
    /host1
      /data
        /metrics
          /0
            <all filset files for namespace "metrics", shard 0, and blocks: 1513756800,1513764000,1513771200>
          /1
            <all filset files for namespace "metrics", shard 1, and blocks: 1513756800,1513764000,1513771200>
        ...
    /host2
      <Same as host1>
    /host3
      <Same as host1>
```