// Copyright (c) 2019 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// This file was automatically generated by genny.
// Any changes will be lost if this file is regenerated.
// see https://github.com/mauricelam/genny

package client

import (
	"fmt"
	"runtime/debug"
	"sync"
	"testing"

	"github.com/stretchr/testify/require"
)

// Copyright (c) 2018 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// aggregateAttemptEqualsFn allows users to override equality checks
// for `aggregateAttempt` instances.
type aggregateAttemptEqualsFn func(a, b *aggregateAttempt) bool

// aggregateAttemptGetHookFn allows users to override properties on items
// retrieved from the backing pools before returning in the Get()
// path.
type aggregateAttemptGetHookFn func(*aggregateAttempt) *aggregateAttempt

// leakcheckAggregateAttemptPoolOpts allows users to override default behaviour.
type leakcheckAggregateAttemptPoolOpts struct {
	DisallowUntrackedPuts bool
	EqualsFn              aggregateAttemptEqualsFn
	GetHookFn             aggregateAttemptGetHookFn
}

// newLeakcheckAggregateAttemptPool returns a new leakcheckAggregateAttemptPool.
func newLeakcheckAggregateAttemptPool(opts leakcheckAggregateAttemptPoolOpts, backingPool aggregateAttemptPool) *leakcheckAggregateAttemptPool {
	if opts.EqualsFn == nil {
		// NB(prateek): fall-back to == in the worst case
		opts.EqualsFn = func(a, b *aggregateAttempt) bool {
			return a == b
		}
	}
	return &leakcheckAggregateAttemptPool{opts: opts, aggregateAttemptPool: backingPool}
}

// leakcheckAggregateAttemptPool wraps the underlying aggregateAttemptPool to make it easier to
// track leaks/allocs.
type leakcheckAggregateAttemptPool struct {
	sync.Mutex
	aggregateAttemptPool
	NumGets      int
	NumPuts      int
	PendingItems []leakcheckAggregateAttempt
	AllGetItems  []leakcheckAggregateAttempt

	opts leakcheckAggregateAttemptPoolOpts
}

// leakcheckAggregateAttempt wraps `aggregateAttempt` instances along with their last Get() paths.
type leakcheckAggregateAttempt struct {
	Value         *aggregateAttempt
	GetStacktrace []byte // GetStacktrace is the stacktrace for the Get() of this item
}

func (p *leakcheckAggregateAttemptPool) Init() {
	p.Lock()
	defer p.Unlock()
	p.aggregateAttemptPool.Init()
}

func (p *leakcheckAggregateAttemptPool) Get() *aggregateAttempt {
	p.Lock()
	defer p.Unlock()

	e := p.aggregateAttemptPool.Get()
	if fn := p.opts.GetHookFn; fn != nil {
		e = fn(e)
	}

	p.NumGets++
	item := leakcheckAggregateAttempt{
		Value:         e,
		GetStacktrace: debug.Stack(),
	}
	p.PendingItems = append(p.PendingItems, item)
	p.AllGetItems = append(p.AllGetItems, item)

	return e
}

func (p *leakcheckAggregateAttemptPool) Put(value *aggregateAttempt) {
	p.Lock()
	defer p.Unlock()

	idx := -1
	for i, item := range p.PendingItems {
		if p.opts.EqualsFn(item.Value, value) {
			idx = i
			break
		}
	}

	if idx == -1 && p.opts.DisallowUntrackedPuts {
		panic(fmt.Errorf("untracked object (%v) returned to pool", value))
	}

	if idx != -1 {
		// update slice
		p.PendingItems = append(p.PendingItems[:idx], p.PendingItems[idx+1:]...)
	}
	p.NumPuts++

	p.aggregateAttemptPool.Put(value)
}

// Check ensures there are no leaks.
func (p *leakcheckAggregateAttemptPool) Check(t *testing.T) {
	p.Lock()
	defer p.Unlock()

	require.Equal(t, p.NumGets, p.NumPuts)
	require.Empty(t, p.PendingItems)
}

type leakcheckAggregateAttemptFn func(e leakcheckAggregateAttempt)

// CheckExtended ensures there are no leaks, and executes the specified fn
func (p *leakcheckAggregateAttemptPool) CheckExtended(t *testing.T, fn leakcheckAggregateAttemptFn) {
	p.Check(t)
	p.Lock()
	defer p.Unlock()
	for _, e := range p.AllGetItems {
		fn(e)
	}
}
