// Copyright (c) 2019 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// This file was automatically generated by genny.
// Any changes will be lost if this file is regenerated.
// see https://github.com/mauricelam/genny

package client

import (
	"fmt"
	"runtime/debug"
	"sync"
	"testing"

	"github.com/stretchr/testify/require"
)

// Copyright (c) 2018 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// aggregateOpEqualsFn allows users to override equality checks
// for `aggregateOp` instances.
type aggregateOpEqualsFn func(a, b *aggregateOp) bool

// aggregateOpGetHookFn allows users to override properties on items
// retrieved from the backing pools before returning in the Get()
// path.
type aggregateOpGetHookFn func(*aggregateOp) *aggregateOp

// leakcheckAggregateOpPoolOpts allows users to override default behaviour.
type leakcheckAggregateOpPoolOpts struct {
	DisallowUntrackedPuts bool
	EqualsFn              aggregateOpEqualsFn
	GetHookFn             aggregateOpGetHookFn
}

// newLeakcheckAggregateOpPool returns a new leakcheckAggregateOpPool.
func newLeakcheckAggregateOpPool(opts leakcheckAggregateOpPoolOpts, backingPool aggregateOpPool) *leakcheckAggregateOpPool {
	if opts.EqualsFn == nil {
		// NB(prateek): fall-back to == in the worst case
		opts.EqualsFn = func(a, b *aggregateOp) bool {
			return a == b
		}
	}
	return &leakcheckAggregateOpPool{opts: opts, aggregateOpPool: backingPool}
}

// leakcheckAggregateOpPool wraps the underlying aggregateOpPool to make it easier to
// track leaks/allocs.
type leakcheckAggregateOpPool struct {
	sync.Mutex
	aggregateOpPool
	NumGets      int
	NumPuts      int
	PendingItems []leakcheckAggregateOp
	AllGetItems  []leakcheckAggregateOp

	opts leakcheckAggregateOpPoolOpts
}

// leakcheckAggregateOp wraps `aggregateOp` instances along with their last Get() paths.
type leakcheckAggregateOp struct {
	Value         *aggregateOp
	GetStacktrace []byte // GetStacktrace is the stacktrace for the Get() of this item
}

func (p *leakcheckAggregateOpPool) Init() {
	p.Lock()
	defer p.Unlock()
	p.aggregateOpPool.Init()
}

func (p *leakcheckAggregateOpPool) Get() *aggregateOp {
	p.Lock()
	defer p.Unlock()

	e := p.aggregateOpPool.Get()
	if fn := p.opts.GetHookFn; fn != nil {
		e = fn(e)
	}

	p.NumGets++
	item := leakcheckAggregateOp{
		Value:         e,
		GetStacktrace: debug.Stack(),
	}
	p.PendingItems = append(p.PendingItems, item)
	p.AllGetItems = append(p.AllGetItems, item)

	return e
}

func (p *leakcheckAggregateOpPool) Put(value *aggregateOp) {
	p.Lock()
	defer p.Unlock()

	idx := -1
	for i, item := range p.PendingItems {
		if p.opts.EqualsFn(item.Value, value) {
			idx = i
			break
		}
	}

	if idx == -1 && p.opts.DisallowUntrackedPuts {
		panic(fmt.Errorf("untracked object (%v) returned to pool", value))
	}

	if idx != -1 {
		// update slice
		p.PendingItems = append(p.PendingItems[:idx], p.PendingItems[idx+1:]...)
	}
	p.NumPuts++

	p.aggregateOpPool.Put(value)
}

// Check ensures there are no leaks.
func (p *leakcheckAggregateOpPool) Check(t *testing.T) {
	p.Lock()
	defer p.Unlock()

	require.Equal(t, p.NumGets, p.NumPuts)
	require.Empty(t, p.PendingItems)
}

type leakcheckAggregateOpFn func(e leakcheckAggregateOp)

// CheckExtended ensures there are no leaks, and executes the specified fn
func (p *leakcheckAggregateOpPool) CheckExtended(t *testing.T, fn leakcheckAggregateOpFn) {
	p.Check(t)
	p.Lock()
	defer p.Unlock()
	for _, e := range p.AllGetItems {
		fn(e)
	}
}
