// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/m3db/m3/src/dbnode/client/types.go

// Copyright (c) 2019 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Package client is a generated GoMock package.
package client

import (
	"reflect"
	"time"

	"github.com/m3db/m3/src/dbnode/clock"
	"github.com/m3db/m3/src/dbnode/encoding"
	"github.com/m3db/m3/src/dbnode/generated/thrift/rpc"
	"github.com/m3db/m3/src/dbnode/namespace"
	"github.com/m3db/m3/src/dbnode/runtime"
	"github.com/m3db/m3/src/dbnode/storage/block"
	"github.com/m3db/m3/src/dbnode/storage/bootstrap/result"
	"github.com/m3db/m3/src/dbnode/storage/index"
	"github.com/m3db/m3/src/dbnode/topology"
	"github.com/m3db/m3/src/x/context"
	"github.com/m3db/m3/src/x/ident"
	"github.com/m3db/m3/src/x/instrument"
	"github.com/m3db/m3/src/x/pool"
	"github.com/m3db/m3/src/x/retry"
	"github.com/m3db/m3/src/x/serialize"
	"github.com/m3db/m3/src/x/sync"
	time0 "github.com/m3db/m3/src/x/time"

	"github.com/golang/mock/gomock"
	tchannel_go "github.com/uber/tchannel-go"
)

// MockClient is a mock of Client interface
type MockClient struct {
	ctrl     *gomock.Controller
	recorder *MockClientMockRecorder
}

// MockClientMockRecorder is the mock recorder for MockClient
type MockClientMockRecorder struct {
	mock *MockClient
}

// NewMockClient creates a new mock instance
func NewMockClient(ctrl *gomock.Controller) *MockClient {
	mock := &MockClient{ctrl: ctrl}
	mock.recorder = &MockClientMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockClient) EXPECT() *MockClientMockRecorder {
	return m.recorder
}

// Options mocks base method
func (m *MockClient) Options() Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Options")
	ret0, _ := ret[0].(Options)
	return ret0
}

// Options indicates an expected call of Options
func (mr *MockClientMockRecorder) Options() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Options", reflect.TypeOf((*MockClient)(nil).Options))
}

// NewSession mocks base method
func (m *MockClient) NewSession() (Session, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NewSession")
	ret0, _ := ret[0].(Session)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// NewSession indicates an expected call of NewSession
func (mr *MockClientMockRecorder) NewSession() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NewSession", reflect.TypeOf((*MockClient)(nil).NewSession))
}

// DefaultSession mocks base method
func (m *MockClient) DefaultSession() (Session, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DefaultSession")
	ret0, _ := ret[0].(Session)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DefaultSession indicates an expected call of DefaultSession
func (mr *MockClientMockRecorder) DefaultSession() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DefaultSession", reflect.TypeOf((*MockClient)(nil).DefaultSession))
}

// DefaultSessionActive mocks base method
func (m *MockClient) DefaultSessionActive() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DefaultSessionActive")
	ret0, _ := ret[0].(bool)
	return ret0
}

// DefaultSessionActive indicates an expected call of DefaultSessionActive
func (mr *MockClientMockRecorder) DefaultSessionActive() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DefaultSessionActive", reflect.TypeOf((*MockClient)(nil).DefaultSessionActive))
}

// MockSession is a mock of Session interface
type MockSession struct {
	ctrl     *gomock.Controller
	recorder *MockSessionMockRecorder
}

// MockSessionMockRecorder is the mock recorder for MockSession
type MockSessionMockRecorder struct {
	mock *MockSession
}

// NewMockSession creates a new mock instance
func NewMockSession(ctrl *gomock.Controller) *MockSession {
	mock := &MockSession{ctrl: ctrl}
	mock.recorder = &MockSessionMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockSession) EXPECT() *MockSessionMockRecorder {
	return m.recorder
}

// Write mocks base method
func (m *MockSession) Write(namespace, id ident.ID, t time.Time, value float64, unit time0.Unit, annotation []byte) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Write", namespace, id, t, value, unit, annotation)
	ret0, _ := ret[0].(error)
	return ret0
}

// Write indicates an expected call of Write
func (mr *MockSessionMockRecorder) Write(namespace, id, t, value, unit, annotation interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Write", reflect.TypeOf((*MockSession)(nil).Write), namespace, id, t, value, unit, annotation)
}

// WriteTagged mocks base method
func (m *MockSession) WriteTagged(namespace, id ident.ID, tags ident.TagIterator, t time.Time, value float64, unit time0.Unit, annotation []byte) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTagged", namespace, id, tags, t, value, unit, annotation)
	ret0, _ := ret[0].(error)
	return ret0
}

// WriteTagged indicates an expected call of WriteTagged
func (mr *MockSessionMockRecorder) WriteTagged(namespace, id, tags, t, value, unit, annotation interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTagged", reflect.TypeOf((*MockSession)(nil).WriteTagged), namespace, id, tags, t, value, unit, annotation)
}

// Fetch mocks base method
func (m *MockSession) Fetch(namespace, id ident.ID, startInclusive, endExclusive time.Time) (encoding.SeriesIterator, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Fetch", namespace, id, startInclusive, endExclusive)
	ret0, _ := ret[0].(encoding.SeriesIterator)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Fetch indicates an expected call of Fetch
func (mr *MockSessionMockRecorder) Fetch(namespace, id, startInclusive, endExclusive interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Fetch", reflect.TypeOf((*MockSession)(nil).Fetch), namespace, id, startInclusive, endExclusive)
}

// FetchIDs mocks base method
func (m *MockSession) FetchIDs(namespace ident.ID, ids ident.Iterator, startInclusive, endExclusive time.Time) (encoding.SeriesIterators, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchIDs", namespace, ids, startInclusive, endExclusive)
	ret0, _ := ret[0].(encoding.SeriesIterators)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchIDs indicates an expected call of FetchIDs
func (mr *MockSessionMockRecorder) FetchIDs(namespace, ids, startInclusive, endExclusive interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchIDs", reflect.TypeOf((*MockSession)(nil).FetchIDs), namespace, ids, startInclusive, endExclusive)
}

// FetchTagged mocks base method
func (m *MockSession) FetchTagged(namespace ident.ID, q index.Query, opts index.QueryOptions) (encoding.SeriesIterators, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchTagged", namespace, q, opts)
	ret0, _ := ret[0].(encoding.SeriesIterators)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// FetchTagged indicates an expected call of FetchTagged
func (mr *MockSessionMockRecorder) FetchTagged(namespace, q, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchTagged", reflect.TypeOf((*MockSession)(nil).FetchTagged), namespace, q, opts)
}

// FetchTaggedIDs mocks base method
func (m *MockSession) FetchTaggedIDs(namespace ident.ID, q index.Query, opts index.QueryOptions) (TaggedIDsIterator, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchTaggedIDs", namespace, q, opts)
	ret0, _ := ret[0].(TaggedIDsIterator)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// FetchTaggedIDs indicates an expected call of FetchTaggedIDs
func (mr *MockSessionMockRecorder) FetchTaggedIDs(namespace, q, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchTaggedIDs", reflect.TypeOf((*MockSession)(nil).FetchTaggedIDs), namespace, q, opts)
}

// Aggregate mocks base method
func (m *MockSession) Aggregate(namespace ident.ID, q index.Query, opts index.AggregationOptions) (AggregatedTagsIterator, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Aggregate", namespace, q, opts)
	ret0, _ := ret[0].(AggregatedTagsIterator)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// Aggregate indicates an expected call of Aggregate
func (mr *MockSessionMockRecorder) Aggregate(namespace, q, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Aggregate", reflect.TypeOf((*MockSession)(nil).Aggregate), namespace, q, opts)
}

// ShardID mocks base method
func (m *MockSession) ShardID(id ident.ID) (uint32, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ShardID", id)
	ret0, _ := ret[0].(uint32)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ShardID indicates an expected call of ShardID
func (mr *MockSessionMockRecorder) ShardID(id interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ShardID", reflect.TypeOf((*MockSession)(nil).ShardID), id)
}

// IteratorPools mocks base method
func (m *MockSession) IteratorPools() (encoding.IteratorPools, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IteratorPools")
	ret0, _ := ret[0].(encoding.IteratorPools)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// IteratorPools indicates an expected call of IteratorPools
func (mr *MockSessionMockRecorder) IteratorPools() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IteratorPools", reflect.TypeOf((*MockSession)(nil).IteratorPools))
}

// Close mocks base method
func (m *MockSession) Close() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Close")
	ret0, _ := ret[0].(error)
	return ret0
}

// Close indicates an expected call of Close
func (mr *MockSessionMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockSession)(nil).Close))
}

// MockAggregatedTagsIterator is a mock of AggregatedTagsIterator interface
type MockAggregatedTagsIterator struct {
	ctrl     *gomock.Controller
	recorder *MockAggregatedTagsIteratorMockRecorder
}

// MockAggregatedTagsIteratorMockRecorder is the mock recorder for MockAggregatedTagsIterator
type MockAggregatedTagsIteratorMockRecorder struct {
	mock *MockAggregatedTagsIterator
}

// NewMockAggregatedTagsIterator creates a new mock instance
func NewMockAggregatedTagsIterator(ctrl *gomock.Controller) *MockAggregatedTagsIterator {
	mock := &MockAggregatedTagsIterator{ctrl: ctrl}
	mock.recorder = &MockAggregatedTagsIteratorMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockAggregatedTagsIterator) EXPECT() *MockAggregatedTagsIteratorMockRecorder {
	return m.recorder
}

// Next mocks base method
func (m *MockAggregatedTagsIterator) Next() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Next")
	ret0, _ := ret[0].(bool)
	return ret0
}

// Next indicates an expected call of Next
func (mr *MockAggregatedTagsIteratorMockRecorder) Next() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Next", reflect.TypeOf((*MockAggregatedTagsIterator)(nil).Next))
}

// Remaining mocks base method
func (m *MockAggregatedTagsIterator) Remaining() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Remaining")
	ret0, _ := ret[0].(int)
	return ret0
}

// Remaining indicates an expected call of Remaining
func (mr *MockAggregatedTagsIteratorMockRecorder) Remaining() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Remaining", reflect.TypeOf((*MockAggregatedTagsIterator)(nil).Remaining))
}

// Current mocks base method
func (m *MockAggregatedTagsIterator) Current() (ident.ID, ident.Iterator) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Current")
	ret0, _ := ret[0].(ident.ID)
	ret1, _ := ret[1].(ident.Iterator)
	return ret0, ret1
}

// Current indicates an expected call of Current
func (mr *MockAggregatedTagsIteratorMockRecorder) Current() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Current", reflect.TypeOf((*MockAggregatedTagsIterator)(nil).Current))
}

// Err mocks base method
func (m *MockAggregatedTagsIterator) Err() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Err")
	ret0, _ := ret[0].(error)
	return ret0
}

// Err indicates an expected call of Err
func (mr *MockAggregatedTagsIteratorMockRecorder) Err() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Err", reflect.TypeOf((*MockAggregatedTagsIterator)(nil).Err))
}

// Finalize mocks base method
func (m *MockAggregatedTagsIterator) Finalize() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Finalize")
}

// Finalize indicates an expected call of Finalize
func (mr *MockAggregatedTagsIteratorMockRecorder) Finalize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Finalize", reflect.TypeOf((*MockAggregatedTagsIterator)(nil).Finalize))
}

// MockTaggedIDsIterator is a mock of TaggedIDsIterator interface
type MockTaggedIDsIterator struct {
	ctrl     *gomock.Controller
	recorder *MockTaggedIDsIteratorMockRecorder
}

// MockTaggedIDsIteratorMockRecorder is the mock recorder for MockTaggedIDsIterator
type MockTaggedIDsIteratorMockRecorder struct {
	mock *MockTaggedIDsIterator
}

// NewMockTaggedIDsIterator creates a new mock instance
func NewMockTaggedIDsIterator(ctrl *gomock.Controller) *MockTaggedIDsIterator {
	mock := &MockTaggedIDsIterator{ctrl: ctrl}
	mock.recorder = &MockTaggedIDsIteratorMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockTaggedIDsIterator) EXPECT() *MockTaggedIDsIteratorMockRecorder {
	return m.recorder
}

// Next mocks base method
func (m *MockTaggedIDsIterator) Next() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Next")
	ret0, _ := ret[0].(bool)
	return ret0
}

// Next indicates an expected call of Next
func (mr *MockTaggedIDsIteratorMockRecorder) Next() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Next", reflect.TypeOf((*MockTaggedIDsIterator)(nil).Next))
}

// Current mocks base method
func (m *MockTaggedIDsIterator) Current() (ident.ID, ident.ID, ident.TagIterator) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Current")
	ret0, _ := ret[0].(ident.ID)
	ret1, _ := ret[1].(ident.ID)
	ret2, _ := ret[2].(ident.TagIterator)
	return ret0, ret1, ret2
}

// Current indicates an expected call of Current
func (mr *MockTaggedIDsIteratorMockRecorder) Current() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Current", reflect.TypeOf((*MockTaggedIDsIterator)(nil).Current))
}

// Err mocks base method
func (m *MockTaggedIDsIterator) Err() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Err")
	ret0, _ := ret[0].(error)
	return ret0
}

// Err indicates an expected call of Err
func (mr *MockTaggedIDsIteratorMockRecorder) Err() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Err", reflect.TypeOf((*MockTaggedIDsIterator)(nil).Err))
}

// Finalize mocks base method
func (m *MockTaggedIDsIterator) Finalize() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Finalize")
}

// Finalize indicates an expected call of Finalize
func (mr *MockTaggedIDsIteratorMockRecorder) Finalize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Finalize", reflect.TypeOf((*MockTaggedIDsIterator)(nil).Finalize))
}

// MockAdminClient is a mock of AdminClient interface
type MockAdminClient struct {
	ctrl     *gomock.Controller
	recorder *MockAdminClientMockRecorder
}

// MockAdminClientMockRecorder is the mock recorder for MockAdminClient
type MockAdminClientMockRecorder struct {
	mock *MockAdminClient
}

// NewMockAdminClient creates a new mock instance
func NewMockAdminClient(ctrl *gomock.Controller) *MockAdminClient {
	mock := &MockAdminClient{ctrl: ctrl}
	mock.recorder = &MockAdminClientMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockAdminClient) EXPECT() *MockAdminClientMockRecorder {
	return m.recorder
}

// Options mocks base method
func (m *MockAdminClient) Options() Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Options")
	ret0, _ := ret[0].(Options)
	return ret0
}

// Options indicates an expected call of Options
func (mr *MockAdminClientMockRecorder) Options() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Options", reflect.TypeOf((*MockAdminClient)(nil).Options))
}

// NewSession mocks base method
func (m *MockAdminClient) NewSession() (Session, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NewSession")
	ret0, _ := ret[0].(Session)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// NewSession indicates an expected call of NewSession
func (mr *MockAdminClientMockRecorder) NewSession() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NewSession", reflect.TypeOf((*MockAdminClient)(nil).NewSession))
}

// DefaultSession mocks base method
func (m *MockAdminClient) DefaultSession() (Session, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DefaultSession")
	ret0, _ := ret[0].(Session)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DefaultSession indicates an expected call of DefaultSession
func (mr *MockAdminClientMockRecorder) DefaultSession() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DefaultSession", reflect.TypeOf((*MockAdminClient)(nil).DefaultSession))
}

// DefaultSessionActive mocks base method
func (m *MockAdminClient) DefaultSessionActive() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DefaultSessionActive")
	ret0, _ := ret[0].(bool)
	return ret0
}

// DefaultSessionActive indicates an expected call of DefaultSessionActive
func (mr *MockAdminClientMockRecorder) DefaultSessionActive() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DefaultSessionActive", reflect.TypeOf((*MockAdminClient)(nil).DefaultSessionActive))
}

// NewAdminSession mocks base method
func (m *MockAdminClient) NewAdminSession() (AdminSession, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NewAdminSession")
	ret0, _ := ret[0].(AdminSession)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// NewAdminSession indicates an expected call of NewAdminSession
func (mr *MockAdminClientMockRecorder) NewAdminSession() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NewAdminSession", reflect.TypeOf((*MockAdminClient)(nil).NewAdminSession))
}

// DefaultAdminSession mocks base method
func (m *MockAdminClient) DefaultAdminSession() (AdminSession, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DefaultAdminSession")
	ret0, _ := ret[0].(AdminSession)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// DefaultAdminSession indicates an expected call of DefaultAdminSession
func (mr *MockAdminClientMockRecorder) DefaultAdminSession() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DefaultAdminSession", reflect.TypeOf((*MockAdminClient)(nil).DefaultAdminSession))
}

// MockPeerBlockMetadataIter is a mock of PeerBlockMetadataIter interface
type MockPeerBlockMetadataIter struct {
	ctrl     *gomock.Controller
	recorder *MockPeerBlockMetadataIterMockRecorder
}

// MockPeerBlockMetadataIterMockRecorder is the mock recorder for MockPeerBlockMetadataIter
type MockPeerBlockMetadataIterMockRecorder struct {
	mock *MockPeerBlockMetadataIter
}

// NewMockPeerBlockMetadataIter creates a new mock instance
func NewMockPeerBlockMetadataIter(ctrl *gomock.Controller) *MockPeerBlockMetadataIter {
	mock := &MockPeerBlockMetadataIter{ctrl: ctrl}
	mock.recorder = &MockPeerBlockMetadataIterMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockPeerBlockMetadataIter) EXPECT() *MockPeerBlockMetadataIterMockRecorder {
	return m.recorder
}

// Next mocks base method
func (m *MockPeerBlockMetadataIter) Next() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Next")
	ret0, _ := ret[0].(bool)
	return ret0
}

// Next indicates an expected call of Next
func (mr *MockPeerBlockMetadataIterMockRecorder) Next() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Next", reflect.TypeOf((*MockPeerBlockMetadataIter)(nil).Next))
}

// Current mocks base method
func (m *MockPeerBlockMetadataIter) Current() (topology.Host, block.Metadata) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Current")
	ret0, _ := ret[0].(topology.Host)
	ret1, _ := ret[1].(block.Metadata)
	return ret0, ret1
}

// Current indicates an expected call of Current
func (mr *MockPeerBlockMetadataIterMockRecorder) Current() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Current", reflect.TypeOf((*MockPeerBlockMetadataIter)(nil).Current))
}

// Err mocks base method
func (m *MockPeerBlockMetadataIter) Err() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Err")
	ret0, _ := ret[0].(error)
	return ret0
}

// Err indicates an expected call of Err
func (mr *MockPeerBlockMetadataIterMockRecorder) Err() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Err", reflect.TypeOf((*MockPeerBlockMetadataIter)(nil).Err))
}

// MockPeerBlocksIter is a mock of PeerBlocksIter interface
type MockPeerBlocksIter struct {
	ctrl     *gomock.Controller
	recorder *MockPeerBlocksIterMockRecorder
}

// MockPeerBlocksIterMockRecorder is the mock recorder for MockPeerBlocksIter
type MockPeerBlocksIterMockRecorder struct {
	mock *MockPeerBlocksIter
}

// NewMockPeerBlocksIter creates a new mock instance
func NewMockPeerBlocksIter(ctrl *gomock.Controller) *MockPeerBlocksIter {
	mock := &MockPeerBlocksIter{ctrl: ctrl}
	mock.recorder = &MockPeerBlocksIterMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockPeerBlocksIter) EXPECT() *MockPeerBlocksIterMockRecorder {
	return m.recorder
}

// Next mocks base method
func (m *MockPeerBlocksIter) Next() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Next")
	ret0, _ := ret[0].(bool)
	return ret0
}

// Next indicates an expected call of Next
func (mr *MockPeerBlocksIterMockRecorder) Next() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Next", reflect.TypeOf((*MockPeerBlocksIter)(nil).Next))
}

// Current mocks base method
func (m *MockPeerBlocksIter) Current() (topology.Host, ident.ID, block.DatabaseBlock) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Current")
	ret0, _ := ret[0].(topology.Host)
	ret1, _ := ret[1].(ident.ID)
	ret2, _ := ret[2].(block.DatabaseBlock)
	return ret0, ret1, ret2
}

// Current indicates an expected call of Current
func (mr *MockPeerBlocksIterMockRecorder) Current() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Current", reflect.TypeOf((*MockPeerBlocksIter)(nil).Current))
}

// Err mocks base method
func (m *MockPeerBlocksIter) Err() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Err")
	ret0, _ := ret[0].(error)
	return ret0
}

// Err indicates an expected call of Err
func (mr *MockPeerBlocksIterMockRecorder) Err() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Err", reflect.TypeOf((*MockPeerBlocksIter)(nil).Err))
}

// MockAdminSession is a mock of AdminSession interface
type MockAdminSession struct {
	ctrl     *gomock.Controller
	recorder *MockAdminSessionMockRecorder
}

// MockAdminSessionMockRecorder is the mock recorder for MockAdminSession
type MockAdminSessionMockRecorder struct {
	mock *MockAdminSession
}

// NewMockAdminSession creates a new mock instance
func NewMockAdminSession(ctrl *gomock.Controller) *MockAdminSession {
	mock := &MockAdminSession{ctrl: ctrl}
	mock.recorder = &MockAdminSessionMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockAdminSession) EXPECT() *MockAdminSessionMockRecorder {
	return m.recorder
}

// Write mocks base method
func (m *MockAdminSession) Write(namespace, id ident.ID, t time.Time, value float64, unit time0.Unit, annotation []byte) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Write", namespace, id, t, value, unit, annotation)
	ret0, _ := ret[0].(error)
	return ret0
}

// Write indicates an expected call of Write
func (mr *MockAdminSessionMockRecorder) Write(namespace, id, t, value, unit, annotation interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Write", reflect.TypeOf((*MockAdminSession)(nil).Write), namespace, id, t, value, unit, annotation)
}

// WriteTagged mocks base method
func (m *MockAdminSession) WriteTagged(namespace, id ident.ID, tags ident.TagIterator, t time.Time, value float64, unit time0.Unit, annotation []byte) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTagged", namespace, id, tags, t, value, unit, annotation)
	ret0, _ := ret[0].(error)
	return ret0
}

// WriteTagged indicates an expected call of WriteTagged
func (mr *MockAdminSessionMockRecorder) WriteTagged(namespace, id, tags, t, value, unit, annotation interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTagged", reflect.TypeOf((*MockAdminSession)(nil).WriteTagged), namespace, id, tags, t, value, unit, annotation)
}

// Fetch mocks base method
func (m *MockAdminSession) Fetch(namespace, id ident.ID, startInclusive, endExclusive time.Time) (encoding.SeriesIterator, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Fetch", namespace, id, startInclusive, endExclusive)
	ret0, _ := ret[0].(encoding.SeriesIterator)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Fetch indicates an expected call of Fetch
func (mr *MockAdminSessionMockRecorder) Fetch(namespace, id, startInclusive, endExclusive interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Fetch", reflect.TypeOf((*MockAdminSession)(nil).Fetch), namespace, id, startInclusive, endExclusive)
}

// FetchIDs mocks base method
func (m *MockAdminSession) FetchIDs(namespace ident.ID, ids ident.Iterator, startInclusive, endExclusive time.Time) (encoding.SeriesIterators, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchIDs", namespace, ids, startInclusive, endExclusive)
	ret0, _ := ret[0].(encoding.SeriesIterators)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchIDs indicates an expected call of FetchIDs
func (mr *MockAdminSessionMockRecorder) FetchIDs(namespace, ids, startInclusive, endExclusive interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchIDs", reflect.TypeOf((*MockAdminSession)(nil).FetchIDs), namespace, ids, startInclusive, endExclusive)
}

// FetchTagged mocks base method
func (m *MockAdminSession) FetchTagged(namespace ident.ID, q index.Query, opts index.QueryOptions) (encoding.SeriesIterators, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchTagged", namespace, q, opts)
	ret0, _ := ret[0].(encoding.SeriesIterators)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// FetchTagged indicates an expected call of FetchTagged
func (mr *MockAdminSessionMockRecorder) FetchTagged(namespace, q, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchTagged", reflect.TypeOf((*MockAdminSession)(nil).FetchTagged), namespace, q, opts)
}

// FetchTaggedIDs mocks base method
func (m *MockAdminSession) FetchTaggedIDs(namespace ident.ID, q index.Query, opts index.QueryOptions) (TaggedIDsIterator, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchTaggedIDs", namespace, q, opts)
	ret0, _ := ret[0].(TaggedIDsIterator)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// FetchTaggedIDs indicates an expected call of FetchTaggedIDs
func (mr *MockAdminSessionMockRecorder) FetchTaggedIDs(namespace, q, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchTaggedIDs", reflect.TypeOf((*MockAdminSession)(nil).FetchTaggedIDs), namespace, q, opts)
}

// Aggregate mocks base method
func (m *MockAdminSession) Aggregate(namespace ident.ID, q index.Query, opts index.AggregationOptions) (AggregatedTagsIterator, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Aggregate", namespace, q, opts)
	ret0, _ := ret[0].(AggregatedTagsIterator)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// Aggregate indicates an expected call of Aggregate
func (mr *MockAdminSessionMockRecorder) Aggregate(namespace, q, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Aggregate", reflect.TypeOf((*MockAdminSession)(nil).Aggregate), namespace, q, opts)
}

// ShardID mocks base method
func (m *MockAdminSession) ShardID(id ident.ID) (uint32, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ShardID", id)
	ret0, _ := ret[0].(uint32)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ShardID indicates an expected call of ShardID
func (mr *MockAdminSessionMockRecorder) ShardID(id interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ShardID", reflect.TypeOf((*MockAdminSession)(nil).ShardID), id)
}

// IteratorPools mocks base method
func (m *MockAdminSession) IteratorPools() (encoding.IteratorPools, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IteratorPools")
	ret0, _ := ret[0].(encoding.IteratorPools)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// IteratorPools indicates an expected call of IteratorPools
func (mr *MockAdminSessionMockRecorder) IteratorPools() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IteratorPools", reflect.TypeOf((*MockAdminSession)(nil).IteratorPools))
}

// Close mocks base method
func (m *MockAdminSession) Close() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Close")
	ret0, _ := ret[0].(error)
	return ret0
}

// Close indicates an expected call of Close
func (mr *MockAdminSessionMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockAdminSession)(nil).Close))
}

// Origin mocks base method
func (m *MockAdminSession) Origin() topology.Host {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Origin")
	ret0, _ := ret[0].(topology.Host)
	return ret0
}

// Origin indicates an expected call of Origin
func (mr *MockAdminSessionMockRecorder) Origin() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Origin", reflect.TypeOf((*MockAdminSession)(nil).Origin))
}

// Replicas mocks base method
func (m *MockAdminSession) Replicas() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Replicas")
	ret0, _ := ret[0].(int)
	return ret0
}

// Replicas indicates an expected call of Replicas
func (mr *MockAdminSessionMockRecorder) Replicas() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Replicas", reflect.TypeOf((*MockAdminSession)(nil).Replicas))
}

// TopologyMap mocks base method
func (m *MockAdminSession) TopologyMap() (topology.Map, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TopologyMap")
	ret0, _ := ret[0].(topology.Map)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// TopologyMap indicates an expected call of TopologyMap
func (mr *MockAdminSessionMockRecorder) TopologyMap() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TopologyMap", reflect.TypeOf((*MockAdminSession)(nil).TopologyMap))
}

// Truncate mocks base method
func (m *MockAdminSession) Truncate(namespace ident.ID) (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Truncate", namespace)
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Truncate indicates an expected call of Truncate
func (mr *MockAdminSessionMockRecorder) Truncate(namespace interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Truncate", reflect.TypeOf((*MockAdminSession)(nil).Truncate), namespace)
}

// FetchBootstrapBlocksFromPeers mocks base method
func (m *MockAdminSession) FetchBootstrapBlocksFromPeers(namespace namespace.Metadata, shard uint32, start, end time.Time, opts result.Options) (result.ShardResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBootstrapBlocksFromPeers", namespace, shard, start, end, opts)
	ret0, _ := ret[0].(result.ShardResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBootstrapBlocksFromPeers indicates an expected call of FetchBootstrapBlocksFromPeers
func (mr *MockAdminSessionMockRecorder) FetchBootstrapBlocksFromPeers(namespace, shard, start, end, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBootstrapBlocksFromPeers", reflect.TypeOf((*MockAdminSession)(nil).FetchBootstrapBlocksFromPeers), namespace, shard, start, end, opts)
}

// FetchBootstrapBlocksMetadataFromPeers mocks base method
func (m *MockAdminSession) FetchBootstrapBlocksMetadataFromPeers(namespace ident.ID, shard uint32, start, end time.Time, result result.Options) (PeerBlockMetadataIter, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBootstrapBlocksMetadataFromPeers", namespace, shard, start, end, result)
	ret0, _ := ret[0].(PeerBlockMetadataIter)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBootstrapBlocksMetadataFromPeers indicates an expected call of FetchBootstrapBlocksMetadataFromPeers
func (mr *MockAdminSessionMockRecorder) FetchBootstrapBlocksMetadataFromPeers(namespace, shard, start, end, result interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBootstrapBlocksMetadataFromPeers", reflect.TypeOf((*MockAdminSession)(nil).FetchBootstrapBlocksMetadataFromPeers), namespace, shard, start, end, result)
}

// FetchBlocksMetadataFromPeers mocks base method
func (m *MockAdminSession) FetchBlocksMetadataFromPeers(namespace ident.ID, shard uint32, start, end time.Time, consistencyLevel topology.ReadConsistencyLevel, result result.Options) (PeerBlockMetadataIter, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocksMetadataFromPeers", namespace, shard, start, end, consistencyLevel, result)
	ret0, _ := ret[0].(PeerBlockMetadataIter)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBlocksMetadataFromPeers indicates an expected call of FetchBlocksMetadataFromPeers
func (mr *MockAdminSessionMockRecorder) FetchBlocksMetadataFromPeers(namespace, shard, start, end, consistencyLevel, result interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocksMetadataFromPeers", reflect.TypeOf((*MockAdminSession)(nil).FetchBlocksMetadataFromPeers), namespace, shard, start, end, consistencyLevel, result)
}

// FetchBlocksFromPeers mocks base method
func (m *MockAdminSession) FetchBlocksFromPeers(namespace namespace.Metadata, shard uint32, consistencyLevel topology.ReadConsistencyLevel, metadatas []block.ReplicaMetadata, opts result.Options) (PeerBlocksIter, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocksFromPeers", namespace, shard, consistencyLevel, metadatas, opts)
	ret0, _ := ret[0].(PeerBlocksIter)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBlocksFromPeers indicates an expected call of FetchBlocksFromPeers
func (mr *MockAdminSessionMockRecorder) FetchBlocksFromPeers(namespace, shard, consistencyLevel, metadatas, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocksFromPeers", reflect.TypeOf((*MockAdminSession)(nil).FetchBlocksFromPeers), namespace, shard, consistencyLevel, metadatas, opts)
}

// MockOptions is a mock of Options interface
type MockOptions struct {
	ctrl     *gomock.Controller
	recorder *MockOptionsMockRecorder
}

// MockOptionsMockRecorder is the mock recorder for MockOptions
type MockOptionsMockRecorder struct {
	mock *MockOptions
}

// NewMockOptions creates a new mock instance
func NewMockOptions(ctrl *gomock.Controller) *MockOptions {
	mock := &MockOptions{ctrl: ctrl}
	mock.recorder = &MockOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockOptions) EXPECT() *MockOptionsMockRecorder {
	return m.recorder
}

// Validate mocks base method
func (m *MockOptions) Validate() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Validate")
	ret0, _ := ret[0].(error)
	return ret0
}

// Validate indicates an expected call of Validate
func (mr *MockOptionsMockRecorder) Validate() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Validate", reflect.TypeOf((*MockOptions)(nil).Validate))
}

// SetEncodingM3TSZ mocks base method
func (m *MockOptions) SetEncodingM3TSZ() Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetEncodingM3TSZ")
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetEncodingM3TSZ indicates an expected call of SetEncodingM3TSZ
func (mr *MockOptionsMockRecorder) SetEncodingM3TSZ() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetEncodingM3TSZ", reflect.TypeOf((*MockOptions)(nil).SetEncodingM3TSZ))
}

// SetEncodingProto mocks base method
func (m *MockOptions) SetEncodingProto(encodingOpts encoding.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetEncodingProto", encodingOpts)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetEncodingProto indicates an expected call of SetEncodingProto
func (mr *MockOptionsMockRecorder) SetEncodingProto(encodingOpts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetEncodingProto", reflect.TypeOf((*MockOptions)(nil).SetEncodingProto), encodingOpts)
}

// IsSetEncodingProto mocks base method
func (m *MockOptions) IsSetEncodingProto() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsSetEncodingProto")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsSetEncodingProto indicates an expected call of IsSetEncodingProto
func (mr *MockOptionsMockRecorder) IsSetEncodingProto() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsSetEncodingProto", reflect.TypeOf((*MockOptions)(nil).IsSetEncodingProto))
}

// SetRuntimeOptionsManager mocks base method
func (m *MockOptions) SetRuntimeOptionsManager(value runtime.OptionsManager) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetRuntimeOptionsManager", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetRuntimeOptionsManager indicates an expected call of SetRuntimeOptionsManager
func (mr *MockOptionsMockRecorder) SetRuntimeOptionsManager(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetRuntimeOptionsManager", reflect.TypeOf((*MockOptions)(nil).SetRuntimeOptionsManager), value)
}

// RuntimeOptionsManager mocks base method
func (m *MockOptions) RuntimeOptionsManager() runtime.OptionsManager {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RuntimeOptionsManager")
	ret0, _ := ret[0].(runtime.OptionsManager)
	return ret0
}

// RuntimeOptionsManager indicates an expected call of RuntimeOptionsManager
func (mr *MockOptionsMockRecorder) RuntimeOptionsManager() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RuntimeOptionsManager", reflect.TypeOf((*MockOptions)(nil).RuntimeOptionsManager))
}

// SetClockOptions mocks base method
func (m *MockOptions) SetClockOptions(value clock.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetClockOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetClockOptions indicates an expected call of SetClockOptions
func (mr *MockOptionsMockRecorder) SetClockOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetClockOptions", reflect.TypeOf((*MockOptions)(nil).SetClockOptions), value)
}

// ClockOptions mocks base method
func (m *MockOptions) ClockOptions() clock.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ClockOptions")
	ret0, _ := ret[0].(clock.Options)
	return ret0
}

// ClockOptions indicates an expected call of ClockOptions
func (mr *MockOptionsMockRecorder) ClockOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClockOptions", reflect.TypeOf((*MockOptions)(nil).ClockOptions))
}

// SetInstrumentOptions mocks base method
func (m *MockOptions) SetInstrumentOptions(value instrument.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetInstrumentOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetInstrumentOptions indicates an expected call of SetInstrumentOptions
func (mr *MockOptionsMockRecorder) SetInstrumentOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetInstrumentOptions", reflect.TypeOf((*MockOptions)(nil).SetInstrumentOptions), value)
}

// InstrumentOptions mocks base method
func (m *MockOptions) InstrumentOptions() instrument.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InstrumentOptions")
	ret0, _ := ret[0].(instrument.Options)
	return ret0
}

// InstrumentOptions indicates an expected call of InstrumentOptions
func (mr *MockOptionsMockRecorder) InstrumentOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InstrumentOptions", reflect.TypeOf((*MockOptions)(nil).InstrumentOptions))
}

// SetTopologyInitializer mocks base method
func (m *MockOptions) SetTopologyInitializer(value topology.Initializer) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTopologyInitializer", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTopologyInitializer indicates an expected call of SetTopologyInitializer
func (mr *MockOptionsMockRecorder) SetTopologyInitializer(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTopologyInitializer", reflect.TypeOf((*MockOptions)(nil).SetTopologyInitializer), value)
}

// TopologyInitializer mocks base method
func (m *MockOptions) TopologyInitializer() topology.Initializer {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TopologyInitializer")
	ret0, _ := ret[0].(topology.Initializer)
	return ret0
}

// TopologyInitializer indicates an expected call of TopologyInitializer
func (mr *MockOptionsMockRecorder) TopologyInitializer() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TopologyInitializer", reflect.TypeOf((*MockOptions)(nil).TopologyInitializer))
}

// SetReadConsistencyLevel mocks base method
func (m *MockOptions) SetReadConsistencyLevel(value topology.ReadConsistencyLevel) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetReadConsistencyLevel", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetReadConsistencyLevel indicates an expected call of SetReadConsistencyLevel
func (mr *MockOptionsMockRecorder) SetReadConsistencyLevel(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetReadConsistencyLevel", reflect.TypeOf((*MockOptions)(nil).SetReadConsistencyLevel), value)
}

// ReadConsistencyLevel mocks base method
func (m *MockOptions) ReadConsistencyLevel() topology.ReadConsistencyLevel {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReadConsistencyLevel")
	ret0, _ := ret[0].(topology.ReadConsistencyLevel)
	return ret0
}

// ReadConsistencyLevel indicates an expected call of ReadConsistencyLevel
func (mr *MockOptionsMockRecorder) ReadConsistencyLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReadConsistencyLevel", reflect.TypeOf((*MockOptions)(nil).ReadConsistencyLevel))
}

// SetWriteConsistencyLevel mocks base method
func (m *MockOptions) SetWriteConsistencyLevel(value topology.ConsistencyLevel) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteConsistencyLevel", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteConsistencyLevel indicates an expected call of SetWriteConsistencyLevel
func (mr *MockOptionsMockRecorder) SetWriteConsistencyLevel(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteConsistencyLevel", reflect.TypeOf((*MockOptions)(nil).SetWriteConsistencyLevel), value)
}

// WriteConsistencyLevel mocks base method
func (m *MockOptions) WriteConsistencyLevel() topology.ConsistencyLevel {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteConsistencyLevel")
	ret0, _ := ret[0].(topology.ConsistencyLevel)
	return ret0
}

// WriteConsistencyLevel indicates an expected call of WriteConsistencyLevel
func (mr *MockOptionsMockRecorder) WriteConsistencyLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteConsistencyLevel", reflect.TypeOf((*MockOptions)(nil).WriteConsistencyLevel))
}

// SetChannelOptions mocks base method
func (m *MockOptions) SetChannelOptions(value *tchannel_go.ChannelOptions) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetChannelOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetChannelOptions indicates an expected call of SetChannelOptions
func (mr *MockOptionsMockRecorder) SetChannelOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetChannelOptions", reflect.TypeOf((*MockOptions)(nil).SetChannelOptions), value)
}

// ChannelOptions mocks base method
func (m *MockOptions) ChannelOptions() *tchannel_go.ChannelOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ChannelOptions")
	ret0, _ := ret[0].(*tchannel_go.ChannelOptions)
	return ret0
}

// ChannelOptions indicates an expected call of ChannelOptions
func (mr *MockOptionsMockRecorder) ChannelOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ChannelOptions", reflect.TypeOf((*MockOptions)(nil).ChannelOptions))
}

// SetMaxConnectionCount mocks base method
func (m *MockOptions) SetMaxConnectionCount(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetMaxConnectionCount", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetMaxConnectionCount indicates an expected call of SetMaxConnectionCount
func (mr *MockOptionsMockRecorder) SetMaxConnectionCount(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetMaxConnectionCount", reflect.TypeOf((*MockOptions)(nil).SetMaxConnectionCount), value)
}

// MaxConnectionCount mocks base method
func (m *MockOptions) MaxConnectionCount() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MaxConnectionCount")
	ret0, _ := ret[0].(int)
	return ret0
}

// MaxConnectionCount indicates an expected call of MaxConnectionCount
func (mr *MockOptionsMockRecorder) MaxConnectionCount() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MaxConnectionCount", reflect.TypeOf((*MockOptions)(nil).MaxConnectionCount))
}

// SetMinConnectionCount mocks base method
func (m *MockOptions) SetMinConnectionCount(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetMinConnectionCount", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetMinConnectionCount indicates an expected call of SetMinConnectionCount
func (mr *MockOptionsMockRecorder) SetMinConnectionCount(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetMinConnectionCount", reflect.TypeOf((*MockOptions)(nil).SetMinConnectionCount), value)
}

// MinConnectionCount mocks base method
func (m *MockOptions) MinConnectionCount() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MinConnectionCount")
	ret0, _ := ret[0].(int)
	return ret0
}

// MinConnectionCount indicates an expected call of MinConnectionCount
func (mr *MockOptionsMockRecorder) MinConnectionCount() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MinConnectionCount", reflect.TypeOf((*MockOptions)(nil).MinConnectionCount))
}

// SetHostConnectTimeout mocks base method
func (m *MockOptions) SetHostConnectTimeout(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHostConnectTimeout", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetHostConnectTimeout indicates an expected call of SetHostConnectTimeout
func (mr *MockOptionsMockRecorder) SetHostConnectTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHostConnectTimeout", reflect.TypeOf((*MockOptions)(nil).SetHostConnectTimeout), value)
}

// HostConnectTimeout mocks base method
func (m *MockOptions) HostConnectTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HostConnectTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// HostConnectTimeout indicates an expected call of HostConnectTimeout
func (mr *MockOptionsMockRecorder) HostConnectTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HostConnectTimeout", reflect.TypeOf((*MockOptions)(nil).HostConnectTimeout))
}

// SetClusterConnectTimeout mocks base method
func (m *MockOptions) SetClusterConnectTimeout(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetClusterConnectTimeout", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetClusterConnectTimeout indicates an expected call of SetClusterConnectTimeout
func (mr *MockOptionsMockRecorder) SetClusterConnectTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetClusterConnectTimeout", reflect.TypeOf((*MockOptions)(nil).SetClusterConnectTimeout), value)
}

// ClusterConnectTimeout mocks base method
func (m *MockOptions) ClusterConnectTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ClusterConnectTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// ClusterConnectTimeout indicates an expected call of ClusterConnectTimeout
func (mr *MockOptionsMockRecorder) ClusterConnectTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClusterConnectTimeout", reflect.TypeOf((*MockOptions)(nil).ClusterConnectTimeout))
}

// SetClusterConnectConsistencyLevel mocks base method
func (m *MockOptions) SetClusterConnectConsistencyLevel(value topology.ConnectConsistencyLevel) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetClusterConnectConsistencyLevel", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetClusterConnectConsistencyLevel indicates an expected call of SetClusterConnectConsistencyLevel
func (mr *MockOptionsMockRecorder) SetClusterConnectConsistencyLevel(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetClusterConnectConsistencyLevel", reflect.TypeOf((*MockOptions)(nil).SetClusterConnectConsistencyLevel), value)
}

// ClusterConnectConsistencyLevel mocks base method
func (m *MockOptions) ClusterConnectConsistencyLevel() topology.ConnectConsistencyLevel {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ClusterConnectConsistencyLevel")
	ret0, _ := ret[0].(topology.ConnectConsistencyLevel)
	return ret0
}

// ClusterConnectConsistencyLevel indicates an expected call of ClusterConnectConsistencyLevel
func (mr *MockOptionsMockRecorder) ClusterConnectConsistencyLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClusterConnectConsistencyLevel", reflect.TypeOf((*MockOptions)(nil).ClusterConnectConsistencyLevel))
}

// SetWriteRequestTimeout mocks base method
func (m *MockOptions) SetWriteRequestTimeout(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteRequestTimeout", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteRequestTimeout indicates an expected call of SetWriteRequestTimeout
func (mr *MockOptionsMockRecorder) SetWriteRequestTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteRequestTimeout", reflect.TypeOf((*MockOptions)(nil).SetWriteRequestTimeout), value)
}

// WriteRequestTimeout mocks base method
func (m *MockOptions) WriteRequestTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteRequestTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// WriteRequestTimeout indicates an expected call of WriteRequestTimeout
func (mr *MockOptionsMockRecorder) WriteRequestTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteRequestTimeout", reflect.TypeOf((*MockOptions)(nil).WriteRequestTimeout))
}

// SetFetchRequestTimeout mocks base method
func (m *MockOptions) SetFetchRequestTimeout(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchRequestTimeout", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetFetchRequestTimeout indicates an expected call of SetFetchRequestTimeout
func (mr *MockOptionsMockRecorder) SetFetchRequestTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchRequestTimeout", reflect.TypeOf((*MockOptions)(nil).SetFetchRequestTimeout), value)
}

// FetchRequestTimeout mocks base method
func (m *MockOptions) FetchRequestTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchRequestTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// FetchRequestTimeout indicates an expected call of FetchRequestTimeout
func (mr *MockOptionsMockRecorder) FetchRequestTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchRequestTimeout", reflect.TypeOf((*MockOptions)(nil).FetchRequestTimeout))
}

// SetTruncateRequestTimeout mocks base method
func (m *MockOptions) SetTruncateRequestTimeout(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTruncateRequestTimeout", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTruncateRequestTimeout indicates an expected call of SetTruncateRequestTimeout
func (mr *MockOptionsMockRecorder) SetTruncateRequestTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTruncateRequestTimeout", reflect.TypeOf((*MockOptions)(nil).SetTruncateRequestTimeout), value)
}

// TruncateRequestTimeout mocks base method
func (m *MockOptions) TruncateRequestTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TruncateRequestTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// TruncateRequestTimeout indicates an expected call of TruncateRequestTimeout
func (mr *MockOptionsMockRecorder) TruncateRequestTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TruncateRequestTimeout", reflect.TypeOf((*MockOptions)(nil).TruncateRequestTimeout))
}

// SetBackgroundConnectInterval mocks base method
func (m *MockOptions) SetBackgroundConnectInterval(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBackgroundConnectInterval", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBackgroundConnectInterval indicates an expected call of SetBackgroundConnectInterval
func (mr *MockOptionsMockRecorder) SetBackgroundConnectInterval(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBackgroundConnectInterval", reflect.TypeOf((*MockOptions)(nil).SetBackgroundConnectInterval), value)
}

// BackgroundConnectInterval mocks base method
func (m *MockOptions) BackgroundConnectInterval() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BackgroundConnectInterval")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// BackgroundConnectInterval indicates an expected call of BackgroundConnectInterval
func (mr *MockOptionsMockRecorder) BackgroundConnectInterval() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BackgroundConnectInterval", reflect.TypeOf((*MockOptions)(nil).BackgroundConnectInterval))
}

// SetBackgroundConnectStutter mocks base method
func (m *MockOptions) SetBackgroundConnectStutter(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBackgroundConnectStutter", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBackgroundConnectStutter indicates an expected call of SetBackgroundConnectStutter
func (mr *MockOptionsMockRecorder) SetBackgroundConnectStutter(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBackgroundConnectStutter", reflect.TypeOf((*MockOptions)(nil).SetBackgroundConnectStutter), value)
}

// BackgroundConnectStutter mocks base method
func (m *MockOptions) BackgroundConnectStutter() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BackgroundConnectStutter")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// BackgroundConnectStutter indicates an expected call of BackgroundConnectStutter
func (mr *MockOptionsMockRecorder) BackgroundConnectStutter() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BackgroundConnectStutter", reflect.TypeOf((*MockOptions)(nil).BackgroundConnectStutter))
}

// SetBackgroundHealthCheckInterval mocks base method
func (m *MockOptions) SetBackgroundHealthCheckInterval(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBackgroundHealthCheckInterval", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBackgroundHealthCheckInterval indicates an expected call of SetBackgroundHealthCheckInterval
func (mr *MockOptionsMockRecorder) SetBackgroundHealthCheckInterval(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBackgroundHealthCheckInterval", reflect.TypeOf((*MockOptions)(nil).SetBackgroundHealthCheckInterval), value)
}

// BackgroundHealthCheckInterval mocks base method
func (m *MockOptions) BackgroundHealthCheckInterval() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BackgroundHealthCheckInterval")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// BackgroundHealthCheckInterval indicates an expected call of BackgroundHealthCheckInterval
func (mr *MockOptionsMockRecorder) BackgroundHealthCheckInterval() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BackgroundHealthCheckInterval", reflect.TypeOf((*MockOptions)(nil).BackgroundHealthCheckInterval))
}

// SetBackgroundHealthCheckStutter mocks base method
func (m *MockOptions) SetBackgroundHealthCheckStutter(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBackgroundHealthCheckStutter", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBackgroundHealthCheckStutter indicates an expected call of SetBackgroundHealthCheckStutter
func (mr *MockOptionsMockRecorder) SetBackgroundHealthCheckStutter(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBackgroundHealthCheckStutter", reflect.TypeOf((*MockOptions)(nil).SetBackgroundHealthCheckStutter), value)
}

// BackgroundHealthCheckStutter mocks base method
func (m *MockOptions) BackgroundHealthCheckStutter() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BackgroundHealthCheckStutter")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// BackgroundHealthCheckStutter indicates an expected call of BackgroundHealthCheckStutter
func (mr *MockOptionsMockRecorder) BackgroundHealthCheckStutter() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BackgroundHealthCheckStutter", reflect.TypeOf((*MockOptions)(nil).BackgroundHealthCheckStutter))
}

// SetBackgroundHealthCheckFailLimit mocks base method
func (m *MockOptions) SetBackgroundHealthCheckFailLimit(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBackgroundHealthCheckFailLimit", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBackgroundHealthCheckFailLimit indicates an expected call of SetBackgroundHealthCheckFailLimit
func (mr *MockOptionsMockRecorder) SetBackgroundHealthCheckFailLimit(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBackgroundHealthCheckFailLimit", reflect.TypeOf((*MockOptions)(nil).SetBackgroundHealthCheckFailLimit), value)
}

// BackgroundHealthCheckFailLimit mocks base method
func (m *MockOptions) BackgroundHealthCheckFailLimit() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BackgroundHealthCheckFailLimit")
	ret0, _ := ret[0].(int)
	return ret0
}

// BackgroundHealthCheckFailLimit indicates an expected call of BackgroundHealthCheckFailLimit
func (mr *MockOptionsMockRecorder) BackgroundHealthCheckFailLimit() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BackgroundHealthCheckFailLimit", reflect.TypeOf((*MockOptions)(nil).BackgroundHealthCheckFailLimit))
}

// SetBackgroundHealthCheckFailThrottleFactor mocks base method
func (m *MockOptions) SetBackgroundHealthCheckFailThrottleFactor(value float64) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBackgroundHealthCheckFailThrottleFactor", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBackgroundHealthCheckFailThrottleFactor indicates an expected call of SetBackgroundHealthCheckFailThrottleFactor
func (mr *MockOptionsMockRecorder) SetBackgroundHealthCheckFailThrottleFactor(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBackgroundHealthCheckFailThrottleFactor", reflect.TypeOf((*MockOptions)(nil).SetBackgroundHealthCheckFailThrottleFactor), value)
}

// BackgroundHealthCheckFailThrottleFactor mocks base method
func (m *MockOptions) BackgroundHealthCheckFailThrottleFactor() float64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BackgroundHealthCheckFailThrottleFactor")
	ret0, _ := ret[0].(float64)
	return ret0
}

// BackgroundHealthCheckFailThrottleFactor indicates an expected call of BackgroundHealthCheckFailThrottleFactor
func (mr *MockOptionsMockRecorder) BackgroundHealthCheckFailThrottleFactor() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BackgroundHealthCheckFailThrottleFactor", reflect.TypeOf((*MockOptions)(nil).BackgroundHealthCheckFailThrottleFactor))
}

// SetWriteRetrier mocks base method
func (m *MockOptions) SetWriteRetrier(value retry.Retrier) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteRetrier", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteRetrier indicates an expected call of SetWriteRetrier
func (mr *MockOptionsMockRecorder) SetWriteRetrier(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteRetrier", reflect.TypeOf((*MockOptions)(nil).SetWriteRetrier), value)
}

// WriteRetrier mocks base method
func (m *MockOptions) WriteRetrier() retry.Retrier {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteRetrier")
	ret0, _ := ret[0].(retry.Retrier)
	return ret0
}

// WriteRetrier indicates an expected call of WriteRetrier
func (mr *MockOptionsMockRecorder) WriteRetrier() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteRetrier", reflect.TypeOf((*MockOptions)(nil).WriteRetrier))
}

// SetFetchRetrier mocks base method
func (m *MockOptions) SetFetchRetrier(value retry.Retrier) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchRetrier", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetFetchRetrier indicates an expected call of SetFetchRetrier
func (mr *MockOptionsMockRecorder) SetFetchRetrier(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchRetrier", reflect.TypeOf((*MockOptions)(nil).SetFetchRetrier), value)
}

// FetchRetrier mocks base method
func (m *MockOptions) FetchRetrier() retry.Retrier {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchRetrier")
	ret0, _ := ret[0].(retry.Retrier)
	return ret0
}

// FetchRetrier indicates an expected call of FetchRetrier
func (mr *MockOptionsMockRecorder) FetchRetrier() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchRetrier", reflect.TypeOf((*MockOptions)(nil).FetchRetrier))
}

// SetTagEncoderOptions mocks base method
func (m *MockOptions) SetTagEncoderOptions(value serialize.TagEncoderOptions) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTagEncoderOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTagEncoderOptions indicates an expected call of SetTagEncoderOptions
func (mr *MockOptionsMockRecorder) SetTagEncoderOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTagEncoderOptions", reflect.TypeOf((*MockOptions)(nil).SetTagEncoderOptions), value)
}

// TagEncoderOptions mocks base method
func (m *MockOptions) TagEncoderOptions() serialize.TagEncoderOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagEncoderOptions")
	ret0, _ := ret[0].(serialize.TagEncoderOptions)
	return ret0
}

// TagEncoderOptions indicates an expected call of TagEncoderOptions
func (mr *MockOptionsMockRecorder) TagEncoderOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagEncoderOptions", reflect.TypeOf((*MockOptions)(nil).TagEncoderOptions))
}

// SetTagEncoderPoolSize mocks base method
func (m *MockOptions) SetTagEncoderPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTagEncoderPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTagEncoderPoolSize indicates an expected call of SetTagEncoderPoolSize
func (mr *MockOptionsMockRecorder) SetTagEncoderPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTagEncoderPoolSize", reflect.TypeOf((*MockOptions)(nil).SetTagEncoderPoolSize), value)
}

// TagEncoderPoolSize mocks base method
func (m *MockOptions) TagEncoderPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagEncoderPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// TagEncoderPoolSize indicates an expected call of TagEncoderPoolSize
func (mr *MockOptionsMockRecorder) TagEncoderPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagEncoderPoolSize", reflect.TypeOf((*MockOptions)(nil).TagEncoderPoolSize))
}

// SetTagDecoderOptions mocks base method
func (m *MockOptions) SetTagDecoderOptions(value serialize.TagDecoderOptions) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTagDecoderOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTagDecoderOptions indicates an expected call of SetTagDecoderOptions
func (mr *MockOptionsMockRecorder) SetTagDecoderOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTagDecoderOptions", reflect.TypeOf((*MockOptions)(nil).SetTagDecoderOptions), value)
}

// TagDecoderOptions mocks base method
func (m *MockOptions) TagDecoderOptions() serialize.TagDecoderOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagDecoderOptions")
	ret0, _ := ret[0].(serialize.TagDecoderOptions)
	return ret0
}

// TagDecoderOptions indicates an expected call of TagDecoderOptions
func (mr *MockOptionsMockRecorder) TagDecoderOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagDecoderOptions", reflect.TypeOf((*MockOptions)(nil).TagDecoderOptions))
}

// SetTagDecoderPoolSize mocks base method
func (m *MockOptions) SetTagDecoderPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTagDecoderPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTagDecoderPoolSize indicates an expected call of SetTagDecoderPoolSize
func (mr *MockOptionsMockRecorder) SetTagDecoderPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTagDecoderPoolSize", reflect.TypeOf((*MockOptions)(nil).SetTagDecoderPoolSize), value)
}

// TagDecoderPoolSize mocks base method
func (m *MockOptions) TagDecoderPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagDecoderPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// TagDecoderPoolSize indicates an expected call of TagDecoderPoolSize
func (mr *MockOptionsMockRecorder) TagDecoderPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagDecoderPoolSize", reflect.TypeOf((*MockOptions)(nil).TagDecoderPoolSize))
}

// SetWriteBatchSize mocks base method
func (m *MockOptions) SetWriteBatchSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteBatchSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteBatchSize indicates an expected call of SetWriteBatchSize
func (mr *MockOptionsMockRecorder) SetWriteBatchSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteBatchSize", reflect.TypeOf((*MockOptions)(nil).SetWriteBatchSize), value)
}

// WriteBatchSize mocks base method
func (m *MockOptions) WriteBatchSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteBatchSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// WriteBatchSize indicates an expected call of WriteBatchSize
func (mr *MockOptionsMockRecorder) WriteBatchSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteBatchSize", reflect.TypeOf((*MockOptions)(nil).WriteBatchSize))
}

// SetFetchBatchSize mocks base method
func (m *MockOptions) SetFetchBatchSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchBatchSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetFetchBatchSize indicates an expected call of SetFetchBatchSize
func (mr *MockOptionsMockRecorder) SetFetchBatchSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchBatchSize", reflect.TypeOf((*MockOptions)(nil).SetFetchBatchSize), value)
}

// FetchBatchSize mocks base method
func (m *MockOptions) FetchBatchSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBatchSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// FetchBatchSize indicates an expected call of FetchBatchSize
func (mr *MockOptionsMockRecorder) FetchBatchSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBatchSize", reflect.TypeOf((*MockOptions)(nil).FetchBatchSize))
}

// SetWriteOpPoolSize mocks base method
func (m *MockOptions) SetWriteOpPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteOpPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteOpPoolSize indicates an expected call of SetWriteOpPoolSize
func (mr *MockOptionsMockRecorder) SetWriteOpPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteOpPoolSize", reflect.TypeOf((*MockOptions)(nil).SetWriteOpPoolSize), value)
}

// WriteOpPoolSize mocks base method
func (m *MockOptions) WriteOpPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteOpPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// WriteOpPoolSize indicates an expected call of WriteOpPoolSize
func (mr *MockOptionsMockRecorder) WriteOpPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteOpPoolSize", reflect.TypeOf((*MockOptions)(nil).WriteOpPoolSize))
}

// SetWriteTaggedOpPoolSize mocks base method
func (m *MockOptions) SetWriteTaggedOpPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteTaggedOpPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteTaggedOpPoolSize indicates an expected call of SetWriteTaggedOpPoolSize
func (mr *MockOptionsMockRecorder) SetWriteTaggedOpPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteTaggedOpPoolSize", reflect.TypeOf((*MockOptions)(nil).SetWriteTaggedOpPoolSize), value)
}

// WriteTaggedOpPoolSize mocks base method
func (m *MockOptions) WriteTaggedOpPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTaggedOpPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// WriteTaggedOpPoolSize indicates an expected call of WriteTaggedOpPoolSize
func (mr *MockOptionsMockRecorder) WriteTaggedOpPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTaggedOpPoolSize", reflect.TypeOf((*MockOptions)(nil).WriteTaggedOpPoolSize))
}

// SetFetchBatchOpPoolSize mocks base method
func (m *MockOptions) SetFetchBatchOpPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchBatchOpPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetFetchBatchOpPoolSize indicates an expected call of SetFetchBatchOpPoolSize
func (mr *MockOptionsMockRecorder) SetFetchBatchOpPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchBatchOpPoolSize", reflect.TypeOf((*MockOptions)(nil).SetFetchBatchOpPoolSize), value)
}

// FetchBatchOpPoolSize mocks base method
func (m *MockOptions) FetchBatchOpPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBatchOpPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// FetchBatchOpPoolSize indicates an expected call of FetchBatchOpPoolSize
func (mr *MockOptionsMockRecorder) FetchBatchOpPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBatchOpPoolSize", reflect.TypeOf((*MockOptions)(nil).FetchBatchOpPoolSize))
}

// SetCheckedBytesWrapperPoolSize mocks base method
func (m *MockOptions) SetCheckedBytesWrapperPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetCheckedBytesWrapperPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetCheckedBytesWrapperPoolSize indicates an expected call of SetCheckedBytesWrapperPoolSize
func (mr *MockOptionsMockRecorder) SetCheckedBytesWrapperPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetCheckedBytesWrapperPoolSize", reflect.TypeOf((*MockOptions)(nil).SetCheckedBytesWrapperPoolSize), value)
}

// CheckedBytesWrapperPoolSize mocks base method
func (m *MockOptions) CheckedBytesWrapperPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CheckedBytesWrapperPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// CheckedBytesWrapperPoolSize indicates an expected call of CheckedBytesWrapperPoolSize
func (mr *MockOptionsMockRecorder) CheckedBytesWrapperPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CheckedBytesWrapperPoolSize", reflect.TypeOf((*MockOptions)(nil).CheckedBytesWrapperPoolSize))
}

// SetHostQueueOpsFlushSize mocks base method
func (m *MockOptions) SetHostQueueOpsFlushSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHostQueueOpsFlushSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetHostQueueOpsFlushSize indicates an expected call of SetHostQueueOpsFlushSize
func (mr *MockOptionsMockRecorder) SetHostQueueOpsFlushSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHostQueueOpsFlushSize", reflect.TypeOf((*MockOptions)(nil).SetHostQueueOpsFlushSize), value)
}

// HostQueueOpsFlushSize mocks base method
func (m *MockOptions) HostQueueOpsFlushSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HostQueueOpsFlushSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// HostQueueOpsFlushSize indicates an expected call of HostQueueOpsFlushSize
func (mr *MockOptionsMockRecorder) HostQueueOpsFlushSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HostQueueOpsFlushSize", reflect.TypeOf((*MockOptions)(nil).HostQueueOpsFlushSize))
}

// SetHostQueueOpsFlushInterval mocks base method
func (m *MockOptions) SetHostQueueOpsFlushInterval(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHostQueueOpsFlushInterval", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetHostQueueOpsFlushInterval indicates an expected call of SetHostQueueOpsFlushInterval
func (mr *MockOptionsMockRecorder) SetHostQueueOpsFlushInterval(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHostQueueOpsFlushInterval", reflect.TypeOf((*MockOptions)(nil).SetHostQueueOpsFlushInterval), value)
}

// HostQueueOpsFlushInterval mocks base method
func (m *MockOptions) HostQueueOpsFlushInterval() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HostQueueOpsFlushInterval")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// HostQueueOpsFlushInterval indicates an expected call of HostQueueOpsFlushInterval
func (mr *MockOptionsMockRecorder) HostQueueOpsFlushInterval() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HostQueueOpsFlushInterval", reflect.TypeOf((*MockOptions)(nil).HostQueueOpsFlushInterval))
}

// SetContextPool mocks base method
func (m *MockOptions) SetContextPool(value context.Pool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetContextPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetContextPool indicates an expected call of SetContextPool
func (mr *MockOptionsMockRecorder) SetContextPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetContextPool", reflect.TypeOf((*MockOptions)(nil).SetContextPool), value)
}

// ContextPool mocks base method
func (m *MockOptions) ContextPool() context.Pool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ContextPool")
	ret0, _ := ret[0].(context.Pool)
	return ret0
}

// ContextPool indicates an expected call of ContextPool
func (mr *MockOptionsMockRecorder) ContextPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ContextPool", reflect.TypeOf((*MockOptions)(nil).ContextPool))
}

// SetIdentifierPool mocks base method
func (m *MockOptions) SetIdentifierPool(value ident.Pool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIdentifierPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetIdentifierPool indicates an expected call of SetIdentifierPool
func (mr *MockOptionsMockRecorder) SetIdentifierPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIdentifierPool", reflect.TypeOf((*MockOptions)(nil).SetIdentifierPool), value)
}

// IdentifierPool mocks base method
func (m *MockOptions) IdentifierPool() ident.Pool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IdentifierPool")
	ret0, _ := ret[0].(ident.Pool)
	return ret0
}

// IdentifierPool indicates an expected call of IdentifierPool
func (mr *MockOptionsMockRecorder) IdentifierPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IdentifierPool", reflect.TypeOf((*MockOptions)(nil).IdentifierPool))
}

// SetHostQueueOpsArrayPoolSize mocks base method
func (m *MockOptions) SetHostQueueOpsArrayPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHostQueueOpsArrayPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetHostQueueOpsArrayPoolSize indicates an expected call of SetHostQueueOpsArrayPoolSize
func (mr *MockOptionsMockRecorder) SetHostQueueOpsArrayPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHostQueueOpsArrayPoolSize", reflect.TypeOf((*MockOptions)(nil).SetHostQueueOpsArrayPoolSize), value)
}

// HostQueueOpsArrayPoolSize mocks base method
func (m *MockOptions) HostQueueOpsArrayPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HostQueueOpsArrayPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// HostQueueOpsArrayPoolSize indicates an expected call of HostQueueOpsArrayPoolSize
func (mr *MockOptionsMockRecorder) HostQueueOpsArrayPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HostQueueOpsArrayPoolSize", reflect.TypeOf((*MockOptions)(nil).HostQueueOpsArrayPoolSize))
}

// SetSeriesIteratorPoolSize mocks base method
func (m *MockOptions) SetSeriesIteratorPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetSeriesIteratorPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetSeriesIteratorPoolSize indicates an expected call of SetSeriesIteratorPoolSize
func (mr *MockOptionsMockRecorder) SetSeriesIteratorPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSeriesIteratorPoolSize", reflect.TypeOf((*MockOptions)(nil).SetSeriesIteratorPoolSize), value)
}

// SeriesIteratorPoolSize mocks base method
func (m *MockOptions) SeriesIteratorPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SeriesIteratorPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// SeriesIteratorPoolSize indicates an expected call of SeriesIteratorPoolSize
func (mr *MockOptionsMockRecorder) SeriesIteratorPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SeriesIteratorPoolSize", reflect.TypeOf((*MockOptions)(nil).SeriesIteratorPoolSize))
}

// SetSeriesIteratorArrayPoolBuckets mocks base method
func (m *MockOptions) SetSeriesIteratorArrayPoolBuckets(value []pool.Bucket) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetSeriesIteratorArrayPoolBuckets", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetSeriesIteratorArrayPoolBuckets indicates an expected call of SetSeriesIteratorArrayPoolBuckets
func (mr *MockOptionsMockRecorder) SetSeriesIteratorArrayPoolBuckets(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSeriesIteratorArrayPoolBuckets", reflect.TypeOf((*MockOptions)(nil).SetSeriesIteratorArrayPoolBuckets), value)
}

// SeriesIteratorArrayPoolBuckets mocks base method
func (m *MockOptions) SeriesIteratorArrayPoolBuckets() []pool.Bucket {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SeriesIteratorArrayPoolBuckets")
	ret0, _ := ret[0].([]pool.Bucket)
	return ret0
}

// SeriesIteratorArrayPoolBuckets indicates an expected call of SeriesIteratorArrayPoolBuckets
func (mr *MockOptionsMockRecorder) SeriesIteratorArrayPoolBuckets() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SeriesIteratorArrayPoolBuckets", reflect.TypeOf((*MockOptions)(nil).SeriesIteratorArrayPoolBuckets))
}

// SetReaderIteratorAllocate mocks base method
func (m *MockOptions) SetReaderIteratorAllocate(value encoding.ReaderIteratorAllocate) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetReaderIteratorAllocate", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetReaderIteratorAllocate indicates an expected call of SetReaderIteratorAllocate
func (mr *MockOptionsMockRecorder) SetReaderIteratorAllocate(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetReaderIteratorAllocate", reflect.TypeOf((*MockOptions)(nil).SetReaderIteratorAllocate), value)
}

// ReaderIteratorAllocate mocks base method
func (m *MockOptions) ReaderIteratorAllocate() encoding.ReaderIteratorAllocate {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReaderIteratorAllocate")
	ret0, _ := ret[0].(encoding.ReaderIteratorAllocate)
	return ret0
}

// ReaderIteratorAllocate indicates an expected call of ReaderIteratorAllocate
func (mr *MockOptionsMockRecorder) ReaderIteratorAllocate() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReaderIteratorAllocate", reflect.TypeOf((*MockOptions)(nil).ReaderIteratorAllocate))
}

// SetSchemaRegistry mocks base method
func (m *MockOptions) SetSchemaRegistry(registry namespace.SchemaRegistry) AdminOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetSchemaRegistry", registry)
	ret0, _ := ret[0].(AdminOptions)
	return ret0
}

// SetSchemaRegistry indicates an expected call of SetSchemaRegistry
func (mr *MockOptionsMockRecorder) SetSchemaRegistry(registry interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSchemaRegistry", reflect.TypeOf((*MockOptions)(nil).SetSchemaRegistry), registry)
}

// SchemaRegistry mocks base method
func (m *MockOptions) SchemaRegistry() namespace.SchemaRegistry {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SchemaRegistry")
	ret0, _ := ret[0].(namespace.SchemaRegistry)
	return ret0
}

// SchemaRegistry indicates an expected call of SchemaRegistry
func (mr *MockOptionsMockRecorder) SchemaRegistry() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SchemaRegistry", reflect.TypeOf((*MockOptions)(nil).SchemaRegistry))
}

// SetAsyncTopologyInitializers mocks base method
func (m *MockOptions) SetAsyncTopologyInitializers(value []topology.Initializer) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetAsyncTopologyInitializers", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetAsyncTopologyInitializers indicates an expected call of SetAsyncTopologyInitializers
func (mr *MockOptionsMockRecorder) SetAsyncTopologyInitializers(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetAsyncTopologyInitializers", reflect.TypeOf((*MockOptions)(nil).SetAsyncTopologyInitializers), value)
}

// AsyncTopologyInitializers mocks base method
func (m *MockOptions) AsyncTopologyInitializers() []topology.Initializer {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AsyncTopologyInitializers")
	ret0, _ := ret[0].([]topology.Initializer)
	return ret0
}

// AsyncTopologyInitializers indicates an expected call of AsyncTopologyInitializers
func (mr *MockOptionsMockRecorder) AsyncTopologyInitializers() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AsyncTopologyInitializers", reflect.TypeOf((*MockOptions)(nil).AsyncTopologyInitializers))
}

// SetAsyncWriteWorkerPool mocks base method
func (m *MockOptions) SetAsyncWriteWorkerPool(value sync.PooledWorkerPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetAsyncWriteWorkerPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetAsyncWriteWorkerPool indicates an expected call of SetAsyncWriteWorkerPool
func (mr *MockOptionsMockRecorder) SetAsyncWriteWorkerPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetAsyncWriteWorkerPool", reflect.TypeOf((*MockOptions)(nil).SetAsyncWriteWorkerPool), value)
}

// AsyncWriteWorkerPool mocks base method
func (m *MockOptions) AsyncWriteWorkerPool() sync.PooledWorkerPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AsyncWriteWorkerPool")
	ret0, _ := ret[0].(sync.PooledWorkerPool)
	return ret0
}

// AsyncWriteWorkerPool indicates an expected call of AsyncWriteWorkerPool
func (mr *MockOptionsMockRecorder) AsyncWriteWorkerPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AsyncWriteWorkerPool", reflect.TypeOf((*MockOptions)(nil).AsyncWriteWorkerPool))
}

// SetAsyncWriteMaxConcurrency mocks base method
func (m *MockOptions) SetAsyncWriteMaxConcurrency(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetAsyncWriteMaxConcurrency", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetAsyncWriteMaxConcurrency indicates an expected call of SetAsyncWriteMaxConcurrency
func (mr *MockOptionsMockRecorder) SetAsyncWriteMaxConcurrency(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetAsyncWriteMaxConcurrency", reflect.TypeOf((*MockOptions)(nil).SetAsyncWriteMaxConcurrency), value)
}

// AsyncWriteMaxConcurrency mocks base method
func (m *MockOptions) AsyncWriteMaxConcurrency() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AsyncWriteMaxConcurrency")
	ret0, _ := ret[0].(int)
	return ret0
}

// AsyncWriteMaxConcurrency indicates an expected call of AsyncWriteMaxConcurrency
func (mr *MockOptionsMockRecorder) AsyncWriteMaxConcurrency() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AsyncWriteMaxConcurrency", reflect.TypeOf((*MockOptions)(nil).AsyncWriteMaxConcurrency))
}

// SetUseV2BatchAPIs mocks base method
func (m *MockOptions) SetUseV2BatchAPIs(value bool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetUseV2BatchAPIs", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetUseV2BatchAPIs indicates an expected call of SetUseV2BatchAPIs
func (mr *MockOptionsMockRecorder) SetUseV2BatchAPIs(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetUseV2BatchAPIs", reflect.TypeOf((*MockOptions)(nil).SetUseV2BatchAPIs), value)
}

// UseV2BatchAPIs mocks base method
func (m *MockOptions) UseV2BatchAPIs() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UseV2BatchAPIs")
	ret0, _ := ret[0].(bool)
	return ret0
}

// UseV2BatchAPIs indicates an expected call of UseV2BatchAPIs
func (mr *MockOptionsMockRecorder) UseV2BatchAPIs() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UseV2BatchAPIs", reflect.TypeOf((*MockOptions)(nil).UseV2BatchAPIs))
}

// MockAdminOptions is a mock of AdminOptions interface
type MockAdminOptions struct {
	ctrl     *gomock.Controller
	recorder *MockAdminOptionsMockRecorder
}

// MockAdminOptionsMockRecorder is the mock recorder for MockAdminOptions
type MockAdminOptionsMockRecorder struct {
	mock *MockAdminOptions
}

// NewMockAdminOptions creates a new mock instance
func NewMockAdminOptions(ctrl *gomock.Controller) *MockAdminOptions {
	mock := &MockAdminOptions{ctrl: ctrl}
	mock.recorder = &MockAdminOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockAdminOptions) EXPECT() *MockAdminOptionsMockRecorder {
	return m.recorder
}

// Validate mocks base method
func (m *MockAdminOptions) Validate() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Validate")
	ret0, _ := ret[0].(error)
	return ret0
}

// Validate indicates an expected call of Validate
func (mr *MockAdminOptionsMockRecorder) Validate() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Validate", reflect.TypeOf((*MockAdminOptions)(nil).Validate))
}

// SetEncodingM3TSZ mocks base method
func (m *MockAdminOptions) SetEncodingM3TSZ() Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetEncodingM3TSZ")
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetEncodingM3TSZ indicates an expected call of SetEncodingM3TSZ
func (mr *MockAdminOptionsMockRecorder) SetEncodingM3TSZ() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetEncodingM3TSZ", reflect.TypeOf((*MockAdminOptions)(nil).SetEncodingM3TSZ))
}

// SetEncodingProto mocks base method
func (m *MockAdminOptions) SetEncodingProto(encodingOpts encoding.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetEncodingProto", encodingOpts)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetEncodingProto indicates an expected call of SetEncodingProto
func (mr *MockAdminOptionsMockRecorder) SetEncodingProto(encodingOpts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetEncodingProto", reflect.TypeOf((*MockAdminOptions)(nil).SetEncodingProto), encodingOpts)
}

// IsSetEncodingProto mocks base method
func (m *MockAdminOptions) IsSetEncodingProto() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsSetEncodingProto")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsSetEncodingProto indicates an expected call of IsSetEncodingProto
func (mr *MockAdminOptionsMockRecorder) IsSetEncodingProto() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsSetEncodingProto", reflect.TypeOf((*MockAdminOptions)(nil).IsSetEncodingProto))
}

// SetRuntimeOptionsManager mocks base method
func (m *MockAdminOptions) SetRuntimeOptionsManager(value runtime.OptionsManager) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetRuntimeOptionsManager", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetRuntimeOptionsManager indicates an expected call of SetRuntimeOptionsManager
func (mr *MockAdminOptionsMockRecorder) SetRuntimeOptionsManager(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetRuntimeOptionsManager", reflect.TypeOf((*MockAdminOptions)(nil).SetRuntimeOptionsManager), value)
}

// RuntimeOptionsManager mocks base method
func (m *MockAdminOptions) RuntimeOptionsManager() runtime.OptionsManager {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RuntimeOptionsManager")
	ret0, _ := ret[0].(runtime.OptionsManager)
	return ret0
}

// RuntimeOptionsManager indicates an expected call of RuntimeOptionsManager
func (mr *MockAdminOptionsMockRecorder) RuntimeOptionsManager() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RuntimeOptionsManager", reflect.TypeOf((*MockAdminOptions)(nil).RuntimeOptionsManager))
}

// SetClockOptions mocks base method
func (m *MockAdminOptions) SetClockOptions(value clock.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetClockOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetClockOptions indicates an expected call of SetClockOptions
func (mr *MockAdminOptionsMockRecorder) SetClockOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetClockOptions", reflect.TypeOf((*MockAdminOptions)(nil).SetClockOptions), value)
}

// ClockOptions mocks base method
func (m *MockAdminOptions) ClockOptions() clock.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ClockOptions")
	ret0, _ := ret[0].(clock.Options)
	return ret0
}

// ClockOptions indicates an expected call of ClockOptions
func (mr *MockAdminOptionsMockRecorder) ClockOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClockOptions", reflect.TypeOf((*MockAdminOptions)(nil).ClockOptions))
}

// SetInstrumentOptions mocks base method
func (m *MockAdminOptions) SetInstrumentOptions(value instrument.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetInstrumentOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetInstrumentOptions indicates an expected call of SetInstrumentOptions
func (mr *MockAdminOptionsMockRecorder) SetInstrumentOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetInstrumentOptions", reflect.TypeOf((*MockAdminOptions)(nil).SetInstrumentOptions), value)
}

// InstrumentOptions mocks base method
func (m *MockAdminOptions) InstrumentOptions() instrument.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InstrumentOptions")
	ret0, _ := ret[0].(instrument.Options)
	return ret0
}

// InstrumentOptions indicates an expected call of InstrumentOptions
func (mr *MockAdminOptionsMockRecorder) InstrumentOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InstrumentOptions", reflect.TypeOf((*MockAdminOptions)(nil).InstrumentOptions))
}

// SetTopologyInitializer mocks base method
func (m *MockAdminOptions) SetTopologyInitializer(value topology.Initializer) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTopologyInitializer", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTopologyInitializer indicates an expected call of SetTopologyInitializer
func (mr *MockAdminOptionsMockRecorder) SetTopologyInitializer(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTopologyInitializer", reflect.TypeOf((*MockAdminOptions)(nil).SetTopologyInitializer), value)
}

// TopologyInitializer mocks base method
func (m *MockAdminOptions) TopologyInitializer() topology.Initializer {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TopologyInitializer")
	ret0, _ := ret[0].(topology.Initializer)
	return ret0
}

// TopologyInitializer indicates an expected call of TopologyInitializer
func (mr *MockAdminOptionsMockRecorder) TopologyInitializer() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TopologyInitializer", reflect.TypeOf((*MockAdminOptions)(nil).TopologyInitializer))
}

// SetReadConsistencyLevel mocks base method
func (m *MockAdminOptions) SetReadConsistencyLevel(value topology.ReadConsistencyLevel) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetReadConsistencyLevel", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetReadConsistencyLevel indicates an expected call of SetReadConsistencyLevel
func (mr *MockAdminOptionsMockRecorder) SetReadConsistencyLevel(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetReadConsistencyLevel", reflect.TypeOf((*MockAdminOptions)(nil).SetReadConsistencyLevel), value)
}

// ReadConsistencyLevel mocks base method
func (m *MockAdminOptions) ReadConsistencyLevel() topology.ReadConsistencyLevel {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReadConsistencyLevel")
	ret0, _ := ret[0].(topology.ReadConsistencyLevel)
	return ret0
}

// ReadConsistencyLevel indicates an expected call of ReadConsistencyLevel
func (mr *MockAdminOptionsMockRecorder) ReadConsistencyLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReadConsistencyLevel", reflect.TypeOf((*MockAdminOptions)(nil).ReadConsistencyLevel))
}

// SetWriteConsistencyLevel mocks base method
func (m *MockAdminOptions) SetWriteConsistencyLevel(value topology.ConsistencyLevel) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteConsistencyLevel", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteConsistencyLevel indicates an expected call of SetWriteConsistencyLevel
func (mr *MockAdminOptionsMockRecorder) SetWriteConsistencyLevel(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteConsistencyLevel", reflect.TypeOf((*MockAdminOptions)(nil).SetWriteConsistencyLevel), value)
}

// WriteConsistencyLevel mocks base method
func (m *MockAdminOptions) WriteConsistencyLevel() topology.ConsistencyLevel {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteConsistencyLevel")
	ret0, _ := ret[0].(topology.ConsistencyLevel)
	return ret0
}

// WriteConsistencyLevel indicates an expected call of WriteConsistencyLevel
func (mr *MockAdminOptionsMockRecorder) WriteConsistencyLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteConsistencyLevel", reflect.TypeOf((*MockAdminOptions)(nil).WriteConsistencyLevel))
}

// SetChannelOptions mocks base method
func (m *MockAdminOptions) SetChannelOptions(value *tchannel_go.ChannelOptions) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetChannelOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetChannelOptions indicates an expected call of SetChannelOptions
func (mr *MockAdminOptionsMockRecorder) SetChannelOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetChannelOptions", reflect.TypeOf((*MockAdminOptions)(nil).SetChannelOptions), value)
}

// ChannelOptions mocks base method
func (m *MockAdminOptions) ChannelOptions() *tchannel_go.ChannelOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ChannelOptions")
	ret0, _ := ret[0].(*tchannel_go.ChannelOptions)
	return ret0
}

// ChannelOptions indicates an expected call of ChannelOptions
func (mr *MockAdminOptionsMockRecorder) ChannelOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ChannelOptions", reflect.TypeOf((*MockAdminOptions)(nil).ChannelOptions))
}

// SetMaxConnectionCount mocks base method
func (m *MockAdminOptions) SetMaxConnectionCount(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetMaxConnectionCount", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetMaxConnectionCount indicates an expected call of SetMaxConnectionCount
func (mr *MockAdminOptionsMockRecorder) SetMaxConnectionCount(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetMaxConnectionCount", reflect.TypeOf((*MockAdminOptions)(nil).SetMaxConnectionCount), value)
}

// MaxConnectionCount mocks base method
func (m *MockAdminOptions) MaxConnectionCount() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MaxConnectionCount")
	ret0, _ := ret[0].(int)
	return ret0
}

// MaxConnectionCount indicates an expected call of MaxConnectionCount
func (mr *MockAdminOptionsMockRecorder) MaxConnectionCount() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MaxConnectionCount", reflect.TypeOf((*MockAdminOptions)(nil).MaxConnectionCount))
}

// SetMinConnectionCount mocks base method
func (m *MockAdminOptions) SetMinConnectionCount(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetMinConnectionCount", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetMinConnectionCount indicates an expected call of SetMinConnectionCount
func (mr *MockAdminOptionsMockRecorder) SetMinConnectionCount(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetMinConnectionCount", reflect.TypeOf((*MockAdminOptions)(nil).SetMinConnectionCount), value)
}

// MinConnectionCount mocks base method
func (m *MockAdminOptions) MinConnectionCount() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MinConnectionCount")
	ret0, _ := ret[0].(int)
	return ret0
}

// MinConnectionCount indicates an expected call of MinConnectionCount
func (mr *MockAdminOptionsMockRecorder) MinConnectionCount() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MinConnectionCount", reflect.TypeOf((*MockAdminOptions)(nil).MinConnectionCount))
}

// SetHostConnectTimeout mocks base method
func (m *MockAdminOptions) SetHostConnectTimeout(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHostConnectTimeout", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetHostConnectTimeout indicates an expected call of SetHostConnectTimeout
func (mr *MockAdminOptionsMockRecorder) SetHostConnectTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHostConnectTimeout", reflect.TypeOf((*MockAdminOptions)(nil).SetHostConnectTimeout), value)
}

// HostConnectTimeout mocks base method
func (m *MockAdminOptions) HostConnectTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HostConnectTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// HostConnectTimeout indicates an expected call of HostConnectTimeout
func (mr *MockAdminOptionsMockRecorder) HostConnectTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HostConnectTimeout", reflect.TypeOf((*MockAdminOptions)(nil).HostConnectTimeout))
}

// SetClusterConnectTimeout mocks base method
func (m *MockAdminOptions) SetClusterConnectTimeout(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetClusterConnectTimeout", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetClusterConnectTimeout indicates an expected call of SetClusterConnectTimeout
func (mr *MockAdminOptionsMockRecorder) SetClusterConnectTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetClusterConnectTimeout", reflect.TypeOf((*MockAdminOptions)(nil).SetClusterConnectTimeout), value)
}

// ClusterConnectTimeout mocks base method
func (m *MockAdminOptions) ClusterConnectTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ClusterConnectTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// ClusterConnectTimeout indicates an expected call of ClusterConnectTimeout
func (mr *MockAdminOptionsMockRecorder) ClusterConnectTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClusterConnectTimeout", reflect.TypeOf((*MockAdminOptions)(nil).ClusterConnectTimeout))
}

// SetClusterConnectConsistencyLevel mocks base method
func (m *MockAdminOptions) SetClusterConnectConsistencyLevel(value topology.ConnectConsistencyLevel) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetClusterConnectConsistencyLevel", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetClusterConnectConsistencyLevel indicates an expected call of SetClusterConnectConsistencyLevel
func (mr *MockAdminOptionsMockRecorder) SetClusterConnectConsistencyLevel(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetClusterConnectConsistencyLevel", reflect.TypeOf((*MockAdminOptions)(nil).SetClusterConnectConsistencyLevel), value)
}

// ClusterConnectConsistencyLevel mocks base method
func (m *MockAdminOptions) ClusterConnectConsistencyLevel() topology.ConnectConsistencyLevel {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ClusterConnectConsistencyLevel")
	ret0, _ := ret[0].(topology.ConnectConsistencyLevel)
	return ret0
}

// ClusterConnectConsistencyLevel indicates an expected call of ClusterConnectConsistencyLevel
func (mr *MockAdminOptionsMockRecorder) ClusterConnectConsistencyLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClusterConnectConsistencyLevel", reflect.TypeOf((*MockAdminOptions)(nil).ClusterConnectConsistencyLevel))
}

// SetWriteRequestTimeout mocks base method
func (m *MockAdminOptions) SetWriteRequestTimeout(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteRequestTimeout", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteRequestTimeout indicates an expected call of SetWriteRequestTimeout
func (mr *MockAdminOptionsMockRecorder) SetWriteRequestTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteRequestTimeout", reflect.TypeOf((*MockAdminOptions)(nil).SetWriteRequestTimeout), value)
}

// WriteRequestTimeout mocks base method
func (m *MockAdminOptions) WriteRequestTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteRequestTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// WriteRequestTimeout indicates an expected call of WriteRequestTimeout
func (mr *MockAdminOptionsMockRecorder) WriteRequestTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteRequestTimeout", reflect.TypeOf((*MockAdminOptions)(nil).WriteRequestTimeout))
}

// SetFetchRequestTimeout mocks base method
func (m *MockAdminOptions) SetFetchRequestTimeout(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchRequestTimeout", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetFetchRequestTimeout indicates an expected call of SetFetchRequestTimeout
func (mr *MockAdminOptionsMockRecorder) SetFetchRequestTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchRequestTimeout", reflect.TypeOf((*MockAdminOptions)(nil).SetFetchRequestTimeout), value)
}

// FetchRequestTimeout mocks base method
func (m *MockAdminOptions) FetchRequestTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchRequestTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// FetchRequestTimeout indicates an expected call of FetchRequestTimeout
func (mr *MockAdminOptionsMockRecorder) FetchRequestTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchRequestTimeout", reflect.TypeOf((*MockAdminOptions)(nil).FetchRequestTimeout))
}

// SetTruncateRequestTimeout mocks base method
func (m *MockAdminOptions) SetTruncateRequestTimeout(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTruncateRequestTimeout", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTruncateRequestTimeout indicates an expected call of SetTruncateRequestTimeout
func (mr *MockAdminOptionsMockRecorder) SetTruncateRequestTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTruncateRequestTimeout", reflect.TypeOf((*MockAdminOptions)(nil).SetTruncateRequestTimeout), value)
}

// TruncateRequestTimeout mocks base method
func (m *MockAdminOptions) TruncateRequestTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TruncateRequestTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// TruncateRequestTimeout indicates an expected call of TruncateRequestTimeout
func (mr *MockAdminOptionsMockRecorder) TruncateRequestTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TruncateRequestTimeout", reflect.TypeOf((*MockAdminOptions)(nil).TruncateRequestTimeout))
}

// SetBackgroundConnectInterval mocks base method
func (m *MockAdminOptions) SetBackgroundConnectInterval(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBackgroundConnectInterval", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBackgroundConnectInterval indicates an expected call of SetBackgroundConnectInterval
func (mr *MockAdminOptionsMockRecorder) SetBackgroundConnectInterval(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBackgroundConnectInterval", reflect.TypeOf((*MockAdminOptions)(nil).SetBackgroundConnectInterval), value)
}

// BackgroundConnectInterval mocks base method
func (m *MockAdminOptions) BackgroundConnectInterval() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BackgroundConnectInterval")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// BackgroundConnectInterval indicates an expected call of BackgroundConnectInterval
func (mr *MockAdminOptionsMockRecorder) BackgroundConnectInterval() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BackgroundConnectInterval", reflect.TypeOf((*MockAdminOptions)(nil).BackgroundConnectInterval))
}

// SetBackgroundConnectStutter mocks base method
func (m *MockAdminOptions) SetBackgroundConnectStutter(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBackgroundConnectStutter", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBackgroundConnectStutter indicates an expected call of SetBackgroundConnectStutter
func (mr *MockAdminOptionsMockRecorder) SetBackgroundConnectStutter(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBackgroundConnectStutter", reflect.TypeOf((*MockAdminOptions)(nil).SetBackgroundConnectStutter), value)
}

// BackgroundConnectStutter mocks base method
func (m *MockAdminOptions) BackgroundConnectStutter() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BackgroundConnectStutter")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// BackgroundConnectStutter indicates an expected call of BackgroundConnectStutter
func (mr *MockAdminOptionsMockRecorder) BackgroundConnectStutter() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BackgroundConnectStutter", reflect.TypeOf((*MockAdminOptions)(nil).BackgroundConnectStutter))
}

// SetBackgroundHealthCheckInterval mocks base method
func (m *MockAdminOptions) SetBackgroundHealthCheckInterval(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBackgroundHealthCheckInterval", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBackgroundHealthCheckInterval indicates an expected call of SetBackgroundHealthCheckInterval
func (mr *MockAdminOptionsMockRecorder) SetBackgroundHealthCheckInterval(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBackgroundHealthCheckInterval", reflect.TypeOf((*MockAdminOptions)(nil).SetBackgroundHealthCheckInterval), value)
}

// BackgroundHealthCheckInterval mocks base method
func (m *MockAdminOptions) BackgroundHealthCheckInterval() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BackgroundHealthCheckInterval")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// BackgroundHealthCheckInterval indicates an expected call of BackgroundHealthCheckInterval
func (mr *MockAdminOptionsMockRecorder) BackgroundHealthCheckInterval() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BackgroundHealthCheckInterval", reflect.TypeOf((*MockAdminOptions)(nil).BackgroundHealthCheckInterval))
}

// SetBackgroundHealthCheckStutter mocks base method
func (m *MockAdminOptions) SetBackgroundHealthCheckStutter(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBackgroundHealthCheckStutter", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBackgroundHealthCheckStutter indicates an expected call of SetBackgroundHealthCheckStutter
func (mr *MockAdminOptionsMockRecorder) SetBackgroundHealthCheckStutter(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBackgroundHealthCheckStutter", reflect.TypeOf((*MockAdminOptions)(nil).SetBackgroundHealthCheckStutter), value)
}

// BackgroundHealthCheckStutter mocks base method
func (m *MockAdminOptions) BackgroundHealthCheckStutter() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BackgroundHealthCheckStutter")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// BackgroundHealthCheckStutter indicates an expected call of BackgroundHealthCheckStutter
func (mr *MockAdminOptionsMockRecorder) BackgroundHealthCheckStutter() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BackgroundHealthCheckStutter", reflect.TypeOf((*MockAdminOptions)(nil).BackgroundHealthCheckStutter))
}

// SetBackgroundHealthCheckFailLimit mocks base method
func (m *MockAdminOptions) SetBackgroundHealthCheckFailLimit(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBackgroundHealthCheckFailLimit", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBackgroundHealthCheckFailLimit indicates an expected call of SetBackgroundHealthCheckFailLimit
func (mr *MockAdminOptionsMockRecorder) SetBackgroundHealthCheckFailLimit(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBackgroundHealthCheckFailLimit", reflect.TypeOf((*MockAdminOptions)(nil).SetBackgroundHealthCheckFailLimit), value)
}

// BackgroundHealthCheckFailLimit mocks base method
func (m *MockAdminOptions) BackgroundHealthCheckFailLimit() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BackgroundHealthCheckFailLimit")
	ret0, _ := ret[0].(int)
	return ret0
}

// BackgroundHealthCheckFailLimit indicates an expected call of BackgroundHealthCheckFailLimit
func (mr *MockAdminOptionsMockRecorder) BackgroundHealthCheckFailLimit() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BackgroundHealthCheckFailLimit", reflect.TypeOf((*MockAdminOptions)(nil).BackgroundHealthCheckFailLimit))
}

// SetBackgroundHealthCheckFailThrottleFactor mocks base method
func (m *MockAdminOptions) SetBackgroundHealthCheckFailThrottleFactor(value float64) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBackgroundHealthCheckFailThrottleFactor", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBackgroundHealthCheckFailThrottleFactor indicates an expected call of SetBackgroundHealthCheckFailThrottleFactor
func (mr *MockAdminOptionsMockRecorder) SetBackgroundHealthCheckFailThrottleFactor(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBackgroundHealthCheckFailThrottleFactor", reflect.TypeOf((*MockAdminOptions)(nil).SetBackgroundHealthCheckFailThrottleFactor), value)
}

// BackgroundHealthCheckFailThrottleFactor mocks base method
func (m *MockAdminOptions) BackgroundHealthCheckFailThrottleFactor() float64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BackgroundHealthCheckFailThrottleFactor")
	ret0, _ := ret[0].(float64)
	return ret0
}

// BackgroundHealthCheckFailThrottleFactor indicates an expected call of BackgroundHealthCheckFailThrottleFactor
func (mr *MockAdminOptionsMockRecorder) BackgroundHealthCheckFailThrottleFactor() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BackgroundHealthCheckFailThrottleFactor", reflect.TypeOf((*MockAdminOptions)(nil).BackgroundHealthCheckFailThrottleFactor))
}

// SetWriteRetrier mocks base method
func (m *MockAdminOptions) SetWriteRetrier(value retry.Retrier) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteRetrier", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteRetrier indicates an expected call of SetWriteRetrier
func (mr *MockAdminOptionsMockRecorder) SetWriteRetrier(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteRetrier", reflect.TypeOf((*MockAdminOptions)(nil).SetWriteRetrier), value)
}

// WriteRetrier mocks base method
func (m *MockAdminOptions) WriteRetrier() retry.Retrier {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteRetrier")
	ret0, _ := ret[0].(retry.Retrier)
	return ret0
}

// WriteRetrier indicates an expected call of WriteRetrier
func (mr *MockAdminOptionsMockRecorder) WriteRetrier() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteRetrier", reflect.TypeOf((*MockAdminOptions)(nil).WriteRetrier))
}

// SetFetchRetrier mocks base method
func (m *MockAdminOptions) SetFetchRetrier(value retry.Retrier) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchRetrier", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetFetchRetrier indicates an expected call of SetFetchRetrier
func (mr *MockAdminOptionsMockRecorder) SetFetchRetrier(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchRetrier", reflect.TypeOf((*MockAdminOptions)(nil).SetFetchRetrier), value)
}

// FetchRetrier mocks base method
func (m *MockAdminOptions) FetchRetrier() retry.Retrier {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchRetrier")
	ret0, _ := ret[0].(retry.Retrier)
	return ret0
}

// FetchRetrier indicates an expected call of FetchRetrier
func (mr *MockAdminOptionsMockRecorder) FetchRetrier() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchRetrier", reflect.TypeOf((*MockAdminOptions)(nil).FetchRetrier))
}

// SetTagEncoderOptions mocks base method
func (m *MockAdminOptions) SetTagEncoderOptions(value serialize.TagEncoderOptions) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTagEncoderOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTagEncoderOptions indicates an expected call of SetTagEncoderOptions
func (mr *MockAdminOptionsMockRecorder) SetTagEncoderOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTagEncoderOptions", reflect.TypeOf((*MockAdminOptions)(nil).SetTagEncoderOptions), value)
}

// TagEncoderOptions mocks base method
func (m *MockAdminOptions) TagEncoderOptions() serialize.TagEncoderOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagEncoderOptions")
	ret0, _ := ret[0].(serialize.TagEncoderOptions)
	return ret0
}

// TagEncoderOptions indicates an expected call of TagEncoderOptions
func (mr *MockAdminOptionsMockRecorder) TagEncoderOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagEncoderOptions", reflect.TypeOf((*MockAdminOptions)(nil).TagEncoderOptions))
}

// SetTagEncoderPoolSize mocks base method
func (m *MockAdminOptions) SetTagEncoderPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTagEncoderPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTagEncoderPoolSize indicates an expected call of SetTagEncoderPoolSize
func (mr *MockAdminOptionsMockRecorder) SetTagEncoderPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTagEncoderPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).SetTagEncoderPoolSize), value)
}

// TagEncoderPoolSize mocks base method
func (m *MockAdminOptions) TagEncoderPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagEncoderPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// TagEncoderPoolSize indicates an expected call of TagEncoderPoolSize
func (mr *MockAdminOptionsMockRecorder) TagEncoderPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagEncoderPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).TagEncoderPoolSize))
}

// SetTagDecoderOptions mocks base method
func (m *MockAdminOptions) SetTagDecoderOptions(value serialize.TagDecoderOptions) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTagDecoderOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTagDecoderOptions indicates an expected call of SetTagDecoderOptions
func (mr *MockAdminOptionsMockRecorder) SetTagDecoderOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTagDecoderOptions", reflect.TypeOf((*MockAdminOptions)(nil).SetTagDecoderOptions), value)
}

// TagDecoderOptions mocks base method
func (m *MockAdminOptions) TagDecoderOptions() serialize.TagDecoderOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagDecoderOptions")
	ret0, _ := ret[0].(serialize.TagDecoderOptions)
	return ret0
}

// TagDecoderOptions indicates an expected call of TagDecoderOptions
func (mr *MockAdminOptionsMockRecorder) TagDecoderOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagDecoderOptions", reflect.TypeOf((*MockAdminOptions)(nil).TagDecoderOptions))
}

// SetTagDecoderPoolSize mocks base method
func (m *MockAdminOptions) SetTagDecoderPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTagDecoderPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTagDecoderPoolSize indicates an expected call of SetTagDecoderPoolSize
func (mr *MockAdminOptionsMockRecorder) SetTagDecoderPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTagDecoderPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).SetTagDecoderPoolSize), value)
}

// TagDecoderPoolSize mocks base method
func (m *MockAdminOptions) TagDecoderPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagDecoderPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// TagDecoderPoolSize indicates an expected call of TagDecoderPoolSize
func (mr *MockAdminOptionsMockRecorder) TagDecoderPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagDecoderPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).TagDecoderPoolSize))
}

// SetWriteBatchSize mocks base method
func (m *MockAdminOptions) SetWriteBatchSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteBatchSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteBatchSize indicates an expected call of SetWriteBatchSize
func (mr *MockAdminOptionsMockRecorder) SetWriteBatchSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteBatchSize", reflect.TypeOf((*MockAdminOptions)(nil).SetWriteBatchSize), value)
}

// WriteBatchSize mocks base method
func (m *MockAdminOptions) WriteBatchSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteBatchSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// WriteBatchSize indicates an expected call of WriteBatchSize
func (mr *MockAdminOptionsMockRecorder) WriteBatchSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteBatchSize", reflect.TypeOf((*MockAdminOptions)(nil).WriteBatchSize))
}

// SetFetchBatchSize mocks base method
func (m *MockAdminOptions) SetFetchBatchSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchBatchSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetFetchBatchSize indicates an expected call of SetFetchBatchSize
func (mr *MockAdminOptionsMockRecorder) SetFetchBatchSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchBatchSize", reflect.TypeOf((*MockAdminOptions)(nil).SetFetchBatchSize), value)
}

// FetchBatchSize mocks base method
func (m *MockAdminOptions) FetchBatchSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBatchSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// FetchBatchSize indicates an expected call of FetchBatchSize
func (mr *MockAdminOptionsMockRecorder) FetchBatchSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBatchSize", reflect.TypeOf((*MockAdminOptions)(nil).FetchBatchSize))
}

// SetWriteOpPoolSize mocks base method
func (m *MockAdminOptions) SetWriteOpPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteOpPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteOpPoolSize indicates an expected call of SetWriteOpPoolSize
func (mr *MockAdminOptionsMockRecorder) SetWriteOpPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteOpPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).SetWriteOpPoolSize), value)
}

// WriteOpPoolSize mocks base method
func (m *MockAdminOptions) WriteOpPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteOpPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// WriteOpPoolSize indicates an expected call of WriteOpPoolSize
func (mr *MockAdminOptionsMockRecorder) WriteOpPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteOpPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).WriteOpPoolSize))
}

// SetWriteTaggedOpPoolSize mocks base method
func (m *MockAdminOptions) SetWriteTaggedOpPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteTaggedOpPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteTaggedOpPoolSize indicates an expected call of SetWriteTaggedOpPoolSize
func (mr *MockAdminOptionsMockRecorder) SetWriteTaggedOpPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteTaggedOpPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).SetWriteTaggedOpPoolSize), value)
}

// WriteTaggedOpPoolSize mocks base method
func (m *MockAdminOptions) WriteTaggedOpPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTaggedOpPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// WriteTaggedOpPoolSize indicates an expected call of WriteTaggedOpPoolSize
func (mr *MockAdminOptionsMockRecorder) WriteTaggedOpPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTaggedOpPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).WriteTaggedOpPoolSize))
}

// SetFetchBatchOpPoolSize mocks base method
func (m *MockAdminOptions) SetFetchBatchOpPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchBatchOpPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetFetchBatchOpPoolSize indicates an expected call of SetFetchBatchOpPoolSize
func (mr *MockAdminOptionsMockRecorder) SetFetchBatchOpPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchBatchOpPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).SetFetchBatchOpPoolSize), value)
}

// FetchBatchOpPoolSize mocks base method
func (m *MockAdminOptions) FetchBatchOpPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBatchOpPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// FetchBatchOpPoolSize indicates an expected call of FetchBatchOpPoolSize
func (mr *MockAdminOptionsMockRecorder) FetchBatchOpPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBatchOpPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).FetchBatchOpPoolSize))
}

// SetCheckedBytesWrapperPoolSize mocks base method
func (m *MockAdminOptions) SetCheckedBytesWrapperPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetCheckedBytesWrapperPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetCheckedBytesWrapperPoolSize indicates an expected call of SetCheckedBytesWrapperPoolSize
func (mr *MockAdminOptionsMockRecorder) SetCheckedBytesWrapperPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetCheckedBytesWrapperPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).SetCheckedBytesWrapperPoolSize), value)
}

// CheckedBytesWrapperPoolSize mocks base method
func (m *MockAdminOptions) CheckedBytesWrapperPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CheckedBytesWrapperPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// CheckedBytesWrapperPoolSize indicates an expected call of CheckedBytesWrapperPoolSize
func (mr *MockAdminOptionsMockRecorder) CheckedBytesWrapperPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CheckedBytesWrapperPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).CheckedBytesWrapperPoolSize))
}

// SetHostQueueOpsFlushSize mocks base method
func (m *MockAdminOptions) SetHostQueueOpsFlushSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHostQueueOpsFlushSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetHostQueueOpsFlushSize indicates an expected call of SetHostQueueOpsFlushSize
func (mr *MockAdminOptionsMockRecorder) SetHostQueueOpsFlushSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHostQueueOpsFlushSize", reflect.TypeOf((*MockAdminOptions)(nil).SetHostQueueOpsFlushSize), value)
}

// HostQueueOpsFlushSize mocks base method
func (m *MockAdminOptions) HostQueueOpsFlushSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HostQueueOpsFlushSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// HostQueueOpsFlushSize indicates an expected call of HostQueueOpsFlushSize
func (mr *MockAdminOptionsMockRecorder) HostQueueOpsFlushSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HostQueueOpsFlushSize", reflect.TypeOf((*MockAdminOptions)(nil).HostQueueOpsFlushSize))
}

// SetHostQueueOpsFlushInterval mocks base method
func (m *MockAdminOptions) SetHostQueueOpsFlushInterval(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHostQueueOpsFlushInterval", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetHostQueueOpsFlushInterval indicates an expected call of SetHostQueueOpsFlushInterval
func (mr *MockAdminOptionsMockRecorder) SetHostQueueOpsFlushInterval(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHostQueueOpsFlushInterval", reflect.TypeOf((*MockAdminOptions)(nil).SetHostQueueOpsFlushInterval), value)
}

// HostQueueOpsFlushInterval mocks base method
func (m *MockAdminOptions) HostQueueOpsFlushInterval() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HostQueueOpsFlushInterval")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// HostQueueOpsFlushInterval indicates an expected call of HostQueueOpsFlushInterval
func (mr *MockAdminOptionsMockRecorder) HostQueueOpsFlushInterval() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HostQueueOpsFlushInterval", reflect.TypeOf((*MockAdminOptions)(nil).HostQueueOpsFlushInterval))
}

// SetContextPool mocks base method
func (m *MockAdminOptions) SetContextPool(value context.Pool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetContextPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetContextPool indicates an expected call of SetContextPool
func (mr *MockAdminOptionsMockRecorder) SetContextPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetContextPool", reflect.TypeOf((*MockAdminOptions)(nil).SetContextPool), value)
}

// ContextPool mocks base method
func (m *MockAdminOptions) ContextPool() context.Pool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ContextPool")
	ret0, _ := ret[0].(context.Pool)
	return ret0
}

// ContextPool indicates an expected call of ContextPool
func (mr *MockAdminOptionsMockRecorder) ContextPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ContextPool", reflect.TypeOf((*MockAdminOptions)(nil).ContextPool))
}

// SetIdentifierPool mocks base method
func (m *MockAdminOptions) SetIdentifierPool(value ident.Pool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIdentifierPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetIdentifierPool indicates an expected call of SetIdentifierPool
func (mr *MockAdminOptionsMockRecorder) SetIdentifierPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIdentifierPool", reflect.TypeOf((*MockAdminOptions)(nil).SetIdentifierPool), value)
}

// IdentifierPool mocks base method
func (m *MockAdminOptions) IdentifierPool() ident.Pool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IdentifierPool")
	ret0, _ := ret[0].(ident.Pool)
	return ret0
}

// IdentifierPool indicates an expected call of IdentifierPool
func (mr *MockAdminOptionsMockRecorder) IdentifierPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IdentifierPool", reflect.TypeOf((*MockAdminOptions)(nil).IdentifierPool))
}

// SetHostQueueOpsArrayPoolSize mocks base method
func (m *MockAdminOptions) SetHostQueueOpsArrayPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetHostQueueOpsArrayPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetHostQueueOpsArrayPoolSize indicates an expected call of SetHostQueueOpsArrayPoolSize
func (mr *MockAdminOptionsMockRecorder) SetHostQueueOpsArrayPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetHostQueueOpsArrayPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).SetHostQueueOpsArrayPoolSize), value)
}

// HostQueueOpsArrayPoolSize mocks base method
func (m *MockAdminOptions) HostQueueOpsArrayPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HostQueueOpsArrayPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// HostQueueOpsArrayPoolSize indicates an expected call of HostQueueOpsArrayPoolSize
func (mr *MockAdminOptionsMockRecorder) HostQueueOpsArrayPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HostQueueOpsArrayPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).HostQueueOpsArrayPoolSize))
}

// SetSeriesIteratorPoolSize mocks base method
func (m *MockAdminOptions) SetSeriesIteratorPoolSize(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetSeriesIteratorPoolSize", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetSeriesIteratorPoolSize indicates an expected call of SetSeriesIteratorPoolSize
func (mr *MockAdminOptionsMockRecorder) SetSeriesIteratorPoolSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSeriesIteratorPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).SetSeriesIteratorPoolSize), value)
}

// SeriesIteratorPoolSize mocks base method
func (m *MockAdminOptions) SeriesIteratorPoolSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SeriesIteratorPoolSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// SeriesIteratorPoolSize indicates an expected call of SeriesIteratorPoolSize
func (mr *MockAdminOptionsMockRecorder) SeriesIteratorPoolSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SeriesIteratorPoolSize", reflect.TypeOf((*MockAdminOptions)(nil).SeriesIteratorPoolSize))
}

// SetSeriesIteratorArrayPoolBuckets mocks base method
func (m *MockAdminOptions) SetSeriesIteratorArrayPoolBuckets(value []pool.Bucket) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetSeriesIteratorArrayPoolBuckets", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetSeriesIteratorArrayPoolBuckets indicates an expected call of SetSeriesIteratorArrayPoolBuckets
func (mr *MockAdminOptionsMockRecorder) SetSeriesIteratorArrayPoolBuckets(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSeriesIteratorArrayPoolBuckets", reflect.TypeOf((*MockAdminOptions)(nil).SetSeriesIteratorArrayPoolBuckets), value)
}

// SeriesIteratorArrayPoolBuckets mocks base method
func (m *MockAdminOptions) SeriesIteratorArrayPoolBuckets() []pool.Bucket {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SeriesIteratorArrayPoolBuckets")
	ret0, _ := ret[0].([]pool.Bucket)
	return ret0
}

// SeriesIteratorArrayPoolBuckets indicates an expected call of SeriesIteratorArrayPoolBuckets
func (mr *MockAdminOptionsMockRecorder) SeriesIteratorArrayPoolBuckets() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SeriesIteratorArrayPoolBuckets", reflect.TypeOf((*MockAdminOptions)(nil).SeriesIteratorArrayPoolBuckets))
}

// SetReaderIteratorAllocate mocks base method
func (m *MockAdminOptions) SetReaderIteratorAllocate(value encoding.ReaderIteratorAllocate) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetReaderIteratorAllocate", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetReaderIteratorAllocate indicates an expected call of SetReaderIteratorAllocate
func (mr *MockAdminOptionsMockRecorder) SetReaderIteratorAllocate(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetReaderIteratorAllocate", reflect.TypeOf((*MockAdminOptions)(nil).SetReaderIteratorAllocate), value)
}

// ReaderIteratorAllocate mocks base method
func (m *MockAdminOptions) ReaderIteratorAllocate() encoding.ReaderIteratorAllocate {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReaderIteratorAllocate")
	ret0, _ := ret[0].(encoding.ReaderIteratorAllocate)
	return ret0
}

// ReaderIteratorAllocate indicates an expected call of ReaderIteratorAllocate
func (mr *MockAdminOptionsMockRecorder) ReaderIteratorAllocate() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReaderIteratorAllocate", reflect.TypeOf((*MockAdminOptions)(nil).ReaderIteratorAllocate))
}

// SetSchemaRegistry mocks base method
func (m *MockAdminOptions) SetSchemaRegistry(registry namespace.SchemaRegistry) AdminOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetSchemaRegistry", registry)
	ret0, _ := ret[0].(AdminOptions)
	return ret0
}

// SetSchemaRegistry indicates an expected call of SetSchemaRegistry
func (mr *MockAdminOptionsMockRecorder) SetSchemaRegistry(registry interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSchemaRegistry", reflect.TypeOf((*MockAdminOptions)(nil).SetSchemaRegistry), registry)
}

// SchemaRegistry mocks base method
func (m *MockAdminOptions) SchemaRegistry() namespace.SchemaRegistry {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SchemaRegistry")
	ret0, _ := ret[0].(namespace.SchemaRegistry)
	return ret0
}

// SchemaRegistry indicates an expected call of SchemaRegistry
func (mr *MockAdminOptionsMockRecorder) SchemaRegistry() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SchemaRegistry", reflect.TypeOf((*MockAdminOptions)(nil).SchemaRegistry))
}

// SetAsyncTopologyInitializers mocks base method
func (m *MockAdminOptions) SetAsyncTopologyInitializers(value []topology.Initializer) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetAsyncTopologyInitializers", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetAsyncTopologyInitializers indicates an expected call of SetAsyncTopologyInitializers
func (mr *MockAdminOptionsMockRecorder) SetAsyncTopologyInitializers(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetAsyncTopologyInitializers", reflect.TypeOf((*MockAdminOptions)(nil).SetAsyncTopologyInitializers), value)
}

// AsyncTopologyInitializers mocks base method
func (m *MockAdminOptions) AsyncTopologyInitializers() []topology.Initializer {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AsyncTopologyInitializers")
	ret0, _ := ret[0].([]topology.Initializer)
	return ret0
}

// AsyncTopologyInitializers indicates an expected call of AsyncTopologyInitializers
func (mr *MockAdminOptionsMockRecorder) AsyncTopologyInitializers() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AsyncTopologyInitializers", reflect.TypeOf((*MockAdminOptions)(nil).AsyncTopologyInitializers))
}

// SetAsyncWriteWorkerPool mocks base method
func (m *MockAdminOptions) SetAsyncWriteWorkerPool(value sync.PooledWorkerPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetAsyncWriteWorkerPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetAsyncWriteWorkerPool indicates an expected call of SetAsyncWriteWorkerPool
func (mr *MockAdminOptionsMockRecorder) SetAsyncWriteWorkerPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetAsyncWriteWorkerPool", reflect.TypeOf((*MockAdminOptions)(nil).SetAsyncWriteWorkerPool), value)
}

// AsyncWriteWorkerPool mocks base method
func (m *MockAdminOptions) AsyncWriteWorkerPool() sync.PooledWorkerPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AsyncWriteWorkerPool")
	ret0, _ := ret[0].(sync.PooledWorkerPool)
	return ret0
}

// AsyncWriteWorkerPool indicates an expected call of AsyncWriteWorkerPool
func (mr *MockAdminOptionsMockRecorder) AsyncWriteWorkerPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AsyncWriteWorkerPool", reflect.TypeOf((*MockAdminOptions)(nil).AsyncWriteWorkerPool))
}

// SetAsyncWriteMaxConcurrency mocks base method
func (m *MockAdminOptions) SetAsyncWriteMaxConcurrency(value int) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetAsyncWriteMaxConcurrency", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetAsyncWriteMaxConcurrency indicates an expected call of SetAsyncWriteMaxConcurrency
func (mr *MockAdminOptionsMockRecorder) SetAsyncWriteMaxConcurrency(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetAsyncWriteMaxConcurrency", reflect.TypeOf((*MockAdminOptions)(nil).SetAsyncWriteMaxConcurrency), value)
}

// AsyncWriteMaxConcurrency mocks base method
func (m *MockAdminOptions) AsyncWriteMaxConcurrency() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AsyncWriteMaxConcurrency")
	ret0, _ := ret[0].(int)
	return ret0
}

// AsyncWriteMaxConcurrency indicates an expected call of AsyncWriteMaxConcurrency
func (mr *MockAdminOptionsMockRecorder) AsyncWriteMaxConcurrency() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AsyncWriteMaxConcurrency", reflect.TypeOf((*MockAdminOptions)(nil).AsyncWriteMaxConcurrency))
}

// SetUseV2BatchAPIs mocks base method
func (m *MockAdminOptions) SetUseV2BatchAPIs(value bool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetUseV2BatchAPIs", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetUseV2BatchAPIs indicates an expected call of SetUseV2BatchAPIs
func (mr *MockAdminOptionsMockRecorder) SetUseV2BatchAPIs(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetUseV2BatchAPIs", reflect.TypeOf((*MockAdminOptions)(nil).SetUseV2BatchAPIs), value)
}

// UseV2BatchAPIs mocks base method
func (m *MockAdminOptions) UseV2BatchAPIs() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UseV2BatchAPIs")
	ret0, _ := ret[0].(bool)
	return ret0
}

// UseV2BatchAPIs indicates an expected call of UseV2BatchAPIs
func (mr *MockAdminOptionsMockRecorder) UseV2BatchAPIs() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UseV2BatchAPIs", reflect.TypeOf((*MockAdminOptions)(nil).UseV2BatchAPIs))
}

// SetOrigin mocks base method
func (m *MockAdminOptions) SetOrigin(value topology.Host) AdminOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetOrigin", value)
	ret0, _ := ret[0].(AdminOptions)
	return ret0
}

// SetOrigin indicates an expected call of SetOrigin
func (mr *MockAdminOptionsMockRecorder) SetOrigin(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetOrigin", reflect.TypeOf((*MockAdminOptions)(nil).SetOrigin), value)
}

// Origin mocks base method
func (m *MockAdminOptions) Origin() topology.Host {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Origin")
	ret0, _ := ret[0].(topology.Host)
	return ret0
}

// Origin indicates an expected call of Origin
func (mr *MockAdminOptionsMockRecorder) Origin() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Origin", reflect.TypeOf((*MockAdminOptions)(nil).Origin))
}

// SetBootstrapConsistencyLevel mocks base method
func (m *MockAdminOptions) SetBootstrapConsistencyLevel(value topology.ReadConsistencyLevel) AdminOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBootstrapConsistencyLevel", value)
	ret0, _ := ret[0].(AdminOptions)
	return ret0
}

// SetBootstrapConsistencyLevel indicates an expected call of SetBootstrapConsistencyLevel
func (mr *MockAdminOptionsMockRecorder) SetBootstrapConsistencyLevel(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBootstrapConsistencyLevel", reflect.TypeOf((*MockAdminOptions)(nil).SetBootstrapConsistencyLevel), value)
}

// BootstrapConsistencyLevel mocks base method
func (m *MockAdminOptions) BootstrapConsistencyLevel() topology.ReadConsistencyLevel {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BootstrapConsistencyLevel")
	ret0, _ := ret[0].(topology.ReadConsistencyLevel)
	return ret0
}

// BootstrapConsistencyLevel indicates an expected call of BootstrapConsistencyLevel
func (mr *MockAdminOptionsMockRecorder) BootstrapConsistencyLevel() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BootstrapConsistencyLevel", reflect.TypeOf((*MockAdminOptions)(nil).BootstrapConsistencyLevel))
}

// SetFetchSeriesBlocksMaxBlockRetries mocks base method
func (m *MockAdminOptions) SetFetchSeriesBlocksMaxBlockRetries(value int) AdminOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchSeriesBlocksMaxBlockRetries", value)
	ret0, _ := ret[0].(AdminOptions)
	return ret0
}

// SetFetchSeriesBlocksMaxBlockRetries indicates an expected call of SetFetchSeriesBlocksMaxBlockRetries
func (mr *MockAdminOptionsMockRecorder) SetFetchSeriesBlocksMaxBlockRetries(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchSeriesBlocksMaxBlockRetries", reflect.TypeOf((*MockAdminOptions)(nil).SetFetchSeriesBlocksMaxBlockRetries), value)
}

// FetchSeriesBlocksMaxBlockRetries mocks base method
func (m *MockAdminOptions) FetchSeriesBlocksMaxBlockRetries() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchSeriesBlocksMaxBlockRetries")
	ret0, _ := ret[0].(int)
	return ret0
}

// FetchSeriesBlocksMaxBlockRetries indicates an expected call of FetchSeriesBlocksMaxBlockRetries
func (mr *MockAdminOptionsMockRecorder) FetchSeriesBlocksMaxBlockRetries() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchSeriesBlocksMaxBlockRetries", reflect.TypeOf((*MockAdminOptions)(nil).FetchSeriesBlocksMaxBlockRetries))
}

// SetFetchSeriesBlocksBatchSize mocks base method
func (m *MockAdminOptions) SetFetchSeriesBlocksBatchSize(value int) AdminOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchSeriesBlocksBatchSize", value)
	ret0, _ := ret[0].(AdminOptions)
	return ret0
}

// SetFetchSeriesBlocksBatchSize indicates an expected call of SetFetchSeriesBlocksBatchSize
func (mr *MockAdminOptionsMockRecorder) SetFetchSeriesBlocksBatchSize(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchSeriesBlocksBatchSize", reflect.TypeOf((*MockAdminOptions)(nil).SetFetchSeriesBlocksBatchSize), value)
}

// FetchSeriesBlocksBatchSize mocks base method
func (m *MockAdminOptions) FetchSeriesBlocksBatchSize() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchSeriesBlocksBatchSize")
	ret0, _ := ret[0].(int)
	return ret0
}

// FetchSeriesBlocksBatchSize indicates an expected call of FetchSeriesBlocksBatchSize
func (mr *MockAdminOptionsMockRecorder) FetchSeriesBlocksBatchSize() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchSeriesBlocksBatchSize", reflect.TypeOf((*MockAdminOptions)(nil).FetchSeriesBlocksBatchSize))
}

// SetFetchSeriesBlocksMetadataBatchTimeout mocks base method
func (m *MockAdminOptions) SetFetchSeriesBlocksMetadataBatchTimeout(value time.Duration) AdminOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchSeriesBlocksMetadataBatchTimeout", value)
	ret0, _ := ret[0].(AdminOptions)
	return ret0
}

// SetFetchSeriesBlocksMetadataBatchTimeout indicates an expected call of SetFetchSeriesBlocksMetadataBatchTimeout
func (mr *MockAdminOptionsMockRecorder) SetFetchSeriesBlocksMetadataBatchTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchSeriesBlocksMetadataBatchTimeout", reflect.TypeOf((*MockAdminOptions)(nil).SetFetchSeriesBlocksMetadataBatchTimeout), value)
}

// FetchSeriesBlocksMetadataBatchTimeout mocks base method
func (m *MockAdminOptions) FetchSeriesBlocksMetadataBatchTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchSeriesBlocksMetadataBatchTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// FetchSeriesBlocksMetadataBatchTimeout indicates an expected call of FetchSeriesBlocksMetadataBatchTimeout
func (mr *MockAdminOptionsMockRecorder) FetchSeriesBlocksMetadataBatchTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchSeriesBlocksMetadataBatchTimeout", reflect.TypeOf((*MockAdminOptions)(nil).FetchSeriesBlocksMetadataBatchTimeout))
}

// SetFetchSeriesBlocksBatchTimeout mocks base method
func (m *MockAdminOptions) SetFetchSeriesBlocksBatchTimeout(value time.Duration) AdminOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchSeriesBlocksBatchTimeout", value)
	ret0, _ := ret[0].(AdminOptions)
	return ret0
}

// SetFetchSeriesBlocksBatchTimeout indicates an expected call of SetFetchSeriesBlocksBatchTimeout
func (mr *MockAdminOptionsMockRecorder) SetFetchSeriesBlocksBatchTimeout(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchSeriesBlocksBatchTimeout", reflect.TypeOf((*MockAdminOptions)(nil).SetFetchSeriesBlocksBatchTimeout), value)
}

// FetchSeriesBlocksBatchTimeout mocks base method
func (m *MockAdminOptions) FetchSeriesBlocksBatchTimeout() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchSeriesBlocksBatchTimeout")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// FetchSeriesBlocksBatchTimeout indicates an expected call of FetchSeriesBlocksBatchTimeout
func (mr *MockAdminOptionsMockRecorder) FetchSeriesBlocksBatchTimeout() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchSeriesBlocksBatchTimeout", reflect.TypeOf((*MockAdminOptions)(nil).FetchSeriesBlocksBatchTimeout))
}

// SetFetchSeriesBlocksBatchConcurrency mocks base method
func (m *MockAdminOptions) SetFetchSeriesBlocksBatchConcurrency(value int) AdminOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchSeriesBlocksBatchConcurrency", value)
	ret0, _ := ret[0].(AdminOptions)
	return ret0
}

// SetFetchSeriesBlocksBatchConcurrency indicates an expected call of SetFetchSeriesBlocksBatchConcurrency
func (mr *MockAdminOptionsMockRecorder) SetFetchSeriesBlocksBatchConcurrency(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchSeriesBlocksBatchConcurrency", reflect.TypeOf((*MockAdminOptions)(nil).SetFetchSeriesBlocksBatchConcurrency), value)
}

// FetchSeriesBlocksBatchConcurrency mocks base method
func (m *MockAdminOptions) FetchSeriesBlocksBatchConcurrency() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchSeriesBlocksBatchConcurrency")
	ret0, _ := ret[0].(int)
	return ret0
}

// FetchSeriesBlocksBatchConcurrency indicates an expected call of FetchSeriesBlocksBatchConcurrency
func (mr *MockAdminOptionsMockRecorder) FetchSeriesBlocksBatchConcurrency() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchSeriesBlocksBatchConcurrency", reflect.TypeOf((*MockAdminOptions)(nil).FetchSeriesBlocksBatchConcurrency))
}

// SetStreamBlocksRetrier mocks base method
func (m *MockAdminOptions) SetStreamBlocksRetrier(value retry.Retrier) AdminOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetStreamBlocksRetrier", value)
	ret0, _ := ret[0].(AdminOptions)
	return ret0
}

// SetStreamBlocksRetrier indicates an expected call of SetStreamBlocksRetrier
func (mr *MockAdminOptionsMockRecorder) SetStreamBlocksRetrier(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetStreamBlocksRetrier", reflect.TypeOf((*MockAdminOptions)(nil).SetStreamBlocksRetrier), value)
}

// StreamBlocksRetrier mocks base method
func (m *MockAdminOptions) StreamBlocksRetrier() retry.Retrier {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "StreamBlocksRetrier")
	ret0, _ := ret[0].(retry.Retrier)
	return ret0
}

// StreamBlocksRetrier indicates an expected call of StreamBlocksRetrier
func (mr *MockAdminOptionsMockRecorder) StreamBlocksRetrier() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "StreamBlocksRetrier", reflect.TypeOf((*MockAdminOptions)(nil).StreamBlocksRetrier))
}

// MockclientSession is a mock of clientSession interface
type MockclientSession struct {
	ctrl     *gomock.Controller
	recorder *MockclientSessionMockRecorder
}

// MockclientSessionMockRecorder is the mock recorder for MockclientSession
type MockclientSessionMockRecorder struct {
	mock *MockclientSession
}

// NewMockclientSession creates a new mock instance
func NewMockclientSession(ctrl *gomock.Controller) *MockclientSession {
	mock := &MockclientSession{ctrl: ctrl}
	mock.recorder = &MockclientSessionMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockclientSession) EXPECT() *MockclientSessionMockRecorder {
	return m.recorder
}

// Write mocks base method
func (m *MockclientSession) Write(namespace, id ident.ID, t time.Time, value float64, unit time0.Unit, annotation []byte) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Write", namespace, id, t, value, unit, annotation)
	ret0, _ := ret[0].(error)
	return ret0
}

// Write indicates an expected call of Write
func (mr *MockclientSessionMockRecorder) Write(namespace, id, t, value, unit, annotation interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Write", reflect.TypeOf((*MockclientSession)(nil).Write), namespace, id, t, value, unit, annotation)
}

// WriteTagged mocks base method
func (m *MockclientSession) WriteTagged(namespace, id ident.ID, tags ident.TagIterator, t time.Time, value float64, unit time0.Unit, annotation []byte) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTagged", namespace, id, tags, t, value, unit, annotation)
	ret0, _ := ret[0].(error)
	return ret0
}

// WriteTagged indicates an expected call of WriteTagged
func (mr *MockclientSessionMockRecorder) WriteTagged(namespace, id, tags, t, value, unit, annotation interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTagged", reflect.TypeOf((*MockclientSession)(nil).WriteTagged), namespace, id, tags, t, value, unit, annotation)
}

// Fetch mocks base method
func (m *MockclientSession) Fetch(namespace, id ident.ID, startInclusive, endExclusive time.Time) (encoding.SeriesIterator, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Fetch", namespace, id, startInclusive, endExclusive)
	ret0, _ := ret[0].(encoding.SeriesIterator)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Fetch indicates an expected call of Fetch
func (mr *MockclientSessionMockRecorder) Fetch(namespace, id, startInclusive, endExclusive interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Fetch", reflect.TypeOf((*MockclientSession)(nil).Fetch), namespace, id, startInclusive, endExclusive)
}

// FetchIDs mocks base method
func (m *MockclientSession) FetchIDs(namespace ident.ID, ids ident.Iterator, startInclusive, endExclusive time.Time) (encoding.SeriesIterators, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchIDs", namespace, ids, startInclusive, endExclusive)
	ret0, _ := ret[0].(encoding.SeriesIterators)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchIDs indicates an expected call of FetchIDs
func (mr *MockclientSessionMockRecorder) FetchIDs(namespace, ids, startInclusive, endExclusive interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchIDs", reflect.TypeOf((*MockclientSession)(nil).FetchIDs), namespace, ids, startInclusive, endExclusive)
}

// FetchTagged mocks base method
func (m *MockclientSession) FetchTagged(namespace ident.ID, q index.Query, opts index.QueryOptions) (encoding.SeriesIterators, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchTagged", namespace, q, opts)
	ret0, _ := ret[0].(encoding.SeriesIterators)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// FetchTagged indicates an expected call of FetchTagged
func (mr *MockclientSessionMockRecorder) FetchTagged(namespace, q, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchTagged", reflect.TypeOf((*MockclientSession)(nil).FetchTagged), namespace, q, opts)
}

// FetchTaggedIDs mocks base method
func (m *MockclientSession) FetchTaggedIDs(namespace ident.ID, q index.Query, opts index.QueryOptions) (TaggedIDsIterator, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchTaggedIDs", namespace, q, opts)
	ret0, _ := ret[0].(TaggedIDsIterator)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// FetchTaggedIDs indicates an expected call of FetchTaggedIDs
func (mr *MockclientSessionMockRecorder) FetchTaggedIDs(namespace, q, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchTaggedIDs", reflect.TypeOf((*MockclientSession)(nil).FetchTaggedIDs), namespace, q, opts)
}

// Aggregate mocks base method
func (m *MockclientSession) Aggregate(namespace ident.ID, q index.Query, opts index.AggregationOptions) (AggregatedTagsIterator, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Aggregate", namespace, q, opts)
	ret0, _ := ret[0].(AggregatedTagsIterator)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// Aggregate indicates an expected call of Aggregate
func (mr *MockclientSessionMockRecorder) Aggregate(namespace, q, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Aggregate", reflect.TypeOf((*MockclientSession)(nil).Aggregate), namespace, q, opts)
}

// ShardID mocks base method
func (m *MockclientSession) ShardID(id ident.ID) (uint32, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ShardID", id)
	ret0, _ := ret[0].(uint32)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ShardID indicates an expected call of ShardID
func (mr *MockclientSessionMockRecorder) ShardID(id interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ShardID", reflect.TypeOf((*MockclientSession)(nil).ShardID), id)
}

// IteratorPools mocks base method
func (m *MockclientSession) IteratorPools() (encoding.IteratorPools, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IteratorPools")
	ret0, _ := ret[0].(encoding.IteratorPools)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// IteratorPools indicates an expected call of IteratorPools
func (mr *MockclientSessionMockRecorder) IteratorPools() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IteratorPools", reflect.TypeOf((*MockclientSession)(nil).IteratorPools))
}

// Close mocks base method
func (m *MockclientSession) Close() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Close")
	ret0, _ := ret[0].(error)
	return ret0
}

// Close indicates an expected call of Close
func (mr *MockclientSessionMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockclientSession)(nil).Close))
}

// Origin mocks base method
func (m *MockclientSession) Origin() topology.Host {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Origin")
	ret0, _ := ret[0].(topology.Host)
	return ret0
}

// Origin indicates an expected call of Origin
func (mr *MockclientSessionMockRecorder) Origin() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Origin", reflect.TypeOf((*MockclientSession)(nil).Origin))
}

// Replicas mocks base method
func (m *MockclientSession) Replicas() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Replicas")
	ret0, _ := ret[0].(int)
	return ret0
}

// Replicas indicates an expected call of Replicas
func (mr *MockclientSessionMockRecorder) Replicas() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Replicas", reflect.TypeOf((*MockclientSession)(nil).Replicas))
}

// TopologyMap mocks base method
func (m *MockclientSession) TopologyMap() (topology.Map, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TopologyMap")
	ret0, _ := ret[0].(topology.Map)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// TopologyMap indicates an expected call of TopologyMap
func (mr *MockclientSessionMockRecorder) TopologyMap() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TopologyMap", reflect.TypeOf((*MockclientSession)(nil).TopologyMap))
}

// Truncate mocks base method
func (m *MockclientSession) Truncate(namespace ident.ID) (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Truncate", namespace)
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Truncate indicates an expected call of Truncate
func (mr *MockclientSessionMockRecorder) Truncate(namespace interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Truncate", reflect.TypeOf((*MockclientSession)(nil).Truncate), namespace)
}

// FetchBootstrapBlocksFromPeers mocks base method
func (m *MockclientSession) FetchBootstrapBlocksFromPeers(namespace namespace.Metadata, shard uint32, start, end time.Time, opts result.Options) (result.ShardResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBootstrapBlocksFromPeers", namespace, shard, start, end, opts)
	ret0, _ := ret[0].(result.ShardResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBootstrapBlocksFromPeers indicates an expected call of FetchBootstrapBlocksFromPeers
func (mr *MockclientSessionMockRecorder) FetchBootstrapBlocksFromPeers(namespace, shard, start, end, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBootstrapBlocksFromPeers", reflect.TypeOf((*MockclientSession)(nil).FetchBootstrapBlocksFromPeers), namespace, shard, start, end, opts)
}

// FetchBootstrapBlocksMetadataFromPeers mocks base method
func (m *MockclientSession) FetchBootstrapBlocksMetadataFromPeers(namespace ident.ID, shard uint32, start, end time.Time, result result.Options) (PeerBlockMetadataIter, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBootstrapBlocksMetadataFromPeers", namespace, shard, start, end, result)
	ret0, _ := ret[0].(PeerBlockMetadataIter)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBootstrapBlocksMetadataFromPeers indicates an expected call of FetchBootstrapBlocksMetadataFromPeers
func (mr *MockclientSessionMockRecorder) FetchBootstrapBlocksMetadataFromPeers(namespace, shard, start, end, result interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBootstrapBlocksMetadataFromPeers", reflect.TypeOf((*MockclientSession)(nil).FetchBootstrapBlocksMetadataFromPeers), namespace, shard, start, end, result)
}

// FetchBlocksMetadataFromPeers mocks base method
func (m *MockclientSession) FetchBlocksMetadataFromPeers(namespace ident.ID, shard uint32, start, end time.Time, consistencyLevel topology.ReadConsistencyLevel, result result.Options) (PeerBlockMetadataIter, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocksMetadataFromPeers", namespace, shard, start, end, consistencyLevel, result)
	ret0, _ := ret[0].(PeerBlockMetadataIter)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBlocksMetadataFromPeers indicates an expected call of FetchBlocksMetadataFromPeers
func (mr *MockclientSessionMockRecorder) FetchBlocksMetadataFromPeers(namespace, shard, start, end, consistencyLevel, result interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocksMetadataFromPeers", reflect.TypeOf((*MockclientSession)(nil).FetchBlocksMetadataFromPeers), namespace, shard, start, end, consistencyLevel, result)
}

// FetchBlocksFromPeers mocks base method
func (m *MockclientSession) FetchBlocksFromPeers(namespace namespace.Metadata, shard uint32, consistencyLevel topology.ReadConsistencyLevel, metadatas []block.ReplicaMetadata, opts result.Options) (PeerBlocksIter, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocksFromPeers", namespace, shard, consistencyLevel, metadatas, opts)
	ret0, _ := ret[0].(PeerBlocksIter)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBlocksFromPeers indicates an expected call of FetchBlocksFromPeers
func (mr *MockclientSessionMockRecorder) FetchBlocksFromPeers(namespace, shard, consistencyLevel, metadatas, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocksFromPeers", reflect.TypeOf((*MockclientSession)(nil).FetchBlocksFromPeers), namespace, shard, consistencyLevel, metadatas, opts)
}

// Open mocks base method
func (m *MockclientSession) Open() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Open")
	ret0, _ := ret[0].(error)
	return ret0
}

// Open indicates an expected call of Open
func (mr *MockclientSessionMockRecorder) Open() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Open", reflect.TypeOf((*MockclientSession)(nil).Open))
}

// MockhostQueue is a mock of hostQueue interface
type MockhostQueue struct {
	ctrl     *gomock.Controller
	recorder *MockhostQueueMockRecorder
}

// MockhostQueueMockRecorder is the mock recorder for MockhostQueue
type MockhostQueueMockRecorder struct {
	mock *MockhostQueue
}

// NewMockhostQueue creates a new mock instance
func NewMockhostQueue(ctrl *gomock.Controller) *MockhostQueue {
	mock := &MockhostQueue{ctrl: ctrl}
	mock.recorder = &MockhostQueueMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockhostQueue) EXPECT() *MockhostQueueMockRecorder {
	return m.recorder
}

// Open mocks base method
func (m *MockhostQueue) Open() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Open")
}

// Open indicates an expected call of Open
func (mr *MockhostQueueMockRecorder) Open() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Open", reflect.TypeOf((*MockhostQueue)(nil).Open))
}

// Len mocks base method
func (m *MockhostQueue) Len() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Len")
	ret0, _ := ret[0].(int)
	return ret0
}

// Len indicates an expected call of Len
func (mr *MockhostQueueMockRecorder) Len() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Len", reflect.TypeOf((*MockhostQueue)(nil).Len))
}

// Enqueue mocks base method
func (m *MockhostQueue) Enqueue(op op) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Enqueue", op)
	ret0, _ := ret[0].(error)
	return ret0
}

// Enqueue indicates an expected call of Enqueue
func (mr *MockhostQueueMockRecorder) Enqueue(op interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Enqueue", reflect.TypeOf((*MockhostQueue)(nil).Enqueue), op)
}

// Host mocks base method
func (m *MockhostQueue) Host() topology.Host {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Host")
	ret0, _ := ret[0].(topology.Host)
	return ret0
}

// Host indicates an expected call of Host
func (mr *MockhostQueueMockRecorder) Host() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Host", reflect.TypeOf((*MockhostQueue)(nil).Host))
}

// ConnectionCount mocks base method
func (m *MockhostQueue) ConnectionCount() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ConnectionCount")
	ret0, _ := ret[0].(int)
	return ret0
}

// ConnectionCount indicates an expected call of ConnectionCount
func (mr *MockhostQueueMockRecorder) ConnectionCount() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ConnectionCount", reflect.TypeOf((*MockhostQueue)(nil).ConnectionCount))
}

// ConnectionPool mocks base method
func (m *MockhostQueue) ConnectionPool() connectionPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ConnectionPool")
	ret0, _ := ret[0].(connectionPool)
	return ret0
}

// ConnectionPool indicates an expected call of ConnectionPool
func (mr *MockhostQueueMockRecorder) ConnectionPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ConnectionPool", reflect.TypeOf((*MockhostQueue)(nil).ConnectionPool))
}

// BorrowConnection mocks base method
func (m *MockhostQueue) BorrowConnection(fn withConnectionFn) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BorrowConnection", fn)
	ret0, _ := ret[0].(error)
	return ret0
}

// BorrowConnection indicates an expected call of BorrowConnection
func (mr *MockhostQueueMockRecorder) BorrowConnection(fn interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BorrowConnection", reflect.TypeOf((*MockhostQueue)(nil).BorrowConnection), fn)
}

// Close mocks base method
func (m *MockhostQueue) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close
func (mr *MockhostQueueMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockhostQueue)(nil).Close))
}

// MockconnectionPool is a mock of connectionPool interface
type MockconnectionPool struct {
	ctrl     *gomock.Controller
	recorder *MockconnectionPoolMockRecorder
}

// MockconnectionPoolMockRecorder is the mock recorder for MockconnectionPool
type MockconnectionPoolMockRecorder struct {
	mock *MockconnectionPool
}

// NewMockconnectionPool creates a new mock instance
func NewMockconnectionPool(ctrl *gomock.Controller) *MockconnectionPool {
	mock := &MockconnectionPool{ctrl: ctrl}
	mock.recorder = &MockconnectionPoolMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockconnectionPool) EXPECT() *MockconnectionPoolMockRecorder {
	return m.recorder
}

// Open mocks base method
func (m *MockconnectionPool) Open() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Open")
}

// Open indicates an expected call of Open
func (mr *MockconnectionPoolMockRecorder) Open() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Open", reflect.TypeOf((*MockconnectionPool)(nil).Open))
}

// ConnectionCount mocks base method
func (m *MockconnectionPool) ConnectionCount() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ConnectionCount")
	ret0, _ := ret[0].(int)
	return ret0
}

// ConnectionCount indicates an expected call of ConnectionCount
func (mr *MockconnectionPoolMockRecorder) ConnectionCount() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ConnectionCount", reflect.TypeOf((*MockconnectionPool)(nil).ConnectionCount))
}

// NextClient mocks base method
func (m *MockconnectionPool) NextClient() (rpc.TChanNode, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NextClient")
	ret0, _ := ret[0].(rpc.TChanNode)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// NextClient indicates an expected call of NextClient
func (mr *MockconnectionPoolMockRecorder) NextClient() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NextClient", reflect.TypeOf((*MockconnectionPool)(nil).NextClient))
}

// Close mocks base method
func (m *MockconnectionPool) Close() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Close")
}

// Close indicates an expected call of Close
func (mr *MockconnectionPoolMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockconnectionPool)(nil).Close))
}

// MockpeerSource is a mock of peerSource interface
type MockpeerSource struct {
	ctrl     *gomock.Controller
	recorder *MockpeerSourceMockRecorder
}

// MockpeerSourceMockRecorder is the mock recorder for MockpeerSource
type MockpeerSourceMockRecorder struct {
	mock *MockpeerSource
}

// NewMockpeerSource creates a new mock instance
func NewMockpeerSource(ctrl *gomock.Controller) *MockpeerSource {
	mock := &MockpeerSource{ctrl: ctrl}
	mock.recorder = &MockpeerSourceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockpeerSource) EXPECT() *MockpeerSourceMockRecorder {
	return m.recorder
}

// BorrowConnection mocks base method
func (m *MockpeerSource) BorrowConnection(hostID string, fn withConnectionFn) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BorrowConnection", hostID, fn)
	ret0, _ := ret[0].(error)
	return ret0
}

// BorrowConnection indicates an expected call of BorrowConnection
func (mr *MockpeerSourceMockRecorder) BorrowConnection(hostID, fn interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BorrowConnection", reflect.TypeOf((*MockpeerSource)(nil).BorrowConnection), hostID, fn)
}

// Mockpeer is a mock of peer interface
type Mockpeer struct {
	ctrl     *gomock.Controller
	recorder *MockpeerMockRecorder
}

// MockpeerMockRecorder is the mock recorder for Mockpeer
type MockpeerMockRecorder struct {
	mock *Mockpeer
}

// NewMockpeer creates a new mock instance
func NewMockpeer(ctrl *gomock.Controller) *Mockpeer {
	mock := &Mockpeer{ctrl: ctrl}
	mock.recorder = &MockpeerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *Mockpeer) EXPECT() *MockpeerMockRecorder {
	return m.recorder
}

// Host mocks base method
func (m *Mockpeer) Host() topology.Host {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Host")
	ret0, _ := ret[0].(topology.Host)
	return ret0
}

// Host indicates an expected call of Host
func (mr *MockpeerMockRecorder) Host() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Host", reflect.TypeOf((*Mockpeer)(nil).Host))
}

// BorrowConnection mocks base method
func (m *Mockpeer) BorrowConnection(fn withConnectionFn) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BorrowConnection", fn)
	ret0, _ := ret[0].(error)
	return ret0
}

// BorrowConnection indicates an expected call of BorrowConnection
func (mr *MockpeerMockRecorder) BorrowConnection(fn interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BorrowConnection", reflect.TypeOf((*Mockpeer)(nil).BorrowConnection), fn)
}

// Mockop is a mock of op interface
type Mockop struct {
	ctrl     *gomock.Controller
	recorder *MockopMockRecorder
}

// MockopMockRecorder is the mock recorder for Mockop
type MockopMockRecorder struct {
	mock *Mockop
}

// NewMockop creates a new mock instance
func NewMockop(ctrl *gomock.Controller) *Mockop {
	mock := &Mockop{ctrl: ctrl}
	mock.recorder = &MockopMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *Mockop) EXPECT() *MockopMockRecorder {
	return m.recorder
}

// Size mocks base method
func (m *Mockop) Size() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Size")
	ret0, _ := ret[0].(int)
	return ret0
}

// Size indicates an expected call of Size
func (mr *MockopMockRecorder) Size() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Size", reflect.TypeOf((*Mockop)(nil).Size))
}

// CompletionFn mocks base method
func (m *Mockop) CompletionFn() completionFn {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CompletionFn")
	ret0, _ := ret[0].(completionFn)
	return ret0
}

// CompletionFn indicates an expected call of CompletionFn
func (mr *MockopMockRecorder) CompletionFn() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CompletionFn", reflect.TypeOf((*Mockop)(nil).CompletionFn))
}

// MockenqueueChannel is a mock of enqueueChannel interface
type MockenqueueChannel struct {
	ctrl     *gomock.Controller
	recorder *MockenqueueChannelMockRecorder
}

// MockenqueueChannelMockRecorder is the mock recorder for MockenqueueChannel
type MockenqueueChannelMockRecorder struct {
	mock *MockenqueueChannel
}

// NewMockenqueueChannel creates a new mock instance
func NewMockenqueueChannel(ctrl *gomock.Controller) *MockenqueueChannel {
	mock := &MockenqueueChannel{ctrl: ctrl}
	mock.recorder = &MockenqueueChannelMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockenqueueChannel) EXPECT() *MockenqueueChannelMockRecorder {
	return m.recorder
}

// enqueue mocks base method
func (m *MockenqueueChannel) enqueue(peersMetadata []receivedBlockMetadata) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "enqueue", peersMetadata)
	ret0, _ := ret[0].(error)
	return ret0
}

// enqueue indicates an expected call of enqueue
func (mr *MockenqueueChannelMockRecorder) enqueue(peersMetadata interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "enqueue", reflect.TypeOf((*MockenqueueChannel)(nil).enqueue), peersMetadata)
}

// enqueueDelayed mocks base method
func (m *MockenqueueChannel) enqueueDelayed(numToEnqueue int) (enqueueDelayedFn, enqueueDelayedDoneFn, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "enqueueDelayed", numToEnqueue)
	ret0, _ := ret[0].(enqueueDelayedFn)
	ret1, _ := ret[1].(enqueueDelayedDoneFn)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// enqueueDelayed indicates an expected call of enqueueDelayed
func (mr *MockenqueueChannelMockRecorder) enqueueDelayed(numToEnqueue interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "enqueueDelayed", reflect.TypeOf((*MockenqueueChannel)(nil).enqueueDelayed), numToEnqueue)
}

// read mocks base method
func (m *MockenqueueChannel) read() <-chan []receivedBlockMetadata {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "read")
	ret0, _ := ret[0].(<-chan []receivedBlockMetadata)
	return ret0
}

// read indicates an expected call of read
func (mr *MockenqueueChannelMockRecorder) read() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "read", reflect.TypeOf((*MockenqueueChannel)(nil).read))
}

// trackPending mocks base method
func (m *MockenqueueChannel) trackPending(amount int) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "trackPending", amount)
}

// trackPending indicates an expected call of trackPending
func (mr *MockenqueueChannelMockRecorder) trackPending(amount interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "trackPending", reflect.TypeOf((*MockenqueueChannel)(nil).trackPending), amount)
}

// trackProcessed mocks base method
func (m *MockenqueueChannel) trackProcessed(amount int) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "trackProcessed", amount)
}

// trackProcessed indicates an expected call of trackProcessed
func (mr *MockenqueueChannelMockRecorder) trackProcessed(amount interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "trackProcessed", reflect.TypeOf((*MockenqueueChannel)(nil).trackProcessed), amount)
}

// unprocessedLen mocks base method
func (m *MockenqueueChannel) unprocessedLen() int {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "unprocessedLen")
	ret0, _ := ret[0].(int)
	return ret0
}

// unprocessedLen indicates an expected call of unprocessedLen
func (mr *MockenqueueChannelMockRecorder) unprocessedLen() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "unprocessedLen", reflect.TypeOf((*MockenqueueChannel)(nil).unprocessedLen))
}

// closeOnAllProcessed mocks base method
func (m *MockenqueueChannel) closeOnAllProcessed() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "closeOnAllProcessed")
}

// closeOnAllProcessed indicates an expected call of closeOnAllProcessed
func (mr *MockenqueueChannelMockRecorder) closeOnAllProcessed() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "closeOnAllProcessed", reflect.TypeOf((*MockenqueueChannel)(nil).closeOnAllProcessed))
}
