// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/m3db/m3/src/dbnode/generated/proto/index/index.proto

// Copyright (c) 2018 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/*
	Package index is a generated protocol buffer package.

	It is generated from these files:
		github.com/m3db/m3/src/dbnode/generated/proto/index/index.proto

	It has these top-level messages:
		IndexInfo
		SegmentInfo
		SegmentFileInfo
		IndexDigests
		SegmentDigest
		SegmentFileDigest
*/
package index

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type IndexInfo struct {
	MajorVersion int64          `protobuf:"varint,1,opt,name=majorVersion,proto3" json:"majorVersion,omitempty"`
	BlockStart   int64          `protobuf:"varint,2,opt,name=blockStart,proto3" json:"blockStart,omitempty"`
	BlockSize    int64          `protobuf:"varint,3,opt,name=blockSize,proto3" json:"blockSize,omitempty"`
	FileType     int64          `protobuf:"varint,4,opt,name=fileType,proto3" json:"fileType,omitempty"`
	Shards       []uint32       `protobuf:"varint,5,rep,packed,name=shards" json:"shards,omitempty"`
	SnapshotTime int64          `protobuf:"varint,6,opt,name=snapshotTime,proto3" json:"snapshotTime,omitempty"`
	Segments     []*SegmentInfo `protobuf:"bytes,7,rep,name=segments" json:"segments,omitempty"`
}

func (m *IndexInfo) Reset()                    { *m = IndexInfo{} }
func (m *IndexInfo) String() string            { return proto.CompactTextString(m) }
func (*IndexInfo) ProtoMessage()               {}
func (*IndexInfo) Descriptor() ([]byte, []int) { return fileDescriptorIndex, []int{0} }

func (m *IndexInfo) GetMajorVersion() int64 {
	if m != nil {
		return m.MajorVersion
	}
	return 0
}

func (m *IndexInfo) GetBlockStart() int64 {
	if m != nil {
		return m.BlockStart
	}
	return 0
}

func (m *IndexInfo) GetBlockSize() int64 {
	if m != nil {
		return m.BlockSize
	}
	return 0
}

func (m *IndexInfo) GetFileType() int64 {
	if m != nil {
		return m.FileType
	}
	return 0
}

func (m *IndexInfo) GetShards() []uint32 {
	if m != nil {
		return m.Shards
	}
	return nil
}

func (m *IndexInfo) GetSnapshotTime() int64 {
	if m != nil {
		return m.SnapshotTime
	}
	return 0
}

func (m *IndexInfo) GetSegments() []*SegmentInfo {
	if m != nil {
		return m.Segments
	}
	return nil
}

type SegmentInfo struct {
	SegmentType  string             `protobuf:"bytes,1,opt,name=segmentType,proto3" json:"segmentType,omitempty"`
	MajorVersion int64              `protobuf:"varint,2,opt,name=majorVersion,proto3" json:"majorVersion,omitempty"`
	MinorVersion int64              `protobuf:"varint,3,opt,name=minorVersion,proto3" json:"minorVersion,omitempty"`
	Metadata     []byte             `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Files        []*SegmentFileInfo `protobuf:"bytes,5,rep,name=files" json:"files,omitempty"`
}

func (m *SegmentInfo) Reset()                    { *m = SegmentInfo{} }
func (m *SegmentInfo) String() string            { return proto.CompactTextString(m) }
func (*SegmentInfo) ProtoMessage()               {}
func (*SegmentInfo) Descriptor() ([]byte, []int) { return fileDescriptorIndex, []int{1} }

func (m *SegmentInfo) GetSegmentType() string {
	if m != nil {
		return m.SegmentType
	}
	return ""
}

func (m *SegmentInfo) GetMajorVersion() int64 {
	if m != nil {
		return m.MajorVersion
	}
	return 0
}

func (m *SegmentInfo) GetMinorVersion() int64 {
	if m != nil {
		return m.MinorVersion
	}
	return 0
}

func (m *SegmentInfo) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *SegmentInfo) GetFiles() []*SegmentFileInfo {
	if m != nil {
		return m.Files
	}
	return nil
}

type SegmentFileInfo struct {
	SegmentFileType string `protobuf:"bytes,1,opt,name=segmentFileType,proto3" json:"segmentFileType,omitempty"`
}

func (m *SegmentFileInfo) Reset()                    { *m = SegmentFileInfo{} }
func (m *SegmentFileInfo) String() string            { return proto.CompactTextString(m) }
func (*SegmentFileInfo) ProtoMessage()               {}
func (*SegmentFileInfo) Descriptor() ([]byte, []int) { return fileDescriptorIndex, []int{2} }

func (m *SegmentFileInfo) GetSegmentFileType() string {
	if m != nil {
		return m.SegmentFileType
	}
	return ""
}

type IndexDigests struct {
	InfoDigest     uint32           `protobuf:"varint,1,opt,name=infoDigest,proto3" json:"infoDigest,omitempty"`
	SegmentDigests []*SegmentDigest `protobuf:"bytes,2,rep,name=segmentDigests" json:"segmentDigests,omitempty"`
}

func (m *IndexDigests) Reset()                    { *m = IndexDigests{} }
func (m *IndexDigests) String() string            { return proto.CompactTextString(m) }
func (*IndexDigests) ProtoMessage()               {}
func (*IndexDigests) Descriptor() ([]byte, []int) { return fileDescriptorIndex, []int{3} }

func (m *IndexDigests) GetInfoDigest() uint32 {
	if m != nil {
		return m.InfoDigest
	}
	return 0
}

func (m *IndexDigests) GetSegmentDigests() []*SegmentDigest {
	if m != nil {
		return m.SegmentDigests
	}
	return nil
}

type SegmentDigest struct {
	SegmentType string               `protobuf:"bytes,1,opt,name=segmentType,proto3" json:"segmentType,omitempty"`
	Files       []*SegmentFileDigest `protobuf:"bytes,2,rep,name=files" json:"files,omitempty"`
}

func (m *SegmentDigest) Reset()                    { *m = SegmentDigest{} }
func (m *SegmentDigest) String() string            { return proto.CompactTextString(m) }
func (*SegmentDigest) ProtoMessage()               {}
func (*SegmentDigest) Descriptor() ([]byte, []int) { return fileDescriptorIndex, []int{4} }

func (m *SegmentDigest) GetSegmentType() string {
	if m != nil {
		return m.SegmentType
	}
	return ""
}

func (m *SegmentDigest) GetFiles() []*SegmentFileDigest {
	if m != nil {
		return m.Files
	}
	return nil
}

type SegmentFileDigest struct {
	SegmentFileType string `protobuf:"bytes,1,opt,name=segmentFileType,proto3" json:"segmentFileType,omitempty"`
	Digest          uint32 `protobuf:"varint,2,opt,name=digest,proto3" json:"digest,omitempty"`
}

func (m *SegmentFileDigest) Reset()                    { *m = SegmentFileDigest{} }
func (m *SegmentFileDigest) String() string            { return proto.CompactTextString(m) }
func (*SegmentFileDigest) ProtoMessage()               {}
func (*SegmentFileDigest) Descriptor() ([]byte, []int) { return fileDescriptorIndex, []int{5} }

func (m *SegmentFileDigest) GetSegmentFileType() string {
	if m != nil {
		return m.SegmentFileType
	}
	return ""
}

func (m *SegmentFileDigest) GetDigest() uint32 {
	if m != nil {
		return m.Digest
	}
	return 0
}

func init() {
	proto.RegisterType((*IndexInfo)(nil), "index.IndexInfo")
	proto.RegisterType((*SegmentInfo)(nil), "index.SegmentInfo")
	proto.RegisterType((*SegmentFileInfo)(nil), "index.SegmentFileInfo")
	proto.RegisterType((*IndexDigests)(nil), "index.IndexDigests")
	proto.RegisterType((*SegmentDigest)(nil), "index.SegmentDigest")
	proto.RegisterType((*SegmentFileDigest)(nil), "index.SegmentFileDigest")
}
func (m *IndexInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IndexInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MajorVersion != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintIndex(dAtA, i, uint64(m.MajorVersion))
	}
	if m.BlockStart != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintIndex(dAtA, i, uint64(m.BlockStart))
	}
	if m.BlockSize != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintIndex(dAtA, i, uint64(m.BlockSize))
	}
	if m.FileType != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintIndex(dAtA, i, uint64(m.FileType))
	}
	if len(m.Shards) > 0 {
		dAtA2 := make([]byte, len(m.Shards)*10)
		var j1 int
		for _, num := range m.Shards {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		dAtA[i] = 0x2a
		i++
		i = encodeVarintIndex(dAtA, i, uint64(j1))
		i += copy(dAtA[i:], dAtA2[:j1])
	}
	if m.SnapshotTime != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintIndex(dAtA, i, uint64(m.SnapshotTime))
	}
	if len(m.Segments) > 0 {
		for _, msg := range m.Segments {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintIndex(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *SegmentInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SegmentInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SegmentType) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIndex(dAtA, i, uint64(len(m.SegmentType)))
		i += copy(dAtA[i:], m.SegmentType)
	}
	if m.MajorVersion != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintIndex(dAtA, i, uint64(m.MajorVersion))
	}
	if m.MinorVersion != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintIndex(dAtA, i, uint64(m.MinorVersion))
	}
	if len(m.Metadata) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintIndex(dAtA, i, uint64(len(m.Metadata)))
		i += copy(dAtA[i:], m.Metadata)
	}
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintIndex(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *SegmentFileInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SegmentFileInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SegmentFileType) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIndex(dAtA, i, uint64(len(m.SegmentFileType)))
		i += copy(dAtA[i:], m.SegmentFileType)
	}
	return i, nil
}

func (m *IndexDigests) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IndexDigests) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.InfoDigest != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintIndex(dAtA, i, uint64(m.InfoDigest))
	}
	if len(m.SegmentDigests) > 0 {
		for _, msg := range m.SegmentDigests {
			dAtA[i] = 0x12
			i++
			i = encodeVarintIndex(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *SegmentDigest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SegmentDigest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SegmentType) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIndex(dAtA, i, uint64(len(m.SegmentType)))
		i += copy(dAtA[i:], m.SegmentType)
	}
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x12
			i++
			i = encodeVarintIndex(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *SegmentFileDigest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SegmentFileDigest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SegmentFileType) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIndex(dAtA, i, uint64(len(m.SegmentFileType)))
		i += copy(dAtA[i:], m.SegmentFileType)
	}
	if m.Digest != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintIndex(dAtA, i, uint64(m.Digest))
	}
	return i, nil
}

func encodeVarintIndex(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *IndexInfo) Size() (n int) {
	var l int
	_ = l
	if m.MajorVersion != 0 {
		n += 1 + sovIndex(uint64(m.MajorVersion))
	}
	if m.BlockStart != 0 {
		n += 1 + sovIndex(uint64(m.BlockStart))
	}
	if m.BlockSize != 0 {
		n += 1 + sovIndex(uint64(m.BlockSize))
	}
	if m.FileType != 0 {
		n += 1 + sovIndex(uint64(m.FileType))
	}
	if len(m.Shards) > 0 {
		l = 0
		for _, e := range m.Shards {
			l += sovIndex(uint64(e))
		}
		n += 1 + sovIndex(uint64(l)) + l
	}
	if m.SnapshotTime != 0 {
		n += 1 + sovIndex(uint64(m.SnapshotTime))
	}
	if len(m.Segments) > 0 {
		for _, e := range m.Segments {
			l = e.Size()
			n += 1 + l + sovIndex(uint64(l))
		}
	}
	return n
}

func (m *SegmentInfo) Size() (n int) {
	var l int
	_ = l
	l = len(m.SegmentType)
	if l > 0 {
		n += 1 + l + sovIndex(uint64(l))
	}
	if m.MajorVersion != 0 {
		n += 1 + sovIndex(uint64(m.MajorVersion))
	}
	if m.MinorVersion != 0 {
		n += 1 + sovIndex(uint64(m.MinorVersion))
	}
	l = len(m.Metadata)
	if l > 0 {
		n += 1 + l + sovIndex(uint64(l))
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovIndex(uint64(l))
		}
	}
	return n
}

func (m *SegmentFileInfo) Size() (n int) {
	var l int
	_ = l
	l = len(m.SegmentFileType)
	if l > 0 {
		n += 1 + l + sovIndex(uint64(l))
	}
	return n
}

func (m *IndexDigests) Size() (n int) {
	var l int
	_ = l
	if m.InfoDigest != 0 {
		n += 1 + sovIndex(uint64(m.InfoDigest))
	}
	if len(m.SegmentDigests) > 0 {
		for _, e := range m.SegmentDigests {
			l = e.Size()
			n += 1 + l + sovIndex(uint64(l))
		}
	}
	return n
}

func (m *SegmentDigest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SegmentType)
	if l > 0 {
		n += 1 + l + sovIndex(uint64(l))
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovIndex(uint64(l))
		}
	}
	return n
}

func (m *SegmentFileDigest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SegmentFileType)
	if l > 0 {
		n += 1 + l + sovIndex(uint64(l))
	}
	if m.Digest != 0 {
		n += 1 + sovIndex(uint64(m.Digest))
	}
	return n
}

func sovIndex(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozIndex(x uint64) (n int) {
	return sovIndex(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *IndexInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIndex
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IndexInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IndexInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MajorVersion", wireType)
			}
			m.MajorVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MajorVersion |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockStart", wireType)
			}
			m.BlockStart = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BlockStart |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockSize", wireType)
			}
			m.BlockSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BlockSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileType", wireType)
			}
			m.FileType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FileType |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowIndex
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Shards = append(m.Shards, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowIndex
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthIndex
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowIndex
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Shards = append(m.Shards, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Shards", wireType)
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SnapshotTime", wireType)
			}
			m.SnapshotTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SnapshotTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Segments", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIndex
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Segments = append(m.Segments, &SegmentInfo{})
			if err := m.Segments[len(m.Segments)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIndex(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIndex
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SegmentInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIndex
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SegmentInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SegmentInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SegmentType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIndex
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SegmentType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MajorVersion", wireType)
			}
			m.MajorVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MajorVersion |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinorVersion", wireType)
			}
			m.MinorVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinorVersion |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthIndex
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metadata = append(m.Metadata[:0], dAtA[iNdEx:postIndex]...)
			if m.Metadata == nil {
				m.Metadata = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIndex
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, &SegmentFileInfo{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIndex(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIndex
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SegmentFileInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIndex
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SegmentFileInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SegmentFileInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SegmentFileType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIndex
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SegmentFileType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIndex(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIndex
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IndexDigests) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIndex
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IndexDigests: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IndexDigests: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InfoDigest", wireType)
			}
			m.InfoDigest = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InfoDigest |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SegmentDigests", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIndex
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SegmentDigests = append(m.SegmentDigests, &SegmentDigest{})
			if err := m.SegmentDigests[len(m.SegmentDigests)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIndex(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIndex
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SegmentDigest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIndex
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SegmentDigest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SegmentDigest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SegmentType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIndex
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SegmentType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIndex
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, &SegmentFileDigest{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIndex(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIndex
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SegmentFileDigest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIndex
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SegmentFileDigest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SegmentFileDigest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SegmentFileType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIndex
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SegmentFileType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Digest", wireType)
			}
			m.Digest = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Digest |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipIndex(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIndex
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipIndex(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowIndex
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIndex
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthIndex
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowIndex
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipIndex(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthIndex = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowIndex   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("github.com/m3db/m3/src/dbnode/generated/proto/index/index.proto", fileDescriptorIndex)
}

var fileDescriptorIndex = []byte{
	// 427 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x53, 0x4d, 0x8e, 0xd3, 0x30,
	0x18, 0x25, 0x09, 0x2d, 0xd3, 0x2f, 0x2d, 0x03, 0x16, 0x1a, 0x59, 0x08, 0x45, 0x51, 0x56, 0x59,
	0xa0, 0x44, 0x9a, 0x2e, 0x41, 0x42, 0x42, 0x08, 0x69, 0xb6, 0x99, 0x81, 0xbd, 0x53, 0xbb, 0xa9,
	0x21, 0xb1, 0xab, 0xd8, 0x48, 0xc0, 0x29, 0xb8, 0x12, 0x3b, 0x96, 0x1c, 0x01, 0x95, 0x33, 0xb0,
	0x47, 0xfe, 0xa1, 0x4d, 0x5a, 0x16, 0xdd, 0x44, 0x79, 0x3f, 0x8e, 0xbf, 0xf7, 0x1c, 0xc3, 0xab,
	0x86, 0xeb, 0xcd, 0xa7, 0xba, 0x58, 0xc9, 0xae, 0xec, 0x96, 0xb4, 0x2e, 0xbb, 0x65, 0xa9, 0xfa,
	0x55, 0x49, 0x6b, 0x21, 0x29, 0x2b, 0x1b, 0x26, 0x58, 0x4f, 0x34, 0xa3, 0xe5, 0xb6, 0x97, 0x5a,
	0x96, 0x5c, 0x50, 0xf6, 0xd9, 0x3d, 0x0b, 0xcb, 0xa0, 0x89, 0x05, 0xd9, 0x9f, 0x00, 0x66, 0x37,
	0xe6, 0xed, 0x46, 0xac, 0x25, 0xca, 0x60, 0xde, 0x91, 0x0f, 0xb2, 0x7f, 0xcf, 0x7a, 0xc5, 0xa5,
	0xc0, 0x41, 0x1a, 0xe4, 0x51, 0x35, 0xe2, 0x50, 0x02, 0x50, 0xb7, 0x72, 0xf5, 0xf1, 0x56, 0x93,
	0x5e, 0xe3, 0xd0, 0x3a, 0x06, 0x0c, 0x7a, 0x06, 0x33, 0x87, 0xf8, 0x57, 0x86, 0x23, 0x2b, 0x1f,
	0x08, 0xf4, 0x14, 0x2e, 0xd6, 0xbc, 0x65, 0x77, 0x5f, 0xb6, 0x0c, 0xdf, 0xb7, 0xe2, 0x1e, 0xa3,
	0x2b, 0x98, 0xaa, 0x0d, 0xe9, 0xa9, 0xc2, 0x93, 0x34, 0xca, 0x17, 0x95, 0x47, 0x66, 0x2a, 0x25,
	0xc8, 0x56, 0x6d, 0xa4, 0xbe, 0xe3, 0x1d, 0xc3, 0x53, 0x37, 0xd5, 0x90, 0x43, 0x05, 0x5c, 0x28,
	0xd6, 0x74, 0x4c, 0x68, 0x85, 0x1f, 0xa4, 0x51, 0x1e, 0x5f, 0xa3, 0xc2, 0xc5, 0xbd, 0x75, 0xb4,
	0xc9, 0x57, 0xed, 0x3d, 0xd9, 0xf7, 0x00, 0xe2, 0x81, 0x82, 0x52, 0x88, 0xbd, 0x66, 0x47, 0x33,
	0xc1, 0x67, 0xd5, 0x90, 0x3a, 0xe9, 0x26, 0xfc, 0x4f, 0x37, 0xc6, 0xc3, 0xc5, 0xc1, 0x13, 0x79,
	0xcf, 0x80, 0x33, 0x0d, 0x74, 0x4c, 0x13, 0x4a, 0x34, 0xb1, 0x0d, 0xcc, 0xab, 0x3d, 0x46, 0xcf,
	0x61, 0x62, 0xda, 0x70, 0x05, 0xc4, 0xd7, 0x57, 0xe3, 0x08, 0x6f, 0x79, 0xcb, 0x6c, 0x0c, 0x67,
	0xca, 0x5e, 0xc0, 0xe5, 0x91, 0x82, 0x72, 0xb8, 0x54, 0x07, 0x6a, 0x10, 0xe5, 0x98, 0xce, 0x5a,
	0x98, 0xdb, 0x73, 0x7f, 0xc3, 0x1b, 0xa6, 0xb4, 0x32, 0xc7, 0xca, 0xc5, 0x5a, 0x3a, 0x68, 0x17,
	0x2d, 0xaa, 0x01, 0x83, 0x5e, 0xc2, 0x43, 0xff, 0x09, 0xbf, 0x02, 0x87, 0x76, 0xc6, 0x27, 0xe3,
	0x19, 0x9d, 0x58, 0x1d, 0x79, 0x33, 0x02, 0x8b, 0x91, 0xe1, 0x8c, 0xbe, 0x8b, 0x7f, 0x5d, 0xb8,
	0x7d, 0xf0, 0x69, 0x17, 0x7e, 0x2f, 0xdf, 0xc6, 0x3b, 0x78, 0x7c, 0xa2, 0x9d, 0xdf, 0x87, 0xf9,
	0xf9, 0xa8, 0xcb, 0x1e, 0xda, 0xec, 0x1e, 0xbd, 0x7e, 0xf4, 0x63, 0x97, 0x04, 0x3f, 0x77, 0x49,
	0xf0, 0x6b, 0x97, 0x04, 0xdf, 0x7e, 0x27, 0xf7, 0xea, 0xa9, 0xbd, 0x40, 0xcb, 0xbf, 0x01, 0x00,
	0x00, 0xff, 0xff, 0xb1, 0x2e, 0xe5, 0xaa, 0x83, 0x03, 0x00, 0x00,
}
