// Copyright (c) 2019 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Autogenerated by Thrift Compiler (0.10.0)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING

package rpc

import (
	"bytes"
	"database/sql/driver"
	"errors"
	"fmt"
	"github.com/apache/thrift/lib/go/thrift"
)

// (needed to ensure safety because of naive import list construction.)
var _ = thrift.ZERO
var _ = fmt.Printf
var _ = bytes.Equal

type TimeType int64

const (
	TimeType_UNIX_SECONDS      TimeType = 0
	TimeType_UNIX_MICROSECONDS TimeType = 1
	TimeType_UNIX_MILLISECONDS TimeType = 2
	TimeType_UNIX_NANOSECONDS  TimeType = 3
)

func (p TimeType) String() string {
	switch p {
	case TimeType_UNIX_SECONDS:
		return "UNIX_SECONDS"
	case TimeType_UNIX_MICROSECONDS:
		return "UNIX_MICROSECONDS"
	case TimeType_UNIX_MILLISECONDS:
		return "UNIX_MILLISECONDS"
	case TimeType_UNIX_NANOSECONDS:
		return "UNIX_NANOSECONDS"
	}
	return "<UNSET>"
}

func TimeTypeFromString(s string) (TimeType, error) {
	switch s {
	case "UNIX_SECONDS":
		return TimeType_UNIX_SECONDS, nil
	case "UNIX_MICROSECONDS":
		return TimeType_UNIX_MICROSECONDS, nil
	case "UNIX_MILLISECONDS":
		return TimeType_UNIX_MILLISECONDS, nil
	case "UNIX_NANOSECONDS":
		return TimeType_UNIX_NANOSECONDS, nil
	}
	return TimeType(0), fmt.Errorf("not a valid TimeType string")
}

func TimeTypePtr(v TimeType) *TimeType { return &v }

func (p TimeType) MarshalText() ([]byte, error) {
	return []byte(p.String()), nil
}

func (p *TimeType) UnmarshalText(text []byte) error {
	q, err := TimeTypeFromString(string(text))
	if err != nil {
		return err
	}
	*p = q
	return nil
}

func (p *TimeType) Scan(value interface{}) error {
	v, ok := value.(int64)
	if !ok {
		return errors.New("Scan value is not int64")
	}
	*p = TimeType(v)
	return nil
}

func (p *TimeType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ErrorType int64

const (
	ErrorType_INTERNAL_ERROR ErrorType = 0
	ErrorType_BAD_REQUEST    ErrorType = 1
)

func (p ErrorType) String() string {
	switch p {
	case ErrorType_INTERNAL_ERROR:
		return "INTERNAL_ERROR"
	case ErrorType_BAD_REQUEST:
		return "BAD_REQUEST"
	}
	return "<UNSET>"
}

func ErrorTypeFromString(s string) (ErrorType, error) {
	switch s {
	case "INTERNAL_ERROR":
		return ErrorType_INTERNAL_ERROR, nil
	case "BAD_REQUEST":
		return ErrorType_BAD_REQUEST, nil
	}
	return ErrorType(0), fmt.Errorf("not a valid ErrorType string")
}

func ErrorTypePtr(v ErrorType) *ErrorType { return &v }

func (p ErrorType) MarshalText() ([]byte, error) {
	return []byte(p.String()), nil
}

func (p *ErrorType) UnmarshalText(text []byte) error {
	q, err := ErrorTypeFromString(string(text))
	if err != nil {
		return err
	}
	*p = q
	return nil
}

func (p *ErrorType) Scan(value interface{}) error {
	v, ok := value.(int64)
	if !ok {
		return errors.New("Scan value is not int64")
	}
	*p = ErrorType(v)
	return nil
}

func (p *ErrorType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type AggregateQueryType int64

const (
	AggregateQueryType_AGGREGATE_BY_TAG_NAME       AggregateQueryType = 0
	AggregateQueryType_AGGREGATE_BY_TAG_NAME_VALUE AggregateQueryType = 1
)

func (p AggregateQueryType) String() string {
	switch p {
	case AggregateQueryType_AGGREGATE_BY_TAG_NAME:
		return "AGGREGATE_BY_TAG_NAME"
	case AggregateQueryType_AGGREGATE_BY_TAG_NAME_VALUE:
		return "AGGREGATE_BY_TAG_NAME_VALUE"
	}
	return "<UNSET>"
}

func AggregateQueryTypeFromString(s string) (AggregateQueryType, error) {
	switch s {
	case "AGGREGATE_BY_TAG_NAME":
		return AggregateQueryType_AGGREGATE_BY_TAG_NAME, nil
	case "AGGREGATE_BY_TAG_NAME_VALUE":
		return AggregateQueryType_AGGREGATE_BY_TAG_NAME_VALUE, nil
	}
	return AggregateQueryType(0), fmt.Errorf("not a valid AggregateQueryType string")
}

func AggregateQueryTypePtr(v AggregateQueryType) *AggregateQueryType { return &v }

func (p AggregateQueryType) MarshalText() ([]byte, error) {
	return []byte(p.String()), nil
}

func (p *AggregateQueryType) UnmarshalText(text []byte) error {
	q, err := AggregateQueryTypeFromString(string(text))
	if err != nil {
		return err
	}
	*p = q
	return nil
}

func (p *AggregateQueryType) Scan(value interface{}) error {
	v, ok := value.(int64)
	if !ok {
		return errors.New("Scan value is not int64")
	}
	*p = AggregateQueryType(v)
	return nil
}

func (p *AggregateQueryType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// Attributes:
//  - Type
//  - Message
type Error struct {
	Type    ErrorType `thrift:"type,1,required" db:"type" json:"type"`
	Message string    `thrift:"message,2,required" db:"message" json:"message"`
}

func NewError() *Error {
	return &Error{
		Type: 0,
	}
}

func (p *Error) GetType() ErrorType {
	return p.Type
}

func (p *Error) GetMessage() string {
	return p.Message
}
func (p *Error) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetType bool = false
	var issetMessage bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetType = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetMessage = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetType {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Type is not set"))
	}
	if !issetMessage {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Message is not set"))
	}
	return nil
}

func (p *Error) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		temp := ErrorType(v)
		p.Type = temp
	}
	return nil
}

func (p *Error) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Message = v
	}
	return nil
}

func (p *Error) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("Error"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *Error) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("type", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:type: ", p), err)
	}
	if err := oprot.WriteI32(int32(p.Type)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.type (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:type: ", p), err)
	}
	return err
}

func (p *Error) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("message", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:message: ", p), err)
	}
	if err := oprot.WriteString(string(p.Message)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.message (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:message: ", p), err)
	}
	return err
}

func (p *Error) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Error(%+v)", *p)
}

func (p *Error) Error() string {
	return p.String()
}

// Attributes:
//  - Errors
type WriteBatchRawErrors struct {
	Errors []*WriteBatchRawError `thrift:"errors,1,required" db:"errors" json:"errors"`
}

func NewWriteBatchRawErrors() *WriteBatchRawErrors {
	return &WriteBatchRawErrors{}
}

func (p *WriteBatchRawErrors) GetErrors() []*WriteBatchRawError {
	return p.Errors
}
func (p *WriteBatchRawErrors) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetErrors bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetErrors = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetErrors {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Errors is not set"))
	}
	return nil
}

func (p *WriteBatchRawErrors) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*WriteBatchRawError, 0, size)
	p.Errors = tSlice
	for i := 0; i < size; i++ {
		_elem0 := &WriteBatchRawError{}
		if err := _elem0.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem0), err)
		}
		p.Errors = append(p.Errors, _elem0)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *WriteBatchRawErrors) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("WriteBatchRawErrors"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *WriteBatchRawErrors) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("errors", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:errors: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Errors)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Errors {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:errors: ", p), err)
	}
	return err
}

func (p *WriteBatchRawErrors) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WriteBatchRawErrors(%+v)", *p)
}

func (p *WriteBatchRawErrors) Error() string {
	return p.String()
}

// Attributes:
//  - RangeStart
//  - RangeEnd
//  - NameSpace
//  - ID
//  - RangeType
//  - ResultTimeType
type FetchRequest struct {
	RangeStart     int64    `thrift:"rangeStart,1,required" db:"rangeStart" json:"rangeStart"`
	RangeEnd       int64    `thrift:"rangeEnd,2,required" db:"rangeEnd" json:"rangeEnd"`
	NameSpace      string   `thrift:"nameSpace,3,required" db:"nameSpace" json:"nameSpace"`
	ID             string   `thrift:"id,4,required" db:"id" json:"id"`
	RangeType      TimeType `thrift:"rangeType,5" db:"rangeType" json:"rangeType,omitempty"`
	ResultTimeType TimeType `thrift:"resultTimeType,6" db:"resultTimeType" json:"resultTimeType,omitempty"`
}

func NewFetchRequest() *FetchRequest {
	return &FetchRequest{
		RangeType: 0,

		ResultTimeType: 0,
	}
}

func (p *FetchRequest) GetRangeStart() int64 {
	return p.RangeStart
}

func (p *FetchRequest) GetRangeEnd() int64 {
	return p.RangeEnd
}

func (p *FetchRequest) GetNameSpace() string {
	return p.NameSpace
}

func (p *FetchRequest) GetID() string {
	return p.ID
}

var FetchRequest_RangeType_DEFAULT TimeType = 0

func (p *FetchRequest) GetRangeType() TimeType {
	return p.RangeType
}

var FetchRequest_ResultTimeType_DEFAULT TimeType = 0

func (p *FetchRequest) GetResultTimeType() TimeType {
	return p.ResultTimeType
}
func (p *FetchRequest) IsSetRangeType() bool {
	return p.RangeType != FetchRequest_RangeType_DEFAULT
}

func (p *FetchRequest) IsSetResultTimeType() bool {
	return p.ResultTimeType != FetchRequest_ResultTimeType_DEFAULT
}

func (p *FetchRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetRangeStart bool = false
	var issetRangeEnd bool = false
	var issetNameSpace bool = false
	var issetID bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetRangeStart = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetRangeEnd = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
			issetID = true
		case 5:
			if err := p.ReadField5(iprot); err != nil {
				return err
			}
		case 6:
			if err := p.ReadField6(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetRangeStart {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeStart is not set"))
	}
	if !issetRangeEnd {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeEnd is not set"))
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	return nil
}

func (p *FetchRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.RangeStart = v
	}
	return nil
}

func (p *FetchRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.RangeEnd = v
	}
	return nil
}

func (p *FetchRequest) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *FetchRequest) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *FetchRequest) ReadField5(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		temp := TimeType(v)
		p.RangeType = temp
	}
	return nil
}

func (p *FetchRequest) ReadField6(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		temp := TimeType(v)
		p.ResultTimeType = temp
	}
	return nil
}

func (p *FetchRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
		if err := p.writeField5(oprot); err != nil {
			return err
		}
		if err := p.writeField6(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeStart", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:rangeStart: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeStart)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeStart (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:rangeStart: ", p), err)
	}
	return err
}

func (p *FetchRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeEnd", thrift.I64, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:rangeEnd: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeEnd)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeEnd (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:rangeEnd: ", p), err)
	}
	return err
}

func (p *FetchRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:nameSpace: ", p), err)
	}
	if err := oprot.WriteString(string(p.NameSpace)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:nameSpace: ", p), err)
	}
	return err
}

func (p *FetchRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:id: ", p), err)
	}
	if err := oprot.WriteString(string(p.ID)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:id: ", p), err)
	}
	return err
}

func (p *FetchRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetRangeType() {
		if err := oprot.WriteFieldBegin("rangeType", thrift.I32, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:rangeType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.RangeType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.rangeType (5) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:rangeType: ", p), err)
		}
	}
	return err
}

func (p *FetchRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetResultTimeType() {
		if err := oprot.WriteFieldBegin("resultTimeType", thrift.I32, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:resultTimeType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.ResultTimeType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.resultTimeType (6) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:resultTimeType: ", p), err)
		}
	}
	return err
}

func (p *FetchRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchRequest(%+v)", *p)
}

// Attributes:
//  - Datapoints
type FetchResult_ struct {
	Datapoints []*Datapoint `thrift:"datapoints,1,required" db:"datapoints" json:"datapoints"`
}

func NewFetchResult_() *FetchResult_ {
	return &FetchResult_{}
}

func (p *FetchResult_) GetDatapoints() []*Datapoint {
	return p.Datapoints
}
func (p *FetchResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetDatapoints bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetDatapoints = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetDatapoints {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Datapoints is not set"))
	}
	return nil
}

func (p *FetchResult_) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*Datapoint, 0, size)
	p.Datapoints = tSlice
	for i := 0; i < size; i++ {
		_elem1 := &Datapoint{
			TimestampTimeType: 0,
		}
		if err := _elem1.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem1), err)
		}
		p.Datapoints = append(p.Datapoints, _elem1)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FetchResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("datapoints", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:datapoints: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Datapoints)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Datapoints {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:datapoints: ", p), err)
	}
	return err
}

func (p *FetchResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchResult_(%+v)", *p)
}

// Attributes:
//  - Timestamp
//  - Value
//  - Annotation
//  - TimestampTimeType
type Datapoint struct {
	Timestamp         int64    `thrift:"timestamp,1,required" db:"timestamp" json:"timestamp"`
	Value             float64  `thrift:"value,2,required" db:"value" json:"value"`
	Annotation        []byte   `thrift:"annotation,3" db:"annotation" json:"annotation,omitempty"`
	TimestampTimeType TimeType `thrift:"timestampTimeType,4" db:"timestampTimeType" json:"timestampTimeType,omitempty"`
}

func NewDatapoint() *Datapoint {
	return &Datapoint{
		TimestampTimeType: 0,
	}
}

func (p *Datapoint) GetTimestamp() int64 {
	return p.Timestamp
}

func (p *Datapoint) GetValue() float64 {
	return p.Value
}

var Datapoint_Annotation_DEFAULT []byte

func (p *Datapoint) GetAnnotation() []byte {
	return p.Annotation
}

var Datapoint_TimestampTimeType_DEFAULT TimeType = 0

func (p *Datapoint) GetTimestampTimeType() TimeType {
	return p.TimestampTimeType
}
func (p *Datapoint) IsSetAnnotation() bool {
	return p.Annotation != nil
}

func (p *Datapoint) IsSetTimestampTimeType() bool {
	return p.TimestampTimeType != Datapoint_TimestampTimeType_DEFAULT
}

func (p *Datapoint) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetTimestamp bool = false
	var issetValue bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetTimestamp = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetValue = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetTimestamp {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamp is not set"))
	}
	if !issetValue {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Value is not set"))
	}
	return nil
}

func (p *Datapoint) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Timestamp = v
	}
	return nil
}

func (p *Datapoint) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadDouble(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Value = v
	}
	return nil
}

func (p *Datapoint) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.Annotation = v
	}
	return nil
}

func (p *Datapoint) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		temp := TimeType(v)
		p.TimestampTimeType = temp
	}
	return nil
}

func (p *Datapoint) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("Datapoint"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *Datapoint) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("timestamp", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:timestamp: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.Timestamp)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.timestamp (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:timestamp: ", p), err)
	}
	return err
}

func (p *Datapoint) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("value", thrift.DOUBLE, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:value: ", p), err)
	}
	if err := oprot.WriteDouble(float64(p.Value)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.value (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:value: ", p), err)
	}
	return err
}

func (p *Datapoint) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetAnnotation() {
		if err := oprot.WriteFieldBegin("annotation", thrift.STRING, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:annotation: ", p), err)
		}
		if err := oprot.WriteBinary(p.Annotation); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.annotation (3) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:annotation: ", p), err)
		}
	}
	return err
}

func (p *Datapoint) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetTimestampTimeType() {
		if err := oprot.WriteFieldBegin("timestampTimeType", thrift.I32, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:timestampTimeType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.TimestampTimeType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.timestampTimeType (4) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:timestampTimeType: ", p), err)
		}
	}
	return err
}

func (p *Datapoint) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Datapoint(%+v)", *p)
}

// Attributes:
//  - NameSpace
//  - ID
//  - Datapoint
type WriteRequest struct {
	NameSpace string     `thrift:"nameSpace,1,required" db:"nameSpace" json:"nameSpace"`
	ID        string     `thrift:"id,2,required" db:"id" json:"id"`
	Datapoint *Datapoint `thrift:"datapoint,3,required" db:"datapoint" json:"datapoint"`
}

func NewWriteRequest() *WriteRequest {
	return &WriteRequest{}
}

func (p *WriteRequest) GetNameSpace() string {
	return p.NameSpace
}

func (p *WriteRequest) GetID() string {
	return p.ID
}

var WriteRequest_Datapoint_DEFAULT *Datapoint

func (p *WriteRequest) GetDatapoint() *Datapoint {
	if !p.IsSetDatapoint() {
		return WriteRequest_Datapoint_DEFAULT
	}
	return p.Datapoint
}
func (p *WriteRequest) IsSetDatapoint() bool {
	return p.Datapoint != nil
}

func (p *WriteRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNameSpace bool = false
	var issetID bool = false
	var issetDatapoint bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetID = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetDatapoint = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	if !issetDatapoint {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Datapoint is not set"))
	}
	return nil
}

func (p *WriteRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *WriteRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *WriteRequest) ReadField3(iprot thrift.TProtocol) error {
	p.Datapoint = &Datapoint{
		TimestampTimeType: 0,
	}
	if err := p.Datapoint.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Datapoint), err)
	}
	return nil
}

func (p *WriteRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("WriteRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *WriteRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:nameSpace: ", p), err)
	}
	if err := oprot.WriteString(string(p.NameSpace)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:nameSpace: ", p), err)
	}
	return err
}

func (p *WriteRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:id: ", p), err)
	}
	if err := oprot.WriteString(string(p.ID)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:id: ", p), err)
	}
	return err
}

func (p *WriteRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("datapoint", thrift.STRUCT, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:datapoint: ", p), err)
	}
	if err := p.Datapoint.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Datapoint), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:datapoint: ", p), err)
	}
	return err
}

func (p *WriteRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WriteRequest(%+v)", *p)
}

// Attributes:
//  - NameSpace
//  - ID
//  - Tags
//  - Datapoint
type WriteTaggedRequest struct {
	NameSpace string     `thrift:"nameSpace,1,required" db:"nameSpace" json:"nameSpace"`
	ID        string     `thrift:"id,2,required" db:"id" json:"id"`
	Tags      []*Tag     `thrift:"tags,3,required" db:"tags" json:"tags"`
	Datapoint *Datapoint `thrift:"datapoint,4,required" db:"datapoint" json:"datapoint"`
}

func NewWriteTaggedRequest() *WriteTaggedRequest {
	return &WriteTaggedRequest{}
}

func (p *WriteTaggedRequest) GetNameSpace() string {
	return p.NameSpace
}

func (p *WriteTaggedRequest) GetID() string {
	return p.ID
}

func (p *WriteTaggedRequest) GetTags() []*Tag {
	return p.Tags
}

var WriteTaggedRequest_Datapoint_DEFAULT *Datapoint

func (p *WriteTaggedRequest) GetDatapoint() *Datapoint {
	if !p.IsSetDatapoint() {
		return WriteTaggedRequest_Datapoint_DEFAULT
	}
	return p.Datapoint
}
func (p *WriteTaggedRequest) IsSetDatapoint() bool {
	return p.Datapoint != nil
}

func (p *WriteTaggedRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNameSpace bool = false
	var issetID bool = false
	var issetTags bool = false
	var issetDatapoint bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetID = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetTags = true
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
			issetDatapoint = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	if !issetTags {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Tags is not set"))
	}
	if !issetDatapoint {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Datapoint is not set"))
	}
	return nil
}

func (p *WriteTaggedRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *WriteTaggedRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *WriteTaggedRequest) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*Tag, 0, size)
	p.Tags = tSlice
	for i := 0; i < size; i++ {
		_elem2 := &Tag{}
		if err := _elem2.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem2), err)
		}
		p.Tags = append(p.Tags, _elem2)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *WriteTaggedRequest) ReadField4(iprot thrift.TProtocol) error {
	p.Datapoint = &Datapoint{
		TimestampTimeType: 0,
	}
	if err := p.Datapoint.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Datapoint), err)
	}
	return nil
}

func (p *WriteTaggedRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("WriteTaggedRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *WriteTaggedRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:nameSpace: ", p), err)
	}
	if err := oprot.WriteString(string(p.NameSpace)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:nameSpace: ", p), err)
	}
	return err
}

func (p *WriteTaggedRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:id: ", p), err)
	}
	if err := oprot.WriteString(string(p.ID)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:id: ", p), err)
	}
	return err
}

func (p *WriteTaggedRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("tags", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:tags: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Tags)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Tags {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:tags: ", p), err)
	}
	return err
}

func (p *WriteTaggedRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("datapoint", thrift.STRUCT, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:datapoint: ", p), err)
	}
	if err := p.Datapoint.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Datapoint), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:datapoint: ", p), err)
	}
	return err
}

func (p *WriteTaggedRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WriteTaggedRequest(%+v)", *p)
}

// Attributes:
//  - RangeStart
//  - RangeEnd
//  - NameSpace
//  - Ids
//  - RangeTimeType
type FetchBatchRawRequest struct {
	RangeStart    int64    `thrift:"rangeStart,1,required" db:"rangeStart" json:"rangeStart"`
	RangeEnd      int64    `thrift:"rangeEnd,2,required" db:"rangeEnd" json:"rangeEnd"`
	NameSpace     []byte   `thrift:"nameSpace,3,required" db:"nameSpace" json:"nameSpace"`
	Ids           [][]byte `thrift:"ids,4,required" db:"ids" json:"ids"`
	RangeTimeType TimeType `thrift:"rangeTimeType,5" db:"rangeTimeType" json:"rangeTimeType,omitempty"`
}

func NewFetchBatchRawRequest() *FetchBatchRawRequest {
	return &FetchBatchRawRequest{
		RangeTimeType: 0,
	}
}

func (p *FetchBatchRawRequest) GetRangeStart() int64 {
	return p.RangeStart
}

func (p *FetchBatchRawRequest) GetRangeEnd() int64 {
	return p.RangeEnd
}

func (p *FetchBatchRawRequest) GetNameSpace() []byte {
	return p.NameSpace
}

func (p *FetchBatchRawRequest) GetIds() [][]byte {
	return p.Ids
}

var FetchBatchRawRequest_RangeTimeType_DEFAULT TimeType = 0

func (p *FetchBatchRawRequest) GetRangeTimeType() TimeType {
	return p.RangeTimeType
}
func (p *FetchBatchRawRequest) IsSetRangeTimeType() bool {
	return p.RangeTimeType != FetchBatchRawRequest_RangeTimeType_DEFAULT
}

func (p *FetchBatchRawRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetRangeStart bool = false
	var issetRangeEnd bool = false
	var issetNameSpace bool = false
	var issetIds bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetRangeStart = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetRangeEnd = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
			issetIds = true
		case 5:
			if err := p.ReadField5(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetRangeStart {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeStart is not set"))
	}
	if !issetRangeEnd {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeEnd is not set"))
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	if !issetIds {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Ids is not set"))
	}
	return nil
}

func (p *FetchBatchRawRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.RangeStart = v
	}
	return nil
}

func (p *FetchBatchRawRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.RangeEnd = v
	}
	return nil
}

func (p *FetchBatchRawRequest) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *FetchBatchRawRequest) ReadField4(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.Ids = tSlice
	for i := 0; i < size; i++ {
		var _elem3 []byte
		if v, err := iprot.ReadBinary(); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem3 = v
		}
		p.Ids = append(p.Ids, _elem3)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FetchBatchRawRequest) ReadField5(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		temp := TimeType(v)
		p.RangeTimeType = temp
	}
	return nil
}

func (p *FetchBatchRawRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchBatchRawRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
		if err := p.writeField5(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchBatchRawRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeStart", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:rangeStart: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeStart)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeStart (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:rangeStart: ", p), err)
	}
	return err
}

func (p *FetchBatchRawRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeEnd", thrift.I64, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:rangeEnd: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeEnd)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeEnd (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:rangeEnd: ", p), err)
	}
	return err
}

func (p *FetchBatchRawRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:nameSpace: ", p), err)
	}
	if err := oprot.WriteBinary(p.NameSpace); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:nameSpace: ", p), err)
	}
	return err
}

func (p *FetchBatchRawRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("ids", thrift.LIST, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:ids: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRING, len(p.Ids)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Ids {
		if err := oprot.WriteBinary(v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:ids: ", p), err)
	}
	return err
}

func (p *FetchBatchRawRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetRangeTimeType() {
		if err := oprot.WriteFieldBegin("rangeTimeType", thrift.I32, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:rangeTimeType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.RangeTimeType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.rangeTimeType (5) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:rangeTimeType: ", p), err)
		}
	}
	return err
}

func (p *FetchBatchRawRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchBatchRawRequest(%+v)", *p)
}

// Attributes:
//  - NameSpaces
//  - Elements
type FetchBatchRawV2Request struct {
	NameSpaces [][]byte                         `thrift:"nameSpaces,1,required" db:"nameSpaces" json:"nameSpaces"`
	Elements   []*FetchBatchRawV2RequestElement `thrift:"elements,2,required" db:"elements" json:"elements"`
}

func NewFetchBatchRawV2Request() *FetchBatchRawV2Request {
	return &FetchBatchRawV2Request{}
}

func (p *FetchBatchRawV2Request) GetNameSpaces() [][]byte {
	return p.NameSpaces
}

func (p *FetchBatchRawV2Request) GetElements() []*FetchBatchRawV2RequestElement {
	return p.Elements
}
func (p *FetchBatchRawV2Request) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNameSpaces bool = false
	var issetElements bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNameSpaces = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetElements = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNameSpaces {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpaces is not set"))
	}
	if !issetElements {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Elements is not set"))
	}
	return nil
}

func (p *FetchBatchRawV2Request) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.NameSpaces = tSlice
	for i := 0; i < size; i++ {
		var _elem4 []byte
		if v, err := iprot.ReadBinary(); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem4 = v
		}
		p.NameSpaces = append(p.NameSpaces, _elem4)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FetchBatchRawV2Request) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*FetchBatchRawV2RequestElement, 0, size)
	p.Elements = tSlice
	for i := 0; i < size; i++ {
		_elem5 := &FetchBatchRawV2RequestElement{
			RangeTimeType: 0,
		}
		if err := _elem5.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem5), err)
		}
		p.Elements = append(p.Elements, _elem5)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FetchBatchRawV2Request) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchBatchRawV2Request"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchBatchRawV2Request) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpaces", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:nameSpaces: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRING, len(p.NameSpaces)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.NameSpaces {
		if err := oprot.WriteBinary(v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:nameSpaces: ", p), err)
	}
	return err
}

func (p *FetchBatchRawV2Request) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("elements", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:elements: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Elements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Elements {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:elements: ", p), err)
	}
	return err
}

func (p *FetchBatchRawV2Request) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchBatchRawV2Request(%+v)", *p)
}

// Attributes:
//  - NameSpace
//  - RangeStart
//  - RangeEnd
//  - ID
//  - RangeTimeType
type FetchBatchRawV2RequestElement struct {
	NameSpace     int64    `thrift:"nameSpace,1,required" db:"nameSpace" json:"nameSpace"`
	RangeStart    int64    `thrift:"rangeStart,2,required" db:"rangeStart" json:"rangeStart"`
	RangeEnd      int64    `thrift:"rangeEnd,3,required" db:"rangeEnd" json:"rangeEnd"`
	ID            []byte   `thrift:"id,4,required" db:"id" json:"id"`
	RangeTimeType TimeType `thrift:"rangeTimeType,5" db:"rangeTimeType" json:"rangeTimeType,omitempty"`
}

func NewFetchBatchRawV2RequestElement() *FetchBatchRawV2RequestElement {
	return &FetchBatchRawV2RequestElement{
		RangeTimeType: 0,
	}
}

func (p *FetchBatchRawV2RequestElement) GetNameSpace() int64 {
	return p.NameSpace
}

func (p *FetchBatchRawV2RequestElement) GetRangeStart() int64 {
	return p.RangeStart
}

func (p *FetchBatchRawV2RequestElement) GetRangeEnd() int64 {
	return p.RangeEnd
}

func (p *FetchBatchRawV2RequestElement) GetID() []byte {
	return p.ID
}

var FetchBatchRawV2RequestElement_RangeTimeType_DEFAULT TimeType = 0

func (p *FetchBatchRawV2RequestElement) GetRangeTimeType() TimeType {
	return p.RangeTimeType
}
func (p *FetchBatchRawV2RequestElement) IsSetRangeTimeType() bool {
	return p.RangeTimeType != FetchBatchRawV2RequestElement_RangeTimeType_DEFAULT
}

func (p *FetchBatchRawV2RequestElement) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNameSpace bool = false
	var issetRangeStart bool = false
	var issetRangeEnd bool = false
	var issetID bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetRangeStart = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetRangeEnd = true
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
			issetID = true
		case 5:
			if err := p.ReadField5(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	if !issetRangeStart {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeStart is not set"))
	}
	if !issetRangeEnd {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeEnd is not set"))
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	return nil
}

func (p *FetchBatchRawV2RequestElement) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *FetchBatchRawV2RequestElement) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.RangeStart = v
	}
	return nil
}

func (p *FetchBatchRawV2RequestElement) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.RangeEnd = v
	}
	return nil
}

func (p *FetchBatchRawV2RequestElement) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *FetchBatchRawV2RequestElement) ReadField5(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		temp := TimeType(v)
		p.RangeTimeType = temp
	}
	return nil
}

func (p *FetchBatchRawV2RequestElement) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchBatchRawV2RequestElement"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
		if err := p.writeField5(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchBatchRawV2RequestElement) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:nameSpace: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.NameSpace)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:nameSpace: ", p), err)
	}
	return err
}

func (p *FetchBatchRawV2RequestElement) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeStart", thrift.I64, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:rangeStart: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeStart)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeStart (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:rangeStart: ", p), err)
	}
	return err
}

func (p *FetchBatchRawV2RequestElement) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeEnd", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:rangeEnd: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeEnd)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeEnd (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:rangeEnd: ", p), err)
	}
	return err
}

func (p *FetchBatchRawV2RequestElement) writeField4(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:id: ", p), err)
	}
	if err := oprot.WriteBinary(p.ID); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:id: ", p), err)
	}
	return err
}

func (p *FetchBatchRawV2RequestElement) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetRangeTimeType() {
		if err := oprot.WriteFieldBegin("rangeTimeType", thrift.I32, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:rangeTimeType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.RangeTimeType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.rangeTimeType (5) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:rangeTimeType: ", p), err)
		}
	}
	return err
}

func (p *FetchBatchRawV2RequestElement) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchBatchRawV2RequestElement(%+v)", *p)
}

// Attributes:
//  - Elements
type FetchBatchRawResult_ struct {
	Elements []*FetchRawResult_ `thrift:"elements,1,required" db:"elements" json:"elements"`
}

func NewFetchBatchRawResult_() *FetchBatchRawResult_ {
	return &FetchBatchRawResult_{}
}

func (p *FetchBatchRawResult_) GetElements() []*FetchRawResult_ {
	return p.Elements
}
func (p *FetchBatchRawResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetElements bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetElements = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetElements {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Elements is not set"))
	}
	return nil
}

func (p *FetchBatchRawResult_) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*FetchRawResult_, 0, size)
	p.Elements = tSlice
	for i := 0; i < size; i++ {
		_elem6 := &FetchRawResult_{}
		if err := _elem6.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem6), err)
		}
		p.Elements = append(p.Elements, _elem6)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FetchBatchRawResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchBatchRawResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchBatchRawResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("elements", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:elements: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Elements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Elements {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:elements: ", p), err)
	}
	return err
}

func (p *FetchBatchRawResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchBatchRawResult_(%+v)", *p)
}

// Attributes:
//  - Segments
//  - Err
type FetchRawResult_ struct {
	Segments []*Segments `thrift:"segments,1,required" db:"segments" json:"segments"`
	Err      *Error      `thrift:"err,2" db:"err" json:"err,omitempty"`
}

func NewFetchRawResult_() *FetchRawResult_ {
	return &FetchRawResult_{}
}

func (p *FetchRawResult_) GetSegments() []*Segments {
	return p.Segments
}

var FetchRawResult__Err_DEFAULT *Error

func (p *FetchRawResult_) GetErr() *Error {
	if !p.IsSetErr() {
		return FetchRawResult__Err_DEFAULT
	}
	return p.Err
}
func (p *FetchRawResult_) IsSetErr() bool {
	return p.Err != nil
}

func (p *FetchRawResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetSegments bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetSegments = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetSegments {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Segments is not set"))
	}
	return nil
}

func (p *FetchRawResult_) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*Segments, 0, size)
	p.Segments = tSlice
	for i := 0; i < size; i++ {
		_elem7 := &Segments{}
		if err := _elem7.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem7), err)
		}
		p.Segments = append(p.Segments, _elem7)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FetchRawResult_) ReadField2(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *FetchRawResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchRawResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchRawResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("segments", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:segments: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Segments)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Segments {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:segments: ", p), err)
	}
	return err
}

func (p *FetchRawResult_) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:err: ", p), err)
		}
	}
	return err
}

func (p *FetchRawResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchRawResult_(%+v)", *p)
}

// Attributes:
//  - Merged
//  - Unmerged
type Segments struct {
	Merged   *Segment   `thrift:"merged,1" db:"merged" json:"merged,omitempty"`
	Unmerged []*Segment `thrift:"unmerged,2" db:"unmerged" json:"unmerged,omitempty"`
}

func NewSegments() *Segments {
	return &Segments{}
}

var Segments_Merged_DEFAULT *Segment

func (p *Segments) GetMerged() *Segment {
	if !p.IsSetMerged() {
		return Segments_Merged_DEFAULT
	}
	return p.Merged
}

var Segments_Unmerged_DEFAULT []*Segment

func (p *Segments) GetUnmerged() []*Segment {
	return p.Unmerged
}
func (p *Segments) IsSetMerged() bool {
	return p.Merged != nil
}

func (p *Segments) IsSetUnmerged() bool {
	return p.Unmerged != nil
}

func (p *Segments) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *Segments) ReadField1(iprot thrift.TProtocol) error {
	p.Merged = &Segment{}
	if err := p.Merged.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Merged), err)
	}
	return nil
}

func (p *Segments) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*Segment, 0, size)
	p.Unmerged = tSlice
	for i := 0; i < size; i++ {
		_elem8 := &Segment{}
		if err := _elem8.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem8), err)
		}
		p.Unmerged = append(p.Unmerged, _elem8)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *Segments) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("Segments"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *Segments) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetMerged() {
		if err := oprot.WriteFieldBegin("merged", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:merged: ", p), err)
		}
		if err := p.Merged.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Merged), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:merged: ", p), err)
		}
	}
	return err
}

func (p *Segments) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetUnmerged() {
		if err := oprot.WriteFieldBegin("unmerged", thrift.LIST, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:unmerged: ", p), err)
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Unmerged)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.Unmerged {
			if err := v.Write(oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:unmerged: ", p), err)
		}
	}
	return err
}

func (p *Segments) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Segments(%+v)", *p)
}

// Attributes:
//  - Head
//  - Tail
//  - StartTime
//  - BlockSize
type Segment struct {
	Head      []byte `thrift:"head,1,required" db:"head" json:"head"`
	Tail      []byte `thrift:"tail,2,required" db:"tail" json:"tail"`
	StartTime *int64 `thrift:"startTime,3" db:"startTime" json:"startTime,omitempty"`
	BlockSize *int64 `thrift:"blockSize,4" db:"blockSize" json:"blockSize,omitempty"`
}

func NewSegment() *Segment {
	return &Segment{}
}

func (p *Segment) GetHead() []byte {
	return p.Head
}

func (p *Segment) GetTail() []byte {
	return p.Tail
}

var Segment_StartTime_DEFAULT int64

func (p *Segment) GetStartTime() int64 {
	if !p.IsSetStartTime() {
		return Segment_StartTime_DEFAULT
	}
	return *p.StartTime
}

var Segment_BlockSize_DEFAULT int64

func (p *Segment) GetBlockSize() int64 {
	if !p.IsSetBlockSize() {
		return Segment_BlockSize_DEFAULT
	}
	return *p.BlockSize
}
func (p *Segment) IsSetStartTime() bool {
	return p.StartTime != nil
}

func (p *Segment) IsSetBlockSize() bool {
	return p.BlockSize != nil
}

func (p *Segment) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetHead bool = false
	var issetTail bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetHead = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetTail = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetHead {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Head is not set"))
	}
	if !issetTail {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Tail is not set"))
	}
	return nil
}

func (p *Segment) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Head = v
	}
	return nil
}

func (p *Segment) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Tail = v
	}
	return nil
}

func (p *Segment) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.StartTime = &v
	}
	return nil
}

func (p *Segment) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.BlockSize = &v
	}
	return nil
}

func (p *Segment) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("Segment"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *Segment) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("head", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:head: ", p), err)
	}
	if err := oprot.WriteBinary(p.Head); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.head (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:head: ", p), err)
	}
	return err
}

func (p *Segment) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("tail", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:tail: ", p), err)
	}
	if err := oprot.WriteBinary(p.Tail); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.tail (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:tail: ", p), err)
	}
	return err
}

func (p *Segment) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetStartTime() {
		if err := oprot.WriteFieldBegin("startTime", thrift.I64, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:startTime: ", p), err)
		}
		if err := oprot.WriteI64(int64(*p.StartTime)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.startTime (3) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:startTime: ", p), err)
		}
	}
	return err
}

func (p *Segment) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetBlockSize() {
		if err := oprot.WriteFieldBegin("blockSize", thrift.I64, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:blockSize: ", p), err)
		}
		if err := oprot.WriteI64(int64(*p.BlockSize)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.blockSize (4) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:blockSize: ", p), err)
		}
	}
	return err
}

func (p *Segment) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Segment(%+v)", *p)
}

// Attributes:
//  - NameSpace
//  - Query
//  - RangeStart
//  - RangeEnd
//  - FetchData
//  - Limit
//  - RangeTimeType
type FetchTaggedRequest struct {
	NameSpace     []byte   `thrift:"nameSpace,1,required" db:"nameSpace" json:"nameSpace"`
	Query         []byte   `thrift:"query,2,required" db:"query" json:"query"`
	RangeStart    int64    `thrift:"rangeStart,3,required" db:"rangeStart" json:"rangeStart"`
	RangeEnd      int64    `thrift:"rangeEnd,4,required" db:"rangeEnd" json:"rangeEnd"`
	FetchData     bool     `thrift:"fetchData,5,required" db:"fetchData" json:"fetchData"`
	Limit         *int64   `thrift:"limit,6" db:"limit" json:"limit,omitempty"`
	RangeTimeType TimeType `thrift:"rangeTimeType,7" db:"rangeTimeType" json:"rangeTimeType,omitempty"`
}

func NewFetchTaggedRequest() *FetchTaggedRequest {
	return &FetchTaggedRequest{
		RangeTimeType: 0,
	}
}

func (p *FetchTaggedRequest) GetNameSpace() []byte {
	return p.NameSpace
}

func (p *FetchTaggedRequest) GetQuery() []byte {
	return p.Query
}

func (p *FetchTaggedRequest) GetRangeStart() int64 {
	return p.RangeStart
}

func (p *FetchTaggedRequest) GetRangeEnd() int64 {
	return p.RangeEnd
}

func (p *FetchTaggedRequest) GetFetchData() bool {
	return p.FetchData
}

var FetchTaggedRequest_Limit_DEFAULT int64

func (p *FetchTaggedRequest) GetLimit() int64 {
	if !p.IsSetLimit() {
		return FetchTaggedRequest_Limit_DEFAULT
	}
	return *p.Limit
}

var FetchTaggedRequest_RangeTimeType_DEFAULT TimeType = 0

func (p *FetchTaggedRequest) GetRangeTimeType() TimeType {
	return p.RangeTimeType
}
func (p *FetchTaggedRequest) IsSetLimit() bool {
	return p.Limit != nil
}

func (p *FetchTaggedRequest) IsSetRangeTimeType() bool {
	return p.RangeTimeType != FetchTaggedRequest_RangeTimeType_DEFAULT
}

func (p *FetchTaggedRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNameSpace bool = false
	var issetQuery bool = false
	var issetRangeStart bool = false
	var issetRangeEnd bool = false
	var issetFetchData bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetQuery = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetRangeStart = true
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
			issetRangeEnd = true
		case 5:
			if err := p.ReadField5(iprot); err != nil {
				return err
			}
			issetFetchData = true
		case 6:
			if err := p.ReadField6(iprot); err != nil {
				return err
			}
		case 7:
			if err := p.ReadField7(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	if !issetQuery {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Query is not set"))
	}
	if !issetRangeStart {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeStart is not set"))
	}
	if !issetRangeEnd {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeEnd is not set"))
	}
	if !issetFetchData {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field FetchData is not set"))
	}
	return nil
}

func (p *FetchTaggedRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *FetchTaggedRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Query = v
	}
	return nil
}

func (p *FetchTaggedRequest) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.RangeStart = v
	}
	return nil
}

func (p *FetchTaggedRequest) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.RangeEnd = v
	}
	return nil
}

func (p *FetchTaggedRequest) ReadField5(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.FetchData = v
	}
	return nil
}

func (p *FetchTaggedRequest) ReadField6(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.Limit = &v
	}
	return nil
}

func (p *FetchTaggedRequest) ReadField7(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		temp := TimeType(v)
		p.RangeTimeType = temp
	}
	return nil
}

func (p *FetchTaggedRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchTaggedRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
		if err := p.writeField5(oprot); err != nil {
			return err
		}
		if err := p.writeField6(oprot); err != nil {
			return err
		}
		if err := p.writeField7(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchTaggedRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:nameSpace: ", p), err)
	}
	if err := oprot.WriteBinary(p.NameSpace); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:nameSpace: ", p), err)
	}
	return err
}

func (p *FetchTaggedRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("query", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:query: ", p), err)
	}
	if err := oprot.WriteBinary(p.Query); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.query (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:query: ", p), err)
	}
	return err
}

func (p *FetchTaggedRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeStart", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:rangeStart: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeStart)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeStart (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:rangeStart: ", p), err)
	}
	return err
}

func (p *FetchTaggedRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeEnd", thrift.I64, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:rangeEnd: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeEnd)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeEnd (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:rangeEnd: ", p), err)
	}
	return err
}

func (p *FetchTaggedRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("fetchData", thrift.BOOL, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:fetchData: ", p), err)
	}
	if err := oprot.WriteBool(bool(p.FetchData)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.fetchData (5) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:fetchData: ", p), err)
	}
	return err
}

func (p *FetchTaggedRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetLimit() {
		if err := oprot.WriteFieldBegin("limit", thrift.I64, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:limit: ", p), err)
		}
		if err := oprot.WriteI64(int64(*p.Limit)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.limit (6) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:limit: ", p), err)
		}
	}
	return err
}

func (p *FetchTaggedRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetRangeTimeType() {
		if err := oprot.WriteFieldBegin("rangeTimeType", thrift.I32, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:rangeTimeType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.RangeTimeType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.rangeTimeType (7) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:rangeTimeType: ", p), err)
		}
	}
	return err
}

func (p *FetchTaggedRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchTaggedRequest(%+v)", *p)
}

// Attributes:
//  - Elements
//  - Exhaustive
type FetchTaggedResult_ struct {
	Elements   []*FetchTaggedIDResult_ `thrift:"elements,1,required" db:"elements" json:"elements"`
	Exhaustive bool                    `thrift:"exhaustive,2,required" db:"exhaustive" json:"exhaustive"`
}

func NewFetchTaggedResult_() *FetchTaggedResult_ {
	return &FetchTaggedResult_{}
}

func (p *FetchTaggedResult_) GetElements() []*FetchTaggedIDResult_ {
	return p.Elements
}

func (p *FetchTaggedResult_) GetExhaustive() bool {
	return p.Exhaustive
}
func (p *FetchTaggedResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetElements bool = false
	var issetExhaustive bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetElements = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetExhaustive = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetElements {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Elements is not set"))
	}
	if !issetExhaustive {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Exhaustive is not set"))
	}
	return nil
}

func (p *FetchTaggedResult_) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*FetchTaggedIDResult_, 0, size)
	p.Elements = tSlice
	for i := 0; i < size; i++ {
		_elem9 := &FetchTaggedIDResult_{}
		if err := _elem9.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem9), err)
		}
		p.Elements = append(p.Elements, _elem9)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FetchTaggedResult_) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Exhaustive = v
	}
	return nil
}

func (p *FetchTaggedResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchTaggedResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchTaggedResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("elements", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:elements: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Elements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Elements {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:elements: ", p), err)
	}
	return err
}

func (p *FetchTaggedResult_) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("exhaustive", thrift.BOOL, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:exhaustive: ", p), err)
	}
	if err := oprot.WriteBool(bool(p.Exhaustive)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.exhaustive (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:exhaustive: ", p), err)
	}
	return err
}

func (p *FetchTaggedResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchTaggedResult_(%+v)", *p)
}

// Attributes:
//  - ID
//  - NameSpace
//  - EncodedTags
//  - Segments
//  - Err
type FetchTaggedIDResult_ struct {
	ID          []byte      `thrift:"id,1,required" db:"id" json:"id"`
	NameSpace   []byte      `thrift:"nameSpace,2,required" db:"nameSpace" json:"nameSpace"`
	EncodedTags []byte      `thrift:"encodedTags,3,required" db:"encodedTags" json:"encodedTags"`
	Segments    []*Segments `thrift:"segments,4" db:"segments" json:"segments,omitempty"`
	Err         *Error      `thrift:"err,5" db:"err" json:"err,omitempty"`
}

func NewFetchTaggedIDResult_() *FetchTaggedIDResult_ {
	return &FetchTaggedIDResult_{}
}

func (p *FetchTaggedIDResult_) GetID() []byte {
	return p.ID
}

func (p *FetchTaggedIDResult_) GetNameSpace() []byte {
	return p.NameSpace
}

func (p *FetchTaggedIDResult_) GetEncodedTags() []byte {
	return p.EncodedTags
}

var FetchTaggedIDResult__Segments_DEFAULT []*Segments

func (p *FetchTaggedIDResult_) GetSegments() []*Segments {
	return p.Segments
}

var FetchTaggedIDResult__Err_DEFAULT *Error

func (p *FetchTaggedIDResult_) GetErr() *Error {
	if !p.IsSetErr() {
		return FetchTaggedIDResult__Err_DEFAULT
	}
	return p.Err
}
func (p *FetchTaggedIDResult_) IsSetSegments() bool {
	return p.Segments != nil
}

func (p *FetchTaggedIDResult_) IsSetErr() bool {
	return p.Err != nil
}

func (p *FetchTaggedIDResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetID bool = false
	var issetNameSpace bool = false
	var issetEncodedTags bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetID = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetEncodedTags = true
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
		case 5:
			if err := p.ReadField5(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	if !issetEncodedTags {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field EncodedTags is not set"))
	}
	return nil
}

func (p *FetchTaggedIDResult_) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *FetchTaggedIDResult_) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *FetchTaggedIDResult_) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.EncodedTags = v
	}
	return nil
}

func (p *FetchTaggedIDResult_) ReadField4(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*Segments, 0, size)
	p.Segments = tSlice
	for i := 0; i < size; i++ {
		_elem10 := &Segments{}
		if err := _elem10.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem10), err)
		}
		p.Segments = append(p.Segments, _elem10)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FetchTaggedIDResult_) ReadField5(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *FetchTaggedIDResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchTaggedIDResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
		if err := p.writeField5(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchTaggedIDResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:id: ", p), err)
	}
	if err := oprot.WriteBinary(p.ID); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:id: ", p), err)
	}
	return err
}

func (p *FetchTaggedIDResult_) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:nameSpace: ", p), err)
	}
	if err := oprot.WriteBinary(p.NameSpace); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:nameSpace: ", p), err)
	}
	return err
}

func (p *FetchTaggedIDResult_) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("encodedTags", thrift.STRING, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:encodedTags: ", p), err)
	}
	if err := oprot.WriteBinary(p.EncodedTags); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.encodedTags (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:encodedTags: ", p), err)
	}
	return err
}

func (p *FetchTaggedIDResult_) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetSegments() {
		if err := oprot.WriteFieldBegin("segments", thrift.LIST, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:segments: ", p), err)
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Segments)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.Segments {
			if err := v.Write(oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:segments: ", p), err)
		}
	}
	return err
}

func (p *FetchTaggedIDResult_) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:err: ", p), err)
		}
	}
	return err
}

func (p *FetchTaggedIDResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchTaggedIDResult_(%+v)", *p)
}

// Attributes:
//  - NameSpace
//  - Shard
//  - Elements
type FetchBlocksRawRequest struct {
	NameSpace []byte                          `thrift:"nameSpace,1,required" db:"nameSpace" json:"nameSpace"`
	Shard     int32                           `thrift:"shard,2,required" db:"shard" json:"shard"`
	Elements  []*FetchBlocksRawRequestElement `thrift:"elements,3,required" db:"elements" json:"elements"`
}

func NewFetchBlocksRawRequest() *FetchBlocksRawRequest {
	return &FetchBlocksRawRequest{}
}

func (p *FetchBlocksRawRequest) GetNameSpace() []byte {
	return p.NameSpace
}

func (p *FetchBlocksRawRequest) GetShard() int32 {
	return p.Shard
}

func (p *FetchBlocksRawRequest) GetElements() []*FetchBlocksRawRequestElement {
	return p.Elements
}
func (p *FetchBlocksRawRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNameSpace bool = false
	var issetShard bool = false
	var issetElements bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetShard = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetElements = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	if !issetShard {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Shard is not set"))
	}
	if !issetElements {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Elements is not set"))
	}
	return nil
}

func (p *FetchBlocksRawRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *FetchBlocksRawRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Shard = v
	}
	return nil
}

func (p *FetchBlocksRawRequest) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*FetchBlocksRawRequestElement, 0, size)
	p.Elements = tSlice
	for i := 0; i < size; i++ {
		_elem11 := &FetchBlocksRawRequestElement{}
		if err := _elem11.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem11), err)
		}
		p.Elements = append(p.Elements, _elem11)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FetchBlocksRawRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchBlocksRawRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchBlocksRawRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:nameSpace: ", p), err)
	}
	if err := oprot.WriteBinary(p.NameSpace); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:nameSpace: ", p), err)
	}
	return err
}

func (p *FetchBlocksRawRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("shard", thrift.I32, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:shard: ", p), err)
	}
	if err := oprot.WriteI32(int32(p.Shard)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.shard (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:shard: ", p), err)
	}
	return err
}

func (p *FetchBlocksRawRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("elements", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:elements: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Elements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Elements {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:elements: ", p), err)
	}
	return err
}

func (p *FetchBlocksRawRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchBlocksRawRequest(%+v)", *p)
}

// Attributes:
//  - ID
//  - Starts
type FetchBlocksRawRequestElement struct {
	ID     []byte  `thrift:"id,1,required" db:"id" json:"id"`
	Starts []int64 `thrift:"starts,2,required" db:"starts" json:"starts"`
}

func NewFetchBlocksRawRequestElement() *FetchBlocksRawRequestElement {
	return &FetchBlocksRawRequestElement{}
}

func (p *FetchBlocksRawRequestElement) GetID() []byte {
	return p.ID
}

func (p *FetchBlocksRawRequestElement) GetStarts() []int64 {
	return p.Starts
}
func (p *FetchBlocksRawRequestElement) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetID bool = false
	var issetStarts bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetID = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetStarts = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	if !issetStarts {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Starts is not set"))
	}
	return nil
}

func (p *FetchBlocksRawRequestElement) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *FetchBlocksRawRequestElement) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]int64, 0, size)
	p.Starts = tSlice
	for i := 0; i < size; i++ {
		var _elem12 int64
		if v, err := iprot.ReadI64(); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem12 = v
		}
		p.Starts = append(p.Starts, _elem12)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FetchBlocksRawRequestElement) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchBlocksRawRequestElement"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchBlocksRawRequestElement) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:id: ", p), err)
	}
	if err := oprot.WriteBinary(p.ID); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:id: ", p), err)
	}
	return err
}

func (p *FetchBlocksRawRequestElement) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("starts", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:starts: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.I64, len(p.Starts)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Starts {
		if err := oprot.WriteI64(int64(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:starts: ", p), err)
	}
	return err
}

func (p *FetchBlocksRawRequestElement) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchBlocksRawRequestElement(%+v)", *p)
}

// Attributes:
//  - Elements
type FetchBlocksRawResult_ struct {
	Elements []*Blocks `thrift:"elements,1,required" db:"elements" json:"elements"`
}

func NewFetchBlocksRawResult_() *FetchBlocksRawResult_ {
	return &FetchBlocksRawResult_{}
}

func (p *FetchBlocksRawResult_) GetElements() []*Blocks {
	return p.Elements
}
func (p *FetchBlocksRawResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetElements bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetElements = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetElements {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Elements is not set"))
	}
	return nil
}

func (p *FetchBlocksRawResult_) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*Blocks, 0, size)
	p.Elements = tSlice
	for i := 0; i < size; i++ {
		_elem13 := &Blocks{}
		if err := _elem13.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem13), err)
		}
		p.Elements = append(p.Elements, _elem13)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FetchBlocksRawResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchBlocksRawResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchBlocksRawResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("elements", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:elements: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Elements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Elements {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:elements: ", p), err)
	}
	return err
}

func (p *FetchBlocksRawResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchBlocksRawResult_(%+v)", *p)
}

// Attributes:
//  - ID
//  - Blocks
type Blocks struct {
	ID     []byte   `thrift:"id,1,required" db:"id" json:"id"`
	Blocks []*Block `thrift:"blocks,2,required" db:"blocks" json:"blocks"`
}

func NewBlocks() *Blocks {
	return &Blocks{}
}

func (p *Blocks) GetID() []byte {
	return p.ID
}

func (p *Blocks) GetBlocks() []*Block {
	return p.Blocks
}
func (p *Blocks) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetID bool = false
	var issetBlocks bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetID = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetBlocks = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	if !issetBlocks {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Blocks is not set"))
	}
	return nil
}

func (p *Blocks) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *Blocks) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*Block, 0, size)
	p.Blocks = tSlice
	for i := 0; i < size; i++ {
		_elem14 := &Block{}
		if err := _elem14.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem14), err)
		}
		p.Blocks = append(p.Blocks, _elem14)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *Blocks) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("Blocks"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *Blocks) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:id: ", p), err)
	}
	if err := oprot.WriteBinary(p.ID); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:id: ", p), err)
	}
	return err
}

func (p *Blocks) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("blocks", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:blocks: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Blocks)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Blocks {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:blocks: ", p), err)
	}
	return err
}

func (p *Blocks) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Blocks(%+v)", *p)
}

// Attributes:
//  - Start
//  - Segments
//  - Err
//  - Checksum
type Block struct {
	Start    int64     `thrift:"start,1,required" db:"start" json:"start"`
	Segments *Segments `thrift:"segments,2" db:"segments" json:"segments,omitempty"`
	Err      *Error    `thrift:"err,3" db:"err" json:"err,omitempty"`
	Checksum *int64    `thrift:"checksum,4" db:"checksum" json:"checksum,omitempty"`
}

func NewBlock() *Block {
	return &Block{}
}

func (p *Block) GetStart() int64 {
	return p.Start
}

var Block_Segments_DEFAULT *Segments

func (p *Block) GetSegments() *Segments {
	if !p.IsSetSegments() {
		return Block_Segments_DEFAULT
	}
	return p.Segments
}

var Block_Err_DEFAULT *Error

func (p *Block) GetErr() *Error {
	if !p.IsSetErr() {
		return Block_Err_DEFAULT
	}
	return p.Err
}

var Block_Checksum_DEFAULT int64

func (p *Block) GetChecksum() int64 {
	if !p.IsSetChecksum() {
		return Block_Checksum_DEFAULT
	}
	return *p.Checksum
}
func (p *Block) IsSetSegments() bool {
	return p.Segments != nil
}

func (p *Block) IsSetErr() bool {
	return p.Err != nil
}

func (p *Block) IsSetChecksum() bool {
	return p.Checksum != nil
}

func (p *Block) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetStart bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetStart = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetStart {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Start is not set"))
	}
	return nil
}

func (p *Block) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Start = v
	}
	return nil
}

func (p *Block) ReadField2(iprot thrift.TProtocol) error {
	p.Segments = &Segments{}
	if err := p.Segments.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Segments), err)
	}
	return nil
}

func (p *Block) ReadField3(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *Block) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.Checksum = &v
	}
	return nil
}

func (p *Block) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("Block"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *Block) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("start", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:start: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.Start)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.start (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:start: ", p), err)
	}
	return err
}

func (p *Block) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetSegments() {
		if err := oprot.WriteFieldBegin("segments", thrift.STRUCT, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:segments: ", p), err)
		}
		if err := p.Segments.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Segments), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:segments: ", p), err)
		}
	}
	return err
}

func (p *Block) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:err: ", p), err)
		}
	}
	return err
}

func (p *Block) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetChecksum() {
		if err := oprot.WriteFieldBegin("checksum", thrift.I64, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:checksum: ", p), err)
		}
		if err := oprot.WriteI64(int64(*p.Checksum)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.checksum (4) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:checksum: ", p), err)
		}
	}
	return err
}

func (p *Block) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Block(%+v)", *p)
}

// Attributes:
//  - Name
//  - Value
type Tag struct {
	Name  string `thrift:"name,1,required" db:"name" json:"name"`
	Value string `thrift:"value,2,required" db:"value" json:"value"`
}

func NewTag() *Tag {
	return &Tag{}
}

func (p *Tag) GetName() string {
	return p.Name
}

func (p *Tag) GetValue() string {
	return p.Value
}
func (p *Tag) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetName bool = false
	var issetValue bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetName = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetValue = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetName {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Name is not set"))
	}
	if !issetValue {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Value is not set"))
	}
	return nil
}

func (p *Tag) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Name = v
	}
	return nil
}

func (p *Tag) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Value = v
	}
	return nil
}

func (p *Tag) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("Tag"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *Tag) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:name: ", p), err)
	}
	if err := oprot.WriteString(string(p.Name)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.name (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:name: ", p), err)
	}
	return err
}

func (p *Tag) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("value", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:value: ", p), err)
	}
	if err := oprot.WriteString(string(p.Value)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.value (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:value: ", p), err)
	}
	return err
}

func (p *Tag) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Tag(%+v)", *p)
}

// Attributes:
//  - NameSpace
//  - Shard
//  - RangeStart
//  - RangeEnd
//  - Limit
//  - PageToken
//  - IncludeSizes
//  - IncludeChecksums
//  - IncludeLastRead
type FetchBlocksMetadataRawV2Request struct {
	NameSpace        []byte `thrift:"nameSpace,1,required" db:"nameSpace" json:"nameSpace"`
	Shard            int32  `thrift:"shard,2,required" db:"shard" json:"shard"`
	RangeStart       int64  `thrift:"rangeStart,3,required" db:"rangeStart" json:"rangeStart"`
	RangeEnd         int64  `thrift:"rangeEnd,4,required" db:"rangeEnd" json:"rangeEnd"`
	Limit            int64  `thrift:"limit,5,required" db:"limit" json:"limit"`
	PageToken        []byte `thrift:"pageToken,6" db:"pageToken" json:"pageToken,omitempty"`
	IncludeSizes     *bool  `thrift:"includeSizes,7" db:"includeSizes" json:"includeSizes,omitempty"`
	IncludeChecksums *bool  `thrift:"includeChecksums,8" db:"includeChecksums" json:"includeChecksums,omitempty"`
	IncludeLastRead  *bool  `thrift:"includeLastRead,9" db:"includeLastRead" json:"includeLastRead,omitempty"`
}

func NewFetchBlocksMetadataRawV2Request() *FetchBlocksMetadataRawV2Request {
	return &FetchBlocksMetadataRawV2Request{}
}

func (p *FetchBlocksMetadataRawV2Request) GetNameSpace() []byte {
	return p.NameSpace
}

func (p *FetchBlocksMetadataRawV2Request) GetShard() int32 {
	return p.Shard
}

func (p *FetchBlocksMetadataRawV2Request) GetRangeStart() int64 {
	return p.RangeStart
}

func (p *FetchBlocksMetadataRawV2Request) GetRangeEnd() int64 {
	return p.RangeEnd
}

func (p *FetchBlocksMetadataRawV2Request) GetLimit() int64 {
	return p.Limit
}

var FetchBlocksMetadataRawV2Request_PageToken_DEFAULT []byte

func (p *FetchBlocksMetadataRawV2Request) GetPageToken() []byte {
	return p.PageToken
}

var FetchBlocksMetadataRawV2Request_IncludeSizes_DEFAULT bool

func (p *FetchBlocksMetadataRawV2Request) GetIncludeSizes() bool {
	if !p.IsSetIncludeSizes() {
		return FetchBlocksMetadataRawV2Request_IncludeSizes_DEFAULT
	}
	return *p.IncludeSizes
}

var FetchBlocksMetadataRawV2Request_IncludeChecksums_DEFAULT bool

func (p *FetchBlocksMetadataRawV2Request) GetIncludeChecksums() bool {
	if !p.IsSetIncludeChecksums() {
		return FetchBlocksMetadataRawV2Request_IncludeChecksums_DEFAULT
	}
	return *p.IncludeChecksums
}

var FetchBlocksMetadataRawV2Request_IncludeLastRead_DEFAULT bool

func (p *FetchBlocksMetadataRawV2Request) GetIncludeLastRead() bool {
	if !p.IsSetIncludeLastRead() {
		return FetchBlocksMetadataRawV2Request_IncludeLastRead_DEFAULT
	}
	return *p.IncludeLastRead
}
func (p *FetchBlocksMetadataRawV2Request) IsSetPageToken() bool {
	return p.PageToken != nil
}

func (p *FetchBlocksMetadataRawV2Request) IsSetIncludeSizes() bool {
	return p.IncludeSizes != nil
}

func (p *FetchBlocksMetadataRawV2Request) IsSetIncludeChecksums() bool {
	return p.IncludeChecksums != nil
}

func (p *FetchBlocksMetadataRawV2Request) IsSetIncludeLastRead() bool {
	return p.IncludeLastRead != nil
}

func (p *FetchBlocksMetadataRawV2Request) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNameSpace bool = false
	var issetShard bool = false
	var issetRangeStart bool = false
	var issetRangeEnd bool = false
	var issetLimit bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetShard = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetRangeStart = true
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
			issetRangeEnd = true
		case 5:
			if err := p.ReadField5(iprot); err != nil {
				return err
			}
			issetLimit = true
		case 6:
			if err := p.ReadField6(iprot); err != nil {
				return err
			}
		case 7:
			if err := p.ReadField7(iprot); err != nil {
				return err
			}
		case 8:
			if err := p.ReadField8(iprot); err != nil {
				return err
			}
		case 9:
			if err := p.ReadField9(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	if !issetShard {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Shard is not set"))
	}
	if !issetRangeStart {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeStart is not set"))
	}
	if !issetRangeEnd {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeEnd is not set"))
	}
	if !issetLimit {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Limit is not set"))
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Request) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Request) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Shard = v
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Request) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.RangeStart = v
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Request) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.RangeEnd = v
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Request) ReadField5(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.Limit = v
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Request) ReadField6(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.PageToken = v
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Request) ReadField7(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		p.IncludeSizes = &v
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Request) ReadField8(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 8: ", err)
	} else {
		p.IncludeChecksums = &v
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Request) ReadField9(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 9: ", err)
	} else {
		p.IncludeLastRead = &v
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Request) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchBlocksMetadataRawV2Request"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
		if err := p.writeField5(oprot); err != nil {
			return err
		}
		if err := p.writeField6(oprot); err != nil {
			return err
		}
		if err := p.writeField7(oprot); err != nil {
			return err
		}
		if err := p.writeField8(oprot); err != nil {
			return err
		}
		if err := p.writeField9(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Request) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:nameSpace: ", p), err)
	}
	if err := oprot.WriteBinary(p.NameSpace); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:nameSpace: ", p), err)
	}
	return err
}

func (p *FetchBlocksMetadataRawV2Request) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("shard", thrift.I32, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:shard: ", p), err)
	}
	if err := oprot.WriteI32(int32(p.Shard)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.shard (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:shard: ", p), err)
	}
	return err
}

func (p *FetchBlocksMetadataRawV2Request) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeStart", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:rangeStart: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeStart)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeStart (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:rangeStart: ", p), err)
	}
	return err
}

func (p *FetchBlocksMetadataRawV2Request) writeField4(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeEnd", thrift.I64, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:rangeEnd: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeEnd)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeEnd (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:rangeEnd: ", p), err)
	}
	return err
}

func (p *FetchBlocksMetadataRawV2Request) writeField5(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("limit", thrift.I64, 5); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:limit: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.Limit)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.limit (5) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 5:limit: ", p), err)
	}
	return err
}

func (p *FetchBlocksMetadataRawV2Request) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetPageToken() {
		if err := oprot.WriteFieldBegin("pageToken", thrift.STRING, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:pageToken: ", p), err)
		}
		if err := oprot.WriteBinary(p.PageToken); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.pageToken (6) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:pageToken: ", p), err)
		}
	}
	return err
}

func (p *FetchBlocksMetadataRawV2Request) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetIncludeSizes() {
		if err := oprot.WriteFieldBegin("includeSizes", thrift.BOOL, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:includeSizes: ", p), err)
		}
		if err := oprot.WriteBool(bool(*p.IncludeSizes)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.includeSizes (7) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:includeSizes: ", p), err)
		}
	}
	return err
}

func (p *FetchBlocksMetadataRawV2Request) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetIncludeChecksums() {
		if err := oprot.WriteFieldBegin("includeChecksums", thrift.BOOL, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:includeChecksums: ", p), err)
		}
		if err := oprot.WriteBool(bool(*p.IncludeChecksums)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.includeChecksums (8) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:includeChecksums: ", p), err)
		}
	}
	return err
}

func (p *FetchBlocksMetadataRawV2Request) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetIncludeLastRead() {
		if err := oprot.WriteFieldBegin("includeLastRead", thrift.BOOL, 9); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:includeLastRead: ", p), err)
		}
		if err := oprot.WriteBool(bool(*p.IncludeLastRead)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.includeLastRead (9) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 9:includeLastRead: ", p), err)
		}
	}
	return err
}

func (p *FetchBlocksMetadataRawV2Request) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchBlocksMetadataRawV2Request(%+v)", *p)
}

// Attributes:
//  - Elements
//  - NextPageToken
type FetchBlocksMetadataRawV2Result_ struct {
	Elements      []*BlockMetadataV2 `thrift:"elements,1,required" db:"elements" json:"elements"`
	NextPageToken []byte             `thrift:"nextPageToken,2" db:"nextPageToken" json:"nextPageToken,omitempty"`
}

func NewFetchBlocksMetadataRawV2Result_() *FetchBlocksMetadataRawV2Result_ {
	return &FetchBlocksMetadataRawV2Result_{}
}

func (p *FetchBlocksMetadataRawV2Result_) GetElements() []*BlockMetadataV2 {
	return p.Elements
}

var FetchBlocksMetadataRawV2Result__NextPageToken_DEFAULT []byte

func (p *FetchBlocksMetadataRawV2Result_) GetNextPageToken() []byte {
	return p.NextPageToken
}
func (p *FetchBlocksMetadataRawV2Result_) IsSetNextPageToken() bool {
	return p.NextPageToken != nil
}

func (p *FetchBlocksMetadataRawV2Result_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetElements bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetElements = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetElements {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Elements is not set"))
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Result_) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*BlockMetadataV2, 0, size)
	p.Elements = tSlice
	for i := 0; i < size; i++ {
		_elem15 := &BlockMetadataV2{
			LastReadTimeType: 0,
		}
		if err := _elem15.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem15), err)
		}
		p.Elements = append(p.Elements, _elem15)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Result_) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.NextPageToken = v
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Result_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FetchBlocksMetadataRawV2Result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FetchBlocksMetadataRawV2Result_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("elements", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:elements: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Elements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Elements {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:elements: ", p), err)
	}
	return err
}

func (p *FetchBlocksMetadataRawV2Result_) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetNextPageToken() {
		if err := oprot.WriteFieldBegin("nextPageToken", thrift.STRING, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:nextPageToken: ", p), err)
		}
		if err := oprot.WriteBinary(p.NextPageToken); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.nextPageToken (2) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:nextPageToken: ", p), err)
		}
	}
	return err
}

func (p *FetchBlocksMetadataRawV2Result_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FetchBlocksMetadataRawV2Result_(%+v)", *p)
}

// Attributes:
//  - ID
//  - Start
//  - Err
//  - Size
//  - Checksum
//  - LastRead
//  - LastReadTimeType
//  - EncodedTags
type BlockMetadataV2 struct {
	ID               []byte   `thrift:"id,1,required" db:"id" json:"id"`
	Start            int64    `thrift:"start,2,required" db:"start" json:"start"`
	Err              *Error   `thrift:"err,3" db:"err" json:"err,omitempty"`
	Size             *int64   `thrift:"size,4" db:"size" json:"size,omitempty"`
	Checksum         *int64   `thrift:"checksum,5" db:"checksum" json:"checksum,omitempty"`
	LastRead         *int64   `thrift:"lastRead,6" db:"lastRead" json:"lastRead,omitempty"`
	LastReadTimeType TimeType `thrift:"lastReadTimeType,7" db:"lastReadTimeType" json:"lastReadTimeType,omitempty"`
	EncodedTags      []byte   `thrift:"encodedTags,8" db:"encodedTags" json:"encodedTags,omitempty"`
}

func NewBlockMetadataV2() *BlockMetadataV2 {
	return &BlockMetadataV2{
		LastReadTimeType: 0,
	}
}

func (p *BlockMetadataV2) GetID() []byte {
	return p.ID
}

func (p *BlockMetadataV2) GetStart() int64 {
	return p.Start
}

var BlockMetadataV2_Err_DEFAULT *Error

func (p *BlockMetadataV2) GetErr() *Error {
	if !p.IsSetErr() {
		return BlockMetadataV2_Err_DEFAULT
	}
	return p.Err
}

var BlockMetadataV2_Size_DEFAULT int64

func (p *BlockMetadataV2) GetSize() int64 {
	if !p.IsSetSize() {
		return BlockMetadataV2_Size_DEFAULT
	}
	return *p.Size
}

var BlockMetadataV2_Checksum_DEFAULT int64

func (p *BlockMetadataV2) GetChecksum() int64 {
	if !p.IsSetChecksum() {
		return BlockMetadataV2_Checksum_DEFAULT
	}
	return *p.Checksum
}

var BlockMetadataV2_LastRead_DEFAULT int64

func (p *BlockMetadataV2) GetLastRead() int64 {
	if !p.IsSetLastRead() {
		return BlockMetadataV2_LastRead_DEFAULT
	}
	return *p.LastRead
}

var BlockMetadataV2_LastReadTimeType_DEFAULT TimeType = 0

func (p *BlockMetadataV2) GetLastReadTimeType() TimeType {
	return p.LastReadTimeType
}

var BlockMetadataV2_EncodedTags_DEFAULT []byte

func (p *BlockMetadataV2) GetEncodedTags() []byte {
	return p.EncodedTags
}
func (p *BlockMetadataV2) IsSetErr() bool {
	return p.Err != nil
}

func (p *BlockMetadataV2) IsSetSize() bool {
	return p.Size != nil
}

func (p *BlockMetadataV2) IsSetChecksum() bool {
	return p.Checksum != nil
}

func (p *BlockMetadataV2) IsSetLastRead() bool {
	return p.LastRead != nil
}

func (p *BlockMetadataV2) IsSetLastReadTimeType() bool {
	return p.LastReadTimeType != BlockMetadataV2_LastReadTimeType_DEFAULT
}

func (p *BlockMetadataV2) IsSetEncodedTags() bool {
	return p.EncodedTags != nil
}

func (p *BlockMetadataV2) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetID bool = false
	var issetStart bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetID = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetStart = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
		case 5:
			if err := p.ReadField5(iprot); err != nil {
				return err
			}
		case 6:
			if err := p.ReadField6(iprot); err != nil {
				return err
			}
		case 7:
			if err := p.ReadField7(iprot); err != nil {
				return err
			}
		case 8:
			if err := p.ReadField8(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	if !issetStart {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Start is not set"))
	}
	return nil
}

func (p *BlockMetadataV2) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *BlockMetadataV2) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Start = v
	}
	return nil
}

func (p *BlockMetadataV2) ReadField3(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *BlockMetadataV2) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.Size = &v
	}
	return nil
}

func (p *BlockMetadataV2) ReadField5(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.Checksum = &v
	}
	return nil
}

func (p *BlockMetadataV2) ReadField6(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.LastRead = &v
	}
	return nil
}

func (p *BlockMetadataV2) ReadField7(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		temp := TimeType(v)
		p.LastReadTimeType = temp
	}
	return nil
}

func (p *BlockMetadataV2) ReadField8(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 8: ", err)
	} else {
		p.EncodedTags = v
	}
	return nil
}

func (p *BlockMetadataV2) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("BlockMetadataV2"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
		if err := p.writeField5(oprot); err != nil {
			return err
		}
		if err := p.writeField6(oprot); err != nil {
			return err
		}
		if err := p.writeField7(oprot); err != nil {
			return err
		}
		if err := p.writeField8(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *BlockMetadataV2) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:id: ", p), err)
	}
	if err := oprot.WriteBinary(p.ID); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:id: ", p), err)
	}
	return err
}

func (p *BlockMetadataV2) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("start", thrift.I64, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:start: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.Start)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.start (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:start: ", p), err)
	}
	return err
}

func (p *BlockMetadataV2) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:err: ", p), err)
		}
	}
	return err
}

func (p *BlockMetadataV2) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetSize() {
		if err := oprot.WriteFieldBegin("size", thrift.I64, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:size: ", p), err)
		}
		if err := oprot.WriteI64(int64(*p.Size)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.size (4) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:size: ", p), err)
		}
	}
	return err
}

func (p *BlockMetadataV2) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetChecksum() {
		if err := oprot.WriteFieldBegin("checksum", thrift.I64, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:checksum: ", p), err)
		}
		if err := oprot.WriteI64(int64(*p.Checksum)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.checksum (5) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:checksum: ", p), err)
		}
	}
	return err
}

func (p *BlockMetadataV2) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetLastRead() {
		if err := oprot.WriteFieldBegin("lastRead", thrift.I64, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:lastRead: ", p), err)
		}
		if err := oprot.WriteI64(int64(*p.LastRead)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.lastRead (6) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:lastRead: ", p), err)
		}
	}
	return err
}

func (p *BlockMetadataV2) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetLastReadTimeType() {
		if err := oprot.WriteFieldBegin("lastReadTimeType", thrift.I32, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:lastReadTimeType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.LastReadTimeType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.lastReadTimeType (7) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:lastReadTimeType: ", p), err)
		}
	}
	return err
}

func (p *BlockMetadataV2) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetEncodedTags() {
		if err := oprot.WriteFieldBegin("encodedTags", thrift.STRING, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:encodedTags: ", p), err)
		}
		if err := oprot.WriteBinary(p.EncodedTags); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.encodedTags (8) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:encodedTags: ", p), err)
		}
	}
	return err
}

func (p *BlockMetadataV2) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BlockMetadataV2(%+v)", *p)
}

// Attributes:
//  - NameSpace
//  - Elements
type WriteBatchRawRequest struct {
	NameSpace []byte                         `thrift:"nameSpace,1,required" db:"nameSpace" json:"nameSpace"`
	Elements  []*WriteBatchRawRequestElement `thrift:"elements,2,required" db:"elements" json:"elements"`
}

func NewWriteBatchRawRequest() *WriteBatchRawRequest {
	return &WriteBatchRawRequest{}
}

func (p *WriteBatchRawRequest) GetNameSpace() []byte {
	return p.NameSpace
}

func (p *WriteBatchRawRequest) GetElements() []*WriteBatchRawRequestElement {
	return p.Elements
}
func (p *WriteBatchRawRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNameSpace bool = false
	var issetElements bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetElements = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	if !issetElements {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Elements is not set"))
	}
	return nil
}

func (p *WriteBatchRawRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *WriteBatchRawRequest) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*WriteBatchRawRequestElement, 0, size)
	p.Elements = tSlice
	for i := 0; i < size; i++ {
		_elem16 := &WriteBatchRawRequestElement{}
		if err := _elem16.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem16), err)
		}
		p.Elements = append(p.Elements, _elem16)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *WriteBatchRawRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("WriteBatchRawRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *WriteBatchRawRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:nameSpace: ", p), err)
	}
	if err := oprot.WriteBinary(p.NameSpace); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:nameSpace: ", p), err)
	}
	return err
}

func (p *WriteBatchRawRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("elements", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:elements: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Elements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Elements {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:elements: ", p), err)
	}
	return err
}

func (p *WriteBatchRawRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WriteBatchRawRequest(%+v)", *p)
}

// Attributes:
//  - NameSpaces
//  - Elements
type WriteBatchRawV2Request struct {
	NameSpaces [][]byte                         `thrift:"nameSpaces,1,required" db:"nameSpaces" json:"nameSpaces"`
	Elements   []*WriteBatchRawV2RequestElement `thrift:"elements,2,required" db:"elements" json:"elements"`
}

func NewWriteBatchRawV2Request() *WriteBatchRawV2Request {
	return &WriteBatchRawV2Request{}
}

func (p *WriteBatchRawV2Request) GetNameSpaces() [][]byte {
	return p.NameSpaces
}

func (p *WriteBatchRawV2Request) GetElements() []*WriteBatchRawV2RequestElement {
	return p.Elements
}
func (p *WriteBatchRawV2Request) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNameSpaces bool = false
	var issetElements bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNameSpaces = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetElements = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNameSpaces {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpaces is not set"))
	}
	if !issetElements {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Elements is not set"))
	}
	return nil
}

func (p *WriteBatchRawV2Request) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.NameSpaces = tSlice
	for i := 0; i < size; i++ {
		var _elem17 []byte
		if v, err := iprot.ReadBinary(); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem17 = v
		}
		p.NameSpaces = append(p.NameSpaces, _elem17)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *WriteBatchRawV2Request) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*WriteBatchRawV2RequestElement, 0, size)
	p.Elements = tSlice
	for i := 0; i < size; i++ {
		_elem18 := &WriteBatchRawV2RequestElement{}
		if err := _elem18.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem18), err)
		}
		p.Elements = append(p.Elements, _elem18)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *WriteBatchRawV2Request) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("WriteBatchRawV2Request"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *WriteBatchRawV2Request) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpaces", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:nameSpaces: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRING, len(p.NameSpaces)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.NameSpaces {
		if err := oprot.WriteBinary(v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:nameSpaces: ", p), err)
	}
	return err
}

func (p *WriteBatchRawV2Request) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("elements", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:elements: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Elements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Elements {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:elements: ", p), err)
	}
	return err
}

func (p *WriteBatchRawV2Request) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WriteBatchRawV2Request(%+v)", *p)
}

// Attributes:
//  - ID
//  - Datapoint
type WriteBatchRawRequestElement struct {
	ID        []byte     `thrift:"id,1,required" db:"id" json:"id"`
	Datapoint *Datapoint `thrift:"datapoint,2,required" db:"datapoint" json:"datapoint"`
}

func NewWriteBatchRawRequestElement() *WriteBatchRawRequestElement {
	return &WriteBatchRawRequestElement{}
}

func (p *WriteBatchRawRequestElement) GetID() []byte {
	return p.ID
}

var WriteBatchRawRequestElement_Datapoint_DEFAULT *Datapoint

func (p *WriteBatchRawRequestElement) GetDatapoint() *Datapoint {
	if !p.IsSetDatapoint() {
		return WriteBatchRawRequestElement_Datapoint_DEFAULT
	}
	return p.Datapoint
}
func (p *WriteBatchRawRequestElement) IsSetDatapoint() bool {
	return p.Datapoint != nil
}

func (p *WriteBatchRawRequestElement) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetID bool = false
	var issetDatapoint bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetID = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetDatapoint = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	if !issetDatapoint {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Datapoint is not set"))
	}
	return nil
}

func (p *WriteBatchRawRequestElement) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *WriteBatchRawRequestElement) ReadField2(iprot thrift.TProtocol) error {
	p.Datapoint = &Datapoint{
		TimestampTimeType: 0,
	}
	if err := p.Datapoint.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Datapoint), err)
	}
	return nil
}

func (p *WriteBatchRawRequestElement) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("WriteBatchRawRequestElement"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *WriteBatchRawRequestElement) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:id: ", p), err)
	}
	if err := oprot.WriteBinary(p.ID); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:id: ", p), err)
	}
	return err
}

func (p *WriteBatchRawRequestElement) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("datapoint", thrift.STRUCT, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:datapoint: ", p), err)
	}
	if err := p.Datapoint.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Datapoint), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:datapoint: ", p), err)
	}
	return err
}

func (p *WriteBatchRawRequestElement) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WriteBatchRawRequestElement(%+v)", *p)
}

// Attributes:
//  - ID
//  - Datapoint
//  - NameSpace
type WriteBatchRawV2RequestElement struct {
	ID        []byte     `thrift:"id,1,required" db:"id" json:"id"`
	Datapoint *Datapoint `thrift:"datapoint,2,required" db:"datapoint" json:"datapoint"`
	NameSpace int64      `thrift:"nameSpace,3,required" db:"nameSpace" json:"nameSpace"`
}

func NewWriteBatchRawV2RequestElement() *WriteBatchRawV2RequestElement {
	return &WriteBatchRawV2RequestElement{}
}

func (p *WriteBatchRawV2RequestElement) GetID() []byte {
	return p.ID
}

var WriteBatchRawV2RequestElement_Datapoint_DEFAULT *Datapoint

func (p *WriteBatchRawV2RequestElement) GetDatapoint() *Datapoint {
	if !p.IsSetDatapoint() {
		return WriteBatchRawV2RequestElement_Datapoint_DEFAULT
	}
	return p.Datapoint
}

func (p *WriteBatchRawV2RequestElement) GetNameSpace() int64 {
	return p.NameSpace
}
func (p *WriteBatchRawV2RequestElement) IsSetDatapoint() bool {
	return p.Datapoint != nil
}

func (p *WriteBatchRawV2RequestElement) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetID bool = false
	var issetDatapoint bool = false
	var issetNameSpace bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetID = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetDatapoint = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	if !issetDatapoint {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Datapoint is not set"))
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	return nil
}

func (p *WriteBatchRawV2RequestElement) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *WriteBatchRawV2RequestElement) ReadField2(iprot thrift.TProtocol) error {
	p.Datapoint = &Datapoint{
		TimestampTimeType: 0,
	}
	if err := p.Datapoint.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Datapoint), err)
	}
	return nil
}

func (p *WriteBatchRawV2RequestElement) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *WriteBatchRawV2RequestElement) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("WriteBatchRawV2RequestElement"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *WriteBatchRawV2RequestElement) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:id: ", p), err)
	}
	if err := oprot.WriteBinary(p.ID); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:id: ", p), err)
	}
	return err
}

func (p *WriteBatchRawV2RequestElement) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("datapoint", thrift.STRUCT, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:datapoint: ", p), err)
	}
	if err := p.Datapoint.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Datapoint), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:datapoint: ", p), err)
	}
	return err
}

func (p *WriteBatchRawV2RequestElement) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:nameSpace: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.NameSpace)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:nameSpace: ", p), err)
	}
	return err
}

func (p *WriteBatchRawV2RequestElement) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WriteBatchRawV2RequestElement(%+v)", *p)
}

// Attributes:
//  - NameSpace
//  - Elements
type WriteTaggedBatchRawRequest struct {
	NameSpace []byte                               `thrift:"nameSpace,1,required" db:"nameSpace" json:"nameSpace"`
	Elements  []*WriteTaggedBatchRawRequestElement `thrift:"elements,2,required" db:"elements" json:"elements"`
}

func NewWriteTaggedBatchRawRequest() *WriteTaggedBatchRawRequest {
	return &WriteTaggedBatchRawRequest{}
}

func (p *WriteTaggedBatchRawRequest) GetNameSpace() []byte {
	return p.NameSpace
}

func (p *WriteTaggedBatchRawRequest) GetElements() []*WriteTaggedBatchRawRequestElement {
	return p.Elements
}
func (p *WriteTaggedBatchRawRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNameSpace bool = false
	var issetElements bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetElements = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	if !issetElements {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Elements is not set"))
	}
	return nil
}

func (p *WriteTaggedBatchRawRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *WriteTaggedBatchRawRequest) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*WriteTaggedBatchRawRequestElement, 0, size)
	p.Elements = tSlice
	for i := 0; i < size; i++ {
		_elem19 := &WriteTaggedBatchRawRequestElement{}
		if err := _elem19.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem19), err)
		}
		p.Elements = append(p.Elements, _elem19)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *WriteTaggedBatchRawRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("WriteTaggedBatchRawRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *WriteTaggedBatchRawRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:nameSpace: ", p), err)
	}
	if err := oprot.WriteBinary(p.NameSpace); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:nameSpace: ", p), err)
	}
	return err
}

func (p *WriteTaggedBatchRawRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("elements", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:elements: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Elements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Elements {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:elements: ", p), err)
	}
	return err
}

func (p *WriteTaggedBatchRawRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WriteTaggedBatchRawRequest(%+v)", *p)
}

// Attributes:
//  - NameSpaces
//  - Elements
type WriteTaggedBatchRawV2Request struct {
	NameSpaces [][]byte                               `thrift:"nameSpaces,1,required" db:"nameSpaces" json:"nameSpaces"`
	Elements   []*WriteTaggedBatchRawV2RequestElement `thrift:"elements,2,required" db:"elements" json:"elements"`
}

func NewWriteTaggedBatchRawV2Request() *WriteTaggedBatchRawV2Request {
	return &WriteTaggedBatchRawV2Request{}
}

func (p *WriteTaggedBatchRawV2Request) GetNameSpaces() [][]byte {
	return p.NameSpaces
}

func (p *WriteTaggedBatchRawV2Request) GetElements() []*WriteTaggedBatchRawV2RequestElement {
	return p.Elements
}
func (p *WriteTaggedBatchRawV2Request) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNameSpaces bool = false
	var issetElements bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNameSpaces = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetElements = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNameSpaces {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpaces is not set"))
	}
	if !issetElements {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Elements is not set"))
	}
	return nil
}

func (p *WriteTaggedBatchRawV2Request) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.NameSpaces = tSlice
	for i := 0; i < size; i++ {
		var _elem20 []byte
		if v, err := iprot.ReadBinary(); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem20 = v
		}
		p.NameSpaces = append(p.NameSpaces, _elem20)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *WriteTaggedBatchRawV2Request) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*WriteTaggedBatchRawV2RequestElement, 0, size)
	p.Elements = tSlice
	for i := 0; i < size; i++ {
		_elem21 := &WriteTaggedBatchRawV2RequestElement{}
		if err := _elem21.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem21), err)
		}
		p.Elements = append(p.Elements, _elem21)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *WriteTaggedBatchRawV2Request) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("WriteTaggedBatchRawV2Request"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *WriteTaggedBatchRawV2Request) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpaces", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:nameSpaces: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRING, len(p.NameSpaces)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.NameSpaces {
		if err := oprot.WriteBinary(v); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:nameSpaces: ", p), err)
	}
	return err
}

func (p *WriteTaggedBatchRawV2Request) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("elements", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:elements: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Elements)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Elements {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:elements: ", p), err)
	}
	return err
}

func (p *WriteTaggedBatchRawV2Request) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WriteTaggedBatchRawV2Request(%+v)", *p)
}

// Attributes:
//  - ID
//  - EncodedTags
//  - Datapoint
type WriteTaggedBatchRawRequestElement struct {
	ID          []byte     `thrift:"id,1,required" db:"id" json:"id"`
	EncodedTags []byte     `thrift:"encodedTags,2,required" db:"encodedTags" json:"encodedTags"`
	Datapoint   *Datapoint `thrift:"datapoint,3,required" db:"datapoint" json:"datapoint"`
}

func NewWriteTaggedBatchRawRequestElement() *WriteTaggedBatchRawRequestElement {
	return &WriteTaggedBatchRawRequestElement{}
}

func (p *WriteTaggedBatchRawRequestElement) GetID() []byte {
	return p.ID
}

func (p *WriteTaggedBatchRawRequestElement) GetEncodedTags() []byte {
	return p.EncodedTags
}

var WriteTaggedBatchRawRequestElement_Datapoint_DEFAULT *Datapoint

func (p *WriteTaggedBatchRawRequestElement) GetDatapoint() *Datapoint {
	if !p.IsSetDatapoint() {
		return WriteTaggedBatchRawRequestElement_Datapoint_DEFAULT
	}
	return p.Datapoint
}
func (p *WriteTaggedBatchRawRequestElement) IsSetDatapoint() bool {
	return p.Datapoint != nil
}

func (p *WriteTaggedBatchRawRequestElement) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetID bool = false
	var issetEncodedTags bool = false
	var issetDatapoint bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetID = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetEncodedTags = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetDatapoint = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	if !issetEncodedTags {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field EncodedTags is not set"))
	}
	if !issetDatapoint {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Datapoint is not set"))
	}
	return nil
}

func (p *WriteTaggedBatchRawRequestElement) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *WriteTaggedBatchRawRequestElement) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.EncodedTags = v
	}
	return nil
}

func (p *WriteTaggedBatchRawRequestElement) ReadField3(iprot thrift.TProtocol) error {
	p.Datapoint = &Datapoint{
		TimestampTimeType: 0,
	}
	if err := p.Datapoint.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Datapoint), err)
	}
	return nil
}

func (p *WriteTaggedBatchRawRequestElement) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("WriteTaggedBatchRawRequestElement"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *WriteTaggedBatchRawRequestElement) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:id: ", p), err)
	}
	if err := oprot.WriteBinary(p.ID); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:id: ", p), err)
	}
	return err
}

func (p *WriteTaggedBatchRawRequestElement) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("encodedTags", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:encodedTags: ", p), err)
	}
	if err := oprot.WriteBinary(p.EncodedTags); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.encodedTags (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:encodedTags: ", p), err)
	}
	return err
}

func (p *WriteTaggedBatchRawRequestElement) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("datapoint", thrift.STRUCT, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:datapoint: ", p), err)
	}
	if err := p.Datapoint.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Datapoint), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:datapoint: ", p), err)
	}
	return err
}

func (p *WriteTaggedBatchRawRequestElement) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WriteTaggedBatchRawRequestElement(%+v)", *p)
}

// Attributes:
//  - ID
//  - EncodedTags
//  - Datapoint
//  - NameSpace
type WriteTaggedBatchRawV2RequestElement struct {
	ID          []byte     `thrift:"id,1,required" db:"id" json:"id"`
	EncodedTags []byte     `thrift:"encodedTags,2,required" db:"encodedTags" json:"encodedTags"`
	Datapoint   *Datapoint `thrift:"datapoint,3,required" db:"datapoint" json:"datapoint"`
	NameSpace   int64      `thrift:"nameSpace,4,required" db:"nameSpace" json:"nameSpace"`
}

func NewWriteTaggedBatchRawV2RequestElement() *WriteTaggedBatchRawV2RequestElement {
	return &WriteTaggedBatchRawV2RequestElement{}
}

func (p *WriteTaggedBatchRawV2RequestElement) GetID() []byte {
	return p.ID
}

func (p *WriteTaggedBatchRawV2RequestElement) GetEncodedTags() []byte {
	return p.EncodedTags
}

var WriteTaggedBatchRawV2RequestElement_Datapoint_DEFAULT *Datapoint

func (p *WriteTaggedBatchRawV2RequestElement) GetDatapoint() *Datapoint {
	if !p.IsSetDatapoint() {
		return WriteTaggedBatchRawV2RequestElement_Datapoint_DEFAULT
	}
	return p.Datapoint
}

func (p *WriteTaggedBatchRawV2RequestElement) GetNameSpace() int64 {
	return p.NameSpace
}
func (p *WriteTaggedBatchRawV2RequestElement) IsSetDatapoint() bool {
	return p.Datapoint != nil
}

func (p *WriteTaggedBatchRawV2RequestElement) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetID bool = false
	var issetEncodedTags bool = false
	var issetDatapoint bool = false
	var issetNameSpace bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetID = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetEncodedTags = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetDatapoint = true
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	if !issetEncodedTags {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field EncodedTags is not set"))
	}
	if !issetDatapoint {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Datapoint is not set"))
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	return nil
}

func (p *WriteTaggedBatchRawV2RequestElement) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *WriteTaggedBatchRawV2RequestElement) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.EncodedTags = v
	}
	return nil
}

func (p *WriteTaggedBatchRawV2RequestElement) ReadField3(iprot thrift.TProtocol) error {
	p.Datapoint = &Datapoint{
		TimestampTimeType: 0,
	}
	if err := p.Datapoint.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Datapoint), err)
	}
	return nil
}

func (p *WriteTaggedBatchRawV2RequestElement) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *WriteTaggedBatchRawV2RequestElement) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("WriteTaggedBatchRawV2RequestElement"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *WriteTaggedBatchRawV2RequestElement) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:id: ", p), err)
	}
	if err := oprot.WriteBinary(p.ID); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:id: ", p), err)
	}
	return err
}

func (p *WriteTaggedBatchRawV2RequestElement) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("encodedTags", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:encodedTags: ", p), err)
	}
	if err := oprot.WriteBinary(p.EncodedTags); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.encodedTags (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:encodedTags: ", p), err)
	}
	return err
}

func (p *WriteTaggedBatchRawV2RequestElement) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("datapoint", thrift.STRUCT, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:datapoint: ", p), err)
	}
	if err := p.Datapoint.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Datapoint), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:datapoint: ", p), err)
	}
	return err
}

func (p *WriteTaggedBatchRawV2RequestElement) writeField4(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.I64, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:nameSpace: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.NameSpace)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:nameSpace: ", p), err)
	}
	return err
}

func (p *WriteTaggedBatchRawV2RequestElement) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WriteTaggedBatchRawV2RequestElement(%+v)", *p)
}

// Attributes:
//  - Index
//  - Err
type WriteBatchRawError struct {
	Index int64  `thrift:"index,1,required" db:"index" json:"index"`
	Err   *Error `thrift:"err,2,required" db:"err" json:"err"`
}

func NewWriteBatchRawError() *WriteBatchRawError {
	return &WriteBatchRawError{}
}

func (p *WriteBatchRawError) GetIndex() int64 {
	return p.Index
}

var WriteBatchRawError_Err_DEFAULT *Error

func (p *WriteBatchRawError) GetErr() *Error {
	if !p.IsSetErr() {
		return WriteBatchRawError_Err_DEFAULT
	}
	return p.Err
}
func (p *WriteBatchRawError) IsSetErr() bool {
	return p.Err != nil
}

func (p *WriteBatchRawError) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetIndex bool = false
	var issetErr bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetIndex = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetErr = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetIndex {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Index is not set"))
	}
	if !issetErr {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Err is not set"))
	}
	return nil
}

func (p *WriteBatchRawError) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Index = v
	}
	return nil
}

func (p *WriteBatchRawError) ReadField2(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *WriteBatchRawError) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("WriteBatchRawError"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *WriteBatchRawError) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("index", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:index: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.Index)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.index (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:index: ", p), err)
	}
	return err
}

func (p *WriteBatchRawError) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:err: ", p), err)
	}
	if err := p.Err.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:err: ", p), err)
	}
	return err
}

func (p *WriteBatchRawError) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WriteBatchRawError(%+v)", *p)
}

// Attributes:
//  - NameSpace
type TruncateRequest struct {
	NameSpace []byte `thrift:"nameSpace,1,required" db:"nameSpace" json:"nameSpace"`
}

func NewTruncateRequest() *TruncateRequest {
	return &TruncateRequest{}
}

func (p *TruncateRequest) GetNameSpace() []byte {
	return p.NameSpace
}
func (p *TruncateRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNameSpace bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	return nil
}

func (p *TruncateRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *TruncateRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("TruncateRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *TruncateRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:nameSpace: ", p), err)
	}
	if err := oprot.WriteBinary(p.NameSpace); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:nameSpace: ", p), err)
	}
	return err
}

func (p *TruncateRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TruncateRequest(%+v)", *p)
}

// Attributes:
//  - NumSeries
type TruncateResult_ struct {
	NumSeries int64 `thrift:"numSeries,1,required" db:"numSeries" json:"numSeries"`
}

func NewTruncateResult_() *TruncateResult_ {
	return &TruncateResult_{}
}

func (p *TruncateResult_) GetNumSeries() int64 {
	return p.NumSeries
}
func (p *TruncateResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetNumSeries bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetNumSeries = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetNumSeries {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NumSeries is not set"))
	}
	return nil
}

func (p *TruncateResult_) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.NumSeries = v
	}
	return nil
}

func (p *TruncateResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("TruncateResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *TruncateResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("numSeries", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:numSeries: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.NumSeries)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.numSeries (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:numSeries: ", p), err)
	}
	return err
}

func (p *TruncateResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TruncateResult_(%+v)", *p)
}

// Attributes:
//  - Ok
//  - Status
//  - Bootstrapped
type NodeHealthResult_ struct {
	Ok           bool   `thrift:"ok,1,required" db:"ok" json:"ok"`
	Status       string `thrift:"status,2,required" db:"status" json:"status"`
	Bootstrapped bool   `thrift:"bootstrapped,3,required" db:"bootstrapped" json:"bootstrapped"`
}

func NewNodeHealthResult_() *NodeHealthResult_ {
	return &NodeHealthResult_{}
}

func (p *NodeHealthResult_) GetOk() bool {
	return p.Ok
}

func (p *NodeHealthResult_) GetStatus() string {
	return p.Status
}

func (p *NodeHealthResult_) GetBootstrapped() bool {
	return p.Bootstrapped
}
func (p *NodeHealthResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetOk bool = false
	var issetStatus bool = false
	var issetBootstrapped bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetOk = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetStatus = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetBootstrapped = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetOk {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Ok is not set"))
	}
	if !issetStatus {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"))
	}
	if !issetBootstrapped {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Bootstrapped is not set"))
	}
	return nil
}

func (p *NodeHealthResult_) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Ok = v
	}
	return nil
}

func (p *NodeHealthResult_) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Status = v
	}
	return nil
}

func (p *NodeHealthResult_) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.Bootstrapped = v
	}
	return nil
}

func (p *NodeHealthResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("NodeHealthResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeHealthResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("ok", thrift.BOOL, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:ok: ", p), err)
	}
	if err := oprot.WriteBool(bool(p.Ok)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.ok (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:ok: ", p), err)
	}
	return err
}

func (p *NodeHealthResult_) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("status", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:status: ", p), err)
	}
	if err := oprot.WriteString(string(p.Status)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.status (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:status: ", p), err)
	}
	return err
}

func (p *NodeHealthResult_) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("bootstrapped", thrift.BOOL, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:bootstrapped: ", p), err)
	}
	if err := oprot.WriteBool(bool(p.Bootstrapped)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.bootstrapped (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:bootstrapped: ", p), err)
	}
	return err
}

func (p *NodeHealthResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeHealthResult_(%+v)", *p)
}

type NodeBootstrappedResult_ struct {
}

func NewNodeBootstrappedResult_() *NodeBootstrappedResult_ {
	return &NodeBootstrappedResult_{}
}

func (p *NodeBootstrappedResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeBootstrappedResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("NodeBootstrappedResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeBootstrappedResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeBootstrappedResult_(%+v)", *p)
}

type NodeBootstrappedInPlacementOrNoPlacementResult_ struct {
}

func NewNodeBootstrappedInPlacementOrNoPlacementResult_() *NodeBootstrappedInPlacementOrNoPlacementResult_ {
	return &NodeBootstrappedInPlacementOrNoPlacementResult_{}
}

func (p *NodeBootstrappedInPlacementOrNoPlacementResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeBootstrappedInPlacementOrNoPlacementResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("NodeBootstrappedInPlacementOrNoPlacementResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeBootstrappedInPlacementOrNoPlacementResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeBootstrappedInPlacementOrNoPlacementResult_(%+v)", *p)
}

// Attributes:
//  - LimitEnabled
//  - LimitMbps
//  - LimitCheckEvery
type NodePersistRateLimitResult_ struct {
	LimitEnabled    bool    `thrift:"limitEnabled,1,required" db:"limitEnabled" json:"limitEnabled"`
	LimitMbps       float64 `thrift:"limitMbps,2,required" db:"limitMbps" json:"limitMbps"`
	LimitCheckEvery int64   `thrift:"limitCheckEvery,3,required" db:"limitCheckEvery" json:"limitCheckEvery"`
}

func NewNodePersistRateLimitResult_() *NodePersistRateLimitResult_ {
	return &NodePersistRateLimitResult_{}
}

func (p *NodePersistRateLimitResult_) GetLimitEnabled() bool {
	return p.LimitEnabled
}

func (p *NodePersistRateLimitResult_) GetLimitMbps() float64 {
	return p.LimitMbps
}

func (p *NodePersistRateLimitResult_) GetLimitCheckEvery() int64 {
	return p.LimitCheckEvery
}
func (p *NodePersistRateLimitResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetLimitEnabled bool = false
	var issetLimitMbps bool = false
	var issetLimitCheckEvery bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetLimitEnabled = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetLimitMbps = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetLimitCheckEvery = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetLimitEnabled {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field LimitEnabled is not set"))
	}
	if !issetLimitMbps {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field LimitMbps is not set"))
	}
	if !issetLimitCheckEvery {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field LimitCheckEvery is not set"))
	}
	return nil
}

func (p *NodePersistRateLimitResult_) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.LimitEnabled = v
	}
	return nil
}

func (p *NodePersistRateLimitResult_) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadDouble(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.LimitMbps = v
	}
	return nil
}

func (p *NodePersistRateLimitResult_) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.LimitCheckEvery = v
	}
	return nil
}

func (p *NodePersistRateLimitResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("NodePersistRateLimitResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodePersistRateLimitResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("limitEnabled", thrift.BOOL, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:limitEnabled: ", p), err)
	}
	if err := oprot.WriteBool(bool(p.LimitEnabled)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.limitEnabled (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:limitEnabled: ", p), err)
	}
	return err
}

func (p *NodePersistRateLimitResult_) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("limitMbps", thrift.DOUBLE, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:limitMbps: ", p), err)
	}
	if err := oprot.WriteDouble(float64(p.LimitMbps)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.limitMbps (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:limitMbps: ", p), err)
	}
	return err
}

func (p *NodePersistRateLimitResult_) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("limitCheckEvery", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:limitCheckEvery: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.LimitCheckEvery)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.limitCheckEvery (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:limitCheckEvery: ", p), err)
	}
	return err
}

func (p *NodePersistRateLimitResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodePersistRateLimitResult_(%+v)", *p)
}

// Attributes:
//  - LimitEnabled
//  - LimitMbps
//  - LimitCheckEvery
type NodeSetPersistRateLimitRequest struct {
	LimitEnabled    *bool    `thrift:"limitEnabled,1" db:"limitEnabled" json:"limitEnabled,omitempty"`
	LimitMbps       *float64 `thrift:"limitMbps,2" db:"limitMbps" json:"limitMbps,omitempty"`
	LimitCheckEvery *int64   `thrift:"limitCheckEvery,3" db:"limitCheckEvery" json:"limitCheckEvery,omitempty"`
}

func NewNodeSetPersistRateLimitRequest() *NodeSetPersistRateLimitRequest {
	return &NodeSetPersistRateLimitRequest{}
}

var NodeSetPersistRateLimitRequest_LimitEnabled_DEFAULT bool

func (p *NodeSetPersistRateLimitRequest) GetLimitEnabled() bool {
	if !p.IsSetLimitEnabled() {
		return NodeSetPersistRateLimitRequest_LimitEnabled_DEFAULT
	}
	return *p.LimitEnabled
}

var NodeSetPersistRateLimitRequest_LimitMbps_DEFAULT float64

func (p *NodeSetPersistRateLimitRequest) GetLimitMbps() float64 {
	if !p.IsSetLimitMbps() {
		return NodeSetPersistRateLimitRequest_LimitMbps_DEFAULT
	}
	return *p.LimitMbps
}

var NodeSetPersistRateLimitRequest_LimitCheckEvery_DEFAULT int64

func (p *NodeSetPersistRateLimitRequest) GetLimitCheckEvery() int64 {
	if !p.IsSetLimitCheckEvery() {
		return NodeSetPersistRateLimitRequest_LimitCheckEvery_DEFAULT
	}
	return *p.LimitCheckEvery
}
func (p *NodeSetPersistRateLimitRequest) IsSetLimitEnabled() bool {
	return p.LimitEnabled != nil
}

func (p *NodeSetPersistRateLimitRequest) IsSetLimitMbps() bool {
	return p.LimitMbps != nil
}

func (p *NodeSetPersistRateLimitRequest) IsSetLimitCheckEvery() bool {
	return p.LimitCheckEvery != nil
}

func (p *NodeSetPersistRateLimitRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeSetPersistRateLimitRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.LimitEnabled = &v
	}
	return nil
}

func (p *NodeSetPersistRateLimitRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadDouble(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.LimitMbps = &v
	}
	return nil
}

func (p *NodeSetPersistRateLimitRequest) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.LimitCheckEvery = &v
	}
	return nil
}

func (p *NodeSetPersistRateLimitRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("NodeSetPersistRateLimitRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeSetPersistRateLimitRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetLimitEnabled() {
		if err := oprot.WriteFieldBegin("limitEnabled", thrift.BOOL, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:limitEnabled: ", p), err)
		}
		if err := oprot.WriteBool(bool(*p.LimitEnabled)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.limitEnabled (1) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:limitEnabled: ", p), err)
		}
	}
	return err
}

func (p *NodeSetPersistRateLimitRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetLimitMbps() {
		if err := oprot.WriteFieldBegin("limitMbps", thrift.DOUBLE, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:limitMbps: ", p), err)
		}
		if err := oprot.WriteDouble(float64(*p.LimitMbps)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.limitMbps (2) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:limitMbps: ", p), err)
		}
	}
	return err
}

func (p *NodeSetPersistRateLimitRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetLimitCheckEvery() {
		if err := oprot.WriteFieldBegin("limitCheckEvery", thrift.I64, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:limitCheckEvery: ", p), err)
		}
		if err := oprot.WriteI64(int64(*p.LimitCheckEvery)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.limitCheckEvery (3) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:limitCheckEvery: ", p), err)
		}
	}
	return err
}

func (p *NodeSetPersistRateLimitRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeSetPersistRateLimitRequest(%+v)", *p)
}

// Attributes:
//  - WriteNewSeriesAsync
type NodeWriteNewSeriesAsyncResult_ struct {
	WriteNewSeriesAsync bool `thrift:"writeNewSeriesAsync,1,required" db:"writeNewSeriesAsync" json:"writeNewSeriesAsync"`
}

func NewNodeWriteNewSeriesAsyncResult_() *NodeWriteNewSeriesAsyncResult_ {
	return &NodeWriteNewSeriesAsyncResult_{}
}

func (p *NodeWriteNewSeriesAsyncResult_) GetWriteNewSeriesAsync() bool {
	return p.WriteNewSeriesAsync
}
func (p *NodeWriteNewSeriesAsyncResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetWriteNewSeriesAsync bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetWriteNewSeriesAsync = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetWriteNewSeriesAsync {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field WriteNewSeriesAsync is not set"))
	}
	return nil
}

func (p *NodeWriteNewSeriesAsyncResult_) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.WriteNewSeriesAsync = v
	}
	return nil
}

func (p *NodeWriteNewSeriesAsyncResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("NodeWriteNewSeriesAsyncResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteNewSeriesAsyncResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("writeNewSeriesAsync", thrift.BOOL, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:writeNewSeriesAsync: ", p), err)
	}
	if err := oprot.WriteBool(bool(p.WriteNewSeriesAsync)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.writeNewSeriesAsync (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:writeNewSeriesAsync: ", p), err)
	}
	return err
}

func (p *NodeWriteNewSeriesAsyncResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteNewSeriesAsyncResult_(%+v)", *p)
}

// Attributes:
//  - WriteNewSeriesAsync
type NodeSetWriteNewSeriesAsyncRequest struct {
	WriteNewSeriesAsync bool `thrift:"writeNewSeriesAsync,1,required" db:"writeNewSeriesAsync" json:"writeNewSeriesAsync"`
}

func NewNodeSetWriteNewSeriesAsyncRequest() *NodeSetWriteNewSeriesAsyncRequest {
	return &NodeSetWriteNewSeriesAsyncRequest{}
}

func (p *NodeSetWriteNewSeriesAsyncRequest) GetWriteNewSeriesAsync() bool {
	return p.WriteNewSeriesAsync
}
func (p *NodeSetWriteNewSeriesAsyncRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetWriteNewSeriesAsync bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetWriteNewSeriesAsync = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetWriteNewSeriesAsync {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field WriteNewSeriesAsync is not set"))
	}
	return nil
}

func (p *NodeSetWriteNewSeriesAsyncRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.WriteNewSeriesAsync = v
	}
	return nil
}

func (p *NodeSetWriteNewSeriesAsyncRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("NodeSetWriteNewSeriesAsyncRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesAsyncRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("writeNewSeriesAsync", thrift.BOOL, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:writeNewSeriesAsync: ", p), err)
	}
	if err := oprot.WriteBool(bool(p.WriteNewSeriesAsync)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.writeNewSeriesAsync (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:writeNewSeriesAsync: ", p), err)
	}
	return err
}

func (p *NodeSetWriteNewSeriesAsyncRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeSetWriteNewSeriesAsyncRequest(%+v)", *p)
}

// Attributes:
//  - WriteNewSeriesBackoffDuration
//  - DurationType
type NodeWriteNewSeriesBackoffDurationResult_ struct {
	WriteNewSeriesBackoffDuration int64    `thrift:"writeNewSeriesBackoffDuration,1,required" db:"writeNewSeriesBackoffDuration" json:"writeNewSeriesBackoffDuration"`
	DurationType                  TimeType `thrift:"durationType,2,required" db:"durationType" json:"durationType"`
}

func NewNodeWriteNewSeriesBackoffDurationResult_() *NodeWriteNewSeriesBackoffDurationResult_ {
	return &NodeWriteNewSeriesBackoffDurationResult_{}
}

func (p *NodeWriteNewSeriesBackoffDurationResult_) GetWriteNewSeriesBackoffDuration() int64 {
	return p.WriteNewSeriesBackoffDuration
}

func (p *NodeWriteNewSeriesBackoffDurationResult_) GetDurationType() TimeType {
	return p.DurationType
}
func (p *NodeWriteNewSeriesBackoffDurationResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetWriteNewSeriesBackoffDuration bool = false
	var issetDurationType bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetWriteNewSeriesBackoffDuration = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetDurationType = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetWriteNewSeriesBackoffDuration {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field WriteNewSeriesBackoffDuration is not set"))
	}
	if !issetDurationType {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DurationType is not set"))
	}
	return nil
}

func (p *NodeWriteNewSeriesBackoffDurationResult_) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.WriteNewSeriesBackoffDuration = v
	}
	return nil
}

func (p *NodeWriteNewSeriesBackoffDurationResult_) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		temp := TimeType(v)
		p.DurationType = temp
	}
	return nil
}

func (p *NodeWriteNewSeriesBackoffDurationResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("NodeWriteNewSeriesBackoffDurationResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteNewSeriesBackoffDurationResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("writeNewSeriesBackoffDuration", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:writeNewSeriesBackoffDuration: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.WriteNewSeriesBackoffDuration)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.writeNewSeriesBackoffDuration (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:writeNewSeriesBackoffDuration: ", p), err)
	}
	return err
}

func (p *NodeWriteNewSeriesBackoffDurationResult_) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("durationType", thrift.I32, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:durationType: ", p), err)
	}
	if err := oprot.WriteI32(int32(p.DurationType)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.durationType (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:durationType: ", p), err)
	}
	return err
}

func (p *NodeWriteNewSeriesBackoffDurationResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteNewSeriesBackoffDurationResult_(%+v)", *p)
}

// Attributes:
//  - WriteNewSeriesBackoffDuration
//  - DurationType
type NodeSetWriteNewSeriesBackoffDurationRequest struct {
	WriteNewSeriesBackoffDuration int64    `thrift:"writeNewSeriesBackoffDuration,1,required" db:"writeNewSeriesBackoffDuration" json:"writeNewSeriesBackoffDuration"`
	DurationType                  TimeType `thrift:"durationType,2" db:"durationType" json:"durationType,omitempty"`
}

func NewNodeSetWriteNewSeriesBackoffDurationRequest() *NodeSetWriteNewSeriesBackoffDurationRequest {
	return &NodeSetWriteNewSeriesBackoffDurationRequest{
		DurationType: 2,
	}
}

func (p *NodeSetWriteNewSeriesBackoffDurationRequest) GetWriteNewSeriesBackoffDuration() int64 {
	return p.WriteNewSeriesBackoffDuration
}

var NodeSetWriteNewSeriesBackoffDurationRequest_DurationType_DEFAULT TimeType = 2

func (p *NodeSetWriteNewSeriesBackoffDurationRequest) GetDurationType() TimeType {
	return p.DurationType
}
func (p *NodeSetWriteNewSeriesBackoffDurationRequest) IsSetDurationType() bool {
	return p.DurationType != NodeSetWriteNewSeriesBackoffDurationRequest_DurationType_DEFAULT
}

func (p *NodeSetWriteNewSeriesBackoffDurationRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetWriteNewSeriesBackoffDuration bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetWriteNewSeriesBackoffDuration = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetWriteNewSeriesBackoffDuration {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field WriteNewSeriesBackoffDuration is not set"))
	}
	return nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.WriteNewSeriesBackoffDuration = v
	}
	return nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		temp := TimeType(v)
		p.DurationType = temp
	}
	return nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("NodeSetWriteNewSeriesBackoffDurationRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("writeNewSeriesBackoffDuration", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:writeNewSeriesBackoffDuration: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.WriteNewSeriesBackoffDuration)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.writeNewSeriesBackoffDuration (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:writeNewSeriesBackoffDuration: ", p), err)
	}
	return err
}

func (p *NodeSetWriteNewSeriesBackoffDurationRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetDurationType() {
		if err := oprot.WriteFieldBegin("durationType", thrift.I32, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:durationType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.DurationType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.durationType (2) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:durationType: ", p), err)
		}
	}
	return err
}

func (p *NodeSetWriteNewSeriesBackoffDurationRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeSetWriteNewSeriesBackoffDurationRequest(%+v)", *p)
}

// Attributes:
//  - WriteNewSeriesLimitPerShardPerSecond
type NodeWriteNewSeriesLimitPerShardPerSecondResult_ struct {
	WriteNewSeriesLimitPerShardPerSecond int64 `thrift:"writeNewSeriesLimitPerShardPerSecond,1,required" db:"writeNewSeriesLimitPerShardPerSecond" json:"writeNewSeriesLimitPerShardPerSecond"`
}

func NewNodeWriteNewSeriesLimitPerShardPerSecondResult_() *NodeWriteNewSeriesLimitPerShardPerSecondResult_ {
	return &NodeWriteNewSeriesLimitPerShardPerSecondResult_{}
}

func (p *NodeWriteNewSeriesLimitPerShardPerSecondResult_) GetWriteNewSeriesLimitPerShardPerSecond() int64 {
	return p.WriteNewSeriesLimitPerShardPerSecond
}
func (p *NodeWriteNewSeriesLimitPerShardPerSecondResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetWriteNewSeriesLimitPerShardPerSecond bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetWriteNewSeriesLimitPerShardPerSecond = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetWriteNewSeriesLimitPerShardPerSecond {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field WriteNewSeriesLimitPerShardPerSecond is not set"))
	}
	return nil
}

func (p *NodeWriteNewSeriesLimitPerShardPerSecondResult_) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.WriteNewSeriesLimitPerShardPerSecond = v
	}
	return nil
}

func (p *NodeWriteNewSeriesLimitPerShardPerSecondResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("NodeWriteNewSeriesLimitPerShardPerSecondResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteNewSeriesLimitPerShardPerSecondResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("writeNewSeriesLimitPerShardPerSecond", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:writeNewSeriesLimitPerShardPerSecond: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.WriteNewSeriesLimitPerShardPerSecond)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.writeNewSeriesLimitPerShardPerSecond (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:writeNewSeriesLimitPerShardPerSecond: ", p), err)
	}
	return err
}

func (p *NodeWriteNewSeriesLimitPerShardPerSecondResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteNewSeriesLimitPerShardPerSecondResult_(%+v)", *p)
}

// Attributes:
//  - WriteNewSeriesLimitPerShardPerSecond
type NodeSetWriteNewSeriesLimitPerShardPerSecondRequest struct {
	WriteNewSeriesLimitPerShardPerSecond int64 `thrift:"writeNewSeriesLimitPerShardPerSecond,1,required" db:"writeNewSeriesLimitPerShardPerSecond" json:"writeNewSeriesLimitPerShardPerSecond"`
}

func NewNodeSetWriteNewSeriesLimitPerShardPerSecondRequest() *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest {
	return &NodeSetWriteNewSeriesLimitPerShardPerSecondRequest{}
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest) GetWriteNewSeriesLimitPerShardPerSecond() int64 {
	return p.WriteNewSeriesLimitPerShardPerSecond
}
func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetWriteNewSeriesLimitPerShardPerSecond bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetWriteNewSeriesLimitPerShardPerSecond = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetWriteNewSeriesLimitPerShardPerSecond {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field WriteNewSeriesLimitPerShardPerSecond is not set"))
	}
	return nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.WriteNewSeriesLimitPerShardPerSecond = v
	}
	return nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("NodeSetWriteNewSeriesLimitPerShardPerSecondRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("writeNewSeriesLimitPerShardPerSecond", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:writeNewSeriesLimitPerShardPerSecond: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.WriteNewSeriesLimitPerShardPerSecond)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.writeNewSeriesLimitPerShardPerSecond (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:writeNewSeriesLimitPerShardPerSecond: ", p), err)
	}
	return err
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeSetWriteNewSeriesLimitPerShardPerSecondRequest(%+v)", *p)
}

// Attributes:
//  - Ok
//  - Status
type HealthResult_ struct {
	Ok     bool   `thrift:"ok,1,required" db:"ok" json:"ok"`
	Status string `thrift:"status,2,required" db:"status" json:"status"`
}

func NewHealthResult_() *HealthResult_ {
	return &HealthResult_{}
}

func (p *HealthResult_) GetOk() bool {
	return p.Ok
}

func (p *HealthResult_) GetStatus() string {
	return p.Status
}
func (p *HealthResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetOk bool = false
	var issetStatus bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetOk = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetStatus = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetOk {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Ok is not set"))
	}
	if !issetStatus {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"))
	}
	return nil
}

func (p *HealthResult_) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Ok = v
	}
	return nil
}

func (p *HealthResult_) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Status = v
	}
	return nil
}

func (p *HealthResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("HealthResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *HealthResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("ok", thrift.BOOL, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:ok: ", p), err)
	}
	if err := oprot.WriteBool(bool(p.Ok)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.ok (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:ok: ", p), err)
	}
	return err
}

func (p *HealthResult_) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("status", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:status: ", p), err)
	}
	if err := oprot.WriteString(string(p.Status)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.status (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:status: ", p), err)
	}
	return err
}

func (p *HealthResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("HealthResult_(%+v)", *p)
}

// Attributes:
//  - Query
//  - RangeStart
//  - RangeEnd
//  - NameSpace
//  - Limit
//  - TagNameFilter
//  - AggregateQueryType
//  - RangeType
type AggregateQueryRawRequest struct {
	Query              []byte             `thrift:"query,1,required" db:"query" json:"query"`
	RangeStart         int64              `thrift:"rangeStart,2,required" db:"rangeStart" json:"rangeStart"`
	RangeEnd           int64              `thrift:"rangeEnd,3,required" db:"rangeEnd" json:"rangeEnd"`
	NameSpace          []byte             `thrift:"nameSpace,4,required" db:"nameSpace" json:"nameSpace"`
	Limit              *int64             `thrift:"limit,5" db:"limit" json:"limit,omitempty"`
	TagNameFilter      [][]byte           `thrift:"tagNameFilter,6" db:"tagNameFilter" json:"tagNameFilter,omitempty"`
	AggregateQueryType AggregateQueryType `thrift:"aggregateQueryType,7" db:"aggregateQueryType" json:"aggregateQueryType,omitempty"`
	RangeType          TimeType           `thrift:"rangeType,8" db:"rangeType" json:"rangeType,omitempty"`
}

func NewAggregateQueryRawRequest() *AggregateQueryRawRequest {
	return &AggregateQueryRawRequest{
		AggregateQueryType: 1,

		RangeType: 0,
	}
}

func (p *AggregateQueryRawRequest) GetQuery() []byte {
	return p.Query
}

func (p *AggregateQueryRawRequest) GetRangeStart() int64 {
	return p.RangeStart
}

func (p *AggregateQueryRawRequest) GetRangeEnd() int64 {
	return p.RangeEnd
}

func (p *AggregateQueryRawRequest) GetNameSpace() []byte {
	return p.NameSpace
}

var AggregateQueryRawRequest_Limit_DEFAULT int64

func (p *AggregateQueryRawRequest) GetLimit() int64 {
	if !p.IsSetLimit() {
		return AggregateQueryRawRequest_Limit_DEFAULT
	}
	return *p.Limit
}

var AggregateQueryRawRequest_TagNameFilter_DEFAULT [][]byte

func (p *AggregateQueryRawRequest) GetTagNameFilter() [][]byte {
	return p.TagNameFilter
}

var AggregateQueryRawRequest_AggregateQueryType_DEFAULT AggregateQueryType = 1

func (p *AggregateQueryRawRequest) GetAggregateQueryType() AggregateQueryType {
	return p.AggregateQueryType
}

var AggregateQueryRawRequest_RangeType_DEFAULT TimeType = 0

func (p *AggregateQueryRawRequest) GetRangeType() TimeType {
	return p.RangeType
}
func (p *AggregateQueryRawRequest) IsSetLimit() bool {
	return p.Limit != nil
}

func (p *AggregateQueryRawRequest) IsSetTagNameFilter() bool {
	return p.TagNameFilter != nil
}

func (p *AggregateQueryRawRequest) IsSetAggregateQueryType() bool {
	return p.AggregateQueryType != AggregateQueryRawRequest_AggregateQueryType_DEFAULT
}

func (p *AggregateQueryRawRequest) IsSetRangeType() bool {
	return p.RangeType != AggregateQueryRawRequest_RangeType_DEFAULT
}

func (p *AggregateQueryRawRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetQuery bool = false
	var issetRangeStart bool = false
	var issetRangeEnd bool = false
	var issetNameSpace bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetQuery = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetRangeStart = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetRangeEnd = true
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 5:
			if err := p.ReadField5(iprot); err != nil {
				return err
			}
		case 6:
			if err := p.ReadField6(iprot); err != nil {
				return err
			}
		case 7:
			if err := p.ReadField7(iprot); err != nil {
				return err
			}
		case 8:
			if err := p.ReadField8(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetQuery {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Query is not set"))
	}
	if !issetRangeStart {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeStart is not set"))
	}
	if !issetRangeEnd {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeEnd is not set"))
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	return nil
}

func (p *AggregateQueryRawRequest) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Query = v
	}
	return nil
}

func (p *AggregateQueryRawRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.RangeStart = v
	}
	return nil
}

func (p *AggregateQueryRawRequest) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.RangeEnd = v
	}
	return nil
}

func (p *AggregateQueryRawRequest) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *AggregateQueryRawRequest) ReadField5(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.Limit = &v
	}
	return nil
}

func (p *AggregateQueryRawRequest) ReadField6(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([][]byte, 0, size)
	p.TagNameFilter = tSlice
	for i := 0; i < size; i++ {
		var _elem22 []byte
		if v, err := iprot.ReadBinary(); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem22 = v
		}
		p.TagNameFilter = append(p.TagNameFilter, _elem22)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *AggregateQueryRawRequest) ReadField7(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		temp := AggregateQueryType(v)
		p.AggregateQueryType = temp
	}
	return nil
}

func (p *AggregateQueryRawRequest) ReadField8(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 8: ", err)
	} else {
		temp := TimeType(v)
		p.RangeType = temp
	}
	return nil
}

func (p *AggregateQueryRawRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("AggregateQueryRawRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
		if err := p.writeField5(oprot); err != nil {
			return err
		}
		if err := p.writeField6(oprot); err != nil {
			return err
		}
		if err := p.writeField7(oprot); err != nil {
			return err
		}
		if err := p.writeField8(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AggregateQueryRawRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("query", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:query: ", p), err)
	}
	if err := oprot.WriteBinary(p.Query); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.query (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:query: ", p), err)
	}
	return err
}

func (p *AggregateQueryRawRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeStart", thrift.I64, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:rangeStart: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeStart)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeStart (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:rangeStart: ", p), err)
	}
	return err
}

func (p *AggregateQueryRawRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeEnd", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:rangeEnd: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeEnd)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeEnd (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:rangeEnd: ", p), err)
	}
	return err
}

func (p *AggregateQueryRawRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:nameSpace: ", p), err)
	}
	if err := oprot.WriteBinary(p.NameSpace); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:nameSpace: ", p), err)
	}
	return err
}

func (p *AggregateQueryRawRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetLimit() {
		if err := oprot.WriteFieldBegin("limit", thrift.I64, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:limit: ", p), err)
		}
		if err := oprot.WriteI64(int64(*p.Limit)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.limit (5) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:limit: ", p), err)
		}
	}
	return err
}

func (p *AggregateQueryRawRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetTagNameFilter() {
		if err := oprot.WriteFieldBegin("tagNameFilter", thrift.LIST, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:tagNameFilter: ", p), err)
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.TagNameFilter)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.TagNameFilter {
			if err := oprot.WriteBinary(v); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:tagNameFilter: ", p), err)
		}
	}
	return err
}

func (p *AggregateQueryRawRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetAggregateQueryType() {
		if err := oprot.WriteFieldBegin("aggregateQueryType", thrift.I32, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:aggregateQueryType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.AggregateQueryType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.aggregateQueryType (7) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:aggregateQueryType: ", p), err)
		}
	}
	return err
}

func (p *AggregateQueryRawRequest) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetRangeType() {
		if err := oprot.WriteFieldBegin("rangeType", thrift.I32, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:rangeType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.RangeType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.rangeType (8) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:rangeType: ", p), err)
		}
	}
	return err
}

func (p *AggregateQueryRawRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AggregateQueryRawRequest(%+v)", *p)
}

// Attributes:
//  - Results
//  - Exhaustive
type AggregateQueryRawResult_ struct {
	Results    []*AggregateQueryRawResultTagNameElement `thrift:"results,1,required" db:"results" json:"results"`
	Exhaustive bool                                     `thrift:"exhaustive,2,required" db:"exhaustive" json:"exhaustive"`
}

func NewAggregateQueryRawResult_() *AggregateQueryRawResult_ {
	return &AggregateQueryRawResult_{}
}

func (p *AggregateQueryRawResult_) GetResults() []*AggregateQueryRawResultTagNameElement {
	return p.Results
}

func (p *AggregateQueryRawResult_) GetExhaustive() bool {
	return p.Exhaustive
}
func (p *AggregateQueryRawResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetResults bool = false
	var issetExhaustive bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetResults = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetExhaustive = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetResults {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Results is not set"))
	}
	if !issetExhaustive {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Exhaustive is not set"))
	}
	return nil
}

func (p *AggregateQueryRawResult_) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*AggregateQueryRawResultTagNameElement, 0, size)
	p.Results = tSlice
	for i := 0; i < size; i++ {
		_elem23 := &AggregateQueryRawResultTagNameElement{}
		if err := _elem23.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem23), err)
		}
		p.Results = append(p.Results, _elem23)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *AggregateQueryRawResult_) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Exhaustive = v
	}
	return nil
}

func (p *AggregateQueryRawResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("AggregateQueryRawResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AggregateQueryRawResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("results", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:results: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Results)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Results {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:results: ", p), err)
	}
	return err
}

func (p *AggregateQueryRawResult_) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("exhaustive", thrift.BOOL, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:exhaustive: ", p), err)
	}
	if err := oprot.WriteBool(bool(p.Exhaustive)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.exhaustive (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:exhaustive: ", p), err)
	}
	return err
}

func (p *AggregateQueryRawResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AggregateQueryRawResult_(%+v)", *p)
}

// Attributes:
//  - TagName
//  - TagValues
type AggregateQueryRawResultTagNameElement struct {
	TagName   []byte                                    `thrift:"tagName,1,required" db:"tagName" json:"tagName"`
	TagValues []*AggregateQueryRawResultTagValueElement `thrift:"tagValues,2" db:"tagValues" json:"tagValues,omitempty"`
}

func NewAggregateQueryRawResultTagNameElement() *AggregateQueryRawResultTagNameElement {
	return &AggregateQueryRawResultTagNameElement{}
}

func (p *AggregateQueryRawResultTagNameElement) GetTagName() []byte {
	return p.TagName
}

var AggregateQueryRawResultTagNameElement_TagValues_DEFAULT []*AggregateQueryRawResultTagValueElement

func (p *AggregateQueryRawResultTagNameElement) GetTagValues() []*AggregateQueryRawResultTagValueElement {
	return p.TagValues
}
func (p *AggregateQueryRawResultTagNameElement) IsSetTagValues() bool {
	return p.TagValues != nil
}

func (p *AggregateQueryRawResultTagNameElement) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetTagName bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetTagName = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetTagName {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TagName is not set"))
	}
	return nil
}

func (p *AggregateQueryRawResultTagNameElement) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.TagName = v
	}
	return nil
}

func (p *AggregateQueryRawResultTagNameElement) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*AggregateQueryRawResultTagValueElement, 0, size)
	p.TagValues = tSlice
	for i := 0; i < size; i++ {
		_elem24 := &AggregateQueryRawResultTagValueElement{}
		if err := _elem24.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem24), err)
		}
		p.TagValues = append(p.TagValues, _elem24)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *AggregateQueryRawResultTagNameElement) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("AggregateQueryRawResultTagNameElement"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AggregateQueryRawResultTagNameElement) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("tagName", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:tagName: ", p), err)
	}
	if err := oprot.WriteBinary(p.TagName); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.tagName (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:tagName: ", p), err)
	}
	return err
}

func (p *AggregateQueryRawResultTagNameElement) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetTagValues() {
		if err := oprot.WriteFieldBegin("tagValues", thrift.LIST, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:tagValues: ", p), err)
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.TagValues)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.TagValues {
			if err := v.Write(oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:tagValues: ", p), err)
		}
	}
	return err
}

func (p *AggregateQueryRawResultTagNameElement) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AggregateQueryRawResultTagNameElement(%+v)", *p)
}

// Attributes:
//  - TagValue
type AggregateQueryRawResultTagValueElement struct {
	TagValue []byte `thrift:"tagValue,1,required" db:"tagValue" json:"tagValue"`
}

func NewAggregateQueryRawResultTagValueElement() *AggregateQueryRawResultTagValueElement {
	return &AggregateQueryRawResultTagValueElement{}
}

func (p *AggregateQueryRawResultTagValueElement) GetTagValue() []byte {
	return p.TagValue
}
func (p *AggregateQueryRawResultTagValueElement) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetTagValue bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetTagValue = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetTagValue {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TagValue is not set"))
	}
	return nil
}

func (p *AggregateQueryRawResultTagValueElement) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBinary(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.TagValue = v
	}
	return nil
}

func (p *AggregateQueryRawResultTagValueElement) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("AggregateQueryRawResultTagValueElement"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AggregateQueryRawResultTagValueElement) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("tagValue", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:tagValue: ", p), err)
	}
	if err := oprot.WriteBinary(p.TagValue); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.tagValue (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:tagValue: ", p), err)
	}
	return err
}

func (p *AggregateQueryRawResultTagValueElement) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AggregateQueryRawResultTagValueElement(%+v)", *p)
}

// Attributes:
//  - Query
//  - RangeStart
//  - RangeEnd
//  - NameSpace
//  - Limit
//  - TagNameFilter
//  - AggregateQueryType
//  - RangeType
type AggregateQueryRequest struct {
	Query              *Query             `thrift:"query,1" db:"query" json:"query,omitempty"`
	RangeStart         int64              `thrift:"rangeStart,2,required" db:"rangeStart" json:"rangeStart"`
	RangeEnd           int64              `thrift:"rangeEnd,3,required" db:"rangeEnd" json:"rangeEnd"`
	NameSpace          string             `thrift:"nameSpace,4,required" db:"nameSpace" json:"nameSpace"`
	Limit              *int64             `thrift:"limit,5" db:"limit" json:"limit,omitempty"`
	TagNameFilter      []string           `thrift:"tagNameFilter,6" db:"tagNameFilter" json:"tagNameFilter,omitempty"`
	AggregateQueryType AggregateQueryType `thrift:"aggregateQueryType,7" db:"aggregateQueryType" json:"aggregateQueryType,omitempty"`
	RangeType          TimeType           `thrift:"rangeType,8" db:"rangeType" json:"rangeType,omitempty"`
}

func NewAggregateQueryRequest() *AggregateQueryRequest {
	return &AggregateQueryRequest{
		AggregateQueryType: 1,

		RangeType: 0,
	}
}

var AggregateQueryRequest_Query_DEFAULT *Query

func (p *AggregateQueryRequest) GetQuery() *Query {
	if !p.IsSetQuery() {
		return AggregateQueryRequest_Query_DEFAULT
	}
	return p.Query
}

func (p *AggregateQueryRequest) GetRangeStart() int64 {
	return p.RangeStart
}

func (p *AggregateQueryRequest) GetRangeEnd() int64 {
	return p.RangeEnd
}

func (p *AggregateQueryRequest) GetNameSpace() string {
	return p.NameSpace
}

var AggregateQueryRequest_Limit_DEFAULT int64

func (p *AggregateQueryRequest) GetLimit() int64 {
	if !p.IsSetLimit() {
		return AggregateQueryRequest_Limit_DEFAULT
	}
	return *p.Limit
}

var AggregateQueryRequest_TagNameFilter_DEFAULT []string

func (p *AggregateQueryRequest) GetTagNameFilter() []string {
	return p.TagNameFilter
}

var AggregateQueryRequest_AggregateQueryType_DEFAULT AggregateQueryType = 1

func (p *AggregateQueryRequest) GetAggregateQueryType() AggregateQueryType {
	return p.AggregateQueryType
}

var AggregateQueryRequest_RangeType_DEFAULT TimeType = 0

func (p *AggregateQueryRequest) GetRangeType() TimeType {
	return p.RangeType
}
func (p *AggregateQueryRequest) IsSetQuery() bool {
	return p.Query != nil
}

func (p *AggregateQueryRequest) IsSetLimit() bool {
	return p.Limit != nil
}

func (p *AggregateQueryRequest) IsSetTagNameFilter() bool {
	return p.TagNameFilter != nil
}

func (p *AggregateQueryRequest) IsSetAggregateQueryType() bool {
	return p.AggregateQueryType != AggregateQueryRequest_AggregateQueryType_DEFAULT
}

func (p *AggregateQueryRequest) IsSetRangeType() bool {
	return p.RangeType != AggregateQueryRequest_RangeType_DEFAULT
}

func (p *AggregateQueryRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetRangeStart bool = false
	var issetRangeEnd bool = false
	var issetNameSpace bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetRangeStart = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetRangeEnd = true
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 5:
			if err := p.ReadField5(iprot); err != nil {
				return err
			}
		case 6:
			if err := p.ReadField6(iprot); err != nil {
				return err
			}
		case 7:
			if err := p.ReadField7(iprot); err != nil {
				return err
			}
		case 8:
			if err := p.ReadField8(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetRangeStart {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeStart is not set"))
	}
	if !issetRangeEnd {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeEnd is not set"))
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	return nil
}

func (p *AggregateQueryRequest) ReadField1(iprot thrift.TProtocol) error {
	p.Query = &Query{}
	if err := p.Query.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Query), err)
	}
	return nil
}

func (p *AggregateQueryRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.RangeStart = v
	}
	return nil
}

func (p *AggregateQueryRequest) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.RangeEnd = v
	}
	return nil
}

func (p *AggregateQueryRequest) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *AggregateQueryRequest) ReadField5(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.Limit = &v
	}
	return nil
}

func (p *AggregateQueryRequest) ReadField6(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]string, 0, size)
	p.TagNameFilter = tSlice
	for i := 0; i < size; i++ {
		var _elem25 string
		if v, err := iprot.ReadString(); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_elem25 = v
		}
		p.TagNameFilter = append(p.TagNameFilter, _elem25)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *AggregateQueryRequest) ReadField7(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		temp := AggregateQueryType(v)
		p.AggregateQueryType = temp
	}
	return nil
}

func (p *AggregateQueryRequest) ReadField8(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 8: ", err)
	} else {
		temp := TimeType(v)
		p.RangeType = temp
	}
	return nil
}

func (p *AggregateQueryRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("AggregateQueryRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
		if err := p.writeField5(oprot); err != nil {
			return err
		}
		if err := p.writeField6(oprot); err != nil {
			return err
		}
		if err := p.writeField7(oprot); err != nil {
			return err
		}
		if err := p.writeField8(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AggregateQueryRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetQuery() {
		if err := oprot.WriteFieldBegin("query", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:query: ", p), err)
		}
		if err := p.Query.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Query), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:query: ", p), err)
		}
	}
	return err
}

func (p *AggregateQueryRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeStart", thrift.I64, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:rangeStart: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeStart)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeStart (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:rangeStart: ", p), err)
	}
	return err
}

func (p *AggregateQueryRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeEnd", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:rangeEnd: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeEnd)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeEnd (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:rangeEnd: ", p), err)
	}
	return err
}

func (p *AggregateQueryRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:nameSpace: ", p), err)
	}
	if err := oprot.WriteString(string(p.NameSpace)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:nameSpace: ", p), err)
	}
	return err
}

func (p *AggregateQueryRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetLimit() {
		if err := oprot.WriteFieldBegin("limit", thrift.I64, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:limit: ", p), err)
		}
		if err := oprot.WriteI64(int64(*p.Limit)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.limit (5) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:limit: ", p), err)
		}
	}
	return err
}

func (p *AggregateQueryRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetTagNameFilter() {
		if err := oprot.WriteFieldBegin("tagNameFilter", thrift.LIST, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:tagNameFilter: ", p), err)
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.TagNameFilter)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.TagNameFilter {
			if err := oprot.WriteString(string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:tagNameFilter: ", p), err)
		}
	}
	return err
}

func (p *AggregateQueryRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetAggregateQueryType() {
		if err := oprot.WriteFieldBegin("aggregateQueryType", thrift.I32, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:aggregateQueryType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.AggregateQueryType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.aggregateQueryType (7) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:aggregateQueryType: ", p), err)
		}
	}
	return err
}

func (p *AggregateQueryRequest) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetRangeType() {
		if err := oprot.WriteFieldBegin("rangeType", thrift.I32, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:rangeType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.RangeType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.rangeType (8) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:rangeType: ", p), err)
		}
	}
	return err
}

func (p *AggregateQueryRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AggregateQueryRequest(%+v)", *p)
}

// Attributes:
//  - Results
//  - Exhaustive
type AggregateQueryResult_ struct {
	Results    []*AggregateQueryResultTagNameElement `thrift:"results,1,required" db:"results" json:"results"`
	Exhaustive bool                                  `thrift:"exhaustive,2,required" db:"exhaustive" json:"exhaustive"`
}

func NewAggregateQueryResult_() *AggregateQueryResult_ {
	return &AggregateQueryResult_{}
}

func (p *AggregateQueryResult_) GetResults() []*AggregateQueryResultTagNameElement {
	return p.Results
}

func (p *AggregateQueryResult_) GetExhaustive() bool {
	return p.Exhaustive
}
func (p *AggregateQueryResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetResults bool = false
	var issetExhaustive bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetResults = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetExhaustive = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetResults {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Results is not set"))
	}
	if !issetExhaustive {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Exhaustive is not set"))
	}
	return nil
}

func (p *AggregateQueryResult_) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*AggregateQueryResultTagNameElement, 0, size)
	p.Results = tSlice
	for i := 0; i < size; i++ {
		_elem26 := &AggregateQueryResultTagNameElement{}
		if err := _elem26.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem26), err)
		}
		p.Results = append(p.Results, _elem26)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *AggregateQueryResult_) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Exhaustive = v
	}
	return nil
}

func (p *AggregateQueryResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("AggregateQueryResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AggregateQueryResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("results", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:results: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Results)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Results {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:results: ", p), err)
	}
	return err
}

func (p *AggregateQueryResult_) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("exhaustive", thrift.BOOL, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:exhaustive: ", p), err)
	}
	if err := oprot.WriteBool(bool(p.Exhaustive)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.exhaustive (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:exhaustive: ", p), err)
	}
	return err
}

func (p *AggregateQueryResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AggregateQueryResult_(%+v)", *p)
}

// Attributes:
//  - TagName
//  - TagValues
type AggregateQueryResultTagNameElement struct {
	TagName   string                                 `thrift:"tagName,1,required" db:"tagName" json:"tagName"`
	TagValues []*AggregateQueryResultTagValueElement `thrift:"tagValues,2" db:"tagValues" json:"tagValues,omitempty"`
}

func NewAggregateQueryResultTagNameElement() *AggregateQueryResultTagNameElement {
	return &AggregateQueryResultTagNameElement{}
}

func (p *AggregateQueryResultTagNameElement) GetTagName() string {
	return p.TagName
}

var AggregateQueryResultTagNameElement_TagValues_DEFAULT []*AggregateQueryResultTagValueElement

func (p *AggregateQueryResultTagNameElement) GetTagValues() []*AggregateQueryResultTagValueElement {
	return p.TagValues
}
func (p *AggregateQueryResultTagNameElement) IsSetTagValues() bool {
	return p.TagValues != nil
}

func (p *AggregateQueryResultTagNameElement) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetTagName bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetTagName = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetTagName {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TagName is not set"))
	}
	return nil
}

func (p *AggregateQueryResultTagNameElement) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.TagName = v
	}
	return nil
}

func (p *AggregateQueryResultTagNameElement) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*AggregateQueryResultTagValueElement, 0, size)
	p.TagValues = tSlice
	for i := 0; i < size; i++ {
		_elem27 := &AggregateQueryResultTagValueElement{}
		if err := _elem27.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem27), err)
		}
		p.TagValues = append(p.TagValues, _elem27)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *AggregateQueryResultTagNameElement) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("AggregateQueryResultTagNameElement"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AggregateQueryResultTagNameElement) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("tagName", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:tagName: ", p), err)
	}
	if err := oprot.WriteString(string(p.TagName)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.tagName (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:tagName: ", p), err)
	}
	return err
}

func (p *AggregateQueryResultTagNameElement) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetTagValues() {
		if err := oprot.WriteFieldBegin("tagValues", thrift.LIST, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:tagValues: ", p), err)
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.TagValues)); err != nil {
			return thrift.PrependError("error writing list begin: ", err)
		}
		for _, v := range p.TagValues {
			if err := v.Write(oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return thrift.PrependError("error writing list end: ", err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:tagValues: ", p), err)
		}
	}
	return err
}

func (p *AggregateQueryResultTagNameElement) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AggregateQueryResultTagNameElement(%+v)", *p)
}

// Attributes:
//  - TagValue
type AggregateQueryResultTagValueElement struct {
	TagValue string `thrift:"tagValue,1,required" db:"tagValue" json:"tagValue"`
}

func NewAggregateQueryResultTagValueElement() *AggregateQueryResultTagValueElement {
	return &AggregateQueryResultTagValueElement{}
}

func (p *AggregateQueryResultTagValueElement) GetTagValue() string {
	return p.TagValue
}
func (p *AggregateQueryResultTagValueElement) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetTagValue bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetTagValue = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetTagValue {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TagValue is not set"))
	}
	return nil
}

func (p *AggregateQueryResultTagValueElement) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.TagValue = v
	}
	return nil
}

func (p *AggregateQueryResultTagValueElement) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("AggregateQueryResultTagValueElement"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AggregateQueryResultTagValueElement) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("tagValue", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:tagValue: ", p), err)
	}
	if err := oprot.WriteString(string(p.TagValue)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.tagValue (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:tagValue: ", p), err)
	}
	return err
}

func (p *AggregateQueryResultTagValueElement) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AggregateQueryResultTagValueElement(%+v)", *p)
}

// Attributes:
//  - Query
//  - RangeStart
//  - RangeEnd
//  - NameSpace
//  - Limit
//  - NoData
//  - RangeType
//  - ResultTimeType
type QueryRequest struct {
	Query          *Query   `thrift:"query,1,required" db:"query" json:"query"`
	RangeStart     int64    `thrift:"rangeStart,2,required" db:"rangeStart" json:"rangeStart"`
	RangeEnd       int64    `thrift:"rangeEnd,3,required" db:"rangeEnd" json:"rangeEnd"`
	NameSpace      string   `thrift:"nameSpace,4,required" db:"nameSpace" json:"nameSpace"`
	Limit          *int64   `thrift:"limit,5" db:"limit" json:"limit,omitempty"`
	NoData         *bool    `thrift:"noData,6" db:"noData" json:"noData,omitempty"`
	RangeType      TimeType `thrift:"rangeType,7" db:"rangeType" json:"rangeType,omitempty"`
	ResultTimeType TimeType `thrift:"resultTimeType,8" db:"resultTimeType" json:"resultTimeType,omitempty"`
}

func NewQueryRequest() *QueryRequest {
	return &QueryRequest{
		RangeType: 0,

		ResultTimeType: 0,
	}
}

var QueryRequest_Query_DEFAULT *Query

func (p *QueryRequest) GetQuery() *Query {
	if !p.IsSetQuery() {
		return QueryRequest_Query_DEFAULT
	}
	return p.Query
}

func (p *QueryRequest) GetRangeStart() int64 {
	return p.RangeStart
}

func (p *QueryRequest) GetRangeEnd() int64 {
	return p.RangeEnd
}

func (p *QueryRequest) GetNameSpace() string {
	return p.NameSpace
}

var QueryRequest_Limit_DEFAULT int64

func (p *QueryRequest) GetLimit() int64 {
	if !p.IsSetLimit() {
		return QueryRequest_Limit_DEFAULT
	}
	return *p.Limit
}

var QueryRequest_NoData_DEFAULT bool

func (p *QueryRequest) GetNoData() bool {
	if !p.IsSetNoData() {
		return QueryRequest_NoData_DEFAULT
	}
	return *p.NoData
}

var QueryRequest_RangeType_DEFAULT TimeType = 0

func (p *QueryRequest) GetRangeType() TimeType {
	return p.RangeType
}

var QueryRequest_ResultTimeType_DEFAULT TimeType = 0

func (p *QueryRequest) GetResultTimeType() TimeType {
	return p.ResultTimeType
}
func (p *QueryRequest) IsSetQuery() bool {
	return p.Query != nil
}

func (p *QueryRequest) IsSetLimit() bool {
	return p.Limit != nil
}

func (p *QueryRequest) IsSetNoData() bool {
	return p.NoData != nil
}

func (p *QueryRequest) IsSetRangeType() bool {
	return p.RangeType != QueryRequest_RangeType_DEFAULT
}

func (p *QueryRequest) IsSetResultTimeType() bool {
	return p.ResultTimeType != QueryRequest_ResultTimeType_DEFAULT
}

func (p *QueryRequest) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetQuery bool = false
	var issetRangeStart bool = false
	var issetRangeEnd bool = false
	var issetNameSpace bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetQuery = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetRangeStart = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetRangeEnd = true
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
			issetNameSpace = true
		case 5:
			if err := p.ReadField5(iprot); err != nil {
				return err
			}
		case 6:
			if err := p.ReadField6(iprot); err != nil {
				return err
			}
		case 7:
			if err := p.ReadField7(iprot); err != nil {
				return err
			}
		case 8:
			if err := p.ReadField8(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetQuery {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Query is not set"))
	}
	if !issetRangeStart {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeStart is not set"))
	}
	if !issetRangeEnd {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field RangeEnd is not set"))
	}
	if !issetNameSpace {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field NameSpace is not set"))
	}
	return nil
}

func (p *QueryRequest) ReadField1(iprot thrift.TProtocol) error {
	p.Query = &Query{}
	if err := p.Query.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Query), err)
	}
	return nil
}

func (p *QueryRequest) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.RangeStart = v
	}
	return nil
}

func (p *QueryRequest) ReadField3(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.RangeEnd = v
	}
	return nil
}

func (p *QueryRequest) ReadField4(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.NameSpace = v
	}
	return nil
}

func (p *QueryRequest) ReadField5(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(); err != nil {
		return thrift.PrependError("error reading field 5: ", err)
	} else {
		p.Limit = &v
	}
	return nil
}

func (p *QueryRequest) ReadField6(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 6: ", err)
	} else {
		p.NoData = &v
	}
	return nil
}

func (p *QueryRequest) ReadField7(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 7: ", err)
	} else {
		temp := TimeType(v)
		p.RangeType = temp
	}
	return nil
}

func (p *QueryRequest) ReadField8(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(); err != nil {
		return thrift.PrependError("error reading field 8: ", err)
	} else {
		temp := TimeType(v)
		p.ResultTimeType = temp
	}
	return nil
}

func (p *QueryRequest) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("QueryRequest"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
		if err := p.writeField5(oprot); err != nil {
			return err
		}
		if err := p.writeField6(oprot); err != nil {
			return err
		}
		if err := p.writeField7(oprot); err != nil {
			return err
		}
		if err := p.writeField8(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *QueryRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("query", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:query: ", p), err)
	}
	if err := p.Query.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Query), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:query: ", p), err)
	}
	return err
}

func (p *QueryRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeStart", thrift.I64, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:rangeStart: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeStart)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeStart (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:rangeStart: ", p), err)
	}
	return err
}

func (p *QueryRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("rangeEnd", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:rangeEnd: ", p), err)
	}
	if err := oprot.WriteI64(int64(p.RangeEnd)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.rangeEnd (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:rangeEnd: ", p), err)
	}
	return err
}

func (p *QueryRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("nameSpace", thrift.STRING, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:nameSpace: ", p), err)
	}
	if err := oprot.WriteString(string(p.NameSpace)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.nameSpace (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:nameSpace: ", p), err)
	}
	return err
}

func (p *QueryRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetLimit() {
		if err := oprot.WriteFieldBegin("limit", thrift.I64, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:limit: ", p), err)
		}
		if err := oprot.WriteI64(int64(*p.Limit)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.limit (5) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:limit: ", p), err)
		}
	}
	return err
}

func (p *QueryRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetNoData() {
		if err := oprot.WriteFieldBegin("noData", thrift.BOOL, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:noData: ", p), err)
		}
		if err := oprot.WriteBool(bool(*p.NoData)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.noData (6) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:noData: ", p), err)
		}
	}
	return err
}

func (p *QueryRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetRangeType() {
		if err := oprot.WriteFieldBegin("rangeType", thrift.I32, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:rangeType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.RangeType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.rangeType (7) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:rangeType: ", p), err)
		}
	}
	return err
}

func (p *QueryRequest) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetResultTimeType() {
		if err := oprot.WriteFieldBegin("resultTimeType", thrift.I32, 8); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:resultTimeType: ", p), err)
		}
		if err := oprot.WriteI32(int32(p.ResultTimeType)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T.resultTimeType (8) field write error: ", p), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 8:resultTimeType: ", p), err)
		}
	}
	return err
}

func (p *QueryRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("QueryRequest(%+v)", *p)
}

// Attributes:
//  - Results
//  - Exhaustive
type QueryResult_ struct {
	Results    []*QueryResultElement `thrift:"results,1,required" db:"results" json:"results"`
	Exhaustive bool                  `thrift:"exhaustive,2,required" db:"exhaustive" json:"exhaustive"`
}

func NewQueryResult_() *QueryResult_ {
	return &QueryResult_{}
}

func (p *QueryResult_) GetResults() []*QueryResultElement {
	return p.Results
}

func (p *QueryResult_) GetExhaustive() bool {
	return p.Exhaustive
}
func (p *QueryResult_) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetResults bool = false
	var issetExhaustive bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetResults = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetExhaustive = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetResults {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Results is not set"))
	}
	if !issetExhaustive {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Exhaustive is not set"))
	}
	return nil
}

func (p *QueryResult_) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*QueryResultElement, 0, size)
	p.Results = tSlice
	for i := 0; i < size; i++ {
		_elem28 := &QueryResultElement{}
		if err := _elem28.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem28), err)
		}
		p.Results = append(p.Results, _elem28)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *QueryResult_) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadBool(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Exhaustive = v
	}
	return nil
}

func (p *QueryResult_) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("QueryResult"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *QueryResult_) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("results", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:results: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Results)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Results {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:results: ", p), err)
	}
	return err
}

func (p *QueryResult_) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("exhaustive", thrift.BOOL, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:exhaustive: ", p), err)
	}
	if err := oprot.WriteBool(bool(p.Exhaustive)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.exhaustive (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:exhaustive: ", p), err)
	}
	return err
}

func (p *QueryResult_) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("QueryResult_(%+v)", *p)
}

// Attributes:
//  - ID
//  - Tags
//  - Datapoints
type QueryResultElement struct {
	ID         string       `thrift:"id,1,required" db:"id" json:"id"`
	Tags       []*Tag       `thrift:"tags,2,required" db:"tags" json:"tags"`
	Datapoints []*Datapoint `thrift:"datapoints,3,required" db:"datapoints" json:"datapoints"`
}

func NewQueryResultElement() *QueryResultElement {
	return &QueryResultElement{}
}

func (p *QueryResultElement) GetID() string {
	return p.ID
}

func (p *QueryResultElement) GetTags() []*Tag {
	return p.Tags
}

func (p *QueryResultElement) GetDatapoints() []*Datapoint {
	return p.Datapoints
}
func (p *QueryResultElement) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetID bool = false
	var issetTags bool = false
	var issetDatapoints bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetID = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetTags = true
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
			issetDatapoints = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetID {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ID is not set"))
	}
	if !issetTags {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Tags is not set"))
	}
	if !issetDatapoints {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Datapoints is not set"))
	}
	return nil
}

func (p *QueryResultElement) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.ID = v
	}
	return nil
}

func (p *QueryResultElement) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*Tag, 0, size)
	p.Tags = tSlice
	for i := 0; i < size; i++ {
		_elem29 := &Tag{}
		if err := _elem29.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem29), err)
		}
		p.Tags = append(p.Tags, _elem29)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *QueryResultElement) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*Datapoint, 0, size)
	p.Datapoints = tSlice
	for i := 0; i < size; i++ {
		_elem30 := &Datapoint{
			TimestampTimeType: 0,
		}
		if err := _elem30.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem30), err)
		}
		p.Datapoints = append(p.Datapoints, _elem30)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *QueryResultElement) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("QueryResultElement"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *QueryResultElement) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:id: ", p), err)
	}
	if err := oprot.WriteString(string(p.ID)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.id (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:id: ", p), err)
	}
	return err
}

func (p *QueryResultElement) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("tags", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:tags: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Tags)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Tags {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:tags: ", p), err)
	}
	return err
}

func (p *QueryResultElement) writeField3(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("datapoints", thrift.LIST, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:datapoints: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Datapoints)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Datapoints {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:datapoints: ", p), err)
	}
	return err
}

func (p *QueryResultElement) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("QueryResultElement(%+v)", *p)
}

// Attributes:
//  - Field
//  - Term
type TermQuery struct {
	Field string `thrift:"field,1,required" db:"field" json:"field"`
	Term  string `thrift:"term,2,required" db:"term" json:"term"`
}

func NewTermQuery() *TermQuery {
	return &TermQuery{}
}

func (p *TermQuery) GetField() string {
	return p.Field
}

func (p *TermQuery) GetTerm() string {
	return p.Term
}
func (p *TermQuery) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetField bool = false
	var issetTerm bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetField = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetTerm = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetField {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Field is not set"))
	}
	if !issetTerm {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Term is not set"))
	}
	return nil
}

func (p *TermQuery) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Field = v
	}
	return nil
}

func (p *TermQuery) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Term = v
	}
	return nil
}

func (p *TermQuery) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("TermQuery"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *TermQuery) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("field", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:field: ", p), err)
	}
	if err := oprot.WriteString(string(p.Field)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.field (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:field: ", p), err)
	}
	return err
}

func (p *TermQuery) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("term", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:term: ", p), err)
	}
	if err := oprot.WriteString(string(p.Term)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.term (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:term: ", p), err)
	}
	return err
}

func (p *TermQuery) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TermQuery(%+v)", *p)
}

// Attributes:
//  - Field
//  - Regexp
type RegexpQuery struct {
	Field  string `thrift:"field,1,required" db:"field" json:"field"`
	Regexp string `thrift:"regexp,2,required" db:"regexp" json:"regexp"`
}

func NewRegexpQuery() *RegexpQuery {
	return &RegexpQuery{}
}

func (p *RegexpQuery) GetField() string {
	return p.Field
}

func (p *RegexpQuery) GetRegexp() string {
	return p.Regexp
}
func (p *RegexpQuery) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetField bool = false
	var issetRegexp bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetField = true
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
			issetRegexp = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetField {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Field is not set"))
	}
	if !issetRegexp {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Regexp is not set"))
	}
	return nil
}

func (p *RegexpQuery) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Field = v
	}
	return nil
}

func (p *RegexpQuery) ReadField2(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Regexp = v
	}
	return nil
}

func (p *RegexpQuery) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("RegexpQuery"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *RegexpQuery) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("field", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:field: ", p), err)
	}
	if err := oprot.WriteString(string(p.Field)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.field (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:field: ", p), err)
	}
	return err
}

func (p *RegexpQuery) writeField2(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("regexp", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:regexp: ", p), err)
	}
	if err := oprot.WriteString(string(p.Regexp)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.regexp (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:regexp: ", p), err)
	}
	return err
}

func (p *RegexpQuery) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("RegexpQuery(%+v)", *p)
}

// Attributes:
//  - Query
type NegationQuery struct {
	Query *Query `thrift:"query,1,required" db:"query" json:"query"`
}

func NewNegationQuery() *NegationQuery {
	return &NegationQuery{}
}

var NegationQuery_Query_DEFAULT *Query

func (p *NegationQuery) GetQuery() *Query {
	if !p.IsSetQuery() {
		return NegationQuery_Query_DEFAULT
	}
	return p.Query
}
func (p *NegationQuery) IsSetQuery() bool {
	return p.Query != nil
}

func (p *NegationQuery) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetQuery bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetQuery = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetQuery {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Query is not set"))
	}
	return nil
}

func (p *NegationQuery) ReadField1(iprot thrift.TProtocol) error {
	p.Query = &Query{}
	if err := p.Query.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Query), err)
	}
	return nil
}

func (p *NegationQuery) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("NegationQuery"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NegationQuery) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("query", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:query: ", p), err)
	}
	if err := p.Query.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Query), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:query: ", p), err)
	}
	return err
}

func (p *NegationQuery) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NegationQuery(%+v)", *p)
}

// Attributes:
//  - Queries
type ConjunctionQuery struct {
	Queries []*Query `thrift:"queries,1,required" db:"queries" json:"queries"`
}

func NewConjunctionQuery() *ConjunctionQuery {
	return &ConjunctionQuery{}
}

func (p *ConjunctionQuery) GetQueries() []*Query {
	return p.Queries
}
func (p *ConjunctionQuery) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetQueries bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetQueries = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetQueries {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Queries is not set"))
	}
	return nil
}

func (p *ConjunctionQuery) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*Query, 0, size)
	p.Queries = tSlice
	for i := 0; i < size; i++ {
		_elem31 := &Query{}
		if err := _elem31.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem31), err)
		}
		p.Queries = append(p.Queries, _elem31)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *ConjunctionQuery) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("ConjunctionQuery"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ConjunctionQuery) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("queries", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:queries: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Queries)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Queries {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:queries: ", p), err)
	}
	return err
}

func (p *ConjunctionQuery) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ConjunctionQuery(%+v)", *p)
}

// Attributes:
//  - Queries
type DisjunctionQuery struct {
	Queries []*Query `thrift:"queries,1,required" db:"queries" json:"queries"`
}

func NewDisjunctionQuery() *DisjunctionQuery {
	return &DisjunctionQuery{}
}

func (p *DisjunctionQuery) GetQueries() []*Query {
	return p.Queries
}
func (p *DisjunctionQuery) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetQueries bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetQueries = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetQueries {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Queries is not set"))
	}
	return nil
}

func (p *DisjunctionQuery) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make([]*Query, 0, size)
	p.Queries = tSlice
	for i := 0; i < size; i++ {
		_elem32 := &Query{}
		if err := _elem32.Read(iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem32), err)
		}
		p.Queries = append(p.Queries, _elem32)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *DisjunctionQuery) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("DisjunctionQuery"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *DisjunctionQuery) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("queries", thrift.LIST, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:queries: ", p), err)
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Queries)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Queries {
		if err := v.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:queries: ", p), err)
	}
	return err
}

func (p *DisjunctionQuery) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DisjunctionQuery(%+v)", *p)
}

type AllQuery struct {
}

func NewAllQuery() *AllQuery {
	return &AllQuery{}
}

func (p *AllQuery) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *AllQuery) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("AllQuery"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *AllQuery) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AllQuery(%+v)", *p)
}

// Attributes:
//  - Field
type FieldQuery struct {
	Field string `thrift:"field,1,required" db:"field" json:"field"`
}

func NewFieldQuery() *FieldQuery {
	return &FieldQuery{}
}

func (p *FieldQuery) GetField() string {
	return p.Field
}
func (p *FieldQuery) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	var issetField bool = false

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
			issetField = true
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	if !issetField {
		return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Field is not set"))
	}
	return nil
}

func (p *FieldQuery) ReadField1(iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Field = v
	}
	return nil
}

func (p *FieldQuery) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("FieldQuery"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *FieldQuery) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("field", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:field: ", p), err)
	}
	if err := oprot.WriteString(string(p.Field)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.field (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:field: ", p), err)
	}
	return err
}

func (p *FieldQuery) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FieldQuery(%+v)", *p)
}

// Attributes:
//  - Term
//  - Regexp
//  - Negation
//  - Conjunction
//  - Disjunction
//  - All
//  - Field
type Query struct {
	Term        *TermQuery        `thrift:"term,1" db:"term" json:"term,omitempty"`
	Regexp      *RegexpQuery      `thrift:"regexp,2" db:"regexp" json:"regexp,omitempty"`
	Negation    *NegationQuery    `thrift:"negation,3" db:"negation" json:"negation,omitempty"`
	Conjunction *ConjunctionQuery `thrift:"conjunction,4" db:"conjunction" json:"conjunction,omitempty"`
	Disjunction *DisjunctionQuery `thrift:"disjunction,5" db:"disjunction" json:"disjunction,omitempty"`
	All         *AllQuery         `thrift:"all,6" db:"all" json:"all,omitempty"`
	Field       *FieldQuery       `thrift:"field,7" db:"field" json:"field,omitempty"`
}

func NewQuery() *Query {
	return &Query{}
}

var Query_Term_DEFAULT *TermQuery

func (p *Query) GetTerm() *TermQuery {
	if !p.IsSetTerm() {
		return Query_Term_DEFAULT
	}
	return p.Term
}

var Query_Regexp_DEFAULT *RegexpQuery

func (p *Query) GetRegexp() *RegexpQuery {
	if !p.IsSetRegexp() {
		return Query_Regexp_DEFAULT
	}
	return p.Regexp
}

var Query_Negation_DEFAULT *NegationQuery

func (p *Query) GetNegation() *NegationQuery {
	if !p.IsSetNegation() {
		return Query_Negation_DEFAULT
	}
	return p.Negation
}

var Query_Conjunction_DEFAULT *ConjunctionQuery

func (p *Query) GetConjunction() *ConjunctionQuery {
	if !p.IsSetConjunction() {
		return Query_Conjunction_DEFAULT
	}
	return p.Conjunction
}

var Query_Disjunction_DEFAULT *DisjunctionQuery

func (p *Query) GetDisjunction() *DisjunctionQuery {
	if !p.IsSetDisjunction() {
		return Query_Disjunction_DEFAULT
	}
	return p.Disjunction
}

var Query_All_DEFAULT *AllQuery

func (p *Query) GetAll() *AllQuery {
	if !p.IsSetAll() {
		return Query_All_DEFAULT
	}
	return p.All
}

var Query_Field_DEFAULT *FieldQuery

func (p *Query) GetField() *FieldQuery {
	if !p.IsSetField() {
		return Query_Field_DEFAULT
	}
	return p.Field
}
func (p *Query) IsSetTerm() bool {
	return p.Term != nil
}

func (p *Query) IsSetRegexp() bool {
	return p.Regexp != nil
}

func (p *Query) IsSetNegation() bool {
	return p.Negation != nil
}

func (p *Query) IsSetConjunction() bool {
	return p.Conjunction != nil
}

func (p *Query) IsSetDisjunction() bool {
	return p.Disjunction != nil
}

func (p *Query) IsSetAll() bool {
	return p.All != nil
}

func (p *Query) IsSetField() bool {
	return p.Field != nil
}

func (p *Query) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		case 2:
			if err := p.ReadField2(iprot); err != nil {
				return err
			}
		case 3:
			if err := p.ReadField3(iprot); err != nil {
				return err
			}
		case 4:
			if err := p.ReadField4(iprot); err != nil {
				return err
			}
		case 5:
			if err := p.ReadField5(iprot); err != nil {
				return err
			}
		case 6:
			if err := p.ReadField6(iprot); err != nil {
				return err
			}
		case 7:
			if err := p.ReadField7(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *Query) ReadField1(iprot thrift.TProtocol) error {
	p.Term = &TermQuery{}
	if err := p.Term.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Term), err)
	}
	return nil
}

func (p *Query) ReadField2(iprot thrift.TProtocol) error {
	p.Regexp = &RegexpQuery{}
	if err := p.Regexp.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Regexp), err)
	}
	return nil
}

func (p *Query) ReadField3(iprot thrift.TProtocol) error {
	p.Negation = &NegationQuery{}
	if err := p.Negation.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Negation), err)
	}
	return nil
}

func (p *Query) ReadField4(iprot thrift.TProtocol) error {
	p.Conjunction = &ConjunctionQuery{}
	if err := p.Conjunction.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Conjunction), err)
	}
	return nil
}

func (p *Query) ReadField5(iprot thrift.TProtocol) error {
	p.Disjunction = &DisjunctionQuery{}
	if err := p.Disjunction.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Disjunction), err)
	}
	return nil
}

func (p *Query) ReadField6(iprot thrift.TProtocol) error {
	p.All = &AllQuery{}
	if err := p.All.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.All), err)
	}
	return nil
}

func (p *Query) ReadField7(iprot thrift.TProtocol) error {
	p.Field = &FieldQuery{}
	if err := p.Field.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Field), err)
	}
	return nil
}

func (p *Query) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("Query"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
		if err := p.writeField2(oprot); err != nil {
			return err
		}
		if err := p.writeField3(oprot); err != nil {
			return err
		}
		if err := p.writeField4(oprot); err != nil {
			return err
		}
		if err := p.writeField5(oprot); err != nil {
			return err
		}
		if err := p.writeField6(oprot); err != nil {
			return err
		}
		if err := p.writeField7(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *Query) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetTerm() {
		if err := oprot.WriteFieldBegin("term", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:term: ", p), err)
		}
		if err := p.Term.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Term), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:term: ", p), err)
		}
	}
	return err
}

func (p *Query) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetRegexp() {
		if err := oprot.WriteFieldBegin("regexp", thrift.STRUCT, 2); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:regexp: ", p), err)
		}
		if err := p.Regexp.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Regexp), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 2:regexp: ", p), err)
		}
	}
	return err
}

func (p *Query) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetNegation() {
		if err := oprot.WriteFieldBegin("negation", thrift.STRUCT, 3); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:negation: ", p), err)
		}
		if err := p.Negation.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Negation), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 3:negation: ", p), err)
		}
	}
	return err
}

func (p *Query) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetConjunction() {
		if err := oprot.WriteFieldBegin("conjunction", thrift.STRUCT, 4); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:conjunction: ", p), err)
		}
		if err := p.Conjunction.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Conjunction), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 4:conjunction: ", p), err)
		}
	}
	return err
}

func (p *Query) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetDisjunction() {
		if err := oprot.WriteFieldBegin("disjunction", thrift.STRUCT, 5); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:disjunction: ", p), err)
		}
		if err := p.Disjunction.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Disjunction), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 5:disjunction: ", p), err)
		}
	}
	return err
}

func (p *Query) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetAll() {
		if err := oprot.WriteFieldBegin("all", thrift.STRUCT, 6); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:all: ", p), err)
		}
		if err := p.All.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.All), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 6:all: ", p), err)
		}
	}
	return err
}

func (p *Query) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetField() {
		if err := oprot.WriteFieldBegin("field", thrift.STRUCT, 7); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:field: ", p), err)
		}
		if err := p.Field.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Field), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 7:field: ", p), err)
		}
	}
	return err
}

func (p *Query) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Query(%+v)", *p)
}

type Node interface {
	// Parameters:
	//  - Req
	Query(req *QueryRequest) (r *QueryResult_, err error)
	// Parameters:
	//  - Req
	AggregateRaw(req *AggregateQueryRawRequest) (r *AggregateQueryRawResult_, err error)
	// Parameters:
	//  - Req
	Aggregate(req *AggregateQueryRequest) (r *AggregateQueryResult_, err error)
	// Parameters:
	//  - Req
	Fetch(req *FetchRequest) (r *FetchResult_, err error)
	// Parameters:
	//  - Req
	FetchTagged(req *FetchTaggedRequest) (r *FetchTaggedResult_, err error)
	// Parameters:
	//  - Req
	Write(req *WriteRequest) (err error)
	// Parameters:
	//  - Req
	WriteTagged(req *WriteTaggedRequest) (err error)
	// Parameters:
	//  - Req
	FetchBatchRaw(req *FetchBatchRawRequest) (r *FetchBatchRawResult_, err error)
	// Parameters:
	//  - Req
	FetchBatchRawV2(req *FetchBatchRawV2Request) (r *FetchBatchRawResult_, err error)
	// Parameters:
	//  - Req
	FetchBlocksRaw(req *FetchBlocksRawRequest) (r *FetchBlocksRawResult_, err error)
	// Parameters:
	//  - Req
	FetchBlocksMetadataRawV2(req *FetchBlocksMetadataRawV2Request) (r *FetchBlocksMetadataRawV2Result_, err error)
	// Parameters:
	//  - Req
	WriteBatchRaw(req *WriteBatchRawRequest) (err error)
	// Parameters:
	//  - Req
	WriteBatchRawV2(req *WriteBatchRawV2Request) (err error)
	// Parameters:
	//  - Req
	WriteTaggedBatchRaw(req *WriteTaggedBatchRawRequest) (err error)
	// Parameters:
	//  - Req
	WriteTaggedBatchRawV2(req *WriteTaggedBatchRawV2Request) (err error)
	Repair() (err error)
	// Parameters:
	//  - Req
	Truncate(req *TruncateRequest) (r *TruncateResult_, err error)
	Health() (r *NodeHealthResult_, err error)
	Bootstrapped() (r *NodeBootstrappedResult_, err error)
	BootstrappedInPlacementOrNoPlacement() (r *NodeBootstrappedInPlacementOrNoPlacementResult_, err error)
	GetPersistRateLimit() (r *NodePersistRateLimitResult_, err error)
	// Parameters:
	//  - Req
	SetPersistRateLimit(req *NodeSetPersistRateLimitRequest) (r *NodePersistRateLimitResult_, err error)
	GetWriteNewSeriesAsync() (r *NodeWriteNewSeriesAsyncResult_, err error)
	// Parameters:
	//  - Req
	SetWriteNewSeriesAsync(req *NodeSetWriteNewSeriesAsyncRequest) (r *NodeWriteNewSeriesAsyncResult_, err error)
	GetWriteNewSeriesBackoffDuration() (r *NodeWriteNewSeriesBackoffDurationResult_, err error)
	// Parameters:
	//  - Req
	SetWriteNewSeriesBackoffDuration(req *NodeSetWriteNewSeriesBackoffDurationRequest) (r *NodeWriteNewSeriesBackoffDurationResult_, err error)
	GetWriteNewSeriesLimitPerShardPerSecond() (r *NodeWriteNewSeriesLimitPerShardPerSecondResult_, err error)
	// Parameters:
	//  - Req
	SetWriteNewSeriesLimitPerShardPerSecond(req *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest) (r *NodeWriteNewSeriesLimitPerShardPerSecondResult_, err error)
}

type NodeClient struct {
	Transport       thrift.TTransport
	ProtocolFactory thrift.TProtocolFactory
	InputProtocol   thrift.TProtocol
	OutputProtocol  thrift.TProtocol
	SeqId           int32
}

func NewNodeClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *NodeClient {
	return &NodeClient{Transport: t,
		ProtocolFactory: f,
		InputProtocol:   f.GetProtocol(t),
		OutputProtocol:  f.GetProtocol(t),
		SeqId:           0,
	}
}

func NewNodeClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *NodeClient {
	return &NodeClient{Transport: t,
		ProtocolFactory: nil,
		InputProtocol:   iprot,
		OutputProtocol:  oprot,
		SeqId:           0,
	}
}

// Parameters:
//  - Req
func (p *NodeClient) Query(req *QueryRequest) (r *QueryResult_, err error) {
	if err = p.sendQuery(req); err != nil {
		return
	}
	return p.recvQuery()
}

func (p *NodeClient) sendQuery(req *QueryRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("query", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeQueryArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvQuery() (value *QueryResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "query" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "query failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "query failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error33 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error34 error
		error34, err = error33.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error34
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "query failed: invalid message type")
		return
	}
	result := NodeQueryResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) AggregateRaw(req *AggregateQueryRawRequest) (r *AggregateQueryRawResult_, err error) {
	if err = p.sendAggregateRaw(req); err != nil {
		return
	}
	return p.recvAggregateRaw()
}

func (p *NodeClient) sendAggregateRaw(req *AggregateQueryRawRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("aggregateRaw", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeAggregateRawArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvAggregateRaw() (value *AggregateQueryRawResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "aggregateRaw" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "aggregateRaw failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "aggregateRaw failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error35 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error36 error
		error36, err = error35.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error36
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "aggregateRaw failed: invalid message type")
		return
	}
	result := NodeAggregateRawResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) Aggregate(req *AggregateQueryRequest) (r *AggregateQueryResult_, err error) {
	if err = p.sendAggregate(req); err != nil {
		return
	}
	return p.recvAggregate()
}

func (p *NodeClient) sendAggregate(req *AggregateQueryRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("aggregate", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeAggregateArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvAggregate() (value *AggregateQueryResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "aggregate" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "aggregate failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "aggregate failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error37 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error38 error
		error38, err = error37.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error38
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "aggregate failed: invalid message type")
		return
	}
	result := NodeAggregateResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) Fetch(req *FetchRequest) (r *FetchResult_, err error) {
	if err = p.sendFetch(req); err != nil {
		return
	}
	return p.recvFetch()
}

func (p *NodeClient) sendFetch(req *FetchRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("fetch", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeFetchArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvFetch() (value *FetchResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "fetch" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "fetch failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "fetch failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error39 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error40 error
		error40, err = error39.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error40
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "fetch failed: invalid message type")
		return
	}
	result := NodeFetchResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) FetchTagged(req *FetchTaggedRequest) (r *FetchTaggedResult_, err error) {
	if err = p.sendFetchTagged(req); err != nil {
		return
	}
	return p.recvFetchTagged()
}

func (p *NodeClient) sendFetchTagged(req *FetchTaggedRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("fetchTagged", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeFetchTaggedArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvFetchTagged() (value *FetchTaggedResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "fetchTagged" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "fetchTagged failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "fetchTagged failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error41 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error42 error
		error42, err = error41.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error42
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "fetchTagged failed: invalid message type")
		return
	}
	result := NodeFetchTaggedResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) Write(req *WriteRequest) (err error) {
	if err = p.sendWrite(req); err != nil {
		return
	}
	return p.recvWrite()
}

func (p *NodeClient) sendWrite(req *WriteRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("write", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeWriteArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvWrite() (err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "write" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "write failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "write failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error43 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error44 error
		error44, err = error43.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error44
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "write failed: invalid message type")
		return
	}
	result := NodeWriteResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	return
}

// Parameters:
//  - Req
func (p *NodeClient) WriteTagged(req *WriteTaggedRequest) (err error) {
	if err = p.sendWriteTagged(req); err != nil {
		return
	}
	return p.recvWriteTagged()
}

func (p *NodeClient) sendWriteTagged(req *WriteTaggedRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("writeTagged", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeWriteTaggedArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvWriteTagged() (err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "writeTagged" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "writeTagged failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "writeTagged failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error45 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error46 error
		error46, err = error45.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error46
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "writeTagged failed: invalid message type")
		return
	}
	result := NodeWriteTaggedResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	return
}

// Parameters:
//  - Req
func (p *NodeClient) FetchBatchRaw(req *FetchBatchRawRequest) (r *FetchBatchRawResult_, err error) {
	if err = p.sendFetchBatchRaw(req); err != nil {
		return
	}
	return p.recvFetchBatchRaw()
}

func (p *NodeClient) sendFetchBatchRaw(req *FetchBatchRawRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("fetchBatchRaw", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeFetchBatchRawArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvFetchBatchRaw() (value *FetchBatchRawResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "fetchBatchRaw" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "fetchBatchRaw failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "fetchBatchRaw failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error47 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error48 error
		error48, err = error47.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error48
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "fetchBatchRaw failed: invalid message type")
		return
	}
	result := NodeFetchBatchRawResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) FetchBatchRawV2(req *FetchBatchRawV2Request) (r *FetchBatchRawResult_, err error) {
	if err = p.sendFetchBatchRawV2(req); err != nil {
		return
	}
	return p.recvFetchBatchRawV2()
}

func (p *NodeClient) sendFetchBatchRawV2(req *FetchBatchRawV2Request) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("fetchBatchRawV2", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeFetchBatchRawV2Args{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvFetchBatchRawV2() (value *FetchBatchRawResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "fetchBatchRawV2" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "fetchBatchRawV2 failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "fetchBatchRawV2 failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error49 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error50 error
		error50, err = error49.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error50
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "fetchBatchRawV2 failed: invalid message type")
		return
	}
	result := NodeFetchBatchRawV2Result{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) FetchBlocksRaw(req *FetchBlocksRawRequest) (r *FetchBlocksRawResult_, err error) {
	if err = p.sendFetchBlocksRaw(req); err != nil {
		return
	}
	return p.recvFetchBlocksRaw()
}

func (p *NodeClient) sendFetchBlocksRaw(req *FetchBlocksRawRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("fetchBlocksRaw", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeFetchBlocksRawArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvFetchBlocksRaw() (value *FetchBlocksRawResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "fetchBlocksRaw" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "fetchBlocksRaw failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "fetchBlocksRaw failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error51 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error52 error
		error52, err = error51.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error52
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "fetchBlocksRaw failed: invalid message type")
		return
	}
	result := NodeFetchBlocksRawResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) FetchBlocksMetadataRawV2(req *FetchBlocksMetadataRawV2Request) (r *FetchBlocksMetadataRawV2Result_, err error) {
	if err = p.sendFetchBlocksMetadataRawV2(req); err != nil {
		return
	}
	return p.recvFetchBlocksMetadataRawV2()
}

func (p *NodeClient) sendFetchBlocksMetadataRawV2(req *FetchBlocksMetadataRawV2Request) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("fetchBlocksMetadataRawV2", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeFetchBlocksMetadataRawV2Args{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvFetchBlocksMetadataRawV2() (value *FetchBlocksMetadataRawV2Result_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "fetchBlocksMetadataRawV2" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "fetchBlocksMetadataRawV2 failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "fetchBlocksMetadataRawV2 failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error53 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error54 error
		error54, err = error53.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error54
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "fetchBlocksMetadataRawV2 failed: invalid message type")
		return
	}
	result := NodeFetchBlocksMetadataRawV2Result{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) WriteBatchRaw(req *WriteBatchRawRequest) (err error) {
	if err = p.sendWriteBatchRaw(req); err != nil {
		return
	}
	return p.recvWriteBatchRaw()
}

func (p *NodeClient) sendWriteBatchRaw(req *WriteBatchRawRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("writeBatchRaw", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeWriteBatchRawArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvWriteBatchRaw() (err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "writeBatchRaw" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "writeBatchRaw failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "writeBatchRaw failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error55 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error56 error
		error56, err = error55.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error56
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "writeBatchRaw failed: invalid message type")
		return
	}
	result := NodeWriteBatchRawResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	return
}

// Parameters:
//  - Req
func (p *NodeClient) WriteBatchRawV2(req *WriteBatchRawV2Request) (err error) {
	if err = p.sendWriteBatchRawV2(req); err != nil {
		return
	}
	return p.recvWriteBatchRawV2()
}

func (p *NodeClient) sendWriteBatchRawV2(req *WriteBatchRawV2Request) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("writeBatchRawV2", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeWriteBatchRawV2Args{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvWriteBatchRawV2() (err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "writeBatchRawV2" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "writeBatchRawV2 failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "writeBatchRawV2 failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error57 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error58 error
		error58, err = error57.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error58
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "writeBatchRawV2 failed: invalid message type")
		return
	}
	result := NodeWriteBatchRawV2Result{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	return
}

// Parameters:
//  - Req
func (p *NodeClient) WriteTaggedBatchRaw(req *WriteTaggedBatchRawRequest) (err error) {
	if err = p.sendWriteTaggedBatchRaw(req); err != nil {
		return
	}
	return p.recvWriteTaggedBatchRaw()
}

func (p *NodeClient) sendWriteTaggedBatchRaw(req *WriteTaggedBatchRawRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("writeTaggedBatchRaw", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeWriteTaggedBatchRawArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvWriteTaggedBatchRaw() (err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "writeTaggedBatchRaw" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "writeTaggedBatchRaw failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "writeTaggedBatchRaw failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error59 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error60 error
		error60, err = error59.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error60
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "writeTaggedBatchRaw failed: invalid message type")
		return
	}
	result := NodeWriteTaggedBatchRawResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	return
}

// Parameters:
//  - Req
func (p *NodeClient) WriteTaggedBatchRawV2(req *WriteTaggedBatchRawV2Request) (err error) {
	if err = p.sendWriteTaggedBatchRawV2(req); err != nil {
		return
	}
	return p.recvWriteTaggedBatchRawV2()
}

func (p *NodeClient) sendWriteTaggedBatchRawV2(req *WriteTaggedBatchRawV2Request) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("writeTaggedBatchRawV2", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeWriteTaggedBatchRawV2Args{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvWriteTaggedBatchRawV2() (err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "writeTaggedBatchRawV2" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "writeTaggedBatchRawV2 failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "writeTaggedBatchRawV2 failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error61 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error62 error
		error62, err = error61.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error62
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "writeTaggedBatchRawV2 failed: invalid message type")
		return
	}
	result := NodeWriteTaggedBatchRawV2Result{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	return
}

func (p *NodeClient) Repair() (err error) {
	if err = p.sendRepair(); err != nil {
		return
	}
	return p.recvRepair()
}

func (p *NodeClient) sendRepair() (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("repair", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeRepairArgs{}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvRepair() (err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "repair" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "repair failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "repair failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error63 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error64 error
		error64, err = error63.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error64
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "repair failed: invalid message type")
		return
	}
	result := NodeRepairResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	return
}

// Parameters:
//  - Req
func (p *NodeClient) Truncate(req *TruncateRequest) (r *TruncateResult_, err error) {
	if err = p.sendTruncate(req); err != nil {
		return
	}
	return p.recvTruncate()
}

func (p *NodeClient) sendTruncate(req *TruncateRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("truncate", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeTruncateArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvTruncate() (value *TruncateResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "truncate" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "truncate failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "truncate failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error65 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error66 error
		error66, err = error65.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error66
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "truncate failed: invalid message type")
		return
	}
	result := NodeTruncateResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

func (p *NodeClient) Health() (r *NodeHealthResult_, err error) {
	if err = p.sendHealth(); err != nil {
		return
	}
	return p.recvHealth()
}

func (p *NodeClient) sendHealth() (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("health", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeHealthArgs{}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvHealth() (value *NodeHealthResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "health" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "health failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "health failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error67 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error68 error
		error68, err = error67.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error68
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "health failed: invalid message type")
		return
	}
	result := NodeHealthResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

func (p *NodeClient) Bootstrapped() (r *NodeBootstrappedResult_, err error) {
	if err = p.sendBootstrapped(); err != nil {
		return
	}
	return p.recvBootstrapped()
}

func (p *NodeClient) sendBootstrapped() (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("bootstrapped", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeBootstrappedArgs{}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvBootstrapped() (value *NodeBootstrappedResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "bootstrapped" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "bootstrapped failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "bootstrapped failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error69 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error70 error
		error70, err = error69.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error70
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "bootstrapped failed: invalid message type")
		return
	}
	result := NodeBootstrappedResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

func (p *NodeClient) BootstrappedInPlacementOrNoPlacement() (r *NodeBootstrappedInPlacementOrNoPlacementResult_, err error) {
	if err = p.sendBootstrappedInPlacementOrNoPlacement(); err != nil {
		return
	}
	return p.recvBootstrappedInPlacementOrNoPlacement()
}

func (p *NodeClient) sendBootstrappedInPlacementOrNoPlacement() (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("bootstrappedInPlacementOrNoPlacement", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeBootstrappedInPlacementOrNoPlacementArgs{}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvBootstrappedInPlacementOrNoPlacement() (value *NodeBootstrappedInPlacementOrNoPlacementResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "bootstrappedInPlacementOrNoPlacement" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "bootstrappedInPlacementOrNoPlacement failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "bootstrappedInPlacementOrNoPlacement failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error71 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error72 error
		error72, err = error71.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error72
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "bootstrappedInPlacementOrNoPlacement failed: invalid message type")
		return
	}
	result := NodeBootstrappedInPlacementOrNoPlacementResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

func (p *NodeClient) GetPersistRateLimit() (r *NodePersistRateLimitResult_, err error) {
	if err = p.sendGetPersistRateLimit(); err != nil {
		return
	}
	return p.recvGetPersistRateLimit()
}

func (p *NodeClient) sendGetPersistRateLimit() (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("getPersistRateLimit", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeGetPersistRateLimitArgs{}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvGetPersistRateLimit() (value *NodePersistRateLimitResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "getPersistRateLimit" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "getPersistRateLimit failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "getPersistRateLimit failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error73 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error74 error
		error74, err = error73.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error74
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "getPersistRateLimit failed: invalid message type")
		return
	}
	result := NodeGetPersistRateLimitResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) SetPersistRateLimit(req *NodeSetPersistRateLimitRequest) (r *NodePersistRateLimitResult_, err error) {
	if err = p.sendSetPersistRateLimit(req); err != nil {
		return
	}
	return p.recvSetPersistRateLimit()
}

func (p *NodeClient) sendSetPersistRateLimit(req *NodeSetPersistRateLimitRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("setPersistRateLimit", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeSetPersistRateLimitArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvSetPersistRateLimit() (value *NodePersistRateLimitResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "setPersistRateLimit" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "setPersistRateLimit failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "setPersistRateLimit failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error75 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error76 error
		error76, err = error75.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error76
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "setPersistRateLimit failed: invalid message type")
		return
	}
	result := NodeSetPersistRateLimitResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

func (p *NodeClient) GetWriteNewSeriesAsync() (r *NodeWriteNewSeriesAsyncResult_, err error) {
	if err = p.sendGetWriteNewSeriesAsync(); err != nil {
		return
	}
	return p.recvGetWriteNewSeriesAsync()
}

func (p *NodeClient) sendGetWriteNewSeriesAsync() (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("getWriteNewSeriesAsync", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeGetWriteNewSeriesAsyncArgs{}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvGetWriteNewSeriesAsync() (value *NodeWriteNewSeriesAsyncResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "getWriteNewSeriesAsync" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "getWriteNewSeriesAsync failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "getWriteNewSeriesAsync failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error77 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error78 error
		error78, err = error77.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error78
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "getWriteNewSeriesAsync failed: invalid message type")
		return
	}
	result := NodeGetWriteNewSeriesAsyncResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) SetWriteNewSeriesAsync(req *NodeSetWriteNewSeriesAsyncRequest) (r *NodeWriteNewSeriesAsyncResult_, err error) {
	if err = p.sendSetWriteNewSeriesAsync(req); err != nil {
		return
	}
	return p.recvSetWriteNewSeriesAsync()
}

func (p *NodeClient) sendSetWriteNewSeriesAsync(req *NodeSetWriteNewSeriesAsyncRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("setWriteNewSeriesAsync", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeSetWriteNewSeriesAsyncArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvSetWriteNewSeriesAsync() (value *NodeWriteNewSeriesAsyncResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "setWriteNewSeriesAsync" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "setWriteNewSeriesAsync failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "setWriteNewSeriesAsync failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error79 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error80 error
		error80, err = error79.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error80
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "setWriteNewSeriesAsync failed: invalid message type")
		return
	}
	result := NodeSetWriteNewSeriesAsyncResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

func (p *NodeClient) GetWriteNewSeriesBackoffDuration() (r *NodeWriteNewSeriesBackoffDurationResult_, err error) {
	if err = p.sendGetWriteNewSeriesBackoffDuration(); err != nil {
		return
	}
	return p.recvGetWriteNewSeriesBackoffDuration()
}

func (p *NodeClient) sendGetWriteNewSeriesBackoffDuration() (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("getWriteNewSeriesBackoffDuration", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeGetWriteNewSeriesBackoffDurationArgs{}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvGetWriteNewSeriesBackoffDuration() (value *NodeWriteNewSeriesBackoffDurationResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "getWriteNewSeriesBackoffDuration" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "getWriteNewSeriesBackoffDuration failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "getWriteNewSeriesBackoffDuration failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error81 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error82 error
		error82, err = error81.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error82
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "getWriteNewSeriesBackoffDuration failed: invalid message type")
		return
	}
	result := NodeGetWriteNewSeriesBackoffDurationResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) SetWriteNewSeriesBackoffDuration(req *NodeSetWriteNewSeriesBackoffDurationRequest) (r *NodeWriteNewSeriesBackoffDurationResult_, err error) {
	if err = p.sendSetWriteNewSeriesBackoffDuration(req); err != nil {
		return
	}
	return p.recvSetWriteNewSeriesBackoffDuration()
}

func (p *NodeClient) sendSetWriteNewSeriesBackoffDuration(req *NodeSetWriteNewSeriesBackoffDurationRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("setWriteNewSeriesBackoffDuration", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeSetWriteNewSeriesBackoffDurationArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvSetWriteNewSeriesBackoffDuration() (value *NodeWriteNewSeriesBackoffDurationResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "setWriteNewSeriesBackoffDuration" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "setWriteNewSeriesBackoffDuration failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "setWriteNewSeriesBackoffDuration failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error83 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error84 error
		error84, err = error83.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error84
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "setWriteNewSeriesBackoffDuration failed: invalid message type")
		return
	}
	result := NodeSetWriteNewSeriesBackoffDurationResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

func (p *NodeClient) GetWriteNewSeriesLimitPerShardPerSecond() (r *NodeWriteNewSeriesLimitPerShardPerSecondResult_, err error) {
	if err = p.sendGetWriteNewSeriesLimitPerShardPerSecond(); err != nil {
		return
	}
	return p.recvGetWriteNewSeriesLimitPerShardPerSecond()
}

func (p *NodeClient) sendGetWriteNewSeriesLimitPerShardPerSecond() (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("getWriteNewSeriesLimitPerShardPerSecond", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeGetWriteNewSeriesLimitPerShardPerSecondArgs{}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvGetWriteNewSeriesLimitPerShardPerSecond() (value *NodeWriteNewSeriesLimitPerShardPerSecondResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "getWriteNewSeriesLimitPerShardPerSecond" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "getWriteNewSeriesLimitPerShardPerSecond failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "getWriteNewSeriesLimitPerShardPerSecond failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error85 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error86 error
		error86, err = error85.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error86
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "getWriteNewSeriesLimitPerShardPerSecond failed: invalid message type")
		return
	}
	result := NodeGetWriteNewSeriesLimitPerShardPerSecondResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *NodeClient) SetWriteNewSeriesLimitPerShardPerSecond(req *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest) (r *NodeWriteNewSeriesLimitPerShardPerSecondResult_, err error) {
	if err = p.sendSetWriteNewSeriesLimitPerShardPerSecond(req); err != nil {
		return
	}
	return p.recvSetWriteNewSeriesLimitPerShardPerSecond()
}

func (p *NodeClient) sendSetWriteNewSeriesLimitPerShardPerSecond(req *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("setWriteNewSeriesLimitPerShardPerSecond", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := NodeSetWriteNewSeriesLimitPerShardPerSecondArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *NodeClient) recvSetWriteNewSeriesLimitPerShardPerSecond() (value *NodeWriteNewSeriesLimitPerShardPerSecondResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "setWriteNewSeriesLimitPerShardPerSecond" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "setWriteNewSeriesLimitPerShardPerSecond failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "setWriteNewSeriesLimitPerShardPerSecond failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error87 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error88 error
		error88, err = error87.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error88
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "setWriteNewSeriesLimitPerShardPerSecond failed: invalid message type")
		return
	}
	result := NodeSetWriteNewSeriesLimitPerShardPerSecondResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

type NodeProcessor struct {
	processorMap map[string]thrift.TProcessorFunction
	handler      Node
}

func (p *NodeProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
	p.processorMap[key] = processor
}

func (p *NodeProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
	processor, ok = p.processorMap[key]
	return processor, ok
}

func (p *NodeProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
	return p.processorMap
}

func NewNodeProcessor(handler Node) *NodeProcessor {

	self89 := &NodeProcessor{handler: handler, processorMap: make(map[string]thrift.TProcessorFunction)}
	self89.processorMap["query"] = &nodeProcessorQuery{handler: handler}
	self89.processorMap["aggregateRaw"] = &nodeProcessorAggregateRaw{handler: handler}
	self89.processorMap["aggregate"] = &nodeProcessorAggregate{handler: handler}
	self89.processorMap["fetch"] = &nodeProcessorFetch{handler: handler}
	self89.processorMap["fetchTagged"] = &nodeProcessorFetchTagged{handler: handler}
	self89.processorMap["write"] = &nodeProcessorWrite{handler: handler}
	self89.processorMap["writeTagged"] = &nodeProcessorWriteTagged{handler: handler}
	self89.processorMap["fetchBatchRaw"] = &nodeProcessorFetchBatchRaw{handler: handler}
	self89.processorMap["fetchBatchRawV2"] = &nodeProcessorFetchBatchRawV2{handler: handler}
	self89.processorMap["fetchBlocksRaw"] = &nodeProcessorFetchBlocksRaw{handler: handler}
	self89.processorMap["fetchBlocksMetadataRawV2"] = &nodeProcessorFetchBlocksMetadataRawV2{handler: handler}
	self89.processorMap["writeBatchRaw"] = &nodeProcessorWriteBatchRaw{handler: handler}
	self89.processorMap["writeBatchRawV2"] = &nodeProcessorWriteBatchRawV2{handler: handler}
	self89.processorMap["writeTaggedBatchRaw"] = &nodeProcessorWriteTaggedBatchRaw{handler: handler}
	self89.processorMap["writeTaggedBatchRawV2"] = &nodeProcessorWriteTaggedBatchRawV2{handler: handler}
	self89.processorMap["repair"] = &nodeProcessorRepair{handler: handler}
	self89.processorMap["truncate"] = &nodeProcessorTruncate{handler: handler}
	self89.processorMap["health"] = &nodeProcessorHealth{handler: handler}
	self89.processorMap["bootstrapped"] = &nodeProcessorBootstrapped{handler: handler}
	self89.processorMap["bootstrappedInPlacementOrNoPlacement"] = &nodeProcessorBootstrappedInPlacementOrNoPlacement{handler: handler}
	self89.processorMap["getPersistRateLimit"] = &nodeProcessorGetPersistRateLimit{handler: handler}
	self89.processorMap["setPersistRateLimit"] = &nodeProcessorSetPersistRateLimit{handler: handler}
	self89.processorMap["getWriteNewSeriesAsync"] = &nodeProcessorGetWriteNewSeriesAsync{handler: handler}
	self89.processorMap["setWriteNewSeriesAsync"] = &nodeProcessorSetWriteNewSeriesAsync{handler: handler}
	self89.processorMap["getWriteNewSeriesBackoffDuration"] = &nodeProcessorGetWriteNewSeriesBackoffDuration{handler: handler}
	self89.processorMap["setWriteNewSeriesBackoffDuration"] = &nodeProcessorSetWriteNewSeriesBackoffDuration{handler: handler}
	self89.processorMap["getWriteNewSeriesLimitPerShardPerSecond"] = &nodeProcessorGetWriteNewSeriesLimitPerShardPerSecond{handler: handler}
	self89.processorMap["setWriteNewSeriesLimitPerShardPerSecond"] = &nodeProcessorSetWriteNewSeriesLimitPerShardPerSecond{handler: handler}
	return self89
}

func (p *NodeProcessor) Process(iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	name, _, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return false, err
	}
	if processor, ok := p.GetProcessorFunction(name); ok {
		return processor.Process(seqId, iprot, oprot)
	}
	iprot.Skip(thrift.STRUCT)
	iprot.ReadMessageEnd()
	x90 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function "+name)
	oprot.WriteMessageBegin(name, thrift.EXCEPTION, seqId)
	x90.Write(oprot)
	oprot.WriteMessageEnd()
	oprot.Flush()
	return false, x90

}

type nodeProcessorQuery struct {
	handler Node
}

func (p *nodeProcessorQuery) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeQueryArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("query", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeQueryResult{}
	var retval *QueryResult_
	var err2 error
	if retval, err2 = p.handler.Query(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing query: "+err2.Error())
			oprot.WriteMessageBegin("query", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("query", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorAggregateRaw struct {
	handler Node
}

func (p *nodeProcessorAggregateRaw) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeAggregateRawArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("aggregateRaw", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeAggregateRawResult{}
	var retval *AggregateQueryRawResult_
	var err2 error
	if retval, err2 = p.handler.AggregateRaw(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing aggregateRaw: "+err2.Error())
			oprot.WriteMessageBegin("aggregateRaw", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("aggregateRaw", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorAggregate struct {
	handler Node
}

func (p *nodeProcessorAggregate) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeAggregateArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("aggregate", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeAggregateResult{}
	var retval *AggregateQueryResult_
	var err2 error
	if retval, err2 = p.handler.Aggregate(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing aggregate: "+err2.Error())
			oprot.WriteMessageBegin("aggregate", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("aggregate", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorFetch struct {
	handler Node
}

func (p *nodeProcessorFetch) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeFetchArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("fetch", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeFetchResult{}
	var retval *FetchResult_
	var err2 error
	if retval, err2 = p.handler.Fetch(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetch: "+err2.Error())
			oprot.WriteMessageBegin("fetch", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("fetch", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorFetchTagged struct {
	handler Node
}

func (p *nodeProcessorFetchTagged) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeFetchTaggedArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("fetchTagged", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeFetchTaggedResult{}
	var retval *FetchTaggedResult_
	var err2 error
	if retval, err2 = p.handler.FetchTagged(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchTagged: "+err2.Error())
			oprot.WriteMessageBegin("fetchTagged", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("fetchTagged", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorWrite struct {
	handler Node
}

func (p *nodeProcessorWrite) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeWriteArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("write", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeWriteResult{}
	var err2 error
	if err2 = p.handler.Write(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing write: "+err2.Error())
			oprot.WriteMessageBegin("write", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	}
	if err2 = oprot.WriteMessageBegin("write", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorWriteTagged struct {
	handler Node
}

func (p *nodeProcessorWriteTagged) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeWriteTaggedArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("writeTagged", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeWriteTaggedResult{}
	var err2 error
	if err2 = p.handler.WriteTagged(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing writeTagged: "+err2.Error())
			oprot.WriteMessageBegin("writeTagged", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	}
	if err2 = oprot.WriteMessageBegin("writeTagged", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorFetchBatchRaw struct {
	handler Node
}

func (p *nodeProcessorFetchBatchRaw) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeFetchBatchRawArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("fetchBatchRaw", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeFetchBatchRawResult{}
	var retval *FetchBatchRawResult_
	var err2 error
	if retval, err2 = p.handler.FetchBatchRaw(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchBatchRaw: "+err2.Error())
			oprot.WriteMessageBegin("fetchBatchRaw", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("fetchBatchRaw", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorFetchBatchRawV2 struct {
	handler Node
}

func (p *nodeProcessorFetchBatchRawV2) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeFetchBatchRawV2Args{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("fetchBatchRawV2", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeFetchBatchRawV2Result{}
	var retval *FetchBatchRawResult_
	var err2 error
	if retval, err2 = p.handler.FetchBatchRawV2(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchBatchRawV2: "+err2.Error())
			oprot.WriteMessageBegin("fetchBatchRawV2", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("fetchBatchRawV2", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorFetchBlocksRaw struct {
	handler Node
}

func (p *nodeProcessorFetchBlocksRaw) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeFetchBlocksRawArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("fetchBlocksRaw", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeFetchBlocksRawResult{}
	var retval *FetchBlocksRawResult_
	var err2 error
	if retval, err2 = p.handler.FetchBlocksRaw(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchBlocksRaw: "+err2.Error())
			oprot.WriteMessageBegin("fetchBlocksRaw", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("fetchBlocksRaw", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorFetchBlocksMetadataRawV2 struct {
	handler Node
}

func (p *nodeProcessorFetchBlocksMetadataRawV2) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeFetchBlocksMetadataRawV2Args{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("fetchBlocksMetadataRawV2", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeFetchBlocksMetadataRawV2Result{}
	var retval *FetchBlocksMetadataRawV2Result_
	var err2 error
	if retval, err2 = p.handler.FetchBlocksMetadataRawV2(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchBlocksMetadataRawV2: "+err2.Error())
			oprot.WriteMessageBegin("fetchBlocksMetadataRawV2", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("fetchBlocksMetadataRawV2", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorWriteBatchRaw struct {
	handler Node
}

func (p *nodeProcessorWriteBatchRaw) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeWriteBatchRawArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("writeBatchRaw", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeWriteBatchRawResult{}
	var err2 error
	if err2 = p.handler.WriteBatchRaw(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *WriteBatchRawErrors:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing writeBatchRaw: "+err2.Error())
			oprot.WriteMessageBegin("writeBatchRaw", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	}
	if err2 = oprot.WriteMessageBegin("writeBatchRaw", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorWriteBatchRawV2 struct {
	handler Node
}

func (p *nodeProcessorWriteBatchRawV2) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeWriteBatchRawV2Args{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("writeBatchRawV2", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeWriteBatchRawV2Result{}
	var err2 error
	if err2 = p.handler.WriteBatchRawV2(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *WriteBatchRawErrors:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing writeBatchRawV2: "+err2.Error())
			oprot.WriteMessageBegin("writeBatchRawV2", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	}
	if err2 = oprot.WriteMessageBegin("writeBatchRawV2", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorWriteTaggedBatchRaw struct {
	handler Node
}

func (p *nodeProcessorWriteTaggedBatchRaw) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeWriteTaggedBatchRawArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("writeTaggedBatchRaw", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeWriteTaggedBatchRawResult{}
	var err2 error
	if err2 = p.handler.WriteTaggedBatchRaw(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *WriteBatchRawErrors:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing writeTaggedBatchRaw: "+err2.Error())
			oprot.WriteMessageBegin("writeTaggedBatchRaw", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	}
	if err2 = oprot.WriteMessageBegin("writeTaggedBatchRaw", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorWriteTaggedBatchRawV2 struct {
	handler Node
}

func (p *nodeProcessorWriteTaggedBatchRawV2) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeWriteTaggedBatchRawV2Args{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("writeTaggedBatchRawV2", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeWriteTaggedBatchRawV2Result{}
	var err2 error
	if err2 = p.handler.WriteTaggedBatchRawV2(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *WriteBatchRawErrors:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing writeTaggedBatchRawV2: "+err2.Error())
			oprot.WriteMessageBegin("writeTaggedBatchRawV2", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	}
	if err2 = oprot.WriteMessageBegin("writeTaggedBatchRawV2", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorRepair struct {
	handler Node
}

func (p *nodeProcessorRepair) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeRepairArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("repair", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeRepairResult{}
	var err2 error
	if err2 = p.handler.Repair(); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing repair: "+err2.Error())
			oprot.WriteMessageBegin("repair", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	}
	if err2 = oprot.WriteMessageBegin("repair", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorTruncate struct {
	handler Node
}

func (p *nodeProcessorTruncate) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeTruncateArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("truncate", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeTruncateResult{}
	var retval *TruncateResult_
	var err2 error
	if retval, err2 = p.handler.Truncate(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing truncate: "+err2.Error())
			oprot.WriteMessageBegin("truncate", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("truncate", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorHealth struct {
	handler Node
}

func (p *nodeProcessorHealth) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeHealthArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("health", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeHealthResult{}
	var retval *NodeHealthResult_
	var err2 error
	if retval, err2 = p.handler.Health(); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing health: "+err2.Error())
			oprot.WriteMessageBegin("health", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("health", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorBootstrapped struct {
	handler Node
}

func (p *nodeProcessorBootstrapped) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeBootstrappedArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("bootstrapped", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeBootstrappedResult{}
	var retval *NodeBootstrappedResult_
	var err2 error
	if retval, err2 = p.handler.Bootstrapped(); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing bootstrapped: "+err2.Error())
			oprot.WriteMessageBegin("bootstrapped", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("bootstrapped", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorBootstrappedInPlacementOrNoPlacement struct {
	handler Node
}

func (p *nodeProcessorBootstrappedInPlacementOrNoPlacement) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeBootstrappedInPlacementOrNoPlacementArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("bootstrappedInPlacementOrNoPlacement", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeBootstrappedInPlacementOrNoPlacementResult{}
	var retval *NodeBootstrappedInPlacementOrNoPlacementResult_
	var err2 error
	if retval, err2 = p.handler.BootstrappedInPlacementOrNoPlacement(); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing bootstrappedInPlacementOrNoPlacement: "+err2.Error())
			oprot.WriteMessageBegin("bootstrappedInPlacementOrNoPlacement", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("bootstrappedInPlacementOrNoPlacement", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorGetPersistRateLimit struct {
	handler Node
}

func (p *nodeProcessorGetPersistRateLimit) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeGetPersistRateLimitArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("getPersistRateLimit", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeGetPersistRateLimitResult{}
	var retval *NodePersistRateLimitResult_
	var err2 error
	if retval, err2 = p.handler.GetPersistRateLimit(); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getPersistRateLimit: "+err2.Error())
			oprot.WriteMessageBegin("getPersistRateLimit", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("getPersistRateLimit", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorSetPersistRateLimit struct {
	handler Node
}

func (p *nodeProcessorSetPersistRateLimit) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeSetPersistRateLimitArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("setPersistRateLimit", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeSetPersistRateLimitResult{}
	var retval *NodePersistRateLimitResult_
	var err2 error
	if retval, err2 = p.handler.SetPersistRateLimit(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setPersistRateLimit: "+err2.Error())
			oprot.WriteMessageBegin("setPersistRateLimit", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("setPersistRateLimit", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorGetWriteNewSeriesAsync struct {
	handler Node
}

func (p *nodeProcessorGetWriteNewSeriesAsync) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeGetWriteNewSeriesAsyncArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("getWriteNewSeriesAsync", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeGetWriteNewSeriesAsyncResult{}
	var retval *NodeWriteNewSeriesAsyncResult_
	var err2 error
	if retval, err2 = p.handler.GetWriteNewSeriesAsync(); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getWriteNewSeriesAsync: "+err2.Error())
			oprot.WriteMessageBegin("getWriteNewSeriesAsync", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("getWriteNewSeriesAsync", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorSetWriteNewSeriesAsync struct {
	handler Node
}

func (p *nodeProcessorSetWriteNewSeriesAsync) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeSetWriteNewSeriesAsyncArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("setWriteNewSeriesAsync", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeSetWriteNewSeriesAsyncResult{}
	var retval *NodeWriteNewSeriesAsyncResult_
	var err2 error
	if retval, err2 = p.handler.SetWriteNewSeriesAsync(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setWriteNewSeriesAsync: "+err2.Error())
			oprot.WriteMessageBegin("setWriteNewSeriesAsync", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("setWriteNewSeriesAsync", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorGetWriteNewSeriesBackoffDuration struct {
	handler Node
}

func (p *nodeProcessorGetWriteNewSeriesBackoffDuration) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeGetWriteNewSeriesBackoffDurationArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("getWriteNewSeriesBackoffDuration", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeGetWriteNewSeriesBackoffDurationResult{}
	var retval *NodeWriteNewSeriesBackoffDurationResult_
	var err2 error
	if retval, err2 = p.handler.GetWriteNewSeriesBackoffDuration(); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getWriteNewSeriesBackoffDuration: "+err2.Error())
			oprot.WriteMessageBegin("getWriteNewSeriesBackoffDuration", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("getWriteNewSeriesBackoffDuration", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorSetWriteNewSeriesBackoffDuration struct {
	handler Node
}

func (p *nodeProcessorSetWriteNewSeriesBackoffDuration) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeSetWriteNewSeriesBackoffDurationArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("setWriteNewSeriesBackoffDuration", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeSetWriteNewSeriesBackoffDurationResult{}
	var retval *NodeWriteNewSeriesBackoffDurationResult_
	var err2 error
	if retval, err2 = p.handler.SetWriteNewSeriesBackoffDuration(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setWriteNewSeriesBackoffDuration: "+err2.Error())
			oprot.WriteMessageBegin("setWriteNewSeriesBackoffDuration", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("setWriteNewSeriesBackoffDuration", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorGetWriteNewSeriesLimitPerShardPerSecond struct {
	handler Node
}

func (p *nodeProcessorGetWriteNewSeriesLimitPerShardPerSecond) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeGetWriteNewSeriesLimitPerShardPerSecondArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("getWriteNewSeriesLimitPerShardPerSecond", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeGetWriteNewSeriesLimitPerShardPerSecondResult{}
	var retval *NodeWriteNewSeriesLimitPerShardPerSecondResult_
	var err2 error
	if retval, err2 = p.handler.GetWriteNewSeriesLimitPerShardPerSecond(); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getWriteNewSeriesLimitPerShardPerSecond: "+err2.Error())
			oprot.WriteMessageBegin("getWriteNewSeriesLimitPerShardPerSecond", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("getWriteNewSeriesLimitPerShardPerSecond", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type nodeProcessorSetWriteNewSeriesLimitPerShardPerSecond struct {
	handler Node
}

func (p *nodeProcessorSetWriteNewSeriesLimitPerShardPerSecond) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := NodeSetWriteNewSeriesLimitPerShardPerSecondArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("setWriteNewSeriesLimitPerShardPerSecond", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := NodeSetWriteNewSeriesLimitPerShardPerSecondResult{}
	var retval *NodeWriteNewSeriesLimitPerShardPerSecondResult_
	var err2 error
	if retval, err2 = p.handler.SetWriteNewSeriesLimitPerShardPerSecond(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setWriteNewSeriesLimitPerShardPerSecond: "+err2.Error())
			oprot.WriteMessageBegin("setWriteNewSeriesLimitPerShardPerSecond", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("setWriteNewSeriesLimitPerShardPerSecond", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

// HELPER FUNCTIONS AND STRUCTURES

// Attributes:
//  - Req
type NodeQueryArgs struct {
	Req *QueryRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeQueryArgs() *NodeQueryArgs {
	return &NodeQueryArgs{}
}

var NodeQueryArgs_Req_DEFAULT *QueryRequest

func (p *NodeQueryArgs) GetReq() *QueryRequest {
	if !p.IsSetReq() {
		return NodeQueryArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeQueryArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeQueryArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeQueryArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &QueryRequest{
		RangeType: 0,

		ResultTimeType: 0,
	}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeQueryArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("query_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeQueryArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeQueryArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeQueryArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeQueryResult struct {
	Success *QueryResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error        `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeQueryResult() *NodeQueryResult {
	return &NodeQueryResult{}
}

var NodeQueryResult_Success_DEFAULT *QueryResult_

func (p *NodeQueryResult) GetSuccess() *QueryResult_ {
	if !p.IsSetSuccess() {
		return NodeQueryResult_Success_DEFAULT
	}
	return p.Success
}

var NodeQueryResult_Err_DEFAULT *Error

func (p *NodeQueryResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeQueryResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeQueryResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeQueryResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeQueryResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeQueryResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &QueryResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeQueryResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeQueryResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("query_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeQueryResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeQueryResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeQueryResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeQueryResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeAggregateRawArgs struct {
	Req *AggregateQueryRawRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeAggregateRawArgs() *NodeAggregateRawArgs {
	return &NodeAggregateRawArgs{}
}

var NodeAggregateRawArgs_Req_DEFAULT *AggregateQueryRawRequest

func (p *NodeAggregateRawArgs) GetReq() *AggregateQueryRawRequest {
	if !p.IsSetReq() {
		return NodeAggregateRawArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeAggregateRawArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeAggregateRawArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeAggregateRawArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &AggregateQueryRawRequest{
		AggregateQueryType: 1,

		RangeType: 0,
	}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeAggregateRawArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("aggregateRaw_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeAggregateRawArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeAggregateRawArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeAggregateRawArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeAggregateRawResult struct {
	Success *AggregateQueryRawResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                    `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeAggregateRawResult() *NodeAggregateRawResult {
	return &NodeAggregateRawResult{}
}

var NodeAggregateRawResult_Success_DEFAULT *AggregateQueryRawResult_

func (p *NodeAggregateRawResult) GetSuccess() *AggregateQueryRawResult_ {
	if !p.IsSetSuccess() {
		return NodeAggregateRawResult_Success_DEFAULT
	}
	return p.Success
}

var NodeAggregateRawResult_Err_DEFAULT *Error

func (p *NodeAggregateRawResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeAggregateRawResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeAggregateRawResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeAggregateRawResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeAggregateRawResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeAggregateRawResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &AggregateQueryRawResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeAggregateRawResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeAggregateRawResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("aggregateRaw_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeAggregateRawResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeAggregateRawResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeAggregateRawResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeAggregateRawResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeAggregateArgs struct {
	Req *AggregateQueryRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeAggregateArgs() *NodeAggregateArgs {
	return &NodeAggregateArgs{}
}

var NodeAggregateArgs_Req_DEFAULT *AggregateQueryRequest

func (p *NodeAggregateArgs) GetReq() *AggregateQueryRequest {
	if !p.IsSetReq() {
		return NodeAggregateArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeAggregateArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeAggregateArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeAggregateArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &AggregateQueryRequest{
		AggregateQueryType: 1,

		RangeType: 0,
	}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeAggregateArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("aggregate_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeAggregateArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeAggregateArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeAggregateArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeAggregateResult struct {
	Success *AggregateQueryResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                 `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeAggregateResult() *NodeAggregateResult {
	return &NodeAggregateResult{}
}

var NodeAggregateResult_Success_DEFAULT *AggregateQueryResult_

func (p *NodeAggregateResult) GetSuccess() *AggregateQueryResult_ {
	if !p.IsSetSuccess() {
		return NodeAggregateResult_Success_DEFAULT
	}
	return p.Success
}

var NodeAggregateResult_Err_DEFAULT *Error

func (p *NodeAggregateResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeAggregateResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeAggregateResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeAggregateResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeAggregateResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeAggregateResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &AggregateQueryResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeAggregateResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeAggregateResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("aggregate_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeAggregateResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeAggregateResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeAggregateResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeAggregateResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeFetchArgs struct {
	Req *FetchRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeFetchArgs() *NodeFetchArgs {
	return &NodeFetchArgs{}
}

var NodeFetchArgs_Req_DEFAULT *FetchRequest

func (p *NodeFetchArgs) GetReq() *FetchRequest {
	if !p.IsSetReq() {
		return NodeFetchArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeFetchArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeFetchArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeFetchArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &FetchRequest{
		RangeType: 0,

		ResultTimeType: 0,
	}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeFetchArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetch_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeFetchArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeFetchArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeFetchArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeFetchResult struct {
	Success *FetchResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error        `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeFetchResult() *NodeFetchResult {
	return &NodeFetchResult{}
}

var NodeFetchResult_Success_DEFAULT *FetchResult_

func (p *NodeFetchResult) GetSuccess() *FetchResult_ {
	if !p.IsSetSuccess() {
		return NodeFetchResult_Success_DEFAULT
	}
	return p.Success
}

var NodeFetchResult_Err_DEFAULT *Error

func (p *NodeFetchResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeFetchResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeFetchResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeFetchResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeFetchResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeFetchResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &FetchResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeFetchResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeFetchResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetch_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeFetchResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeFetchResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeFetchResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeFetchResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeFetchTaggedArgs struct {
	Req *FetchTaggedRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeFetchTaggedArgs() *NodeFetchTaggedArgs {
	return &NodeFetchTaggedArgs{}
}

var NodeFetchTaggedArgs_Req_DEFAULT *FetchTaggedRequest

func (p *NodeFetchTaggedArgs) GetReq() *FetchTaggedRequest {
	if !p.IsSetReq() {
		return NodeFetchTaggedArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeFetchTaggedArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeFetchTaggedArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeFetchTaggedArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &FetchTaggedRequest{
		RangeTimeType: 0,
	}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeFetchTaggedArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetchTagged_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeFetchTaggedArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeFetchTaggedArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeFetchTaggedArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeFetchTaggedResult struct {
	Success *FetchTaggedResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error              `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeFetchTaggedResult() *NodeFetchTaggedResult {
	return &NodeFetchTaggedResult{}
}

var NodeFetchTaggedResult_Success_DEFAULT *FetchTaggedResult_

func (p *NodeFetchTaggedResult) GetSuccess() *FetchTaggedResult_ {
	if !p.IsSetSuccess() {
		return NodeFetchTaggedResult_Success_DEFAULT
	}
	return p.Success
}

var NodeFetchTaggedResult_Err_DEFAULT *Error

func (p *NodeFetchTaggedResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeFetchTaggedResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeFetchTaggedResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeFetchTaggedResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeFetchTaggedResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeFetchTaggedResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &FetchTaggedResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeFetchTaggedResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeFetchTaggedResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetchTagged_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeFetchTaggedResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeFetchTaggedResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeFetchTaggedResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeFetchTaggedResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeWriteArgs struct {
	Req *WriteRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeWriteArgs() *NodeWriteArgs {
	return &NodeWriteArgs{}
}

var NodeWriteArgs_Req_DEFAULT *WriteRequest

func (p *NodeWriteArgs) GetReq() *WriteRequest {
	if !p.IsSetReq() {
		return NodeWriteArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeWriteArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeWriteArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeWriteArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &WriteRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeWriteArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("write_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeWriteArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteArgs(%+v)", *p)
}

// Attributes:
//  - Err
type NodeWriteResult struct {
	Err *Error `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeWriteResult() *NodeWriteResult {
	return &NodeWriteResult{}
}

var NodeWriteResult_Err_DEFAULT *Error

func (p *NodeWriteResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeWriteResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeWriteResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeWriteResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeWriteResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeWriteResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("write_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeWriteResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeWriteTaggedArgs struct {
	Req *WriteTaggedRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeWriteTaggedArgs() *NodeWriteTaggedArgs {
	return &NodeWriteTaggedArgs{}
}

var NodeWriteTaggedArgs_Req_DEFAULT *WriteTaggedRequest

func (p *NodeWriteTaggedArgs) GetReq() *WriteTaggedRequest {
	if !p.IsSetReq() {
		return NodeWriteTaggedArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeWriteTaggedArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeWriteTaggedArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeWriteTaggedArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &WriteTaggedRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeWriteTaggedArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("writeTagged_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteTaggedArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeWriteTaggedArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteTaggedArgs(%+v)", *p)
}

// Attributes:
//  - Err
type NodeWriteTaggedResult struct {
	Err *Error `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeWriteTaggedResult() *NodeWriteTaggedResult {
	return &NodeWriteTaggedResult{}
}

var NodeWriteTaggedResult_Err_DEFAULT *Error

func (p *NodeWriteTaggedResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeWriteTaggedResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeWriteTaggedResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeWriteTaggedResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeWriteTaggedResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeWriteTaggedResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("writeTagged_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteTaggedResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeWriteTaggedResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteTaggedResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeFetchBatchRawArgs struct {
	Req *FetchBatchRawRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeFetchBatchRawArgs() *NodeFetchBatchRawArgs {
	return &NodeFetchBatchRawArgs{}
}

var NodeFetchBatchRawArgs_Req_DEFAULT *FetchBatchRawRequest

func (p *NodeFetchBatchRawArgs) GetReq() *FetchBatchRawRequest {
	if !p.IsSetReq() {
		return NodeFetchBatchRawArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeFetchBatchRawArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeFetchBatchRawArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeFetchBatchRawArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &FetchBatchRawRequest{
		RangeTimeType: 0,
	}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeFetchBatchRawArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetchBatchRaw_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeFetchBatchRawArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeFetchBatchRawArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeFetchBatchRawArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeFetchBatchRawResult struct {
	Success *FetchBatchRawResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeFetchBatchRawResult() *NodeFetchBatchRawResult {
	return &NodeFetchBatchRawResult{}
}

var NodeFetchBatchRawResult_Success_DEFAULT *FetchBatchRawResult_

func (p *NodeFetchBatchRawResult) GetSuccess() *FetchBatchRawResult_ {
	if !p.IsSetSuccess() {
		return NodeFetchBatchRawResult_Success_DEFAULT
	}
	return p.Success
}

var NodeFetchBatchRawResult_Err_DEFAULT *Error

func (p *NodeFetchBatchRawResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeFetchBatchRawResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeFetchBatchRawResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeFetchBatchRawResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeFetchBatchRawResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeFetchBatchRawResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &FetchBatchRawResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeFetchBatchRawResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeFetchBatchRawResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetchBatchRaw_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeFetchBatchRawResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeFetchBatchRawResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeFetchBatchRawResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeFetchBatchRawResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeFetchBatchRawV2Args struct {
	Req *FetchBatchRawV2Request `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeFetchBatchRawV2Args() *NodeFetchBatchRawV2Args {
	return &NodeFetchBatchRawV2Args{}
}

var NodeFetchBatchRawV2Args_Req_DEFAULT *FetchBatchRawV2Request

func (p *NodeFetchBatchRawV2Args) GetReq() *FetchBatchRawV2Request {
	if !p.IsSetReq() {
		return NodeFetchBatchRawV2Args_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeFetchBatchRawV2Args) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeFetchBatchRawV2Args) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeFetchBatchRawV2Args) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &FetchBatchRawV2Request{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeFetchBatchRawV2Args) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetchBatchRawV2_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeFetchBatchRawV2Args) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeFetchBatchRawV2Args) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeFetchBatchRawV2Args(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeFetchBatchRawV2Result struct {
	Success *FetchBatchRawResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeFetchBatchRawV2Result() *NodeFetchBatchRawV2Result {
	return &NodeFetchBatchRawV2Result{}
}

var NodeFetchBatchRawV2Result_Success_DEFAULT *FetchBatchRawResult_

func (p *NodeFetchBatchRawV2Result) GetSuccess() *FetchBatchRawResult_ {
	if !p.IsSetSuccess() {
		return NodeFetchBatchRawV2Result_Success_DEFAULT
	}
	return p.Success
}

var NodeFetchBatchRawV2Result_Err_DEFAULT *Error

func (p *NodeFetchBatchRawV2Result) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeFetchBatchRawV2Result_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeFetchBatchRawV2Result) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeFetchBatchRawV2Result) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeFetchBatchRawV2Result) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeFetchBatchRawV2Result) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &FetchBatchRawResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeFetchBatchRawV2Result) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeFetchBatchRawV2Result) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetchBatchRawV2_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeFetchBatchRawV2Result) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeFetchBatchRawV2Result) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeFetchBatchRawV2Result) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeFetchBatchRawV2Result(%+v)", *p)
}

// Attributes:
//  - Req
type NodeFetchBlocksRawArgs struct {
	Req *FetchBlocksRawRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeFetchBlocksRawArgs() *NodeFetchBlocksRawArgs {
	return &NodeFetchBlocksRawArgs{}
}

var NodeFetchBlocksRawArgs_Req_DEFAULT *FetchBlocksRawRequest

func (p *NodeFetchBlocksRawArgs) GetReq() *FetchBlocksRawRequest {
	if !p.IsSetReq() {
		return NodeFetchBlocksRawArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeFetchBlocksRawArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeFetchBlocksRawArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeFetchBlocksRawArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &FetchBlocksRawRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeFetchBlocksRawArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetchBlocksRaw_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeFetchBlocksRawArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeFetchBlocksRawArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeFetchBlocksRawArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeFetchBlocksRawResult struct {
	Success *FetchBlocksRawResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                 `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeFetchBlocksRawResult() *NodeFetchBlocksRawResult {
	return &NodeFetchBlocksRawResult{}
}

var NodeFetchBlocksRawResult_Success_DEFAULT *FetchBlocksRawResult_

func (p *NodeFetchBlocksRawResult) GetSuccess() *FetchBlocksRawResult_ {
	if !p.IsSetSuccess() {
		return NodeFetchBlocksRawResult_Success_DEFAULT
	}
	return p.Success
}

var NodeFetchBlocksRawResult_Err_DEFAULT *Error

func (p *NodeFetchBlocksRawResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeFetchBlocksRawResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeFetchBlocksRawResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeFetchBlocksRawResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeFetchBlocksRawResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeFetchBlocksRawResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &FetchBlocksRawResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeFetchBlocksRawResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeFetchBlocksRawResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetchBlocksRaw_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeFetchBlocksRawResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeFetchBlocksRawResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeFetchBlocksRawResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeFetchBlocksRawResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeFetchBlocksMetadataRawV2Args struct {
	Req *FetchBlocksMetadataRawV2Request `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeFetchBlocksMetadataRawV2Args() *NodeFetchBlocksMetadataRawV2Args {
	return &NodeFetchBlocksMetadataRawV2Args{}
}

var NodeFetchBlocksMetadataRawV2Args_Req_DEFAULT *FetchBlocksMetadataRawV2Request

func (p *NodeFetchBlocksMetadataRawV2Args) GetReq() *FetchBlocksMetadataRawV2Request {
	if !p.IsSetReq() {
		return NodeFetchBlocksMetadataRawV2Args_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeFetchBlocksMetadataRawV2Args) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeFetchBlocksMetadataRawV2Args) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeFetchBlocksMetadataRawV2Args) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &FetchBlocksMetadataRawV2Request{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeFetchBlocksMetadataRawV2Args) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetchBlocksMetadataRawV2_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeFetchBlocksMetadataRawV2Args) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeFetchBlocksMetadataRawV2Args) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeFetchBlocksMetadataRawV2Args(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeFetchBlocksMetadataRawV2Result struct {
	Success *FetchBlocksMetadataRawV2Result_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                           `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeFetchBlocksMetadataRawV2Result() *NodeFetchBlocksMetadataRawV2Result {
	return &NodeFetchBlocksMetadataRawV2Result{}
}

var NodeFetchBlocksMetadataRawV2Result_Success_DEFAULT *FetchBlocksMetadataRawV2Result_

func (p *NodeFetchBlocksMetadataRawV2Result) GetSuccess() *FetchBlocksMetadataRawV2Result_ {
	if !p.IsSetSuccess() {
		return NodeFetchBlocksMetadataRawV2Result_Success_DEFAULT
	}
	return p.Success
}

var NodeFetchBlocksMetadataRawV2Result_Err_DEFAULT *Error

func (p *NodeFetchBlocksMetadataRawV2Result) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeFetchBlocksMetadataRawV2Result_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeFetchBlocksMetadataRawV2Result) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeFetchBlocksMetadataRawV2Result) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeFetchBlocksMetadataRawV2Result) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeFetchBlocksMetadataRawV2Result) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &FetchBlocksMetadataRawV2Result_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeFetchBlocksMetadataRawV2Result) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeFetchBlocksMetadataRawV2Result) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetchBlocksMetadataRawV2_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeFetchBlocksMetadataRawV2Result) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeFetchBlocksMetadataRawV2Result) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeFetchBlocksMetadataRawV2Result) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeFetchBlocksMetadataRawV2Result(%+v)", *p)
}

// Attributes:
//  - Req
type NodeWriteBatchRawArgs struct {
	Req *WriteBatchRawRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeWriteBatchRawArgs() *NodeWriteBatchRawArgs {
	return &NodeWriteBatchRawArgs{}
}

var NodeWriteBatchRawArgs_Req_DEFAULT *WriteBatchRawRequest

func (p *NodeWriteBatchRawArgs) GetReq() *WriteBatchRawRequest {
	if !p.IsSetReq() {
		return NodeWriteBatchRawArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeWriteBatchRawArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeWriteBatchRawArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeWriteBatchRawArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &WriteBatchRawRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeWriteBatchRawArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("writeBatchRaw_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteBatchRawArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeWriteBatchRawArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteBatchRawArgs(%+v)", *p)
}

// Attributes:
//  - Err
type NodeWriteBatchRawResult struct {
	Err *WriteBatchRawErrors `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeWriteBatchRawResult() *NodeWriteBatchRawResult {
	return &NodeWriteBatchRawResult{}
}

var NodeWriteBatchRawResult_Err_DEFAULT *WriteBatchRawErrors

func (p *NodeWriteBatchRawResult) GetErr() *WriteBatchRawErrors {
	if !p.IsSetErr() {
		return NodeWriteBatchRawResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeWriteBatchRawResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeWriteBatchRawResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeWriteBatchRawResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &WriteBatchRawErrors{}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeWriteBatchRawResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("writeBatchRaw_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteBatchRawResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeWriteBatchRawResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteBatchRawResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeWriteBatchRawV2Args struct {
	Req *WriteBatchRawV2Request `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeWriteBatchRawV2Args() *NodeWriteBatchRawV2Args {
	return &NodeWriteBatchRawV2Args{}
}

var NodeWriteBatchRawV2Args_Req_DEFAULT *WriteBatchRawV2Request

func (p *NodeWriteBatchRawV2Args) GetReq() *WriteBatchRawV2Request {
	if !p.IsSetReq() {
		return NodeWriteBatchRawV2Args_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeWriteBatchRawV2Args) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeWriteBatchRawV2Args) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeWriteBatchRawV2Args) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &WriteBatchRawV2Request{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeWriteBatchRawV2Args) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("writeBatchRawV2_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteBatchRawV2Args) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeWriteBatchRawV2Args) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteBatchRawV2Args(%+v)", *p)
}

// Attributes:
//  - Err
type NodeWriteBatchRawV2Result struct {
	Err *WriteBatchRawErrors `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeWriteBatchRawV2Result() *NodeWriteBatchRawV2Result {
	return &NodeWriteBatchRawV2Result{}
}

var NodeWriteBatchRawV2Result_Err_DEFAULT *WriteBatchRawErrors

func (p *NodeWriteBatchRawV2Result) GetErr() *WriteBatchRawErrors {
	if !p.IsSetErr() {
		return NodeWriteBatchRawV2Result_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeWriteBatchRawV2Result) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeWriteBatchRawV2Result) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeWriteBatchRawV2Result) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &WriteBatchRawErrors{}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeWriteBatchRawV2Result) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("writeBatchRawV2_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteBatchRawV2Result) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeWriteBatchRawV2Result) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteBatchRawV2Result(%+v)", *p)
}

// Attributes:
//  - Req
type NodeWriteTaggedBatchRawArgs struct {
	Req *WriteTaggedBatchRawRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeWriteTaggedBatchRawArgs() *NodeWriteTaggedBatchRawArgs {
	return &NodeWriteTaggedBatchRawArgs{}
}

var NodeWriteTaggedBatchRawArgs_Req_DEFAULT *WriteTaggedBatchRawRequest

func (p *NodeWriteTaggedBatchRawArgs) GetReq() *WriteTaggedBatchRawRequest {
	if !p.IsSetReq() {
		return NodeWriteTaggedBatchRawArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeWriteTaggedBatchRawArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeWriteTaggedBatchRawArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeWriteTaggedBatchRawArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &WriteTaggedBatchRawRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeWriteTaggedBatchRawArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("writeTaggedBatchRaw_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteTaggedBatchRawArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeWriteTaggedBatchRawArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteTaggedBatchRawArgs(%+v)", *p)
}

// Attributes:
//  - Err
type NodeWriteTaggedBatchRawResult struct {
	Err *WriteBatchRawErrors `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeWriteTaggedBatchRawResult() *NodeWriteTaggedBatchRawResult {
	return &NodeWriteTaggedBatchRawResult{}
}

var NodeWriteTaggedBatchRawResult_Err_DEFAULT *WriteBatchRawErrors

func (p *NodeWriteTaggedBatchRawResult) GetErr() *WriteBatchRawErrors {
	if !p.IsSetErr() {
		return NodeWriteTaggedBatchRawResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeWriteTaggedBatchRawResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeWriteTaggedBatchRawResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeWriteTaggedBatchRawResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &WriteBatchRawErrors{}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeWriteTaggedBatchRawResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("writeTaggedBatchRaw_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteTaggedBatchRawResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeWriteTaggedBatchRawResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteTaggedBatchRawResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeWriteTaggedBatchRawV2Args struct {
	Req *WriteTaggedBatchRawV2Request `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeWriteTaggedBatchRawV2Args() *NodeWriteTaggedBatchRawV2Args {
	return &NodeWriteTaggedBatchRawV2Args{}
}

var NodeWriteTaggedBatchRawV2Args_Req_DEFAULT *WriteTaggedBatchRawV2Request

func (p *NodeWriteTaggedBatchRawV2Args) GetReq() *WriteTaggedBatchRawV2Request {
	if !p.IsSetReq() {
		return NodeWriteTaggedBatchRawV2Args_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeWriteTaggedBatchRawV2Args) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeWriteTaggedBatchRawV2Args) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeWriteTaggedBatchRawV2Args) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &WriteTaggedBatchRawV2Request{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeWriteTaggedBatchRawV2Args) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("writeTaggedBatchRawV2_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteTaggedBatchRawV2Args) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeWriteTaggedBatchRawV2Args) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteTaggedBatchRawV2Args(%+v)", *p)
}

// Attributes:
//  - Err
type NodeWriteTaggedBatchRawV2Result struct {
	Err *WriteBatchRawErrors `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeWriteTaggedBatchRawV2Result() *NodeWriteTaggedBatchRawV2Result {
	return &NodeWriteTaggedBatchRawV2Result{}
}

var NodeWriteTaggedBatchRawV2Result_Err_DEFAULT *WriteBatchRawErrors

func (p *NodeWriteTaggedBatchRawV2Result) GetErr() *WriteBatchRawErrors {
	if !p.IsSetErr() {
		return NodeWriteTaggedBatchRawV2Result_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeWriteTaggedBatchRawV2Result) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeWriteTaggedBatchRawV2Result) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeWriteTaggedBatchRawV2Result) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &WriteBatchRawErrors{}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeWriteTaggedBatchRawV2Result) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("writeTaggedBatchRawV2_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeWriteTaggedBatchRawV2Result) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeWriteTaggedBatchRawV2Result) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeWriteTaggedBatchRawV2Result(%+v)", *p)
}

type NodeRepairArgs struct {
}

func NewNodeRepairArgs() *NodeRepairArgs {
	return &NodeRepairArgs{}
}

func (p *NodeRepairArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeRepairArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("repair_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeRepairArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeRepairArgs(%+v)", *p)
}

// Attributes:
//  - Err
type NodeRepairResult struct {
	Err *Error `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeRepairResult() *NodeRepairResult {
	return &NodeRepairResult{}
}

var NodeRepairResult_Err_DEFAULT *Error

func (p *NodeRepairResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeRepairResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeRepairResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeRepairResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeRepairResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeRepairResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("repair_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeRepairResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeRepairResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeRepairResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeTruncateArgs struct {
	Req *TruncateRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeTruncateArgs() *NodeTruncateArgs {
	return &NodeTruncateArgs{}
}

var NodeTruncateArgs_Req_DEFAULT *TruncateRequest

func (p *NodeTruncateArgs) GetReq() *TruncateRequest {
	if !p.IsSetReq() {
		return NodeTruncateArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeTruncateArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeTruncateArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeTruncateArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &TruncateRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeTruncateArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("truncate_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeTruncateArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeTruncateArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeTruncateArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeTruncateResult struct {
	Success *TruncateResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error           `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeTruncateResult() *NodeTruncateResult {
	return &NodeTruncateResult{}
}

var NodeTruncateResult_Success_DEFAULT *TruncateResult_

func (p *NodeTruncateResult) GetSuccess() *TruncateResult_ {
	if !p.IsSetSuccess() {
		return NodeTruncateResult_Success_DEFAULT
	}
	return p.Success
}

var NodeTruncateResult_Err_DEFAULT *Error

func (p *NodeTruncateResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeTruncateResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeTruncateResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeTruncateResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeTruncateResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeTruncateResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &TruncateResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeTruncateResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeTruncateResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("truncate_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeTruncateResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeTruncateResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeTruncateResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeTruncateResult(%+v)", *p)
}

type NodeHealthArgs struct {
}

func NewNodeHealthArgs() *NodeHealthArgs {
	return &NodeHealthArgs{}
}

func (p *NodeHealthArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeHealthArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("health_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeHealthArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeHealthArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeHealthResult struct {
	Success *NodeHealthResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error             `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeHealthResult() *NodeHealthResult {
	return &NodeHealthResult{}
}

var NodeHealthResult_Success_DEFAULT *NodeHealthResult_

func (p *NodeHealthResult) GetSuccess() *NodeHealthResult_ {
	if !p.IsSetSuccess() {
		return NodeHealthResult_Success_DEFAULT
	}
	return p.Success
}

var NodeHealthResult_Err_DEFAULT *Error

func (p *NodeHealthResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeHealthResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeHealthResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeHealthResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeHealthResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeHealthResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &NodeHealthResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeHealthResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeHealthResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("health_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeHealthResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeHealthResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeHealthResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeHealthResult(%+v)", *p)
}

type NodeBootstrappedArgs struct {
}

func NewNodeBootstrappedArgs() *NodeBootstrappedArgs {
	return &NodeBootstrappedArgs{}
}

func (p *NodeBootstrappedArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeBootstrappedArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("bootstrapped_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeBootstrappedArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeBootstrappedArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeBootstrappedResult struct {
	Success *NodeBootstrappedResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                   `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeBootstrappedResult() *NodeBootstrappedResult {
	return &NodeBootstrappedResult{}
}

var NodeBootstrappedResult_Success_DEFAULT *NodeBootstrappedResult_

func (p *NodeBootstrappedResult) GetSuccess() *NodeBootstrappedResult_ {
	if !p.IsSetSuccess() {
		return NodeBootstrappedResult_Success_DEFAULT
	}
	return p.Success
}

var NodeBootstrappedResult_Err_DEFAULT *Error

func (p *NodeBootstrappedResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeBootstrappedResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeBootstrappedResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeBootstrappedResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeBootstrappedResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeBootstrappedResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &NodeBootstrappedResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeBootstrappedResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeBootstrappedResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("bootstrapped_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeBootstrappedResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeBootstrappedResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeBootstrappedResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeBootstrappedResult(%+v)", *p)
}

type NodeBootstrappedInPlacementOrNoPlacementArgs struct {
}

func NewNodeBootstrappedInPlacementOrNoPlacementArgs() *NodeBootstrappedInPlacementOrNoPlacementArgs {
	return &NodeBootstrappedInPlacementOrNoPlacementArgs{}
}

func (p *NodeBootstrappedInPlacementOrNoPlacementArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeBootstrappedInPlacementOrNoPlacementArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("bootstrappedInPlacementOrNoPlacement_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeBootstrappedInPlacementOrNoPlacementArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeBootstrappedInPlacementOrNoPlacementArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeBootstrappedInPlacementOrNoPlacementResult struct {
	Success *NodeBootstrappedInPlacementOrNoPlacementResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                                           `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeBootstrappedInPlacementOrNoPlacementResult() *NodeBootstrappedInPlacementOrNoPlacementResult {
	return &NodeBootstrappedInPlacementOrNoPlacementResult{}
}

var NodeBootstrappedInPlacementOrNoPlacementResult_Success_DEFAULT *NodeBootstrappedInPlacementOrNoPlacementResult_

func (p *NodeBootstrappedInPlacementOrNoPlacementResult) GetSuccess() *NodeBootstrappedInPlacementOrNoPlacementResult_ {
	if !p.IsSetSuccess() {
		return NodeBootstrappedInPlacementOrNoPlacementResult_Success_DEFAULT
	}
	return p.Success
}

var NodeBootstrappedInPlacementOrNoPlacementResult_Err_DEFAULT *Error

func (p *NodeBootstrappedInPlacementOrNoPlacementResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeBootstrappedInPlacementOrNoPlacementResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeBootstrappedInPlacementOrNoPlacementResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeBootstrappedInPlacementOrNoPlacementResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeBootstrappedInPlacementOrNoPlacementResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeBootstrappedInPlacementOrNoPlacementResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &NodeBootstrappedInPlacementOrNoPlacementResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeBootstrappedInPlacementOrNoPlacementResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeBootstrappedInPlacementOrNoPlacementResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("bootstrappedInPlacementOrNoPlacement_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeBootstrappedInPlacementOrNoPlacementResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeBootstrappedInPlacementOrNoPlacementResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeBootstrappedInPlacementOrNoPlacementResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeBootstrappedInPlacementOrNoPlacementResult(%+v)", *p)
}

type NodeGetPersistRateLimitArgs struct {
}

func NewNodeGetPersistRateLimitArgs() *NodeGetPersistRateLimitArgs {
	return &NodeGetPersistRateLimitArgs{}
}

func (p *NodeGetPersistRateLimitArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeGetPersistRateLimitArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("getPersistRateLimit_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeGetPersistRateLimitArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeGetPersistRateLimitArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeGetPersistRateLimitResult struct {
	Success *NodePersistRateLimitResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                       `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeGetPersistRateLimitResult() *NodeGetPersistRateLimitResult {
	return &NodeGetPersistRateLimitResult{}
}

var NodeGetPersistRateLimitResult_Success_DEFAULT *NodePersistRateLimitResult_

func (p *NodeGetPersistRateLimitResult) GetSuccess() *NodePersistRateLimitResult_ {
	if !p.IsSetSuccess() {
		return NodeGetPersistRateLimitResult_Success_DEFAULT
	}
	return p.Success
}

var NodeGetPersistRateLimitResult_Err_DEFAULT *Error

func (p *NodeGetPersistRateLimitResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeGetPersistRateLimitResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeGetPersistRateLimitResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeGetPersistRateLimitResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeGetPersistRateLimitResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeGetPersistRateLimitResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &NodePersistRateLimitResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeGetPersistRateLimitResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeGetPersistRateLimitResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("getPersistRateLimit_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeGetPersistRateLimitResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeGetPersistRateLimitResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeGetPersistRateLimitResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeGetPersistRateLimitResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeSetPersistRateLimitArgs struct {
	Req *NodeSetPersistRateLimitRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeSetPersistRateLimitArgs() *NodeSetPersistRateLimitArgs {
	return &NodeSetPersistRateLimitArgs{}
}

var NodeSetPersistRateLimitArgs_Req_DEFAULT *NodeSetPersistRateLimitRequest

func (p *NodeSetPersistRateLimitArgs) GetReq() *NodeSetPersistRateLimitRequest {
	if !p.IsSetReq() {
		return NodeSetPersistRateLimitArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeSetPersistRateLimitArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeSetPersistRateLimitArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeSetPersistRateLimitArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &NodeSetPersistRateLimitRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeSetPersistRateLimitArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("setPersistRateLimit_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeSetPersistRateLimitArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeSetPersistRateLimitArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeSetPersistRateLimitArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeSetPersistRateLimitResult struct {
	Success *NodePersistRateLimitResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                       `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeSetPersistRateLimitResult() *NodeSetPersistRateLimitResult {
	return &NodeSetPersistRateLimitResult{}
}

var NodeSetPersistRateLimitResult_Success_DEFAULT *NodePersistRateLimitResult_

func (p *NodeSetPersistRateLimitResult) GetSuccess() *NodePersistRateLimitResult_ {
	if !p.IsSetSuccess() {
		return NodeSetPersistRateLimitResult_Success_DEFAULT
	}
	return p.Success
}

var NodeSetPersistRateLimitResult_Err_DEFAULT *Error

func (p *NodeSetPersistRateLimitResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeSetPersistRateLimitResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeSetPersistRateLimitResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeSetPersistRateLimitResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeSetPersistRateLimitResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeSetPersistRateLimitResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &NodePersistRateLimitResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeSetPersistRateLimitResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeSetPersistRateLimitResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("setPersistRateLimit_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeSetPersistRateLimitResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeSetPersistRateLimitResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeSetPersistRateLimitResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeSetPersistRateLimitResult(%+v)", *p)
}

type NodeGetWriteNewSeriesAsyncArgs struct {
}

func NewNodeGetWriteNewSeriesAsyncArgs() *NodeGetWriteNewSeriesAsyncArgs {
	return &NodeGetWriteNewSeriesAsyncArgs{}
}

func (p *NodeGetWriteNewSeriesAsyncArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesAsyncArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("getWriteNewSeriesAsync_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesAsyncArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeGetWriteNewSeriesAsyncArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeGetWriteNewSeriesAsyncResult struct {
	Success *NodeWriteNewSeriesAsyncResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                          `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeGetWriteNewSeriesAsyncResult() *NodeGetWriteNewSeriesAsyncResult {
	return &NodeGetWriteNewSeriesAsyncResult{}
}

var NodeGetWriteNewSeriesAsyncResult_Success_DEFAULT *NodeWriteNewSeriesAsyncResult_

func (p *NodeGetWriteNewSeriesAsyncResult) GetSuccess() *NodeWriteNewSeriesAsyncResult_ {
	if !p.IsSetSuccess() {
		return NodeGetWriteNewSeriesAsyncResult_Success_DEFAULT
	}
	return p.Success
}

var NodeGetWriteNewSeriesAsyncResult_Err_DEFAULT *Error

func (p *NodeGetWriteNewSeriesAsyncResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeGetWriteNewSeriesAsyncResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeGetWriteNewSeriesAsyncResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeGetWriteNewSeriesAsyncResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeGetWriteNewSeriesAsyncResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesAsyncResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &NodeWriteNewSeriesAsyncResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesAsyncResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesAsyncResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("getWriteNewSeriesAsync_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesAsyncResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeGetWriteNewSeriesAsyncResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeGetWriteNewSeriesAsyncResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeGetWriteNewSeriesAsyncResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeSetWriteNewSeriesAsyncArgs struct {
	Req *NodeSetWriteNewSeriesAsyncRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeSetWriteNewSeriesAsyncArgs() *NodeSetWriteNewSeriesAsyncArgs {
	return &NodeSetWriteNewSeriesAsyncArgs{}
}

var NodeSetWriteNewSeriesAsyncArgs_Req_DEFAULT *NodeSetWriteNewSeriesAsyncRequest

func (p *NodeSetWriteNewSeriesAsyncArgs) GetReq() *NodeSetWriteNewSeriesAsyncRequest {
	if !p.IsSetReq() {
		return NodeSetWriteNewSeriesAsyncArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeSetWriteNewSeriesAsyncArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeSetWriteNewSeriesAsyncArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesAsyncArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &NodeSetWriteNewSeriesAsyncRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesAsyncArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("setWriteNewSeriesAsync_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesAsyncArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeSetWriteNewSeriesAsyncArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeSetWriteNewSeriesAsyncArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeSetWriteNewSeriesAsyncResult struct {
	Success *NodeWriteNewSeriesAsyncResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                          `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeSetWriteNewSeriesAsyncResult() *NodeSetWriteNewSeriesAsyncResult {
	return &NodeSetWriteNewSeriesAsyncResult{}
}

var NodeSetWriteNewSeriesAsyncResult_Success_DEFAULT *NodeWriteNewSeriesAsyncResult_

func (p *NodeSetWriteNewSeriesAsyncResult) GetSuccess() *NodeWriteNewSeriesAsyncResult_ {
	if !p.IsSetSuccess() {
		return NodeSetWriteNewSeriesAsyncResult_Success_DEFAULT
	}
	return p.Success
}

var NodeSetWriteNewSeriesAsyncResult_Err_DEFAULT *Error

func (p *NodeSetWriteNewSeriesAsyncResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeSetWriteNewSeriesAsyncResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeSetWriteNewSeriesAsyncResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeSetWriteNewSeriesAsyncResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeSetWriteNewSeriesAsyncResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesAsyncResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &NodeWriteNewSeriesAsyncResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesAsyncResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesAsyncResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("setWriteNewSeriesAsync_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesAsyncResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeSetWriteNewSeriesAsyncResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeSetWriteNewSeriesAsyncResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeSetWriteNewSeriesAsyncResult(%+v)", *p)
}

type NodeGetWriteNewSeriesBackoffDurationArgs struct {
}

func NewNodeGetWriteNewSeriesBackoffDurationArgs() *NodeGetWriteNewSeriesBackoffDurationArgs {
	return &NodeGetWriteNewSeriesBackoffDurationArgs{}
}

func (p *NodeGetWriteNewSeriesBackoffDurationArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesBackoffDurationArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("getWriteNewSeriesBackoffDuration_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesBackoffDurationArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeGetWriteNewSeriesBackoffDurationArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeGetWriteNewSeriesBackoffDurationResult struct {
	Success *NodeWriteNewSeriesBackoffDurationResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                                    `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeGetWriteNewSeriesBackoffDurationResult() *NodeGetWriteNewSeriesBackoffDurationResult {
	return &NodeGetWriteNewSeriesBackoffDurationResult{}
}

var NodeGetWriteNewSeriesBackoffDurationResult_Success_DEFAULT *NodeWriteNewSeriesBackoffDurationResult_

func (p *NodeGetWriteNewSeriesBackoffDurationResult) GetSuccess() *NodeWriteNewSeriesBackoffDurationResult_ {
	if !p.IsSetSuccess() {
		return NodeGetWriteNewSeriesBackoffDurationResult_Success_DEFAULT
	}
	return p.Success
}

var NodeGetWriteNewSeriesBackoffDurationResult_Err_DEFAULT *Error

func (p *NodeGetWriteNewSeriesBackoffDurationResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeGetWriteNewSeriesBackoffDurationResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeGetWriteNewSeriesBackoffDurationResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeGetWriteNewSeriesBackoffDurationResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeGetWriteNewSeriesBackoffDurationResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesBackoffDurationResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &NodeWriteNewSeriesBackoffDurationResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesBackoffDurationResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesBackoffDurationResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("getWriteNewSeriesBackoffDuration_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesBackoffDurationResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeGetWriteNewSeriesBackoffDurationResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeGetWriteNewSeriesBackoffDurationResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeGetWriteNewSeriesBackoffDurationResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeSetWriteNewSeriesBackoffDurationArgs struct {
	Req *NodeSetWriteNewSeriesBackoffDurationRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeSetWriteNewSeriesBackoffDurationArgs() *NodeSetWriteNewSeriesBackoffDurationArgs {
	return &NodeSetWriteNewSeriesBackoffDurationArgs{}
}

var NodeSetWriteNewSeriesBackoffDurationArgs_Req_DEFAULT *NodeSetWriteNewSeriesBackoffDurationRequest

func (p *NodeSetWriteNewSeriesBackoffDurationArgs) GetReq() *NodeSetWriteNewSeriesBackoffDurationRequest {
	if !p.IsSetReq() {
		return NodeSetWriteNewSeriesBackoffDurationArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeSetWriteNewSeriesBackoffDurationArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &NodeSetWriteNewSeriesBackoffDurationRequest{
		DurationType: 2,
	}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("setWriteNewSeriesBackoffDuration_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeSetWriteNewSeriesBackoffDurationArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeSetWriteNewSeriesBackoffDurationArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeSetWriteNewSeriesBackoffDurationResult struct {
	Success *NodeWriteNewSeriesBackoffDurationResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                                    `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeSetWriteNewSeriesBackoffDurationResult() *NodeSetWriteNewSeriesBackoffDurationResult {
	return &NodeSetWriteNewSeriesBackoffDurationResult{}
}

var NodeSetWriteNewSeriesBackoffDurationResult_Success_DEFAULT *NodeWriteNewSeriesBackoffDurationResult_

func (p *NodeSetWriteNewSeriesBackoffDurationResult) GetSuccess() *NodeWriteNewSeriesBackoffDurationResult_ {
	if !p.IsSetSuccess() {
		return NodeSetWriteNewSeriesBackoffDurationResult_Success_DEFAULT
	}
	return p.Success
}

var NodeSetWriteNewSeriesBackoffDurationResult_Err_DEFAULT *Error

func (p *NodeSetWriteNewSeriesBackoffDurationResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeSetWriteNewSeriesBackoffDurationResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeSetWriteNewSeriesBackoffDurationResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &NodeWriteNewSeriesBackoffDurationResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("setWriteNewSeriesBackoffDuration_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesBackoffDurationResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeSetWriteNewSeriesBackoffDurationResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeSetWriteNewSeriesBackoffDurationResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeSetWriteNewSeriesBackoffDurationResult(%+v)", *p)
}

type NodeGetWriteNewSeriesLimitPerShardPerSecondArgs struct {
}

func NewNodeGetWriteNewSeriesLimitPerShardPerSecondArgs() *NodeGetWriteNewSeriesLimitPerShardPerSecondArgs {
	return &NodeGetWriteNewSeriesLimitPerShardPerSecondArgs{}
}

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("getWriteNewSeriesLimitPerShardPerSecond_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeGetWriteNewSeriesLimitPerShardPerSecondArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeGetWriteNewSeriesLimitPerShardPerSecondResult struct {
	Success *NodeWriteNewSeriesLimitPerShardPerSecondResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                                           `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeGetWriteNewSeriesLimitPerShardPerSecondResult() *NodeGetWriteNewSeriesLimitPerShardPerSecondResult {
	return &NodeGetWriteNewSeriesLimitPerShardPerSecondResult{}
}

var NodeGetWriteNewSeriesLimitPerShardPerSecondResult_Success_DEFAULT *NodeWriteNewSeriesLimitPerShardPerSecondResult_

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondResult) GetSuccess() *NodeWriteNewSeriesLimitPerShardPerSecondResult_ {
	if !p.IsSetSuccess() {
		return NodeGetWriteNewSeriesLimitPerShardPerSecondResult_Success_DEFAULT
	}
	return p.Success
}

var NodeGetWriteNewSeriesLimitPerShardPerSecondResult_Err_DEFAULT *Error

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeGetWriteNewSeriesLimitPerShardPerSecondResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &NodeWriteNewSeriesLimitPerShardPerSecondResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("getWriteNewSeriesLimitPerShardPerSecond_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeGetWriteNewSeriesLimitPerShardPerSecondResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeGetWriteNewSeriesLimitPerShardPerSecondResult(%+v)", *p)
}

// Attributes:
//  - Req
type NodeSetWriteNewSeriesLimitPerShardPerSecondArgs struct {
	Req *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewNodeSetWriteNewSeriesLimitPerShardPerSecondArgs() *NodeSetWriteNewSeriesLimitPerShardPerSecondArgs {
	return &NodeSetWriteNewSeriesLimitPerShardPerSecondArgs{}
}

var NodeSetWriteNewSeriesLimitPerShardPerSecondArgs_Req_DEFAULT *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondArgs) GetReq() *NodeSetWriteNewSeriesLimitPerShardPerSecondRequest {
	if !p.IsSetReq() {
		return NodeSetWriteNewSeriesLimitPerShardPerSecondArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &NodeSetWriteNewSeriesLimitPerShardPerSecondRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("setWriteNewSeriesLimitPerShardPerSecond_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeSetWriteNewSeriesLimitPerShardPerSecondArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type NodeSetWriteNewSeriesLimitPerShardPerSecondResult struct {
	Success *NodeWriteNewSeriesLimitPerShardPerSecondResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                                           `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewNodeSetWriteNewSeriesLimitPerShardPerSecondResult() *NodeSetWriteNewSeriesLimitPerShardPerSecondResult {
	return &NodeSetWriteNewSeriesLimitPerShardPerSecondResult{}
}

var NodeSetWriteNewSeriesLimitPerShardPerSecondResult_Success_DEFAULT *NodeWriteNewSeriesLimitPerShardPerSecondResult_

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondResult) GetSuccess() *NodeWriteNewSeriesLimitPerShardPerSecondResult_ {
	if !p.IsSetSuccess() {
		return NodeSetWriteNewSeriesLimitPerShardPerSecondResult_Success_DEFAULT
	}
	return p.Success
}

var NodeSetWriteNewSeriesLimitPerShardPerSecondResult_Err_DEFAULT *Error

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondResult) GetErr() *Error {
	if !p.IsSetErr() {
		return NodeSetWriteNewSeriesLimitPerShardPerSecondResult_Err_DEFAULT
	}
	return p.Err
}
func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &NodeWriteNewSeriesLimitPerShardPerSecondResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("setWriteNewSeriesLimitPerShardPerSecond_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *NodeSetWriteNewSeriesLimitPerShardPerSecondResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeSetWriteNewSeriesLimitPerShardPerSecondResult(%+v)", *p)
}

type Cluster interface {
	Health() (r *HealthResult_, err error)
	// Parameters:
	//  - Req
	Write(req *WriteRequest) (err error)
	// Parameters:
	//  - Req
	WriteTagged(req *WriteTaggedRequest) (err error)
	// Parameters:
	//  - Req
	Query(req *QueryRequest) (r *QueryResult_, err error)
	// Parameters:
	//  - Req
	Aggregate(req *AggregateQueryRequest) (r *AggregateQueryResult_, err error)
	// Parameters:
	//  - Req
	Fetch(req *FetchRequest) (r *FetchResult_, err error)
	// Parameters:
	//  - Req
	Truncate(req *TruncateRequest) (r *TruncateResult_, err error)
}

type ClusterClient struct {
	Transport       thrift.TTransport
	ProtocolFactory thrift.TProtocolFactory
	InputProtocol   thrift.TProtocol
	OutputProtocol  thrift.TProtocol
	SeqId           int32
}

func NewClusterClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *ClusterClient {
	return &ClusterClient{Transport: t,
		ProtocolFactory: f,
		InputProtocol:   f.GetProtocol(t),
		OutputProtocol:  f.GetProtocol(t),
		SeqId:           0,
	}
}

func NewClusterClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *ClusterClient {
	return &ClusterClient{Transport: t,
		ProtocolFactory: nil,
		InputProtocol:   iprot,
		OutputProtocol:  oprot,
		SeqId:           0,
	}
}

func (p *ClusterClient) Health() (r *HealthResult_, err error) {
	if err = p.sendHealth(); err != nil {
		return
	}
	return p.recvHealth()
}

func (p *ClusterClient) sendHealth() (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("health", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := ClusterHealthArgs{}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ClusterClient) recvHealth() (value *HealthResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "health" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "health failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "health failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error211 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error212 error
		error212, err = error211.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error212
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "health failed: invalid message type")
		return
	}
	result := ClusterHealthResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *ClusterClient) Write(req *WriteRequest) (err error) {
	if err = p.sendWrite(req); err != nil {
		return
	}
	return p.recvWrite()
}

func (p *ClusterClient) sendWrite(req *WriteRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("write", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := ClusterWriteArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ClusterClient) recvWrite() (err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "write" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "write failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "write failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error213 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error214 error
		error214, err = error213.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error214
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "write failed: invalid message type")
		return
	}
	result := ClusterWriteResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	return
}

// Parameters:
//  - Req
func (p *ClusterClient) WriteTagged(req *WriteTaggedRequest) (err error) {
	if err = p.sendWriteTagged(req); err != nil {
		return
	}
	return p.recvWriteTagged()
}

func (p *ClusterClient) sendWriteTagged(req *WriteTaggedRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("writeTagged", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := ClusterWriteTaggedArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ClusterClient) recvWriteTagged() (err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "writeTagged" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "writeTagged failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "writeTagged failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error215 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error216 error
		error216, err = error215.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error216
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "writeTagged failed: invalid message type")
		return
	}
	result := ClusterWriteTaggedResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	return
}

// Parameters:
//  - Req
func (p *ClusterClient) Query(req *QueryRequest) (r *QueryResult_, err error) {
	if err = p.sendQuery(req); err != nil {
		return
	}
	return p.recvQuery()
}

func (p *ClusterClient) sendQuery(req *QueryRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("query", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := ClusterQueryArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ClusterClient) recvQuery() (value *QueryResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "query" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "query failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "query failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error217 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error218 error
		error218, err = error217.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error218
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "query failed: invalid message type")
		return
	}
	result := ClusterQueryResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *ClusterClient) Aggregate(req *AggregateQueryRequest) (r *AggregateQueryResult_, err error) {
	if err = p.sendAggregate(req); err != nil {
		return
	}
	return p.recvAggregate()
}

func (p *ClusterClient) sendAggregate(req *AggregateQueryRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("aggregate", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := ClusterAggregateArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ClusterClient) recvAggregate() (value *AggregateQueryResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "aggregate" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "aggregate failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "aggregate failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error219 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error220 error
		error220, err = error219.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error220
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "aggregate failed: invalid message type")
		return
	}
	result := ClusterAggregateResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *ClusterClient) Fetch(req *FetchRequest) (r *FetchResult_, err error) {
	if err = p.sendFetch(req); err != nil {
		return
	}
	return p.recvFetch()
}

func (p *ClusterClient) sendFetch(req *FetchRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("fetch", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := ClusterFetchArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ClusterClient) recvFetch() (value *FetchResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "fetch" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "fetch failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "fetch failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error221 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error222 error
		error222, err = error221.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error222
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "fetch failed: invalid message type")
		return
	}
	result := ClusterFetchResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

// Parameters:
//  - Req
func (p *ClusterClient) Truncate(req *TruncateRequest) (r *TruncateResult_, err error) {
	if err = p.sendTruncate(req); err != nil {
		return
	}
	return p.recvTruncate()
}

func (p *ClusterClient) sendTruncate(req *TruncateRequest) (err error) {
	oprot := p.OutputProtocol
	if oprot == nil {
		oprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.OutputProtocol = oprot
	}
	p.SeqId++
	if err = oprot.WriteMessageBegin("truncate", thrift.CALL, p.SeqId); err != nil {
		return
	}
	args := ClusterTruncateArgs{
		Req: req,
	}
	if err = args.Write(oprot); err != nil {
		return
	}
	if err = oprot.WriteMessageEnd(); err != nil {
		return
	}
	return oprot.Flush()
}

func (p *ClusterClient) recvTruncate() (value *TruncateResult_, err error) {
	iprot := p.InputProtocol
	if iprot == nil {
		iprot = p.ProtocolFactory.GetProtocol(p.Transport)
		p.InputProtocol = iprot
	}
	method, mTypeId, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return
	}
	if method != "truncate" {
		err = thrift.NewTApplicationException(thrift.WRONG_METHOD_NAME, "truncate failed: wrong method name")
		return
	}
	if p.SeqId != seqId {
		err = thrift.NewTApplicationException(thrift.BAD_SEQUENCE_ID, "truncate failed: out of sequence response")
		return
	}
	if mTypeId == thrift.EXCEPTION {
		error223 := thrift.NewTApplicationException(thrift.UNKNOWN_APPLICATION_EXCEPTION, "Unknown Exception")
		var error224 error
		error224, err = error223.Read(iprot)
		if err != nil {
			return
		}
		if err = iprot.ReadMessageEnd(); err != nil {
			return
		}
		err = error224
		return
	}
	if mTypeId != thrift.REPLY {
		err = thrift.NewTApplicationException(thrift.INVALID_MESSAGE_TYPE_EXCEPTION, "truncate failed: invalid message type")
		return
	}
	result := ClusterTruncateResult{}
	if err = result.Read(iprot); err != nil {
		return
	}
	if err = iprot.ReadMessageEnd(); err != nil {
		return
	}
	if result.Err != nil {
		err = result.Err
		return
	}
	value = result.GetSuccess()
	return
}

type ClusterProcessor struct {
	processorMap map[string]thrift.TProcessorFunction
	handler      Cluster
}

func (p *ClusterProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
	p.processorMap[key] = processor
}

func (p *ClusterProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
	processor, ok = p.processorMap[key]
	return processor, ok
}

func (p *ClusterProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
	return p.processorMap
}

func NewClusterProcessor(handler Cluster) *ClusterProcessor {

	self225 := &ClusterProcessor{handler: handler, processorMap: make(map[string]thrift.TProcessorFunction)}
	self225.processorMap["health"] = &clusterProcessorHealth{handler: handler}
	self225.processorMap["write"] = &clusterProcessorWrite{handler: handler}
	self225.processorMap["writeTagged"] = &clusterProcessorWriteTagged{handler: handler}
	self225.processorMap["query"] = &clusterProcessorQuery{handler: handler}
	self225.processorMap["aggregate"] = &clusterProcessorAggregate{handler: handler}
	self225.processorMap["fetch"] = &clusterProcessorFetch{handler: handler}
	self225.processorMap["truncate"] = &clusterProcessorTruncate{handler: handler}
	return self225
}

func (p *ClusterProcessor) Process(iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	name, _, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return false, err
	}
	if processor, ok := p.GetProcessorFunction(name); ok {
		return processor.Process(seqId, iprot, oprot)
	}
	iprot.Skip(thrift.STRUCT)
	iprot.ReadMessageEnd()
	x226 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function "+name)
	oprot.WriteMessageBegin(name, thrift.EXCEPTION, seqId)
	x226.Write(oprot)
	oprot.WriteMessageEnd()
	oprot.Flush()
	return false, x226

}

type clusterProcessorHealth struct {
	handler Cluster
}

func (p *clusterProcessorHealth) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ClusterHealthArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("health", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := ClusterHealthResult{}
	var retval *HealthResult_
	var err2 error
	if retval, err2 = p.handler.Health(); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing health: "+err2.Error())
			oprot.WriteMessageBegin("health", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("health", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type clusterProcessorWrite struct {
	handler Cluster
}

func (p *clusterProcessorWrite) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ClusterWriteArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("write", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := ClusterWriteResult{}
	var err2 error
	if err2 = p.handler.Write(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing write: "+err2.Error())
			oprot.WriteMessageBegin("write", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	}
	if err2 = oprot.WriteMessageBegin("write", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type clusterProcessorWriteTagged struct {
	handler Cluster
}

func (p *clusterProcessorWriteTagged) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ClusterWriteTaggedArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("writeTagged", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := ClusterWriteTaggedResult{}
	var err2 error
	if err2 = p.handler.WriteTagged(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing writeTagged: "+err2.Error())
			oprot.WriteMessageBegin("writeTagged", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	}
	if err2 = oprot.WriteMessageBegin("writeTagged", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type clusterProcessorQuery struct {
	handler Cluster
}

func (p *clusterProcessorQuery) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ClusterQueryArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("query", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := ClusterQueryResult{}
	var retval *QueryResult_
	var err2 error
	if retval, err2 = p.handler.Query(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing query: "+err2.Error())
			oprot.WriteMessageBegin("query", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("query", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type clusterProcessorAggregate struct {
	handler Cluster
}

func (p *clusterProcessorAggregate) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ClusterAggregateArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("aggregate", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := ClusterAggregateResult{}
	var retval *AggregateQueryResult_
	var err2 error
	if retval, err2 = p.handler.Aggregate(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing aggregate: "+err2.Error())
			oprot.WriteMessageBegin("aggregate", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("aggregate", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type clusterProcessorFetch struct {
	handler Cluster
}

func (p *clusterProcessorFetch) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ClusterFetchArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("fetch", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := ClusterFetchResult{}
	var retval *FetchResult_
	var err2 error
	if retval, err2 = p.handler.Fetch(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetch: "+err2.Error())
			oprot.WriteMessageBegin("fetch", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("fetch", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type clusterProcessorTruncate struct {
	handler Cluster
}

func (p *clusterProcessorTruncate) Process(seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ClusterTruncateArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("truncate", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush()
		return false, err
	}

	iprot.ReadMessageEnd()
	result := ClusterTruncateResult{}
	var retval *TruncateResult_
	var err2 error
	if retval, err2 = p.handler.Truncate(args.Req); err2 != nil {
		switch v := err2.(type) {
		case *Error:
			result.Err = v
		default:
			x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing truncate: "+err2.Error())
			oprot.WriteMessageBegin("truncate", thrift.EXCEPTION, seqId)
			x.Write(oprot)
			oprot.WriteMessageEnd()
			oprot.Flush()
			return true, err2
		}
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("truncate", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

// HELPER FUNCTIONS AND STRUCTURES

type ClusterHealthArgs struct {
}

func NewClusterHealthArgs() *ClusterHealthArgs {
	return &ClusterHealthArgs{}
}

func (p *ClusterHealthArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterHealthArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("health_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterHealthArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterHealthArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type ClusterHealthResult struct {
	Success *HealthResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error         `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewClusterHealthResult() *ClusterHealthResult {
	return &ClusterHealthResult{}
}

var ClusterHealthResult_Success_DEFAULT *HealthResult_

func (p *ClusterHealthResult) GetSuccess() *HealthResult_ {
	if !p.IsSetSuccess() {
		return ClusterHealthResult_Success_DEFAULT
	}
	return p.Success
}

var ClusterHealthResult_Err_DEFAULT *Error

func (p *ClusterHealthResult) GetErr() *Error {
	if !p.IsSetErr() {
		return ClusterHealthResult_Err_DEFAULT
	}
	return p.Err
}
func (p *ClusterHealthResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ClusterHealthResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *ClusterHealthResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterHealthResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &HealthResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ClusterHealthResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *ClusterHealthResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("health_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterHealthResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ClusterHealthResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *ClusterHealthResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterHealthResult(%+v)", *p)
}

// Attributes:
//  - Req
type ClusterWriteArgs struct {
	Req *WriteRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewClusterWriteArgs() *ClusterWriteArgs {
	return &ClusterWriteArgs{}
}

var ClusterWriteArgs_Req_DEFAULT *WriteRequest

func (p *ClusterWriteArgs) GetReq() *WriteRequest {
	if !p.IsSetReq() {
		return ClusterWriteArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *ClusterWriteArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *ClusterWriteArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterWriteArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &WriteRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *ClusterWriteArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("write_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterWriteArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *ClusterWriteArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterWriteArgs(%+v)", *p)
}

// Attributes:
//  - Err
type ClusterWriteResult struct {
	Err *Error `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewClusterWriteResult() *ClusterWriteResult {
	return &ClusterWriteResult{}
}

var ClusterWriteResult_Err_DEFAULT *Error

func (p *ClusterWriteResult) GetErr() *Error {
	if !p.IsSetErr() {
		return ClusterWriteResult_Err_DEFAULT
	}
	return p.Err
}
func (p *ClusterWriteResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *ClusterWriteResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterWriteResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *ClusterWriteResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("write_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterWriteResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *ClusterWriteResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterWriteResult(%+v)", *p)
}

// Attributes:
//  - Req
type ClusterWriteTaggedArgs struct {
	Req *WriteTaggedRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewClusterWriteTaggedArgs() *ClusterWriteTaggedArgs {
	return &ClusterWriteTaggedArgs{}
}

var ClusterWriteTaggedArgs_Req_DEFAULT *WriteTaggedRequest

func (p *ClusterWriteTaggedArgs) GetReq() *WriteTaggedRequest {
	if !p.IsSetReq() {
		return ClusterWriteTaggedArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *ClusterWriteTaggedArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *ClusterWriteTaggedArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterWriteTaggedArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &WriteTaggedRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *ClusterWriteTaggedArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("writeTagged_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterWriteTaggedArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *ClusterWriteTaggedArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterWriteTaggedArgs(%+v)", *p)
}

// Attributes:
//  - Err
type ClusterWriteTaggedResult struct {
	Err *Error `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewClusterWriteTaggedResult() *ClusterWriteTaggedResult {
	return &ClusterWriteTaggedResult{}
}

var ClusterWriteTaggedResult_Err_DEFAULT *Error

func (p *ClusterWriteTaggedResult) GetErr() *Error {
	if !p.IsSetErr() {
		return ClusterWriteTaggedResult_Err_DEFAULT
	}
	return p.Err
}
func (p *ClusterWriteTaggedResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *ClusterWriteTaggedResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterWriteTaggedResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *ClusterWriteTaggedResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("writeTagged_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterWriteTaggedResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *ClusterWriteTaggedResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterWriteTaggedResult(%+v)", *p)
}

// Attributes:
//  - Req
type ClusterQueryArgs struct {
	Req *QueryRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewClusterQueryArgs() *ClusterQueryArgs {
	return &ClusterQueryArgs{}
}

var ClusterQueryArgs_Req_DEFAULT *QueryRequest

func (p *ClusterQueryArgs) GetReq() *QueryRequest {
	if !p.IsSetReq() {
		return ClusterQueryArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *ClusterQueryArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *ClusterQueryArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterQueryArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &QueryRequest{
		RangeType: 0,

		ResultTimeType: 0,
	}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *ClusterQueryArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("query_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterQueryArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *ClusterQueryArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterQueryArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type ClusterQueryResult struct {
	Success *QueryResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error        `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewClusterQueryResult() *ClusterQueryResult {
	return &ClusterQueryResult{}
}

var ClusterQueryResult_Success_DEFAULT *QueryResult_

func (p *ClusterQueryResult) GetSuccess() *QueryResult_ {
	if !p.IsSetSuccess() {
		return ClusterQueryResult_Success_DEFAULT
	}
	return p.Success
}

var ClusterQueryResult_Err_DEFAULT *Error

func (p *ClusterQueryResult) GetErr() *Error {
	if !p.IsSetErr() {
		return ClusterQueryResult_Err_DEFAULT
	}
	return p.Err
}
func (p *ClusterQueryResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ClusterQueryResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *ClusterQueryResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterQueryResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &QueryResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ClusterQueryResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *ClusterQueryResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("query_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterQueryResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ClusterQueryResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *ClusterQueryResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterQueryResult(%+v)", *p)
}

// Attributes:
//  - Req
type ClusterAggregateArgs struct {
	Req *AggregateQueryRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewClusterAggregateArgs() *ClusterAggregateArgs {
	return &ClusterAggregateArgs{}
}

var ClusterAggregateArgs_Req_DEFAULT *AggregateQueryRequest

func (p *ClusterAggregateArgs) GetReq() *AggregateQueryRequest {
	if !p.IsSetReq() {
		return ClusterAggregateArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *ClusterAggregateArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *ClusterAggregateArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterAggregateArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &AggregateQueryRequest{
		AggregateQueryType: 1,

		RangeType: 0,
	}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *ClusterAggregateArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("aggregate_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterAggregateArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *ClusterAggregateArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterAggregateArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type ClusterAggregateResult struct {
	Success *AggregateQueryResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error                 `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewClusterAggregateResult() *ClusterAggregateResult {
	return &ClusterAggregateResult{}
}

var ClusterAggregateResult_Success_DEFAULT *AggregateQueryResult_

func (p *ClusterAggregateResult) GetSuccess() *AggregateQueryResult_ {
	if !p.IsSetSuccess() {
		return ClusterAggregateResult_Success_DEFAULT
	}
	return p.Success
}

var ClusterAggregateResult_Err_DEFAULT *Error

func (p *ClusterAggregateResult) GetErr() *Error {
	if !p.IsSetErr() {
		return ClusterAggregateResult_Err_DEFAULT
	}
	return p.Err
}
func (p *ClusterAggregateResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ClusterAggregateResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *ClusterAggregateResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterAggregateResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &AggregateQueryResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ClusterAggregateResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *ClusterAggregateResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("aggregate_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterAggregateResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ClusterAggregateResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *ClusterAggregateResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterAggregateResult(%+v)", *p)
}

// Attributes:
//  - Req
type ClusterFetchArgs struct {
	Req *FetchRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewClusterFetchArgs() *ClusterFetchArgs {
	return &ClusterFetchArgs{}
}

var ClusterFetchArgs_Req_DEFAULT *FetchRequest

func (p *ClusterFetchArgs) GetReq() *FetchRequest {
	if !p.IsSetReq() {
		return ClusterFetchArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *ClusterFetchArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *ClusterFetchArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterFetchArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &FetchRequest{
		RangeType: 0,

		ResultTimeType: 0,
	}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *ClusterFetchArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetch_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterFetchArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *ClusterFetchArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterFetchArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type ClusterFetchResult struct {
	Success *FetchResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error        `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewClusterFetchResult() *ClusterFetchResult {
	return &ClusterFetchResult{}
}

var ClusterFetchResult_Success_DEFAULT *FetchResult_

func (p *ClusterFetchResult) GetSuccess() *FetchResult_ {
	if !p.IsSetSuccess() {
		return ClusterFetchResult_Success_DEFAULT
	}
	return p.Success
}

var ClusterFetchResult_Err_DEFAULT *Error

func (p *ClusterFetchResult) GetErr() *Error {
	if !p.IsSetErr() {
		return ClusterFetchResult_Err_DEFAULT
	}
	return p.Err
}
func (p *ClusterFetchResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ClusterFetchResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *ClusterFetchResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterFetchResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &FetchResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ClusterFetchResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *ClusterFetchResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("fetch_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterFetchResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ClusterFetchResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *ClusterFetchResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterFetchResult(%+v)", *p)
}

// Attributes:
//  - Req
type ClusterTruncateArgs struct {
	Req *TruncateRequest `thrift:"req,1" db:"req" json:"req"`
}

func NewClusterTruncateArgs() *ClusterTruncateArgs {
	return &ClusterTruncateArgs{}
}

var ClusterTruncateArgs_Req_DEFAULT *TruncateRequest

func (p *ClusterTruncateArgs) GetReq() *TruncateRequest {
	if !p.IsSetReq() {
		return ClusterTruncateArgs_Req_DEFAULT
	}
	return p.Req
}
func (p *ClusterTruncateArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *ClusterTruncateArgs) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterTruncateArgs) ReadField1(iprot thrift.TProtocol) error {
	p.Req = &TruncateRequest{}
	if err := p.Req.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
	}
	return nil
}

func (p *ClusterTruncateArgs) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("truncate_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterTruncateArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err)
	}
	if err := p.Req.Write(oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
	}
	if err := oprot.WriteFieldEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err)
	}
	return err
}

func (p *ClusterTruncateArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterTruncateArgs(%+v)", *p)
}

// Attributes:
//  - Success
//  - Err
type ClusterTruncateResult struct {
	Success *TruncateResult_ `thrift:"success,0" db:"success" json:"success,omitempty"`
	Err     *Error           `thrift:"err,1" db:"err" json:"err,omitempty"`
}

func NewClusterTruncateResult() *ClusterTruncateResult {
	return &ClusterTruncateResult{}
}

var ClusterTruncateResult_Success_DEFAULT *TruncateResult_

func (p *ClusterTruncateResult) GetSuccess() *TruncateResult_ {
	if !p.IsSetSuccess() {
		return ClusterTruncateResult_Success_DEFAULT
	}
	return p.Success
}

var ClusterTruncateResult_Err_DEFAULT *Error

func (p *ClusterTruncateResult) GetErr() *Error {
	if !p.IsSetErr() {
		return ClusterTruncateResult_Err_DEFAULT
	}
	return p.Err
}
func (p *ClusterTruncateResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ClusterTruncateResult) IsSetErr() bool {
	return p.Err != nil
}

func (p *ClusterTruncateResult) Read(iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin()
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if err := p.ReadField0(iprot); err != nil {
				return err
			}
		case 1:
			if err := p.ReadField1(iprot); err != nil {
				return err
			}
		default:
			if err := iprot.Skip(fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ClusterTruncateResult) ReadField0(iprot thrift.TProtocol) error {
	p.Success = &TruncateResult_{}
	if err := p.Success.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ClusterTruncateResult) ReadField1(iprot thrift.TProtocol) error {
	p.Err = &Error{
		Type: 0,
	}
	if err := p.Err.Read(iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Err), err)
	}
	return nil
}

func (p *ClusterTruncateResult) Write(oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin("truncate_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(oprot); err != nil {
			return err
		}
		if err := p.writeField1(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ClusterTruncateResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ClusterTruncateResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetErr() {
		if err := oprot.WriteFieldBegin("err", thrift.STRUCT, 1); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:err: ", p), err)
		}
		if err := p.Err.Write(oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Err), err)
		}
		if err := oprot.WriteFieldEnd(); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 1:err: ", p), err)
		}
	}
	return err
}

func (p *ClusterTruncateResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ClusterTruncateResult(%+v)", *p)
}
