// Code generated by MockGen. DO NOT EDIT.
// Source: github.com/m3db/m3/src/dbnode/storage/types.go

// Copyright (c) 2019 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Package storage is a generated GoMock package.
package storage

import (
	"reflect"
	"sync"
	"time"

	"github.com/m3db/m3/src/dbnode/clock"
	"github.com/m3db/m3/src/dbnode/encoding"
	"github.com/m3db/m3/src/dbnode/namespace"
	"github.com/m3db/m3/src/dbnode/persist"
	"github.com/m3db/m3/src/dbnode/persist/fs/commitlog"
	"github.com/m3db/m3/src/dbnode/runtime"
	"github.com/m3db/m3/src/dbnode/sharding"
	"github.com/m3db/m3/src/dbnode/storage/block"
	"github.com/m3db/m3/src/dbnode/storage/bootstrap"
	"github.com/m3db/m3/src/dbnode/storage/bootstrap/result"
	"github.com/m3db/m3/src/dbnode/storage/index"
	"github.com/m3db/m3/src/dbnode/storage/repair"
	"github.com/m3db/m3/src/dbnode/storage/series"
	"github.com/m3db/m3/src/dbnode/ts"
	"github.com/m3db/m3/src/dbnode/x/xio"
	"github.com/m3db/m3/src/x/context"
	"github.com/m3db/m3/src/x/ident"
	"github.com/m3db/m3/src/x/instrument"
	"github.com/m3db/m3/src/x/pool"
	sync0 "github.com/m3db/m3/src/x/sync"
	time0 "github.com/m3db/m3/src/x/time"

	"github.com/golang/mock/gomock"
)

// MockIndexedErrorHandler is a mock of IndexedErrorHandler interface
type MockIndexedErrorHandler struct {
	ctrl     *gomock.Controller
	recorder *MockIndexedErrorHandlerMockRecorder
}

// MockIndexedErrorHandlerMockRecorder is the mock recorder for MockIndexedErrorHandler
type MockIndexedErrorHandlerMockRecorder struct {
	mock *MockIndexedErrorHandler
}

// NewMockIndexedErrorHandler creates a new mock instance
func NewMockIndexedErrorHandler(ctrl *gomock.Controller) *MockIndexedErrorHandler {
	mock := &MockIndexedErrorHandler{ctrl: ctrl}
	mock.recorder = &MockIndexedErrorHandlerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockIndexedErrorHandler) EXPECT() *MockIndexedErrorHandlerMockRecorder {
	return m.recorder
}

// HandleError mocks base method
func (m *MockIndexedErrorHandler) HandleError(index int, err error) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "HandleError", index, err)
}

// HandleError indicates an expected call of HandleError
func (mr *MockIndexedErrorHandlerMockRecorder) HandleError(index, err interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HandleError", reflect.TypeOf((*MockIndexedErrorHandler)(nil).HandleError), index, err)
}

// MockDatabase is a mock of Database interface
type MockDatabase struct {
	ctrl     *gomock.Controller
	recorder *MockDatabaseMockRecorder
}

// MockDatabaseMockRecorder is the mock recorder for MockDatabase
type MockDatabaseMockRecorder struct {
	mock *MockDatabase
}

// NewMockDatabase creates a new mock instance
func NewMockDatabase(ctrl *gomock.Controller) *MockDatabase {
	mock := &MockDatabase{ctrl: ctrl}
	mock.recorder = &MockDatabaseMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockDatabase) EXPECT() *MockDatabaseMockRecorder {
	return m.recorder
}

// Options mocks base method
func (m *MockDatabase) Options() Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Options")
	ret0, _ := ret[0].(Options)
	return ret0
}

// Options indicates an expected call of Options
func (mr *MockDatabaseMockRecorder) Options() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Options", reflect.TypeOf((*MockDatabase)(nil).Options))
}

// AssignShardSet mocks base method
func (m *MockDatabase) AssignShardSet(shardSet sharding.ShardSet) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "AssignShardSet", shardSet)
}

// AssignShardSet indicates an expected call of AssignShardSet
func (mr *MockDatabaseMockRecorder) AssignShardSet(shardSet interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssignShardSet", reflect.TypeOf((*MockDatabase)(nil).AssignShardSet), shardSet)
}

// Namespaces mocks base method
func (m *MockDatabase) Namespaces() []Namespace {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Namespaces")
	ret0, _ := ret[0].([]Namespace)
	return ret0
}

// Namespaces indicates an expected call of Namespaces
func (mr *MockDatabaseMockRecorder) Namespaces() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Namespaces", reflect.TypeOf((*MockDatabase)(nil).Namespaces))
}

// Namespace mocks base method
func (m *MockDatabase) Namespace(ns ident.ID) (Namespace, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Namespace", ns)
	ret0, _ := ret[0].(Namespace)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// Namespace indicates an expected call of Namespace
func (mr *MockDatabaseMockRecorder) Namespace(ns interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Namespace", reflect.TypeOf((*MockDatabase)(nil).Namespace), ns)
}

// Open mocks base method
func (m *MockDatabase) Open() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Open")
	ret0, _ := ret[0].(error)
	return ret0
}

// Open indicates an expected call of Open
func (mr *MockDatabaseMockRecorder) Open() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Open", reflect.TypeOf((*MockDatabase)(nil).Open))
}

// Close mocks base method
func (m *MockDatabase) Close() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Close")
	ret0, _ := ret[0].(error)
	return ret0
}

// Close indicates an expected call of Close
func (mr *MockDatabaseMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockDatabase)(nil).Close))
}

// ShardSet mocks base method
func (m *MockDatabase) ShardSet() sharding.ShardSet {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ShardSet")
	ret0, _ := ret[0].(sharding.ShardSet)
	return ret0
}

// ShardSet indicates an expected call of ShardSet
func (mr *MockDatabaseMockRecorder) ShardSet() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ShardSet", reflect.TypeOf((*MockDatabase)(nil).ShardSet))
}

// Terminate mocks base method
func (m *MockDatabase) Terminate() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Terminate")
	ret0, _ := ret[0].(error)
	return ret0
}

// Terminate indicates an expected call of Terminate
func (mr *MockDatabaseMockRecorder) Terminate() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Terminate", reflect.TypeOf((*MockDatabase)(nil).Terminate))
}

// Write mocks base method
func (m *MockDatabase) Write(ctx context.Context, namespace, id ident.ID, timestamp time.Time, value float64, unit time0.Unit, annotation []byte) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Write", ctx, namespace, id, timestamp, value, unit, annotation)
	ret0, _ := ret[0].(error)
	return ret0
}

// Write indicates an expected call of Write
func (mr *MockDatabaseMockRecorder) Write(ctx, namespace, id, timestamp, value, unit, annotation interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Write", reflect.TypeOf((*MockDatabase)(nil).Write), ctx, namespace, id, timestamp, value, unit, annotation)
}

// WriteTagged mocks base method
func (m *MockDatabase) WriteTagged(ctx context.Context, namespace, id ident.ID, tags ident.TagIterator, timestamp time.Time, value float64, unit time0.Unit, annotation []byte) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTagged", ctx, namespace, id, tags, timestamp, value, unit, annotation)
	ret0, _ := ret[0].(error)
	return ret0
}

// WriteTagged indicates an expected call of WriteTagged
func (mr *MockDatabaseMockRecorder) WriteTagged(ctx, namespace, id, tags, timestamp, value, unit, annotation interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTagged", reflect.TypeOf((*MockDatabase)(nil).WriteTagged), ctx, namespace, id, tags, timestamp, value, unit, annotation)
}

// BatchWriter mocks base method
func (m *MockDatabase) BatchWriter(namespace ident.ID, batchSize int) (ts.BatchWriter, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BatchWriter", namespace, batchSize)
	ret0, _ := ret[0].(ts.BatchWriter)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BatchWriter indicates an expected call of BatchWriter
func (mr *MockDatabaseMockRecorder) BatchWriter(namespace, batchSize interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BatchWriter", reflect.TypeOf((*MockDatabase)(nil).BatchWriter), namespace, batchSize)
}

// WriteBatch mocks base method
func (m *MockDatabase) WriteBatch(ctx context.Context, namespace ident.ID, writes ts.BatchWriter, errHandler IndexedErrorHandler) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteBatch", ctx, namespace, writes, errHandler)
	ret0, _ := ret[0].(error)
	return ret0
}

// WriteBatch indicates an expected call of WriteBatch
func (mr *MockDatabaseMockRecorder) WriteBatch(ctx, namespace, writes, errHandler interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteBatch", reflect.TypeOf((*MockDatabase)(nil).WriteBatch), ctx, namespace, writes, errHandler)
}

// WriteTaggedBatch mocks base method
func (m *MockDatabase) WriteTaggedBatch(ctx context.Context, namespace ident.ID, writes ts.BatchWriter, errHandler IndexedErrorHandler) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTaggedBatch", ctx, namespace, writes, errHandler)
	ret0, _ := ret[0].(error)
	return ret0
}

// WriteTaggedBatch indicates an expected call of WriteTaggedBatch
func (mr *MockDatabaseMockRecorder) WriteTaggedBatch(ctx, namespace, writes, errHandler interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTaggedBatch", reflect.TypeOf((*MockDatabase)(nil).WriteTaggedBatch), ctx, namespace, writes, errHandler)
}

// QueryIDs mocks base method
func (m *MockDatabase) QueryIDs(ctx context.Context, namespace ident.ID, query index.Query, opts index.QueryOptions) (index.QueryResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "QueryIDs", ctx, namespace, query, opts)
	ret0, _ := ret[0].(index.QueryResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// QueryIDs indicates an expected call of QueryIDs
func (mr *MockDatabaseMockRecorder) QueryIDs(ctx, namespace, query, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "QueryIDs", reflect.TypeOf((*MockDatabase)(nil).QueryIDs), ctx, namespace, query, opts)
}

// AggregateQuery mocks base method
func (m *MockDatabase) AggregateQuery(ctx context.Context, namespace ident.ID, query index.Query, opts index.AggregationOptions) (index.AggregateQueryResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AggregateQuery", ctx, namespace, query, opts)
	ret0, _ := ret[0].(index.AggregateQueryResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AggregateQuery indicates an expected call of AggregateQuery
func (mr *MockDatabaseMockRecorder) AggregateQuery(ctx, namespace, query, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AggregateQuery", reflect.TypeOf((*MockDatabase)(nil).AggregateQuery), ctx, namespace, query, opts)
}

// ReadEncoded mocks base method
func (m *MockDatabase) ReadEncoded(ctx context.Context, namespace, id ident.ID, start, end time.Time) ([][]xio.BlockReader, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReadEncoded", ctx, namespace, id, start, end)
	ret0, _ := ret[0].([][]xio.BlockReader)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReadEncoded indicates an expected call of ReadEncoded
func (mr *MockDatabaseMockRecorder) ReadEncoded(ctx, namespace, id, start, end interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReadEncoded", reflect.TypeOf((*MockDatabase)(nil).ReadEncoded), ctx, namespace, id, start, end)
}

// FetchBlocks mocks base method
func (m *MockDatabase) FetchBlocks(ctx context.Context, namespace ident.ID, shard uint32, id ident.ID, starts []time.Time) ([]block.FetchBlockResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocks", ctx, namespace, shard, id, starts)
	ret0, _ := ret[0].([]block.FetchBlockResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBlocks indicates an expected call of FetchBlocks
func (mr *MockDatabaseMockRecorder) FetchBlocks(ctx, namespace, shard, id, starts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocks", reflect.TypeOf((*MockDatabase)(nil).FetchBlocks), ctx, namespace, shard, id, starts)
}

// FetchBlocksMetadataV2 mocks base method
func (m *MockDatabase) FetchBlocksMetadataV2(ctx context.Context, namespace ident.ID, shard uint32, start, end time.Time, limit int64, pageToken PageToken, opts block.FetchBlocksMetadataOptions) (block.FetchBlocksMetadataResults, PageToken, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocksMetadataV2", ctx, namespace, shard, start, end, limit, pageToken, opts)
	ret0, _ := ret[0].(block.FetchBlocksMetadataResults)
	ret1, _ := ret[1].(PageToken)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// FetchBlocksMetadataV2 indicates an expected call of FetchBlocksMetadataV2
func (mr *MockDatabaseMockRecorder) FetchBlocksMetadataV2(ctx, namespace, shard, start, end, limit, pageToken, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocksMetadataV2", reflect.TypeOf((*MockDatabase)(nil).FetchBlocksMetadataV2), ctx, namespace, shard, start, end, limit, pageToken, opts)
}

// Bootstrap mocks base method
func (m *MockDatabase) Bootstrap() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Bootstrap")
	ret0, _ := ret[0].(error)
	return ret0
}

// Bootstrap indicates an expected call of Bootstrap
func (mr *MockDatabaseMockRecorder) Bootstrap() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Bootstrap", reflect.TypeOf((*MockDatabase)(nil).Bootstrap))
}

// IsBootstrapped mocks base method
func (m *MockDatabase) IsBootstrapped() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsBootstrapped")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsBootstrapped indicates an expected call of IsBootstrapped
func (mr *MockDatabaseMockRecorder) IsBootstrapped() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsBootstrapped", reflect.TypeOf((*MockDatabase)(nil).IsBootstrapped))
}

// IsBootstrappedAndDurable mocks base method
func (m *MockDatabase) IsBootstrappedAndDurable() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsBootstrappedAndDurable")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsBootstrappedAndDurable indicates an expected call of IsBootstrappedAndDurable
func (mr *MockDatabaseMockRecorder) IsBootstrappedAndDurable() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsBootstrappedAndDurable", reflect.TypeOf((*MockDatabase)(nil).IsBootstrappedAndDurable))
}

// IsOverloaded mocks base method
func (m *MockDatabase) IsOverloaded() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsOverloaded")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsOverloaded indicates an expected call of IsOverloaded
func (mr *MockDatabaseMockRecorder) IsOverloaded() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsOverloaded", reflect.TypeOf((*MockDatabase)(nil).IsOverloaded))
}

// Repair mocks base method
func (m *MockDatabase) Repair() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Repair")
	ret0, _ := ret[0].(error)
	return ret0
}

// Repair indicates an expected call of Repair
func (mr *MockDatabaseMockRecorder) Repair() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Repair", reflect.TypeOf((*MockDatabase)(nil).Repair))
}

// Truncate mocks base method
func (m *MockDatabase) Truncate(namespace ident.ID) (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Truncate", namespace)
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Truncate indicates an expected call of Truncate
func (mr *MockDatabaseMockRecorder) Truncate(namespace interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Truncate", reflect.TypeOf((*MockDatabase)(nil).Truncate), namespace)
}

// BootstrapState mocks base method
func (m *MockDatabase) BootstrapState() DatabaseBootstrapState {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BootstrapState")
	ret0, _ := ret[0].(DatabaseBootstrapState)
	return ret0
}

// BootstrapState indicates an expected call of BootstrapState
func (mr *MockDatabaseMockRecorder) BootstrapState() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BootstrapState", reflect.TypeOf((*MockDatabase)(nil).BootstrapState))
}

// FlushState mocks base method
func (m *MockDatabase) FlushState(namespace ident.ID, shardID uint32, blockStart time.Time) (fileOpState, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FlushState", namespace, shardID, blockStart)
	ret0, _ := ret[0].(fileOpState)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FlushState indicates an expected call of FlushState
func (mr *MockDatabaseMockRecorder) FlushState(namespace, shardID, blockStart interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FlushState", reflect.TypeOf((*MockDatabase)(nil).FlushState), namespace, shardID, blockStart)
}

// Mockdatabase is a mock of database interface
type Mockdatabase struct {
	ctrl     *gomock.Controller
	recorder *MockdatabaseMockRecorder
}

// MockdatabaseMockRecorder is the mock recorder for Mockdatabase
type MockdatabaseMockRecorder struct {
	mock *Mockdatabase
}

// NewMockdatabase creates a new mock instance
func NewMockdatabase(ctrl *gomock.Controller) *Mockdatabase {
	mock := &Mockdatabase{ctrl: ctrl}
	mock.recorder = &MockdatabaseMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *Mockdatabase) EXPECT() *MockdatabaseMockRecorder {
	return m.recorder
}

// Options mocks base method
func (m *Mockdatabase) Options() Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Options")
	ret0, _ := ret[0].(Options)
	return ret0
}

// Options indicates an expected call of Options
func (mr *MockdatabaseMockRecorder) Options() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Options", reflect.TypeOf((*Mockdatabase)(nil).Options))
}

// AssignShardSet mocks base method
func (m *Mockdatabase) AssignShardSet(shardSet sharding.ShardSet) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "AssignShardSet", shardSet)
}

// AssignShardSet indicates an expected call of AssignShardSet
func (mr *MockdatabaseMockRecorder) AssignShardSet(shardSet interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssignShardSet", reflect.TypeOf((*Mockdatabase)(nil).AssignShardSet), shardSet)
}

// Namespaces mocks base method
func (m *Mockdatabase) Namespaces() []Namespace {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Namespaces")
	ret0, _ := ret[0].([]Namespace)
	return ret0
}

// Namespaces indicates an expected call of Namespaces
func (mr *MockdatabaseMockRecorder) Namespaces() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Namespaces", reflect.TypeOf((*Mockdatabase)(nil).Namespaces))
}

// Namespace mocks base method
func (m *Mockdatabase) Namespace(ns ident.ID) (Namespace, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Namespace", ns)
	ret0, _ := ret[0].(Namespace)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// Namespace indicates an expected call of Namespace
func (mr *MockdatabaseMockRecorder) Namespace(ns interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Namespace", reflect.TypeOf((*Mockdatabase)(nil).Namespace), ns)
}

// Open mocks base method
func (m *Mockdatabase) Open() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Open")
	ret0, _ := ret[0].(error)
	return ret0
}

// Open indicates an expected call of Open
func (mr *MockdatabaseMockRecorder) Open() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Open", reflect.TypeOf((*Mockdatabase)(nil).Open))
}

// Close mocks base method
func (m *Mockdatabase) Close() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Close")
	ret0, _ := ret[0].(error)
	return ret0
}

// Close indicates an expected call of Close
func (mr *MockdatabaseMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*Mockdatabase)(nil).Close))
}

// ShardSet mocks base method
func (m *Mockdatabase) ShardSet() sharding.ShardSet {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ShardSet")
	ret0, _ := ret[0].(sharding.ShardSet)
	return ret0
}

// ShardSet indicates an expected call of ShardSet
func (mr *MockdatabaseMockRecorder) ShardSet() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ShardSet", reflect.TypeOf((*Mockdatabase)(nil).ShardSet))
}

// Terminate mocks base method
func (m *Mockdatabase) Terminate() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Terminate")
	ret0, _ := ret[0].(error)
	return ret0
}

// Terminate indicates an expected call of Terminate
func (mr *MockdatabaseMockRecorder) Terminate() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Terminate", reflect.TypeOf((*Mockdatabase)(nil).Terminate))
}

// Write mocks base method
func (m *Mockdatabase) Write(ctx context.Context, namespace, id ident.ID, timestamp time.Time, value float64, unit time0.Unit, annotation []byte) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Write", ctx, namespace, id, timestamp, value, unit, annotation)
	ret0, _ := ret[0].(error)
	return ret0
}

// Write indicates an expected call of Write
func (mr *MockdatabaseMockRecorder) Write(ctx, namespace, id, timestamp, value, unit, annotation interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Write", reflect.TypeOf((*Mockdatabase)(nil).Write), ctx, namespace, id, timestamp, value, unit, annotation)
}

// WriteTagged mocks base method
func (m *Mockdatabase) WriteTagged(ctx context.Context, namespace, id ident.ID, tags ident.TagIterator, timestamp time.Time, value float64, unit time0.Unit, annotation []byte) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTagged", ctx, namespace, id, tags, timestamp, value, unit, annotation)
	ret0, _ := ret[0].(error)
	return ret0
}

// WriteTagged indicates an expected call of WriteTagged
func (mr *MockdatabaseMockRecorder) WriteTagged(ctx, namespace, id, tags, timestamp, value, unit, annotation interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTagged", reflect.TypeOf((*Mockdatabase)(nil).WriteTagged), ctx, namespace, id, tags, timestamp, value, unit, annotation)
}

// BatchWriter mocks base method
func (m *Mockdatabase) BatchWriter(namespace ident.ID, batchSize int) (ts.BatchWriter, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BatchWriter", namespace, batchSize)
	ret0, _ := ret[0].(ts.BatchWriter)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// BatchWriter indicates an expected call of BatchWriter
func (mr *MockdatabaseMockRecorder) BatchWriter(namespace, batchSize interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BatchWriter", reflect.TypeOf((*Mockdatabase)(nil).BatchWriter), namespace, batchSize)
}

// WriteBatch mocks base method
func (m *Mockdatabase) WriteBatch(ctx context.Context, namespace ident.ID, writes ts.BatchWriter, errHandler IndexedErrorHandler) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteBatch", ctx, namespace, writes, errHandler)
	ret0, _ := ret[0].(error)
	return ret0
}

// WriteBatch indicates an expected call of WriteBatch
func (mr *MockdatabaseMockRecorder) WriteBatch(ctx, namespace, writes, errHandler interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteBatch", reflect.TypeOf((*Mockdatabase)(nil).WriteBatch), ctx, namespace, writes, errHandler)
}

// WriteTaggedBatch mocks base method
func (m *Mockdatabase) WriteTaggedBatch(ctx context.Context, namespace ident.ID, writes ts.BatchWriter, errHandler IndexedErrorHandler) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTaggedBatch", ctx, namespace, writes, errHandler)
	ret0, _ := ret[0].(error)
	return ret0
}

// WriteTaggedBatch indicates an expected call of WriteTaggedBatch
func (mr *MockdatabaseMockRecorder) WriteTaggedBatch(ctx, namespace, writes, errHandler interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTaggedBatch", reflect.TypeOf((*Mockdatabase)(nil).WriteTaggedBatch), ctx, namespace, writes, errHandler)
}

// QueryIDs mocks base method
func (m *Mockdatabase) QueryIDs(ctx context.Context, namespace ident.ID, query index.Query, opts index.QueryOptions) (index.QueryResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "QueryIDs", ctx, namespace, query, opts)
	ret0, _ := ret[0].(index.QueryResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// QueryIDs indicates an expected call of QueryIDs
func (mr *MockdatabaseMockRecorder) QueryIDs(ctx, namespace, query, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "QueryIDs", reflect.TypeOf((*Mockdatabase)(nil).QueryIDs), ctx, namespace, query, opts)
}

// AggregateQuery mocks base method
func (m *Mockdatabase) AggregateQuery(ctx context.Context, namespace ident.ID, query index.Query, opts index.AggregationOptions) (index.AggregateQueryResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AggregateQuery", ctx, namespace, query, opts)
	ret0, _ := ret[0].(index.AggregateQueryResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AggregateQuery indicates an expected call of AggregateQuery
func (mr *MockdatabaseMockRecorder) AggregateQuery(ctx, namespace, query, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AggregateQuery", reflect.TypeOf((*Mockdatabase)(nil).AggregateQuery), ctx, namespace, query, opts)
}

// ReadEncoded mocks base method
func (m *Mockdatabase) ReadEncoded(ctx context.Context, namespace, id ident.ID, start, end time.Time) ([][]xio.BlockReader, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReadEncoded", ctx, namespace, id, start, end)
	ret0, _ := ret[0].([][]xio.BlockReader)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReadEncoded indicates an expected call of ReadEncoded
func (mr *MockdatabaseMockRecorder) ReadEncoded(ctx, namespace, id, start, end interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReadEncoded", reflect.TypeOf((*Mockdatabase)(nil).ReadEncoded), ctx, namespace, id, start, end)
}

// FetchBlocks mocks base method
func (m *Mockdatabase) FetchBlocks(ctx context.Context, namespace ident.ID, shard uint32, id ident.ID, starts []time.Time) ([]block.FetchBlockResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocks", ctx, namespace, shard, id, starts)
	ret0, _ := ret[0].([]block.FetchBlockResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBlocks indicates an expected call of FetchBlocks
func (mr *MockdatabaseMockRecorder) FetchBlocks(ctx, namespace, shard, id, starts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocks", reflect.TypeOf((*Mockdatabase)(nil).FetchBlocks), ctx, namespace, shard, id, starts)
}

// FetchBlocksMetadataV2 mocks base method
func (m *Mockdatabase) FetchBlocksMetadataV2(ctx context.Context, namespace ident.ID, shard uint32, start, end time.Time, limit int64, pageToken PageToken, opts block.FetchBlocksMetadataOptions) (block.FetchBlocksMetadataResults, PageToken, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocksMetadataV2", ctx, namespace, shard, start, end, limit, pageToken, opts)
	ret0, _ := ret[0].(block.FetchBlocksMetadataResults)
	ret1, _ := ret[1].(PageToken)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// FetchBlocksMetadataV2 indicates an expected call of FetchBlocksMetadataV2
func (mr *MockdatabaseMockRecorder) FetchBlocksMetadataV2(ctx, namespace, shard, start, end, limit, pageToken, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocksMetadataV2", reflect.TypeOf((*Mockdatabase)(nil).FetchBlocksMetadataV2), ctx, namespace, shard, start, end, limit, pageToken, opts)
}

// Bootstrap mocks base method
func (m *Mockdatabase) Bootstrap() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Bootstrap")
	ret0, _ := ret[0].(error)
	return ret0
}

// Bootstrap indicates an expected call of Bootstrap
func (mr *MockdatabaseMockRecorder) Bootstrap() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Bootstrap", reflect.TypeOf((*Mockdatabase)(nil).Bootstrap))
}

// IsBootstrapped mocks base method
func (m *Mockdatabase) IsBootstrapped() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsBootstrapped")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsBootstrapped indicates an expected call of IsBootstrapped
func (mr *MockdatabaseMockRecorder) IsBootstrapped() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsBootstrapped", reflect.TypeOf((*Mockdatabase)(nil).IsBootstrapped))
}

// IsBootstrappedAndDurable mocks base method
func (m *Mockdatabase) IsBootstrappedAndDurable() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsBootstrappedAndDurable")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsBootstrappedAndDurable indicates an expected call of IsBootstrappedAndDurable
func (mr *MockdatabaseMockRecorder) IsBootstrappedAndDurable() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsBootstrappedAndDurable", reflect.TypeOf((*Mockdatabase)(nil).IsBootstrappedAndDurable))
}

// IsOverloaded mocks base method
func (m *Mockdatabase) IsOverloaded() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsOverloaded")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsOverloaded indicates an expected call of IsOverloaded
func (mr *MockdatabaseMockRecorder) IsOverloaded() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsOverloaded", reflect.TypeOf((*Mockdatabase)(nil).IsOverloaded))
}

// Repair mocks base method
func (m *Mockdatabase) Repair() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Repair")
	ret0, _ := ret[0].(error)
	return ret0
}

// Repair indicates an expected call of Repair
func (mr *MockdatabaseMockRecorder) Repair() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Repair", reflect.TypeOf((*Mockdatabase)(nil).Repair))
}

// Truncate mocks base method
func (m *Mockdatabase) Truncate(namespace ident.ID) (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Truncate", namespace)
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Truncate indicates an expected call of Truncate
func (mr *MockdatabaseMockRecorder) Truncate(namespace interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Truncate", reflect.TypeOf((*Mockdatabase)(nil).Truncate), namespace)
}

// BootstrapState mocks base method
func (m *Mockdatabase) BootstrapState() DatabaseBootstrapState {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BootstrapState")
	ret0, _ := ret[0].(DatabaseBootstrapState)
	return ret0
}

// BootstrapState indicates an expected call of BootstrapState
func (mr *MockdatabaseMockRecorder) BootstrapState() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BootstrapState", reflect.TypeOf((*Mockdatabase)(nil).BootstrapState))
}

// FlushState mocks base method
func (m *Mockdatabase) FlushState(namespace ident.ID, shardID uint32, blockStart time.Time) (fileOpState, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FlushState", namespace, shardID, blockStart)
	ret0, _ := ret[0].(fileOpState)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FlushState indicates an expected call of FlushState
func (mr *MockdatabaseMockRecorder) FlushState(namespace, shardID, blockStart interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FlushState", reflect.TypeOf((*Mockdatabase)(nil).FlushState), namespace, shardID, blockStart)
}

// GetOwnedNamespaces mocks base method
func (m *Mockdatabase) GetOwnedNamespaces() ([]databaseNamespace, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOwnedNamespaces")
	ret0, _ := ret[0].([]databaseNamespace)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetOwnedNamespaces indicates an expected call of GetOwnedNamespaces
func (mr *MockdatabaseMockRecorder) GetOwnedNamespaces() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOwnedNamespaces", reflect.TypeOf((*Mockdatabase)(nil).GetOwnedNamespaces))
}

// UpdateOwnedNamespaces mocks base method
func (m *Mockdatabase) UpdateOwnedNamespaces(namespaces namespace.Map) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "UpdateOwnedNamespaces", namespaces)
	ret0, _ := ret[0].(error)
	return ret0
}

// UpdateOwnedNamespaces indicates an expected call of UpdateOwnedNamespaces
func (mr *MockdatabaseMockRecorder) UpdateOwnedNamespaces(namespaces interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "UpdateOwnedNamespaces", reflect.TypeOf((*Mockdatabase)(nil).UpdateOwnedNamespaces), namespaces)
}

// MockNamespace is a mock of Namespace interface
type MockNamespace struct {
	ctrl     *gomock.Controller
	recorder *MockNamespaceMockRecorder
}

// MockNamespaceMockRecorder is the mock recorder for MockNamespace
type MockNamespaceMockRecorder struct {
	mock *MockNamespace
}

// NewMockNamespace creates a new mock instance
func NewMockNamespace(ctrl *gomock.Controller) *MockNamespace {
	mock := &MockNamespace{ctrl: ctrl}
	mock.recorder = &MockNamespaceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockNamespace) EXPECT() *MockNamespaceMockRecorder {
	return m.recorder
}

// Options mocks base method
func (m *MockNamespace) Options() namespace.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Options")
	ret0, _ := ret[0].(namespace.Options)
	return ret0
}

// Options indicates an expected call of Options
func (mr *MockNamespaceMockRecorder) Options() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Options", reflect.TypeOf((*MockNamespace)(nil).Options))
}

// ID mocks base method
func (m *MockNamespace) ID() ident.ID {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ID")
	ret0, _ := ret[0].(ident.ID)
	return ret0
}

// ID indicates an expected call of ID
func (mr *MockNamespaceMockRecorder) ID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ID", reflect.TypeOf((*MockNamespace)(nil).ID))
}

// Schema mocks base method
func (m *MockNamespace) Schema() namespace.SchemaDescr {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Schema")
	ret0, _ := ret[0].(namespace.SchemaDescr)
	return ret0
}

// Schema indicates an expected call of Schema
func (mr *MockNamespaceMockRecorder) Schema() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Schema", reflect.TypeOf((*MockNamespace)(nil).Schema))
}

// NumSeries mocks base method
func (m *MockNamespace) NumSeries() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NumSeries")
	ret0, _ := ret[0].(int64)
	return ret0
}

// NumSeries indicates an expected call of NumSeries
func (mr *MockNamespaceMockRecorder) NumSeries() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NumSeries", reflect.TypeOf((*MockNamespace)(nil).NumSeries))
}

// Shards mocks base method
func (m *MockNamespace) Shards() []Shard {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Shards")
	ret0, _ := ret[0].([]Shard)
	return ret0
}

// Shards indicates an expected call of Shards
func (mr *MockNamespaceMockRecorder) Shards() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Shards", reflect.TypeOf((*MockNamespace)(nil).Shards))
}

// MockdatabaseNamespace is a mock of databaseNamespace interface
type MockdatabaseNamespace struct {
	ctrl     *gomock.Controller
	recorder *MockdatabaseNamespaceMockRecorder
}

// MockdatabaseNamespaceMockRecorder is the mock recorder for MockdatabaseNamespace
type MockdatabaseNamespaceMockRecorder struct {
	mock *MockdatabaseNamespace
}

// NewMockdatabaseNamespace creates a new mock instance
func NewMockdatabaseNamespace(ctrl *gomock.Controller) *MockdatabaseNamespace {
	mock := &MockdatabaseNamespace{ctrl: ctrl}
	mock.recorder = &MockdatabaseNamespaceMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockdatabaseNamespace) EXPECT() *MockdatabaseNamespaceMockRecorder {
	return m.recorder
}

// Options mocks base method
func (m *MockdatabaseNamespace) Options() namespace.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Options")
	ret0, _ := ret[0].(namespace.Options)
	return ret0
}

// Options indicates an expected call of Options
func (mr *MockdatabaseNamespaceMockRecorder) Options() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Options", reflect.TypeOf((*MockdatabaseNamespace)(nil).Options))
}

// ID mocks base method
func (m *MockdatabaseNamespace) ID() ident.ID {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ID")
	ret0, _ := ret[0].(ident.ID)
	return ret0
}

// ID indicates an expected call of ID
func (mr *MockdatabaseNamespaceMockRecorder) ID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ID", reflect.TypeOf((*MockdatabaseNamespace)(nil).ID))
}

// Schema mocks base method
func (m *MockdatabaseNamespace) Schema() namespace.SchemaDescr {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Schema")
	ret0, _ := ret[0].(namespace.SchemaDescr)
	return ret0
}

// Schema indicates an expected call of Schema
func (mr *MockdatabaseNamespaceMockRecorder) Schema() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Schema", reflect.TypeOf((*MockdatabaseNamespace)(nil).Schema))
}

// NumSeries mocks base method
func (m *MockdatabaseNamespace) NumSeries() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NumSeries")
	ret0, _ := ret[0].(int64)
	return ret0
}

// NumSeries indicates an expected call of NumSeries
func (mr *MockdatabaseNamespaceMockRecorder) NumSeries() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NumSeries", reflect.TypeOf((*MockdatabaseNamespace)(nil).NumSeries))
}

// Shards mocks base method
func (m *MockdatabaseNamespace) Shards() []Shard {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Shards")
	ret0, _ := ret[0].([]Shard)
	return ret0
}

// Shards indicates an expected call of Shards
func (mr *MockdatabaseNamespaceMockRecorder) Shards() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Shards", reflect.TypeOf((*MockdatabaseNamespace)(nil).Shards))
}

// Close mocks base method
func (m *MockdatabaseNamespace) Close() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Close")
	ret0, _ := ret[0].(error)
	return ret0
}

// Close indicates an expected call of Close
func (mr *MockdatabaseNamespaceMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockdatabaseNamespace)(nil).Close))
}

// AssignShardSet mocks base method
func (m *MockdatabaseNamespace) AssignShardSet(shardSet sharding.ShardSet) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "AssignShardSet", shardSet)
}

// AssignShardSet indicates an expected call of AssignShardSet
func (mr *MockdatabaseNamespaceMockRecorder) AssignShardSet(shardSet interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssignShardSet", reflect.TypeOf((*MockdatabaseNamespace)(nil).AssignShardSet), shardSet)
}

// GetOwnedShards mocks base method
func (m *MockdatabaseNamespace) GetOwnedShards() []databaseShard {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetOwnedShards")
	ret0, _ := ret[0].([]databaseShard)
	return ret0
}

// GetOwnedShards indicates an expected call of GetOwnedShards
func (mr *MockdatabaseNamespaceMockRecorder) GetOwnedShards() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetOwnedShards", reflect.TypeOf((*MockdatabaseNamespace)(nil).GetOwnedShards))
}

// GetIndex mocks base method
func (m *MockdatabaseNamespace) GetIndex() (namespaceIndex, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetIndex")
	ret0, _ := ret[0].(namespaceIndex)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// GetIndex indicates an expected call of GetIndex
func (mr *MockdatabaseNamespaceMockRecorder) GetIndex() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetIndex", reflect.TypeOf((*MockdatabaseNamespace)(nil).GetIndex))
}

// Tick mocks base method
func (m *MockdatabaseNamespace) Tick(c context.Cancellable, startTime time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Tick", c, startTime)
	ret0, _ := ret[0].(error)
	return ret0
}

// Tick indicates an expected call of Tick
func (mr *MockdatabaseNamespaceMockRecorder) Tick(c, startTime interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Tick", reflect.TypeOf((*MockdatabaseNamespace)(nil).Tick), c, startTime)
}

// Write mocks base method
func (m *MockdatabaseNamespace) Write(ctx context.Context, id ident.ID, timestamp time.Time, value float64, unit time0.Unit, annotation []byte) (ts.Series, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Write", ctx, id, timestamp, value, unit, annotation)
	ret0, _ := ret[0].(ts.Series)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// Write indicates an expected call of Write
func (mr *MockdatabaseNamespaceMockRecorder) Write(ctx, id, timestamp, value, unit, annotation interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Write", reflect.TypeOf((*MockdatabaseNamespace)(nil).Write), ctx, id, timestamp, value, unit, annotation)
}

// WriteTagged mocks base method
func (m *MockdatabaseNamespace) WriteTagged(ctx context.Context, id ident.ID, tags ident.TagIterator, timestamp time.Time, value float64, unit time0.Unit, annotation []byte) (ts.Series, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTagged", ctx, id, tags, timestamp, value, unit, annotation)
	ret0, _ := ret[0].(ts.Series)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// WriteTagged indicates an expected call of WriteTagged
func (mr *MockdatabaseNamespaceMockRecorder) WriteTagged(ctx, id, tags, timestamp, value, unit, annotation interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTagged", reflect.TypeOf((*MockdatabaseNamespace)(nil).WriteTagged), ctx, id, tags, timestamp, value, unit, annotation)
}

// QueryIDs mocks base method
func (m *MockdatabaseNamespace) QueryIDs(ctx context.Context, query index.Query, opts index.QueryOptions) (index.QueryResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "QueryIDs", ctx, query, opts)
	ret0, _ := ret[0].(index.QueryResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// QueryIDs indicates an expected call of QueryIDs
func (mr *MockdatabaseNamespaceMockRecorder) QueryIDs(ctx, query, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "QueryIDs", reflect.TypeOf((*MockdatabaseNamespace)(nil).QueryIDs), ctx, query, opts)
}

// AggregateQuery mocks base method
func (m *MockdatabaseNamespace) AggregateQuery(ctx context.Context, query index.Query, opts index.AggregationOptions) (index.AggregateQueryResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AggregateQuery", ctx, query, opts)
	ret0, _ := ret[0].(index.AggregateQueryResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AggregateQuery indicates an expected call of AggregateQuery
func (mr *MockdatabaseNamespaceMockRecorder) AggregateQuery(ctx, query, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AggregateQuery", reflect.TypeOf((*MockdatabaseNamespace)(nil).AggregateQuery), ctx, query, opts)
}

// ReadEncoded mocks base method
func (m *MockdatabaseNamespace) ReadEncoded(ctx context.Context, id ident.ID, start, end time.Time) ([][]xio.BlockReader, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReadEncoded", ctx, id, start, end)
	ret0, _ := ret[0].([][]xio.BlockReader)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReadEncoded indicates an expected call of ReadEncoded
func (mr *MockdatabaseNamespaceMockRecorder) ReadEncoded(ctx, id, start, end interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReadEncoded", reflect.TypeOf((*MockdatabaseNamespace)(nil).ReadEncoded), ctx, id, start, end)
}

// FetchBlocks mocks base method
func (m *MockdatabaseNamespace) FetchBlocks(ctx context.Context, shardID uint32, id ident.ID, starts []time.Time) ([]block.FetchBlockResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocks", ctx, shardID, id, starts)
	ret0, _ := ret[0].([]block.FetchBlockResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBlocks indicates an expected call of FetchBlocks
func (mr *MockdatabaseNamespaceMockRecorder) FetchBlocks(ctx, shardID, id, starts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocks", reflect.TypeOf((*MockdatabaseNamespace)(nil).FetchBlocks), ctx, shardID, id, starts)
}

// FetchBlocksMetadataV2 mocks base method
func (m *MockdatabaseNamespace) FetchBlocksMetadataV2(ctx context.Context, shardID uint32, start, end time.Time, limit int64, pageToken PageToken, opts block.FetchBlocksMetadataOptions) (block.FetchBlocksMetadataResults, PageToken, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocksMetadataV2", ctx, shardID, start, end, limit, pageToken, opts)
	ret0, _ := ret[0].(block.FetchBlocksMetadataResults)
	ret1, _ := ret[1].(PageToken)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// FetchBlocksMetadataV2 indicates an expected call of FetchBlocksMetadataV2
func (mr *MockdatabaseNamespaceMockRecorder) FetchBlocksMetadataV2(ctx, shardID, start, end, limit, pageToken, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocksMetadataV2", reflect.TypeOf((*MockdatabaseNamespace)(nil).FetchBlocksMetadataV2), ctx, shardID, start, end, limit, pageToken, opts)
}

// Bootstrap mocks base method
func (m *MockdatabaseNamespace) Bootstrap(start time.Time, process bootstrap.Process) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Bootstrap", start, process)
	ret0, _ := ret[0].(error)
	return ret0
}

// Bootstrap indicates an expected call of Bootstrap
func (mr *MockdatabaseNamespaceMockRecorder) Bootstrap(start, process interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Bootstrap", reflect.TypeOf((*MockdatabaseNamespace)(nil).Bootstrap), start, process)
}

// WarmFlush mocks base method
func (m *MockdatabaseNamespace) WarmFlush(blockStart time.Time, flush persist.FlushPreparer) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WarmFlush", blockStart, flush)
	ret0, _ := ret[0].(error)
	return ret0
}

// WarmFlush indicates an expected call of WarmFlush
func (mr *MockdatabaseNamespaceMockRecorder) WarmFlush(blockStart, flush interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WarmFlush", reflect.TypeOf((*MockdatabaseNamespace)(nil).WarmFlush), blockStart, flush)
}

// FlushIndex mocks base method
func (m *MockdatabaseNamespace) FlushIndex(flush persist.IndexFlush) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FlushIndex", flush)
	ret0, _ := ret[0].(error)
	return ret0
}

// FlushIndex indicates an expected call of FlushIndex
func (mr *MockdatabaseNamespaceMockRecorder) FlushIndex(flush interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FlushIndex", reflect.TypeOf((*MockdatabaseNamespace)(nil).FlushIndex), flush)
}

// ColdFlush mocks base method
func (m *MockdatabaseNamespace) ColdFlush(flush persist.FlushPreparer) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ColdFlush", flush)
	ret0, _ := ret[0].(error)
	return ret0
}

// ColdFlush indicates an expected call of ColdFlush
func (mr *MockdatabaseNamespaceMockRecorder) ColdFlush(flush interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ColdFlush", reflect.TypeOf((*MockdatabaseNamespace)(nil).ColdFlush), flush)
}

// Snapshot mocks base method
func (m *MockdatabaseNamespace) Snapshot(blockStart, snapshotTime time.Time, flush persist.SnapshotPreparer) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Snapshot", blockStart, snapshotTime, flush)
	ret0, _ := ret[0].(error)
	return ret0
}

// Snapshot indicates an expected call of Snapshot
func (mr *MockdatabaseNamespaceMockRecorder) Snapshot(blockStart, snapshotTime, flush interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Snapshot", reflect.TypeOf((*MockdatabaseNamespace)(nil).Snapshot), blockStart, snapshotTime, flush)
}

// NeedsFlush mocks base method
func (m *MockdatabaseNamespace) NeedsFlush(alignedInclusiveStart, alignedInclusiveEnd time.Time) (bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NeedsFlush", alignedInclusiveStart, alignedInclusiveEnd)
	ret0, _ := ret[0].(bool)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// NeedsFlush indicates an expected call of NeedsFlush
func (mr *MockdatabaseNamespaceMockRecorder) NeedsFlush(alignedInclusiveStart, alignedInclusiveEnd interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NeedsFlush", reflect.TypeOf((*MockdatabaseNamespace)(nil).NeedsFlush), alignedInclusiveStart, alignedInclusiveEnd)
}

// Truncate mocks base method
func (m *MockdatabaseNamespace) Truncate() (int64, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Truncate")
	ret0, _ := ret[0].(int64)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Truncate indicates an expected call of Truncate
func (mr *MockdatabaseNamespaceMockRecorder) Truncate() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Truncate", reflect.TypeOf((*MockdatabaseNamespace)(nil).Truncate))
}

// Repair mocks base method
func (m *MockdatabaseNamespace) Repair(repairer databaseShardRepairer, tr time0.Range) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Repair", repairer, tr)
	ret0, _ := ret[0].(error)
	return ret0
}

// Repair indicates an expected call of Repair
func (mr *MockdatabaseNamespaceMockRecorder) Repair(repairer, tr interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Repair", reflect.TypeOf((*MockdatabaseNamespace)(nil).Repair), repairer, tr)
}

// BootstrapState mocks base method
func (m *MockdatabaseNamespace) BootstrapState() ShardBootstrapStates {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BootstrapState")
	ret0, _ := ret[0].(ShardBootstrapStates)
	return ret0
}

// BootstrapState indicates an expected call of BootstrapState
func (mr *MockdatabaseNamespaceMockRecorder) BootstrapState() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BootstrapState", reflect.TypeOf((*MockdatabaseNamespace)(nil).BootstrapState))
}

// FlushState mocks base method
func (m *MockdatabaseNamespace) FlushState(shardID uint32, blockStart time.Time) (fileOpState, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FlushState", shardID, blockStart)
	ret0, _ := ret[0].(fileOpState)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FlushState indicates an expected call of FlushState
func (mr *MockdatabaseNamespaceMockRecorder) FlushState(shardID, blockStart interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FlushState", reflect.TypeOf((*MockdatabaseNamespace)(nil).FlushState), shardID, blockStart)
}

// MockShard is a mock of Shard interface
type MockShard struct {
	ctrl     *gomock.Controller
	recorder *MockShardMockRecorder
}

// MockShardMockRecorder is the mock recorder for MockShard
type MockShardMockRecorder struct {
	mock *MockShard
}

// NewMockShard creates a new mock instance
func NewMockShard(ctrl *gomock.Controller) *MockShard {
	mock := &MockShard{ctrl: ctrl}
	mock.recorder = &MockShardMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockShard) EXPECT() *MockShardMockRecorder {
	return m.recorder
}

// ID mocks base method
func (m *MockShard) ID() uint32 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ID")
	ret0, _ := ret[0].(uint32)
	return ret0
}

// ID indicates an expected call of ID
func (mr *MockShardMockRecorder) ID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ID", reflect.TypeOf((*MockShard)(nil).ID))
}

// NumSeries mocks base method
func (m *MockShard) NumSeries() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NumSeries")
	ret0, _ := ret[0].(int64)
	return ret0
}

// NumSeries indicates an expected call of NumSeries
func (mr *MockShardMockRecorder) NumSeries() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NumSeries", reflect.TypeOf((*MockShard)(nil).NumSeries))
}

// IsBootstrapped mocks base method
func (m *MockShard) IsBootstrapped() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsBootstrapped")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsBootstrapped indicates an expected call of IsBootstrapped
func (mr *MockShardMockRecorder) IsBootstrapped() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsBootstrapped", reflect.TypeOf((*MockShard)(nil).IsBootstrapped))
}

// BootstrapState mocks base method
func (m *MockShard) BootstrapState() BootstrapState {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BootstrapState")
	ret0, _ := ret[0].(BootstrapState)
	return ret0
}

// BootstrapState indicates an expected call of BootstrapState
func (mr *MockShardMockRecorder) BootstrapState() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BootstrapState", reflect.TypeOf((*MockShard)(nil).BootstrapState))
}

// MockdatabaseShard is a mock of databaseShard interface
type MockdatabaseShard struct {
	ctrl     *gomock.Controller
	recorder *MockdatabaseShardMockRecorder
}

// MockdatabaseShardMockRecorder is the mock recorder for MockdatabaseShard
type MockdatabaseShardMockRecorder struct {
	mock *MockdatabaseShard
}

// NewMockdatabaseShard creates a new mock instance
func NewMockdatabaseShard(ctrl *gomock.Controller) *MockdatabaseShard {
	mock := &MockdatabaseShard{ctrl: ctrl}
	mock.recorder = &MockdatabaseShardMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockdatabaseShard) EXPECT() *MockdatabaseShardMockRecorder {
	return m.recorder
}

// ID mocks base method
func (m *MockdatabaseShard) ID() uint32 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ID")
	ret0, _ := ret[0].(uint32)
	return ret0
}

// ID indicates an expected call of ID
func (mr *MockdatabaseShardMockRecorder) ID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ID", reflect.TypeOf((*MockdatabaseShard)(nil).ID))
}

// NumSeries mocks base method
func (m *MockdatabaseShard) NumSeries() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NumSeries")
	ret0, _ := ret[0].(int64)
	return ret0
}

// NumSeries indicates an expected call of NumSeries
func (mr *MockdatabaseShardMockRecorder) NumSeries() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NumSeries", reflect.TypeOf((*MockdatabaseShard)(nil).NumSeries))
}

// IsBootstrapped mocks base method
func (m *MockdatabaseShard) IsBootstrapped() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsBootstrapped")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsBootstrapped indicates an expected call of IsBootstrapped
func (mr *MockdatabaseShardMockRecorder) IsBootstrapped() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsBootstrapped", reflect.TypeOf((*MockdatabaseShard)(nil).IsBootstrapped))
}

// BootstrapState mocks base method
func (m *MockdatabaseShard) BootstrapState() BootstrapState {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BootstrapState")
	ret0, _ := ret[0].(BootstrapState)
	return ret0
}

// BootstrapState indicates an expected call of BootstrapState
func (mr *MockdatabaseShardMockRecorder) BootstrapState() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BootstrapState", reflect.TypeOf((*MockdatabaseShard)(nil).BootstrapState))
}

// OnEvictedFromWiredList mocks base method
func (m *MockdatabaseShard) OnEvictedFromWiredList(id ident.ID, blockStart time.Time) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "OnEvictedFromWiredList", id, blockStart)
}

// OnEvictedFromWiredList indicates an expected call of OnEvictedFromWiredList
func (mr *MockdatabaseShardMockRecorder) OnEvictedFromWiredList(id, blockStart interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "OnEvictedFromWiredList", reflect.TypeOf((*MockdatabaseShard)(nil).OnEvictedFromWiredList), id, blockStart)
}

// Close mocks base method
func (m *MockdatabaseShard) Close() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Close")
	ret0, _ := ret[0].(error)
	return ret0
}

// Close indicates an expected call of Close
func (mr *MockdatabaseShardMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockdatabaseShard)(nil).Close))
}

// Tick mocks base method
func (m *MockdatabaseShard) Tick(c context.Cancellable, startTime time.Time, nsCtx namespace.Context) (tickResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Tick", c, startTime, nsCtx)
	ret0, _ := ret[0].(tickResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Tick indicates an expected call of Tick
func (mr *MockdatabaseShardMockRecorder) Tick(c, startTime, nsCtx interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Tick", reflect.TypeOf((*MockdatabaseShard)(nil).Tick), c, startTime, nsCtx)
}

// Write mocks base method
func (m *MockdatabaseShard) Write(ctx context.Context, id ident.ID, timestamp time.Time, value float64, unit time0.Unit, annotation []byte, wOpts series.WriteOptions) (ts.Series, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Write", ctx, id, timestamp, value, unit, annotation, wOpts)
	ret0, _ := ret[0].(ts.Series)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// Write indicates an expected call of Write
func (mr *MockdatabaseShardMockRecorder) Write(ctx, id, timestamp, value, unit, annotation, wOpts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Write", reflect.TypeOf((*MockdatabaseShard)(nil).Write), ctx, id, timestamp, value, unit, annotation, wOpts)
}

// WriteTagged mocks base method
func (m *MockdatabaseShard) WriteTagged(ctx context.Context, id ident.ID, tags ident.TagIterator, timestamp time.Time, value float64, unit time0.Unit, annotation []byte, wOpts series.WriteOptions) (ts.Series, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTagged", ctx, id, tags, timestamp, value, unit, annotation, wOpts)
	ret0, _ := ret[0].(ts.Series)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// WriteTagged indicates an expected call of WriteTagged
func (mr *MockdatabaseShardMockRecorder) WriteTagged(ctx, id, tags, timestamp, value, unit, annotation, wOpts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTagged", reflect.TypeOf((*MockdatabaseShard)(nil).WriteTagged), ctx, id, tags, timestamp, value, unit, annotation, wOpts)
}

// ReadEncoded mocks base method
func (m *MockdatabaseShard) ReadEncoded(ctx context.Context, id ident.ID, start, end time.Time, nsCtx namespace.Context) ([][]xio.BlockReader, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReadEncoded", ctx, id, start, end, nsCtx)
	ret0, _ := ret[0].([][]xio.BlockReader)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ReadEncoded indicates an expected call of ReadEncoded
func (mr *MockdatabaseShardMockRecorder) ReadEncoded(ctx, id, start, end, nsCtx interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReadEncoded", reflect.TypeOf((*MockdatabaseShard)(nil).ReadEncoded), ctx, id, start, end, nsCtx)
}

// FetchBlocks mocks base method
func (m *MockdatabaseShard) FetchBlocks(ctx context.Context, id ident.ID, starts []time.Time, nsCtx namespace.Context) ([]block.FetchBlockResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocks", ctx, id, starts, nsCtx)
	ret0, _ := ret[0].([]block.FetchBlockResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBlocks indicates an expected call of FetchBlocks
func (mr *MockdatabaseShardMockRecorder) FetchBlocks(ctx, id, starts, nsCtx interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocks", reflect.TypeOf((*MockdatabaseShard)(nil).FetchBlocks), ctx, id, starts, nsCtx)
}

// FetchBlocksForColdFlush mocks base method
func (m *MockdatabaseShard) FetchBlocksForColdFlush(ctx context.Context, seriesID ident.ID, start time.Time, version int, nsCtx namespace.Context) ([]xio.BlockReader, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocksForColdFlush", ctx, seriesID, start, version, nsCtx)
	ret0, _ := ret[0].([]xio.BlockReader)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FetchBlocksForColdFlush indicates an expected call of FetchBlocksForColdFlush
func (mr *MockdatabaseShardMockRecorder) FetchBlocksForColdFlush(ctx, seriesID, start, version, nsCtx interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocksForColdFlush", reflect.TypeOf((*MockdatabaseShard)(nil).FetchBlocksForColdFlush), ctx, seriesID, start, version, nsCtx)
}

// FetchBlocksMetadataV2 mocks base method
func (m *MockdatabaseShard) FetchBlocksMetadataV2(ctx context.Context, start, end time.Time, limit int64, pageToken PageToken, opts block.FetchBlocksMetadataOptions) (block.FetchBlocksMetadataResults, PageToken, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocksMetadataV2", ctx, start, end, limit, pageToken, opts)
	ret0, _ := ret[0].(block.FetchBlocksMetadataResults)
	ret1, _ := ret[1].(PageToken)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// FetchBlocksMetadataV2 indicates an expected call of FetchBlocksMetadataV2
func (mr *MockdatabaseShardMockRecorder) FetchBlocksMetadataV2(ctx, start, end, limit, pageToken, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocksMetadataV2", reflect.TypeOf((*MockdatabaseShard)(nil).FetchBlocksMetadataV2), ctx, start, end, limit, pageToken, opts)
}

// Bootstrap mocks base method
func (m *MockdatabaseShard) Bootstrap(bootstrappedSeries *result.Map) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Bootstrap", bootstrappedSeries)
	ret0, _ := ret[0].(error)
	return ret0
}

// Bootstrap indicates an expected call of Bootstrap
func (mr *MockdatabaseShardMockRecorder) Bootstrap(bootstrappedSeries interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Bootstrap", reflect.TypeOf((*MockdatabaseShard)(nil).Bootstrap), bootstrappedSeries)
}

// Load mocks base method
func (m *MockdatabaseShard) Load(series *result.Map) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Load", series)
	ret0, _ := ret[0].(error)
	return ret0
}

// Load indicates an expected call of Load
func (mr *MockdatabaseShardMockRecorder) Load(series interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Load", reflect.TypeOf((*MockdatabaseShard)(nil).Load), series)
}

// WarmFlush mocks base method
func (m *MockdatabaseShard) WarmFlush(blockStart time.Time, flush persist.FlushPreparer, nsCtx namespace.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WarmFlush", blockStart, flush, nsCtx)
	ret0, _ := ret[0].(error)
	return ret0
}

// WarmFlush indicates an expected call of WarmFlush
func (mr *MockdatabaseShardMockRecorder) WarmFlush(blockStart, flush, nsCtx interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WarmFlush", reflect.TypeOf((*MockdatabaseShard)(nil).WarmFlush), blockStart, flush, nsCtx)
}

// ColdFlush mocks base method
func (m *MockdatabaseShard) ColdFlush(flush persist.FlushPreparer, resources coldFlushReuseableResources, nsCtx namespace.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ColdFlush", flush, resources, nsCtx)
	ret0, _ := ret[0].(error)
	return ret0
}

// ColdFlush indicates an expected call of ColdFlush
func (mr *MockdatabaseShardMockRecorder) ColdFlush(flush, resources, nsCtx interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ColdFlush", reflect.TypeOf((*MockdatabaseShard)(nil).ColdFlush), flush, resources, nsCtx)
}

// Snapshot mocks base method
func (m *MockdatabaseShard) Snapshot(blockStart, snapshotStart time.Time, flush persist.SnapshotPreparer, nsCtx namespace.Context) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Snapshot", blockStart, snapshotStart, flush, nsCtx)
	ret0, _ := ret[0].(error)
	return ret0
}

// Snapshot indicates an expected call of Snapshot
func (mr *MockdatabaseShardMockRecorder) Snapshot(blockStart, snapshotStart, flush, nsCtx interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Snapshot", reflect.TypeOf((*MockdatabaseShard)(nil).Snapshot), blockStart, snapshotStart, flush, nsCtx)
}

// FlushState mocks base method
func (m *MockdatabaseShard) FlushState(blockStart time.Time) (fileOpState, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FlushState", blockStart)
	ret0, _ := ret[0].(fileOpState)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// FlushState indicates an expected call of FlushState
func (mr *MockdatabaseShardMockRecorder) FlushState(blockStart interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FlushState", reflect.TypeOf((*MockdatabaseShard)(nil).FlushState), blockStart)
}

// CleanupExpiredFileSets mocks base method
func (m *MockdatabaseShard) CleanupExpiredFileSets(earliestToRetain time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CleanupExpiredFileSets", earliestToRetain)
	ret0, _ := ret[0].(error)
	return ret0
}

// CleanupExpiredFileSets indicates an expected call of CleanupExpiredFileSets
func (mr *MockdatabaseShardMockRecorder) CleanupExpiredFileSets(earliestToRetain interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CleanupExpiredFileSets", reflect.TypeOf((*MockdatabaseShard)(nil).CleanupExpiredFileSets), earliestToRetain)
}

// CleanupCompactedFileSets mocks base method
func (m *MockdatabaseShard) CleanupCompactedFileSets() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CleanupCompactedFileSets")
	ret0, _ := ret[0].(error)
	return ret0
}

// CleanupCompactedFileSets indicates an expected call of CleanupCompactedFileSets
func (mr *MockdatabaseShardMockRecorder) CleanupCompactedFileSets() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CleanupCompactedFileSets", reflect.TypeOf((*MockdatabaseShard)(nil).CleanupCompactedFileSets))
}

// Repair mocks base method
func (m *MockdatabaseShard) Repair(ctx context.Context, nsCtx namespace.Context, nsMeta namespace.Metadata, tr time0.Range, repairer databaseShardRepairer) (repair.MetadataComparisonResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Repair", ctx, nsCtx, nsMeta, tr, repairer)
	ret0, _ := ret[0].(repair.MetadataComparisonResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Repair indicates an expected call of Repair
func (mr *MockdatabaseShardMockRecorder) Repair(ctx, nsCtx, nsMeta, tr, repairer interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Repair", reflect.TypeOf((*MockdatabaseShard)(nil).Repair), ctx, nsCtx, nsMeta, tr, repairer)
}

// TagsFromSeriesID mocks base method
func (m *MockdatabaseShard) TagsFromSeriesID(seriesID ident.ID) (ident.Tags, bool, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TagsFromSeriesID", seriesID)
	ret0, _ := ret[0].(ident.Tags)
	ret1, _ := ret[1].(bool)
	ret2, _ := ret[2].(error)
	return ret0, ret1, ret2
}

// TagsFromSeriesID indicates an expected call of TagsFromSeriesID
func (mr *MockdatabaseShardMockRecorder) TagsFromSeriesID(seriesID interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TagsFromSeriesID", reflect.TypeOf((*MockdatabaseShard)(nil).TagsFromSeriesID), seriesID)
}

// MocknamespaceIndex is a mock of namespaceIndex interface
type MocknamespaceIndex struct {
	ctrl     *gomock.Controller
	recorder *MocknamespaceIndexMockRecorder
}

// MocknamespaceIndexMockRecorder is the mock recorder for MocknamespaceIndex
type MocknamespaceIndexMockRecorder struct {
	mock *MocknamespaceIndex
}

// NewMocknamespaceIndex creates a new mock instance
func NewMocknamespaceIndex(ctrl *gomock.Controller) *MocknamespaceIndex {
	mock := &MocknamespaceIndex{ctrl: ctrl}
	mock.recorder = &MocknamespaceIndexMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MocknamespaceIndex) EXPECT() *MocknamespaceIndexMockRecorder {
	return m.recorder
}

// AssignShardSet mocks base method
func (m *MocknamespaceIndex) AssignShardSet(shardSet sharding.ShardSet) {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "AssignShardSet", shardSet)
}

// AssignShardSet indicates an expected call of AssignShardSet
func (mr *MocknamespaceIndexMockRecorder) AssignShardSet(shardSet interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AssignShardSet", reflect.TypeOf((*MocknamespaceIndex)(nil).AssignShardSet), shardSet)
}

// BlockStartForWriteTime mocks base method
func (m *MocknamespaceIndex) BlockStartForWriteTime(writeTime time.Time) time0.UnixNano {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BlockStartForWriteTime", writeTime)
	ret0, _ := ret[0].(time0.UnixNano)
	return ret0
}

// BlockStartForWriteTime indicates an expected call of BlockStartForWriteTime
func (mr *MocknamespaceIndexMockRecorder) BlockStartForWriteTime(writeTime interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BlockStartForWriteTime", reflect.TypeOf((*MocknamespaceIndex)(nil).BlockStartForWriteTime), writeTime)
}

// WriteBatch mocks base method
func (m *MocknamespaceIndex) WriteBatch(batch *index.WriteBatch) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteBatch", batch)
	ret0, _ := ret[0].(error)
	return ret0
}

// WriteBatch indicates an expected call of WriteBatch
func (mr *MocknamespaceIndexMockRecorder) WriteBatch(batch interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteBatch", reflect.TypeOf((*MocknamespaceIndex)(nil).WriteBatch), batch)
}

// Query mocks base method
func (m *MocknamespaceIndex) Query(ctx context.Context, query index.Query, opts index.QueryOptions) (index.QueryResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Query", ctx, query, opts)
	ret0, _ := ret[0].(index.QueryResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Query indicates an expected call of Query
func (mr *MocknamespaceIndexMockRecorder) Query(ctx, query, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Query", reflect.TypeOf((*MocknamespaceIndex)(nil).Query), ctx, query, opts)
}

// AggregateQuery mocks base method
func (m *MocknamespaceIndex) AggregateQuery(ctx context.Context, query index.Query, opts index.AggregationOptions) (index.AggregateQueryResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AggregateQuery", ctx, query, opts)
	ret0, _ := ret[0].(index.AggregateQueryResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// AggregateQuery indicates an expected call of AggregateQuery
func (mr *MocknamespaceIndexMockRecorder) AggregateQuery(ctx, query, opts interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AggregateQuery", reflect.TypeOf((*MocknamespaceIndex)(nil).AggregateQuery), ctx, query, opts)
}

// Bootstrap mocks base method
func (m *MocknamespaceIndex) Bootstrap(bootstrapResults result.IndexResults) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Bootstrap", bootstrapResults)
	ret0, _ := ret[0].(error)
	return ret0
}

// Bootstrap indicates an expected call of Bootstrap
func (mr *MocknamespaceIndexMockRecorder) Bootstrap(bootstrapResults interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Bootstrap", reflect.TypeOf((*MocknamespaceIndex)(nil).Bootstrap), bootstrapResults)
}

// BootstrapsDone mocks base method
func (m *MocknamespaceIndex) BootstrapsDone() uint {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BootstrapsDone")
	ret0, _ := ret[0].(uint)
	return ret0
}

// BootstrapsDone indicates an expected call of BootstrapsDone
func (mr *MocknamespaceIndexMockRecorder) BootstrapsDone() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BootstrapsDone", reflect.TypeOf((*MocknamespaceIndex)(nil).BootstrapsDone))
}

// CleanupExpiredFileSets mocks base method
func (m *MocknamespaceIndex) CleanupExpiredFileSets(t time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CleanupExpiredFileSets", t)
	ret0, _ := ret[0].(error)
	return ret0
}

// CleanupExpiredFileSets indicates an expected call of CleanupExpiredFileSets
func (mr *MocknamespaceIndexMockRecorder) CleanupExpiredFileSets(t interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CleanupExpiredFileSets", reflect.TypeOf((*MocknamespaceIndex)(nil).CleanupExpiredFileSets), t)
}

// Tick mocks base method
func (m *MocknamespaceIndex) Tick(c context.Cancellable, startTime time.Time) (namespaceIndexTickResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Tick", c, startTime)
	ret0, _ := ret[0].(namespaceIndexTickResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Tick indicates an expected call of Tick
func (mr *MocknamespaceIndexMockRecorder) Tick(c, startTime interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Tick", reflect.TypeOf((*MocknamespaceIndex)(nil).Tick), c, startTime)
}

// Flush mocks base method
func (m *MocknamespaceIndex) Flush(flush persist.IndexFlush, shards []databaseShard) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Flush", flush, shards)
	ret0, _ := ret[0].(error)
	return ret0
}

// Flush indicates an expected call of Flush
func (mr *MocknamespaceIndexMockRecorder) Flush(flush, shards interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Flush", reflect.TypeOf((*MocknamespaceIndex)(nil).Flush), flush, shards)
}

// Close mocks base method
func (m *MocknamespaceIndex) Close() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Close")
	ret0, _ := ret[0].(error)
	return ret0
}

// Close indicates an expected call of Close
func (mr *MocknamespaceIndexMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MocknamespaceIndex)(nil).Close))
}

// MocknamespaceIndexInsertQueue is a mock of namespaceIndexInsertQueue interface
type MocknamespaceIndexInsertQueue struct {
	ctrl     *gomock.Controller
	recorder *MocknamespaceIndexInsertQueueMockRecorder
}

// MocknamespaceIndexInsertQueueMockRecorder is the mock recorder for MocknamespaceIndexInsertQueue
type MocknamespaceIndexInsertQueueMockRecorder struct {
	mock *MocknamespaceIndexInsertQueue
}

// NewMocknamespaceIndexInsertQueue creates a new mock instance
func NewMocknamespaceIndexInsertQueue(ctrl *gomock.Controller) *MocknamespaceIndexInsertQueue {
	mock := &MocknamespaceIndexInsertQueue{ctrl: ctrl}
	mock.recorder = &MocknamespaceIndexInsertQueueMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MocknamespaceIndexInsertQueue) EXPECT() *MocknamespaceIndexInsertQueueMockRecorder {
	return m.recorder
}

// Start mocks base method
func (m *MocknamespaceIndexInsertQueue) Start() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Start")
	ret0, _ := ret[0].(error)
	return ret0
}

// Start indicates an expected call of Start
func (mr *MocknamespaceIndexInsertQueueMockRecorder) Start() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Start", reflect.TypeOf((*MocknamespaceIndexInsertQueue)(nil).Start))
}

// Stop mocks base method
func (m *MocknamespaceIndexInsertQueue) Stop() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Stop")
	ret0, _ := ret[0].(error)
	return ret0
}

// Stop indicates an expected call of Stop
func (mr *MocknamespaceIndexInsertQueueMockRecorder) Stop() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Stop", reflect.TypeOf((*MocknamespaceIndexInsertQueue)(nil).Stop))
}

// InsertBatch mocks base method
func (m *MocknamespaceIndexInsertQueue) InsertBatch(batch *index.WriteBatch) (*sync.WaitGroup, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InsertBatch", batch)
	ret0, _ := ret[0].(*sync.WaitGroup)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// InsertBatch indicates an expected call of InsertBatch
func (mr *MocknamespaceIndexInsertQueueMockRecorder) InsertBatch(batch interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InsertBatch", reflect.TypeOf((*MocknamespaceIndexInsertQueue)(nil).InsertBatch), batch)
}

// MockdatabaseBootstrapManager is a mock of databaseBootstrapManager interface
type MockdatabaseBootstrapManager struct {
	ctrl     *gomock.Controller
	recorder *MockdatabaseBootstrapManagerMockRecorder
}

// MockdatabaseBootstrapManagerMockRecorder is the mock recorder for MockdatabaseBootstrapManager
type MockdatabaseBootstrapManagerMockRecorder struct {
	mock *MockdatabaseBootstrapManager
}

// NewMockdatabaseBootstrapManager creates a new mock instance
func NewMockdatabaseBootstrapManager(ctrl *gomock.Controller) *MockdatabaseBootstrapManager {
	mock := &MockdatabaseBootstrapManager{ctrl: ctrl}
	mock.recorder = &MockdatabaseBootstrapManagerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockdatabaseBootstrapManager) EXPECT() *MockdatabaseBootstrapManagerMockRecorder {
	return m.recorder
}

// IsBootstrapped mocks base method
func (m *MockdatabaseBootstrapManager) IsBootstrapped() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsBootstrapped")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsBootstrapped indicates an expected call of IsBootstrapped
func (mr *MockdatabaseBootstrapManagerMockRecorder) IsBootstrapped() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsBootstrapped", reflect.TypeOf((*MockdatabaseBootstrapManager)(nil).IsBootstrapped))
}

// LastBootstrapCompletionTime mocks base method
func (m *MockdatabaseBootstrapManager) LastBootstrapCompletionTime() (time.Time, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LastBootstrapCompletionTime")
	ret0, _ := ret[0].(time.Time)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// LastBootstrapCompletionTime indicates an expected call of LastBootstrapCompletionTime
func (mr *MockdatabaseBootstrapManagerMockRecorder) LastBootstrapCompletionTime() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LastBootstrapCompletionTime", reflect.TypeOf((*MockdatabaseBootstrapManager)(nil).LastBootstrapCompletionTime))
}

// Bootstrap mocks base method
func (m *MockdatabaseBootstrapManager) Bootstrap() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Bootstrap")
	ret0, _ := ret[0].(error)
	return ret0
}

// Bootstrap indicates an expected call of Bootstrap
func (mr *MockdatabaseBootstrapManagerMockRecorder) Bootstrap() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Bootstrap", reflect.TypeOf((*MockdatabaseBootstrapManager)(nil).Bootstrap))
}

// Report mocks base method
func (m *MockdatabaseBootstrapManager) Report() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Report")
}

// Report indicates an expected call of Report
func (mr *MockdatabaseBootstrapManagerMockRecorder) Report() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Report", reflect.TypeOf((*MockdatabaseBootstrapManager)(nil).Report))
}

// MockdatabaseFlushManager is a mock of databaseFlushManager interface
type MockdatabaseFlushManager struct {
	ctrl     *gomock.Controller
	recorder *MockdatabaseFlushManagerMockRecorder
}

// MockdatabaseFlushManagerMockRecorder is the mock recorder for MockdatabaseFlushManager
type MockdatabaseFlushManagerMockRecorder struct {
	mock *MockdatabaseFlushManager
}

// NewMockdatabaseFlushManager creates a new mock instance
func NewMockdatabaseFlushManager(ctrl *gomock.Controller) *MockdatabaseFlushManager {
	mock := &MockdatabaseFlushManager{ctrl: ctrl}
	mock.recorder = &MockdatabaseFlushManagerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockdatabaseFlushManager) EXPECT() *MockdatabaseFlushManagerMockRecorder {
	return m.recorder
}

// Flush mocks base method
func (m *MockdatabaseFlushManager) Flush(startTime time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Flush", startTime)
	ret0, _ := ret[0].(error)
	return ret0
}

// Flush indicates an expected call of Flush
func (mr *MockdatabaseFlushManagerMockRecorder) Flush(startTime interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Flush", reflect.TypeOf((*MockdatabaseFlushManager)(nil).Flush), startTime)
}

// LastSuccessfulSnapshotStartTime mocks base method
func (m *MockdatabaseFlushManager) LastSuccessfulSnapshotStartTime() (time.Time, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LastSuccessfulSnapshotStartTime")
	ret0, _ := ret[0].(time.Time)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// LastSuccessfulSnapshotStartTime indicates an expected call of LastSuccessfulSnapshotStartTime
func (mr *MockdatabaseFlushManagerMockRecorder) LastSuccessfulSnapshotStartTime() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LastSuccessfulSnapshotStartTime", reflect.TypeOf((*MockdatabaseFlushManager)(nil).LastSuccessfulSnapshotStartTime))
}

// Report mocks base method
func (m *MockdatabaseFlushManager) Report() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Report")
}

// Report indicates an expected call of Report
func (mr *MockdatabaseFlushManagerMockRecorder) Report() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Report", reflect.TypeOf((*MockdatabaseFlushManager)(nil).Report))
}

// MockdatabaseCleanupManager is a mock of databaseCleanupManager interface
type MockdatabaseCleanupManager struct {
	ctrl     *gomock.Controller
	recorder *MockdatabaseCleanupManagerMockRecorder
}

// MockdatabaseCleanupManagerMockRecorder is the mock recorder for MockdatabaseCleanupManager
type MockdatabaseCleanupManagerMockRecorder struct {
	mock *MockdatabaseCleanupManager
}

// NewMockdatabaseCleanupManager creates a new mock instance
func NewMockdatabaseCleanupManager(ctrl *gomock.Controller) *MockdatabaseCleanupManager {
	mock := &MockdatabaseCleanupManager{ctrl: ctrl}
	mock.recorder = &MockdatabaseCleanupManagerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockdatabaseCleanupManager) EXPECT() *MockdatabaseCleanupManagerMockRecorder {
	return m.recorder
}

// Cleanup mocks base method
func (m *MockdatabaseCleanupManager) Cleanup(t time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Cleanup", t)
	ret0, _ := ret[0].(error)
	return ret0
}

// Cleanup indicates an expected call of Cleanup
func (mr *MockdatabaseCleanupManagerMockRecorder) Cleanup(t interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Cleanup", reflect.TypeOf((*MockdatabaseCleanupManager)(nil).Cleanup), t)
}

// Report mocks base method
func (m *MockdatabaseCleanupManager) Report() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Report")
}

// Report indicates an expected call of Report
func (mr *MockdatabaseCleanupManagerMockRecorder) Report() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Report", reflect.TypeOf((*MockdatabaseCleanupManager)(nil).Report))
}

// MockdatabaseFileSystemManager is a mock of databaseFileSystemManager interface
type MockdatabaseFileSystemManager struct {
	ctrl     *gomock.Controller
	recorder *MockdatabaseFileSystemManagerMockRecorder
}

// MockdatabaseFileSystemManagerMockRecorder is the mock recorder for MockdatabaseFileSystemManager
type MockdatabaseFileSystemManagerMockRecorder struct {
	mock *MockdatabaseFileSystemManager
}

// NewMockdatabaseFileSystemManager creates a new mock instance
func NewMockdatabaseFileSystemManager(ctrl *gomock.Controller) *MockdatabaseFileSystemManager {
	mock := &MockdatabaseFileSystemManager{ctrl: ctrl}
	mock.recorder = &MockdatabaseFileSystemManagerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockdatabaseFileSystemManager) EXPECT() *MockdatabaseFileSystemManagerMockRecorder {
	return m.recorder
}

// Cleanup mocks base method
func (m *MockdatabaseFileSystemManager) Cleanup(t time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Cleanup", t)
	ret0, _ := ret[0].(error)
	return ret0
}

// Cleanup indicates an expected call of Cleanup
func (mr *MockdatabaseFileSystemManagerMockRecorder) Cleanup(t interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Cleanup", reflect.TypeOf((*MockdatabaseFileSystemManager)(nil).Cleanup), t)
}

// Flush mocks base method
func (m *MockdatabaseFileSystemManager) Flush(t time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Flush", t)
	ret0, _ := ret[0].(error)
	return ret0
}

// Flush indicates an expected call of Flush
func (mr *MockdatabaseFileSystemManagerMockRecorder) Flush(t interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Flush", reflect.TypeOf((*MockdatabaseFileSystemManager)(nil).Flush), t)
}

// Disable mocks base method
func (m *MockdatabaseFileSystemManager) Disable() fileOpStatus {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Disable")
	ret0, _ := ret[0].(fileOpStatus)
	return ret0
}

// Disable indicates an expected call of Disable
func (mr *MockdatabaseFileSystemManagerMockRecorder) Disable() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Disable", reflect.TypeOf((*MockdatabaseFileSystemManager)(nil).Disable))
}

// Enable mocks base method
func (m *MockdatabaseFileSystemManager) Enable() fileOpStatus {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Enable")
	ret0, _ := ret[0].(fileOpStatus)
	return ret0
}

// Enable indicates an expected call of Enable
func (mr *MockdatabaseFileSystemManagerMockRecorder) Enable() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Enable", reflect.TypeOf((*MockdatabaseFileSystemManager)(nil).Enable))
}

// Status mocks base method
func (m *MockdatabaseFileSystemManager) Status() fileOpStatus {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Status")
	ret0, _ := ret[0].(fileOpStatus)
	return ret0
}

// Status indicates an expected call of Status
func (mr *MockdatabaseFileSystemManagerMockRecorder) Status() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Status", reflect.TypeOf((*MockdatabaseFileSystemManager)(nil).Status))
}

// Run mocks base method
func (m *MockdatabaseFileSystemManager) Run(t time.Time, runType runType, forceType forceType) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Run", t, runType, forceType)
	ret0, _ := ret[0].(bool)
	return ret0
}

// Run indicates an expected call of Run
func (mr *MockdatabaseFileSystemManagerMockRecorder) Run(t, runType, forceType interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Run", reflect.TypeOf((*MockdatabaseFileSystemManager)(nil).Run), t, runType, forceType)
}

// Report mocks base method
func (m *MockdatabaseFileSystemManager) Report() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Report")
}

// Report indicates an expected call of Report
func (mr *MockdatabaseFileSystemManagerMockRecorder) Report() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Report", reflect.TypeOf((*MockdatabaseFileSystemManager)(nil).Report))
}

// LastSuccessfulSnapshotStartTime mocks base method
func (m *MockdatabaseFileSystemManager) LastSuccessfulSnapshotStartTime() (time.Time, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LastSuccessfulSnapshotStartTime")
	ret0, _ := ret[0].(time.Time)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// LastSuccessfulSnapshotStartTime indicates an expected call of LastSuccessfulSnapshotStartTime
func (mr *MockdatabaseFileSystemManagerMockRecorder) LastSuccessfulSnapshotStartTime() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LastSuccessfulSnapshotStartTime", reflect.TypeOf((*MockdatabaseFileSystemManager)(nil).LastSuccessfulSnapshotStartTime))
}

// MockdatabaseShardRepairer is a mock of databaseShardRepairer interface
type MockdatabaseShardRepairer struct {
	ctrl     *gomock.Controller
	recorder *MockdatabaseShardRepairerMockRecorder
}

// MockdatabaseShardRepairerMockRecorder is the mock recorder for MockdatabaseShardRepairer
type MockdatabaseShardRepairerMockRecorder struct {
	mock *MockdatabaseShardRepairer
}

// NewMockdatabaseShardRepairer creates a new mock instance
func NewMockdatabaseShardRepairer(ctrl *gomock.Controller) *MockdatabaseShardRepairer {
	mock := &MockdatabaseShardRepairer{ctrl: ctrl}
	mock.recorder = &MockdatabaseShardRepairerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockdatabaseShardRepairer) EXPECT() *MockdatabaseShardRepairerMockRecorder {
	return m.recorder
}

// Options mocks base method
func (m *MockdatabaseShardRepairer) Options() repair.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Options")
	ret0, _ := ret[0].(repair.Options)
	return ret0
}

// Options indicates an expected call of Options
func (mr *MockdatabaseShardRepairerMockRecorder) Options() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Options", reflect.TypeOf((*MockdatabaseShardRepairer)(nil).Options))
}

// Repair mocks base method
func (m *MockdatabaseShardRepairer) Repair(ctx context.Context, nsCtx namespace.Context, nsMeta namespace.Metadata, tr time0.Range, shard databaseShard) (repair.MetadataComparisonResult, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Repair", ctx, nsCtx, nsMeta, tr, shard)
	ret0, _ := ret[0].(repair.MetadataComparisonResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Repair indicates an expected call of Repair
func (mr *MockdatabaseShardRepairerMockRecorder) Repair(ctx, nsCtx, nsMeta, tr, shard interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Repair", reflect.TypeOf((*MockdatabaseShardRepairer)(nil).Repair), ctx, nsCtx, nsMeta, tr, shard)
}

// MockdatabaseRepairer is a mock of databaseRepairer interface
type MockdatabaseRepairer struct {
	ctrl     *gomock.Controller
	recorder *MockdatabaseRepairerMockRecorder
}

// MockdatabaseRepairerMockRecorder is the mock recorder for MockdatabaseRepairer
type MockdatabaseRepairerMockRecorder struct {
	mock *MockdatabaseRepairer
}

// NewMockdatabaseRepairer creates a new mock instance
func NewMockdatabaseRepairer(ctrl *gomock.Controller) *MockdatabaseRepairer {
	mock := &MockdatabaseRepairer{ctrl: ctrl}
	mock.recorder = &MockdatabaseRepairerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockdatabaseRepairer) EXPECT() *MockdatabaseRepairerMockRecorder {
	return m.recorder
}

// Start mocks base method
func (m *MockdatabaseRepairer) Start() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Start")
}

// Start indicates an expected call of Start
func (mr *MockdatabaseRepairerMockRecorder) Start() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Start", reflect.TypeOf((*MockdatabaseRepairer)(nil).Start))
}

// Stop mocks base method
func (m *MockdatabaseRepairer) Stop() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Stop")
}

// Stop indicates an expected call of Stop
func (mr *MockdatabaseRepairerMockRecorder) Stop() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Stop", reflect.TypeOf((*MockdatabaseRepairer)(nil).Stop))
}

// Repair mocks base method
func (m *MockdatabaseRepairer) Repair() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Repair")
	ret0, _ := ret[0].(error)
	return ret0
}

// Repair indicates an expected call of Repair
func (mr *MockdatabaseRepairerMockRecorder) Repair() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Repair", reflect.TypeOf((*MockdatabaseRepairer)(nil).Repair))
}

// Report mocks base method
func (m *MockdatabaseRepairer) Report() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Report")
}

// Report indicates an expected call of Report
func (mr *MockdatabaseRepairerMockRecorder) Report() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Report", reflect.TypeOf((*MockdatabaseRepairer)(nil).Report))
}

// MockdatabaseTickManager is a mock of databaseTickManager interface
type MockdatabaseTickManager struct {
	ctrl     *gomock.Controller
	recorder *MockdatabaseTickManagerMockRecorder
}

// MockdatabaseTickManagerMockRecorder is the mock recorder for MockdatabaseTickManager
type MockdatabaseTickManagerMockRecorder struct {
	mock *MockdatabaseTickManager
}

// NewMockdatabaseTickManager creates a new mock instance
func NewMockdatabaseTickManager(ctrl *gomock.Controller) *MockdatabaseTickManager {
	mock := &MockdatabaseTickManager{ctrl: ctrl}
	mock.recorder = &MockdatabaseTickManagerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockdatabaseTickManager) EXPECT() *MockdatabaseTickManagerMockRecorder {
	return m.recorder
}

// Tick mocks base method
func (m *MockdatabaseTickManager) Tick(forceType forceType, startTime time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Tick", forceType, startTime)
	ret0, _ := ret[0].(error)
	return ret0
}

// Tick indicates an expected call of Tick
func (mr *MockdatabaseTickManagerMockRecorder) Tick(forceType, startTime interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Tick", reflect.TypeOf((*MockdatabaseTickManager)(nil).Tick), forceType, startTime)
}

// MockdatabaseMediator is a mock of databaseMediator interface
type MockdatabaseMediator struct {
	ctrl     *gomock.Controller
	recorder *MockdatabaseMediatorMockRecorder
}

// MockdatabaseMediatorMockRecorder is the mock recorder for MockdatabaseMediator
type MockdatabaseMediatorMockRecorder struct {
	mock *MockdatabaseMediator
}

// NewMockdatabaseMediator creates a new mock instance
func NewMockdatabaseMediator(ctrl *gomock.Controller) *MockdatabaseMediator {
	mock := &MockdatabaseMediator{ctrl: ctrl}
	mock.recorder = &MockdatabaseMediatorMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockdatabaseMediator) EXPECT() *MockdatabaseMediatorMockRecorder {
	return m.recorder
}

// Open mocks base method
func (m *MockdatabaseMediator) Open() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Open")
	ret0, _ := ret[0].(error)
	return ret0
}

// Open indicates an expected call of Open
func (mr *MockdatabaseMediatorMockRecorder) Open() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Open", reflect.TypeOf((*MockdatabaseMediator)(nil).Open))
}

// IsBootstrapped mocks base method
func (m *MockdatabaseMediator) IsBootstrapped() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IsBootstrapped")
	ret0, _ := ret[0].(bool)
	return ret0
}

// IsBootstrapped indicates an expected call of IsBootstrapped
func (mr *MockdatabaseMediatorMockRecorder) IsBootstrapped() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IsBootstrapped", reflect.TypeOf((*MockdatabaseMediator)(nil).IsBootstrapped))
}

// LastBootstrapCompletionTime mocks base method
func (m *MockdatabaseMediator) LastBootstrapCompletionTime() (time.Time, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LastBootstrapCompletionTime")
	ret0, _ := ret[0].(time.Time)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// LastBootstrapCompletionTime indicates an expected call of LastBootstrapCompletionTime
func (mr *MockdatabaseMediatorMockRecorder) LastBootstrapCompletionTime() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LastBootstrapCompletionTime", reflect.TypeOf((*MockdatabaseMediator)(nil).LastBootstrapCompletionTime))
}

// Bootstrap mocks base method
func (m *MockdatabaseMediator) Bootstrap() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Bootstrap")
	ret0, _ := ret[0].(error)
	return ret0
}

// Bootstrap indicates an expected call of Bootstrap
func (mr *MockdatabaseMediatorMockRecorder) Bootstrap() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Bootstrap", reflect.TypeOf((*MockdatabaseMediator)(nil).Bootstrap))
}

// DisableFileOps mocks base method
func (m *MockdatabaseMediator) DisableFileOps() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "DisableFileOps")
}

// DisableFileOps indicates an expected call of DisableFileOps
func (mr *MockdatabaseMediatorMockRecorder) DisableFileOps() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DisableFileOps", reflect.TypeOf((*MockdatabaseMediator)(nil).DisableFileOps))
}

// EnableFileOps mocks base method
func (m *MockdatabaseMediator) EnableFileOps() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "EnableFileOps")
}

// EnableFileOps indicates an expected call of EnableFileOps
func (mr *MockdatabaseMediatorMockRecorder) EnableFileOps() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EnableFileOps", reflect.TypeOf((*MockdatabaseMediator)(nil).EnableFileOps))
}

// Tick mocks base method
func (m *MockdatabaseMediator) Tick(forceType forceType, startTime time.Time) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Tick", forceType, startTime)
	ret0, _ := ret[0].(error)
	return ret0
}

// Tick indicates an expected call of Tick
func (mr *MockdatabaseMediatorMockRecorder) Tick(forceType, startTime interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Tick", reflect.TypeOf((*MockdatabaseMediator)(nil).Tick), forceType, startTime)
}

// Repair mocks base method
func (m *MockdatabaseMediator) Repair() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Repair")
	ret0, _ := ret[0].(error)
	return ret0
}

// Repair indicates an expected call of Repair
func (mr *MockdatabaseMediatorMockRecorder) Repair() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Repair", reflect.TypeOf((*MockdatabaseMediator)(nil).Repair))
}

// Close mocks base method
func (m *MockdatabaseMediator) Close() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Close")
	ret0, _ := ret[0].(error)
	return ret0
}

// Close indicates an expected call of Close
func (mr *MockdatabaseMediatorMockRecorder) Close() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Close", reflect.TypeOf((*MockdatabaseMediator)(nil).Close))
}

// Report mocks base method
func (m *MockdatabaseMediator) Report() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "Report")
}

// Report indicates an expected call of Report
func (mr *MockdatabaseMediatorMockRecorder) Report() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Report", reflect.TypeOf((*MockdatabaseMediator)(nil).Report))
}

// LastSuccessfulSnapshotStartTime mocks base method
func (m *MockdatabaseMediator) LastSuccessfulSnapshotStartTime() (time.Time, bool) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "LastSuccessfulSnapshotStartTime")
	ret0, _ := ret[0].(time.Time)
	ret1, _ := ret[1].(bool)
	return ret0, ret1
}

// LastSuccessfulSnapshotStartTime indicates an expected call of LastSuccessfulSnapshotStartTime
func (mr *MockdatabaseMediatorMockRecorder) LastSuccessfulSnapshotStartTime() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "LastSuccessfulSnapshotStartTime", reflect.TypeOf((*MockdatabaseMediator)(nil).LastSuccessfulSnapshotStartTime))
}

// MockOptions is a mock of Options interface
type MockOptions struct {
	ctrl     *gomock.Controller
	recorder *MockOptionsMockRecorder
}

// MockOptionsMockRecorder is the mock recorder for MockOptions
type MockOptionsMockRecorder struct {
	mock *MockOptions
}

// NewMockOptions creates a new mock instance
func NewMockOptions(ctrl *gomock.Controller) *MockOptions {
	mock := &MockOptions{ctrl: ctrl}
	mock.recorder = &MockOptionsMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockOptions) EXPECT() *MockOptionsMockRecorder {
	return m.recorder
}

// Validate mocks base method
func (m *MockOptions) Validate() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Validate")
	ret0, _ := ret[0].(error)
	return ret0
}

// Validate indicates an expected call of Validate
func (mr *MockOptionsMockRecorder) Validate() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Validate", reflect.TypeOf((*MockOptions)(nil).Validate))
}

// SetEncodingM3TSZPooled mocks base method
func (m *MockOptions) SetEncodingM3TSZPooled() Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetEncodingM3TSZPooled")
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetEncodingM3TSZPooled indicates an expected call of SetEncodingM3TSZPooled
func (mr *MockOptionsMockRecorder) SetEncodingM3TSZPooled() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetEncodingM3TSZPooled", reflect.TypeOf((*MockOptions)(nil).SetEncodingM3TSZPooled))
}

// SetClockOptions mocks base method
func (m *MockOptions) SetClockOptions(value clock.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetClockOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetClockOptions indicates an expected call of SetClockOptions
func (mr *MockOptionsMockRecorder) SetClockOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetClockOptions", reflect.TypeOf((*MockOptions)(nil).SetClockOptions), value)
}

// ClockOptions mocks base method
func (m *MockOptions) ClockOptions() clock.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ClockOptions")
	ret0, _ := ret[0].(clock.Options)
	return ret0
}

// ClockOptions indicates an expected call of ClockOptions
func (mr *MockOptionsMockRecorder) ClockOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ClockOptions", reflect.TypeOf((*MockOptions)(nil).ClockOptions))
}

// SetInstrumentOptions mocks base method
func (m *MockOptions) SetInstrumentOptions(value instrument.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetInstrumentOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetInstrumentOptions indicates an expected call of SetInstrumentOptions
func (mr *MockOptionsMockRecorder) SetInstrumentOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetInstrumentOptions", reflect.TypeOf((*MockOptions)(nil).SetInstrumentOptions), value)
}

// InstrumentOptions mocks base method
func (m *MockOptions) InstrumentOptions() instrument.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "InstrumentOptions")
	ret0, _ := ret[0].(instrument.Options)
	return ret0
}

// InstrumentOptions indicates an expected call of InstrumentOptions
func (mr *MockOptionsMockRecorder) InstrumentOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "InstrumentOptions", reflect.TypeOf((*MockOptions)(nil).InstrumentOptions))
}

// SetNamespaceInitializer mocks base method
func (m *MockOptions) SetNamespaceInitializer(value namespace.Initializer) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetNamespaceInitializer", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetNamespaceInitializer indicates an expected call of SetNamespaceInitializer
func (mr *MockOptionsMockRecorder) SetNamespaceInitializer(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetNamespaceInitializer", reflect.TypeOf((*MockOptions)(nil).SetNamespaceInitializer), value)
}

// NamespaceInitializer mocks base method
func (m *MockOptions) NamespaceInitializer() namespace.Initializer {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NamespaceInitializer")
	ret0, _ := ret[0].(namespace.Initializer)
	return ret0
}

// NamespaceInitializer indicates an expected call of NamespaceInitializer
func (mr *MockOptionsMockRecorder) NamespaceInitializer() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NamespaceInitializer", reflect.TypeOf((*MockOptions)(nil).NamespaceInitializer))
}

// SetDatabaseBlockOptions mocks base method
func (m *MockOptions) SetDatabaseBlockOptions(value block.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetDatabaseBlockOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetDatabaseBlockOptions indicates an expected call of SetDatabaseBlockOptions
func (mr *MockOptionsMockRecorder) SetDatabaseBlockOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetDatabaseBlockOptions", reflect.TypeOf((*MockOptions)(nil).SetDatabaseBlockOptions), value)
}

// DatabaseBlockOptions mocks base method
func (m *MockOptions) DatabaseBlockOptions() block.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DatabaseBlockOptions")
	ret0, _ := ret[0].(block.Options)
	return ret0
}

// DatabaseBlockOptions indicates an expected call of DatabaseBlockOptions
func (mr *MockOptionsMockRecorder) DatabaseBlockOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DatabaseBlockOptions", reflect.TypeOf((*MockOptions)(nil).DatabaseBlockOptions))
}

// SetCommitLogOptions mocks base method
func (m *MockOptions) SetCommitLogOptions(value commitlog.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetCommitLogOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetCommitLogOptions indicates an expected call of SetCommitLogOptions
func (mr *MockOptionsMockRecorder) SetCommitLogOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetCommitLogOptions", reflect.TypeOf((*MockOptions)(nil).SetCommitLogOptions), value)
}

// CommitLogOptions mocks base method
func (m *MockOptions) CommitLogOptions() commitlog.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "CommitLogOptions")
	ret0, _ := ret[0].(commitlog.Options)
	return ret0
}

// CommitLogOptions indicates an expected call of CommitLogOptions
func (mr *MockOptionsMockRecorder) CommitLogOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "CommitLogOptions", reflect.TypeOf((*MockOptions)(nil).CommitLogOptions))
}

// SetRuntimeOptionsManager mocks base method
func (m *MockOptions) SetRuntimeOptionsManager(value runtime.OptionsManager) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetRuntimeOptionsManager", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetRuntimeOptionsManager indicates an expected call of SetRuntimeOptionsManager
func (mr *MockOptionsMockRecorder) SetRuntimeOptionsManager(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetRuntimeOptionsManager", reflect.TypeOf((*MockOptions)(nil).SetRuntimeOptionsManager), value)
}

// RuntimeOptionsManager mocks base method
func (m *MockOptions) RuntimeOptionsManager() runtime.OptionsManager {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RuntimeOptionsManager")
	ret0, _ := ret[0].(runtime.OptionsManager)
	return ret0
}

// RuntimeOptionsManager indicates an expected call of RuntimeOptionsManager
func (mr *MockOptionsMockRecorder) RuntimeOptionsManager() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RuntimeOptionsManager", reflect.TypeOf((*MockOptions)(nil).RuntimeOptionsManager))
}

// SetErrorWindowForLoad mocks base method
func (m *MockOptions) SetErrorWindowForLoad(value time.Duration) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetErrorWindowForLoad", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetErrorWindowForLoad indicates an expected call of SetErrorWindowForLoad
func (mr *MockOptionsMockRecorder) SetErrorWindowForLoad(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetErrorWindowForLoad", reflect.TypeOf((*MockOptions)(nil).SetErrorWindowForLoad), value)
}

// ErrorWindowForLoad mocks base method
func (m *MockOptions) ErrorWindowForLoad() time.Duration {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ErrorWindowForLoad")
	ret0, _ := ret[0].(time.Duration)
	return ret0
}

// ErrorWindowForLoad indicates an expected call of ErrorWindowForLoad
func (mr *MockOptionsMockRecorder) ErrorWindowForLoad() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ErrorWindowForLoad", reflect.TypeOf((*MockOptions)(nil).ErrorWindowForLoad))
}

// SetErrorThresholdForLoad mocks base method
func (m *MockOptions) SetErrorThresholdForLoad(value int64) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetErrorThresholdForLoad", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetErrorThresholdForLoad indicates an expected call of SetErrorThresholdForLoad
func (mr *MockOptionsMockRecorder) SetErrorThresholdForLoad(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetErrorThresholdForLoad", reflect.TypeOf((*MockOptions)(nil).SetErrorThresholdForLoad), value)
}

// ErrorThresholdForLoad mocks base method
func (m *MockOptions) ErrorThresholdForLoad() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ErrorThresholdForLoad")
	ret0, _ := ret[0].(int64)
	return ret0
}

// ErrorThresholdForLoad indicates an expected call of ErrorThresholdForLoad
func (mr *MockOptionsMockRecorder) ErrorThresholdForLoad() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ErrorThresholdForLoad", reflect.TypeOf((*MockOptions)(nil).ErrorThresholdForLoad))
}

// SetIndexOptions mocks base method
func (m *MockOptions) SetIndexOptions(value index.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIndexOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetIndexOptions indicates an expected call of SetIndexOptions
func (mr *MockOptionsMockRecorder) SetIndexOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIndexOptions", reflect.TypeOf((*MockOptions)(nil).SetIndexOptions), value)
}

// IndexOptions mocks base method
func (m *MockOptions) IndexOptions() index.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IndexOptions")
	ret0, _ := ret[0].(index.Options)
	return ret0
}

// IndexOptions indicates an expected call of IndexOptions
func (mr *MockOptionsMockRecorder) IndexOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IndexOptions", reflect.TypeOf((*MockOptions)(nil).IndexOptions))
}

// SetTruncateType mocks base method
func (m *MockOptions) SetTruncateType(value series.TruncateType) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetTruncateType", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetTruncateType indicates an expected call of SetTruncateType
func (mr *MockOptionsMockRecorder) SetTruncateType(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetTruncateType", reflect.TypeOf((*MockOptions)(nil).SetTruncateType), value)
}

// TruncateType mocks base method
func (m *MockOptions) TruncateType() series.TruncateType {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "TruncateType")
	ret0, _ := ret[0].(series.TruncateType)
	return ret0
}

// TruncateType indicates an expected call of TruncateType
func (mr *MockOptionsMockRecorder) TruncateType() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "TruncateType", reflect.TypeOf((*MockOptions)(nil).TruncateType))
}

// SetWriteTransformOptions mocks base method
func (m *MockOptions) SetWriteTransformOptions(value series.WriteTransformOptions) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteTransformOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteTransformOptions indicates an expected call of SetWriteTransformOptions
func (mr *MockOptionsMockRecorder) SetWriteTransformOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteTransformOptions", reflect.TypeOf((*MockOptions)(nil).SetWriteTransformOptions), value)
}

// WriteTransformOptions mocks base method
func (m *MockOptions) WriteTransformOptions() series.WriteTransformOptions {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteTransformOptions")
	ret0, _ := ret[0].(series.WriteTransformOptions)
	return ret0
}

// WriteTransformOptions indicates an expected call of WriteTransformOptions
func (mr *MockOptionsMockRecorder) WriteTransformOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteTransformOptions", reflect.TypeOf((*MockOptions)(nil).WriteTransformOptions))
}

// SetRepairEnabled mocks base method
func (m *MockOptions) SetRepairEnabled(b bool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetRepairEnabled", b)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetRepairEnabled indicates an expected call of SetRepairEnabled
func (mr *MockOptionsMockRecorder) SetRepairEnabled(b interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetRepairEnabled", reflect.TypeOf((*MockOptions)(nil).SetRepairEnabled), b)
}

// RepairEnabled mocks base method
func (m *MockOptions) RepairEnabled() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RepairEnabled")
	ret0, _ := ret[0].(bool)
	return ret0
}

// RepairEnabled indicates an expected call of RepairEnabled
func (mr *MockOptionsMockRecorder) RepairEnabled() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RepairEnabled", reflect.TypeOf((*MockOptions)(nil).RepairEnabled))
}

// SetRepairOptions mocks base method
func (m *MockOptions) SetRepairOptions(value repair.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetRepairOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetRepairOptions indicates an expected call of SetRepairOptions
func (mr *MockOptionsMockRecorder) SetRepairOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetRepairOptions", reflect.TypeOf((*MockOptions)(nil).SetRepairOptions), value)
}

// RepairOptions mocks base method
func (m *MockOptions) RepairOptions() repair.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RepairOptions")
	ret0, _ := ret[0].(repair.Options)
	return ret0
}

// RepairOptions indicates an expected call of RepairOptions
func (mr *MockOptionsMockRecorder) RepairOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RepairOptions", reflect.TypeOf((*MockOptions)(nil).RepairOptions))
}

// SetBootstrapProcessProvider mocks base method
func (m *MockOptions) SetBootstrapProcessProvider(value bootstrap.ProcessProvider) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBootstrapProcessProvider", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBootstrapProcessProvider indicates an expected call of SetBootstrapProcessProvider
func (mr *MockOptionsMockRecorder) SetBootstrapProcessProvider(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBootstrapProcessProvider", reflect.TypeOf((*MockOptions)(nil).SetBootstrapProcessProvider), value)
}

// BootstrapProcessProvider mocks base method
func (m *MockOptions) BootstrapProcessProvider() bootstrap.ProcessProvider {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BootstrapProcessProvider")
	ret0, _ := ret[0].(bootstrap.ProcessProvider)
	return ret0
}

// BootstrapProcessProvider indicates an expected call of BootstrapProcessProvider
func (mr *MockOptionsMockRecorder) BootstrapProcessProvider() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BootstrapProcessProvider", reflect.TypeOf((*MockOptions)(nil).BootstrapProcessProvider))
}

// SetPersistManager mocks base method
func (m *MockOptions) SetPersistManager(value persist.Manager) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetPersistManager", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetPersistManager indicates an expected call of SetPersistManager
func (mr *MockOptionsMockRecorder) SetPersistManager(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetPersistManager", reflect.TypeOf((*MockOptions)(nil).SetPersistManager), value)
}

// PersistManager mocks base method
func (m *MockOptions) PersistManager() persist.Manager {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PersistManager")
	ret0, _ := ret[0].(persist.Manager)
	return ret0
}

// PersistManager indicates an expected call of PersistManager
func (mr *MockOptionsMockRecorder) PersistManager() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PersistManager", reflect.TypeOf((*MockOptions)(nil).PersistManager))
}

// SetDatabaseBlockRetrieverManager mocks base method
func (m *MockOptions) SetDatabaseBlockRetrieverManager(value block.DatabaseBlockRetrieverManager) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetDatabaseBlockRetrieverManager", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetDatabaseBlockRetrieverManager indicates an expected call of SetDatabaseBlockRetrieverManager
func (mr *MockOptionsMockRecorder) SetDatabaseBlockRetrieverManager(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetDatabaseBlockRetrieverManager", reflect.TypeOf((*MockOptions)(nil).SetDatabaseBlockRetrieverManager), value)
}

// DatabaseBlockRetrieverManager mocks base method
func (m *MockOptions) DatabaseBlockRetrieverManager() block.DatabaseBlockRetrieverManager {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DatabaseBlockRetrieverManager")
	ret0, _ := ret[0].(block.DatabaseBlockRetrieverManager)
	return ret0
}

// DatabaseBlockRetrieverManager indicates an expected call of DatabaseBlockRetrieverManager
func (mr *MockOptionsMockRecorder) DatabaseBlockRetrieverManager() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DatabaseBlockRetrieverManager", reflect.TypeOf((*MockOptions)(nil).DatabaseBlockRetrieverManager))
}

// SetContextPool mocks base method
func (m *MockOptions) SetContextPool(value context.Pool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetContextPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetContextPool indicates an expected call of SetContextPool
func (mr *MockOptionsMockRecorder) SetContextPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetContextPool", reflect.TypeOf((*MockOptions)(nil).SetContextPool), value)
}

// ContextPool mocks base method
func (m *MockOptions) ContextPool() context.Pool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ContextPool")
	ret0, _ := ret[0].(context.Pool)
	return ret0
}

// ContextPool indicates an expected call of ContextPool
func (mr *MockOptionsMockRecorder) ContextPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ContextPool", reflect.TypeOf((*MockOptions)(nil).ContextPool))
}

// SetSeriesCachePolicy mocks base method
func (m *MockOptions) SetSeriesCachePolicy(value series.CachePolicy) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetSeriesCachePolicy", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetSeriesCachePolicy indicates an expected call of SetSeriesCachePolicy
func (mr *MockOptionsMockRecorder) SetSeriesCachePolicy(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSeriesCachePolicy", reflect.TypeOf((*MockOptions)(nil).SetSeriesCachePolicy), value)
}

// SeriesCachePolicy mocks base method
func (m *MockOptions) SeriesCachePolicy() series.CachePolicy {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SeriesCachePolicy")
	ret0, _ := ret[0].(series.CachePolicy)
	return ret0
}

// SeriesCachePolicy indicates an expected call of SeriesCachePolicy
func (mr *MockOptionsMockRecorder) SeriesCachePolicy() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SeriesCachePolicy", reflect.TypeOf((*MockOptions)(nil).SeriesCachePolicy))
}

// SetSeriesOptions mocks base method
func (m *MockOptions) SetSeriesOptions(value series.Options) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetSeriesOptions", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetSeriesOptions indicates an expected call of SetSeriesOptions
func (mr *MockOptionsMockRecorder) SetSeriesOptions(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSeriesOptions", reflect.TypeOf((*MockOptions)(nil).SetSeriesOptions), value)
}

// SeriesOptions mocks base method
func (m *MockOptions) SeriesOptions() series.Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SeriesOptions")
	ret0, _ := ret[0].(series.Options)
	return ret0
}

// SeriesOptions indicates an expected call of SeriesOptions
func (mr *MockOptionsMockRecorder) SeriesOptions() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SeriesOptions", reflect.TypeOf((*MockOptions)(nil).SeriesOptions))
}

// SetDatabaseSeriesPool mocks base method
func (m *MockOptions) SetDatabaseSeriesPool(value series.DatabaseSeriesPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetDatabaseSeriesPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetDatabaseSeriesPool indicates an expected call of SetDatabaseSeriesPool
func (mr *MockOptionsMockRecorder) SetDatabaseSeriesPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetDatabaseSeriesPool", reflect.TypeOf((*MockOptions)(nil).SetDatabaseSeriesPool), value)
}

// DatabaseSeriesPool mocks base method
func (m *MockOptions) DatabaseSeriesPool() series.DatabaseSeriesPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "DatabaseSeriesPool")
	ret0, _ := ret[0].(series.DatabaseSeriesPool)
	return ret0
}

// DatabaseSeriesPool indicates an expected call of DatabaseSeriesPool
func (mr *MockOptionsMockRecorder) DatabaseSeriesPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DatabaseSeriesPool", reflect.TypeOf((*MockOptions)(nil).DatabaseSeriesPool))
}

// SetBytesPool mocks base method
func (m *MockOptions) SetBytesPool(value pool.CheckedBytesPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBytesPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBytesPool indicates an expected call of SetBytesPool
func (mr *MockOptionsMockRecorder) SetBytesPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBytesPool", reflect.TypeOf((*MockOptions)(nil).SetBytesPool), value)
}

// BytesPool mocks base method
func (m *MockOptions) BytesPool() pool.CheckedBytesPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BytesPool")
	ret0, _ := ret[0].(pool.CheckedBytesPool)
	return ret0
}

// BytesPool indicates an expected call of BytesPool
func (mr *MockOptionsMockRecorder) BytesPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BytesPool", reflect.TypeOf((*MockOptions)(nil).BytesPool))
}

// SetEncoderPool mocks base method
func (m *MockOptions) SetEncoderPool(value encoding.EncoderPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetEncoderPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetEncoderPool indicates an expected call of SetEncoderPool
func (mr *MockOptionsMockRecorder) SetEncoderPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetEncoderPool", reflect.TypeOf((*MockOptions)(nil).SetEncoderPool), value)
}

// EncoderPool mocks base method
func (m *MockOptions) EncoderPool() encoding.EncoderPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "EncoderPool")
	ret0, _ := ret[0].(encoding.EncoderPool)
	return ret0
}

// EncoderPool indicates an expected call of EncoderPool
func (mr *MockOptionsMockRecorder) EncoderPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "EncoderPool", reflect.TypeOf((*MockOptions)(nil).EncoderPool))
}

// SetSegmentReaderPool mocks base method
func (m *MockOptions) SetSegmentReaderPool(value xio.SegmentReaderPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetSegmentReaderPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetSegmentReaderPool indicates an expected call of SetSegmentReaderPool
func (mr *MockOptionsMockRecorder) SetSegmentReaderPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSegmentReaderPool", reflect.TypeOf((*MockOptions)(nil).SetSegmentReaderPool), value)
}

// SegmentReaderPool mocks base method
func (m *MockOptions) SegmentReaderPool() xio.SegmentReaderPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SegmentReaderPool")
	ret0, _ := ret[0].(xio.SegmentReaderPool)
	return ret0
}

// SegmentReaderPool indicates an expected call of SegmentReaderPool
func (mr *MockOptionsMockRecorder) SegmentReaderPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SegmentReaderPool", reflect.TypeOf((*MockOptions)(nil).SegmentReaderPool))
}

// SetReaderIteratorPool mocks base method
func (m *MockOptions) SetReaderIteratorPool(value encoding.ReaderIteratorPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetReaderIteratorPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetReaderIteratorPool indicates an expected call of SetReaderIteratorPool
func (mr *MockOptionsMockRecorder) SetReaderIteratorPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetReaderIteratorPool", reflect.TypeOf((*MockOptions)(nil).SetReaderIteratorPool), value)
}

// ReaderIteratorPool mocks base method
func (m *MockOptions) ReaderIteratorPool() encoding.ReaderIteratorPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ReaderIteratorPool")
	ret0, _ := ret[0].(encoding.ReaderIteratorPool)
	return ret0
}

// ReaderIteratorPool indicates an expected call of ReaderIteratorPool
func (mr *MockOptionsMockRecorder) ReaderIteratorPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ReaderIteratorPool", reflect.TypeOf((*MockOptions)(nil).ReaderIteratorPool))
}

// SetMultiReaderIteratorPool mocks base method
func (m *MockOptions) SetMultiReaderIteratorPool(value encoding.MultiReaderIteratorPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetMultiReaderIteratorPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetMultiReaderIteratorPool indicates an expected call of SetMultiReaderIteratorPool
func (mr *MockOptionsMockRecorder) SetMultiReaderIteratorPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetMultiReaderIteratorPool", reflect.TypeOf((*MockOptions)(nil).SetMultiReaderIteratorPool), value)
}

// MultiReaderIteratorPool mocks base method
func (m *MockOptions) MultiReaderIteratorPool() encoding.MultiReaderIteratorPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MultiReaderIteratorPool")
	ret0, _ := ret[0].(encoding.MultiReaderIteratorPool)
	return ret0
}

// MultiReaderIteratorPool indicates an expected call of MultiReaderIteratorPool
func (mr *MockOptionsMockRecorder) MultiReaderIteratorPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MultiReaderIteratorPool", reflect.TypeOf((*MockOptions)(nil).MultiReaderIteratorPool))
}

// SetIdentifierPool mocks base method
func (m *MockOptions) SetIdentifierPool(value ident.Pool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetIdentifierPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetIdentifierPool indicates an expected call of SetIdentifierPool
func (mr *MockOptionsMockRecorder) SetIdentifierPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetIdentifierPool", reflect.TypeOf((*MockOptions)(nil).SetIdentifierPool), value)
}

// IdentifierPool mocks base method
func (m *MockOptions) IdentifierPool() ident.Pool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IdentifierPool")
	ret0, _ := ret[0].(ident.Pool)
	return ret0
}

// IdentifierPool indicates an expected call of IdentifierPool
func (mr *MockOptionsMockRecorder) IdentifierPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IdentifierPool", reflect.TypeOf((*MockOptions)(nil).IdentifierPool))
}

// SetFetchBlockMetadataResultsPool mocks base method
func (m *MockOptions) SetFetchBlockMetadataResultsPool(value block.FetchBlockMetadataResultsPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchBlockMetadataResultsPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetFetchBlockMetadataResultsPool indicates an expected call of SetFetchBlockMetadataResultsPool
func (mr *MockOptionsMockRecorder) SetFetchBlockMetadataResultsPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchBlockMetadataResultsPool", reflect.TypeOf((*MockOptions)(nil).SetFetchBlockMetadataResultsPool), value)
}

// FetchBlockMetadataResultsPool mocks base method
func (m *MockOptions) FetchBlockMetadataResultsPool() block.FetchBlockMetadataResultsPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlockMetadataResultsPool")
	ret0, _ := ret[0].(block.FetchBlockMetadataResultsPool)
	return ret0
}

// FetchBlockMetadataResultsPool indicates an expected call of FetchBlockMetadataResultsPool
func (mr *MockOptionsMockRecorder) FetchBlockMetadataResultsPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlockMetadataResultsPool", reflect.TypeOf((*MockOptions)(nil).FetchBlockMetadataResultsPool))
}

// SetFetchBlocksMetadataResultsPool mocks base method
func (m *MockOptions) SetFetchBlocksMetadataResultsPool(value block.FetchBlocksMetadataResultsPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetFetchBlocksMetadataResultsPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetFetchBlocksMetadataResultsPool indicates an expected call of SetFetchBlocksMetadataResultsPool
func (mr *MockOptionsMockRecorder) SetFetchBlocksMetadataResultsPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetFetchBlocksMetadataResultsPool", reflect.TypeOf((*MockOptions)(nil).SetFetchBlocksMetadataResultsPool), value)
}

// FetchBlocksMetadataResultsPool mocks base method
func (m *MockOptions) FetchBlocksMetadataResultsPool() block.FetchBlocksMetadataResultsPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "FetchBlocksMetadataResultsPool")
	ret0, _ := ret[0].(block.FetchBlocksMetadataResultsPool)
	return ret0
}

// FetchBlocksMetadataResultsPool indicates an expected call of FetchBlocksMetadataResultsPool
func (mr *MockOptionsMockRecorder) FetchBlocksMetadataResultsPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "FetchBlocksMetadataResultsPool", reflect.TypeOf((*MockOptions)(nil).FetchBlocksMetadataResultsPool))
}

// SetQueryIDsWorkerPool mocks base method
func (m *MockOptions) SetQueryIDsWorkerPool(value sync0.WorkerPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetQueryIDsWorkerPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetQueryIDsWorkerPool indicates an expected call of SetQueryIDsWorkerPool
func (mr *MockOptionsMockRecorder) SetQueryIDsWorkerPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetQueryIDsWorkerPool", reflect.TypeOf((*MockOptions)(nil).SetQueryIDsWorkerPool), value)
}

// QueryIDsWorkerPool mocks base method
func (m *MockOptions) QueryIDsWorkerPool() sync0.WorkerPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "QueryIDsWorkerPool")
	ret0, _ := ret[0].(sync0.WorkerPool)
	return ret0
}

// QueryIDsWorkerPool indicates an expected call of QueryIDsWorkerPool
func (mr *MockOptionsMockRecorder) QueryIDsWorkerPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "QueryIDsWorkerPool", reflect.TypeOf((*MockOptions)(nil).QueryIDsWorkerPool))
}

// SetWriteBatchPool mocks base method
func (m *MockOptions) SetWriteBatchPool(value *ts.WriteBatchPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetWriteBatchPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetWriteBatchPool indicates an expected call of SetWriteBatchPool
func (mr *MockOptionsMockRecorder) SetWriteBatchPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetWriteBatchPool", reflect.TypeOf((*MockOptions)(nil).SetWriteBatchPool), value)
}

// WriteBatchPool mocks base method
func (m *MockOptions) WriteBatchPool() *ts.WriteBatchPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "WriteBatchPool")
	ret0, _ := ret[0].(*ts.WriteBatchPool)
	return ret0
}

// WriteBatchPool indicates an expected call of WriteBatchPool
func (mr *MockOptionsMockRecorder) WriteBatchPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WriteBatchPool", reflect.TypeOf((*MockOptions)(nil).WriteBatchPool))
}

// SetBufferBucketPool mocks base method
func (m *MockOptions) SetBufferBucketPool(value *series.BufferBucketPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBufferBucketPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBufferBucketPool indicates an expected call of SetBufferBucketPool
func (mr *MockOptionsMockRecorder) SetBufferBucketPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBufferBucketPool", reflect.TypeOf((*MockOptions)(nil).SetBufferBucketPool), value)
}

// BufferBucketPool mocks base method
func (m *MockOptions) BufferBucketPool() *series.BufferBucketPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BufferBucketPool")
	ret0, _ := ret[0].(*series.BufferBucketPool)
	return ret0
}

// BufferBucketPool indicates an expected call of BufferBucketPool
func (mr *MockOptionsMockRecorder) BufferBucketPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BufferBucketPool", reflect.TypeOf((*MockOptions)(nil).BufferBucketPool))
}

// SetBufferBucketVersionsPool mocks base method
func (m *MockOptions) SetBufferBucketVersionsPool(value *series.BufferBucketVersionsPool) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBufferBucketVersionsPool", value)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBufferBucketVersionsPool indicates an expected call of SetBufferBucketVersionsPool
func (mr *MockOptionsMockRecorder) SetBufferBucketVersionsPool(value interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBufferBucketVersionsPool", reflect.TypeOf((*MockOptions)(nil).SetBufferBucketVersionsPool), value)
}

// BufferBucketVersionsPool mocks base method
func (m *MockOptions) BufferBucketVersionsPool() *series.BufferBucketVersionsPool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BufferBucketVersionsPool")
	ret0, _ := ret[0].(*series.BufferBucketVersionsPool)
	return ret0
}

// BufferBucketVersionsPool indicates an expected call of BufferBucketVersionsPool
func (mr *MockOptionsMockRecorder) BufferBucketVersionsPool() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BufferBucketVersionsPool", reflect.TypeOf((*MockOptions)(nil).BufferBucketVersionsPool))
}

// SetSchemaRegistry mocks base method
func (m *MockOptions) SetSchemaRegistry(registry namespace.SchemaRegistry) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetSchemaRegistry", registry)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetSchemaRegistry indicates an expected call of SetSchemaRegistry
func (mr *MockOptionsMockRecorder) SetSchemaRegistry(registry interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetSchemaRegistry", reflect.TypeOf((*MockOptions)(nil).SetSchemaRegistry), registry)
}

// SchemaRegistry mocks base method
func (m *MockOptions) SchemaRegistry() namespace.SchemaRegistry {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SchemaRegistry")
	ret0, _ := ret[0].(namespace.SchemaRegistry)
	return ret0
}

// SchemaRegistry indicates an expected call of SchemaRegistry
func (mr *MockOptionsMockRecorder) SchemaRegistry() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SchemaRegistry", reflect.TypeOf((*MockOptions)(nil).SchemaRegistry))
}

// SetBlockLeaseManager mocks base method
func (m *MockOptions) SetBlockLeaseManager(leaseMgr block.LeaseManager) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetBlockLeaseManager", leaseMgr)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetBlockLeaseManager indicates an expected call of SetBlockLeaseManager
func (mr *MockOptionsMockRecorder) SetBlockLeaseManager(leaseMgr interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetBlockLeaseManager", reflect.TypeOf((*MockOptions)(nil).SetBlockLeaseManager), leaseMgr)
}

// BlockLeaseManager mocks base method
func (m *MockOptions) BlockLeaseManager() block.LeaseManager {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "BlockLeaseManager")
	ret0, _ := ret[0].(block.LeaseManager)
	return ret0
}

// BlockLeaseManager indicates an expected call of BlockLeaseManager
func (mr *MockOptionsMockRecorder) BlockLeaseManager() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "BlockLeaseManager", reflect.TypeOf((*MockOptions)(nil).BlockLeaseManager))
}

// SetMemoryTracker mocks base method
func (m *MockOptions) SetMemoryTracker(memTracker MemoryTracker) Options {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "SetMemoryTracker", memTracker)
	ret0, _ := ret[0].(Options)
	return ret0
}

// SetMemoryTracker indicates an expected call of SetMemoryTracker
func (mr *MockOptionsMockRecorder) SetMemoryTracker(memTracker interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SetMemoryTracker", reflect.TypeOf((*MockOptions)(nil).SetMemoryTracker), memTracker)
}

// MemoryTracker mocks base method
func (m *MockOptions) MemoryTracker() MemoryTracker {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "MemoryTracker")
	ret0, _ := ret[0].(MemoryTracker)
	return ret0
}

// MemoryTracker indicates an expected call of MemoryTracker
func (mr *MockOptionsMockRecorder) MemoryTracker() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MemoryTracker", reflect.TypeOf((*MockOptions)(nil).MemoryTracker))
}

// MockMemoryTracker is a mock of MemoryTracker interface
type MockMemoryTracker struct {
	ctrl     *gomock.Controller
	recorder *MockMemoryTrackerMockRecorder
}

// MockMemoryTrackerMockRecorder is the mock recorder for MockMemoryTracker
type MockMemoryTrackerMockRecorder struct {
	mock *MockMemoryTracker
}

// NewMockMemoryTracker creates a new mock instance
func NewMockMemoryTracker(ctrl *gomock.Controller) *MockMemoryTracker {
	mock := &MockMemoryTracker{ctrl: ctrl}
	mock.recorder = &MockMemoryTrackerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use
func (m *MockMemoryTracker) EXPECT() *MockMemoryTrackerMockRecorder {
	return m.recorder
}

// IncNumLoadedBytes mocks base method
func (m *MockMemoryTracker) IncNumLoadedBytes(x int64) bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "IncNumLoadedBytes", x)
	ret0, _ := ret[0].(bool)
	return ret0
}

// IncNumLoadedBytes indicates an expected call of IncNumLoadedBytes
func (mr *MockMemoryTrackerMockRecorder) IncNumLoadedBytes(x interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "IncNumLoadedBytes", reflect.TypeOf((*MockMemoryTracker)(nil).IncNumLoadedBytes), x)
}

// NumLoadedBytes mocks base method
func (m *MockMemoryTracker) NumLoadedBytes() int64 {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "NumLoadedBytes")
	ret0, _ := ret[0].(int64)
	return ret0
}

// NumLoadedBytes indicates an expected call of NumLoadedBytes
func (mr *MockMemoryTrackerMockRecorder) NumLoadedBytes() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "NumLoadedBytes", reflect.TypeOf((*MockMemoryTracker)(nil).NumLoadedBytes))
}

// MarkLoadedAsPending mocks base method
func (m *MockMemoryTracker) MarkLoadedAsPending() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "MarkLoadedAsPending")
}

// MarkLoadedAsPending indicates an expected call of MarkLoadedAsPending
func (mr *MockMemoryTrackerMockRecorder) MarkLoadedAsPending() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "MarkLoadedAsPending", reflect.TypeOf((*MockMemoryTracker)(nil).MarkLoadedAsPending))
}

// DecPendingLoadedBytes mocks base method
func (m *MockMemoryTracker) DecPendingLoadedBytes() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "DecPendingLoadedBytes")
}

// DecPendingLoadedBytes indicates an expected call of DecPendingLoadedBytes
func (mr *MockMemoryTrackerMockRecorder) DecPendingLoadedBytes() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "DecPendingLoadedBytes", reflect.TypeOf((*MockMemoryTracker)(nil).DecPendingLoadedBytes))
}

// WaitForDec mocks base method
func (m *MockMemoryTracker) WaitForDec() {
	m.ctrl.T.Helper()
	m.ctrl.Call(m, "WaitForDec")
}

// WaitForDec indicates an expected call of WaitForDec
func (mr *MockMemoryTrackerMockRecorder) WaitForDec() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "WaitForDec", reflect.TypeOf((*MockMemoryTracker)(nil).WaitForDec))
}
