// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/m3db/m3/src/m3em/generated/proto/m3em/operator.proto

// Copyright (c) 2018 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/*
	Package m3em is a generated protocol buffer package.

	It is generated from these files:
		github.com/m3db/m3/src/m3em/generated/proto/m3em/operator.proto

	It has these top-level messages:
		SetupRequest
		SetupResponse
		StartRequest
		StartResponse
		StopRequest
		StopResponse
		TeardownRequest
		TeardownResponse
		PullFileRequest
		PullFileResponse
		PushFileRequest
		PushFileResponse
		DataChunk
*/
package m3em

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type PullFileType int32

const (
	PullFileType_PULL_FILE_TYPE_UNKNOWN        PullFileType = 0
	PullFileType_PULL_FILE_TYPE_SERVICE_STDOUT PullFileType = 1
	PullFileType_PULL_FILE_TYPE_SERVICE_STDERR PullFileType = 2
)

var PullFileType_name = map[int32]string{
	0: "PULL_FILE_TYPE_UNKNOWN",
	1: "PULL_FILE_TYPE_SERVICE_STDOUT",
	2: "PULL_FILE_TYPE_SERVICE_STDERR",
}
var PullFileType_value = map[string]int32{
	"PULL_FILE_TYPE_UNKNOWN":        0,
	"PULL_FILE_TYPE_SERVICE_STDOUT": 1,
	"PULL_FILE_TYPE_SERVICE_STDERR": 2,
}

func (x PullFileType) String() string {
	return proto.EnumName(PullFileType_name, int32(x))
}
func (PullFileType) EnumDescriptor() ([]byte, []int) { return fileDescriptorOperator, []int{0} }

type PullFileContentType int32

const (
	PullFileContentType_PULL_FILE_CONTENT_TYPE_UNKNOWN PullFileContentType = 0
	PullFileContentType_PULL_FILE_CONTENT_TYPE_LAST    PullFileContentType = 1
	PullFileContentType_PULL_FILE_CONTENT_TYPE_FULL    PullFileContentType = 2
)

var PullFileContentType_name = map[int32]string{
	0: "PULL_FILE_CONTENT_TYPE_UNKNOWN",
	1: "PULL_FILE_CONTENT_TYPE_LAST",
	2: "PULL_FILE_CONTENT_TYPE_FULL",
}
var PullFileContentType_value = map[string]int32{
	"PULL_FILE_CONTENT_TYPE_UNKNOWN": 0,
	"PULL_FILE_CONTENT_TYPE_LAST":    1,
	"PULL_FILE_CONTENT_TYPE_FULL":    2,
}

func (x PullFileContentType) String() string {
	return proto.EnumName(PullFileContentType_name, int32(x))
}
func (PullFileContentType) EnumDescriptor() ([]byte, []int) { return fileDescriptorOperator, []int{1} }

type PushFileType int32

const (
	PushFileType_PUSH_FILE_TYPE_UNKNOWN        PushFileType = 0
	PushFileType_PUSH_FILE_TYPE_SERVICE_BINARY PushFileType = 1
	PushFileType_PUSH_FILE_TYPE_SERVICE_CONFIG PushFileType = 2
	PushFileType_PUSH_FILE_TYPE_DATA_FILE      PushFileType = 3
)

var PushFileType_name = map[int32]string{
	0: "PUSH_FILE_TYPE_UNKNOWN",
	1: "PUSH_FILE_TYPE_SERVICE_BINARY",
	2: "PUSH_FILE_TYPE_SERVICE_CONFIG",
	3: "PUSH_FILE_TYPE_DATA_FILE",
}
var PushFileType_value = map[string]int32{
	"PUSH_FILE_TYPE_UNKNOWN":        0,
	"PUSH_FILE_TYPE_SERVICE_BINARY": 1,
	"PUSH_FILE_TYPE_SERVICE_CONFIG": 2,
	"PUSH_FILE_TYPE_DATA_FILE":      3,
}

func (x PushFileType) String() string {
	return proto.EnumName(PushFileType_name, int32(x))
}
func (PushFileType) EnumDescriptor() ([]byte, []int) { return fileDescriptorOperator, []int{2} }

type SetupRequest struct {
	SessionToken           string `protobuf:"bytes,1,opt,name=session_token,json=sessionToken,proto3" json:"session_token,omitempty"`
	OperatorUuid           string `protobuf:"bytes,2,opt,name=operator_uuid,json=operatorUuid,proto3" json:"operator_uuid,omitempty"`
	Force                  bool   `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	HeartbeatEnabled       bool   `protobuf:"varint,4,opt,name=heartbeat_enabled,json=heartbeatEnabled,proto3" json:"heartbeat_enabled,omitempty"`
	HeartbeatEndpoint      string `protobuf:"bytes,5,opt,name=heartbeat_endpoint,json=heartbeatEndpoint,proto3" json:"heartbeat_endpoint,omitempty"`
	HeartbeatFrequencySecs uint32 `protobuf:"varint,6,opt,name=heartbeat_frequency_secs,json=heartbeatFrequencySecs,proto3" json:"heartbeat_frequency_secs,omitempty"`
}

func (m *SetupRequest) Reset()                    { *m = SetupRequest{} }
func (m *SetupRequest) String() string            { return proto.CompactTextString(m) }
func (*SetupRequest) ProtoMessage()               {}
func (*SetupRequest) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{0} }

func (m *SetupRequest) GetSessionToken() string {
	if m != nil {
		return m.SessionToken
	}
	return ""
}

func (m *SetupRequest) GetOperatorUuid() string {
	if m != nil {
		return m.OperatorUuid
	}
	return ""
}

func (m *SetupRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *SetupRequest) GetHeartbeatEnabled() bool {
	if m != nil {
		return m.HeartbeatEnabled
	}
	return false
}

func (m *SetupRequest) GetHeartbeatEndpoint() string {
	if m != nil {
		return m.HeartbeatEndpoint
	}
	return ""
}

func (m *SetupRequest) GetHeartbeatFrequencySecs() uint32 {
	if m != nil {
		return m.HeartbeatFrequencySecs
	}
	return 0
}

type SetupResponse struct {
}

func (m *SetupResponse) Reset()                    { *m = SetupResponse{} }
func (m *SetupResponse) String() string            { return proto.CompactTextString(m) }
func (*SetupResponse) ProtoMessage()               {}
func (*SetupResponse) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{1} }

type StartRequest struct {
}

func (m *StartRequest) Reset()                    { *m = StartRequest{} }
func (m *StartRequest) String() string            { return proto.CompactTextString(m) }
func (*StartRequest) ProtoMessage()               {}
func (*StartRequest) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{2} }

type StartResponse struct {
}

func (m *StartResponse) Reset()                    { *m = StartResponse{} }
func (m *StartResponse) String() string            { return proto.CompactTextString(m) }
func (*StartResponse) ProtoMessage()               {}
func (*StartResponse) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{3} }

type StopRequest struct {
}

func (m *StopRequest) Reset()                    { *m = StopRequest{} }
func (m *StopRequest) String() string            { return proto.CompactTextString(m) }
func (*StopRequest) ProtoMessage()               {}
func (*StopRequest) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{4} }

type StopResponse struct {
}

func (m *StopResponse) Reset()                    { *m = StopResponse{} }
func (m *StopResponse) String() string            { return proto.CompactTextString(m) }
func (*StopResponse) ProtoMessage()               {}
func (*StopResponse) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{5} }

type TeardownRequest struct {
}

func (m *TeardownRequest) Reset()                    { *m = TeardownRequest{} }
func (m *TeardownRequest) String() string            { return proto.CompactTextString(m) }
func (*TeardownRequest) ProtoMessage()               {}
func (*TeardownRequest) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{6} }

type TeardownResponse struct {
}

func (m *TeardownResponse) Reset()                    { *m = TeardownResponse{} }
func (m *TeardownResponse) String() string            { return proto.CompactTextString(m) }
func (*TeardownResponse) ProtoMessage()               {}
func (*TeardownResponse) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{7} }

// PullFileRequest(s) are used to transfer files from remote agents to the master.
type PullFileRequest struct {
	FileType  PullFileType `protobuf:"varint,1,opt,name=file_type,json=fileType,proto3,enum=m3em.PullFileType" json:"file_type,omitempty"`
	ChunkSize int64        `protobuf:"varint,2,opt,name=chunk_size,json=chunkSize,proto3" json:"chunk_size,omitempty"`
	MaxSize   int64        `protobuf:"varint,3,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
}

func (m *PullFileRequest) Reset()                    { *m = PullFileRequest{} }
func (m *PullFileRequest) String() string            { return proto.CompactTextString(m) }
func (*PullFileRequest) ProtoMessage()               {}
func (*PullFileRequest) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{8} }

func (m *PullFileRequest) GetFileType() PullFileType {
	if m != nil {
		return m.FileType
	}
	return PullFileType_PULL_FILE_TYPE_UNKNOWN
}

func (m *PullFileRequest) GetChunkSize() int64 {
	if m != nil {
		return m.ChunkSize
	}
	return 0
}

func (m *PullFileRequest) GetMaxSize() int64 {
	if m != nil {
		return m.MaxSize
	}
	return 0
}

type PullFileResponse struct {
	Data      *DataChunk `protobuf:"bytes,1,opt,name=data" json:"data,omitempty"`
	Truncated bool       `protobuf:"varint,2,opt,name=truncated,proto3" json:"truncated,omitempty"`
}

func (m *PullFileResponse) Reset()                    { *m = PullFileResponse{} }
func (m *PullFileResponse) String() string            { return proto.CompactTextString(m) }
func (*PullFileResponse) ProtoMessage()               {}
func (*PullFileResponse) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{9} }

func (m *PullFileResponse) GetData() *DataChunk {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *PullFileResponse) GetTruncated() bool {
	if m != nil {
		return m.Truncated
	}
	return false
}

// PushFileRequest(s) are used to transfer files from the master to remote agents.
type PushFileRequest struct {
	Type        PushFileType `protobuf:"varint,1,opt,name=type,proto3,enum=m3em.PushFileType" json:"type,omitempty"`
	Overwrite   bool         `protobuf:"varint,2,opt,name=overwrite,proto3" json:"overwrite,omitempty"`
	Data        *DataChunk   `protobuf:"bytes,3,opt,name=data" json:"data,omitempty"`
	TargetPaths []string     `protobuf:"bytes,4,rep,name=target_paths,json=targetPaths" json:"target_paths,omitempty"`
}

func (m *PushFileRequest) Reset()                    { *m = PushFileRequest{} }
func (m *PushFileRequest) String() string            { return proto.CompactTextString(m) }
func (*PushFileRequest) ProtoMessage()               {}
func (*PushFileRequest) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{10} }

func (m *PushFileRequest) GetType() PushFileType {
	if m != nil {
		return m.Type
	}
	return PushFileType_PUSH_FILE_TYPE_UNKNOWN
}

func (m *PushFileRequest) GetOverwrite() bool {
	if m != nil {
		return m.Overwrite
	}
	return false
}

func (m *PushFileRequest) GetData() *DataChunk {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *PushFileRequest) GetTargetPaths() []string {
	if m != nil {
		return m.TargetPaths
	}
	return nil
}

type PushFileResponse struct {
	FileChecksum   uint32 `protobuf:"varint,1,opt,name=file_checksum,json=fileChecksum,proto3" json:"file_checksum,omitempty"`
	NumChunksRecvd int32  `protobuf:"varint,2,opt,name=num_chunks_recvd,json=numChunksRecvd,proto3" json:"num_chunks_recvd,omitempty"`
}

func (m *PushFileResponse) Reset()                    { *m = PushFileResponse{} }
func (m *PushFileResponse) String() string            { return proto.CompactTextString(m) }
func (*PushFileResponse) ProtoMessage()               {}
func (*PushFileResponse) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{11} }

func (m *PushFileResponse) GetFileChecksum() uint32 {
	if m != nil {
		return m.FileChecksum
	}
	return 0
}

func (m *PushFileResponse) GetNumChunksRecvd() int32 {
	if m != nil {
		return m.NumChunksRecvd
	}
	return 0
}

type DataChunk struct {
	Idx   int32  `protobuf:"varint,1,opt,name=idx,proto3" json:"idx,omitempty"`
	Bytes []byte `protobuf:"bytes,2,opt,name=bytes,proto3" json:"bytes,omitempty"`
}

func (m *DataChunk) Reset()                    { *m = DataChunk{} }
func (m *DataChunk) String() string            { return proto.CompactTextString(m) }
func (*DataChunk) ProtoMessage()               {}
func (*DataChunk) Descriptor() ([]byte, []int) { return fileDescriptorOperator, []int{12} }

func (m *DataChunk) GetIdx() int32 {
	if m != nil {
		return m.Idx
	}
	return 0
}

func (m *DataChunk) GetBytes() []byte {
	if m != nil {
		return m.Bytes
	}
	return nil
}

func init() {
	proto.RegisterType((*SetupRequest)(nil), "m3em.SetupRequest")
	proto.RegisterType((*SetupResponse)(nil), "m3em.SetupResponse")
	proto.RegisterType((*StartRequest)(nil), "m3em.StartRequest")
	proto.RegisterType((*StartResponse)(nil), "m3em.StartResponse")
	proto.RegisterType((*StopRequest)(nil), "m3em.StopRequest")
	proto.RegisterType((*StopResponse)(nil), "m3em.StopResponse")
	proto.RegisterType((*TeardownRequest)(nil), "m3em.TeardownRequest")
	proto.RegisterType((*TeardownResponse)(nil), "m3em.TeardownResponse")
	proto.RegisterType((*PullFileRequest)(nil), "m3em.PullFileRequest")
	proto.RegisterType((*PullFileResponse)(nil), "m3em.PullFileResponse")
	proto.RegisterType((*PushFileRequest)(nil), "m3em.PushFileRequest")
	proto.RegisterType((*PushFileResponse)(nil), "m3em.PushFileResponse")
	proto.RegisterType((*DataChunk)(nil), "m3em.DataChunk")
	proto.RegisterEnum("m3em.PullFileType", PullFileType_name, PullFileType_value)
	proto.RegisterEnum("m3em.PullFileContentType", PullFileContentType_name, PullFileContentType_value)
	proto.RegisterEnum("m3em.PushFileType", PushFileType_name, PushFileType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Operator service

type OperatorClient interface {
	Setup(ctx context.Context, in *SetupRequest, opts ...grpc.CallOption) (*SetupResponse, error)
	Start(ctx context.Context, in *StartRequest, opts ...grpc.CallOption) (*StartResponse, error)
	Stop(ctx context.Context, in *StopRequest, opts ...grpc.CallOption) (*StopResponse, error)
	Teardown(ctx context.Context, in *TeardownRequest, opts ...grpc.CallOption) (*TeardownResponse, error)
	PullFile(ctx context.Context, in *PullFileRequest, opts ...grpc.CallOption) (Operator_PullFileClient, error)
	PushFile(ctx context.Context, opts ...grpc.CallOption) (Operator_PushFileClient, error)
}

type operatorClient struct {
	cc *grpc.ClientConn
}

func NewOperatorClient(cc *grpc.ClientConn) OperatorClient {
	return &operatorClient{cc}
}

func (c *operatorClient) Setup(ctx context.Context, in *SetupRequest, opts ...grpc.CallOption) (*SetupResponse, error) {
	out := new(SetupResponse)
	err := grpc.Invoke(ctx, "/m3em.Operator/Setup", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operatorClient) Start(ctx context.Context, in *StartRequest, opts ...grpc.CallOption) (*StartResponse, error) {
	out := new(StartResponse)
	err := grpc.Invoke(ctx, "/m3em.Operator/Start", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operatorClient) Stop(ctx context.Context, in *StopRequest, opts ...grpc.CallOption) (*StopResponse, error) {
	out := new(StopResponse)
	err := grpc.Invoke(ctx, "/m3em.Operator/Stop", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operatorClient) Teardown(ctx context.Context, in *TeardownRequest, opts ...grpc.CallOption) (*TeardownResponse, error) {
	out := new(TeardownResponse)
	err := grpc.Invoke(ctx, "/m3em.Operator/Teardown", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operatorClient) PullFile(ctx context.Context, in *PullFileRequest, opts ...grpc.CallOption) (Operator_PullFileClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Operator_serviceDesc.Streams[0], c.cc, "/m3em.Operator/PullFile", opts...)
	if err != nil {
		return nil, err
	}
	x := &operatorPullFileClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Operator_PullFileClient interface {
	Recv() (*PullFileResponse, error)
	grpc.ClientStream
}

type operatorPullFileClient struct {
	grpc.ClientStream
}

func (x *operatorPullFileClient) Recv() (*PullFileResponse, error) {
	m := new(PullFileResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *operatorClient) PushFile(ctx context.Context, opts ...grpc.CallOption) (Operator_PushFileClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Operator_serviceDesc.Streams[1], c.cc, "/m3em.Operator/PushFile", opts...)
	if err != nil {
		return nil, err
	}
	x := &operatorPushFileClient{stream}
	return x, nil
}

type Operator_PushFileClient interface {
	Send(*PushFileRequest) error
	CloseAndRecv() (*PushFileResponse, error)
	grpc.ClientStream
}

type operatorPushFileClient struct {
	grpc.ClientStream
}

func (x *operatorPushFileClient) Send(m *PushFileRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *operatorPushFileClient) CloseAndRecv() (*PushFileResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(PushFileResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for Operator service

type OperatorServer interface {
	Setup(context.Context, *SetupRequest) (*SetupResponse, error)
	Start(context.Context, *StartRequest) (*StartResponse, error)
	Stop(context.Context, *StopRequest) (*StopResponse, error)
	Teardown(context.Context, *TeardownRequest) (*TeardownResponse, error)
	PullFile(*PullFileRequest, Operator_PullFileServer) error
	PushFile(Operator_PushFileServer) error
}

func RegisterOperatorServer(s *grpc.Server, srv OperatorServer) {
	s.RegisterService(&_Operator_serviceDesc, srv)
}

func _Operator_Setup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperatorServer).Setup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/m3em.Operator/Setup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperatorServer).Setup(ctx, req.(*SetupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Operator_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperatorServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/m3em.Operator/Start",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperatorServer).Start(ctx, req.(*StartRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Operator_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperatorServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/m3em.Operator/Stop",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperatorServer).Stop(ctx, req.(*StopRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Operator_Teardown_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TeardownRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperatorServer).Teardown(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/m3em.Operator/Teardown",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperatorServer).Teardown(ctx, req.(*TeardownRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Operator_PullFile_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PullFileRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(OperatorServer).PullFile(m, &operatorPullFileServer{stream})
}

type Operator_PullFileServer interface {
	Send(*PullFileResponse) error
	grpc.ServerStream
}

type operatorPullFileServer struct {
	grpc.ServerStream
}

func (x *operatorPullFileServer) Send(m *PullFileResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Operator_PushFile_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(OperatorServer).PushFile(&operatorPushFileServer{stream})
}

type Operator_PushFileServer interface {
	SendAndClose(*PushFileResponse) error
	Recv() (*PushFileRequest, error)
	grpc.ServerStream
}

type operatorPushFileServer struct {
	grpc.ServerStream
}

func (x *operatorPushFileServer) SendAndClose(m *PushFileResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *operatorPushFileServer) Recv() (*PushFileRequest, error) {
	m := new(PushFileRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Operator_serviceDesc = grpc.ServiceDesc{
	ServiceName: "m3em.Operator",
	HandlerType: (*OperatorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Setup",
			Handler:    _Operator_Setup_Handler,
		},
		{
			MethodName: "Start",
			Handler:    _Operator_Start_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _Operator_Stop_Handler,
		},
		{
			MethodName: "Teardown",
			Handler:    _Operator_Teardown_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "PullFile",
			Handler:       _Operator_PullFile_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PushFile",
			Handler:       _Operator_PushFile_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "github.com/m3db/m3/src/m3em/generated/proto/m3em/operator.proto",
}

func (m *SetupRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SetupRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionToken) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintOperator(dAtA, i, uint64(len(m.SessionToken)))
		i += copy(dAtA[i:], m.SessionToken)
	}
	if len(m.OperatorUuid) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintOperator(dAtA, i, uint64(len(m.OperatorUuid)))
		i += copy(dAtA[i:], m.OperatorUuid)
	}
	if m.Force {
		dAtA[i] = 0x18
		i++
		if m.Force {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.HeartbeatEnabled {
		dAtA[i] = 0x20
		i++
		if m.HeartbeatEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.HeartbeatEndpoint) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintOperator(dAtA, i, uint64(len(m.HeartbeatEndpoint)))
		i += copy(dAtA[i:], m.HeartbeatEndpoint)
	}
	if m.HeartbeatFrequencySecs != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintOperator(dAtA, i, uint64(m.HeartbeatFrequencySecs))
	}
	return i, nil
}

func (m *SetupResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SetupResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *StartRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StartRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *StartResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StartResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *StopRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StopRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *StopResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StopResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *TeardownRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TeardownRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *TeardownResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TeardownResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *PullFileRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PullFileRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FileType != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintOperator(dAtA, i, uint64(m.FileType))
	}
	if m.ChunkSize != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintOperator(dAtA, i, uint64(m.ChunkSize))
	}
	if m.MaxSize != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintOperator(dAtA, i, uint64(m.MaxSize))
	}
	return i, nil
}

func (m *PullFileResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PullFileResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Data != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintOperator(dAtA, i, uint64(m.Data.Size()))
		n1, err := m.Data.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Truncated {
		dAtA[i] = 0x10
		i++
		if m.Truncated {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *PushFileRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushFileRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintOperator(dAtA, i, uint64(m.Type))
	}
	if m.Overwrite {
		dAtA[i] = 0x10
		i++
		if m.Overwrite {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Data != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintOperator(dAtA, i, uint64(m.Data.Size()))
		n2, err := m.Data.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.TargetPaths) > 0 {
		for _, s := range m.TargetPaths {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *PushFileResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushFileResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FileChecksum != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintOperator(dAtA, i, uint64(m.FileChecksum))
	}
	if m.NumChunksRecvd != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintOperator(dAtA, i, uint64(m.NumChunksRecvd))
	}
	return i, nil
}

func (m *DataChunk) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataChunk) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Idx != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintOperator(dAtA, i, uint64(m.Idx))
	}
	if len(m.Bytes) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintOperator(dAtA, i, uint64(len(m.Bytes)))
		i += copy(dAtA[i:], m.Bytes)
	}
	return i, nil
}

func encodeVarintOperator(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *SetupRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionToken)
	if l > 0 {
		n += 1 + l + sovOperator(uint64(l))
	}
	l = len(m.OperatorUuid)
	if l > 0 {
		n += 1 + l + sovOperator(uint64(l))
	}
	if m.Force {
		n += 2
	}
	if m.HeartbeatEnabled {
		n += 2
	}
	l = len(m.HeartbeatEndpoint)
	if l > 0 {
		n += 1 + l + sovOperator(uint64(l))
	}
	if m.HeartbeatFrequencySecs != 0 {
		n += 1 + sovOperator(uint64(m.HeartbeatFrequencySecs))
	}
	return n
}

func (m *SetupResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *StartRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *StartResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *StopRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *StopResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *TeardownRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *TeardownResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *PullFileRequest) Size() (n int) {
	var l int
	_ = l
	if m.FileType != 0 {
		n += 1 + sovOperator(uint64(m.FileType))
	}
	if m.ChunkSize != 0 {
		n += 1 + sovOperator(uint64(m.ChunkSize))
	}
	if m.MaxSize != 0 {
		n += 1 + sovOperator(uint64(m.MaxSize))
	}
	return n
}

func (m *PullFileResponse) Size() (n int) {
	var l int
	_ = l
	if m.Data != nil {
		l = m.Data.Size()
		n += 1 + l + sovOperator(uint64(l))
	}
	if m.Truncated {
		n += 2
	}
	return n
}

func (m *PushFileRequest) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovOperator(uint64(m.Type))
	}
	if m.Overwrite {
		n += 2
	}
	if m.Data != nil {
		l = m.Data.Size()
		n += 1 + l + sovOperator(uint64(l))
	}
	if len(m.TargetPaths) > 0 {
		for _, s := range m.TargetPaths {
			l = len(s)
			n += 1 + l + sovOperator(uint64(l))
		}
	}
	return n
}

func (m *PushFileResponse) Size() (n int) {
	var l int
	_ = l
	if m.FileChecksum != 0 {
		n += 1 + sovOperator(uint64(m.FileChecksum))
	}
	if m.NumChunksRecvd != 0 {
		n += 1 + sovOperator(uint64(m.NumChunksRecvd))
	}
	return n
}

func (m *DataChunk) Size() (n int) {
	var l int
	_ = l
	if m.Idx != 0 {
		n += 1 + sovOperator(uint64(m.Idx))
	}
	l = len(m.Bytes)
	if l > 0 {
		n += 1 + l + sovOperator(uint64(l))
	}
	return n
}

func sovOperator(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozOperator(x uint64) (n int) {
	return sovOperator(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *SetupRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetupRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetupRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOperator
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OperatorUuid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOperator
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OperatorUuid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Force = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HeartbeatEnabled = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatEndpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOperator
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeartbeatEndpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatFrequencySecs", wireType)
			}
			m.HeartbeatFrequencySecs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HeartbeatFrequencySecs |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SetupResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetupResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetupResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StartRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StartRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StartRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StartResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StartResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StartResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StopRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StopRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StopRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StopResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StopResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StopResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TeardownRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TeardownRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TeardownRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TeardownResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TeardownResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TeardownResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PullFileRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PullFileRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PullFileRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileType", wireType)
			}
			m.FileType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FileType |= (PullFileType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChunkSize", wireType)
			}
			m.ChunkSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ChunkSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxSize", wireType)
			}
			m.MaxSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PullFileResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PullFileResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PullFileResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOperator
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Data == nil {
				m.Data = &DataChunk{}
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Truncated", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Truncated = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PushFileRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PushFileRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PushFileRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (PushFileType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Overwrite", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Overwrite = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOperator
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Data == nil {
				m.Data = &DataChunk{}
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetPaths", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthOperator
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetPaths = append(m.TargetPaths, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PushFileResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PushFileResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PushFileResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileChecksum", wireType)
			}
			m.FileChecksum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FileChecksum |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumChunksRecvd", wireType)
			}
			m.NumChunksRecvd = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumChunksRecvd |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataChunk) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataChunk: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataChunk: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Idx", wireType)
			}
			m.Idx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Idx |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthOperator
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bytes = append(m.Bytes[:0], dAtA[iNdEx:postIndex]...)
			if m.Bytes == nil {
				m.Bytes = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOperator(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOperator
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipOperator(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowOperator
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowOperator
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthOperator
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowOperator
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipOperator(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthOperator = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowOperator   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("github.com/m3db/m3/src/m3em/generated/proto/m3em/operator.proto", fileDescriptorOperator)
}

var fileDescriptorOperator = []byte{
	// 841 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x55, 0xdd, 0x6e, 0xe3, 0x44,
	0x18, 0x5d, 0xe7, 0x67, 0x49, 0xbe, 0x26, 0xad, 0x3b, 0x0b, 0x95, 0x29, 0xbb, 0xa1, 0xeb, 0x95,
	0x50, 0x54, 0xb4, 0xcd, 0xaa, 0xb9, 0x01, 0x71, 0x81, 0xba, 0x69, 0x02, 0x15, 0x51, 0x52, 0x8d,
	0x1d, 0xd0, 0x5e, 0x59, 0x8e, 0x3d, 0x6d, 0xac, 0xc6, 0x3f, 0x78, 0xc6, 0xbb, 0xed, 0xc2, 0x25,
	0xd7, 0x88, 0x37, 0xe0, 0x75, 0xb8, 0x44, 0x3c, 0x01, 0x2a, 0x2f, 0x82, 0x66, 0xc6, 0x63, 0xbb,
	0xd1, 0xb6, 0x77, 0x99, 0x73, 0xce, 0x37, 0xdf, 0x77, 0x66, 0xc6, 0x27, 0xf0, 0xed, 0x65, 0xc0,
	0x56, 0xd9, 0xf2, 0xc8, 0x8b, 0xc3, 0x41, 0x38, 0xf4, 0x97, 0x83, 0x70, 0x38, 0xa0, 0xa9, 0x37,
	0x08, 0x87, 0x24, 0x1c, 0x5c, 0x92, 0x88, 0xa4, 0x2e, 0x23, 0xfe, 0x20, 0x49, 0x63, 0x16, 0x4b,
	0x30, 0x4e, 0x38, 0x16, 0xa7, 0x47, 0x02, 0x43, 0x0d, 0x0e, 0x9a, 0xbf, 0xd5, 0xa0, 0x63, 0x11,
	0x96, 0x25, 0x98, 0xfc, 0x9c, 0x11, 0xca, 0xd0, 0x0b, 0xe8, 0x52, 0x42, 0x69, 0x10, 0x47, 0x0e,
	0x8b, 0xaf, 0x48, 0x64, 0x68, 0x07, 0x5a, 0xbf, 0x8d, 0x3b, 0x39, 0x68, 0x73, 0x8c, 0x8b, 0xd4,
	0x6e, 0x4e, 0x96, 0x05, 0xbe, 0x51, 0x93, 0x22, 0x05, 0x2e, 0xb2, 0xc0, 0x47, 0x1f, 0x43, 0xf3,
	0x22, 0x4e, 0x3d, 0x62, 0xd4, 0x0f, 0xb4, 0x7e, 0x0b, 0xcb, 0x05, 0xfa, 0x12, 0x76, 0x57, 0xc4,
	0x4d, 0xd9, 0x92, 0xb8, 0xcc, 0x21, 0x91, 0xbb, 0x5c, 0x13, 0xdf, 0x68, 0x08, 0x85, 0x5e, 0x10,
	0x63, 0x89, 0xa3, 0x97, 0x80, 0xaa, 0x62, 0x3f, 0x89, 0x83, 0x88, 0x19, 0x4d, 0xd1, 0x6c, 0xb7,
	0xa2, 0x96, 0x04, 0xfa, 0x0a, 0x8c, 0x52, 0x7e, 0x91, 0x72, 0x47, 0x91, 0x77, 0xe3, 0x50, 0xe2,
	0x51, 0xe3, 0xf1, 0x81, 0xd6, 0xef, 0xe2, 0xbd, 0x82, 0x9f, 0x28, 0xda, 0x22, 0x1e, 0x35, 0x77,
	0xa0, 0x9b, 0x9f, 0x02, 0x4d, 0xe2, 0x88, 0x12, 0x73, 0x1b, 0x3a, 0x16, 0x73, 0x53, 0x96, 0x1f,
	0x8b, 0x10, 0xc8, 0x75, 0x2e, 0xe8, 0xc2, 0x96, 0xc5, 0x62, 0x75, 0x6c, 0x52, 0x1f, 0x97, 0xf5,
	0xbb, 0xb0, 0x63, 0x13, 0x37, 0xf5, 0xe3, 0x77, 0x91, 0x92, 0x20, 0xd0, 0x4b, 0x28, 0x97, 0xfd,
	0x0a, 0x3b, 0xe7, 0xd9, 0x7a, 0x3d, 0x09, 0xd6, 0x44, 0x5d, 0xc0, 0x00, 0xda, 0x17, 0xc1, 0x9a,
	0x38, 0xec, 0x26, 0x21, 0xe2, 0xf0, 0xb7, 0x8f, 0xd1, 0x11, 0xbf, 0xab, 0x23, 0xa5, 0xb4, 0x6f,
	0x12, 0x82, 0x5b, 0x17, 0xf9, 0x2f, 0xf4, 0x0c, 0xc0, 0x5b, 0x65, 0xd1, 0x95, 0x43, 0x83, 0xf7,
	0x44, 0xdc, 0x44, 0x1d, 0xb7, 0x05, 0x62, 0x05, 0xef, 0x09, 0xfa, 0x14, 0x5a, 0xa1, 0x7b, 0x2d,
	0xc9, 0xba, 0x20, 0x3f, 0x0a, 0xdd, 0x6b, 0x4e, 0x99, 0x0b, 0xd0, 0xcb, 0xee, 0x72, 0x22, 0xf4,
	0x02, 0x1a, 0xbe, 0xcb, 0x5c, 0xd1, 0x79, 0xeb, 0x78, 0x47, 0x76, 0x3e, 0x75, 0x99, 0x3b, 0xe2,
	0x3b, 0x62, 0x41, 0xa2, 0xa7, 0xd0, 0x66, 0x69, 0x16, 0x79, 0xfc, 0x89, 0x89, 0x8e, 0x2d, 0x5c,
	0x02, 0xe6, 0x9f, 0x1a, 0x77, 0x45, 0x57, 0x55, 0x57, 0x5f, 0x40, 0xe3, 0x43, 0x86, 0xa4, 0x48,
	0x18, 0x12, 0x3c, 0xdf, 0x39, 0x7e, 0x4b, 0xd2, 0x77, 0x69, 0xc0, 0x88, 0xda, 0xb9, 0x00, 0x8a,
	0xe1, 0xea, 0x0f, 0x0d, 0xf7, 0x1c, 0x3a, 0xcc, 0x4d, 0x2f, 0x09, 0x73, 0x12, 0x97, 0xad, 0xa8,
	0xd1, 0x38, 0xa8, 0xf7, 0xdb, 0x78, 0x4b, 0x62, 0xe7, 0x1c, 0x32, 0x5d, 0x6e, 0x5c, 0x0d, 0x58,
	0x18, 0xef, 0x8a, 0x73, 0xf7, 0x56, 0xc4, 0xbb, 0xa2, 0x59, 0x28, 0x46, 0xed, 0xe2, 0x0e, 0x07,
	0x47, 0x39, 0x86, 0xfa, 0xa0, 0x47, 0x59, 0xe8, 0x88, 0xd3, 0xa5, 0x4e, 0x4a, 0xbc, 0xb7, 0xd2,
	0x7f, 0x13, 0x6f, 0x47, 0x59, 0x28, 0xa6, 0xa0, 0x98, 0xa3, 0xe6, 0x10, 0xda, 0xc5, 0x60, 0x48,
	0x87, 0x7a, 0xe0, 0x5f, 0x8b, 0x1d, 0x9b, 0x98, 0xff, 0xe4, 0x1f, 0xc7, 0xf2, 0x86, 0x11, 0x2a,
	0xaa, 0x3b, 0x58, 0x2e, 0x0e, 0x13, 0xe8, 0x54, 0x2f, 0x19, 0xed, 0xc3, 0xde, 0xf9, 0x62, 0x3a,
	0x75, 0x26, 0x67, 0xd3, 0xb1, 0x63, 0xbf, 0x39, 0x1f, 0x3b, 0x8b, 0xd9, 0x0f, 0xb3, 0xf9, 0x4f,
	0x33, 0xfd, 0x11, 0x7a, 0x0e, 0xcf, 0x36, 0x38, 0x6b, 0x8c, 0x7f, 0x3c, 0x1b, 0x8d, 0x1d, 0xcb,
	0x3e, 0x9d, 0x2f, 0x6c, 0x5d, 0x7b, 0x58, 0x32, 0xc6, 0x58, 0xaf, 0x1d, 0xfe, 0x02, 0x4f, 0x54,
	0xc7, 0x51, 0x1c, 0x31, 0x12, 0x31, 0xd1, 0xd8, 0x84, 0x5e, 0x59, 0x39, 0x9a, 0xcf, 0xec, 0xf1,
	0xcc, 0xde, 0x1c, 0xe0, 0x73, 0xf8, 0xec, 0x1e, 0xcd, 0xf4, 0xc4, 0xe2, 0xed, 0xef, 0x17, 0x4c,
	0x16, 0xd3, 0xa9, 0x5e, 0x3b, 0xfc, 0x5d, 0xe3, 0x7e, 0xcb, 0x37, 0x20, 0xfd, 0x5a, 0xdf, 0xdf,
	0xef, 0xf7, 0x0e, 0xa7, 0xcc, 0xbc, 0x3e, 0x9b, 0x9d, 0xe0, 0x37, 0xca, 0xef, 0x07, 0x25, 0xa3,
	0xf9, 0x6c, 0x72, 0xf6, 0x9d, 0x5e, 0x43, 0x4f, 0xc1, 0xd8, 0x90, 0x9c, 0x9e, 0xd8, 0x27, 0x62,
	0xa9, 0xd7, 0x8f, 0xff, 0xa9, 0x41, 0x6b, 0x9e, 0x67, 0x18, 0x7a, 0x05, 0x4d, 0x91, 0x09, 0x28,
	0x7f, 0xad, 0xd5, 0x98, 0xdc, 0x7f, 0x72, 0x07, 0xcb, 0x9f, 0x10, 0xaf, 0xe0, 0x21, 0x51, 0x54,
	0x54, 0x12, 0xa4, 0xa8, 0xa8, 0xa6, 0x08, 0x7a, 0x09, 0x0d, 0x1e, 0x1b, 0x68, 0x57, 0x91, 0x45,
	0xa2, 0xec, 0xa3, 0x2a, 0x94, 0xcb, 0xbf, 0x86, 0x96, 0x8a, 0x10, 0xf4, 0x89, 0xe4, 0x37, 0x52,
	0x66, 0x7f, 0x6f, 0x13, 0xce, 0x4b, 0xbf, 0x81, 0x96, 0xba, 0x68, 0x55, 0xba, 0x91, 0x3c, 0xaa,
	0x74, 0x33, 0x12, 0x5e, 0x69, 0xb2, 0x58, 0xde, 0x53, 0x59, 0x7c, 0xe7, 0x03, 0x2f, 0x8b, 0xef,
	0x7e, 0x56, 0x7d, 0xed, 0xb5, 0xfe, 0xd7, 0x6d, 0x4f, 0xfb, 0xfb, 0xb6, 0xa7, 0xfd, 0x7b, 0xdb,
	0xd3, 0xfe, 0xf8, 0xaf, 0xf7, 0x68, 0xf9, 0x58, 0xfc, 0x03, 0x0d, 0xff, 0x0f, 0x00, 0x00, 0xff,
	0xff, 0x5e, 0x54, 0x4b, 0x61, 0xc4, 0x06, 0x00, 0x00,
}
