// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/m3db/m3/src/m3nsch/generated/proto/m3nsch/m3nsch.proto

// Copyright (c) 2019 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/*
	Package m3nsch is a generated protocol buffer package.

	It is generated from these files:
		github.com/m3db/m3/src/m3nsch/generated/proto/m3nsch/m3nsch.proto

	It has these top-level messages:
		StatusRequest
		StatusResponse
		InitRequest
		InitResponse
		ModifyRequest
		ModifyResponse
		StartRequest
		StartResponse
		StopRequest
		StopResponse
		Workload
*/
package m3nsch

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/gogo/protobuf/types"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type Status int32

const (
	Status_UNKNOWN       Status = 0
	Status_UNINITIALIZED Status = 1
	Status_INITIALIZED   Status = 2
	Status_RUNNING       Status = 3
)

var Status_name = map[int32]string{
	0: "UNKNOWN",
	1: "UNINITIALIZED",
	2: "INITIALIZED",
	3: "RUNNING",
}
var Status_value = map[string]int32{
	"UNKNOWN":       0,
	"UNINITIALIZED": 1,
	"INITIALIZED":   2,
	"RUNNING":       3,
}

func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}
func (Status) EnumDescriptor() ([]byte, []int) { return fileDescriptorM3Nsch, []int{0} }

type StatusRequest struct {
}

func (m *StatusRequest) Reset()                    { *m = StatusRequest{} }
func (m *StatusRequest) String() string            { return proto.CompactTextString(m) }
func (*StatusRequest) ProtoMessage()               {}
func (*StatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorM3Nsch, []int{0} }

type StatusResponse struct {
	Status   Status    `protobuf:"varint,1,opt,name=status,proto3,enum=m3nsch.Status" json:"status,omitempty"`
	Token    string    `protobuf:"bytes,2,opt,name=token,proto3" json:"token,omitempty"`
	MaxQPS   int64     `protobuf:"varint,3,opt,name=maxQPS,proto3" json:"maxQPS,omitempty"`
	Workload *Workload `protobuf:"bytes,4,opt,name=workload" json:"workload,omitempty"`
}

func (m *StatusResponse) Reset()                    { *m = StatusResponse{} }
func (m *StatusResponse) String() string            { return proto.CompactTextString(m) }
func (*StatusResponse) ProtoMessage()               {}
func (*StatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorM3Nsch, []int{1} }

func (m *StatusResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_UNKNOWN
}

func (m *StatusResponse) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *StatusResponse) GetMaxQPS() int64 {
	if m != nil {
		return m.MaxQPS
	}
	return 0
}

func (m *StatusResponse) GetWorkload() *Workload {
	if m != nil {
		return m.Workload
	}
	return nil
}

type InitRequest struct {
	Token      string    `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	Workload   *Workload `protobuf:"bytes,2,opt,name=workload" json:"workload,omitempty"`
	Force      bool      `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	TargetZone string    `protobuf:"bytes,4,opt,name=targetZone,proto3" json:"targetZone,omitempty"`
	TargetEnv  string    `protobuf:"bytes,5,opt,name=targetEnv,proto3" json:"targetEnv,omitempty"`
}

func (m *InitRequest) Reset()                    { *m = InitRequest{} }
func (m *InitRequest) String() string            { return proto.CompactTextString(m) }
func (*InitRequest) ProtoMessage()               {}
func (*InitRequest) Descriptor() ([]byte, []int) { return fileDescriptorM3Nsch, []int{2} }

func (m *InitRequest) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *InitRequest) GetWorkload() *Workload {
	if m != nil {
		return m.Workload
	}
	return nil
}

func (m *InitRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *InitRequest) GetTargetZone() string {
	if m != nil {
		return m.TargetZone
	}
	return ""
}

func (m *InitRequest) GetTargetEnv() string {
	if m != nil {
		return m.TargetEnv
	}
	return ""
}

type InitResponse struct {
}

func (m *InitResponse) Reset()                    { *m = InitResponse{} }
func (m *InitResponse) String() string            { return proto.CompactTextString(m) }
func (*InitResponse) ProtoMessage()               {}
func (*InitResponse) Descriptor() ([]byte, []int) { return fileDescriptorM3Nsch, []int{3} }

type ModifyRequest struct {
	Workload *Workload `protobuf:"bytes,1,opt,name=workload" json:"workload,omitempty"`
}

func (m *ModifyRequest) Reset()                    { *m = ModifyRequest{} }
func (m *ModifyRequest) String() string            { return proto.CompactTextString(m) }
func (*ModifyRequest) ProtoMessage()               {}
func (*ModifyRequest) Descriptor() ([]byte, []int) { return fileDescriptorM3Nsch, []int{4} }

func (m *ModifyRequest) GetWorkload() *Workload {
	if m != nil {
		return m.Workload
	}
	return nil
}

type ModifyResponse struct {
}

func (m *ModifyResponse) Reset()                    { *m = ModifyResponse{} }
func (m *ModifyResponse) String() string            { return proto.CompactTextString(m) }
func (*ModifyResponse) ProtoMessage()               {}
func (*ModifyResponse) Descriptor() ([]byte, []int) { return fileDescriptorM3Nsch, []int{5} }

type StartRequest struct {
}

func (m *StartRequest) Reset()                    { *m = StartRequest{} }
func (m *StartRequest) String() string            { return proto.CompactTextString(m) }
func (*StartRequest) ProtoMessage()               {}
func (*StartRequest) Descriptor() ([]byte, []int) { return fileDescriptorM3Nsch, []int{6} }

type StartResponse struct {
}

func (m *StartResponse) Reset()                    { *m = StartResponse{} }
func (m *StartResponse) String() string            { return proto.CompactTextString(m) }
func (*StartResponse) ProtoMessage()               {}
func (*StartResponse) Descriptor() ([]byte, []int) { return fileDescriptorM3Nsch, []int{7} }

type StopRequest struct {
}

func (m *StopRequest) Reset()                    { *m = StopRequest{} }
func (m *StopRequest) String() string            { return proto.CompactTextString(m) }
func (*StopRequest) ProtoMessage()               {}
func (*StopRequest) Descriptor() ([]byte, []int) { return fileDescriptorM3Nsch, []int{8} }

type StopResponse struct {
}

func (m *StopResponse) Reset()                    { *m = StopResponse{} }
func (m *StopResponse) String() string            { return proto.CompactTextString(m) }
func (*StopResponse) ProtoMessage()               {}
func (*StopResponse) Descriptor() ([]byte, []int) { return fileDescriptorM3Nsch, []int{9} }

type Workload struct {
	BaseTime        *google_protobuf.Timestamp `protobuf:"bytes,1,opt,name=baseTime" json:"baseTime,omitempty"`
	MetricPrefix    string                     `protobuf:"bytes,2,opt,name=metricPrefix,proto3" json:"metricPrefix,omitempty"`
	Namespace       string                     `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Cardinality     int32                      `protobuf:"varint,4,opt,name=cardinality,proto3" json:"cardinality,omitempty"`
	IngressQPS      int32                      `protobuf:"varint,5,opt,name=ingressQPS,proto3" json:"ingressQPS,omitempty"`
	UniqueAmplifier float64                    `protobuf:"fixed64,6,opt,name=uniqueAmplifier,proto3" json:"uniqueAmplifier,omitempty"`
}

func (m *Workload) Reset()                    { *m = Workload{} }
func (m *Workload) String() string            { return proto.CompactTextString(m) }
func (*Workload) ProtoMessage()               {}
func (*Workload) Descriptor() ([]byte, []int) { return fileDescriptorM3Nsch, []int{10} }

func (m *Workload) GetBaseTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.BaseTime
	}
	return nil
}

func (m *Workload) GetMetricPrefix() string {
	if m != nil {
		return m.MetricPrefix
	}
	return ""
}

func (m *Workload) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *Workload) GetCardinality() int32 {
	if m != nil {
		return m.Cardinality
	}
	return 0
}

func (m *Workload) GetIngressQPS() int32 {
	if m != nil {
		return m.IngressQPS
	}
	return 0
}

func (m *Workload) GetUniqueAmplifier() float64 {
	if m != nil {
		return m.UniqueAmplifier
	}
	return 0
}

func init() {
	proto.RegisterType((*StatusRequest)(nil), "m3nsch.StatusRequest")
	proto.RegisterType((*StatusResponse)(nil), "m3nsch.StatusResponse")
	proto.RegisterType((*InitRequest)(nil), "m3nsch.InitRequest")
	proto.RegisterType((*InitResponse)(nil), "m3nsch.InitResponse")
	proto.RegisterType((*ModifyRequest)(nil), "m3nsch.ModifyRequest")
	proto.RegisterType((*ModifyResponse)(nil), "m3nsch.ModifyResponse")
	proto.RegisterType((*StartRequest)(nil), "m3nsch.StartRequest")
	proto.RegisterType((*StartResponse)(nil), "m3nsch.StartResponse")
	proto.RegisterType((*StopRequest)(nil), "m3nsch.StopRequest")
	proto.RegisterType((*StopResponse)(nil), "m3nsch.StopResponse")
	proto.RegisterType((*Workload)(nil), "m3nsch.Workload")
	proto.RegisterEnum("m3nsch.Status", Status_name, Status_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Mensch service

type MenschClient interface {
	Status(ctx context.Context, in *StatusRequest, opts ...grpc.CallOption) (*StatusResponse, error)
	Init(ctx context.Context, in *InitRequest, opts ...grpc.CallOption) (*InitResponse, error)
	Start(ctx context.Context, in *StartRequest, opts ...grpc.CallOption) (*StartResponse, error)
	Stop(ctx context.Context, in *StopRequest, opts ...grpc.CallOption) (*StopResponse, error)
	Modify(ctx context.Context, in *ModifyRequest, opts ...grpc.CallOption) (*ModifyResponse, error)
}

type menschClient struct {
	cc *grpc.ClientConn
}

func NewMenschClient(cc *grpc.ClientConn) MenschClient {
	return &menschClient{cc}
}

func (c *menschClient) Status(ctx context.Context, in *StatusRequest, opts ...grpc.CallOption) (*StatusResponse, error) {
	out := new(StatusResponse)
	err := grpc.Invoke(ctx, "/m3nsch.Mensch/Status", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *menschClient) Init(ctx context.Context, in *InitRequest, opts ...grpc.CallOption) (*InitResponse, error) {
	out := new(InitResponse)
	err := grpc.Invoke(ctx, "/m3nsch.Mensch/Init", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *menschClient) Start(ctx context.Context, in *StartRequest, opts ...grpc.CallOption) (*StartResponse, error) {
	out := new(StartResponse)
	err := grpc.Invoke(ctx, "/m3nsch.Mensch/Start", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *menschClient) Stop(ctx context.Context, in *StopRequest, opts ...grpc.CallOption) (*StopResponse, error) {
	out := new(StopResponse)
	err := grpc.Invoke(ctx, "/m3nsch.Mensch/Stop", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *menschClient) Modify(ctx context.Context, in *ModifyRequest, opts ...grpc.CallOption) (*ModifyResponse, error) {
	out := new(ModifyResponse)
	err := grpc.Invoke(ctx, "/m3nsch.Mensch/Modify", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Mensch service

type MenschServer interface {
	Status(context.Context, *StatusRequest) (*StatusResponse, error)
	Init(context.Context, *InitRequest) (*InitResponse, error)
	Start(context.Context, *StartRequest) (*StartResponse, error)
	Stop(context.Context, *StopRequest) (*StopResponse, error)
	Modify(context.Context, *ModifyRequest) (*ModifyResponse, error)
}

func RegisterMenschServer(s *grpc.Server, srv MenschServer) {
	s.RegisterService(&_Mensch_serviceDesc, srv)
}

func _Mensch_Status_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MenschServer).Status(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/m3nsch.Mensch/Status",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MenschServer).Status(ctx, req.(*StatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Mensch_Init_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MenschServer).Init(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/m3nsch.Mensch/Init",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MenschServer).Init(ctx, req.(*InitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Mensch_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MenschServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/m3nsch.Mensch/Start",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MenschServer).Start(ctx, req.(*StartRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Mensch_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MenschServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/m3nsch.Mensch/Stop",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MenschServer).Stop(ctx, req.(*StopRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Mensch_Modify_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MenschServer).Modify(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/m3nsch.Mensch/Modify",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MenschServer).Modify(ctx, req.(*ModifyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Mensch_serviceDesc = grpc.ServiceDesc{
	ServiceName: "m3nsch.Mensch",
	HandlerType: (*MenschServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Status",
			Handler:    _Mensch_Status_Handler,
		},
		{
			MethodName: "Init",
			Handler:    _Mensch_Init_Handler,
		},
		{
			MethodName: "Start",
			Handler:    _Mensch_Start_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _Mensch_Stop_Handler,
		},
		{
			MethodName: "Modify",
			Handler:    _Mensch_Modify_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "github.com/m3db/m3/src/m3nsch/generated/proto/m3nsch/m3nsch.proto",
}

func (m *StatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatusRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *StatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatusResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Status != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(m.Status))
	}
	if len(m.Token) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(len(m.Token)))
		i += copy(dAtA[i:], m.Token)
	}
	if m.MaxQPS != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(m.MaxQPS))
	}
	if m.Workload != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(m.Workload.Size()))
		n1, err := m.Workload.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	return i, nil
}

func (m *InitRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InitRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Token) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(len(m.Token)))
		i += copy(dAtA[i:], m.Token)
	}
	if m.Workload != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(m.Workload.Size()))
		n2, err := m.Workload.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Force {
		dAtA[i] = 0x18
		i++
		if m.Force {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.TargetZone) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(len(m.TargetZone)))
		i += copy(dAtA[i:], m.TargetZone)
	}
	if len(m.TargetEnv) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(len(m.TargetEnv)))
		i += copy(dAtA[i:], m.TargetEnv)
	}
	return i, nil
}

func (m *InitResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InitResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ModifyRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ModifyRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Workload != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(m.Workload.Size()))
		n3, err := m.Workload.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}

func (m *ModifyResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ModifyResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *StartRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StartRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *StartResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StartResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *StopRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StopRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *StopResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StopResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *Workload) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Workload) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.BaseTime != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(m.BaseTime.Size()))
		n4, err := m.BaseTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.MetricPrefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(len(m.MetricPrefix)))
		i += copy(dAtA[i:], m.MetricPrefix)
	}
	if len(m.Namespace) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(len(m.Namespace)))
		i += copy(dAtA[i:], m.Namespace)
	}
	if m.Cardinality != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(m.Cardinality))
	}
	if m.IngressQPS != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintM3Nsch(dAtA, i, uint64(m.IngressQPS))
	}
	if m.UniqueAmplifier != 0 {
		dAtA[i] = 0x31
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.UniqueAmplifier))))
		i += 8
	}
	return i, nil
}

func encodeVarintM3Nsch(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *StatusRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *StatusResponse) Size() (n int) {
	var l int
	_ = l
	if m.Status != 0 {
		n += 1 + sovM3Nsch(uint64(m.Status))
	}
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovM3Nsch(uint64(l))
	}
	if m.MaxQPS != 0 {
		n += 1 + sovM3Nsch(uint64(m.MaxQPS))
	}
	if m.Workload != nil {
		l = m.Workload.Size()
		n += 1 + l + sovM3Nsch(uint64(l))
	}
	return n
}

func (m *InitRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovM3Nsch(uint64(l))
	}
	if m.Workload != nil {
		l = m.Workload.Size()
		n += 1 + l + sovM3Nsch(uint64(l))
	}
	if m.Force {
		n += 2
	}
	l = len(m.TargetZone)
	if l > 0 {
		n += 1 + l + sovM3Nsch(uint64(l))
	}
	l = len(m.TargetEnv)
	if l > 0 {
		n += 1 + l + sovM3Nsch(uint64(l))
	}
	return n
}

func (m *InitResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ModifyRequest) Size() (n int) {
	var l int
	_ = l
	if m.Workload != nil {
		l = m.Workload.Size()
		n += 1 + l + sovM3Nsch(uint64(l))
	}
	return n
}

func (m *ModifyResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *StartRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *StartResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *StopRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *StopResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *Workload) Size() (n int) {
	var l int
	_ = l
	if m.BaseTime != nil {
		l = m.BaseTime.Size()
		n += 1 + l + sovM3Nsch(uint64(l))
	}
	l = len(m.MetricPrefix)
	if l > 0 {
		n += 1 + l + sovM3Nsch(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovM3Nsch(uint64(l))
	}
	if m.Cardinality != 0 {
		n += 1 + sovM3Nsch(uint64(m.Cardinality))
	}
	if m.IngressQPS != 0 {
		n += 1 + sovM3Nsch(uint64(m.IngressQPS))
	}
	if m.UniqueAmplifier != 0 {
		n += 9
	}
	return n
}

func sovM3Nsch(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozM3Nsch(x uint64) (n int) {
	return sovM3Nsch(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *StatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowM3Nsch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipM3Nsch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthM3Nsch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowM3Nsch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (Status(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthM3Nsch
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxQPS", wireType)
			}
			m.MaxQPS = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxQPS |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Workload", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthM3Nsch
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Workload == nil {
				m.Workload = &Workload{}
			}
			if err := m.Workload.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipM3Nsch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthM3Nsch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InitRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowM3Nsch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InitRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InitRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthM3Nsch
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Workload", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthM3Nsch
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Workload == nil {
				m.Workload = &Workload{}
			}
			if err := m.Workload.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Force = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetZone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthM3Nsch
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetZone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetEnv", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthM3Nsch
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetEnv = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipM3Nsch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthM3Nsch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InitResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowM3Nsch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InitResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InitResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipM3Nsch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthM3Nsch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ModifyRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowM3Nsch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ModifyRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ModifyRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Workload", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthM3Nsch
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Workload == nil {
				m.Workload = &Workload{}
			}
			if err := m.Workload.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipM3Nsch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthM3Nsch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ModifyResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowM3Nsch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ModifyResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ModifyResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipM3Nsch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthM3Nsch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StartRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowM3Nsch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StartRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StartRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipM3Nsch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthM3Nsch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StartResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowM3Nsch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StartResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StartResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipM3Nsch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthM3Nsch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StopRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowM3Nsch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StopRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StopRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipM3Nsch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthM3Nsch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StopResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowM3Nsch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StopResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StopResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipM3Nsch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthM3Nsch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Workload) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowM3Nsch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Workload: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Workload: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthM3Nsch
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BaseTime == nil {
				m.BaseTime = &google_protobuf.Timestamp{}
			}
			if err := m.BaseTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthM3Nsch
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MetricPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthM3Nsch
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cardinality", wireType)
			}
			m.Cardinality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Cardinality |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngressQPS", wireType)
			}
			m.IngressQPS = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IngressQPS |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field UniqueAmplifier", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.UniqueAmplifier = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipM3Nsch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthM3Nsch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipM3Nsch(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowM3Nsch
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowM3Nsch
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthM3Nsch
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowM3Nsch
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipM3Nsch(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthM3Nsch = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowM3Nsch   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("github.com/m3db/m3/src/m3nsch/generated/proto/m3nsch/m3nsch.proto", fileDescriptorM3Nsch)
}

var fileDescriptorM3Nsch = []byte{
	// 617 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x93, 0x4d, 0x6e, 0xd3, 0x40,
	0x14, 0xc7, 0x3b, 0x69, 0x63, 0x92, 0x97, 0x26, 0x0d, 0x43, 0x5a, 0x45, 0x11, 0x0a, 0x51, 0x16,
	0x28, 0x42, 0x28, 0x16, 0x0d, 0xa2, 0x2b, 0x16, 0x45, 0x14, 0x14, 0x41, 0x4d, 0x71, 0x5a, 0x55,
	0xea, 0x6e, 0xe2, 0x4c, 0xdc, 0x51, 0x63, 0x8f, 0x3b, 0x33, 0x86, 0xf6, 0x16, 0x2c, 0x10, 0x37,
	0xe0, 0x2e, 0x2c, 0x39, 0x02, 0x2a, 0x17, 0xe0, 0x08, 0xc8, 0x9e, 0x71, 0xec, 0x64, 0xd3, 0x95,
	0xf5, 0x7e, 0xef, 0x73, 0xde, 0xfb, 0x1b, 0x0e, 0x7d, 0xa6, 0x2e, 0xe3, 0xe9, 0xd0, 0xe3, 0x81,
	0x1d, 0x8c, 0x66, 0x53, 0x3b, 0x18, 0xd9, 0x52, 0x78, 0x76, 0x30, 0x0a, 0xa5, 0x77, 0x69, 0xfb,
	0x34, 0xa4, 0x82, 0x28, 0x3a, 0xb3, 0x23, 0xc1, 0x15, 0xcf, 0xb0, 0xfe, 0x0c, 0x53, 0x86, 0x2d,
	0x6d, 0x75, 0x9e, 0xf8, 0x9c, 0xfb, 0x0b, 0xaa, 0x23, 0xa7, 0xf1, 0xdc, 0x56, 0x2c, 0xa0, 0x52,
	0x91, 0x20, 0xd2, 0x81, 0xfd, 0x1d, 0xa8, 0x4f, 0x14, 0x51, 0xb1, 0x74, 0xe9, 0x75, 0x4c, 0xa5,
	0xea, 0x7f, 0x47, 0xd0, 0xc8, 0x88, 0x8c, 0x78, 0x28, 0x29, 0x7e, 0x0a, 0x96, 0x4c, 0x49, 0x1b,
	0xf5, 0xd0, 0xa0, 0xb1, 0xdf, 0x18, 0x9a, 0x5e, 0x26, 0xce, 0x78, 0x71, 0x0b, 0xca, 0x8a, 0x5f,
	0xd1, 0xb0, 0x5d, 0xea, 0xa1, 0x41, 0xd5, 0xd5, 0x06, 0xde, 0x03, 0x2b, 0x20, 0x37, 0x9f, 0x4f,
	0x26, 0xed, 0xcd, 0x1e, 0x1a, 0x6c, 0xba, 0xc6, 0xc2, 0xcf, 0xa1, 0xf2, 0x95, 0x8b, 0xab, 0x05,
	0x27, 0xb3, 0xf6, 0x56, 0x0f, 0x0d, 0x6a, 0xfb, 0xcd, 0xac, 0xee, 0xb9, 0xe1, 0xee, 0x32, 0xa2,
	0xff, 0x13, 0x41, 0x6d, 0x1c, 0x32, 0x65, 0xc6, 0xcc, 0x7b, 0xa1, 0x62, 0xaf, 0x62, 0xcd, 0xd2,
	0x7d, 0x35, 0x93, 0x1a, 0x73, 0x2e, 0x3c, 0x9a, 0x0e, 0x56, 0x71, 0xb5, 0x81, 0xbb, 0x00, 0x8a,
	0x08, 0x9f, 0xaa, 0x0b, 0x1e, 0xd2, 0x74, 0xb2, 0xaa, 0x5b, 0x20, 0xf8, 0x31, 0x54, 0xb5, 0x75,
	0x14, 0x7e, 0x69, 0x97, 0x53, 0x77, 0x0e, 0xfa, 0x0d, 0xd8, 0xd6, 0x63, 0xea, 0xdd, 0xf5, 0x5f,
	0x43, 0xfd, 0x98, 0xcf, 0xd8, 0xfc, 0x36, 0x1b, 0xbc, 0x38, 0x22, 0xba, 0xf7, 0xd9, 0x4d, 0x68,
	0x64, 0xe9, 0xa6, 0x60, 0x03, 0xb6, 0x27, 0x8a, 0x88, 0x6c, 0x11, 0xe6, 0x80, 0x22, 0xef, 0x58,
	0x87, 0xda, 0x44, 0xf1, 0x28, 0xf3, 0xa7, 0xf1, 0x89, 0x69, 0xdc, 0xff, 0x10, 0x54, 0xb2, 0x46,
	0xf8, 0x15, 0x54, 0xa6, 0x44, 0xd2, 0x53, 0x16, 0x50, 0x33, 0x4c, 0x67, 0xa8, 0x15, 0x33, 0xcc,
	0x14, 0x33, 0x3c, 0xcd, 0x14, 0xe3, 0x2e, 0x63, 0x71, 0x1f, 0xb6, 0x03, 0xaa, 0x04, 0xf3, 0x4e,
	0x04, 0x9d, 0xb3, 0x1b, 0x73, 0xf0, 0x15, 0x96, 0xec, 0x29, 0x24, 0x01, 0x95, 0x11, 0x31, 0x1b,
	0xae, 0xba, 0x39, 0xc0, 0x3d, 0xa8, 0x79, 0x44, 0xcc, 0x58, 0x48, 0x16, 0x4c, 0xdd, 0xa6, 0x6b,
	0x2e, 0xbb, 0x45, 0x94, 0xdc, 0x81, 0x85, 0xbe, 0xa0, 0x52, 0x26, 0xda, 0x29, 0xa7, 0x01, 0x05,
	0x82, 0x07, 0xb0, 0x13, 0x87, 0xec, 0x3a, 0xa6, 0x87, 0x41, 0xb4, 0x60, 0x73, 0x46, 0x45, 0xdb,
	0xea, 0xa1, 0x01, 0x72, 0xd7, 0xf1, 0xb3, 0x77, 0x60, 0x69, 0xa5, 0xe2, 0x1a, 0x3c, 0x38, 0x73,
	0x3e, 0x38, 0x9f, 0xce, 0x9d, 0xe6, 0x06, 0x7e, 0x08, 0xf5, 0x33, 0x67, 0xec, 0x8c, 0x4f, 0xc7,
	0x87, 0x1f, 0xc7, 0x17, 0x47, 0x6f, 0x9b, 0x08, 0xef, 0x40, 0xad, 0x08, 0x4a, 0x49, 0x82, 0x7b,
	0xe6, 0x38, 0x63, 0xe7, 0x7d, 0x73, 0x73, 0xff, 0x47, 0x09, 0xac, 0x63, 0x9a, 0x9c, 0x0a, 0x1f,
	0x2c, 0x4b, 0xee, 0xae, 0xfd, 0x0c, 0x7a, 0xed, 0x9d, 0xbd, 0x75, 0x6c, 0xfe, 0xa5, 0x17, 0xb0,
	0x95, 0xe8, 0x03, 0x3f, 0xca, 0xfc, 0x05, 0x51, 0x77, 0x5a, 0xab, 0xd0, 0xa4, 0xbc, 0x84, 0x72,
	0x7a, 0x61, 0xdc, 0x2a, 0xd4, 0x5c, 0x0a, 0xa0, 0xb3, 0xbb, 0x46, 0xf3, 0x46, 0xc9, 0xdd, 0xf3,
	0x46, 0x05, 0x51, 0x74, 0x5a, 0xab, 0xd0, 0xa4, 0x1c, 0x80, 0xa5, 0xc5, 0x96, 0x3f, 0x6a, 0x45,
	0xbb, 0xf9, 0xa3, 0x56, 0x35, 0xf9, 0xa6, 0xf9, 0xeb, 0xae, 0x8b, 0x7e, 0xdf, 0x75, 0xd1, 0x9f,
	0xbb, 0x2e, 0xfa, 0xf6, 0xb7, 0xbb, 0x31, 0xb5, 0x52, 0xf9, 0x8c, 0xfe, 0x07, 0x00, 0x00, 0xff,
	0xff, 0x6a, 0x4c, 0xfe, 0xd7, 0xcb, 0x04, 0x00, 0x00,
}
