// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/m3db/m3/src/metrics/generated/proto/pipelinepb/pipeline.proto

// Copyright (c) 2018 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/*
	Package pipelinepb is a generated protocol buffer package.

	It is generated from these files:
		github.com/m3db/m3/src/metrics/generated/proto/pipelinepb/pipeline.proto

	It has these top-level messages:
		AggregationOp
		TransformationOp
		RollupOp
		PipelineOp
		Pipeline
		AppliedRollupOp
		AppliedPipelineOp
		AppliedPipeline
*/
package pipelinepb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import aggregationpb "github.com/m3db/m3/src/metrics/generated/proto/aggregationpb"
import transformationpb "github.com/m3db/m3/src/metrics/generated/proto/transformationpb"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type PipelineOp_Type int32

const (
	PipelineOp_UNKNOWN        PipelineOp_Type = 0
	PipelineOp_AGGREGATION    PipelineOp_Type = 1
	PipelineOp_TRANSFORMATION PipelineOp_Type = 2
	PipelineOp_ROLLUP         PipelineOp_Type = 3
)

var PipelineOp_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "AGGREGATION",
	2: "TRANSFORMATION",
	3: "ROLLUP",
}
var PipelineOp_Type_value = map[string]int32{
	"UNKNOWN":        0,
	"AGGREGATION":    1,
	"TRANSFORMATION": 2,
	"ROLLUP":         3,
}

func (x PipelineOp_Type) String() string {
	return proto.EnumName(PipelineOp_Type_name, int32(x))
}
func (PipelineOp_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorPipeline, []int{3, 0} }

type AppliedPipelineOp_Type int32

const (
	AppliedPipelineOp_UNKNOWN        AppliedPipelineOp_Type = 0
	AppliedPipelineOp_TRANSFORMATION AppliedPipelineOp_Type = 1
	AppliedPipelineOp_ROLLUP         AppliedPipelineOp_Type = 2
)

var AppliedPipelineOp_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "TRANSFORMATION",
	2: "ROLLUP",
}
var AppliedPipelineOp_Type_value = map[string]int32{
	"UNKNOWN":        0,
	"TRANSFORMATION": 1,
	"ROLLUP":         2,
}

func (x AppliedPipelineOp_Type) String() string {
	return proto.EnumName(AppliedPipelineOp_Type_name, int32(x))
}
func (AppliedPipelineOp_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorPipeline, []int{6, 0}
}

type AggregationOp struct {
	Type aggregationpb.AggregationType `protobuf:"varint,1,opt,name=type,proto3,enum=aggregationpb.AggregationType" json:"type,omitempty"`
}

func (m *AggregationOp) Reset()                    { *m = AggregationOp{} }
func (m *AggregationOp) String() string            { return proto.CompactTextString(m) }
func (*AggregationOp) ProtoMessage()               {}
func (*AggregationOp) Descriptor() ([]byte, []int) { return fileDescriptorPipeline, []int{0} }

func (m *AggregationOp) GetType() aggregationpb.AggregationType {
	if m != nil {
		return m.Type
	}
	return aggregationpb.AggregationType_UNKNOWN
}

type TransformationOp struct {
	Type transformationpb.TransformationType `protobuf:"varint,1,opt,name=type,proto3,enum=transformationpb.TransformationType" json:"type,omitempty"`
}

func (m *TransformationOp) Reset()                    { *m = TransformationOp{} }
func (m *TransformationOp) String() string            { return proto.CompactTextString(m) }
func (*TransformationOp) ProtoMessage()               {}
func (*TransformationOp) Descriptor() ([]byte, []int) { return fileDescriptorPipeline, []int{1} }

func (m *TransformationOp) GetType() transformationpb.TransformationType {
	if m != nil {
		return m.Type
	}
	return transformationpb.TransformationType_UNKNOWN
}

type RollupOp struct {
	NewName          string                          `protobuf:"bytes,1,opt,name=new_name,json=newName,proto3" json:"new_name,omitempty"`
	Tags             []string                        `protobuf:"bytes,2,rep,name=tags" json:"tags,omitempty"`
	AggregationTypes []aggregationpb.AggregationType `protobuf:"varint,3,rep,packed,name=aggregation_types,json=aggregationTypes,enum=aggregationpb.AggregationType" json:"aggregation_types,omitempty"`
}

func (m *RollupOp) Reset()                    { *m = RollupOp{} }
func (m *RollupOp) String() string            { return proto.CompactTextString(m) }
func (*RollupOp) ProtoMessage()               {}
func (*RollupOp) Descriptor() ([]byte, []int) { return fileDescriptorPipeline, []int{2} }

func (m *RollupOp) GetNewName() string {
	if m != nil {
		return m.NewName
	}
	return ""
}

func (m *RollupOp) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *RollupOp) GetAggregationTypes() []aggregationpb.AggregationType {
	if m != nil {
		return m.AggregationTypes
	}
	return nil
}

type PipelineOp struct {
	Type           PipelineOp_Type   `protobuf:"varint,1,opt,name=type,proto3,enum=pipelinepb.PipelineOp_Type" json:"type,omitempty"`
	Aggregation    *AggregationOp    `protobuf:"bytes,2,opt,name=aggregation" json:"aggregation,omitempty"`
	Transformation *TransformationOp `protobuf:"bytes,3,opt,name=transformation" json:"transformation,omitempty"`
	Rollup         *RollupOp         `protobuf:"bytes,4,opt,name=rollup" json:"rollup,omitempty"`
}

func (m *PipelineOp) Reset()                    { *m = PipelineOp{} }
func (m *PipelineOp) String() string            { return proto.CompactTextString(m) }
func (*PipelineOp) ProtoMessage()               {}
func (*PipelineOp) Descriptor() ([]byte, []int) { return fileDescriptorPipeline, []int{3} }

func (m *PipelineOp) GetType() PipelineOp_Type {
	if m != nil {
		return m.Type
	}
	return PipelineOp_UNKNOWN
}

func (m *PipelineOp) GetAggregation() *AggregationOp {
	if m != nil {
		return m.Aggregation
	}
	return nil
}

func (m *PipelineOp) GetTransformation() *TransformationOp {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (m *PipelineOp) GetRollup() *RollupOp {
	if m != nil {
		return m.Rollup
	}
	return nil
}

type Pipeline struct {
	Ops []PipelineOp `protobuf:"bytes,1,rep,name=ops" json:"ops"`
}

func (m *Pipeline) Reset()                    { *m = Pipeline{} }
func (m *Pipeline) String() string            { return proto.CompactTextString(m) }
func (*Pipeline) ProtoMessage()               {}
func (*Pipeline) Descriptor() ([]byte, []int) { return fileDescriptorPipeline, []int{4} }

func (m *Pipeline) GetOps() []PipelineOp {
	if m != nil {
		return m.Ops
	}
	return nil
}

// AppliedRollupOp is a rollup operation that has been
// applied against a metric.
type AppliedRollupOp struct {
	Id            []byte                      `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	AggregationId aggregationpb.AggregationID `protobuf:"bytes,2,opt,name=aggregation_id,json=aggregationId" json:"aggregation_id"`
}

func (m *AppliedRollupOp) Reset()                    { *m = AppliedRollupOp{} }
func (m *AppliedRollupOp) String() string            { return proto.CompactTextString(m) }
func (*AppliedRollupOp) ProtoMessage()               {}
func (*AppliedRollupOp) Descriptor() ([]byte, []int) { return fileDescriptorPipeline, []int{5} }

func (m *AppliedRollupOp) GetId() []byte {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *AppliedRollupOp) GetAggregationId() aggregationpb.AggregationID {
	if m != nil {
		return m.AggregationId
	}
	return aggregationpb.AggregationID{}
}

// AppliedPipelineOp is a pipeline operation that has
// been applied against a metric.
type AppliedPipelineOp struct {
	Type           AppliedPipelineOp_Type `protobuf:"varint,1,opt,name=type,proto3,enum=pipelinepb.AppliedPipelineOp_Type" json:"type,omitempty"`
	Transformation *TransformationOp      `protobuf:"bytes,2,opt,name=transformation" json:"transformation,omitempty"`
	Rollup         *AppliedRollupOp       `protobuf:"bytes,3,opt,name=rollup" json:"rollup,omitempty"`
}

func (m *AppliedPipelineOp) Reset()                    { *m = AppliedPipelineOp{} }
func (m *AppliedPipelineOp) String() string            { return proto.CompactTextString(m) }
func (*AppliedPipelineOp) ProtoMessage()               {}
func (*AppliedPipelineOp) Descriptor() ([]byte, []int) { return fileDescriptorPipeline, []int{6} }

func (m *AppliedPipelineOp) GetType() AppliedPipelineOp_Type {
	if m != nil {
		return m.Type
	}
	return AppliedPipelineOp_UNKNOWN
}

func (m *AppliedPipelineOp) GetTransformation() *TransformationOp {
	if m != nil {
		return m.Transformation
	}
	return nil
}

func (m *AppliedPipelineOp) GetRollup() *AppliedRollupOp {
	if m != nil {
		return m.Rollup
	}
	return nil
}

// AppliedPipelineOp is a pipeline containing operations
// that have been applied against a metric.
type AppliedPipeline struct {
	Ops []AppliedPipelineOp `protobuf:"bytes,1,rep,name=ops" json:"ops"`
}

func (m *AppliedPipeline) Reset()                    { *m = AppliedPipeline{} }
func (m *AppliedPipeline) String() string            { return proto.CompactTextString(m) }
func (*AppliedPipeline) ProtoMessage()               {}
func (*AppliedPipeline) Descriptor() ([]byte, []int) { return fileDescriptorPipeline, []int{7} }

func (m *AppliedPipeline) GetOps() []AppliedPipelineOp {
	if m != nil {
		return m.Ops
	}
	return nil
}

func init() {
	proto.RegisterType((*AggregationOp)(nil), "pipelinepb.AggregationOp")
	proto.RegisterType((*TransformationOp)(nil), "pipelinepb.TransformationOp")
	proto.RegisterType((*RollupOp)(nil), "pipelinepb.RollupOp")
	proto.RegisterType((*PipelineOp)(nil), "pipelinepb.PipelineOp")
	proto.RegisterType((*Pipeline)(nil), "pipelinepb.Pipeline")
	proto.RegisterType((*AppliedRollupOp)(nil), "pipelinepb.AppliedRollupOp")
	proto.RegisterType((*AppliedPipelineOp)(nil), "pipelinepb.AppliedPipelineOp")
	proto.RegisterType((*AppliedPipeline)(nil), "pipelinepb.AppliedPipeline")
	proto.RegisterEnum("pipelinepb.PipelineOp_Type", PipelineOp_Type_name, PipelineOp_Type_value)
	proto.RegisterEnum("pipelinepb.AppliedPipelineOp_Type", AppliedPipelineOp_Type_name, AppliedPipelineOp_Type_value)
}
func (m *AggregationOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AggregationOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintPipeline(dAtA, i, uint64(m.Type))
	}
	return i, nil
}

func (m *TransformationOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransformationOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintPipeline(dAtA, i, uint64(m.Type))
	}
	return i, nil
}

func (m *RollupOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RollupOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NewName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintPipeline(dAtA, i, uint64(len(m.NewName)))
		i += copy(dAtA[i:], m.NewName)
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.AggregationTypes) > 0 {
		dAtA2 := make([]byte, len(m.AggregationTypes)*10)
		var j1 int
		for _, num := range m.AggregationTypes {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintPipeline(dAtA, i, uint64(j1))
		i += copy(dAtA[i:], dAtA2[:j1])
	}
	return i, nil
}

func (m *PipelineOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PipelineOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintPipeline(dAtA, i, uint64(m.Type))
	}
	if m.Aggregation != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintPipeline(dAtA, i, uint64(m.Aggregation.Size()))
		n3, err := m.Aggregation.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Transformation != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintPipeline(dAtA, i, uint64(m.Transformation.Size()))
		n4, err := m.Transformation.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Rollup != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintPipeline(dAtA, i, uint64(m.Rollup.Size()))
		n5, err := m.Rollup.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *Pipeline) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Pipeline) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ops) > 0 {
		for _, msg := range m.Ops {
			dAtA[i] = 0xa
			i++
			i = encodeVarintPipeline(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AppliedRollupOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AppliedRollupOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintPipeline(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintPipeline(dAtA, i, uint64(m.AggregationId.Size()))
	n6, err := m.AggregationId.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	return i, nil
}

func (m *AppliedPipelineOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AppliedPipelineOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintPipeline(dAtA, i, uint64(m.Type))
	}
	if m.Transformation != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintPipeline(dAtA, i, uint64(m.Transformation.Size()))
		n7, err := m.Transformation.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Rollup != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintPipeline(dAtA, i, uint64(m.Rollup.Size()))
		n8, err := m.Rollup.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}

func (m *AppliedPipeline) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AppliedPipeline) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ops) > 0 {
		for _, msg := range m.Ops {
			dAtA[i] = 0xa
			i++
			i = encodeVarintPipeline(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeVarintPipeline(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *AggregationOp) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovPipeline(uint64(m.Type))
	}
	return n
}

func (m *TransformationOp) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovPipeline(uint64(m.Type))
	}
	return n
}

func (m *RollupOp) Size() (n int) {
	var l int
	_ = l
	l = len(m.NewName)
	if l > 0 {
		n += 1 + l + sovPipeline(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovPipeline(uint64(l))
		}
	}
	if len(m.AggregationTypes) > 0 {
		l = 0
		for _, e := range m.AggregationTypes {
			l += sovPipeline(uint64(e))
		}
		n += 1 + sovPipeline(uint64(l)) + l
	}
	return n
}

func (m *PipelineOp) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovPipeline(uint64(m.Type))
	}
	if m.Aggregation != nil {
		l = m.Aggregation.Size()
		n += 1 + l + sovPipeline(uint64(l))
	}
	if m.Transformation != nil {
		l = m.Transformation.Size()
		n += 1 + l + sovPipeline(uint64(l))
	}
	if m.Rollup != nil {
		l = m.Rollup.Size()
		n += 1 + l + sovPipeline(uint64(l))
	}
	return n
}

func (m *Pipeline) Size() (n int) {
	var l int
	_ = l
	if len(m.Ops) > 0 {
		for _, e := range m.Ops {
			l = e.Size()
			n += 1 + l + sovPipeline(uint64(l))
		}
	}
	return n
}

func (m *AppliedRollupOp) Size() (n int) {
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovPipeline(uint64(l))
	}
	l = m.AggregationId.Size()
	n += 1 + l + sovPipeline(uint64(l))
	return n
}

func (m *AppliedPipelineOp) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovPipeline(uint64(m.Type))
	}
	if m.Transformation != nil {
		l = m.Transformation.Size()
		n += 1 + l + sovPipeline(uint64(l))
	}
	if m.Rollup != nil {
		l = m.Rollup.Size()
		n += 1 + l + sovPipeline(uint64(l))
	}
	return n
}

func (m *AppliedPipeline) Size() (n int) {
	var l int
	_ = l
	if len(m.Ops) > 0 {
		for _, e := range m.Ops {
			l = e.Size()
			n += 1 + l + sovPipeline(uint64(l))
		}
	}
	return n
}

func sovPipeline(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozPipeline(x uint64) (n int) {
	return sovPipeline(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *AggregationOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPipeline
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AggregationOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AggregationOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (aggregationpb.AggregationType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPipeline(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPipeline
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransformationOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPipeline
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransformationOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransformationOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (transformationpb.TransformationType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPipeline(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPipeline
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RollupOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPipeline
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RollupOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RollupOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPipeline
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NewName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPipeline
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType == 0 {
				var v aggregationpb.AggregationType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPipeline
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (aggregationpb.AggregationType(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.AggregationTypes = append(m.AggregationTypes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPipeline
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPipeline
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v aggregationpb.AggregationType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPipeline
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (aggregationpb.AggregationType(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.AggregationTypes = append(m.AggregationTypes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTypes", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPipeline(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPipeline
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PipelineOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPipeline
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PipelineOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PipelineOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (PipelineOp_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Aggregation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPipeline
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Aggregation == nil {
				m.Aggregation = &AggregationOp{}
			}
			if err := m.Aggregation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Transformation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPipeline
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Transformation == nil {
				m.Transformation = &TransformationOp{}
			}
			if err := m.Transformation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rollup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPipeline
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Rollup == nil {
				m.Rollup = &RollupOp{}
			}
			if err := m.Rollup.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPipeline(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPipeline
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Pipeline) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPipeline
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Pipeline: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Pipeline: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ops", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPipeline
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ops = append(m.Ops, PipelineOp{})
			if err := m.Ops[len(m.Ops)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPipeline(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPipeline
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AppliedRollupOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPipeline
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AppliedRollupOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AppliedRollupOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthPipeline
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = append(m.Id[:0], dAtA[iNdEx:postIndex]...)
			if m.Id == nil {
				m.Id = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPipeline
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AggregationId.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPipeline(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPipeline
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AppliedPipelineOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPipeline
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AppliedPipelineOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AppliedPipelineOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (AppliedPipelineOp_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Transformation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPipeline
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Transformation == nil {
				m.Transformation = &TransformationOp{}
			}
			if err := m.Transformation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rollup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPipeline
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Rollup == nil {
				m.Rollup = &AppliedRollupOp{}
			}
			if err := m.Rollup.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPipeline(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPipeline
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AppliedPipeline) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPipeline
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AppliedPipeline: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AppliedPipeline: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ops", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPipeline
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ops = append(m.Ops, AppliedPipelineOp{})
			if err := m.Ops[len(m.Ops)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPipeline(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPipeline
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPipeline(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPipeline
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPipeline
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthPipeline
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowPipeline
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipPipeline(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthPipeline = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPipeline   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("github.com/m3db/m3/src/metrics/generated/proto/pipelinepb/pipeline.proto", fileDescriptorPipeline)
}

var fileDescriptorPipeline = []byte{
	// 587 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x94, 0x4d, 0x6e, 0xd3, 0x40,
	0x1c, 0xc5, 0x3b, 0x76, 0x94, 0xa6, 0xff, 0xd0, 0x34, 0x1d, 0x21, 0xe4, 0x7e, 0x10, 0x22, 0x8b,
	0x45, 0x16, 0x60, 0x4b, 0x89, 0x40, 0x7c, 0xac, 0x52, 0x02, 0x69, 0x94, 0x60, 0x57, 0x43, 0x2a,
	0x24, 0x36, 0x95, 0x1d, 0x4f, 0x8d, 0xa5, 0xd8, 0x1e, 0xd9, 0x8e, 0xaa, 0x5e, 0x80, 0x35, 0x87,
	0xe1, 0x10, 0x5d, 0x72, 0x02, 0x84, 0xc2, 0x31, 0xd8, 0xa0, 0xd8, 0x4e, 0x32, 0x93, 0x04, 0x44,
	0xbb, 0x1b, 0x8f, 0xdf, 0x7b, 0xf3, 0x9f, 0xf7, 0xb3, 0x0c, 0xa7, 0xae, 0x97, 0x7c, 0x9e, 0xd8,
	0xda, 0x28, 0xf4, 0x75, 0xbf, 0xe5, 0xd8, 0xba, 0xdf, 0xd2, 0xe3, 0x68, 0xa4, 0xfb, 0x34, 0x89,
	0xbc, 0x51, 0xac, 0xbb, 0x34, 0xa0, 0x91, 0x95, 0x50, 0x47, 0x67, 0x51, 0x98, 0x84, 0x3a, 0xf3,
	0x18, 0x1d, 0x7b, 0x01, 0x65, 0xf6, 0x62, 0xa9, 0xa5, 0x6f, 0x30, 0x2c, 0x5f, 0x1d, 0x3e, 0xe5,
	0x52, 0xdd, 0xd0, 0x0d, 0x33, 0xb3, 0x3d, 0xb9, 0x4c, 0x9f, 0xb2, 0xa4, 0xd9, 0x2a, 0xb3, 0x1e,
	0x1a, 0xb7, 0x1c, 0xc2, 0x72, 0xdd, 0x88, 0xba, 0x56, 0xe2, 0x85, 0x01, 0xb3, 0xf9, 0xa7, 0x3c,
	0x6f, 0x78, 0xcb, 0xbc, 0x24, 0xb2, 0x82, 0xf8, 0x32, 0x8c, 0xfc, 0x79, 0xa4, 0xb8, 0x91, 0xa5,
	0xaa, 0x6f, 0x60, 0xb7, 0xbd, 0x3c, 0xca, 0x64, 0xb8, 0x09, 0x85, 0xe4, 0x9a, 0x51, 0x05, 0xd5,
	0x51, 0xa3, 0xd2, 0xac, 0x69, 0xc2, 0x58, 0x1a, 0xa7, 0x1d, 0x5e, 0x33, 0x4a, 0x52, 0xad, 0x3a,
	0x80, 0xea, 0x50, 0x08, 0x37, 0x19, 0x7e, 0x21, 0xe4, 0x3c, 0xd6, 0x56, 0xc7, 0xd1, 0x44, 0x07,
	0x97, 0xf6, 0x05, 0x41, 0x89, 0x84, 0xe3, 0xf1, 0x84, 0x99, 0x0c, 0x1f, 0x40, 0x29, 0xa0, 0x57,
	0x17, 0x81, 0xe5, 0x67, 0x51, 0x3b, 0x64, 0x3b, 0xa0, 0x57, 0x86, 0xe5, 0x53, 0x8c, 0xa1, 0x90,
	0x58, 0x6e, 0xac, 0x48, 0x75, 0xb9, 0xb1, 0x43, 0xd2, 0x35, 0xee, 0xc3, 0x3e, 0x37, 0xf0, 0xc5,
	0x2c, 0x2f, 0x56, 0xe4, 0xba, 0xfc, 0x1f, 0x57, 0xa9, 0x5a, 0xe2, 0x46, 0xac, 0x7e, 0x93, 0x00,
	0xce, 0x72, 0xfe, 0x26, 0xc3, 0xba, 0x70, 0xa3, 0x23, 0x6d, 0xf9, 0x69, 0x68, 0x4b, 0x95, 0xb6,
	0xbc, 0x08, 0x7e, 0x0d, 0x65, 0x2e, 0x53, 0x91, 0xea, 0xa8, 0x51, 0x6e, 0x1e, 0xf0, 0x3e, 0xa1,
	0x7a, 0xc2, 0xab, 0x71, 0x07, 0x2a, 0x62, 0x65, 0x8a, 0x9c, 0xfa, 0x8f, 0x79, 0xff, 0x6a, 0xeb,
	0x64, 0xc5, 0x83, 0x9f, 0x40, 0x31, 0x4a, 0xab, 0x54, 0x0a, 0xa9, 0xfb, 0x3e, 0xef, 0x9e, 0x97,
	0x4c, 0x72, 0x8d, 0xda, 0x81, 0xc2, 0x6c, 0x7c, 0x5c, 0x86, 0xed, 0x73, 0xa3, 0x6f, 0x98, 0x1f,
	0x8d, 0xea, 0x16, 0xde, 0x83, 0x72, 0xbb, 0xdb, 0x25, 0x6f, 0xbb, 0xed, 0x61, 0xcf, 0x34, 0xaa,
	0x08, 0x63, 0xa8, 0x0c, 0x49, 0xdb, 0xf8, 0xf0, 0xce, 0x24, 0xef, 0xb3, 0x3d, 0x09, 0x03, 0x14,
	0x89, 0x39, 0x18, 0x9c, 0x9f, 0x55, 0x65, 0xf5, 0x15, 0x94, 0xe6, 0x7d, 0x60, 0x0d, 0xe4, 0x90,
	0xc5, 0x0a, 0xaa, 0xcb, 0x8d, 0x72, 0xf3, 0xc1, 0xe6, 0xca, 0x4e, 0x0a, 0x37, 0x3f, 0x1e, 0x6d,
	0x91, 0x99, 0x50, 0x1d, 0xc3, 0x5e, 0x9b, 0xb1, 0xb1, 0x47, 0x9d, 0xc5, 0x17, 0x50, 0x01, 0xc9,
	0x73, 0xd2, 0xd2, 0xef, 0x11, 0xc9, 0x73, 0x70, 0x0f, 0x2a, 0x3c, 0x62, 0xcf, 0xc9, 0x8b, 0x3d,
	0xfe, 0x3b, 0xdf, 0x5e, 0x27, 0x3f, 0x63, 0x97, 0x93, 0xf4, 0x1c, 0xf5, 0x37, 0x82, 0xfd, 0xfc,
	0x38, 0x8e, 0xf3, 0x73, 0x81, 0xb3, 0x2a, 0xf0, 0x5a, 0x15, 0xf3, 0xb8, 0xd7, 0x89, 0x49, 0x77,
	0x20, 0xd6, 0x5a, 0x10, 0xcb, 0x78, 0x1f, 0x6d, 0x38, 0x7f, 0x0d, 0x5c, 0x6b, 0x13, 0xb8, 0x75,
	0x4e, 0x88, 0xe3, 0x24, 0xa9, 0xa7, 0x8b, 0xae, 0x17, 0xb8, 0x9e, 0xf1, 0xb8, 0x1e, 0xfe, 0xf3,
	0xe6, 0x1c, 0xb5, 0x93, 0xfe, 0xcd, 0xb4, 0x86, 0xbe, 0x4f, 0x6b, 0xe8, 0xe7, 0xb4, 0x86, 0xbe,
	0xfe, 0xaa, 0x6d, 0x7d, 0x7a, 0x79, 0xe7, 0x3f, 0xb0, 0x5d, 0x4c, 0x77, 0x5a, 0x7f, 0x02, 0x00,
	0x00, 0xff, 0xff, 0x26, 0x29, 0x00, 0xcc, 0xc5, 0x05, 0x00, 0x00,
}
