// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/m3db/m3/src/metrics/generated/proto/rulepb/rule.proto

// Copyright (c) 2018 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package rulepb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import aggregationpb "github.com/m3db/m3/src/metrics/generated/proto/aggregationpb"
import pipelinepb "github.com/m3db/m3/src/metrics/generated/proto/pipelinepb"
import policypb "github.com/m3db/m3/src/metrics/generated/proto/policypb"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type MappingRuleSnapshot struct {
	Name         string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Tombstoned   bool   `protobuf:"varint,2,opt,name=tombstoned,proto3" json:"tombstoned,omitempty"`
	CutoverNanos int64  `protobuf:"varint,3,opt,name=cutover_nanos,json=cutoverNanos,proto3" json:"cutover_nanos,omitempty"`
	Filter       string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// TODO(xichen): remove this and mark the field number reserved once all mapping rules are updated in KV.
	Policies           []*policypb.Policy              `protobuf:"bytes,5,rep,name=policies" json:"policies,omitempty"`
	LastUpdatedAtNanos int64                           `protobuf:"varint,6,opt,name=last_updated_at_nanos,json=lastUpdatedAtNanos,proto3" json:"last_updated_at_nanos,omitempty"`
	LastUpdatedBy      string                          `protobuf:"bytes,7,opt,name=last_updated_by,json=lastUpdatedBy,proto3" json:"last_updated_by,omitempty"`
	AggregationTypes   []aggregationpb.AggregationType `protobuf:"varint,8,rep,packed,name=aggregation_types,json=aggregationTypes,enum=aggregationpb.AggregationType" json:"aggregation_types,omitempty"`
	StoragePolicies    []*policypb.StoragePolicy       `protobuf:"bytes,9,rep,name=storage_policies,json=storagePolicies" json:"storage_policies,omitempty"`
	DropPolicy         policypb.DropPolicy             `protobuf:"varint,10,opt,name=drop_policy,json=dropPolicy,proto3,enum=policypb.DropPolicy" json:"drop_policy,omitempty"`
}

func (m *MappingRuleSnapshot) Reset()                    { *m = MappingRuleSnapshot{} }
func (m *MappingRuleSnapshot) String() string            { return proto.CompactTextString(m) }
func (*MappingRuleSnapshot) ProtoMessage()               {}
func (*MappingRuleSnapshot) Descriptor() ([]byte, []int) { return fileDescriptorRule, []int{0} }

func (m *MappingRuleSnapshot) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MappingRuleSnapshot) GetTombstoned() bool {
	if m != nil {
		return m.Tombstoned
	}
	return false
}

func (m *MappingRuleSnapshot) GetCutoverNanos() int64 {
	if m != nil {
		return m.CutoverNanos
	}
	return 0
}

func (m *MappingRuleSnapshot) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *MappingRuleSnapshot) GetPolicies() []*policypb.Policy {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *MappingRuleSnapshot) GetLastUpdatedAtNanos() int64 {
	if m != nil {
		return m.LastUpdatedAtNanos
	}
	return 0
}

func (m *MappingRuleSnapshot) GetLastUpdatedBy() string {
	if m != nil {
		return m.LastUpdatedBy
	}
	return ""
}

func (m *MappingRuleSnapshot) GetAggregationTypes() []aggregationpb.AggregationType {
	if m != nil {
		return m.AggregationTypes
	}
	return nil
}

func (m *MappingRuleSnapshot) GetStoragePolicies() []*policypb.StoragePolicy {
	if m != nil {
		return m.StoragePolicies
	}
	return nil
}

func (m *MappingRuleSnapshot) GetDropPolicy() policypb.DropPolicy {
	if m != nil {
		return m.DropPolicy
	}
	return policypb.DropPolicy_NONE
}

type MappingRule struct {
	Uuid      string                 `protobuf:"bytes,1,opt,name=uuid,proto3" json:"uuid,omitempty"`
	Snapshots []*MappingRuleSnapshot `protobuf:"bytes,2,rep,name=snapshots" json:"snapshots,omitempty"`
}

func (m *MappingRule) Reset()                    { *m = MappingRule{} }
func (m *MappingRule) String() string            { return proto.CompactTextString(m) }
func (*MappingRule) ProtoMessage()               {}
func (*MappingRule) Descriptor() ([]byte, []int) { return fileDescriptorRule, []int{1} }

func (m *MappingRule) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *MappingRule) GetSnapshots() []*MappingRuleSnapshot {
	if m != nil {
		return m.Snapshots
	}
	return nil
}

// TODO(xichen): remove this once all rules are updated in KV.
type RollupTarget struct {
	Name     string             `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Tags     []string           `protobuf:"bytes,2,rep,name=tags" json:"tags,omitempty"`
	Policies []*policypb.Policy `protobuf:"bytes,3,rep,name=policies" json:"policies,omitempty"`
}

func (m *RollupTarget) Reset()                    { *m = RollupTarget{} }
func (m *RollupTarget) String() string            { return proto.CompactTextString(m) }
func (*RollupTarget) ProtoMessage()               {}
func (*RollupTarget) Descriptor() ([]byte, []int) { return fileDescriptorRule, []int{2} }

func (m *RollupTarget) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RollupTarget) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *RollupTarget) GetPolicies() []*policypb.Policy {
	if m != nil {
		return m.Policies
	}
	return nil
}

// TODO(xichen): rename this once all rules are updated in KV.
type RollupTargetV2 struct {
	Pipeline        *pipelinepb.Pipeline      `protobuf:"bytes,1,opt,name=pipeline" json:"pipeline,omitempty"`
	StoragePolicies []*policypb.StoragePolicy `protobuf:"bytes,2,rep,name=storage_policies,json=storagePolicies" json:"storage_policies,omitempty"`
}

func (m *RollupTargetV2) Reset()                    { *m = RollupTargetV2{} }
func (m *RollupTargetV2) String() string            { return proto.CompactTextString(m) }
func (*RollupTargetV2) ProtoMessage()               {}
func (*RollupTargetV2) Descriptor() ([]byte, []int) { return fileDescriptorRule, []int{3} }

func (m *RollupTargetV2) GetPipeline() *pipelinepb.Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

func (m *RollupTargetV2) GetStoragePolicies() []*policypb.StoragePolicy {
	if m != nil {
		return m.StoragePolicies
	}
	return nil
}

type RollupRuleSnapshot struct {
	Name         string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Tombstoned   bool   `protobuf:"varint,2,opt,name=tombstoned,proto3" json:"tombstoned,omitempty"`
	CutoverNanos int64  `protobuf:"varint,3,opt,name=cutover_nanos,json=cutoverNanos,proto3" json:"cutover_nanos,omitempty"`
	Filter       string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// TODO(xichen): remove this and mark the field number reserved once all rollup rules are updated in KV.
	Targets            []*RollupTarget `protobuf:"bytes,5,rep,name=targets" json:"targets,omitempty"`
	LastUpdatedAtNanos int64           `protobuf:"varint,6,opt,name=last_updated_at_nanos,json=lastUpdatedAtNanos,proto3" json:"last_updated_at_nanos,omitempty"`
	LastUpdatedBy      string          `protobuf:"bytes,7,opt,name=last_updated_by,json=lastUpdatedBy,proto3" json:"last_updated_by,omitempty"`
	// TODO(xichen): rename this once all rules are updated in KV.
	TargetsV2 []*RollupTargetV2 `protobuf:"bytes,8,rep,name=targets_v2,json=targetsV2" json:"targets_v2,omitempty"`
}

func (m *RollupRuleSnapshot) Reset()                    { *m = RollupRuleSnapshot{} }
func (m *RollupRuleSnapshot) String() string            { return proto.CompactTextString(m) }
func (*RollupRuleSnapshot) ProtoMessage()               {}
func (*RollupRuleSnapshot) Descriptor() ([]byte, []int) { return fileDescriptorRule, []int{4} }

func (m *RollupRuleSnapshot) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RollupRuleSnapshot) GetTombstoned() bool {
	if m != nil {
		return m.Tombstoned
	}
	return false
}

func (m *RollupRuleSnapshot) GetCutoverNanos() int64 {
	if m != nil {
		return m.CutoverNanos
	}
	return 0
}

func (m *RollupRuleSnapshot) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *RollupRuleSnapshot) GetTargets() []*RollupTarget {
	if m != nil {
		return m.Targets
	}
	return nil
}

func (m *RollupRuleSnapshot) GetLastUpdatedAtNanos() int64 {
	if m != nil {
		return m.LastUpdatedAtNanos
	}
	return 0
}

func (m *RollupRuleSnapshot) GetLastUpdatedBy() string {
	if m != nil {
		return m.LastUpdatedBy
	}
	return ""
}

func (m *RollupRuleSnapshot) GetTargetsV2() []*RollupTargetV2 {
	if m != nil {
		return m.TargetsV2
	}
	return nil
}

type RollupRule struct {
	Uuid      string                `protobuf:"bytes,1,opt,name=uuid,proto3" json:"uuid,omitempty"`
	Snapshots []*RollupRuleSnapshot `protobuf:"bytes,2,rep,name=snapshots" json:"snapshots,omitempty"`
}

func (m *RollupRule) Reset()                    { *m = RollupRule{} }
func (m *RollupRule) String() string            { return proto.CompactTextString(m) }
func (*RollupRule) ProtoMessage()               {}
func (*RollupRule) Descriptor() ([]byte, []int) { return fileDescriptorRule, []int{5} }

func (m *RollupRule) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *RollupRule) GetSnapshots() []*RollupRuleSnapshot {
	if m != nil {
		return m.Snapshots
	}
	return nil
}

type RuleSet struct {
	Uuid               string         `protobuf:"bytes,1,opt,name=uuid,proto3" json:"uuid,omitempty"`
	Namespace          string         `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	CreatedAtNanos     int64          `protobuf:"varint,3,opt,name=created_at_nanos,json=createdAtNanos,proto3" json:"created_at_nanos,omitempty"`
	LastUpdatedAtNanos int64          `protobuf:"varint,4,opt,name=last_updated_at_nanos,json=lastUpdatedAtNanos,proto3" json:"last_updated_at_nanos,omitempty"`
	Tombstoned         bool           `protobuf:"varint,5,opt,name=tombstoned,proto3" json:"tombstoned,omitempty"`
	CutoverNanos       int64          `protobuf:"varint,6,opt,name=cutover_nanos,json=cutoverNanos,proto3" json:"cutover_nanos,omitempty"`
	MappingRules       []*MappingRule `protobuf:"bytes,7,rep,name=mapping_rules,json=mappingRules" json:"mapping_rules,omitempty"`
	RollupRules        []*RollupRule  `protobuf:"bytes,8,rep,name=rollup_rules,json=rollupRules" json:"rollup_rules,omitempty"`
	LastUpdatedBy      string         `protobuf:"bytes,9,opt,name=last_updated_by,json=lastUpdatedBy,proto3" json:"last_updated_by,omitempty"`
}

func (m *RuleSet) Reset()                    { *m = RuleSet{} }
func (m *RuleSet) String() string            { return proto.CompactTextString(m) }
func (*RuleSet) ProtoMessage()               {}
func (*RuleSet) Descriptor() ([]byte, []int) { return fileDescriptorRule, []int{6} }

func (m *RuleSet) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *RuleSet) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *RuleSet) GetCreatedAtNanos() int64 {
	if m != nil {
		return m.CreatedAtNanos
	}
	return 0
}

func (m *RuleSet) GetLastUpdatedAtNanos() int64 {
	if m != nil {
		return m.LastUpdatedAtNanos
	}
	return 0
}

func (m *RuleSet) GetTombstoned() bool {
	if m != nil {
		return m.Tombstoned
	}
	return false
}

func (m *RuleSet) GetCutoverNanos() int64 {
	if m != nil {
		return m.CutoverNanos
	}
	return 0
}

func (m *RuleSet) GetMappingRules() []*MappingRule {
	if m != nil {
		return m.MappingRules
	}
	return nil
}

func (m *RuleSet) GetRollupRules() []*RollupRule {
	if m != nil {
		return m.RollupRules
	}
	return nil
}

func (m *RuleSet) GetLastUpdatedBy() string {
	if m != nil {
		return m.LastUpdatedBy
	}
	return ""
}

func init() {
	proto.RegisterType((*MappingRuleSnapshot)(nil), "rulepb.MappingRuleSnapshot")
	proto.RegisterType((*MappingRule)(nil), "rulepb.MappingRule")
	proto.RegisterType((*RollupTarget)(nil), "rulepb.RollupTarget")
	proto.RegisterType((*RollupTargetV2)(nil), "rulepb.RollupTargetV2")
	proto.RegisterType((*RollupRuleSnapshot)(nil), "rulepb.RollupRuleSnapshot")
	proto.RegisterType((*RollupRule)(nil), "rulepb.RollupRule")
	proto.RegisterType((*RuleSet)(nil), "rulepb.RuleSet")
}
func (m *MappingRuleSnapshot) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MappingRuleSnapshot) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRule(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Tombstoned {
		dAtA[i] = 0x10
		i++
		if m.Tombstoned {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.CutoverNanos != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintRule(dAtA, i, uint64(m.CutoverNanos))
	}
	if len(m.Filter) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRule(dAtA, i, uint64(len(m.Filter)))
		i += copy(dAtA[i:], m.Filter)
	}
	if len(m.Policies) > 0 {
		for _, msg := range m.Policies {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintRule(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.LastUpdatedAtNanos != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintRule(dAtA, i, uint64(m.LastUpdatedAtNanos))
	}
	if len(m.LastUpdatedBy) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRule(dAtA, i, uint64(len(m.LastUpdatedBy)))
		i += copy(dAtA[i:], m.LastUpdatedBy)
	}
	if len(m.AggregationTypes) > 0 {
		dAtA2 := make([]byte, len(m.AggregationTypes)*10)
		var j1 int
		for _, num := range m.AggregationTypes {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		dAtA[i] = 0x42
		i++
		i = encodeVarintRule(dAtA, i, uint64(j1))
		i += copy(dAtA[i:], dAtA2[:j1])
	}
	if len(m.StoragePolicies) > 0 {
		for _, msg := range m.StoragePolicies {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintRule(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DropPolicy != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintRule(dAtA, i, uint64(m.DropPolicy))
	}
	return i, nil
}

func (m *MappingRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MappingRule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Uuid) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRule(dAtA, i, uint64(len(m.Uuid)))
		i += copy(dAtA[i:], m.Uuid)
	}
	if len(m.Snapshots) > 0 {
		for _, msg := range m.Snapshots {
			dAtA[i] = 0x12
			i++
			i = encodeVarintRule(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RollupTarget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RollupTarget) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRule(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Policies) > 0 {
		for _, msg := range m.Policies {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintRule(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RollupTargetV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RollupTargetV2) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Pipeline != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRule(dAtA, i, uint64(m.Pipeline.Size()))
		n3, err := m.Pipeline.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.StoragePolicies) > 0 {
		for _, msg := range m.StoragePolicies {
			dAtA[i] = 0x12
			i++
			i = encodeVarintRule(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RollupRuleSnapshot) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RollupRuleSnapshot) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRule(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Tombstoned {
		dAtA[i] = 0x10
		i++
		if m.Tombstoned {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.CutoverNanos != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintRule(dAtA, i, uint64(m.CutoverNanos))
	}
	if len(m.Filter) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRule(dAtA, i, uint64(len(m.Filter)))
		i += copy(dAtA[i:], m.Filter)
	}
	if len(m.Targets) > 0 {
		for _, msg := range m.Targets {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintRule(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.LastUpdatedAtNanos != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintRule(dAtA, i, uint64(m.LastUpdatedAtNanos))
	}
	if len(m.LastUpdatedBy) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRule(dAtA, i, uint64(len(m.LastUpdatedBy)))
		i += copy(dAtA[i:], m.LastUpdatedBy)
	}
	if len(m.TargetsV2) > 0 {
		for _, msg := range m.TargetsV2 {
			dAtA[i] = 0x42
			i++
			i = encodeVarintRule(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RollupRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RollupRule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Uuid) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRule(dAtA, i, uint64(len(m.Uuid)))
		i += copy(dAtA[i:], m.Uuid)
	}
	if len(m.Snapshots) > 0 {
		for _, msg := range m.Snapshots {
			dAtA[i] = 0x12
			i++
			i = encodeVarintRule(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RuleSet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuleSet) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Uuid) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRule(dAtA, i, uint64(len(m.Uuid)))
		i += copy(dAtA[i:], m.Uuid)
	}
	if len(m.Namespace) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRule(dAtA, i, uint64(len(m.Namespace)))
		i += copy(dAtA[i:], m.Namespace)
	}
	if m.CreatedAtNanos != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintRule(dAtA, i, uint64(m.CreatedAtNanos))
	}
	if m.LastUpdatedAtNanos != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintRule(dAtA, i, uint64(m.LastUpdatedAtNanos))
	}
	if m.Tombstoned {
		dAtA[i] = 0x28
		i++
		if m.Tombstoned {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.CutoverNanos != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintRule(dAtA, i, uint64(m.CutoverNanos))
	}
	if len(m.MappingRules) > 0 {
		for _, msg := range m.MappingRules {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintRule(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RollupRules) > 0 {
		for _, msg := range m.RollupRules {
			dAtA[i] = 0x42
			i++
			i = encodeVarintRule(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.LastUpdatedBy) > 0 {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintRule(dAtA, i, uint64(len(m.LastUpdatedBy)))
		i += copy(dAtA[i:], m.LastUpdatedBy)
	}
	return i, nil
}

func encodeVarintRule(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *MappingRuleSnapshot) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRule(uint64(l))
	}
	if m.Tombstoned {
		n += 2
	}
	if m.CutoverNanos != 0 {
		n += 1 + sovRule(uint64(m.CutoverNanos))
	}
	l = len(m.Filter)
	if l > 0 {
		n += 1 + l + sovRule(uint64(l))
	}
	if len(m.Policies) > 0 {
		for _, e := range m.Policies {
			l = e.Size()
			n += 1 + l + sovRule(uint64(l))
		}
	}
	if m.LastUpdatedAtNanos != 0 {
		n += 1 + sovRule(uint64(m.LastUpdatedAtNanos))
	}
	l = len(m.LastUpdatedBy)
	if l > 0 {
		n += 1 + l + sovRule(uint64(l))
	}
	if len(m.AggregationTypes) > 0 {
		l = 0
		for _, e := range m.AggregationTypes {
			l += sovRule(uint64(e))
		}
		n += 1 + sovRule(uint64(l)) + l
	}
	if len(m.StoragePolicies) > 0 {
		for _, e := range m.StoragePolicies {
			l = e.Size()
			n += 1 + l + sovRule(uint64(l))
		}
	}
	if m.DropPolicy != 0 {
		n += 1 + sovRule(uint64(m.DropPolicy))
	}
	return n
}

func (m *MappingRule) Size() (n int) {
	var l int
	_ = l
	l = len(m.Uuid)
	if l > 0 {
		n += 1 + l + sovRule(uint64(l))
	}
	if len(m.Snapshots) > 0 {
		for _, e := range m.Snapshots {
			l = e.Size()
			n += 1 + l + sovRule(uint64(l))
		}
	}
	return n
}

func (m *RollupTarget) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRule(uint64(l))
	}
	if len(m.Tags) > 0 {
		for _, s := range m.Tags {
			l = len(s)
			n += 1 + l + sovRule(uint64(l))
		}
	}
	if len(m.Policies) > 0 {
		for _, e := range m.Policies {
			l = e.Size()
			n += 1 + l + sovRule(uint64(l))
		}
	}
	return n
}

func (m *RollupTargetV2) Size() (n int) {
	var l int
	_ = l
	if m.Pipeline != nil {
		l = m.Pipeline.Size()
		n += 1 + l + sovRule(uint64(l))
	}
	if len(m.StoragePolicies) > 0 {
		for _, e := range m.StoragePolicies {
			l = e.Size()
			n += 1 + l + sovRule(uint64(l))
		}
	}
	return n
}

func (m *RollupRuleSnapshot) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRule(uint64(l))
	}
	if m.Tombstoned {
		n += 2
	}
	if m.CutoverNanos != 0 {
		n += 1 + sovRule(uint64(m.CutoverNanos))
	}
	l = len(m.Filter)
	if l > 0 {
		n += 1 + l + sovRule(uint64(l))
	}
	if len(m.Targets) > 0 {
		for _, e := range m.Targets {
			l = e.Size()
			n += 1 + l + sovRule(uint64(l))
		}
	}
	if m.LastUpdatedAtNanos != 0 {
		n += 1 + sovRule(uint64(m.LastUpdatedAtNanos))
	}
	l = len(m.LastUpdatedBy)
	if l > 0 {
		n += 1 + l + sovRule(uint64(l))
	}
	if len(m.TargetsV2) > 0 {
		for _, e := range m.TargetsV2 {
			l = e.Size()
			n += 1 + l + sovRule(uint64(l))
		}
	}
	return n
}

func (m *RollupRule) Size() (n int) {
	var l int
	_ = l
	l = len(m.Uuid)
	if l > 0 {
		n += 1 + l + sovRule(uint64(l))
	}
	if len(m.Snapshots) > 0 {
		for _, e := range m.Snapshots {
			l = e.Size()
			n += 1 + l + sovRule(uint64(l))
		}
	}
	return n
}

func (m *RuleSet) Size() (n int) {
	var l int
	_ = l
	l = len(m.Uuid)
	if l > 0 {
		n += 1 + l + sovRule(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovRule(uint64(l))
	}
	if m.CreatedAtNanos != 0 {
		n += 1 + sovRule(uint64(m.CreatedAtNanos))
	}
	if m.LastUpdatedAtNanos != 0 {
		n += 1 + sovRule(uint64(m.LastUpdatedAtNanos))
	}
	if m.Tombstoned {
		n += 2
	}
	if m.CutoverNanos != 0 {
		n += 1 + sovRule(uint64(m.CutoverNanos))
	}
	if len(m.MappingRules) > 0 {
		for _, e := range m.MappingRules {
			l = e.Size()
			n += 1 + l + sovRule(uint64(l))
		}
	}
	if len(m.RollupRules) > 0 {
		for _, e := range m.RollupRules {
			l = e.Size()
			n += 1 + l + sovRule(uint64(l))
		}
	}
	l = len(m.LastUpdatedBy)
	if l > 0 {
		n += 1 + l + sovRule(uint64(l))
	}
	return n
}

func sovRule(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozRule(x uint64) (n int) {
	return sovRule(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *MappingRuleSnapshot) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MappingRuleSnapshot: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MappingRuleSnapshot: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tombstoned", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Tombstoned = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CutoverNanos", wireType)
			}
			m.CutoverNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CutoverNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filter = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Policies = append(m.Policies, &policypb.Policy{})
			if err := m.Policies[len(m.Policies)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdatedAtNanos", wireType)
			}
			m.LastUpdatedAtNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastUpdatedAtNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdatedBy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastUpdatedBy = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType == 0 {
				var v aggregationpb.AggregationType
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRule
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (aggregationpb.AggregationType(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.AggregationTypes = append(m.AggregationTypes, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRule
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthRule
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v aggregationpb.AggregationType
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRule
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (aggregationpb.AggregationType(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.AggregationTypes = append(m.AggregationTypes, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTypes", wireType)
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoragePolicies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StoragePolicies = append(m.StoragePolicies, &policypb.StoragePolicy{})
			if err := m.StoragePolicies[len(m.StoragePolicies)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DropPolicy", wireType)
			}
			m.DropPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DropPolicy |= (policypb.DropPolicy(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MappingRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MappingRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MappingRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uuid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uuid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Snapshots", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Snapshots = append(m.Snapshots, &MappingRuleSnapshot{})
			if err := m.Snapshots[len(m.Snapshots)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RollupTarget) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RollupTarget: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RollupTarget: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Policies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Policies = append(m.Policies, &policypb.Policy{})
			if err := m.Policies[len(m.Policies)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RollupTargetV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RollupTargetV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RollupTargetV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pipeline", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Pipeline == nil {
				m.Pipeline = &pipelinepb.Pipeline{}
			}
			if err := m.Pipeline.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoragePolicies", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StoragePolicies = append(m.StoragePolicies, &policypb.StoragePolicy{})
			if err := m.StoragePolicies[len(m.StoragePolicies)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RollupRuleSnapshot) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RollupRuleSnapshot: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RollupRuleSnapshot: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tombstoned", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Tombstoned = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CutoverNanos", wireType)
			}
			m.CutoverNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CutoverNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filter = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Targets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Targets = append(m.Targets, &RollupTarget{})
			if err := m.Targets[len(m.Targets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdatedAtNanos", wireType)
			}
			m.LastUpdatedAtNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastUpdatedAtNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdatedBy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastUpdatedBy = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetsV2 = append(m.TargetsV2, &RollupTargetV2{})
			if err := m.TargetsV2[len(m.TargetsV2)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RollupRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RollupRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RollupRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uuid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uuid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Snapshots", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Snapshots = append(m.Snapshots, &RollupRuleSnapshot{})
			if err := m.Snapshots[len(m.Snapshots)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuleSet) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RuleSet: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RuleSet: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uuid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uuid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAtNanos", wireType)
			}
			m.CreatedAtNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CreatedAtNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdatedAtNanos", wireType)
			}
			m.LastUpdatedAtNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastUpdatedAtNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tombstoned", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Tombstoned = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CutoverNanos", wireType)
			}
			m.CutoverNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CutoverNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MappingRules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MappingRules = append(m.MappingRules, &MappingRule{})
			if err := m.MappingRules[len(m.MappingRules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RollupRules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RollupRules = append(m.RollupRules, &RollupRule{})
			if err := m.RollupRules[len(m.RollupRules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdatedBy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastUpdatedBy = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRule(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRule
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRule
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRule
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthRule
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowRule
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipRule(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthRule = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRule   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("github.com/m3db/m3/src/metrics/generated/proto/rulepb/rule.proto", fileDescriptorRule)
}

var fileDescriptorRule = []byte{
	// 702 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x55, 0x41, 0x6b, 0xdb, 0x4a,
	0x10, 0x7e, 0xb2, 0x1d, 0xdb, 0x1a, 0x3b, 0x8e, 0xdf, 0x26, 0x2f, 0x4f, 0xe4, 0x3d, 0x8c, 0x71,
	0xa1, 0xf8, 0x50, 0xe4, 0x56, 0x21, 0x90, 0xde, 0x9a, 0x10, 0x68, 0xa1, 0x34, 0x84, 0x4d, 0x9a,
	0x43, 0x28, 0x18, 0xd9, 0xda, 0x2a, 0x02, 0x49, 0xbb, 0xec, 0xae, 0x02, 0xfe, 0x03, 0x3d, 0xf7,
	0x5f, 0xb5, 0xc7, 0xde, 0x7a, 0x2d, 0xe9, 0x7f, 0xe8, 0xb9, 0x68, 0x57, 0xb2, 0x25, 0xa2, 0x10,
	0x5c, 0x28, 0x3d, 0x65, 0x76, 0x34, 0xfb, 0xed, 0xcc, 0xf7, 0x7d, 0x13, 0xc3, 0x0b, 0x3f, 0x90,
	0xd7, 0xc9, 0xcc, 0x9e, 0xd3, 0x68, 0x12, 0xed, 0x7b, 0xb3, 0x49, 0xb4, 0x3f, 0x11, 0x7c, 0x3e,
	0x89, 0x88, 0xe4, 0xc1, 0x5c, 0x4c, 0x7c, 0x12, 0x13, 0xee, 0x4a, 0xe2, 0x4d, 0x18, 0xa7, 0x92,
	0x4e, 0x78, 0x12, 0x12, 0x36, 0x53, 0x7f, 0x6c, 0x95, 0x41, 0x4d, 0x9d, 0xda, 0x3b, 0x5d, 0x13,
	0xc9, 0xf5, 0x7d, 0x4e, 0x7c, 0x57, 0x06, 0x34, 0x66, 0xb3, 0xe2, 0x49, 0xe3, 0xee, 0xbd, 0x5a,
	0x13, 0x8f, 0x05, 0x8c, 0x84, 0x41, 0x9c, 0x76, 0x97, 0x87, 0x19, 0xd2, 0xc9, 0xba, 0x48, 0x34,
	0x0c, 0xe6, 0x8b, 0x14, 0x47, 0x05, 0x1a, 0x65, 0xf4, 0xb5, 0x0e, 0xdb, 0x6f, 0x5c, 0xc6, 0x82,
	0xd8, 0xc7, 0x49, 0x48, 0xce, 0x63, 0x97, 0x89, 0x6b, 0x2a, 0x11, 0x82, 0x46, 0xec, 0x46, 0xc4,
	0x32, 0x86, 0xc6, 0xd8, 0xc4, 0x2a, 0x46, 0x03, 0x00, 0x49, 0xa3, 0x99, 0x90, 0x34, 0x26, 0x9e,
	0x55, 0x1b, 0x1a, 0xe3, 0x36, 0x2e, 0x64, 0xd0, 0x23, 0xd8, 0x9c, 0x27, 0x92, 0xde, 0x10, 0x3e,
	0x8d, 0xdd, 0x98, 0x0a, 0xab, 0x3e, 0x34, 0xc6, 0x75, 0xdc, 0xcd, 0x92, 0xa7, 0x69, 0x0e, 0xed,
	0x42, 0xf3, 0x7d, 0x10, 0x4a, 0xc2, 0xad, 0x86, 0x82, 0xce, 0x4e, 0xe8, 0x09, 0xb4, 0x55, 0x63,
	0x01, 0x11, 0xd6, 0xc6, 0xb0, 0x3e, 0xee, 0x38, 0x7d, 0x3b, 0x6f, 0xd9, 0x3e, 0x53, 0x01, 0x5e,
	0x56, 0xa0, 0x67, 0xf0, 0x4f, 0xe8, 0x0a, 0x39, 0x4d, 0x98, 0x97, 0x8e, 0x38, 0x75, 0x65, 0xf6,
	0x64, 0x53, 0x3d, 0x89, 0xd2, 0x8f, 0x6f, 0xf5, 0xb7, 0x23, 0xa9, 0x1f, 0x7e, 0x0c, 0x5b, 0xa5,
	0x2b, 0xb3, 0x85, 0xd5, 0x52, 0x1d, 0x6c, 0x16, 0x8a, 0x8f, 0x17, 0xe8, 0x35, 0xfc, 0x5d, 0x90,
	0x6d, 0x2a, 0x17, 0x8c, 0x08, 0xab, 0x3d, 0xac, 0x8f, 0x7b, 0xce, 0xc0, 0x2e, 0xc9, 0x6b, 0x1f,
	0xad, 0x4e, 0x17, 0x0b, 0x46, 0x70, 0xdf, 0x2d, 0x27, 0x04, 0x3a, 0x86, 0xbe, 0x90, 0x94, 0xbb,
	0x3e, 0x99, 0x2e, 0xa7, 0x33, 0xd5, 0x74, 0xff, 0xae, 0xa6, 0x3b, 0xd7, 0x15, 0xd9, 0x90, 0x5b,
	0xa2, 0x70, 0x4c, 0x67, 0x3d, 0x80, 0x8e, 0xc7, 0x29, 0xd3, 0x00, 0x0b, 0x0b, 0x86, 0xc6, 0xb8,
	0xe7, 0xec, 0xac, 0xae, 0x9f, 0x70, 0xca, 0xb2, 0xbb, 0xe0, 0x2d, 0xe3, 0xd1, 0x3b, 0xe8, 0x14,
	0x84, 0x4d, 0x05, 0x4d, 0x92, 0xc0, 0xcb, 0x05, 0x4d, 0x63, 0xf4, 0x1c, 0x4c, 0x91, 0x09, 0x2e,
	0xac, 0x9a, 0x6a, 0xeb, 0x3f, 0x5b, 0x1b, 0xdf, 0xae, 0x30, 0x05, 0x5e, 0x55, 0x8f, 0x3c, 0xe8,
	0x62, 0x1a, 0x86, 0x09, 0xbb, 0x70, 0xb9, 0x4f, 0xaa, 0xfd, 0x82, 0xa0, 0x21, 0x5d, 0x5f, 0x23,
	0x9b, 0x58, 0xc5, 0x25, 0x99, 0xeb, 0x0f, 0xc9, 0x3c, 0xfa, 0x60, 0x40, 0xaf, 0xf8, 0xcc, 0xa5,
	0x83, 0x9e, 0x42, 0x3b, 0x5f, 0x04, 0xf5, 0x58, 0x27, 0xa5, 0x62, 0xb9, 0x24, 0xf6, 0x59, 0x16,
	0xe2, 0x65, 0x55, 0xa5, 0x06, 0xb5, 0xf5, 0x34, 0x18, 0x7d, 0xaa, 0x01, 0xd2, 0x8d, 0xfc, 0xd9,
	0x2d, 0xb1, 0xa1, 0x25, 0x15, 0x13, 0xf9, 0x92, 0xec, 0xe4, 0x7a, 0x15, 0x69, 0xc2, 0x79, 0xd1,
	0xef, 0xdc, 0x93, 0x03, 0x80, 0xec, 0x95, 0xe9, 0x8d, 0xa3, 0x16, 0xa4, 0xe3, 0xec, 0x56, 0x75,
	0x73, 0xe9, 0x60, 0x33, 0xab, 0xbc, 0x74, 0x46, 0x57, 0x00, 0x2b, 0x22, 0x2b, 0x5d, 0x79, 0x78,
	0xd7, 0x95, 0x7b, 0x65, 0xdc, 0xfb, 0x4c, 0xf9, 0xa3, 0x06, 0x2d, 0xf5, 0x4d, 0x1b, 0xf2, 0x0e,
	0xf2, 0xff, 0x60, 0xa6, 0x12, 0x09, 0xe6, 0xce, 0x89, 0x52, 0xc6, 0xc4, 0xab, 0x04, 0x1a, 0x43,
	0x7f, 0xce, 0x49, 0x99, 0x26, 0xad, 0x4d, 0x2f, 0xcb, 0xe7, 0x14, 0xdd, 0xcb, 0x6a, 0xe3, 0x5e,
	0x56, 0xcb, 0xae, 0xd8, 0x78, 0xd8, 0x15, 0xcd, 0x0a, 0x57, 0x1c, 0xc2, 0x66, 0xa4, 0xd7, 0x72,
	0x9a, 0xf2, 0x21, 0xac, 0x96, 0x62, 0x67, 0xbb, 0x62, 0x67, 0x71, 0x37, 0x5a, 0x1d, 0xd2, 0xff,
	0x21, 0x5d, 0xae, 0xa8, 0xcb, 0x2e, 0x6a, 0xb9, 0xd0, 0x5d, 0x5a, 0x71, 0x87, 0x2f, 0xe3, 0x4a,
	0x2f, 0x98, 0x15, 0x5e, 0x38, 0x7e, 0xf9, 0xf9, 0x76, 0x60, 0x7c, 0xb9, 0x1d, 0x18, 0xdf, 0x6e,
	0x07, 0xc6, 0xc7, 0xef, 0x83, 0xbf, 0xae, 0x0e, 0x7e, 0xe9, 0x17, 0x78, 0xd6, 0x54, 0xa7, 0xfd,
	0x9f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x69, 0x70, 0x7f, 0x58, 0xc1, 0x07, 0x00, 0x00,
}
