// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/m3db/m3/src/query/generated/proto/admin/database.proto

// Copyright (c) 2019 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/*
	Package admin is a generated protocol buffer package.

	It is generated from these files:
		github.com/m3db/m3/src/query/generated/proto/admin/database.proto
		github.com/m3db/m3/src/query/generated/proto/admin/namespace.proto
		github.com/m3db/m3/src/query/generated/proto/admin/placement.proto
		github.com/m3db/m3/src/query/generated/proto/admin/topic.proto

	It has these top-level messages:
		DatabaseCreateRequest
		BlockSize
		Host
		DatabaseCreateResponse
		NamespaceGetResponse
		NamespaceAddRequest
		NamespaceSchemaAddRequest
		NamespaceSchemaAddResponse
		NamespaceSchemaResetRequest
		NamespaceSchemaResetResponse
		PlacementInitRequest
		PlacementGetResponse
		PlacementAddRequest
		PlacementReplaceRequest
		TopicGetResponse
		TopicInitRequest
		TopicAddRequest
*/
package admin

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type DatabaseCreateRequest struct {
	// Required fields
	NamespaceName string `protobuf:"bytes,1,opt,name=namespace_name,json=namespaceName,proto3" json:"namespace_name,omitempty"`
	Type          string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Optional fields that may be inferred depending on database type
	NumShards         int32 `protobuf:"varint,3,opt,name=num_shards,json=numShards,proto3" json:"num_shards,omitempty"`
	ReplicationFactor int32 `protobuf:"varint,4,opt,name=replication_factor,json=replicationFactor,proto3" json:"replication_factor,omitempty"`
	// Explicit retention time using time shorthand, e.g. "48h"
	RetentionTime string `protobuf:"bytes,5,opt,name=retention_time,json=retentionTime,proto3" json:"retention_time,omitempty"`
	// If no block size fields are set then the block size is
	// derived from the length of the retention period
	BlockSize *BlockSize `protobuf:"bytes,6,opt,name=block_size,json=blockSize" json:"block_size,omitempty"`
	// Required if not using local database type
	Hosts []*Host `protobuf:"bytes,7,rep,name=hosts" json:"hosts,omitempty"`
}

func (m *DatabaseCreateRequest) Reset()                    { *m = DatabaseCreateRequest{} }
func (m *DatabaseCreateRequest) String() string            { return proto.CompactTextString(m) }
func (*DatabaseCreateRequest) ProtoMessage()               {}
func (*DatabaseCreateRequest) Descriptor() ([]byte, []int) { return fileDescriptorDatabase, []int{0} }

func (m *DatabaseCreateRequest) GetNamespaceName() string {
	if m != nil {
		return m.NamespaceName
	}
	return ""
}

func (m *DatabaseCreateRequest) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *DatabaseCreateRequest) GetNumShards() int32 {
	if m != nil {
		return m.NumShards
	}
	return 0
}

func (m *DatabaseCreateRequest) GetReplicationFactor() int32 {
	if m != nil {
		return m.ReplicationFactor
	}
	return 0
}

func (m *DatabaseCreateRequest) GetRetentionTime() string {
	if m != nil {
		return m.RetentionTime
	}
	return ""
}

func (m *DatabaseCreateRequest) GetBlockSize() *BlockSize {
	if m != nil {
		return m.BlockSize
	}
	return nil
}

func (m *DatabaseCreateRequest) GetHosts() []*Host {
	if m != nil {
		return m.Hosts
	}
	return nil
}

type BlockSize struct {
	// Explicit block size using time shorthand, e.g. "2h"
	Time string `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// With the expected series datapoints per hour, use a recommended block size
	ExpectedSeriesDatapointsPerHour int64 `protobuf:"varint,2,opt,name=expected_series_datapoints_per_hour,json=expectedSeriesDatapointsPerHour,proto3" json:"expected_series_datapoints_per_hour,omitempty"`
}

func (m *BlockSize) Reset()                    { *m = BlockSize{} }
func (m *BlockSize) String() string            { return proto.CompactTextString(m) }
func (*BlockSize) ProtoMessage()               {}
func (*BlockSize) Descriptor() ([]byte, []int) { return fileDescriptorDatabase, []int{1} }

func (m *BlockSize) GetTime() string {
	if m != nil {
		return m.Time
	}
	return ""
}

func (m *BlockSize) GetExpectedSeriesDatapointsPerHour() int64 {
	if m != nil {
		return m.ExpectedSeriesDatapointsPerHour
	}
	return 0
}

type Host struct {
	// Name (must be unique) of the host for logging/display purposes, can be hostname if desired,
	// or UUID or any other string ID as used in third party inventory system
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Address can be IP address or hostname, this is used to connect to the host
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Port running the Node RPC listen address (currently TChannel/Thrift Node service)
	Port uint32 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	// (Optional) Isolation group is an optional grouping, for instance to isolate replicas by
	// zones use zone here, or to isolate by host racks use racks here
	IsolationGroup string `protobuf:"bytes,4,opt,name=isolation_group,json=isolationGroup,proto3" json:"isolation_group,omitempty"`
	// (Optional) Zone specifies the zone the host resides in, this is optional.
	Zone string `protobuf:"bytes,5,opt,name=zone,proto3" json:"zone,omitempty"`
	// (Optional) Weight specifies when considering how many shards to take how to weight
	// this instance, do not specify to default to a weight of 1.
	Weight uint32 `protobuf:"varint,6,opt,name=weight,proto3" json:"weight,omitempty"`
}

func (m *Host) Reset()                    { *m = Host{} }
func (m *Host) String() string            { return proto.CompactTextString(m) }
func (*Host) ProtoMessage()               {}
func (*Host) Descriptor() ([]byte, []int) { return fileDescriptorDatabase, []int{2} }

func (m *Host) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Host) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Host) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Host) GetIsolationGroup() string {
	if m != nil {
		return m.IsolationGroup
	}
	return ""
}

func (m *Host) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Host) GetWeight() uint32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

type DatabaseCreateResponse struct {
	Namespace *NamespaceGetResponse `protobuf:"bytes,1,opt,name=namespace" json:"namespace,omitempty"`
	Placement *PlacementGetResponse `protobuf:"bytes,2,opt,name=placement" json:"placement,omitempty"`
}

func (m *DatabaseCreateResponse) Reset()                    { *m = DatabaseCreateResponse{} }
func (m *DatabaseCreateResponse) String() string            { return proto.CompactTextString(m) }
func (*DatabaseCreateResponse) ProtoMessage()               {}
func (*DatabaseCreateResponse) Descriptor() ([]byte, []int) { return fileDescriptorDatabase, []int{3} }

func (m *DatabaseCreateResponse) GetNamespace() *NamespaceGetResponse {
	if m != nil {
		return m.Namespace
	}
	return nil
}

func (m *DatabaseCreateResponse) GetPlacement() *PlacementGetResponse {
	if m != nil {
		return m.Placement
	}
	return nil
}

func init() {
	proto.RegisterType((*DatabaseCreateRequest)(nil), "admin.DatabaseCreateRequest")
	proto.RegisterType((*BlockSize)(nil), "admin.BlockSize")
	proto.RegisterType((*Host)(nil), "admin.Host")
	proto.RegisterType((*DatabaseCreateResponse)(nil), "admin.DatabaseCreateResponse")
}
func (m *DatabaseCreateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseCreateRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NamespaceName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.NamespaceName)))
		i += copy(dAtA[i:], m.NamespaceName)
	}
	if len(m.Type) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	if m.NumShards != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(m.NumShards))
	}
	if m.ReplicationFactor != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(m.ReplicationFactor))
	}
	if len(m.RetentionTime) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.RetentionTime)))
		i += copy(dAtA[i:], m.RetentionTime)
	}
	if m.BlockSize != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(m.BlockSize.Size()))
		n1, err := m.BlockSize.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.Hosts) > 0 {
		for _, msg := range m.Hosts {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintDatabase(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *BlockSize) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BlockSize) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Time) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.Time)))
		i += copy(dAtA[i:], m.Time)
	}
	if m.ExpectedSeriesDatapointsPerHour != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(m.ExpectedSeriesDatapointsPerHour))
	}
	return i, nil
}

func (m *Host) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Host) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Address) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.Address)))
		i += copy(dAtA[i:], m.Address)
	}
	if m.Port != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(m.Port))
	}
	if len(m.IsolationGroup) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.IsolationGroup)))
		i += copy(dAtA[i:], m.IsolationGroup)
	}
	if len(m.Zone) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.Zone)))
		i += copy(dAtA[i:], m.Zone)
	}
	if m.Weight != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(m.Weight))
	}
	return i, nil
}

func (m *DatabaseCreateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseCreateResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Namespace != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(m.Namespace.Size()))
		n2, err := m.Namespace.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Placement != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintDatabase(dAtA, i, uint64(m.Placement.Size()))
		n3, err := m.Placement.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}

func encodeVarintDatabase(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *DatabaseCreateRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NamespaceName)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	if m.NumShards != 0 {
		n += 1 + sovDatabase(uint64(m.NumShards))
	}
	if m.ReplicationFactor != 0 {
		n += 1 + sovDatabase(uint64(m.ReplicationFactor))
	}
	l = len(m.RetentionTime)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	if m.BlockSize != nil {
		l = m.BlockSize.Size()
		n += 1 + l + sovDatabase(uint64(l))
	}
	if len(m.Hosts) > 0 {
		for _, e := range m.Hosts {
			l = e.Size()
			n += 1 + l + sovDatabase(uint64(l))
		}
	}
	return n
}

func (m *BlockSize) Size() (n int) {
	var l int
	_ = l
	l = len(m.Time)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	if m.ExpectedSeriesDatapointsPerHour != 0 {
		n += 1 + sovDatabase(uint64(m.ExpectedSeriesDatapointsPerHour))
	}
	return n
}

func (m *Host) Size() (n int) {
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovDatabase(uint64(m.Port))
	}
	l = len(m.IsolationGroup)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	l = len(m.Zone)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	if m.Weight != 0 {
		n += 1 + sovDatabase(uint64(m.Weight))
	}
	return n
}

func (m *DatabaseCreateResponse) Size() (n int) {
	var l int
	_ = l
	if m.Namespace != nil {
		l = m.Namespace.Size()
		n += 1 + l + sovDatabase(uint64(l))
	}
	if m.Placement != nil {
		l = m.Placement.Size()
		n += 1 + l + sovDatabase(uint64(l))
	}
	return n
}

func sovDatabase(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozDatabase(x uint64) (n int) {
	return sovDatabase(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *DatabaseCreateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabaseCreateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabaseCreateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamespaceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NamespaceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumShards", wireType)
			}
			m.NumShards = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumShards |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationFactor", wireType)
			}
			m.ReplicationFactor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicationFactor |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetentionTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RetentionTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BlockSize == nil {
				m.BlockSize = &BlockSize{}
			}
			if err := m.BlockSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hosts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hosts = append(m.Hosts, &Host{})
			if err := m.Hosts[len(m.Hosts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BlockSize) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BlockSize: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BlockSize: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Time = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpectedSeriesDatapointsPerHour", wireType)
			}
			m.ExpectedSeriesDatapointsPerHour = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExpectedSeriesDatapointsPerHour |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Host) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Host: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Host: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsolationGroup", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IsolationGroup = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Zone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Zone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			m.Weight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Weight |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DatabaseCreateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabaseCreateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabaseCreateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Namespace == nil {
				m.Namespace = &NamespaceGetResponse{}
			}
			if err := m.Namespace.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Placement", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Placement == nil {
				m.Placement = &PlacementGetResponse{}
			}
			if err := m.Placement.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDatabase(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthDatabase
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowDatabase
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipDatabase(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthDatabase = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDatabase   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("github.com/m3db/m3/src/query/generated/proto/admin/database.proto", fileDescriptorDatabase)
}

var fileDescriptorDatabase = []byte{
	// 510 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x52, 0xcb, 0x6e, 0xd3, 0x40,
	0x14, 0xc5, 0x79, 0x55, 0x9e, 0x28, 0xa1, 0x8c, 0x44, 0x65, 0x81, 0x08, 0x21, 0x08, 0x91, 0x0d,
	0xb1, 0x94, 0xac, 0x58, 0x12, 0x2a, 0xda, 0x05, 0xaa, 0x2a, 0x87, 0xbd, 0x35, 0xb6, 0x2f, 0xc9,
	0x88, 0xcc, 0xa3, 0x33, 0x63, 0x41, 0xf3, 0x11, 0x88, 0x2d, 0xe2, 0x87, 0x58, 0xf2, 0x09, 0x28,
	0xfc, 0x08, 0xf2, 0x8d, 0x3d, 0x85, 0x2e, 0xbb, 0x3b, 0x73, 0xee, 0xb9, 0xaf, 0x33, 0x97, 0xbc,
	0x59, 0x73, 0xb7, 0x29, 0xb3, 0x59, 0xae, 0x44, 0x2c, 0x16, 0x45, 0x16, 0x8b, 0x45, 0x6c, 0x4d,
	0x1e, 0x5f, 0x95, 0x60, 0xae, 0xe3, 0x35, 0x48, 0x30, 0xcc, 0x41, 0x11, 0x6b, 0xa3, 0x9c, 0x8a,
	0x59, 0x21, 0xb8, 0x8c, 0x0b, 0xe6, 0x58, 0xc6, 0x2c, 0xcc, 0x90, 0xa4, 0x5d, 0x64, 0x1f, 0x2d,
	0xef, 0x50, 0x49, 0x32, 0x01, 0x56, 0xb3, 0xbc, 0x2e, 0x75, 0xa7, 0x1a, 0x7a, 0xcb, 0x72, 0x10,
	0x20, 0xdd, 0xa1, 0xc6, 0xe4, 0x47, 0x8b, 0x3c, 0x3c, 0xad, 0x27, 0x7c, 0x6b, 0x80, 0x39, 0x48,
	0xe0, 0xaa, 0x04, 0xeb, 0xe8, 0x0b, 0x32, 0xf4, 0x0d, 0xd3, 0x0a, 0x45, 0xc1, 0x38, 0x98, 0x86,
	0xc9, 0xc0, 0xb3, 0x17, 0x4c, 0x00, 0xa5, 0xa4, 0xe3, 0xae, 0x35, 0x44, 0x2d, 0x0c, 0x22, 0xa6,
	0x4f, 0x08, 0x91, 0xa5, 0x48, 0xed, 0x86, 0x99, 0xc2, 0x46, 0xed, 0x71, 0x30, 0xed, 0x26, 0xa1,
	0x2c, 0xc5, 0x0a, 0x09, 0xfa, 0x8a, 0x50, 0x03, 0x7a, 0xcb, 0x73, 0xe6, 0xb8, 0x92, 0xe9, 0x47,
	0x96, 0x3b, 0x65, 0xa2, 0x0e, 0xca, 0x1e, 0xfc, 0x13, 0x79, 0x87, 0x81, 0x6a, 0x10, 0x03, 0x0e,
	0x24, 0x8a, 0x1d, 0x17, 0x10, 0x75, 0x0f, 0x83, 0x78, 0xf6, 0x03, 0x17, 0x40, 0x63, 0x42, 0xb2,
	0xad, 0xca, 0x3f, 0xa5, 0x96, 0xef, 0x20, 0xea, 0x8d, 0x83, 0x69, 0x7f, 0x7e, 0x3c, 0xc3, 0xad,
	0x67, 0xcb, 0x2a, 0xb0, 0xe2, 0x3b, 0x48, 0xc2, 0xac, 0x81, 0xf4, 0x19, 0xe9, 0x6e, 0x94, 0x75,
	0x36, 0x3a, 0x1a, 0xb7, 0xa7, 0xfd, 0x79, 0xbf, 0xd6, 0x9e, 0x2b, 0xeb, 0x92, 0x43, 0x64, 0x22,
	0x48, 0xe8, 0x53, 0x71, 0x53, 0xee, 0x6d, 0x40, 0x4c, 0xdf, 0x93, 0xe7, 0xf0, 0x45, 0x43, 0xee,
	0xa0, 0x48, 0x2d, 0x18, 0x0e, 0x36, 0xad, 0xfe, 0x5b, 0x2b, 0x2e, 0x9d, 0x4d, 0x35, 0x98, 0x74,
	0xa3, 0x4a, 0x83, 0xe6, 0xb4, 0x93, 0xa7, 0x8d, 0x74, 0x85, 0xca, 0x53, 0x2f, 0xbc, 0x04, 0x73,
	0xae, 0x4a, 0x33, 0xf9, 0x1e, 0x90, 0x4e, 0xd5, 0x9e, 0x0e, 0x49, 0x8b, 0x17, 0x75, 0xa3, 0x16,
	0x2f, 0x68, 0x44, 0x8e, 0x58, 0x51, 0x18, 0xb0, 0xb6, 0xf6, 0xb9, 0x79, 0x56, 0x43, 0x69, 0x65,
	0x1c, 0x9a, 0x3c, 0x48, 0x10, 0xd3, 0x97, 0xe4, 0x3e, 0xb7, 0x6a, 0x7b, 0x70, 0x77, 0x6d, 0x54,
	0xa9, 0xd1, 0xdc, 0x30, 0x19, 0x7a, 0xfa, 0xac, 0x62, 0xab, 0xe4, 0x9d, 0x92, 0x8d, 0x9f, 0x88,
	0xe9, 0x09, 0xe9, 0x7d, 0x06, 0xbe, 0xde, 0x38, 0xb4, 0x70, 0x90, 0xd4, 0xaf, 0xc9, 0xd7, 0x80,
	0x9c, 0xdc, 0x3e, 0x14, 0xab, 0x95, 0xb4, 0x40, 0x5f, 0x93, 0xd0, 0xdf, 0x04, 0x0e, 0xdd, 0x9f,
	0x3f, 0xae, 0xcd, 0xbc, 0x68, 0xf8, 0x33, 0x70, 0x8d, 0x3e, 0xb9, 0x51, 0x57, 0xa9, 0xfe, 0x22,
	0x71, 0xb5, 0x9b, 0xd4, 0xcb, 0x86, 0xff, 0x2f, 0xd5, 0xab, 0x97, 0xc7, 0x3f, 0xf7, 0xa3, 0xe0,
	0xd7, 0x7e, 0x14, 0xfc, 0xde, 0x8f, 0x82, 0x6f, 0x7f, 0x46, 0xf7, 0xb2, 0x1e, 0x9e, 0xf4, 0xe2,
	0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xc2, 0xec, 0x9c, 0x42, 0xa6, 0x03, 0x00, 0x00,
}
