// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/m3db/m3/src/query/generated/proto/admin/placement.proto

// Copyright (c) 2018 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package admin

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import placementpb "github.com/m3db/m3/src/cluster/generated/proto/placementpb"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type PlacementInitRequest struct {
	Instances         []*placementpb.Instance `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
	NumShards         int32                   `protobuf:"varint,2,opt,name=num_shards,json=numShards,proto3" json:"num_shards,omitempty"`
	ReplicationFactor int32                   `protobuf:"varint,3,opt,name=replication_factor,json=replicationFactor,proto3" json:"replication_factor,omitempty"`
}

func (m *PlacementInitRequest) Reset()                    { *m = PlacementInitRequest{} }
func (m *PlacementInitRequest) String() string            { return proto.CompactTextString(m) }
func (*PlacementInitRequest) ProtoMessage()               {}
func (*PlacementInitRequest) Descriptor() ([]byte, []int) { return fileDescriptorPlacement, []int{0} }

func (m *PlacementInitRequest) GetInstances() []*placementpb.Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *PlacementInitRequest) GetNumShards() int32 {
	if m != nil {
		return m.NumShards
	}
	return 0
}

func (m *PlacementInitRequest) GetReplicationFactor() int32 {
	if m != nil {
		return m.ReplicationFactor
	}
	return 0
}

type PlacementGetResponse struct {
	Placement *placementpb.Placement `protobuf:"bytes,1,opt,name=placement" json:"placement,omitempty"`
	Version   int32                  `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (m *PlacementGetResponse) Reset()                    { *m = PlacementGetResponse{} }
func (m *PlacementGetResponse) String() string            { return proto.CompactTextString(m) }
func (*PlacementGetResponse) ProtoMessage()               {}
func (*PlacementGetResponse) Descriptor() ([]byte, []int) { return fileDescriptorPlacement, []int{1} }

func (m *PlacementGetResponse) GetPlacement() *placementpb.Placement {
	if m != nil {
		return m.Placement
	}
	return nil
}

func (m *PlacementGetResponse) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

type PlacementAddRequest struct {
	Instances []*placementpb.Instance `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
	// By default add requests will only succeed if all instances in the placement
	// are AVAILABLE for all their shards. force overrides that.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (m *PlacementAddRequest) Reset()                    { *m = PlacementAddRequest{} }
func (m *PlacementAddRequest) String() string            { return proto.CompactTextString(m) }
func (*PlacementAddRequest) ProtoMessage()               {}
func (*PlacementAddRequest) Descriptor() ([]byte, []int) { return fileDescriptorPlacement, []int{2} }

func (m *PlacementAddRequest) GetInstances() []*placementpb.Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *PlacementAddRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

type PlacementReplaceRequest struct {
	LeavingInstanceIDs []string                `protobuf:"bytes,1,rep,name=leavingInstanceIDs" json:"leavingInstanceIDs,omitempty"`
	Candidates         []*placementpb.Instance `protobuf:"bytes,2,rep,name=candidates" json:"candidates,omitempty"`
	Force              bool                    `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (m *PlacementReplaceRequest) Reset()                    { *m = PlacementReplaceRequest{} }
func (m *PlacementReplaceRequest) String() string            { return proto.CompactTextString(m) }
func (*PlacementReplaceRequest) ProtoMessage()               {}
func (*PlacementReplaceRequest) Descriptor() ([]byte, []int) { return fileDescriptorPlacement, []int{3} }

func (m *PlacementReplaceRequest) GetLeavingInstanceIDs() []string {
	if m != nil {
		return m.LeavingInstanceIDs
	}
	return nil
}

func (m *PlacementReplaceRequest) GetCandidates() []*placementpb.Instance {
	if m != nil {
		return m.Candidates
	}
	return nil
}

func (m *PlacementReplaceRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func init() {
	proto.RegisterType((*PlacementInitRequest)(nil), "admin.PlacementInitRequest")
	proto.RegisterType((*PlacementGetResponse)(nil), "admin.PlacementGetResponse")
	proto.RegisterType((*PlacementAddRequest)(nil), "admin.PlacementAddRequest")
	proto.RegisterType((*PlacementReplaceRequest)(nil), "admin.PlacementReplaceRequest")
}
func (m *PlacementInitRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PlacementInitRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, msg := range m.Instances {
			dAtA[i] = 0xa
			i++
			i = encodeVarintPlacement(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.NumShards != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.NumShards))
	}
	if m.ReplicationFactor != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.ReplicationFactor))
	}
	return i, nil
}

func (m *PlacementGetResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PlacementGetResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Placement != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.Placement.Size()))
		n1, err := m.Placement.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Version != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintPlacement(dAtA, i, uint64(m.Version))
	}
	return i, nil
}

func (m *PlacementAddRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PlacementAddRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, msg := range m.Instances {
			dAtA[i] = 0xa
			i++
			i = encodeVarintPlacement(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Force {
		dAtA[i] = 0x10
		i++
		if m.Force {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *PlacementReplaceRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PlacementReplaceRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.LeavingInstanceIDs) > 0 {
		for _, s := range m.LeavingInstanceIDs {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Candidates) > 0 {
		for _, msg := range m.Candidates {
			dAtA[i] = 0x12
			i++
			i = encodeVarintPlacement(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Force {
		dAtA[i] = 0x18
		i++
		if m.Force {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func encodeVarintPlacement(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *PlacementInitRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovPlacement(uint64(l))
		}
	}
	if m.NumShards != 0 {
		n += 1 + sovPlacement(uint64(m.NumShards))
	}
	if m.ReplicationFactor != 0 {
		n += 1 + sovPlacement(uint64(m.ReplicationFactor))
	}
	return n
}

func (m *PlacementGetResponse) Size() (n int) {
	var l int
	_ = l
	if m.Placement != nil {
		l = m.Placement.Size()
		n += 1 + l + sovPlacement(uint64(l))
	}
	if m.Version != 0 {
		n += 1 + sovPlacement(uint64(m.Version))
	}
	return n
}

func (m *PlacementAddRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovPlacement(uint64(l))
		}
	}
	if m.Force {
		n += 2
	}
	return n
}

func (m *PlacementReplaceRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.LeavingInstanceIDs) > 0 {
		for _, s := range m.LeavingInstanceIDs {
			l = len(s)
			n += 1 + l + sovPlacement(uint64(l))
		}
	}
	if len(m.Candidates) > 0 {
		for _, e := range m.Candidates {
			l = e.Size()
			n += 1 + l + sovPlacement(uint64(l))
		}
	}
	if m.Force {
		n += 2
	}
	return n
}

func sovPlacement(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozPlacement(x uint64) (n int) {
	return sovPlacement(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *PlacementInitRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlacement
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlacementInitRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlacementInitRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &placementpb.Instance{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumShards", wireType)
			}
			m.NumShards = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumShards |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicationFactor", wireType)
			}
			m.ReplicationFactor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicationFactor |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlacement(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlacement
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PlacementGetResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlacement
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlacementGetResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlacementGetResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Placement", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Placement == nil {
				m.Placement = &placementpb.Placement{}
			}
			if err := m.Placement.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPlacement(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlacement
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PlacementAddRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlacement
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlacementAddRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlacementAddRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &placementpb.Instance{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Force = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipPlacement(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlacement
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PlacementReplaceRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlacement
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlacementReplaceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlacementReplaceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeavingInstanceIDs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LeavingInstanceIDs = append(m.LeavingInstanceIDs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Candidates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlacement
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Candidates = append(m.Candidates, &placementpb.Instance{})
			if err := m.Candidates[len(m.Candidates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Force = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipPlacement(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlacement
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPlacement(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPlacement
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPlacement
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthPlacement
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowPlacement
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipPlacement(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthPlacement = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPlacement   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("github.com/m3db/m3/src/query/generated/proto/admin/placement.proto", fileDescriptorPlacement)
}

var fileDescriptorPlacement = []byte{
	// 365 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x92, 0xcd, 0x8e, 0xd3, 0x30,
	0x14, 0x85, 0x31, 0x55, 0x81, 0xb8, 0x1b, 0x30, 0x05, 0x22, 0x24, 0xa2, 0x2a, 0xab, 0x6e, 0x88,
	0xa5, 0x06, 0x1e, 0x80, 0x0a, 0x81, 0xca, 0x0a, 0x85, 0x07, 0x28, 0x8e, 0x7d, 0xdb, 0x5a, 0x4a,
	0xec, 0xd4, 0x76, 0x2a, 0xf1, 0x16, 0xac, 0x46, 0x9a, 0x37, 0x9a, 0xe5, 0x3c, 0xc2, 0xa8, 0xf3,
	0x22, 0xa3, 0x71, 0x9b, 0x9f, 0xf9, 0xdd, 0xcc, 0xd2, 0xe7, 0x9c, 0x7b, 0xee, 0xa7, 0x2b, 0xe3,
	0xf9, 0x5a, 0xba, 0x4d, 0x9d, 0x27, 0x5c, 0x97, 0xb4, 0x4c, 0x45, 0x4e, 0xcb, 0x94, 0x5a, 0xc3,
	0xe9, 0xb6, 0x06, 0xf3, 0x8f, 0xae, 0x41, 0x81, 0x61, 0x0e, 0x04, 0xad, 0x8c, 0x76, 0x9a, 0x32,
	0x51, 0x4a, 0x45, 0xab, 0x82, 0x71, 0x28, 0x41, 0xb9, 0xc4, 0xab, 0x64, 0xe8, 0xe5, 0x8f, 0xbf,
	0x1e, 0xa8, 0xe2, 0x45, 0x6d, 0x1d, 0x98, 0x3b, 0x65, 0x6d, 0x4d, 0x95, 0xdf, 0xae, 0x8c, 0x4f,
	0x11, 0x1e, 0xff, 0x6e, 0xb4, 0x85, 0x92, 0x2e, 0x83, 0x6d, 0x0d, 0xd6, 0x91, 0x14, 0x07, 0x52,
	0x59, 0xc7, 0x14, 0x07, 0x1b, 0xa2, 0xc9, 0x60, 0x3a, 0x9a, 0xbd, 0x4b, 0x7a, 0x4d, 0xc9, 0xe2,
	0xe8, 0x66, 0x5d, 0x8e, 0x7c, 0xc2, 0x58, 0xd5, 0xe5, 0xd2, 0x6e, 0x98, 0x11, 0x36, 0x7c, 0x3e,
	0x41, 0xd3, 0x61, 0x16, 0xa8, 0xba, 0xfc, 0xe3, 0x05, 0xf2, 0x19, 0x13, 0x03, 0x55, 0x21, 0x39,
	0x73, 0x52, 0xab, 0xe5, 0x8a, 0x71, 0xa7, 0x4d, 0x38, 0xf0, 0xb1, 0x37, 0x3d, 0xe7, 0x87, 0x37,
	0xe2, 0x55, 0x0f, 0xed, 0x27, 0xb8, 0x0c, 0x6c, 0xa5, 0x95, 0x05, 0xf2, 0x05, 0x07, 0x2d, 0x48,
	0x88, 0x26, 0x68, 0x3a, 0x9a, 0xbd, 0xbf, 0x81, 0xd6, 0x4e, 0x65, 0x5d, 0x90, 0x84, 0xf8, 0xe5,
	0x0e, 0x8c, 0x95, 0x5a, 0x1d, 0xc1, 0x9a, 0x67, 0xfc, 0x17, 0xbf, 0x6d, 0x27, 0xbe, 0x09, 0xf1,
	0xa4, 0x0b, 0x8c, 0xf1, 0x70, 0xa5, 0x0d, 0x07, 0xbf, 0xe3, 0x55, 0x76, 0x78, 0xc4, 0x27, 0x08,
	0x7f, 0xe8, 0xa0, 0xc0, 0x97, 0x34, 0x6b, 0x12, 0x4c, 0x0a, 0x60, 0x3b, 0xa9, 0xd6, 0x4d, 0xdf,
	0xe2, 0xfb, 0x61, 0x5f, 0x90, 0xdd, 0xe3, 0x90, 0xaf, 0x18, 0x73, 0xa6, 0x84, 0x14, 0xcc, 0xc1,
	0xf5, 0x8d, 0x1f, 0xe1, 0xea, 0x05, 0x3b, 0xb0, 0x41, 0x0f, 0x6c, 0xfe, 0xfa, 0x6c, 0x1f, 0xa1,
	0xf3, 0x7d, 0x84, 0x2e, 0xf6, 0x11, 0xfa, 0x7f, 0x19, 0x3d, 0xcb, 0x5f, 0xf8, 0x7f, 0x91, 0x5e,
	0x05, 0x00, 0x00, 0xff, 0xff, 0xae, 0x31, 0x55, 0xba, 0xb0, 0x02, 0x00, 0x00,
}
