// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/m3db/m3/src/query/generated/proto/rpcpb/query.proto

// Copyright (c) 2019 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/*
	Package rpcpb is a generated protocol buffer package.

	It is generated from these files:
		github.com/m3db/m3/src/query/generated/proto/rpcpb/query.proto

	It has these top-level messages:
		HealthRequest
		HealthResponse
		FetchRequest
		TagMatchers
		TagMatcher
		FetchOptions
		RestrictFetchOptions
		FetchResponse
		Series
		SeriesMetadata
		DecompressedSeries
		Datapoint
		Tag
		M3CompressedSeries
		M3CompressedValuesReplica
		M3Segments
		M3Segment
		SearchRequest
		M3TagProperty
		M3TagProperties
		TagProperty
		TagProperties
		SearchResponse
		CompleteTagsRequestOptions
		CompleteTagsRequest
		TagNames
		TagValue
		TagValues
		CompleteTagsResponse
		ResultMetadata
		Warning
*/
package rpcpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import policypb "github.com/m3db/m3/src/metrics/generated/proto/policypb"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type MatcherType int32

const (
	MatcherType_EQUAL     MatcherType = 0
	MatcherType_NOTEQUAL  MatcherType = 1
	MatcherType_REGEXP    MatcherType = 2
	MatcherType_NOTREGEXP MatcherType = 3
	// EXISTS and NOTEXISTS apply only to
	// matcher name rather than value.
	MatcherType_EXISTS    MatcherType = 4
	MatcherType_NOTEXISTS MatcherType = 5
	// ALL supercedes other matcher types
	// and does no filtering.
	MatcherType_ALL MatcherType = 6
)

var MatcherType_name = map[int32]string{
	0: "EQUAL",
	1: "NOTEQUAL",
	2: "REGEXP",
	3: "NOTREGEXP",
	4: "EXISTS",
	5: "NOTEXISTS",
	6: "ALL",
}
var MatcherType_value = map[string]int32{
	"EQUAL":     0,
	"NOTEQUAL":  1,
	"REGEXP":    2,
	"NOTREGEXP": 3,
	"EXISTS":    4,
	"NOTEXISTS": 5,
	"ALL":       6,
}

func (x MatcherType) String() string {
	return proto.EnumName(MatcherType_name, int32(x))
}
func (MatcherType) EnumDescriptor() ([]byte, []int) { return fileDescriptorQuery, []int{0} }

type MetricsType int32

const (
	MetricsType_UNKNOWN_METRICS_TYPE      MetricsType = 0
	MetricsType_UNAGGREGATED_METRICS_TYPE MetricsType = 1
	MetricsType_AGGREGATED_METRICS_TYPE   MetricsType = 2
)

var MetricsType_name = map[int32]string{
	0: "UNKNOWN_METRICS_TYPE",
	1: "UNAGGREGATED_METRICS_TYPE",
	2: "AGGREGATED_METRICS_TYPE",
}
var MetricsType_value = map[string]int32{
	"UNKNOWN_METRICS_TYPE":      0,
	"UNAGGREGATED_METRICS_TYPE": 1,
	"AGGREGATED_METRICS_TYPE":   2,
}

func (x MetricsType) String() string {
	return proto.EnumName(MetricsType_name, int32(x))
}
func (MetricsType) EnumDescriptor() ([]byte, []int) { return fileDescriptorQuery, []int{1} }

type FanoutOption int32

const (
	FanoutOption_DEFAULT_OPTION FanoutOption = 0
	FanoutOption_FORCE_ENABLED  FanoutOption = 1
	FanoutOption_FORCE_DISABLED FanoutOption = 2
)

var FanoutOption_name = map[int32]string{
	0: "DEFAULT_OPTION",
	1: "FORCE_ENABLED",
	2: "FORCE_DISABLED",
}
var FanoutOption_value = map[string]int32{
	"DEFAULT_OPTION": 0,
	"FORCE_ENABLED":  1,
	"FORCE_DISABLED": 2,
}

func (x FanoutOption) String() string {
	return proto.EnumName(FanoutOption_name, int32(x))
}
func (FanoutOption) EnumDescriptor() ([]byte, []int) { return fileDescriptorQuery, []int{2} }

type CompleteTagsType int32

const (
	// Requests tag names and values
	CompleteTagsType_DEFAULT CompleteTagsType = 0
	// Requests tag names only
	CompleteTagsType_TAGNAME CompleteTagsType = 1
)

var CompleteTagsType_name = map[int32]string{
	0: "DEFAULT",
	1: "TAGNAME",
}
var CompleteTagsType_value = map[string]int32{
	"DEFAULT": 0,
	"TAGNAME": 1,
}

func (x CompleteTagsType) String() string {
	return proto.EnumName(CompleteTagsType_name, int32(x))
}
func (CompleteTagsType) EnumDescriptor() ([]byte, []int) { return fileDescriptorQuery, []int{3} }

type HealthRequest struct {
}

func (m *HealthRequest) Reset()                    { *m = HealthRequest{} }
func (m *HealthRequest) String() string            { return proto.CompactTextString(m) }
func (*HealthRequest) ProtoMessage()               {}
func (*HealthRequest) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{0} }

type HealthResponse struct {
	UptimeDuration    string `protobuf:"bytes,1,opt,name=uptimeDuration,proto3" json:"uptimeDuration,omitempty"`
	UptimeNanoseconds int64  `protobuf:"varint,2,opt,name=uptimeNanoseconds,proto3" json:"uptimeNanoseconds,omitempty"`
}

func (m *HealthResponse) Reset()                    { *m = HealthResponse{} }
func (m *HealthResponse) String() string            { return proto.CompactTextString(m) }
func (*HealthResponse) ProtoMessage()               {}
func (*HealthResponse) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{1} }

func (m *HealthResponse) GetUptimeDuration() string {
	if m != nil {
		return m.UptimeDuration
	}
	return ""
}

func (m *HealthResponse) GetUptimeNanoseconds() int64 {
	if m != nil {
		return m.UptimeNanoseconds
	}
	return 0
}

type FetchRequest struct {
	Start int64 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	End   int64 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	// Types that are valid to be assigned to Matchers:
	//	*FetchRequest_TagMatchers
	Matchers isFetchRequest_Matchers `protobuf_oneof:"matchers"`
	Options  *FetchOptions           `protobuf:"bytes,4,opt,name=options" json:"options,omitempty"`
}

func (m *FetchRequest) Reset()                    { *m = FetchRequest{} }
func (m *FetchRequest) String() string            { return proto.CompactTextString(m) }
func (*FetchRequest) ProtoMessage()               {}
func (*FetchRequest) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{2} }

type isFetchRequest_Matchers interface {
	isFetchRequest_Matchers()
	MarshalTo([]byte) (int, error)
	Size() int
}

type FetchRequest_TagMatchers struct {
	TagMatchers *TagMatchers `protobuf:"bytes,3,opt,name=tagMatchers,oneof"`
}

func (*FetchRequest_TagMatchers) isFetchRequest_Matchers() {}

func (m *FetchRequest) GetMatchers() isFetchRequest_Matchers {
	if m != nil {
		return m.Matchers
	}
	return nil
}

func (m *FetchRequest) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *FetchRequest) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *FetchRequest) GetTagMatchers() *TagMatchers {
	if x, ok := m.GetMatchers().(*FetchRequest_TagMatchers); ok {
		return x.TagMatchers
	}
	return nil
}

func (m *FetchRequest) GetOptions() *FetchOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*FetchRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _FetchRequest_OneofMarshaler, _FetchRequest_OneofUnmarshaler, _FetchRequest_OneofSizer, []interface{}{
		(*FetchRequest_TagMatchers)(nil),
	}
}

func _FetchRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*FetchRequest)
	// matchers
	switch x := m.Matchers.(type) {
	case *FetchRequest_TagMatchers:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TagMatchers); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("FetchRequest.Matchers has unexpected type %T", x)
	}
	return nil
}

func _FetchRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*FetchRequest)
	switch tag {
	case 3: // matchers.tagMatchers
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TagMatchers)
		err := b.DecodeMessage(msg)
		m.Matchers = &FetchRequest_TagMatchers{msg}
		return true, err
	default:
		return false, nil
	}
}

func _FetchRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*FetchRequest)
	// matchers
	switch x := m.Matchers.(type) {
	case *FetchRequest_TagMatchers:
		s := proto.Size(x.TagMatchers)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type TagMatchers struct {
	TagMatchers []*TagMatcher `protobuf:"bytes,1,rep,name=tagMatchers" json:"tagMatchers,omitempty"`
}

func (m *TagMatchers) Reset()                    { *m = TagMatchers{} }
func (m *TagMatchers) String() string            { return proto.CompactTextString(m) }
func (*TagMatchers) ProtoMessage()               {}
func (*TagMatchers) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{3} }

func (m *TagMatchers) GetTagMatchers() []*TagMatcher {
	if m != nil {
		return m.TagMatchers
	}
	return nil
}

type TagMatcher struct {
	Name  []byte      `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value []byte      `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	Type  MatcherType `protobuf:"varint,3,opt,name=type,proto3,enum=rpc.MatcherType" json:"type,omitempty"`
}

func (m *TagMatcher) Reset()                    { *m = TagMatcher{} }
func (m *TagMatcher) String() string            { return proto.CompactTextString(m) }
func (*TagMatcher) ProtoMessage()               {}
func (*TagMatcher) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{4} }

func (m *TagMatcher) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *TagMatcher) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *TagMatcher) GetType() MatcherType {
	if m != nil {
		return m.Type
	}
	return MatcherType_EQUAL
}

type FetchOptions struct {
	Limit               int64                 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	Restrict            *RestrictFetchOptions `protobuf:"bytes,2,opt,name=restrict" json:"restrict,omitempty"`
	LookbackDuration    int64                 `protobuf:"varint,3,opt,name=lookbackDuration,proto3" json:"lookbackDuration,omitempty"`
	Unaggregated        FanoutOption          `protobuf:"varint,4,opt,name=unaggregated,proto3,enum=rpc.FanoutOption" json:"unaggregated,omitempty"`
	Aggregated          FanoutOption          `protobuf:"varint,5,opt,name=aggregated,proto3,enum=rpc.FanoutOption" json:"aggregated,omitempty"`
	AggregatedOptimized FanoutOption          `protobuf:"varint,6,opt,name=aggregatedOptimized,proto3,enum=rpc.FanoutOption" json:"aggregatedOptimized,omitempty"`
	IncludeResolution   bool                  `protobuf:"varint,7,opt,name=includeResolution,proto3" json:"includeResolution,omitempty"`
}

func (m *FetchOptions) Reset()                    { *m = FetchOptions{} }
func (m *FetchOptions) String() string            { return proto.CompactTextString(m) }
func (*FetchOptions) ProtoMessage()               {}
func (*FetchOptions) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{5} }

func (m *FetchOptions) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *FetchOptions) GetRestrict() *RestrictFetchOptions {
	if m != nil {
		return m.Restrict
	}
	return nil
}

func (m *FetchOptions) GetLookbackDuration() int64 {
	if m != nil {
		return m.LookbackDuration
	}
	return 0
}

func (m *FetchOptions) GetUnaggregated() FanoutOption {
	if m != nil {
		return m.Unaggregated
	}
	return FanoutOption_DEFAULT_OPTION
}

func (m *FetchOptions) GetAggregated() FanoutOption {
	if m != nil {
		return m.Aggregated
	}
	return FanoutOption_DEFAULT_OPTION
}

func (m *FetchOptions) GetAggregatedOptimized() FanoutOption {
	if m != nil {
		return m.AggregatedOptimized
	}
	return FanoutOption_DEFAULT_OPTION
}

func (m *FetchOptions) GetIncludeResolution() bool {
	if m != nil {
		return m.IncludeResolution
	}
	return false
}

type RestrictFetchOptions struct {
	MetricsType          MetricsType             `protobuf:"varint,1,opt,name=metricsType,proto3,enum=rpc.MetricsType" json:"metricsType,omitempty"`
	MetricsStoragePolicy *policypb.StoragePolicy `protobuf:"bytes,2,opt,name=metricsStoragePolicy" json:"metricsStoragePolicy,omitempty"`
}

func (m *RestrictFetchOptions) Reset()                    { *m = RestrictFetchOptions{} }
func (m *RestrictFetchOptions) String() string            { return proto.CompactTextString(m) }
func (*RestrictFetchOptions) ProtoMessage()               {}
func (*RestrictFetchOptions) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{6} }

func (m *RestrictFetchOptions) GetMetricsType() MetricsType {
	if m != nil {
		return m.MetricsType
	}
	return MetricsType_UNKNOWN_METRICS_TYPE
}

func (m *RestrictFetchOptions) GetMetricsStoragePolicy() *policypb.StoragePolicy {
	if m != nil {
		return m.MetricsStoragePolicy
	}
	return nil
}

type FetchResponse struct {
	Series []*Series       `protobuf:"bytes,1,rep,name=series" json:"series,omitempty"`
	Meta   *ResultMetadata `protobuf:"bytes,2,opt,name=meta" json:"meta,omitempty"`
}

func (m *FetchResponse) Reset()                    { *m = FetchResponse{} }
func (m *FetchResponse) String() string            { return proto.CompactTextString(m) }
func (*FetchResponse) ProtoMessage()               {}
func (*FetchResponse) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{7} }

func (m *FetchResponse) GetSeries() []*Series {
	if m != nil {
		return m.Series
	}
	return nil
}

func (m *FetchResponse) GetMeta() *ResultMetadata {
	if m != nil {
		return m.Meta
	}
	return nil
}

type Series struct {
	Meta *SeriesMetadata `protobuf:"bytes,1,opt,name=meta" json:"meta,omitempty"`
	// Types that are valid to be assigned to Value:
	//	*Series_Decompressed
	//	*Series_Compressed
	Value isSeries_Value `protobuf_oneof:"value"`
}

func (m *Series) Reset()                    { *m = Series{} }
func (m *Series) String() string            { return proto.CompactTextString(m) }
func (*Series) ProtoMessage()               {}
func (*Series) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{8} }

type isSeries_Value interface {
	isSeries_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Series_Decompressed struct {
	Decompressed *DecompressedSeries `protobuf:"bytes,2,opt,name=decompressed,oneof"`
}
type Series_Compressed struct {
	Compressed *M3CompressedSeries `protobuf:"bytes,3,opt,name=compressed,oneof"`
}

func (*Series_Decompressed) isSeries_Value() {}
func (*Series_Compressed) isSeries_Value()   {}

func (m *Series) GetValue() isSeries_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Series) GetMeta() *SeriesMetadata {
	if m != nil {
		return m.Meta
	}
	return nil
}

func (m *Series) GetDecompressed() *DecompressedSeries {
	if x, ok := m.GetValue().(*Series_Decompressed); ok {
		return x.Decompressed
	}
	return nil
}

func (m *Series) GetCompressed() *M3CompressedSeries {
	if x, ok := m.GetValue().(*Series_Compressed); ok {
		return x.Compressed
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Series) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Series_OneofMarshaler, _Series_OneofUnmarshaler, _Series_OneofSizer, []interface{}{
		(*Series_Decompressed)(nil),
		(*Series_Compressed)(nil),
	}
}

func _Series_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Series)
	// value
	switch x := m.Value.(type) {
	case *Series_Decompressed:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Decompressed); err != nil {
			return err
		}
	case *Series_Compressed:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Compressed); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Series.Value has unexpected type %T", x)
	}
	return nil
}

func _Series_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Series)
	switch tag {
	case 2: // value.decompressed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DecompressedSeries)
		err := b.DecodeMessage(msg)
		m.Value = &Series_Decompressed{msg}
		return true, err
	case 3: // value.compressed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(M3CompressedSeries)
		err := b.DecodeMessage(msg)
		m.Value = &Series_Compressed{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Series_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Series)
	// value
	switch x := m.Value.(type) {
	case *Series_Decompressed:
		s := proto.Size(x.Decompressed)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Series_Compressed:
		s := proto.Size(x.Compressed)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type SeriesMetadata struct {
	Id        []byte `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	StartTime int64  `protobuf:"varint,2,opt,name=startTime,proto3" json:"startTime,omitempty"`
	EndTime   int64  `protobuf:"varint,3,opt,name=endTime,proto3" json:"endTime,omitempty"`
}

func (m *SeriesMetadata) Reset()                    { *m = SeriesMetadata{} }
func (m *SeriesMetadata) String() string            { return proto.CompactTextString(m) }
func (*SeriesMetadata) ProtoMessage()               {}
func (*SeriesMetadata) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{9} }

func (m *SeriesMetadata) GetId() []byte {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *SeriesMetadata) GetStartTime() int64 {
	if m != nil {
		return m.StartTime
	}
	return 0
}

func (m *SeriesMetadata) GetEndTime() int64 {
	if m != nil {
		return m.EndTime
	}
	return 0
}

type DecompressedSeries struct {
	Datapoints []*Datapoint `protobuf:"bytes,1,rep,name=datapoints" json:"datapoints,omitempty"`
	Tags       []*Tag       `protobuf:"bytes,2,rep,name=tags" json:"tags,omitempty"`
}

func (m *DecompressedSeries) Reset()                    { *m = DecompressedSeries{} }
func (m *DecompressedSeries) String() string            { return proto.CompactTextString(m) }
func (*DecompressedSeries) ProtoMessage()               {}
func (*DecompressedSeries) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{10} }

func (m *DecompressedSeries) GetDatapoints() []*Datapoint {
	if m != nil {
		return m.Datapoints
	}
	return nil
}

func (m *DecompressedSeries) GetTags() []*Tag {
	if m != nil {
		return m.Tags
	}
	return nil
}

type Datapoint struct {
	Timestamp int64   `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Value     float64 `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Datapoint) Reset()                    { *m = Datapoint{} }
func (m *Datapoint) String() string            { return proto.CompactTextString(m) }
func (*Datapoint) ProtoMessage()               {}
func (*Datapoint) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{11} }

func (m *Datapoint) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *Datapoint) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

type Tag struct {
	Name  []byte `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Tag) Reset()                    { *m = Tag{} }
func (m *Tag) String() string            { return proto.CompactTextString(m) }
func (*Tag) ProtoMessage()               {}
func (*Tag) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{12} }

func (m *Tag) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Tag) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type M3CompressedSeries struct {
	CompressedTags []byte                       `protobuf:"bytes,1,opt,name=compressedTags,proto3" json:"compressedTags,omitempty"`
	Replicas       []*M3CompressedValuesReplica `protobuf:"bytes,2,rep,name=replicas" json:"replicas,omitempty"`
}

func (m *M3CompressedSeries) Reset()                    { *m = M3CompressedSeries{} }
func (m *M3CompressedSeries) String() string            { return proto.CompactTextString(m) }
func (*M3CompressedSeries) ProtoMessage()               {}
func (*M3CompressedSeries) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{13} }

func (m *M3CompressedSeries) GetCompressedTags() []byte {
	if m != nil {
		return m.CompressedTags
	}
	return nil
}

func (m *M3CompressedSeries) GetReplicas() []*M3CompressedValuesReplica {
	if m != nil {
		return m.Replicas
	}
	return nil
}

type M3CompressedValuesReplica struct {
	Segments []*M3Segments `protobuf:"bytes,1,rep,name=segments" json:"segments,omitempty"`
}

func (m *M3CompressedValuesReplica) Reset()                    { *m = M3CompressedValuesReplica{} }
func (m *M3CompressedValuesReplica) String() string            { return proto.CompactTextString(m) }
func (*M3CompressedValuesReplica) ProtoMessage()               {}
func (*M3CompressedValuesReplica) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{14} }

func (m *M3CompressedValuesReplica) GetSegments() []*M3Segments {
	if m != nil {
		return m.Segments
	}
	return nil
}

type M3Segments struct {
	Merged   *M3Segment   `protobuf:"bytes,1,opt,name=merged" json:"merged,omitempty"`
	Unmerged []*M3Segment `protobuf:"bytes,2,rep,name=unmerged" json:"unmerged,omitempty"`
}

func (m *M3Segments) Reset()                    { *m = M3Segments{} }
func (m *M3Segments) String() string            { return proto.CompactTextString(m) }
func (*M3Segments) ProtoMessage()               {}
func (*M3Segments) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{15} }

func (m *M3Segments) GetMerged() *M3Segment {
	if m != nil {
		return m.Merged
	}
	return nil
}

func (m *M3Segments) GetUnmerged() []*M3Segment {
	if m != nil {
		return m.Unmerged
	}
	return nil
}

type M3Segment struct {
	Head      []byte `protobuf:"bytes,1,opt,name=head,proto3" json:"head,omitempty"`
	Tail      []byte `protobuf:"bytes,2,opt,name=tail,proto3" json:"tail,omitempty"`
	StartTime int64  `protobuf:"varint,3,opt,name=startTime,proto3" json:"startTime,omitempty"`
	BlockSize int64  `protobuf:"varint,4,opt,name=blockSize,proto3" json:"blockSize,omitempty"`
}

func (m *M3Segment) Reset()                    { *m = M3Segment{} }
func (m *M3Segment) String() string            { return proto.CompactTextString(m) }
func (*M3Segment) ProtoMessage()               {}
func (*M3Segment) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{16} }

func (m *M3Segment) GetHead() []byte {
	if m != nil {
		return m.Head
	}
	return nil
}

func (m *M3Segment) GetTail() []byte {
	if m != nil {
		return m.Tail
	}
	return nil
}

func (m *M3Segment) GetStartTime() int64 {
	if m != nil {
		return m.StartTime
	}
	return 0
}

func (m *M3Segment) GetBlockSize() int64 {
	if m != nil {
		return m.BlockSize
	}
	return 0
}

type SearchRequest struct {
	// Types that are valid to be assigned to Matchers:
	//	*SearchRequest_TagMatchers
	Matchers isSearchRequest_Matchers `protobuf_oneof:"matchers"`
	Start    int64                    `protobuf:"varint,2,opt,name=start,proto3" json:"start,omitempty"`
	End      int64                    `protobuf:"varint,3,opt,name=end,proto3" json:"end,omitempty"`
	Options  *FetchOptions            `protobuf:"bytes,4,opt,name=options" json:"options,omitempty"`
}

func (m *SearchRequest) Reset()                    { *m = SearchRequest{} }
func (m *SearchRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchRequest) ProtoMessage()               {}
func (*SearchRequest) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{17} }

type isSearchRequest_Matchers interface {
	isSearchRequest_Matchers()
	MarshalTo([]byte) (int, error)
	Size() int
}

type SearchRequest_TagMatchers struct {
	TagMatchers *TagMatchers `protobuf:"bytes,1,opt,name=tagMatchers,oneof"`
}

func (*SearchRequest_TagMatchers) isSearchRequest_Matchers() {}

func (m *SearchRequest) GetMatchers() isSearchRequest_Matchers {
	if m != nil {
		return m.Matchers
	}
	return nil
}

func (m *SearchRequest) GetTagMatchers() *TagMatchers {
	if x, ok := m.GetMatchers().(*SearchRequest_TagMatchers); ok {
		return x.TagMatchers
	}
	return nil
}

func (m *SearchRequest) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *SearchRequest) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *SearchRequest) GetOptions() *FetchOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SearchRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SearchRequest_OneofMarshaler, _SearchRequest_OneofUnmarshaler, _SearchRequest_OneofSizer, []interface{}{
		(*SearchRequest_TagMatchers)(nil),
	}
}

func _SearchRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SearchRequest)
	// matchers
	switch x := m.Matchers.(type) {
	case *SearchRequest_TagMatchers:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TagMatchers); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SearchRequest.Matchers has unexpected type %T", x)
	}
	return nil
}

func _SearchRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SearchRequest)
	switch tag {
	case 1: // matchers.tagMatchers
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TagMatchers)
		err := b.DecodeMessage(msg)
		m.Matchers = &SearchRequest_TagMatchers{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SearchRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SearchRequest)
	// matchers
	switch x := m.Matchers.(type) {
	case *SearchRequest_TagMatchers:
		s := proto.Size(x.TagMatchers)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type M3TagProperty struct {
	Id             []byte `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	CompressedTags []byte `protobuf:"bytes,2,opt,name=compressedTags,proto3" json:"compressedTags,omitempty"`
}

func (m *M3TagProperty) Reset()                    { *m = M3TagProperty{} }
func (m *M3TagProperty) String() string            { return proto.CompactTextString(m) }
func (*M3TagProperty) ProtoMessage()               {}
func (*M3TagProperty) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{18} }

func (m *M3TagProperty) GetId() []byte {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *M3TagProperty) GetCompressedTags() []byte {
	if m != nil {
		return m.CompressedTags
	}
	return nil
}

type M3TagProperties struct {
	Properties []*M3TagProperty `protobuf:"bytes,1,rep,name=properties" json:"properties,omitempty"`
}

func (m *M3TagProperties) Reset()                    { *m = M3TagProperties{} }
func (m *M3TagProperties) String() string            { return proto.CompactTextString(m) }
func (*M3TagProperties) ProtoMessage()               {}
func (*M3TagProperties) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{19} }

func (m *M3TagProperties) GetProperties() []*M3TagProperty {
	if m != nil {
		return m.Properties
	}
	return nil
}

type TagProperty struct {
	Key    []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Values []byte `protobuf:"bytes,2,opt,name=values,proto3" json:"values,omitempty"`
}

func (m *TagProperty) Reset()                    { *m = TagProperty{} }
func (m *TagProperty) String() string            { return proto.CompactTextString(m) }
func (*TagProperty) ProtoMessage()               {}
func (*TagProperty) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{20} }

func (m *TagProperty) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *TagProperty) GetValues() []byte {
	if m != nil {
		return m.Values
	}
	return nil
}

type TagProperties struct {
	Properties []*TagProperty `protobuf:"bytes,1,rep,name=properties" json:"properties,omitempty"`
}

func (m *TagProperties) Reset()                    { *m = TagProperties{} }
func (m *TagProperties) String() string            { return proto.CompactTextString(m) }
func (*TagProperties) ProtoMessage()               {}
func (*TagProperties) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{21} }

func (m *TagProperties) GetProperties() []*TagProperty {
	if m != nil {
		return m.Properties
	}
	return nil
}

type SearchResponse struct {
	// Types that are valid to be assigned to Value:
	//	*SearchResponse_Decompressed
	//	*SearchResponse_Compressed
	Value isSearchResponse_Value `protobuf_oneof:"value"`
	Meta  *ResultMetadata        `protobuf:"bytes,3,opt,name=meta" json:"meta,omitempty"`
}

func (m *SearchResponse) Reset()                    { *m = SearchResponse{} }
func (m *SearchResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchResponse) ProtoMessage()               {}
func (*SearchResponse) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{22} }

type isSearchResponse_Value interface {
	isSearchResponse_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type SearchResponse_Decompressed struct {
	Decompressed *TagProperties `protobuf:"bytes,1,opt,name=decompressed,oneof"`
}
type SearchResponse_Compressed struct {
	Compressed *M3TagProperties `protobuf:"bytes,2,opt,name=compressed,oneof"`
}

func (*SearchResponse_Decompressed) isSearchResponse_Value() {}
func (*SearchResponse_Compressed) isSearchResponse_Value()   {}

func (m *SearchResponse) GetValue() isSearchResponse_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *SearchResponse) GetDecompressed() *TagProperties {
	if x, ok := m.GetValue().(*SearchResponse_Decompressed); ok {
		return x.Decompressed
	}
	return nil
}

func (m *SearchResponse) GetCompressed() *M3TagProperties {
	if x, ok := m.GetValue().(*SearchResponse_Compressed); ok {
		return x.Compressed
	}
	return nil
}

func (m *SearchResponse) GetMeta() *ResultMetadata {
	if m != nil {
		return m.Meta
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SearchResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SearchResponse_OneofMarshaler, _SearchResponse_OneofUnmarshaler, _SearchResponse_OneofSizer, []interface{}{
		(*SearchResponse_Decompressed)(nil),
		(*SearchResponse_Compressed)(nil),
	}
}

func _SearchResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SearchResponse)
	// value
	switch x := m.Value.(type) {
	case *SearchResponse_Decompressed:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Decompressed); err != nil {
			return err
		}
	case *SearchResponse_Compressed:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Compressed); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SearchResponse.Value has unexpected type %T", x)
	}
	return nil
}

func _SearchResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SearchResponse)
	switch tag {
	case 1: // value.decompressed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TagProperties)
		err := b.DecodeMessage(msg)
		m.Value = &SearchResponse_Decompressed{msg}
		return true, err
	case 2: // value.compressed
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(M3TagProperties)
		err := b.DecodeMessage(msg)
		m.Value = &SearchResponse_Compressed{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SearchResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SearchResponse)
	// value
	switch x := m.Value.(type) {
	case *SearchResponse_Decompressed:
		s := proto.Size(x.Decompressed)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SearchResponse_Compressed:
		s := proto.Size(x.Compressed)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type CompleteTagsRequestOptions struct {
	Type           CompleteTagsType `protobuf:"varint,1,opt,name=type,proto3,enum=rpc.CompleteTagsType" json:"type,omitempty"`
	FilterNameTags [][]byte         `protobuf:"bytes,2,rep,name=filterNameTags" json:"filterNameTags,omitempty"`
	Start          int64            `protobuf:"varint,3,opt,name=start,proto3" json:"start,omitempty"`
	End            int64            `protobuf:"varint,4,opt,name=end,proto3" json:"end,omitempty"`
	Options        *FetchOptions    `protobuf:"bytes,5,opt,name=options" json:"options,omitempty"`
}

func (m *CompleteTagsRequestOptions) Reset()                    { *m = CompleteTagsRequestOptions{} }
func (m *CompleteTagsRequestOptions) String() string            { return proto.CompactTextString(m) }
func (*CompleteTagsRequestOptions) ProtoMessage()               {}
func (*CompleteTagsRequestOptions) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{23} }

func (m *CompleteTagsRequestOptions) GetType() CompleteTagsType {
	if m != nil {
		return m.Type
	}
	return CompleteTagsType_DEFAULT
}

func (m *CompleteTagsRequestOptions) GetFilterNameTags() [][]byte {
	if m != nil {
		return m.FilterNameTags
	}
	return nil
}

func (m *CompleteTagsRequestOptions) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *CompleteTagsRequestOptions) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *CompleteTagsRequestOptions) GetOptions() *FetchOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

type CompleteTagsRequest struct {
	// Types that are valid to be assigned to Matchers:
	//	*CompleteTagsRequest_TagMatchers
	Matchers isCompleteTagsRequest_Matchers `protobuf_oneof:"matchers"`
	Options  *CompleteTagsRequestOptions    `protobuf:"bytes,2,opt,name=options" json:"options,omitempty"`
}

func (m *CompleteTagsRequest) Reset()                    { *m = CompleteTagsRequest{} }
func (m *CompleteTagsRequest) String() string            { return proto.CompactTextString(m) }
func (*CompleteTagsRequest) ProtoMessage()               {}
func (*CompleteTagsRequest) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{24} }

type isCompleteTagsRequest_Matchers interface {
	isCompleteTagsRequest_Matchers()
	MarshalTo([]byte) (int, error)
	Size() int
}

type CompleteTagsRequest_TagMatchers struct {
	TagMatchers *TagMatchers `protobuf:"bytes,1,opt,name=tagMatchers,oneof"`
}

func (*CompleteTagsRequest_TagMatchers) isCompleteTagsRequest_Matchers() {}

func (m *CompleteTagsRequest) GetMatchers() isCompleteTagsRequest_Matchers {
	if m != nil {
		return m.Matchers
	}
	return nil
}

func (m *CompleteTagsRequest) GetTagMatchers() *TagMatchers {
	if x, ok := m.GetMatchers().(*CompleteTagsRequest_TagMatchers); ok {
		return x.TagMatchers
	}
	return nil
}

func (m *CompleteTagsRequest) GetOptions() *CompleteTagsRequestOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CompleteTagsRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CompleteTagsRequest_OneofMarshaler, _CompleteTagsRequest_OneofUnmarshaler, _CompleteTagsRequest_OneofSizer, []interface{}{
		(*CompleteTagsRequest_TagMatchers)(nil),
	}
}

func _CompleteTagsRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CompleteTagsRequest)
	// matchers
	switch x := m.Matchers.(type) {
	case *CompleteTagsRequest_TagMatchers:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TagMatchers); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CompleteTagsRequest.Matchers has unexpected type %T", x)
	}
	return nil
}

func _CompleteTagsRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CompleteTagsRequest)
	switch tag {
	case 1: // matchers.tagMatchers
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TagMatchers)
		err := b.DecodeMessage(msg)
		m.Matchers = &CompleteTagsRequest_TagMatchers{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CompleteTagsRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CompleteTagsRequest)
	// matchers
	switch x := m.Matchers.(type) {
	case *CompleteTagsRequest_TagMatchers:
		s := proto.Size(x.TagMatchers)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type TagNames struct {
	Names [][]byte `protobuf:"bytes,1,rep,name=names" json:"names,omitempty"`
}

func (m *TagNames) Reset()                    { *m = TagNames{} }
func (m *TagNames) String() string            { return proto.CompactTextString(m) }
func (*TagNames) ProtoMessage()               {}
func (*TagNames) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{25} }

func (m *TagNames) GetNames() [][]byte {
	if m != nil {
		return m.Names
	}
	return nil
}

type TagValue struct {
	Key    []byte   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Values [][]byte `protobuf:"bytes,2,rep,name=values" json:"values,omitempty"`
}

func (m *TagValue) Reset()                    { *m = TagValue{} }
func (m *TagValue) String() string            { return proto.CompactTextString(m) }
func (*TagValue) ProtoMessage()               {}
func (*TagValue) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{26} }

func (m *TagValue) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *TagValue) GetValues() [][]byte {
	if m != nil {
		return m.Values
	}
	return nil
}

type TagValues struct {
	Values []*TagValue `protobuf:"bytes,1,rep,name=values" json:"values,omitempty"`
}

func (m *TagValues) Reset()                    { *m = TagValues{} }
func (m *TagValues) String() string            { return proto.CompactTextString(m) }
func (*TagValues) ProtoMessage()               {}
func (*TagValues) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{27} }

func (m *TagValues) GetValues() []*TagValue {
	if m != nil {
		return m.Values
	}
	return nil
}

type CompleteTagsResponse struct {
	// Types that are valid to be assigned to Value:
	//	*CompleteTagsResponse_Default
	//	*CompleteTagsResponse_NamesOnly
	Value isCompleteTagsResponse_Value `protobuf_oneof:"value"`
	Meta  *ResultMetadata              `protobuf:"bytes,3,opt,name=meta" json:"meta,omitempty"`
}

func (m *CompleteTagsResponse) Reset()                    { *m = CompleteTagsResponse{} }
func (m *CompleteTagsResponse) String() string            { return proto.CompactTextString(m) }
func (*CompleteTagsResponse) ProtoMessage()               {}
func (*CompleteTagsResponse) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{28} }

type isCompleteTagsResponse_Value interface {
	isCompleteTagsResponse_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type CompleteTagsResponse_Default struct {
	Default *TagValues `protobuf:"bytes,1,opt,name=default,oneof"`
}
type CompleteTagsResponse_NamesOnly struct {
	NamesOnly *TagNames `protobuf:"bytes,2,opt,name=namesOnly,oneof"`
}

func (*CompleteTagsResponse_Default) isCompleteTagsResponse_Value()   {}
func (*CompleteTagsResponse_NamesOnly) isCompleteTagsResponse_Value() {}

func (m *CompleteTagsResponse) GetValue() isCompleteTagsResponse_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *CompleteTagsResponse) GetDefault() *TagValues {
	if x, ok := m.GetValue().(*CompleteTagsResponse_Default); ok {
		return x.Default
	}
	return nil
}

func (m *CompleteTagsResponse) GetNamesOnly() *TagNames {
	if x, ok := m.GetValue().(*CompleteTagsResponse_NamesOnly); ok {
		return x.NamesOnly
	}
	return nil
}

func (m *CompleteTagsResponse) GetMeta() *ResultMetadata {
	if m != nil {
		return m.Meta
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CompleteTagsResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CompleteTagsResponse_OneofMarshaler, _CompleteTagsResponse_OneofUnmarshaler, _CompleteTagsResponse_OneofSizer, []interface{}{
		(*CompleteTagsResponse_Default)(nil),
		(*CompleteTagsResponse_NamesOnly)(nil),
	}
}

func _CompleteTagsResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CompleteTagsResponse)
	// value
	switch x := m.Value.(type) {
	case *CompleteTagsResponse_Default:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Default); err != nil {
			return err
		}
	case *CompleteTagsResponse_NamesOnly:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NamesOnly); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CompleteTagsResponse.Value has unexpected type %T", x)
	}
	return nil
}

func _CompleteTagsResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CompleteTagsResponse)
	switch tag {
	case 1: // value.default
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TagValues)
		err := b.DecodeMessage(msg)
		m.Value = &CompleteTagsResponse_Default{msg}
		return true, err
	case 2: // value.namesOnly
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TagNames)
		err := b.DecodeMessage(msg)
		m.Value = &CompleteTagsResponse_NamesOnly{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CompleteTagsResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CompleteTagsResponse)
	// value
	switch x := m.Value.(type) {
	case *CompleteTagsResponse_Default:
		s := proto.Size(x.Default)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CompleteTagsResponse_NamesOnly:
		s := proto.Size(x.NamesOnly)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type ResultMetadata struct {
	Exhaustive  bool       `protobuf:"varint,1,opt,name=exhaustive,proto3" json:"exhaustive,omitempty"`
	Warnings    []*Warning `protobuf:"bytes,2,rep,name=warnings" json:"warnings,omitempty"`
	Resolutions []int64    `protobuf:"varint,3,rep,packed,name=resolutions" json:"resolutions,omitempty"`
}

func (m *ResultMetadata) Reset()                    { *m = ResultMetadata{} }
func (m *ResultMetadata) String() string            { return proto.CompactTextString(m) }
func (*ResultMetadata) ProtoMessage()               {}
func (*ResultMetadata) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{29} }

func (m *ResultMetadata) GetExhaustive() bool {
	if m != nil {
		return m.Exhaustive
	}
	return false
}

func (m *ResultMetadata) GetWarnings() []*Warning {
	if m != nil {
		return m.Warnings
	}
	return nil
}

func (m *ResultMetadata) GetResolutions() []int64 {
	if m != nil {
		return m.Resolutions
	}
	return nil
}

type Warning struct {
	Name    []byte `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Message []byte `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *Warning) Reset()                    { *m = Warning{} }
func (m *Warning) String() string            { return proto.CompactTextString(m) }
func (*Warning) ProtoMessage()               {}
func (*Warning) Descriptor() ([]byte, []int) { return fileDescriptorQuery, []int{30} }

func (m *Warning) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Warning) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

func init() {
	proto.RegisterType((*HealthRequest)(nil), "rpc.HealthRequest")
	proto.RegisterType((*HealthResponse)(nil), "rpc.HealthResponse")
	proto.RegisterType((*FetchRequest)(nil), "rpc.FetchRequest")
	proto.RegisterType((*TagMatchers)(nil), "rpc.TagMatchers")
	proto.RegisterType((*TagMatcher)(nil), "rpc.TagMatcher")
	proto.RegisterType((*FetchOptions)(nil), "rpc.FetchOptions")
	proto.RegisterType((*RestrictFetchOptions)(nil), "rpc.RestrictFetchOptions")
	proto.RegisterType((*FetchResponse)(nil), "rpc.FetchResponse")
	proto.RegisterType((*Series)(nil), "rpc.Series")
	proto.RegisterType((*SeriesMetadata)(nil), "rpc.SeriesMetadata")
	proto.RegisterType((*DecompressedSeries)(nil), "rpc.DecompressedSeries")
	proto.RegisterType((*Datapoint)(nil), "rpc.Datapoint")
	proto.RegisterType((*Tag)(nil), "rpc.Tag")
	proto.RegisterType((*M3CompressedSeries)(nil), "rpc.M3CompressedSeries")
	proto.RegisterType((*M3CompressedValuesReplica)(nil), "rpc.M3CompressedValuesReplica")
	proto.RegisterType((*M3Segments)(nil), "rpc.M3Segments")
	proto.RegisterType((*M3Segment)(nil), "rpc.M3Segment")
	proto.RegisterType((*SearchRequest)(nil), "rpc.SearchRequest")
	proto.RegisterType((*M3TagProperty)(nil), "rpc.M3TagProperty")
	proto.RegisterType((*M3TagProperties)(nil), "rpc.M3TagProperties")
	proto.RegisterType((*TagProperty)(nil), "rpc.TagProperty")
	proto.RegisterType((*TagProperties)(nil), "rpc.TagProperties")
	proto.RegisterType((*SearchResponse)(nil), "rpc.SearchResponse")
	proto.RegisterType((*CompleteTagsRequestOptions)(nil), "rpc.CompleteTagsRequestOptions")
	proto.RegisterType((*CompleteTagsRequest)(nil), "rpc.CompleteTagsRequest")
	proto.RegisterType((*TagNames)(nil), "rpc.TagNames")
	proto.RegisterType((*TagValue)(nil), "rpc.TagValue")
	proto.RegisterType((*TagValues)(nil), "rpc.TagValues")
	proto.RegisterType((*CompleteTagsResponse)(nil), "rpc.CompleteTagsResponse")
	proto.RegisterType((*ResultMetadata)(nil), "rpc.ResultMetadata")
	proto.RegisterType((*Warning)(nil), "rpc.Warning")
	proto.RegisterEnum("rpc.MatcherType", MatcherType_name, MatcherType_value)
	proto.RegisterEnum("rpc.MetricsType", MetricsType_name, MetricsType_value)
	proto.RegisterEnum("rpc.FanoutOption", FanoutOption_name, FanoutOption_value)
	proto.RegisterEnum("rpc.CompleteTagsType", CompleteTagsType_name, CompleteTagsType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Query service

type QueryClient interface {
	Health(ctx context.Context, in *HealthRequest, opts ...grpc.CallOption) (*HealthResponse, error)
	Fetch(ctx context.Context, in *FetchRequest, opts ...grpc.CallOption) (Query_FetchClient, error)
	Search(ctx context.Context, in *SearchRequest, opts ...grpc.CallOption) (Query_SearchClient, error)
	CompleteTags(ctx context.Context, in *CompleteTagsRequest, opts ...grpc.CallOption) (Query_CompleteTagsClient, error)
}

type queryClient struct {
	cc *grpc.ClientConn
}

func NewQueryClient(cc *grpc.ClientConn) QueryClient {
	return &queryClient{cc}
}

func (c *queryClient) Health(ctx context.Context, in *HealthRequest, opts ...grpc.CallOption) (*HealthResponse, error) {
	out := new(HealthResponse)
	err := grpc.Invoke(ctx, "/rpc.Query/Health", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) Fetch(ctx context.Context, in *FetchRequest, opts ...grpc.CallOption) (Query_FetchClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Query_serviceDesc.Streams[0], c.cc, "/rpc.Query/Fetch", opts...)
	if err != nil {
		return nil, err
	}
	x := &queryFetchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Query_FetchClient interface {
	Recv() (*FetchResponse, error)
	grpc.ClientStream
}

type queryFetchClient struct {
	grpc.ClientStream
}

func (x *queryFetchClient) Recv() (*FetchResponse, error) {
	m := new(FetchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *queryClient) Search(ctx context.Context, in *SearchRequest, opts ...grpc.CallOption) (Query_SearchClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Query_serviceDesc.Streams[1], c.cc, "/rpc.Query/Search", opts...)
	if err != nil {
		return nil, err
	}
	x := &querySearchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Query_SearchClient interface {
	Recv() (*SearchResponse, error)
	grpc.ClientStream
}

type querySearchClient struct {
	grpc.ClientStream
}

func (x *querySearchClient) Recv() (*SearchResponse, error) {
	m := new(SearchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *queryClient) CompleteTags(ctx context.Context, in *CompleteTagsRequest, opts ...grpc.CallOption) (Query_CompleteTagsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Query_serviceDesc.Streams[2], c.cc, "/rpc.Query/CompleteTags", opts...)
	if err != nil {
		return nil, err
	}
	x := &queryCompleteTagsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Query_CompleteTagsClient interface {
	Recv() (*CompleteTagsResponse, error)
	grpc.ClientStream
}

type queryCompleteTagsClient struct {
	grpc.ClientStream
}

func (x *queryCompleteTagsClient) Recv() (*CompleteTagsResponse, error) {
	m := new(CompleteTagsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for Query service

type QueryServer interface {
	Health(context.Context, *HealthRequest) (*HealthResponse, error)
	Fetch(*FetchRequest, Query_FetchServer) error
	Search(*SearchRequest, Query_SearchServer) error
	CompleteTags(*CompleteTagsRequest, Query_CompleteTagsServer) error
}

func RegisterQueryServer(s *grpc.Server, srv QueryServer) {
	s.RegisterService(&_Query_serviceDesc, srv)
}

func _Query_Health_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HealthRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).Health(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/rpc.Query/Health",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).Health(ctx, req.(*HealthRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_Fetch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FetchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(QueryServer).Fetch(m, &queryFetchServer{stream})
}

type Query_FetchServer interface {
	Send(*FetchResponse) error
	grpc.ServerStream
}

type queryFetchServer struct {
	grpc.ServerStream
}

func (x *queryFetchServer) Send(m *FetchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Query_Search_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SearchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(QueryServer).Search(m, &querySearchServer{stream})
}

type Query_SearchServer interface {
	Send(*SearchResponse) error
	grpc.ServerStream
}

type querySearchServer struct {
	grpc.ServerStream
}

func (x *querySearchServer) Send(m *SearchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Query_CompleteTags_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CompleteTagsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(QueryServer).CompleteTags(m, &queryCompleteTagsServer{stream})
}

type Query_CompleteTagsServer interface {
	Send(*CompleteTagsResponse) error
	grpc.ServerStream
}

type queryCompleteTagsServer struct {
	grpc.ServerStream
}

func (x *queryCompleteTagsServer) Send(m *CompleteTagsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _Query_serviceDesc = grpc.ServiceDesc{
	ServiceName: "rpc.Query",
	HandlerType: (*QueryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Health",
			Handler:    _Query_Health_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Fetch",
			Handler:       _Query_Fetch_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Search",
			Handler:       _Query_Search_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "CompleteTags",
			Handler:       _Query_CompleteTags_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "github.com/m3db/m3/src/query/generated/proto/rpcpb/query.proto",
}

func (m *HealthRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *HealthResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UptimeDuration) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.UptimeDuration)))
		i += copy(dAtA[i:], m.UptimeDuration)
	}
	if m.UptimeNanoseconds != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.UptimeNanoseconds))
	}
	return i, nil
}

func (m *FetchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FetchRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Start != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Start))
	}
	if m.End != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.End))
	}
	if m.Matchers != nil {
		nn1, err := m.Matchers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if m.Options != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Options.Size()))
		n2, err := m.Options.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *FetchRequest_TagMatchers) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TagMatchers != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.TagMatchers.Size()))
		n3, err := m.TagMatchers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *TagMatchers) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TagMatchers) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TagMatchers) > 0 {
		for _, msg := range m.TagMatchers {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuery(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *TagMatcher) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TagMatcher) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	if m.Type != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Type))
	}
	return i, nil
}

func (m *FetchOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FetchOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Limit != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Limit))
	}
	if m.Restrict != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Restrict.Size()))
		n4, err := m.Restrict.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.LookbackDuration != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.LookbackDuration))
	}
	if m.Unaggregated != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Unaggregated))
	}
	if m.Aggregated != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Aggregated))
	}
	if m.AggregatedOptimized != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.AggregatedOptimized))
	}
	if m.IncludeResolution {
		dAtA[i] = 0x38
		i++
		if m.IncludeResolution {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RestrictFetchOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RestrictFetchOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MetricsType != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.MetricsType))
	}
	if m.MetricsStoragePolicy != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.MetricsStoragePolicy.Size()))
		n5, err := m.MetricsStoragePolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *FetchResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FetchResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Series) > 0 {
		for _, msg := range m.Series {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuery(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Meta != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Meta.Size()))
		n6, err := m.Meta.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}

func (m *Series) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Series) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Meta != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Meta.Size()))
		n7, err := m.Meta.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Value != nil {
		nn8, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn8
	}
	return i, nil
}

func (m *Series_Decompressed) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Decompressed != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Decompressed.Size()))
		n9, err := m.Decompressed.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *Series_Compressed) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Compressed != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Compressed.Size()))
		n10, err := m.Compressed.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *SeriesMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SeriesMetadata) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if m.StartTime != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.StartTime))
	}
	if m.EndTime != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.EndTime))
	}
	return i, nil
}

func (m *DecompressedSeries) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DecompressedSeries) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Datapoints) > 0 {
		for _, msg := range m.Datapoints {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuery(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Tags) > 0 {
		for _, msg := range m.Tags {
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuery(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Datapoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Datapoint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Timestamp))
	}
	if m.Value != 0 {
		dAtA[i] = 0x11
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Value))))
		i += 8
	}
	return i, nil
}

func (m *Tag) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tag) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *M3CompressedSeries) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *M3CompressedSeries) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.CompressedTags) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.CompressedTags)))
		i += copy(dAtA[i:], m.CompressedTags)
	}
	if len(m.Replicas) > 0 {
		for _, msg := range m.Replicas {
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuery(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *M3CompressedValuesReplica) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *M3CompressedValuesReplica) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Segments) > 0 {
		for _, msg := range m.Segments {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuery(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *M3Segments) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *M3Segments) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Merged != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Merged.Size()))
		n11, err := m.Merged.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if len(m.Unmerged) > 0 {
		for _, msg := range m.Unmerged {
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuery(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *M3Segment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *M3Segment) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Head) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Head)))
		i += copy(dAtA[i:], m.Head)
	}
	if len(m.Tail) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Tail)))
		i += copy(dAtA[i:], m.Tail)
	}
	if m.StartTime != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.StartTime))
	}
	if m.BlockSize != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.BlockSize))
	}
	return i, nil
}

func (m *SearchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SearchRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Matchers != nil {
		nn12, err := m.Matchers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn12
	}
	if m.Start != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Start))
	}
	if m.End != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.End))
	}
	if m.Options != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Options.Size()))
		n13, err := m.Options.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}

func (m *SearchRequest_TagMatchers) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TagMatchers != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.TagMatchers.Size()))
		n14, err := m.TagMatchers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}
func (m *M3TagProperty) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *M3TagProperty) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.CompressedTags) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.CompressedTags)))
		i += copy(dAtA[i:], m.CompressedTags)
	}
	return i, nil
}

func (m *M3TagProperties) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *M3TagProperties) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Properties) > 0 {
		for _, msg := range m.Properties {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuery(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *TagProperty) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TagProperty) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.Values) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Values)))
		i += copy(dAtA[i:], m.Values)
	}
	return i, nil
}

func (m *TagProperties) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TagProperties) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Properties) > 0 {
		for _, msg := range m.Properties {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuery(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *SearchResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SearchResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn15, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn15
	}
	if m.Meta != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Meta.Size()))
		n16, err := m.Meta.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}

func (m *SearchResponse_Decompressed) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Decompressed != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Decompressed.Size()))
		n17, err := m.Decompressed.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}
func (m *SearchResponse_Compressed) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Compressed != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Compressed.Size()))
		n18, err := m.Compressed.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	return i, nil
}
func (m *CompleteTagsRequestOptions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompleteTagsRequestOptions) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Type))
	}
	if len(m.FilterNameTags) > 0 {
		for _, b := range m.FilterNameTags {
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuery(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	if m.Start != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Start))
	}
	if m.End != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.End))
	}
	if m.Options != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Options.Size()))
		n19, err := m.Options.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	return i, nil
}

func (m *CompleteTagsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompleteTagsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Matchers != nil {
		nn20, err := m.Matchers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn20
	}
	if m.Options != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Options.Size()))
		n21, err := m.Options.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	return i, nil
}

func (m *CompleteTagsRequest_TagMatchers) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TagMatchers != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.TagMatchers.Size()))
		n22, err := m.TagMatchers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	return i, nil
}
func (m *TagNames) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TagNames) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Names) > 0 {
		for _, b := range m.Names {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuery(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	return i, nil
}

func (m *TagValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TagValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.Values) > 0 {
		for _, b := range m.Values {
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuery(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	return i, nil
}

func (m *TagValues) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TagValues) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Values) > 0 {
		for _, msg := range m.Values {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuery(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *CompleteTagsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompleteTagsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn23, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn23
	}
	if m.Meta != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Meta.Size()))
		n24, err := m.Meta.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	return i, nil
}

func (m *CompleteTagsResponse_Default) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Default != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.Default.Size()))
		n25, err := m.Default.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	return i, nil
}
func (m *CompleteTagsResponse_NamesOnly) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.NamesOnly != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(m.NamesOnly.Size()))
		n26, err := m.NamesOnly.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	return i, nil
}
func (m *ResultMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResultMetadata) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Exhaustive {
		dAtA[i] = 0x8
		i++
		if m.Exhaustive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Warnings) > 0 {
		for _, msg := range m.Warnings {
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuery(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Resolutions) > 0 {
		dAtA28 := make([]byte, len(m.Resolutions)*10)
		var j27 int
		for _, num1 := range m.Resolutions {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA28[j27] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j27++
			}
			dAtA28[j27] = uint8(num)
			j27++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintQuery(dAtA, i, uint64(j27))
		i += copy(dAtA[i:], dAtA28[:j27])
	}
	return i, nil
}

func (m *Warning) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Warning) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Message) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuery(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	return i, nil
}

func encodeVarintQuery(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HealthRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *HealthResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.UptimeDuration)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	if m.UptimeNanoseconds != 0 {
		n += 1 + sovQuery(uint64(m.UptimeNanoseconds))
	}
	return n
}

func (m *FetchRequest) Size() (n int) {
	var l int
	_ = l
	if m.Start != 0 {
		n += 1 + sovQuery(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovQuery(uint64(m.End))
	}
	if m.Matchers != nil {
		n += m.Matchers.Size()
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func (m *FetchRequest_TagMatchers) Size() (n int) {
	var l int
	_ = l
	if m.TagMatchers != nil {
		l = m.TagMatchers.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}
func (m *TagMatchers) Size() (n int) {
	var l int
	_ = l
	if len(m.TagMatchers) > 0 {
		for _, e := range m.TagMatchers {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	return n
}

func (m *TagMatcher) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovQuery(uint64(m.Type))
	}
	return n
}

func (m *FetchOptions) Size() (n int) {
	var l int
	_ = l
	if m.Limit != 0 {
		n += 1 + sovQuery(uint64(m.Limit))
	}
	if m.Restrict != nil {
		l = m.Restrict.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	if m.LookbackDuration != 0 {
		n += 1 + sovQuery(uint64(m.LookbackDuration))
	}
	if m.Unaggregated != 0 {
		n += 1 + sovQuery(uint64(m.Unaggregated))
	}
	if m.Aggregated != 0 {
		n += 1 + sovQuery(uint64(m.Aggregated))
	}
	if m.AggregatedOptimized != 0 {
		n += 1 + sovQuery(uint64(m.AggregatedOptimized))
	}
	if m.IncludeResolution {
		n += 2
	}
	return n
}

func (m *RestrictFetchOptions) Size() (n int) {
	var l int
	_ = l
	if m.MetricsType != 0 {
		n += 1 + sovQuery(uint64(m.MetricsType))
	}
	if m.MetricsStoragePolicy != nil {
		l = m.MetricsStoragePolicy.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func (m *FetchResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Series) > 0 {
		for _, e := range m.Series {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	if m.Meta != nil {
		l = m.Meta.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func (m *Series) Size() (n int) {
	var l int
	_ = l
	if m.Meta != nil {
		l = m.Meta.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *Series_Decompressed) Size() (n int) {
	var l int
	_ = l
	if m.Decompressed != nil {
		l = m.Decompressed.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}
func (m *Series_Compressed) Size() (n int) {
	var l int
	_ = l
	if m.Compressed != nil {
		l = m.Compressed.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}
func (m *SeriesMetadata) Size() (n int) {
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	if m.StartTime != 0 {
		n += 1 + sovQuery(uint64(m.StartTime))
	}
	if m.EndTime != 0 {
		n += 1 + sovQuery(uint64(m.EndTime))
	}
	return n
}

func (m *DecompressedSeries) Size() (n int) {
	var l int
	_ = l
	if len(m.Datapoints) > 0 {
		for _, e := range m.Datapoints {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	if len(m.Tags) > 0 {
		for _, e := range m.Tags {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	return n
}

func (m *Datapoint) Size() (n int) {
	var l int
	_ = l
	if m.Timestamp != 0 {
		n += 1 + sovQuery(uint64(m.Timestamp))
	}
	if m.Value != 0 {
		n += 9
	}
	return n
}

func (m *Tag) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func (m *M3CompressedSeries) Size() (n int) {
	var l int
	_ = l
	l = len(m.CompressedTags)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	if len(m.Replicas) > 0 {
		for _, e := range m.Replicas {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	return n
}

func (m *M3CompressedValuesReplica) Size() (n int) {
	var l int
	_ = l
	if len(m.Segments) > 0 {
		for _, e := range m.Segments {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	return n
}

func (m *M3Segments) Size() (n int) {
	var l int
	_ = l
	if m.Merged != nil {
		l = m.Merged.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	if len(m.Unmerged) > 0 {
		for _, e := range m.Unmerged {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	return n
}

func (m *M3Segment) Size() (n int) {
	var l int
	_ = l
	l = len(m.Head)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	l = len(m.Tail)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	if m.StartTime != 0 {
		n += 1 + sovQuery(uint64(m.StartTime))
	}
	if m.BlockSize != 0 {
		n += 1 + sovQuery(uint64(m.BlockSize))
	}
	return n
}

func (m *SearchRequest) Size() (n int) {
	var l int
	_ = l
	if m.Matchers != nil {
		n += m.Matchers.Size()
	}
	if m.Start != 0 {
		n += 1 + sovQuery(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovQuery(uint64(m.End))
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func (m *SearchRequest_TagMatchers) Size() (n int) {
	var l int
	_ = l
	if m.TagMatchers != nil {
		l = m.TagMatchers.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}
func (m *M3TagProperty) Size() (n int) {
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	l = len(m.CompressedTags)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func (m *M3TagProperties) Size() (n int) {
	var l int
	_ = l
	if len(m.Properties) > 0 {
		for _, e := range m.Properties {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	return n
}

func (m *TagProperty) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	l = len(m.Values)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func (m *TagProperties) Size() (n int) {
	var l int
	_ = l
	if len(m.Properties) > 0 {
		for _, e := range m.Properties {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	return n
}

func (m *SearchResponse) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	if m.Meta != nil {
		l = m.Meta.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func (m *SearchResponse_Decompressed) Size() (n int) {
	var l int
	_ = l
	if m.Decompressed != nil {
		l = m.Decompressed.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}
func (m *SearchResponse_Compressed) Size() (n int) {
	var l int
	_ = l
	if m.Compressed != nil {
		l = m.Compressed.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}
func (m *CompleteTagsRequestOptions) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovQuery(uint64(m.Type))
	}
	if len(m.FilterNameTags) > 0 {
		for _, b := range m.FilterNameTags {
			l = len(b)
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	if m.Start != 0 {
		n += 1 + sovQuery(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovQuery(uint64(m.End))
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func (m *CompleteTagsRequest) Size() (n int) {
	var l int
	_ = l
	if m.Matchers != nil {
		n += m.Matchers.Size()
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func (m *CompleteTagsRequest_TagMatchers) Size() (n int) {
	var l int
	_ = l
	if m.TagMatchers != nil {
		l = m.TagMatchers.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}
func (m *TagNames) Size() (n int) {
	var l int
	_ = l
	if len(m.Names) > 0 {
		for _, b := range m.Names {
			l = len(b)
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	return n
}

func (m *TagValue) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	if len(m.Values) > 0 {
		for _, b := range m.Values {
			l = len(b)
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	return n
}

func (m *TagValues) Size() (n int) {
	var l int
	_ = l
	if len(m.Values) > 0 {
		for _, e := range m.Values {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	return n
}

func (m *CompleteTagsResponse) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	if m.Meta != nil {
		l = m.Meta.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func (m *CompleteTagsResponse_Default) Size() (n int) {
	var l int
	_ = l
	if m.Default != nil {
		l = m.Default.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}
func (m *CompleteTagsResponse_NamesOnly) Size() (n int) {
	var l int
	_ = l
	if m.NamesOnly != nil {
		l = m.NamesOnly.Size()
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}
func (m *ResultMetadata) Size() (n int) {
	var l int
	_ = l
	if m.Exhaustive {
		n += 2
	}
	if len(m.Warnings) > 0 {
		for _, e := range m.Warnings {
			l = e.Size()
			n += 1 + l + sovQuery(uint64(l))
		}
	}
	if len(m.Resolutions) > 0 {
		l = 0
		for _, e := range m.Resolutions {
			l += sovQuery(uint64(e))
		}
		n += 1 + sovQuery(uint64(l)) + l
	}
	return n
}

func (m *Warning) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovQuery(uint64(l))
	}
	return n
}

func sovQuery(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozQuery(x uint64) (n int) {
	return sovQuery(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *HealthRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UptimeDuration", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UptimeDuration = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UptimeNanoseconds", wireType)
			}
			m.UptimeNanoseconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UptimeNanoseconds |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FetchRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FetchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FetchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagMatchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TagMatchers{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Matchers = &FetchRequest_TagMatchers{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &FetchOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TagMatchers) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TagMatchers: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TagMatchers: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagMatchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TagMatchers = append(m.TagMatchers, &TagMatcher{})
			if err := m.TagMatchers[len(m.TagMatchers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TagMatcher) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TagMatcher: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TagMatcher: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = append(m.Name[:0], dAtA[iNdEx:postIndex]...)
			if m.Name == nil {
				m.Name = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (MatcherType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FetchOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FetchOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FetchOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Restrict", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Restrict == nil {
				m.Restrict = &RestrictFetchOptions{}
			}
			if err := m.Restrict.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LookbackDuration", wireType)
			}
			m.LookbackDuration = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LookbackDuration |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unaggregated", wireType)
			}
			m.Unaggregated = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Unaggregated |= (FanoutOption(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Aggregated", wireType)
			}
			m.Aggregated = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Aggregated |= (FanoutOption(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregatedOptimized", wireType)
			}
			m.AggregatedOptimized = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AggregatedOptimized |= (FanoutOption(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeResolution", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludeResolution = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RestrictFetchOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RestrictFetchOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RestrictFetchOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricsType", wireType)
			}
			m.MetricsType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MetricsType |= (MetricsType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricsStoragePolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetricsStoragePolicy == nil {
				m.MetricsStoragePolicy = &policypb.StoragePolicy{}
			}
			if err := m.MetricsStoragePolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FetchResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FetchResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FetchResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Series", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Series = append(m.Series, &Series{})
			if err := m.Series[len(m.Series)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Meta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Meta == nil {
				m.Meta = &ResultMetadata{}
			}
			if err := m.Meta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Series) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Series: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Series: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Meta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Meta == nil {
				m.Meta = &SeriesMetadata{}
			}
			if err := m.Meta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Decompressed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DecompressedSeries{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Series_Decompressed{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Compressed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &M3CompressedSeries{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Series_Compressed{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SeriesMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SeriesMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SeriesMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = append(m.Id[:0], dAtA[iNdEx:postIndex]...)
			if m.Id == nil {
				m.Id = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			m.StartTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			m.EndTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DecompressedSeries) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DecompressedSeries: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DecompressedSeries: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Datapoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Datapoints = append(m.Datapoints, &Datapoint{})
			if err := m.Datapoints[len(m.Datapoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tags = append(m.Tags, &Tag{})
			if err := m.Tags[len(m.Tags)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Datapoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Datapoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Datapoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			m.Timestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timestamp |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tag) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tag: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tag: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = append(m.Name[:0], dAtA[iNdEx:postIndex]...)
			if m.Name == nil {
				m.Name = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *M3CompressedSeries) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: M3CompressedSeries: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: M3CompressedSeries: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompressedTags", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CompressedTags = append(m.CompressedTags[:0], dAtA[iNdEx:postIndex]...)
			if m.CompressedTags == nil {
				m.CompressedTags = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Replicas = append(m.Replicas, &M3CompressedValuesReplica{})
			if err := m.Replicas[len(m.Replicas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *M3CompressedValuesReplica) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: M3CompressedValuesReplica: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: M3CompressedValuesReplica: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Segments", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Segments = append(m.Segments, &M3Segments{})
			if err := m.Segments[len(m.Segments)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *M3Segments) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: M3Segments: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: M3Segments: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Merged", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Merged == nil {
				m.Merged = &M3Segment{}
			}
			if err := m.Merged.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unmerged", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Unmerged = append(m.Unmerged, &M3Segment{})
			if err := m.Unmerged[len(m.Unmerged)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *M3Segment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: M3Segment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: M3Segment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Head", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Head = append(m.Head[:0], dAtA[iNdEx:postIndex]...)
			if m.Head == nil {
				m.Head = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tail", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tail = append(m.Tail[:0], dAtA[iNdEx:postIndex]...)
			if m.Tail == nil {
				m.Tail = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			m.StartTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockSize", wireType)
			}
			m.BlockSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BlockSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SearchRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SearchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SearchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagMatchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TagMatchers{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Matchers = &SearchRequest_TagMatchers{v}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &FetchOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *M3TagProperty) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: M3TagProperty: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: M3TagProperty: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = append(m.Id[:0], dAtA[iNdEx:postIndex]...)
			if m.Id == nil {
				m.Id = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompressedTags", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CompressedTags = append(m.CompressedTags[:0], dAtA[iNdEx:postIndex]...)
			if m.CompressedTags == nil {
				m.CompressedTags = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *M3TagProperties) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: M3TagProperties: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: M3TagProperties: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Properties = append(m.Properties, &M3TagProperty{})
			if err := m.Properties[len(m.Properties)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TagProperty) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TagProperty: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TagProperty: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values[:0], dAtA[iNdEx:postIndex]...)
			if m.Values == nil {
				m.Values = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TagProperties) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TagProperties: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TagProperties: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Properties = append(m.Properties, &TagProperty{})
			if err := m.Properties[len(m.Properties)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SearchResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SearchResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SearchResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Decompressed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TagProperties{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &SearchResponse_Decompressed{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Compressed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &M3TagProperties{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &SearchResponse_Compressed{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Meta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Meta == nil {
				m.Meta = &ResultMetadata{}
			}
			if err := m.Meta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CompleteTagsRequestOptions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CompleteTagsRequestOptions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CompleteTagsRequestOptions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (CompleteTagsType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterNameTags", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FilterNameTags = append(m.FilterNameTags, make([]byte, postIndex-iNdEx))
			copy(m.FilterNameTags[len(m.FilterNameTags)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &FetchOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CompleteTagsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CompleteTagsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CompleteTagsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagMatchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TagMatchers{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Matchers = &CompleteTagsRequest_TagMatchers{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &CompleteTagsRequestOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TagNames) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TagNames: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TagNames: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Names", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Names = append(m.Names, make([]byte, postIndex-iNdEx))
			copy(m.Names[len(m.Names)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TagValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TagValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TagValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, make([]byte, postIndex-iNdEx))
			copy(m.Values[len(m.Values)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TagValues) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TagValues: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TagValues: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, &TagValue{})
			if err := m.Values[len(m.Values)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CompleteTagsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CompleteTagsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CompleteTagsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TagValues{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &CompleteTagsResponse_Default{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamesOnly", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TagNames{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &CompleteTagsResponse_NamesOnly{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Meta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Meta == nil {
				m.Meta = &ResultMetadata{}
			}
			if err := m.Meta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResultMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResultMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResultMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exhaustive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Exhaustive = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, &Warning{})
			if err := m.Warnings[len(m.Warnings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQuery
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Resolutions = append(m.Resolutions, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQuery
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthQuery
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQuery
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Resolutions = append(m.Resolutions, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Resolutions", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Warning) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Warning: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Warning: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = append(m.Name[:0], dAtA[iNdEx:postIndex]...)
			if m.Name == nil {
				m.Name = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthQuery
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = append(m.Message[:0], dAtA[iNdEx:postIndex]...)
			if m.Message == nil {
				m.Message = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuery(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuery
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQuery(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQuery
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuery
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthQuery
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowQuery
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipQuery(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthQuery = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQuery   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("github.com/m3db/m3/src/query/generated/proto/rpcpb/query.proto", fileDescriptorQuery)
}

var fileDescriptorQuery = []byte{
	// 1579 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0xdb, 0x52, 0x1b, 0x47,
	0x1a, 0xd6, 0x68, 0xd0, 0xe9, 0xd7, 0x01, 0xb9, 0x61, 0xd7, 0x82, 0xf5, 0xb2, 0xd4, 0xec, 0xae,
	0x97, 0xc5, 0x5e, 0x64, 0x83, 0xbd, 0x8e, 0x53, 0x95, 0x83, 0x00, 0x19, 0x28, 0x83, 0x84, 0x5b,
	0x43, 0xec, 0xa4, 0x92, 0x22, 0xad, 0x51, 0x5b, 0x4c, 0xa1, 0x39, 0x78, 0xa6, 0xe5, 0x18, 0x57,
	0x1e, 0x22, 0x95, 0x9b, 0x3c, 0x40, 0x2a, 0x79, 0x02, 0x3f, 0x42, 0x2e, 0x72, 0x99, 0x47, 0x48,
	0x39, 0xb9, 0xc8, 0x63, 0xa4, 0xba, 0xa7, 0xe7, 0x24, 0x89, 0xb2, 0xcb, 0x77, 0xd3, 0xff, 0xb1,
	0xff, 0xbf, 0xbf, 0xfe, 0xfe, 0x1e, 0xf8, 0x70, 0x68, 0xb2, 0xb3, 0x71, 0x7f, 0xc3, 0x70, 0xac,
	0xa6, 0xb5, 0x35, 0xe8, 0x37, 0xad, 0xad, 0xa6, 0xef, 0x19, 0xcd, 0x67, 0x63, 0xea, 0x5d, 0x34,
	0x87, 0xd4, 0xa6, 0x1e, 0x61, 0x74, 0xd0, 0x74, 0x3d, 0x87, 0x39, 0x4d, 0xcf, 0x35, 0xdc, 0x7e,
	0xa0, 0xdb, 0x10, 0x12, 0xa4, 0x7a, 0xae, 0xb1, 0xbc, 0x7b, 0x49, 0x10, 0x8b, 0x32, 0xcf, 0x34,
	0xfc, 0xa9, 0x30, 0xae, 0x33, 0x32, 0x8d, 0x0b, 0xb7, 0x2f, 0x3f, 0x82, 0x50, 0xda, 0x3c, 0x54,
	0xf7, 0x29, 0x19, 0xb1, 0x33, 0x4c, 0x9f, 0x8d, 0xa9, 0xcf, 0xb4, 0xa7, 0x50, 0x0b, 0x05, 0xbe,
	0xeb, 0xd8, 0x3e, 0x45, 0xd7, 0xa1, 0x36, 0x76, 0x99, 0x69, 0xd1, 0xdd, 0xb1, 0x47, 0x98, 0xe9,
	0xd8, 0x0d, 0x65, 0x55, 0x59, 0x2b, 0xe1, 0x09, 0x29, 0xba, 0x09, 0x57, 0x02, 0x49, 0x87, 0xd8,
	0x8e, 0x4f, 0x0d, 0xc7, 0x1e, 0xf8, 0x8d, 0xec, 0xaa, 0xb2, 0xa6, 0xe2, 0x69, 0x85, 0xf6, 0x83,
	0x02, 0x95, 0x07, 0x94, 0x19, 0x61, 0x62, 0xb4, 0x08, 0x39, 0x9f, 0x11, 0x8f, 0x89, 0xe8, 0x2a,
	0x0e, 0x16, 0xa8, 0x0e, 0x2a, 0xb5, 0x07, 0x32, 0x0c, 0xff, 0x44, 0x77, 0xa0, 0xcc, 0xc8, 0xf0,
	0x88, 0x30, 0xe3, 0x8c, 0x7a, 0x7e, 0x43, 0x5d, 0x55, 0xd6, 0xca, 0x9b, 0xf5, 0x0d, 0xcf, 0x35,
	0x36, 0xf4, 0x58, 0xbe, 0x9f, 0xc1, 0x49, 0x33, 0x74, 0x03, 0x0a, 0x8e, 0xcb, 0xb7, 0xe9, 0x37,
	0xe6, 0x84, 0xc7, 0x15, 0xe1, 0x21, 0x76, 0xd0, 0x0d, 0x14, 0x38, 0xb4, 0xd8, 0x06, 0x28, 0x5a,
	0xd2, 0x51, 0xfb, 0x18, 0xca, 0x89, 0xb0, 0xe8, 0x76, 0x3a, 0xbb, 0xb2, 0xaa, 0xae, 0x95, 0x37,
	0xe7, 0x27, 0xb2, 0xa7, 0x52, 0x6b, 0x9f, 0x03, 0xc4, 0x2a, 0x84, 0x60, 0xce, 0x26, 0x16, 0x15,
	0x55, 0x56, 0xb0, 0xf8, 0xe6, 0xa5, 0x3f, 0x27, 0xa3, 0x31, 0x15, 0x65, 0x56, 0x70, 0xb0, 0x40,
	0xff, 0x82, 0x39, 0x76, 0xe1, 0x52, 0x51, 0x61, 0x4d, 0x56, 0x28, 0xa3, 0xe8, 0x17, 0x2e, 0xc5,
	0x42, 0xab, 0xfd, 0x9e, 0x95, 0x7d, 0x94, 0x55, 0xf0, 0x60, 0x23, 0xd3, 0x32, 0xa3, 0x3e, 0x8a,
	0x05, 0xba, 0x0b, 0x45, 0x8f, 0xfa, 0x1c, 0x19, 0x4c, 0x64, 0x29, 0x6f, 0x2e, 0x89, 0x80, 0x58,
	0x0a, 0x53, 0x8d, 0x88, 0x4c, 0xd1, 0x3a, 0xd4, 0x47, 0x8e, 0x73, 0xde, 0x27, 0xc6, 0x79, 0x74,
	0xfa, 0xaa, 0x88, 0x3b, 0x25, 0x47, 0x77, 0xa1, 0x32, 0xb6, 0xc9, 0x70, 0xe8, 0xd1, 0x21, 0x87,
	0x9d, 0xe8, 0x73, 0x2d, 0xec, 0x33, 0xb1, 0x9d, 0x31, 0x0b, 0xe2, 0xe3, 0x94, 0x19, 0xba, 0x0d,
	0x90, 0x70, 0xca, 0x5d, 0xe6, 0x94, 0x30, 0x42, 0x3b, 0xb0, 0x10, 0xaf, 0xb8, 0xde, 0x32, 0x5f,
	0xd2, 0x41, 0x23, 0x7f, 0x99, 0xef, 0x2c, 0x6b, 0x0e, 0x57, 0xd3, 0x36, 0x46, 0xe3, 0x01, 0xc5,
	0xd4, 0x77, 0x46, 0x63, 0x51, 0x5b, 0x61, 0x55, 0x59, 0x2b, 0xe2, 0x69, 0x85, 0xf6, 0x9d, 0x02,
	0x8b, 0xb3, 0x7a, 0x85, 0x36, 0xa1, 0x2c, 0x6f, 0x1c, 0x3f, 0x14, 0xd1, 0xf4, 0xe8, 0xb0, 0x62,
	0x39, 0x4e, 0x1a, 0xa1, 0x87, 0xb0, 0x28, 0x97, 0x3d, 0xe6, 0x78, 0x64, 0x48, 0x8f, 0xc5, 0x95,
	0x94, 0x07, 0x73, 0x75, 0x23, 0xbc, 0xaa, 0x1b, 0x29, 0x35, 0x9e, 0xe9, 0xa4, 0x7d, 0x01, 0x55,
	0x79, 0x8f, 0xe4, 0x7d, 0xfd, 0x27, 0xe4, 0x7d, 0xea, 0x99, 0x34, 0x44, 0x67, 0x59, 0x6c, 0xa6,
	0x27, 0x44, 0x58, 0xaa, 0xd0, 0x7f, 0x60, 0xce, 0xa2, 0x8c, 0xc8, 0x94, 0x0b, 0x21, 0x16, 0xc6,
	0x23, 0x76, 0x44, 0x19, 0x19, 0x10, 0x46, 0xb0, 0x30, 0xd0, 0x5e, 0x29, 0x90, 0xef, 0xa5, 0x7d,
	0x94, 0x84, 0x4f, 0xa0, 0x4a, 0xfb, 0xa0, 0x0f, 0xa0, 0x32, 0xa0, 0x86, 0x63, 0xb9, 0x1e, 0xf5,
	0x7d, 0x3a, 0x88, 0xea, 0xe2, 0x0e, 0xbb, 0x09, 0x45, 0xe0, 0xbc, 0x9f, 0xc1, 0x29, 0x73, 0x74,
	0x1f, 0x20, 0xe1, 0xac, 0x26, 0x9c, 0x8f, 0xb6, 0x76, 0xa6, 0x9d, 0x13, 0xc6, 0xdb, 0x05, 0x79,
	0x93, 0xb4, 0x27, 0x50, 0x4b, 0x6f, 0x0d, 0xd5, 0x20, 0x6b, 0x0e, 0xe4, 0xb5, 0xcb, 0x9a, 0x03,
	0x74, 0x0d, 0x4a, 0x82, 0x62, 0x74, 0xd3, 0xa2, 0x92, 0x5f, 0x62, 0x01, 0x6a, 0x40, 0x81, 0xda,
	0x03, 0xa1, 0x0b, 0xf0, 0x1e, 0x2e, 0xb5, 0x3e, 0xa0, 0xe9, 0x1a, 0xd0, 0x06, 0x00, 0xcf, 0xe2,
	0x3a, 0xa6, 0xcd, 0xc2, 0xc6, 0xd7, 0x82, 0x82, 0x43, 0x31, 0x4e, 0x58, 0xa0, 0x6b, 0x30, 0xc7,
	0xc8, 0x90, 0xf3, 0x23, 0xb7, 0x2c, 0x86, 0x04, 0x82, 0x85, 0x54, 0xfb, 0x08, 0x4a, 0x91, 0x1b,
	0xdf, 0x28, 0x27, 0x4f, 0x9f, 0x11, 0xcb, 0x95, 0x97, 0x3a, 0x16, 0xa4, 0xb9, 0x43, 0x91, 0xdc,
	0xa1, 0x35, 0x41, 0xd5, 0xc9, 0xf0, 0xed, 0xc9, 0x46, 0x7b, 0x01, 0x68, 0xba, 0xb9, 0x9c, 0xfa,
	0xe3, 0x4a, 0x75, 0xbe, 0xdf, 0x20, 0xd2, 0x84, 0x14, 0xbd, 0xcf, 0xd9, 0xc5, 0x1d, 0x99, 0x06,
	0x09, 0x2b, 0x5a, 0x99, 0x3a, 0xaf, 0x4f, 0x78, 0x1e, 0x1f, 0x07, 0x66, 0x38, 0xb2, 0xd7, 0xf6,
	0x61, 0xe9, 0x52, 0x33, 0x74, 0x03, 0x8a, 0x3e, 0x1d, 0x5a, 0x34, 0x6e, 0xea, 0xbc, 0x0c, 0xdc,
	0x93, 0x62, 0x1c, 0x19, 0x68, 0x5f, 0x02, 0xc4, 0x72, 0x74, 0x1d, 0xf2, 0x16, 0xf5, 0x86, 0x74,
	0x20, 0xf1, 0x5a, 0x4b, 0x3b, 0x62, 0xa9, 0x45, 0xeb, 0x50, 0x1c, 0xdb, 0xd2, 0x32, 0x9b, 0x38,
	0xb7, 0xd8, 0x32, 0xd2, 0x6b, 0x0e, 0x94, 0x22, 0x31, 0x6f, 0xee, 0x19, 0x25, 0x21, 0xa4, 0xc4,
	0x37, 0x97, 0x31, 0x62, 0x8e, 0x64, 0x6f, 0xc5, 0x77, 0x1a, 0x68, 0xea, 0x24, 0xd0, 0xae, 0x41,
	0xa9, 0x3f, 0x72, 0x8c, 0xf3, 0x9e, 0xf9, 0x92, 0x0a, 0xca, 0x54, 0x71, 0x2c, 0xd0, 0x7e, 0x54,
	0xa0, 0xda, 0xa3, 0xc4, 0x8b, 0xc7, 0xe4, 0x9d, 0xc9, 0x01, 0xf4, 0x56, 0xe3, 0x2f, 0x1a, 0xae,
	0xd9, 0x19, 0xc3, 0x55, 0x8d, 0x87, 0xeb, 0x3b, 0x8f, 0xc9, 0x3d, 0xa8, 0x1e, 0x6d, 0xe9, 0x64,
	0x78, 0xec, 0x39, 0x2e, 0xf5, 0xd8, 0xc5, 0xd4, 0x75, 0x9b, 0x86, 0x52, 0x76, 0x16, 0x94, 0xb4,
	0x36, 0xcc, 0x27, 0x03, 0x71, 0x14, 0x6e, 0x02, 0xb8, 0xd1, 0x4a, 0xc2, 0x00, 0xc9, 0x33, 0x4a,
	0xa4, 0xc4, 0x09, 0x2b, 0xed, 0x9e, 0x18, 0xdb, 0xd1, 0x6e, 0xea, 0xa0, 0x9e, 0xd3, 0x0b, 0xb9,
	0x1d, 0xfe, 0x89, 0xfe, 0x0a, 0x79, 0x81, 0xfc, 0x70, 0x1f, 0x72, 0xa5, 0xb5, 0xa0, 0x9a, 0xce,
	0x7e, 0x6b, 0x46, 0xf6, 0xa8, 0xdf, 0x33, 0x73, 0xbf, 0x52, 0x38, 0xf9, 0x04, 0x87, 0x26, 0x39,
	0xf9, 0xbd, 0x09, 0x46, 0x0c, 0x8e, 0x0d, 0x4d, 0x84, 0x99, 0x45, 0x86, 0xff, 0x4f, 0x91, 0x61,
	0xc0, 0xa4, 0x8b, 0x53, 0xc5, 0x4f, 0x31, 0x61, 0x44, 0xd6, 0xea, 0x1b, 0x08, 0x3e, 0xa6, 0xcc,
	0x9f, 0x14, 0x58, 0xe6, 0xf7, 0x70, 0x44, 0x19, 0xe5, 0x47, 0x21, 0x11, 0x17, 0x0e, 0xba, 0xff,
	0xca, 0xe7, 0x48, 0x30, 0xe1, 0xfe, 0x22, 0x02, 0x26, 0xcd, 0xe3, 0x37, 0x09, 0x3f, 0xeb, 0xa7,
	0xe6, 0x88, 0x51, 0xaf, 0x43, 0x2c, 0xaa, 0x87, 0x34, 0x57, 0xc1, 0x13, 0xd2, 0x18, 0x95, 0xea,
	0x0c, 0x54, 0xce, 0xcd, 0x44, 0x65, 0xee, 0x4d, 0xa8, 0xd4, 0xbe, 0x55, 0x60, 0x61, 0x46, 0x19,
	0xef, 0x78, 0x71, 0xee, 0xc7, 0xa9, 0x83, 0xde, 0xff, 0x63, 0xaa, 0xf0, 0x74, 0x9f, 0x66, 0x5f,
	0x8f, 0x55, 0x28, 0xea, 0x64, 0xc8, 0x0b, 0x17, 0x55, 0x73, 0x22, 0x0e, 0xb0, 0x54, 0xc1, 0xc1,
	0x42, 0xbb, 0x23, 0x2c, 0x04, 0xfb, 0xbd, 0x01, 0xad, 0x6a, 0x02, 0xad, 0x9b, 0x50, 0x0a, 0xbd,
	0x7c, 0xf4, 0xef, 0xc8, 0x28, 0x40, 0x69, 0x35, 0x2c, 0x4e, 0xe8, 0x23, 0x9f, 0xef, 0x15, 0x58,
	0x4c, 0xef, 0x5f, 0x82, 0x74, 0x1d, 0x0a, 0x03, 0xfa, 0x94, 0x8c, 0x47, 0x2c, 0x45, 0x99, 0x51,
	0x82, 0xfd, 0x0c, 0x0e, 0x0d, 0xd0, 0xff, 0xa0, 0x24, 0xf6, 0xdd, 0xb5, 0x47, 0xe1, 0xbb, 0x25,
	0x4a, 0x27, 0xca, 0xdc, 0xcf, 0xe0, 0xd8, 0xe2, 0x1d, 0xd0, 0xf8, 0x35, 0xd4, 0xd2, 0x06, 0x68,
	0x05, 0x80, 0xbe, 0x38, 0x23, 0x63, 0x9f, 0x99, 0xcf, 0x03, 0x18, 0x16, 0x71, 0x42, 0x82, 0xd6,
	0xa0, 0xf8, 0x15, 0xf1, 0x6c, 0xd3, 0x8e, 0xc6, 0x6a, 0x45, 0xe4, 0x79, 0x1c, 0x08, 0x71, 0xa4,
	0x45, 0xab, 0x50, 0xf6, 0xa2, 0xa7, 0x1d, 0xff, 0x85, 0x50, 0xd7, 0x54, 0x9c, 0x14, 0x69, 0xf7,
	0xa0, 0x20, 0xdd, 0x66, 0xce, 0xd0, 0x06, 0x14, 0x2c, 0xea, 0xfb, 0x64, 0x18, 0x4e, 0xd1, 0x70,
	0xb9, 0x4e, 0xa1, 0x9c, 0x78, 0xa3, 0xa3, 0x12, 0xe4, 0xda, 0x8f, 0x4e, 0x5a, 0x87, 0xf5, 0x0c,
	0xaa, 0x40, 0xb1, 0xd3, 0xd5, 0x83, 0x95, 0x82, 0x00, 0xf2, 0xb8, 0xbd, 0xd7, 0x7e, 0x72, 0x5c,
	0xcf, 0xa2, 0x2a, 0x94, 0x3a, 0x5d, 0x5d, 0x2e, 0x55, 0xae, 0x6a, 0x3f, 0x39, 0xe8, 0xe9, 0xbd,
	0xfa, 0x9c, 0x54, 0xc9, 0x65, 0x0e, 0x15, 0x40, 0x6d, 0x1d, 0x1e, 0xd6, 0xf3, 0xeb, 0x06, 0x94,
	0x13, 0xaf, 0x4b, 0xd4, 0x80, 0xc5, 0x93, 0xce, 0xc3, 0x4e, 0xf7, 0x71, 0xe7, 0xf4, 0xa8, 0xad,
	0xe3, 0x83, 0x9d, 0xde, 0xa9, 0xfe, 0xe9, 0x71, 0xbb, 0x9e, 0x41, 0x7f, 0x87, 0xa5, 0x93, 0x4e,
	0x6b, 0x6f, 0x0f, 0xb7, 0xf7, 0x5a, 0x7a, 0x7b, 0x37, 0xad, 0x56, 0xd0, 0xdf, 0xe0, 0xea, 0x65,
	0xca, 0xec, 0xfa, 0x01, 0x54, 0x92, 0xcf, 0x68, 0x84, 0xa0, 0xb6, 0xdb, 0x7e, 0xd0, 0x3a, 0x39,
	0xd4, 0x4f, 0xbb, 0xc7, 0xfa, 0x41, 0xb7, 0x53, 0xcf, 0xa0, 0x2b, 0x50, 0x7d, 0xd0, 0xc5, 0x3b,
	0xed, 0xd3, 0x76, 0xa7, 0xb5, 0x7d, 0xd8, 0xde, 0xad, 0x2b, 0xdc, 0x2c, 0x10, 0xed, 0x1e, 0xf4,
	0x02, 0x59, 0x76, 0xfd, 0x26, 0xd4, 0x27, 0xb9, 0x02, 0x95, 0xa1, 0x20, 0xc3, 0xd5, 0x33, 0x7c,
	0xa1, 0xb7, 0xf6, 0x3a, 0xad, 0xa3, 0x76, 0x5d, 0xd9, 0xfc, 0x43, 0x81, 0xdc, 0x23, 0xfe, 0xbf,
	0x8b, 0x6e, 0x43, 0x3e, 0xf8, 0x1b, 0x45, 0x01, 0x57, 0xa6, 0xfe, 0x55, 0x97, 0x17, 0x52, 0x32,
	0x89, 0xe2, 0x5b, 0x90, 0x13, 0xc4, 0x80, 0x12, 0x24, 0x11, 0x3a, 0xa0, 0xa4, 0x28, 0xb0, 0xbf,
	0xa5, 0xa0, 0x2d, 0xfe, 0xc2, 0xe5, 0x74, 0x2d, 0x93, 0xa4, 0x06, 0xee, 0xf2, 0x42, 0x4a, 0x16,
	0x39, 0xb5, 0xa1, 0x92, 0xac, 0x08, 0x35, 0x2e, 0xe3, 0x85, 0xe5, 0xa5, 0x19, 0x9a, 0x30, 0xcc,
	0xf6, 0xd5, 0x9f, 0x5f, 0xaf, 0x28, 0xbf, 0xbc, 0x5e, 0x51, 0x7e, 0x7d, 0xbd, 0xa2, 0x7c, 0xf3,
	0xdb, 0x4a, 0xe6, 0xb3, 0x9c, 0xf8, 0xdf, 0xef, 0xe7, 0xc5, 0xff, 0xf9, 0xd6, 0x9f, 0x01, 0x00,
	0x00, 0xff, 0xff, 0xf3, 0x1f, 0xfe, 0x09, 0x2c, 0x10, 0x00, 0x00,
}
