// Copyright (c) 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

package config_test

import (
	"flag"
	"fmt"
	"log"

	"github.com/m3db/m3/src/x/config"
)

type configuration struct {
	ListenAddress string `yaml:"listenAddress" validate:"nonzero"`
}

func ExampleLoadFile() {
	var cfg configuration
	file := "testdata/conf.yaml"
	if err := config.LoadFile(&cfg, file, config.Options{}); err != nil {
		log.Fatal(err)
	}
	fmt.Printf("listenAddress: %s\n", cfg.ListenAddress)
	// Output: listenAddress: 0.0.0.0:8392
}

// The FlagStringSlice allows for multiple values when used as a flag variable.
func ExampleFlagStringSlice() {
	var configFiles config.FlagStringSlice
	fs := flag.NewFlagSet("config", flag.PanicOnError)
	fs.Var(&configFiles, "f", "config files")
	fs.Parse([]string{"-f", "file1.yaml", "-f", "file2.yaml", "-f", "file3.yaml"})
	fmt.Println("Config files:", configFiles)
	// Output:
	// Config files: [file1.yaml file2.yaml file3.yaml]
}
