#region License
/* 
 * Copyright (C) 1999-2024 John Källén.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Reko.Core;
using Reko.Core.Machine;

namespace Reko.Arch.Vax
{
    using Decoder = Decoder<VaxDisassembler, Mnemonic, VaxInstruction>;

    public partial class VaxDisassembler
    {
        // http://www2.hmc.edu/www_common/OVMS072-OLD/72final/4515/4515pro_038.html#mnemonics

        private static Decoder[] oneByteInstructions = new[]
        {
 /* 00 */ Instr(Mnemonic.halt, InstrClass.Privileged|InstrClass.Terminates|InstrClass.Zero), 
 /* 01 */ Instr(Mnemonic.nop, InstrClass.Padding|InstrClass.Linear), 
 /* 02 */ Instr(Mnemonic.rei, InstrClass.Transfer|InstrClass.Return), 
 /* 03 */ Instr(Mnemonic.bpt), 
 /* 04 */ Instr(Mnemonic.ret, InstrClass.Transfer|InstrClass.Return), 
 /* 05 */ Instr(Mnemonic.rsb, InstrClass.Transfer|InstrClass.Return), 
 /* 06 */ Instr(Mnemonic.ldpctx), 
 /* 07 */ Instr(Mnemonic.svpctx), 
 /* 08 */ Instr(Mnemonic.cvtps, rw,ab,rw,ab), 
 /* 09 */ Instr(Mnemonic.cvtsp, rw,ab,rw,ab),
 /* 0A */ Instr(Mnemonic.index, rl,rl,rl,rl,rl,wl),
 /* 0B */ Instr(Mnemonic.crc, ab,rl,rw,ab), 
 /* 0C */ Instr(Mnemonic.prober, rb,rw,ab), 
 /* 0D */ Instr(Mnemonic.probew, rb,rw,ab), 
 /* 0E */ Instr(Mnemonic.insque, ab,ab), 
 /* 0F */ Instr(Mnemonic.remque, ab,wl), 

 /* 10 */ Instr(Mnemonic.bsbb, InstrClass.Transfer, bb), 
 /* 11 */ Instr(Mnemonic.brb, InstrClass.Transfer, bb), 
 /* 12 */ Instr(Mnemonic.bneq, InstrClass.ConditionalTransfer, bb),    // bnequ
 /* 13 */ Instr(Mnemonic.beql, InstrClass.ConditionalTransfer, bb),  // beqlu
 /* 14 */ Instr(Mnemonic.bgtr, InstrClass.ConditionalTransfer, bb), 
 /* 15 */ Instr(Mnemonic.bleq, InstrClass.ConditionalTransfer, bb), 
 /* 16 */ Instr(Mnemonic.jsb, InstrClass.Transfer|InstrClass.Call, ab), 
 /* 17 */ Instr(Mnemonic.jmp, InstrClass.Transfer, ab), 
 /* 18 */ Instr(Mnemonic.bgeq, InstrClass.ConditionalTransfer, bb), 
 /* 19 */ Instr(Mnemonic.blss, InstrClass.ConditionalTransfer, bb), 
 /* 1A */ Instr(Mnemonic.bgtru, InstrClass.ConditionalTransfer, bb), 
 /* 1B */ Instr(Mnemonic.blequ, InstrClass.ConditionalTransfer, bb), 
 /* 1C */ Instr(Mnemonic.bvc, InstrClass.ConditionalTransfer, bb), 
 /* 1D */ Instr(Mnemonic.bvs, InstrClass.ConditionalTransfer, bb), 
 /* 1E */ Instr(Mnemonic.bgequ, InstrClass.ConditionalTransfer, bb), // bcc, 
 /* 1F */ Instr(Mnemonic.blssu, InstrClass.ConditionalTransfer, bb), //  bcs, 

 /* 20 */ Instr(Mnemonic.addp4, rw,ab,rw,ab),
 /* 21 */ Instr(Mnemonic.addp6, rw,ab,rw,ab,rw,ab),
 /* 22 */ Instr(Mnemonic.subp4, rw,ab,rw,ab),
 /* 23 */ Instr(Mnemonic.subp6, rw,ab,rw,ab,rw,ab),
 /* 24 */ Instr(Mnemonic.cvtpt, rw,ab,ab,rw),
 /* 25 */ Instr(Mnemonic.mulp,  rw,ab,rw,ab,rw,ab),
 /* 26 */ Instr(Mnemonic.cvttp, rw,ab,ab,rw),
 /* 27 */ Instr(Mnemonic.divp,  rw,ab,rw,ab,rw,ab),
 /* 28 */ Instr(Mnemonic.movc3, rw,ab,ab),
 /* 29 */ Instr(Mnemonic.cmpc3, rw,ab,ab),
 /* 2A */ Instr(Mnemonic.scanc, rw,ab,ab,rb),
 /* 2B */ Instr(Mnemonic.spanc, rw,ab,ab,rb),
 /* 2C */ Instr(Mnemonic.movc5,  -1), 
 /* 2D */ Instr(Mnemonic.cmpc5, rw,ab,rb,rw,ab), 
 /* 2E */ Instr(Mnemonic.movtc,  -1), 
 /* 2F */ Instr(Mnemonic.movtuc,  -1), 

 /* 30 */ Instr(Mnemonic.bsbw,  InstrClass.Transfer, bw), 
 /* 31 */ Instr(Mnemonic.brw,   InstrClass.Transfer, bw), 
 /* 32 */ Instr(Mnemonic.cvtwl, rw,wl),
 /* 33 */ Instr(Mnemonic.cvtwb, rw,wb), 
 /* 34 */ Instr(Mnemonic.movp,  rw,ab,ab), 
 /* 35 */ Instr(Mnemonic.cmpp3,  rw,ab,ab), 
 /* 36 */ Instr(Mnemonic.cvtpl,  -1), 
 /* 37 */ Instr(Mnemonic.cmpp4,  rw,ab,rw,ab), 
 /* 38 */ Instr(Mnemonic.editpc,  -1), 
 /* 39 */ Instr(Mnemonic.matchc, rw,ab,rw,ab), 
 /* 3A */ Instr(Mnemonic.locc,  -1), 
 /* 3B */ Instr(Mnemonic.skpc,  -1), 
 /* 3C */ Instr(Mnemonic.movzwl, rw,wl),
 /* 3D */ Instr(Mnemonic.acbw,  InstrClass.ConditionalTransfer, rw,rw,mw,bw),
 /* 3E */ Instr(Mnemonic.movaw,  aw,wl), 
 /* 3F */ Instr(Mnemonic.pushaw, aw), 
 
 /* 40 */ Instr(Mnemonic.addf2, rf,wf), 
 /* 41 */ Instr(Mnemonic.addf3, rf,rf,wf), 
 /* 42 */ Instr(Mnemonic.subf2, rf,wf), 
 /* 43 */ Instr(Mnemonic.subf3, rf,rf,wf), 
 /* 44 */ Instr(Mnemonic.mulf2, rf,wf), 
 /* 45 */ Instr(Mnemonic.mulf3, rf,rf,wf), 
 /* 46 */ Instr(Mnemonic.divf2, rf,wf), 
 /* 47 */ Instr(Mnemonic.divf3, rf,rf,wf), 
 /* 48 */ Instr(Mnemonic.cvtfb, rf,wb),
 /* 49 */ Instr(Mnemonic.cvtfw, rf,ww),
 /* 4A */ Instr(Mnemonic.cvtfl, rf,wl), 
 /* 4B */ Instr(Mnemonic.cvtrfl, rf,wl),
 /* 4C */ Instr(Mnemonic.cvtbf, rb,wf),
 /* 4D */ Instr(Mnemonic.cvtwf, rw,wf),
 /* 4E */ Instr(Mnemonic.cvtlf, rl,wf), 
 /* 4F */ Instr(Mnemonic.acbf,  InstrClass.ConditionalTransfer, rf,rf,mf,bw),

 /* 50 */ Instr(Mnemonic.movf,  rf,wf),
 /* 51 */ Instr(Mnemonic.cmpf,  rf,rf), 
 /* 52 */ Instr(Mnemonic.mnegf, rf,wf), 
 /* 53 */ Instr(Mnemonic.tstf,  rf), 
 /* 54 */ Instr(Mnemonic.emodf, rf,rb,rd,wl,wf), 
 /* 55 */ Instr(Mnemonic.polyf, rf,rw,ab), 
 /* 56 */ Instr(Mnemonic.cvtfd, rf,wd),
 /* 57 */ Instr(Mnemonic.Reserved ,  -1), 
 /* 58 */ Instr(Mnemonic.adawi, rw,aw), 
 /* 59 */ Instr(Mnemonic.Reserved,  -1), 
 /* 5A */ Instr(Mnemonic.Reserved,  -1), 
 /* 5B */ Instr(Mnemonic.Reserved,  -1), 
 /* 5C */ Instr(Mnemonic.insqhi,  -1), 
 /* 5D */ Instr(Mnemonic.insqti,  -1), 
 /* 5E */ Instr(Mnemonic.remqhi,  -1), 
 /* 5F */ Instr(Mnemonic.remqti,  -1), 

 /* 60 */ Instr(Mnemonic.addd2,  rd,rw), 
 /* 61 */ Instr(Mnemonic.addd3,  rd,rd,wd), 
 /* 62 */ Instr(Mnemonic.subd2,  rd,rw), 
 /* 63 */ Instr(Mnemonic.subd3,  rd,rd,wd),  
 /* 64 */ Instr(Mnemonic.muld2,  rd,rw), 
 /* 65 */ Instr(Mnemonic.muld3,  rd,rd,wd),
 /* 66 */ Instr(Mnemonic.divd2,  rd,rw), 
 /* 67 */ Instr(Mnemonic.divd3,  rd,rd,wd),
 /* 68 */ Instr(Mnemonic.cvtdb,  rd,rb),  
 /* 69 */ Instr(Mnemonic.cvtdw,  rd,rw),  
 /* 6A */ Instr(Mnemonic.cvtdl,  rd,rl),  
 /* 6B */ Instr(Mnemonic.cvtrdl, rd,rl), 
 /* 6C */ Instr(Mnemonic.cvtbd,  rb,rd),
 /* 6D */ Instr(Mnemonic.cvtwd,  rw,rd),
 /* 6E */ Instr(Mnemonic.cvtld,  rl,rd),
 /* 6F */ Instr(Mnemonic.acbd,   InstrClass.ConditionalTransfer, rd,rd,md,bw),

 /* 70 */ Instr(Mnemonic.movd,  rd,wd), 
 /* 71 */ Instr(Mnemonic.cmpd,  rd,rd), 
 /* 72 */ Instr(Mnemonic.mnegd, rd,wd), 
 /* 73 */ Instr(Mnemonic.tstd,  rd), 
 /* 74 */ Instr(Mnemonic.emodd, rd,rb,rd,wl,wd), 
 /* 75 */ Instr(Mnemonic.polyd, rd,rw,ab), 
 /* 76 */ Instr(Mnemonic.cvtdf, rd,wf), 
 /* 77 */ Instr(Mnemonic.Reserved,  -1), 
 /* 78 */ Instr(Mnemonic.ashl, rb,rl,wl), 
 /* 79 */ Instr(Mnemonic.ashq, rb,rq,wq), 
 /* 7A */ Instr(Mnemonic.emul, rl,rl,rl,wq), 
 /* 7B */ Instr(Mnemonic.ediv, rl,rq,wl,wl), 
 /* 7C */ Instr(Mnemonic.clrq, wq), //  clrd,  clrg,  -1), 
 /* 7D */ Instr(Mnemonic.movq, rq,wq), 
 /* 7E */ Instr(Mnemonic.movaq, aq,wl), //  movad,  movag,  -1), 
 /* 7F */ Instr(Mnemonic.pushaq, aq), //  pushad,  pushag,  -1), 

 /* 80 */ Instr(Mnemonic.addb2, rb,wb), 
 /* 81 */ Instr(Mnemonic.addb3, rb,rb,wb), 
 /* 82 */ Instr(Mnemonic.subb2, rb,wb), 
 /* 83 */ Instr(Mnemonic.subb3, rb,rb,wb), 
 /* 84 */ Instr(Mnemonic.mulb2, rb,rb), 
 /* 85 */ Instr(Mnemonic.mulb3, rb,rb,wb), 
 /* 86 */ Instr(Mnemonic.divb2, rb,rb), 
 /* 87 */ Instr(Mnemonic.divb3, rb,rb,wb), 
 /* 88 */ Instr(Mnemonic.bisb2, rb,rb), 
 /* 89 */ Instr(Mnemonic.bisb3, rb,rb,wb), 
 /* 8A */ Instr(Mnemonic.bicb2, rb,rb), 
 /* 8B */ Instr(Mnemonic.bicb3, rb,rb,wb), 
 /* 8C */ Instr(Mnemonic.xorb2, rb,wb),  
 /* 8D */ Instr(Mnemonic.xorb3, rb,rb,wb),  
 /* 8E */ Instr(Mnemonic.mnegb, rb,wb), 
 /* 8F */ Instr(Mnemonic.caseb, InstrClass.Transfer, rb,rb,rb),

 /* 90 */ Instr(Mnemonic.movb,  rb,wb), 
 /* 91 */ Instr(Mnemonic.cmpb,  rb,rb), 
 /* 92 */ Instr(Mnemonic.mcomb,  rb,wb), 
 /* 93 */ Instr(Mnemonic.bitb,  rb,rb), 
 /* 94 */ Instr(Mnemonic.clrb,  wb), 
 /* 95 */ Instr(Mnemonic.tstb,  rb), 
 /* 96 */ Instr(Mnemonic.incb,  wb), 
 /* 97 */ Instr(Mnemonic.decb,  wb), 
 /* 98 */ Instr(Mnemonic.cvtbl, rb,wl), 
 /* 99 */ Instr(Mnemonic.cvtbw, rb,ww), 
 /* 9A */ Instr(Mnemonic.movzbl, rb,wl), 
 /* 9B */ Instr(Mnemonic.movzbw, rb,ww),
 /* 9C */ Instr(Mnemonic.rotl,  rb,rl,wl),
 /* 9D */ Instr(Mnemonic.acbb,  InstrClass.ConditionalTransfer, rb,rb,mb,bw), 
 /* 9E */ Instr(Mnemonic.movab,  ab,wl), 
 /* 9F */ Instr(Mnemonic.pushab, ab), 

 /* A0 */ Instr(Mnemonic.addw2, rw,ww), 
 /* A1 */ Instr(Mnemonic.addw3, rw,rw,ww), 
 /* A2 */ Instr(Mnemonic.subw2, rw,ww), 
 /* A3 */ Instr(Mnemonic.subw3, rw,rw,ww), 
 /* A4 */ Instr(Mnemonic.mulw2, rw,ww), 
 /* A5 */ Instr(Mnemonic.mulw3, rw,rw,ww), 
 /* A6 */ Instr(Mnemonic.divw2, rw,ww), 
 /* A7 */ Instr(Mnemonic.divw3, rw,rw,ww), 
 /* A8 */ Instr(Mnemonic.bisw2, rw,ww), 
 /* A9 */ Instr(Mnemonic.bisw3, rw,rw,ww), 
 /* AA */ Instr(Mnemonic.bicw2, rw,ww), 
 /* AB */ Instr(Mnemonic.bicw3, rw,rw,ww), 
 /* AC */ Instr(Mnemonic.xorw2, rw,ww), 
 /* AD */ Instr(Mnemonic.xorw3, rw,rw,ww), 
 /* AE */ Instr(Mnemonic.mnegw, rw,ww),
 /* AF */ Instr(Mnemonic.casew, InstrClass.Transfer, rw,rw,rw), 

 /* B0 */ Instr(Mnemonic.movw, rw,ww), 
 /* B1 */ Instr(Mnemonic.cmpw, rw,rw),
 /* B2 */ Instr(Mnemonic.mcomw, rw,ww), 
 /* B3 */ Instr(Mnemonic.bitw, rw,rw),
 /* B4 */ Instr(Mnemonic.clrw,  ww), 
 /* B5 */ Instr(Mnemonic.tstw,  rw), 
 /* B6 */ Instr(Mnemonic.incw,  ww), 
 /* B7 */ Instr(Mnemonic.decw,  ww), 
 /* B8 */ Instr(Mnemonic.bispsw, rw), 
 /* B9 */ Instr(Mnemonic.bicpsw, rw), 
 /* BA */ Instr(Mnemonic.popr,  -1), 
 /* BB */ Instr(Mnemonic.pushr,  -1), 
 /* BC */ Instr(Mnemonic.chmk,  rw), 
 /* BD */ Instr(Mnemonic.chme,  rw), 
 /* BE */ Instr(Mnemonic.chms,  rw), 
 /* BF */ Instr(Mnemonic.chmu,  rw),
        
 /* C0 */ Instr(Mnemonic.addl2, rl,wl), 
 /* C1 */ Instr(Mnemonic.addl3, rl,rl,wl), 
 /* C2 */ Instr(Mnemonic.subl2, rl,wl),
 /* C3 */ Instr(Mnemonic.subl3, rl,rl,wl),
 /* C4 */ Instr(Mnemonic.mull2, rl,wl), 
 /* C5 */ Instr(Mnemonic.mull3, rl,rl,wl), 
 /* C6 */ Instr(Mnemonic.divl2, rl,wl),
 /* C7 */ Instr(Mnemonic.divl3, rl,rl,wl),
 /* C8 */ Instr(Mnemonic.bisl2, rl,wl),
 /* C9 */ Instr(Mnemonic.bisl3, rl,rl,wl),
 /* CA */ Instr(Mnemonic.bicl2, rl,wl),
 /* CB */ Instr(Mnemonic.bicl3, rl,rl,wl),
 /* CC */ Instr(Mnemonic.xorl2, rl,wl), 
 /* CD */ Instr(Mnemonic.xorl3, rl,rl,wl),
 /* CE */ Instr(Mnemonic.mnegl, rl,wl),
 /* CF */ Instr(Mnemonic.casel, InstrClass.Transfer, rl,rl,rl),
              
 /* D0 */ Instr(Mnemonic.movl, rl,wl), 
 /* D1 */ Instr(Mnemonic.cmpl, rl,rl), 
 /* D2 */ Instr(Mnemonic.mcoml, rl,wl),
 /* D3 */ Instr(Mnemonic.bitl, rl,rl),
 /* D4 */ Instr(Mnemonic.clrl, wl), //  clrf,  -1), 
 /* D5 */ Instr(Mnemonic.tstl, rl), 
 /* D6 */ Instr(Mnemonic.incl, wl), 
 /* D7 */ Instr(Mnemonic.decl, wl), 
 /* D8 */ Instr(Mnemonic.adwc, rl,wl),
 /* D9 */ Instr(Mnemonic.sbwc, rl,ml), 
 /* DA */ Instr(Mnemonic.mtpr,  -1), 
 /* DB */ Instr(Mnemonic.mfpr, rl,wl), 
 /* DC */ Instr(Mnemonic.movpsl,  -1), 
 /* DD */ Instr(Mnemonic.pushl, rl), 
 /* DE */ Instr(Mnemonic.moval, al,wl), // mova,  -1), 
 /* DF */ Instr(Mnemonic.pushal, al), // pushaf,  -1), 

 /* E0 */ Instr(Mnemonic.bbs, InstrClass.ConditionalTransfer, rl,vb,bb), 
 /* E1 */ Instr(Mnemonic.bbc, InstrClass.ConditionalTransfer, rl,vb,bb), 
 /* E2 */ Instr(Mnemonic.bbss, InstrClass.ConditionalTransfer, rl,vb,bb), 
 /* E3 */ Instr(Mnemonic.bbcs, InstrClass.ConditionalTransfer, rl,vb,bb), 
 /* E4 */ Instr(Mnemonic.bbsc, InstrClass.ConditionalTransfer, rl,vb,bb),
 /* E5 */ Instr(Mnemonic.bbcc, InstrClass.ConditionalTransfer, rl,vb,bb),
 /* E6 */ Instr(Mnemonic.bbssi, InstrClass.ConditionalTransfer, rl,vb,bb), 
 /* E7 */ Instr(Mnemonic.bbcci, InstrClass.ConditionalTransfer, rl,vb,bb),
 /* E8 */ Instr(Mnemonic.blbs,  InstrClass.ConditionalTransfer, rl,bb), 
 /* E9 */ Instr(Mnemonic.blbc,  InstrClass.ConditionalTransfer, rl,bb), 
 /* EA */ Instr(Mnemonic.ffs,  rl,rb,vb,wl), 
 /* EB */ Instr(Mnemonic.ffc,  rl,rb,vb,wl), 
 /* EC */ Instr(Mnemonic.cmpv,  -1), 
 /* ED */ Instr(Mnemonic.cmpzv,  -1), 
 /* EE */ Instr(Mnemonic.extv,  rl,rb,vb,wl),
 /* EF */ Instr(Mnemonic.extzv, rl,rb,vb,wl),

 /* F0 */ Instr(Mnemonic.insv,  rl,rl,rb,vb), 
 /* F1 */ Instr(Mnemonic.acbl,   InstrClass.ConditionalTransfer, rl,rl,ml,bw),
 /* F2 */ Instr(Mnemonic.aoblss, InstrClass.ConditionalTransfer, rl,ml,bb), 
 /* F3 */ Instr(Mnemonic.aobleq, InstrClass.ConditionalTransfer, rl,ml,bb), 
 /* F4 */ Instr(Mnemonic.sobgeq, InstrClass.ConditionalTransfer, ml,bb), 
 /* F5 */ Instr(Mnemonic.sobgtr, InstrClass.ConditionalTransfer, ml,bb), 
 /* F6 */ Instr(Mnemonic.cvtlb, rl,wb), 
 /* F7 */ Instr(Mnemonic.cvtlw, rl,ww), 
 /* F8 */ Instr(Mnemonic.ashp,  rb,rw,ab,rb,rw,ab),
 /* F9 */ Instr(Mnemonic.cvtlp, rl,rw,ab), 
 /* FA */ Instr(Mnemonic.callg, InstrClass.Transfer|InstrClass.Call, ab,ab), 
 /* FB */ Instr(Mnemonic.calls, InstrClass.Transfer|InstrClass.Call, ab,ab), 
 /* FC */ Instr(Mnemonic.xfc,  -1), 
 /* FD */ Instr(Mnemonic.Invalid), // escd to Digital,  -1), 
 /* FE */ Instr(Mnemonic.Invalid), // esce to Digital,  -1), 
 /* FF */ Instr(Mnemonic.Invalid), // escf to Digital,  -1), 

            };
    }
}