// Linux 4.7 (pulled from github.com/torvalds/linux on Jul 20 2016), x86_64

[[reko::service(vector=0x80, regs={rax:0})]] [[reko::convention(amd64kernel)]] long sys_read(unsigned int fd, char *buf, size_t count);
[[reko::service(vector=0x80, regs={rax:1})]] [[reko::convention(amd64kernel)]] long sys_write(unsigned int fd, const char *buf, size_t count);
[[reko::service(vector=0x80, regs={rax:2})]] [[reko::convention(amd64kernel)]] long sys_open(const char *filename, int flags, int mode);
[[reko::service(vector=0x80, regs={rax:3})]] [[reko::convention(amd64kernel)]] long sys_close(unsigned int fd);
[[reko::service(vector=0x80, regs={rax:4})]] [[reko::convention(amd64kernel)]] long sys_stat(const char *filename, struct stat *statbuf);
[[reko::service(vector=0x80, regs={rax:5})]] [[reko::convention(amd64kernel)]] long sys_fstat(unsigned int fd, struct stat *statbuf);
[[reko::service(vector=0x80, regs={rax:6})]] [[reko::convention(amd64kernel)]] long sys_lstat(const char *filename, struct stat *statbuf);
[[reko::service(vector=0x80, regs={rax:7})]] [[reko::convention(amd64kernel)]] long sys_poll(struct poll_fd *ufds, unsigned int nfds, long timeout_msecs);
[[reko::service(vector=0x80, regs={rax:8})]] [[reko::convention(amd64kernel)]] long sys_lseek(unsigned int fd, off_t offset, unsigned int origin);
[[reko::service(vector=0x80, regs={rax:9})]] [[reko::convention(amd64kernel)]] long sys_mmap(unsigned long addr, unsigned long len, unsigned long prot, unsigned long flags, unsigned long fd, unsigned long off);
[[reko::service(vector=0x80, regs={rax:10})]] [[reko::convention(amd64kernel)]] long sys_mprotect(unsigned long start, size_t len, unsigned long prot);
[[reko::service(vector=0x80, regs={rax:11})]] [[reko::convention(amd64kernel)]] long sys_munmap(unsigned long addr, size_t len);
[[reko::service(vector=0x80, regs={rax:12})]] [[reko::convention(amd64kernel)]] long sys_brk(unsigned long brk);
[[reko::service(vector=0x80, regs={rax:13})]] [[reko::convention(amd64kernel)]] long sys_rt_sigaction(int sig, const struct sigaction *act, struct sigaction *oact, size_t sigsetsize);
[[reko::service(vector=0x80, regs={rax:14})]] [[reko::convention(amd64kernel)]] long sys_rt_sigprocmask(int how, sigset_t *nset, sigset_t *oset, size_t sigsetsize);
[[reko::service(vector=0x80, regs={rax:15})]] [[reko::convention(amd64kernel)]] long sys_rt_sigreturn(unsigned long __unused);
[[reko::service(vector=0x80, regs={rax:16})]] [[reko::convention(amd64kernel)]] long sys_ioctl(unsigned int fd, unsigned int cmd, unsigned long arg);
[[reko::service(vector=0x80, regs={rax:17})]] [[reko::convention(amd64kernel)]] long sys_pread64(unsigned long fd, char *buf, size_t count, loff_t pos);
[[reko::service(vector=0x80, regs={rax:18})]] [[reko::convention(amd64kernel)]] long sys_pwrite64(unsigned int fd, const char *buf, size_t count, loff_t pos);
[[reko::service(vector=0x80, regs={rax:19})]] [[reko::convention(amd64kernel)]] long sys_readv(unsigned long fd, const struct iovec *vec, unsigned long vlen);
[[reko::service(vector=0x80, regs={rax:20})]] [[reko::convention(amd64kernel)]] long sys_writev(unsigned long fd, const struct iovec *vec, unsigned long vlen);
[[reko::service(vector=0x80, regs={rax:21})]] [[reko::convention(amd64kernel)]] long sys_access(const char *filename, int mode);
[[reko::service(vector=0x80, regs={rax:22})]] [[reko::convention(amd64kernel)]] long sys_pipe(int *filedes);
[[reko::service(vector=0x80, regs={rax:23})]] [[reko::convention(amd64kernel)]] long sys_select(int n, fd_set *inp, fd_set *outp, fd_set*exp, struct timeval *tvp);
[[reko::service(vector=0x80, regs={rax:24})]] [[reko::convention(amd64kernel)]] long sys_sched_yield();
[[reko::service(vector=0x80, regs={rax:25})]] [[reko::convention(amd64kernel)]] long sys_mremap(unsigned long addr, unsigned long old_len, unsigned long new_len, unsigned long flags, unsigned long new_addr);
[[reko::service(vector=0x80, regs={rax:26})]] [[reko::convention(amd64kernel)]] long sys_msync(unsigned long start, size_t len, int flags);
[[reko::service(vector=0x80, regs={rax:27})]] [[reko::convention(amd64kernel)]] long sys_mincore(unsigned long start, size_t len, unsigned char *vec);
[[reko::service(vector=0x80, regs={rax:28})]] [[reko::convention(amd64kernel)]] long sys_madvise(unsigned long start, size_t len_in, int behavior);
[[reko::service(vector=0x80, regs={rax:29})]] [[reko::convention(amd64kernel)]] long sys_shmget(key_t key, size_t size, int shmflg);
[[reko::service(vector=0x80, regs={rax:30})]] [[reko::convention(amd64kernel)]] long sys_shmat(int shmid, char *shmaddr, int shmflg);
[[reko::service(vector=0x80, regs={rax:31})]] [[reko::convention(amd64kernel)]] long sys_shmctl(int shmid, int cmd, struct shmid_ds *buf);
[[reko::service(vector=0x80, regs={rax:32})]] [[reko::convention(amd64kernel)]] long sys_dup(unsigned int fildes);
[[reko::service(vector=0x80, regs={rax:33})]] [[reko::convention(amd64kernel)]] long sys_dup2(unsigned int oldfd, unsigned int newfd);
[[reko::service(vector=0x80, regs={rax:34})]] [[reko::convention(amd64kernel)]] long sys_pause();
[[reko::service(vector=0x80, regs={rax:35})]] [[reko::convention(amd64kernel)]] long sys_nanosleep(struct timespec *rqtp, struct timespec *rmtp);
[[reko::service(vector=0x80, regs={rax:36})]] [[reko::convention(amd64kernel)]] long sys_getitimer(int which, struct itimerval *value);
[[reko::service(vector=0x80, regs={rax:37})]] [[reko::convention(amd64kernel)]] long sys_alarm(unsigned int seconds);
[[reko::service(vector=0x80, regs={rax:38})]] [[reko::convention(amd64kernel)]] long sys_setitimer(int which, struct itimerval *value, struct itimerval *ovalue);
[[reko::service(vector=0x80, regs={rax:39})]] [[reko::convention(amd64kernel)]] long sys_getpid();
[[reko::service(vector=0x80, regs={rax:40})]] [[reko::convention(amd64kernel)]] long sys_sendfile(int out_fd, int in_fd, off_t *offset, size_t count);
[[reko::service(vector=0x80, regs={rax:41})]] [[reko::convention(amd64kernel)]] long sys_socket(int family, int type, int protocol);
[[reko::service(vector=0x80, regs={rax:42})]] [[reko::convention(amd64kernel)]] long sys_connect(int fd, struct sockaddr *uservaddr, int addrlen);
[[reko::service(vector=0x80, regs={rax:43})]] [[reko::convention(amd64kernel)]] long sys_accept(int fd, struct sockaddr *upeer_sockaddr, int *upeer_addrlen);
[[reko::service(vector=0x80, regs={rax:44})]] [[reko::convention(amd64kernel)]] long sys_sendto(int fd, void *buff, size_t len, unsigned flags, struct sockaddr *addr, int addr_len);
[[reko::service(vector=0x80, regs={rax:45})]] [[reko::convention(amd64kernel)]] long sys_recvfrom(int fd, void *ubuf, size_t size, unsigned flags, struct sockaddr *addr, int *addr_len);
[[reko::service(vector=0x80, regs={rax:46})]] [[reko::convention(amd64kernel)]] long sys_sendmsg(int fd, struct msghdr *msg, unsigned flags);
[[reko::service(vector=0x80, regs={rax:47})]] [[reko::convention(amd64kernel)]] long sys_recvmsg(int fd, struct msghdr *msg, unsigned int flags);
[[reko::service(vector=0x80, regs={rax:48})]] [[reko::convention(amd64kernel)]] long sys_shutdown(int fd, int how);
[[reko::service(vector=0x80, regs={rax:49})]] [[reko::convention(amd64kernel)]] long sys_bind(int fd, struct sokaddr *umyaddr, int addrlen);
[[reko::service(vector=0x80, regs={rax:50})]] [[reko::convention(amd64kernel)]] long sys_listen(int fd, int backlog);
[[reko::service(vector=0x80, regs={rax:51})]] [[reko::convention(amd64kernel)]] long sys_getsockname(int fd, struct sockaddr *usockaddr, int *usockaddr_len);
[[reko::service(vector=0x80, regs={rax:52})]] [[reko::convention(amd64kernel)]] long sys_getpeername(int fd, struct sockaddr *usockaddr, int *usockaddr_len);
[[reko::service(vector=0x80, regs={rax:53})]] [[reko::convention(amd64kernel)]] long sys_socketpair(int family, int type, int protocol, int *usockvec);
[[reko::service(vector=0x80, regs={rax:54})]] [[reko::convention(amd64kernel)]] long sys_setsockopt(int fd, int level, int optname, char *optval, int optlen);
[[reko::service(vector=0x80, regs={rax:55})]] [[reko::convention(amd64kernel)]] long sys_getsockopt(int fd, int level, int optname, char *optval, int *optlen);
[[reko::service(vector=0x80, regs={rax:56})]] [[reko::convention(amd64kernel)]] long sys_clone(unsigned long clone_flags, unsigned long newsp, void *parent_tid, void *child_tid, unsigned int tid);
[[reko::service(vector=0x80, regs={rax:57})]] [[reko::convention(amd64kernel)]] long sys_fork();
[[reko::service(vector=0x80, regs={rax:58})]] [[reko::convention(amd64kernel)]] long sys_vfork();
[[reko::service(vector=0x80, regs={rax:59})]] [[reko::convention(amd64kernel)]] long sys_execve(const char *filename, const char *const argv[], const char *const envp[]);
[[reko::service(vector=0x80, regs={rax:60})]] [[reko::convention(amd64kernel)]] long sys_exit(int error_code);
[[reko::service(vector=0x80, regs={rax:61})]] [[reko::convention(amd64kernel)]] long sys_wait4(pid_t upid, int *stat_addr, int options, struct rusage *ru);
[[reko::service(vector=0x80, regs={rax:62})]] [[reko::convention(amd64kernel)]] long sys_kill(pid_t pid, int sig);
[[reko::service(vector=0x80, regs={rax:63})]] [[reko::convention(amd64kernel)]] long sys_uname(struct old_utsname *name);
[[reko::service(vector=0x80, regs={rax:64})]] [[reko::convention(amd64kernel)]] long sys_semget(key_t key, int nsems, int semflg);
[[reko::service(vector=0x80, regs={rax:65})]] [[reko::convention(amd64kernel)]] long sys_semop(int semid, struct sembuf *tsops, unsigned nsops);
[[reko::service(vector=0x80, regs={rax:66})]] [[reko::convention(amd64kernel)]] long sys_semctl(int semid, int semnum, int cmd, union semun arg);
[[reko::service(vector=0x80, regs={rax:67})]] [[reko::convention(amd64kernel)]] long sys_shmdt(char *shmaddr);
[[reko::service(vector=0x80, regs={rax:68})]] [[reko::convention(amd64kernel)]] long sys_msgget(key_t key, int msgflg);
[[reko::service(vector=0x80, regs={rax:69})]] [[reko::convention(amd64kernel)]] long sys_msgsnd(int msqid, struct msgbuf *msgp, size_t msgsz, int msgflg);
[[reko::service(vector=0x80, regs={rax:70})]] [[reko::convention(amd64kernel)]] long sys_msgrcv(int msqid, struct msgbuf *msgp, size_t msgsz, long msgtyp, int msgflg);
[[reko::service(vector=0x80, regs={rax:71})]] [[reko::convention(amd64kernel)]] long sys_msgctl(int msqid, int cmd, struct msqid_ds *buf);
[[reko::service(vector=0x80, regs={rax:72})]] [[reko::convention(amd64kernel)]] long sys_fcntl(unsigned int fd, unsigned int cmd, unsigned long arg);
[[reko::service(vector=0x80, regs={rax:73})]] [[reko::convention(amd64kernel)]] long sys_flock(unsigned int fd, unsigned int cmd);
[[reko::service(vector=0x80, regs={rax:74})]] [[reko::convention(amd64kernel)]] long sys_fsync(unsigned int fd);
[[reko::service(vector=0x80, regs={rax:75})]] [[reko::convention(amd64kernel)]] long sys_fdatasync(unsigned int fd);
[[reko::service(vector=0x80, regs={rax:76})]] [[reko::convention(amd64kernel)]] long sys_truncate(const char *path, long length);
[[reko::service(vector=0x80, regs={rax:77})]] [[reko::convention(amd64kernel)]] long sys_ftruncate(unsigned int fd, unsigned long length);
[[reko::service(vector=0x80, regs={rax:78})]] [[reko::convention(amd64kernel)]] long sys_getdents(unsigned int fd, struct linux_dirent *dirent, unsigned int count);
[[reko::service(vector=0x80, regs={rax:79})]] [[reko::convention(amd64kernel)]] long sys_getcwd(char *buf, unsigned long size);
[[reko::service(vector=0x80, regs={rax:80})]] [[reko::convention(amd64kernel)]] long sys_chdir(const char *filename);
[[reko::service(vector=0x80, regs={rax:81})]] [[reko::convention(amd64kernel)]] long sys_fchdir(unsigned int fd);
[[reko::service(vector=0x80, regs={rax:82})]] [[reko::convention(amd64kernel)]] long sys_rename(const char *oldname, const char *newname);
[[reko::service(vector=0x80, regs={rax:83})]] [[reko::convention(amd64kernel)]] long sys_mkdir(const char *pathname, int mode);
[[reko::service(vector=0x80, regs={rax:84})]] [[reko::convention(amd64kernel)]] long sys_rmdir(const char *pathname);
[[reko::service(vector=0x80, regs={rax:85})]] [[reko::convention(amd64kernel)]] long sys_creat(const char *pathname, int mode);
[[reko::service(vector=0x80, regs={rax:86})]] [[reko::convention(amd64kernel)]] long sys_link(const char *oldname, const char *newname);
[[reko::service(vector=0x80, regs={rax:87})]] [[reko::convention(amd64kernel)]] long sys_unlink(const char *pathname);
[[reko::service(vector=0x80, regs={rax:88})]] [[reko::convention(amd64kernel)]] long sys_symlink(const char *oldname, const char *newname);
[[reko::service(vector=0x80, regs={rax:89})]] [[reko::convention(amd64kernel)]] long sys_readlink(const char *path, char *buf, int bufsiz);
[[reko::service(vector=0x80, regs={rax:90})]] [[reko::convention(amd64kernel)]] long sys_chmod(const char *filename, mode_t mode);
[[reko::service(vector=0x80, regs={rax:91})]] [[reko::convention(amd64kernel)]] long sys_fchmod(unsigned int fd, mode_t mode);
[[reko::service(vector=0x80, regs={rax:92})]] [[reko::convention(amd64kernel)]] long sys_chown(const char *filename, uid_t user, gid_t group);
[[reko::service(vector=0x80, regs={rax:93})]] [[reko::convention(amd64kernel)]] long sys_fchown(unsigned int fd, uid_t user, gid_t group);
[[reko::service(vector=0x80, regs={rax:94})]] [[reko::convention(amd64kernel)]] long sys_lchown(const char *filename, uid_t user, gid_t group);
[[reko::service(vector=0x80, regs={rax:95})]] [[reko::convention(amd64kernel)]] long sys_umask(int mask);
[[reko::service(vector=0x80, regs={rax:96})]] [[reko::convention(amd64kernel)]] long sys_gettimeofday(struct timeval *tv, struct timezone *tz);
[[reko::service(vector=0x80, regs={rax:97})]] [[reko::convention(amd64kernel)]] long sys_getrlimit(unsigned int resource, struct rlimit *rlim);
[[reko::service(vector=0x80, regs={rax:98})]] [[reko::convention(amd64kernel)]] long sys_getrusage(int who, struct rusage *ru);
[[reko::service(vector=0x80, regs={rax:99})]] [[reko::convention(amd64kernel)]] long sys_sysinfo(struct sysinfo *info);
[[reko::service(vector=0x80, regs={rax:100})]] [[reko::convention(amd64kernel)]] long sys_times(struct tms *tbuf);
[[reko::service(vector=0x80, regs={rax:101})]] [[reko::convention(amd64kernel)]] long sys_ptrace(long request, long pid, unsigned long addr, unsigned long data);
[[reko::service(vector=0x80, regs={rax:102})]] [[reko::convention(amd64kernel)]] long sys_getuid();
[[reko::service(vector=0x80, regs={rax:103})]] [[reko::convention(amd64kernel)]] long sys_syslog(int type, char *buf, int len);
[[reko::service(vector=0x80, regs={rax:104})]] [[reko::convention(amd64kernel)]] long sys_getgid();
[[reko::service(vector=0x80, regs={rax:105})]] [[reko::convention(amd64kernel)]] long sys_setuid(uid_t uid);
[[reko::service(vector=0x80, regs={rax:106})]] [[reko::convention(amd64kernel)]] long sys_setgid(gid_t gid);
[[reko::service(vector=0x80, regs={rax:107})]] [[reko::convention(amd64kernel)]] long sys_geteuid();
[[reko::service(vector=0x80, regs={rax:108})]] [[reko::convention(amd64kernel)]] long sys_getegid();
[[reko::service(vector=0x80, regs={rax:109})]] [[reko::convention(amd64kernel)]] long sys_setpgid(pid_t pid, pid_t pgid);
[[reko::service(vector=0x80, regs={rax:110})]] [[reko::convention(amd64kernel)]] long sys_getppid();
[[reko::service(vector=0x80, regs={rax:111})]] [[reko::convention(amd64kernel)]] long sys_getpgrp();
[[reko::service(vector=0x80, regs={rax:112})]] [[reko::convention(amd64kernel)]] long sys_setsid();
[[reko::service(vector=0x80, regs={rax:113})]] [[reko::convention(amd64kernel)]] long sys_setreuid(uid_t ruid, uid_t euid);
[[reko::service(vector=0x80, regs={rax:114})]] [[reko::convention(amd64kernel)]] long sys_setregid(gid_t rgid, gid_t egid);
[[reko::service(vector=0x80, regs={rax:115})]] [[reko::convention(amd64kernel)]] long sys_getgroups(int gidsetsize, gid_t *grouplist);
[[reko::service(vector=0x80, regs={rax:116})]] [[reko::convention(amd64kernel)]] long sys_setgroups(int gidsetsize, gid_t *grouplist);
[[reko::service(vector=0x80, regs={rax:117})]] [[reko::convention(amd64kernel)]] long sys_setresuid(uid_t *ruid, uid_t *euid, uid_t *suid);
[[reko::service(vector=0x80, regs={rax:118})]] [[reko::convention(amd64kernel)]] long sys_getresuid(uid_t *ruid, uid_t *euid, uid_t *suid);
[[reko::service(vector=0x80, regs={rax:119})]] [[reko::convention(amd64kernel)]] long sys_setresgid(gid_t rgid, gid_t egid, gid_t sgid);
[[reko::service(vector=0x80, regs={rax:120})]] [[reko::convention(amd64kernel)]] long sys_getresgid(gid_t *rgid, gid_t *egid, gid_t *sgid);
[[reko::service(vector=0x80, regs={rax:121})]] [[reko::convention(amd64kernel)]] long sys_getpgid(pid_t pid);
[[reko::service(vector=0x80, regs={rax:122})]] [[reko::convention(amd64kernel)]] long sys_setfsuid(uid_t uid);
[[reko::service(vector=0x80, regs={rax:123})]] [[reko::convention(amd64kernel)]] long sys_setfsgid(gid_t gid);
[[reko::service(vector=0x80, regs={rax:124})]] [[reko::convention(amd64kernel)]] long sys_getsid(pid_t pid);
[[reko::service(vector=0x80, regs={rax:125})]] [[reko::convention(amd64kernel)]] long sys_capget(cap_user_header_t header, cap_user_data_t dataptr);
[[reko::service(vector=0x80, regs={rax:126})]] [[reko::convention(amd64kernel)]] long sys_capset(cap_user_header_t header, const cap_user_data_t data);
[[reko::service(vector=0x80, regs={rax:127})]] [[reko::convention(amd64kernel)]] long sys_rt_sigpending(sigset_t *set, size_t sigsetsize);
[[reko::service(vector=0x80, regs={rax:128})]] [[reko::convention(amd64kernel)]] long sys_rt_sigtimedwait(const sigset_t *uthese, siginfo_t *uinfo, const struct timespec *uts, size_t sigsetsize);
[[reko::service(vector=0x80, regs={rax:129})]] [[reko::convention(amd64kernel)]] long sys_rt_sigqueueinfo(pid_t pid, int sig, siginfo_t *uinfo);
[[reko::service(vector=0x80, regs={rax:130})]] [[reko::convention(amd64kernel)]] long sys_rt_sigsuspend(sigset_t *unewset, size_t sigsetsize);
[[reko::service(vector=0x80, regs={rax:131})]] [[reko::convention(amd64kernel)]] long sys_sigaltstack(const stack_t *uss, stack_t *uoss);
[[reko::service(vector=0x80, regs={rax:132})]] [[reko::convention(amd64kernel)]] long sys_utime(char *filename, struct utimbuf *times);
[[reko::service(vector=0x80, regs={rax:133})]] [[reko::convention(amd64kernel)]] long sys_mknod(const char *filename, umode_t mode, unsigned dev);
[[reko::service(vector=0x80, regs={rax:134})]] [[reko::convention(amd64kernel)]] long sys_uselib(NOT IMPLEMENTED);
[[reko::service(vector=0x80, regs={rax:135})]] [[reko::convention(amd64kernel)]] long sys_personality(unsigned int personality);
[[reko::service(vector=0x80, regs={rax:136})]] [[reko::convention(amd64kernel)]] long sys_ustat(unsigned dev, struct ustat *ubuf);
[[reko::service(vector=0x80, regs={rax:137})]] [[reko::convention(amd64kernel)]] long sys_statfs(const char *pathname, struct statfs *buf);
[[reko::service(vector=0x80, regs={rax:138})]] [[reko::convention(amd64kernel)]] long sys_fstatfs(unsigned int fd, struct statfs *buf);
[[reko::service(vector=0x80, regs={rax:139})]] [[reko::convention(amd64kernel)]] long sys_sysfs(int option, unsigned long arg1, unsigned long arg2);
[[reko::service(vector=0x80, regs={rax:140})]] [[reko::convention(amd64kernel)]] long sys_getpriority(int which, int who);
[[reko::service(vector=0x80, regs={rax:141})]] [[reko::convention(amd64kernel)]] long sys_setpriority(int which, int who, int niceval);
[[reko::service(vector=0x80, regs={rax:142})]] [[reko::convention(amd64kernel)]] long sys_sched_setparam(pid_t pid, struct sched_param *param);
[[reko::service(vector=0x80, regs={rax:143})]] [[reko::convention(amd64kernel)]] long sys_sched_getparam(pid_t pid, struct sched_param *param);
[[reko::service(vector=0x80, regs={rax:144})]] [[reko::convention(amd64kernel)]] long sys_sched_setscheduler(pid_t pid, int policy, struct sched_param *param);
[[reko::service(vector=0x80, regs={rax:145})]] [[reko::convention(amd64kernel)]] long sys_sched_getscheduler(pid_t pid);
[[reko::service(vector=0x80, regs={rax:146})]] [[reko::convention(amd64kernel)]] long sys_sched_get_priority_max(int policy);
[[reko::service(vector=0x80, regs={rax:147})]] [[reko::convention(amd64kernel)]] long sys_sched_get_priority_min(int policy);
[[reko::service(vector=0x80, regs={rax:148})]] [[reko::convention(amd64kernel)]] long sys_sched_rr_get_interval(pid_t pid, struct timespec *interval);
[[reko::service(vector=0x80, regs={rax:149})]] [[reko::convention(amd64kernel)]] long sys_mlock(unsigned long start, size_t len);
[[reko::service(vector=0x80, regs={rax:150})]] [[reko::convention(amd64kernel)]] long sys_munlock(unsigned long start, size_t len);
[[reko::service(vector=0x80, regs={rax:151})]] [[reko::convention(amd64kernel)]] long sys_mlockall(int flags);
[[reko::service(vector=0x80, regs={rax:152})]] [[reko::convention(amd64kernel)]] long sys_munlockall();
[[reko::service(vector=0x80, regs={rax:153})]] [[reko::convention(amd64kernel)]] long sys_vhangup();
[[reko::service(vector=0x80, regs={rax:154})]] [[reko::convention(amd64kernel)]] long sys_modify_ldt(int func, void *ptr, unsigned long bytecount);
[[reko::service(vector=0x80, regs={rax:155})]] [[reko::convention(amd64kernel)]] long sys_pivot_root(const char *new_root, const char *put_old);
[[reko::service(vector=0x80, regs={rax:156})]] [[reko::convention(amd64kernel)]] long sys__sysctl(struct __sysctl_args *args);
[[reko::service(vector=0x80, regs={rax:157})]] [[reko::convention(amd64kernel)]] long sys_prctl(int option, unsigned long arg2, unsigned long arg3, unsigned long arg4, , unsigned long arg5);
[[reko::service(vector=0x80, regs={rax:158})]] [[reko::convention(amd64kernel)]] long sys_arch_prctl(struct task_struct *task, int code, unsigned long *addr);
[[reko::service(vector=0x80, regs={rax:159})]] [[reko::convention(amd64kernel)]] long sys_adjtimex(struct timex *txc_p);
[[reko::service(vector=0x80, regs={rax:160})]] [[reko::convention(amd64kernel)]] long sys_setrlimit(unsigned int resource, struct rlimit *rlim);
[[reko::service(vector=0x80, regs={rax:161})]] [[reko::convention(amd64kernel)]] long sys_chroot(const char *filename);
[[reko::service(vector=0x80, regs={rax:162})]] [[reko::convention(amd64kernel)]] long sys_sync();
[[reko::service(vector=0x80, regs={rax:163})]] [[reko::convention(amd64kernel)]] long sys_acct(const char *name);
[[reko::service(vector=0x80, regs={rax:164})]] [[reko::convention(amd64kernel)]] long sys_settimeofday(struct timeval *tv, struct timezone *tz);
[[reko::service(vector=0x80, regs={rax:165})]] [[reko::convention(amd64kernel)]] long sys_mount(char *dev_name, char *dir_name, char *type, unsigned long flags, void *data);
[[reko::service(vector=0x80, regs={rax:166})]] [[reko::convention(amd64kernel)]] long sys_umount2(const char *target, int flags);
[[reko::service(vector=0x80, regs={rax:167})]] [[reko::convention(amd64kernel)]] long sys_swapon(const char *specialfile, int swap_flags);
[[reko::service(vector=0x80, regs={rax:168})]] [[reko::convention(amd64kernel)]] long sys_swapoff(const char *specialfile);
[[reko::service(vector=0x80, regs={rax:169})]] [[reko::convention(amd64kernel)]] long sys_reboot(int magic1, int magic2, unsigned int cmd, void *arg);
[[reko::service(vector=0x80, regs={rax:170})]] [[reko::convention(amd64kernel)]] long sys_sethostname(char *name, int len);
[[reko::service(vector=0x80, regs={rax:171})]] [[reko::convention(amd64kernel)]] long sys_setdomainname(char *name, int len);
[[reko::service(vector=0x80, regs={rax:172})]] [[reko::convention(amd64kernel)]] long sys_iopl(unsigned int level, struct pt_regs *regs);
[[reko::service(vector=0x80, regs={rax:173})]] [[reko::convention(amd64kernel)]] long sys_ioperm(unsigned long from, unsigned long num, int turn_on);
[[reko::service(vector=0x80, regs={rax:174})]] [[reko::convention(amd64kernel)]] long sys_create_module(REMOVED IN Linux 2.6);
[[reko::service(vector=0x80, regs={rax:175})]] [[reko::convention(amd64kernel)]] long sys_init_module(void *umod, unsigned long len, const char *uargs);
[[reko::service(vector=0x80, regs={rax:176})]] [[reko::convention(amd64kernel)]] long sys_delete_module(const chat *name_user, unsigned int flags);
[[reko::service(vector=0x80, regs={rax:177})]] [[reko::convention(amd64kernel)]] long sys_get_kernel_syms(REMOVED IN Linux 2.6);
[[reko::service(vector=0x80, regs={rax:178})]] [[reko::convention(amd64kernel)]] long sys_query_module(REMOVED IN Linux 2.6);
[[reko::service(vector=0x80, regs={rax:179})]] [[reko::convention(amd64kernel)]] long sys_quotactl(unsigned int cmd, const char *special, qid_t id, void *addr);
[[reko::service(vector=0x80, regs={rax:180})]] [[reko::convention(amd64kernel)]] long sys_nfsservctl(NOT IMPLEMENTED);
[[reko::service(vector=0x80, regs={rax:181})]] [[reko::convention(amd64kernel)]] long sys_getpmsg(NOT IMPLEMENTED);
[[reko::service(vector=0x80, regs={rax:182})]] [[reko::convention(amd64kernel)]] long sys_putpmsg(NOT IMPLEMENTED);
[[reko::service(vector=0x80, regs={rax:183})]] [[reko::convention(amd64kernel)]] long sys_afs_syscall(NOT IMPLEMENTED);
[[reko::service(vector=0x80, regs={rax:184})]] [[reko::convention(amd64kernel)]] long sys_tuxcall(NOT IMPLEMENTED);
[[reko::service(vector=0x80, regs={rax:185})]] [[reko::convention(amd64kernel)]] long sys_security(NOT IMPLEMENTED);
[[reko::service(vector=0x80, regs={rax:186})]] [[reko::convention(amd64kernel)]] long sys_gettid();
[[reko::service(vector=0x80, regs={rax:187})]] [[reko::convention(amd64kernel)]] long sys_readahead(int fd, loff_t offset, size_t count);
[[reko::service(vector=0x80, regs={rax:188})]] [[reko::convention(amd64kernel)]] long sys_setxattr(const char *pathname, const char *name, const void *value, size_t size, int flags);
[[reko::service(vector=0x80, regs={rax:189})]] [[reko::convention(amd64kernel)]] long sys_lsetxattr(const char *pathname, const char *name, const void *value, size_t size, int flags);
[[reko::service(vector=0x80, regs={rax:190})]] [[reko::convention(amd64kernel)]] long sys_fsetxattr(int fd, const char *name, const void *value, size_t size, int flags);
[[reko::service(vector=0x80, regs={rax:191})]] [[reko::convention(amd64kernel)]] long sys_getxattr(const char *pathname, const char *name, void *value, size_t size);
[[reko::service(vector=0x80, regs={rax:192})]] [[reko::convention(amd64kernel)]] long sys_lgetxattr(const char *pathname, const char *name, void *value, size_t size);
[[reko::service(vector=0x80, regs={rax:193})]] [[reko::convention(amd64kernel)]] long sys_fgetxattr(int fd, const har *name, void *value, size_t size);
[[reko::service(vector=0x80, regs={rax:194})]] [[reko::convention(amd64kernel)]] long sys_listxattr(const char *pathname, char *list, size_t size);
[[reko::service(vector=0x80, regs={rax:195})]] [[reko::convention(amd64kernel)]] long sys_llistxattr(const char *pathname, char *list, size_t size);
[[reko::service(vector=0x80, regs={rax:196})]] [[reko::convention(amd64kernel)]] long sys_flistxattr(int fd, char *list, size_t size);
[[reko::service(vector=0x80, regs={rax:197})]] [[reko::convention(amd64kernel)]] long sys_removexattr(const char *pathname, const char *name);
[[reko::service(vector=0x80, regs={rax:198})]] [[reko::convention(amd64kernel)]] long sys_lremovexattr(const char *pathname, const char *name);
[[reko::service(vector=0x80, regs={rax:199})]] [[reko::convention(amd64kernel)]] long sys_fremovexattr(int fd, const char *name);
[[reko::service(vector=0x80, regs={rax:200})]] [[reko::convention(amd64kernel)]] long sys_tkill(pid_t pid, ing sig);
[[reko::service(vector=0x80, regs={rax:201})]] [[reko::convention(amd64kernel)]] long sys_time(time_t *tloc);
[[reko::service(vector=0x80, regs={rax:202})]] [[reko::convention(amd64kernel)]] long sys_futex(u32 *uaddr, int op, u32 val, struct timespec *utime, u32 *uaddr2, u32 val3);
[[reko::service(vector=0x80, regs={rax:203})]] [[reko::convention(amd64kernel)]] long sys_sched_setaffinity(pid_t pid, unsigned int len, unsigned long *user_mask_ptr);
[[reko::service(vector=0x80, regs={rax:204})]] [[reko::convention(amd64kernel)]] long sys_sched_getaffinity(pid_t pid, unsigned int len, unsigned long *user_mask_ptr);
[[reko::service(vector=0x80, regs={rax:205})]] [[reko::convention(amd64kernel)]] long sys_set_thread_area(NOT IMPLEMENTED. Use arch_prctl);
[[reko::service(vector=0x80, regs={rax:206})]] [[reko::convention(amd64kernel)]] long sys_io_setup(unsigned nr_events, aio_context_t *ctxp);
[[reko::service(vector=0x80, regs={rax:207})]] [[reko::convention(amd64kernel)]] long sys_io_destroy(aio_context_t ctx);
[[reko::service(vector=0x80, regs={rax:208})]] [[reko::convention(amd64kernel)]] long sys_io_getevents(aio_context_t ctx_id, long min_nr, long nr, struct io_event *events);
[[reko::service(vector=0x80, regs={rax:209})]] [[reko::convention(amd64kernel)]] long sys_io_submit(aio_context_t ctx_id, long nr, struct iocb **iocbpp);
[[reko::service(vector=0x80, regs={rax:210})]] [[reko::convention(amd64kernel)]] long sys_io_cancel(aio_context_t ctx_id, struct iocb *iocb, struct io_event *result);
[[reko::service(vector=0x80, regs={rax:211})]] [[reko::convention(amd64kernel)]] long sys_get_thread_area(NOT IMPLEMENTED. Use arch_prctl);
[[reko::service(vector=0x80, regs={rax:212})]] [[reko::convention(amd64kernel)]] long sys_lookup_dcookie(u64 cookie64, long buf, long len);
[[reko::service(vector=0x80, regs={rax:213})]] [[reko::convention(amd64kernel)]] long sys_epoll_create(int size);
[[reko::service(vector=0x80, regs={rax:214})]] [[reko::convention(amd64kernel)]] long sys_epoll_ctl_old(NOT IMPLEMENTED);
[[reko::service(vector=0x80, regs={rax:215})]] [[reko::convention(amd64kernel)]] long sys_epoll_wait_old(NOT IMPLEMENTED);
[[reko::service(vector=0x80, regs={rax:216})]] [[reko::convention(amd64kernel)]] long sys_remap_file_pages(unsigned long start, unsigned long size, unsigned long prot, unsigned long pgoff, unsigned long flags);
[[reko::service(vector=0x80, regs={rax:217})]] [[reko::convention(amd64kernel)]] long sys_getdents64(unsigned int fd, struct linux_dirent64 *dirent, unsigned int count);
[[reko::service(vector=0x80, regs={rax:218})]] [[reko::convention(amd64kernel)]] long sys_set_tid_address(int *tidptr);
[[reko::service(vector=0x80, regs={rax:219})]] [[reko::convention(amd64kernel)]] long sys_restart_syscall();
[[reko::service(vector=0x80, regs={rax:220})]] [[reko::convention(amd64kernel)]] long sys_semtimedop(int semid, struct sembuf *tsops, unsigned nsops, const struct timespec *timeout);
[[reko::service(vector=0x80, regs={rax:221})]] [[reko::convention(amd64kernel)]] long sys_fadvise64(int fd, loff_t offset, size_t len, int advice);
[[reko::service(vector=0x80, regs={rax:222})]] [[reko::convention(amd64kernel)]] long sys_timer_create(const clockid_t which_clock, struct sigevent *timer_event_spec, timer_t *created_timer_id);
[[reko::service(vector=0x80, regs={rax:223})]] [[reko::convention(amd64kernel)]] long sys_timer_settime(timer_t timer_id, int flags, const struct itimerspec *new_setting, struct itimerspec *old_setting);
[[reko::service(vector=0x80, regs={rax:224})]] [[reko::convention(amd64kernel)]] long sys_timer_gettime(timer_t timer_id, struct itimerspec *setting);
[[reko::service(vector=0x80, regs={rax:225})]] [[reko::convention(amd64kernel)]] long sys_timer_getoverrun(timer_t timer_id);
[[reko::service(vector=0x80, regs={rax:226})]] [[reko::convention(amd64kernel)]] long sys_timer_delete(timer_t timer_id);
[[reko::service(vector=0x80, regs={rax:227})]] [[reko::convention(amd64kernel)]] long sys_clock_settime(const clockid_t which_clock, const struct timespec *tp);
[[reko::service(vector=0x80, regs={rax:228})]] [[reko::convention(amd64kernel)]] long sys_clock_gettime(const clockid_t which_clock, struct timespec *tp);
[[reko::service(vector=0x80, regs={rax:229})]] [[reko::convention(amd64kernel)]] long sys_clock_getres(const clockid_t which_clock, struct timespec *tp);
[[reko::service(vector=0x80, regs={rax:230})]] [[reko::convention(amd64kernel)]] long sys_clock_nanosleep(const clockid_t which_clock, int flags, const struct timespec *rqtp, struct timespec *rmtp);
[[reko::service(vector=0x80, regs={rax:231})]] [[reko::convention(amd64kernel)]] long sys_exit_group(int error_code);
[[reko::service(vector=0x80, regs={rax:232})]] [[reko::convention(amd64kernel)]] long sys_epoll_wait(int epfd, struct epoll_event *events, int maxevents, int timeout);
[[reko::service(vector=0x80, regs={rax:233})]] [[reko::convention(amd64kernel)]] long sys_epoll_ctl(int epfd, int op, int fd, struct epoll_event *event);
[[reko::service(vector=0x80, regs={rax:234})]] [[reko::convention(amd64kernel)]] long sys_tgkill(pid_t tgid, pid_t pid, int sig);
[[reko::service(vector=0x80, regs={rax:235})]] [[reko::convention(amd64kernel)]] long sys_utimes(char *filename, struct timeval *utimes);
[[reko::service(vector=0x80, regs={rax:236})]] [[reko::convention(amd64kernel)]] long sys_vserver(NOT IMPLEMENTED);
[[reko::service(vector=0x80, regs={rax:237})]] [[reko::convention(amd64kernel)]] long sys_mbind(unsigned long start, unsigned long len, unsigned long mode, unsigned long *nmask, unsigned long maxnode, unsigned flags);
[[reko::service(vector=0x80, regs={rax:238})]] [[reko::convention(amd64kernel)]] long sys_set_mempolicy(int mode, unsigned long *nmask, unsigned long maxnode);
[[reko::service(vector=0x80, regs={rax:239})]] [[reko::convention(amd64kernel)]] long sys_get_mempolicy(int *policy, unsigned long *nmask, unsigned long maxnode, unsigned long addr, unsigned long flags);
[[reko::service(vector=0x80, regs={rax:240})]] [[reko::convention(amd64kernel)]] long sys_mq_open(const char *u_name, int oflag, mode_t mode, struct mq_attr *u_attr);
[[reko::service(vector=0x80, regs={rax:241})]] [[reko::convention(amd64kernel)]] long sys_mq_unlink(const char *u_name);
[[reko::service(vector=0x80, regs={rax:242})]] [[reko::convention(amd64kernel)]] long sys_mq_timedsend(mqd_t mqdes, const char *u_msg_ptr, size_t msg_len, unsigned int msg_prio, const stuct timespec *u_abs_timeout);
[[reko::service(vector=0x80, regs={rax:243})]] [[reko::convention(amd64kernel)]] long sys_mq_timedreceive(mqd_t mqdes, char *u_msg_ptr, size_t msg_len, unsigned int *u_msg_prio, const struct timespec *u_abs_timeout);
[[reko::service(vector=0x80, regs={rax:244})]] [[reko::convention(amd64kernel)]] long sys_mq_notify(mqd_t mqdes, const struct sigevent *u_notification);
[[reko::service(vector=0x80, regs={rax:245})]] [[reko::convention(amd64kernel)]] long sys_mq_getsetattr(mqd_t mqdes, const struct mq_attr *u_mqstat, struct mq_attr *u_omqstat);
[[reko::service(vector=0x80, regs={rax:246})]] [[reko::convention(amd64kernel)]] long sys_kexec_load(unsigned long entry, unsigned long nr_segments, struct kexec_segment *segments, unsigned long flags);
[[reko::service(vector=0x80, regs={rax:247})]] [[reko::convention(amd64kernel)]] long sys_waitid(int which, pid_t upid, struct siginfo *infop, int options, struct rusage *ru);
[[reko::service(vector=0x80, regs={rax:248})]] [[reko::convention(amd64kernel)]] long sys_add_key(const char *_type, const char *_description, const void *_payload, size_t plen);
[[reko::service(vector=0x80, regs={rax:249})]] [[reko::convention(amd64kernel)]] long sys_request_key(const char *_type, const char *_description, const char *_callout_info, key_serial_t destringid);
[[reko::service(vector=0x80, regs={rax:250})]] [[reko::convention(amd64kernel)]] long sys_keyctl(int option, unsigned long arg2, unsigned long arg3, unsigned long arg4, unsigned long arg5);
[[reko::service(vector=0x80, regs={rax:251})]] [[reko::convention(amd64kernel)]] long sys_ioprio_set(int which, int who, int ioprio);
[[reko::service(vector=0x80, regs={rax:252})]] [[reko::convention(amd64kernel)]] long sys_ioprio_get(int which, int who);
[[reko::service(vector=0x80, regs={rax:253})]] [[reko::convention(amd64kernel)]] long sys_inotify_init();
[[reko::service(vector=0x80, regs={rax:254})]] [[reko::convention(amd64kernel)]] long sys_inotify_add_watch(int fd, const char *pathname, u32 mask);
[[reko::service(vector=0x80, regs={rax:255})]] [[reko::convention(amd64kernel)]] long sys_inotify_rm_watch(int fd, __s32 wd);
[[reko::service(vector=0x80, regs={rax:256})]] [[reko::convention(amd64kernel)]] long sys_migrate_pages(pid_t pid, unsigned long maxnode, const unsigned long *old_nodes, const unsigned long *new_nodes);
[[reko::service(vector=0x80, regs={rax:257})]] [[reko::convention(amd64kernel)]] long sys_openat(int dfd, const char *filename, int flags, int mode);
[[reko::service(vector=0x80, regs={rax:258})]] [[reko::convention(amd64kernel)]] long sys_mkdirat(int dfd, const char *pathname, int mode);
[[reko::service(vector=0x80, regs={rax:259})]] [[reko::convention(amd64kernel)]] long sys_mknodat(int dfd, const char *filename, int mode, unsigned dev);
[[reko::service(vector=0x80, regs={rax:260})]] [[reko::convention(amd64kernel)]] long sys_fchownat(int dfd, const char *filename, uid_t user, gid_t group, int flag);
[[reko::service(vector=0x80, regs={rax:261})]] [[reko::convention(amd64kernel)]] long sys_futimesat(int dfd, const char *filename, struct timeval *utimes);
[[reko::service(vector=0x80, regs={rax:262})]] [[reko::convention(amd64kernel)]] long sys_newfstatat(int dfd, const char *filename, struct stat *statbuf, int flag);
[[reko::service(vector=0x80, regs={rax:263})]] [[reko::convention(amd64kernel)]] long sys_unlinkat(int dfd, const char *pathname, int flag);
[[reko::service(vector=0x80, regs={rax:264})]] [[reko::convention(amd64kernel)]] long sys_renameat(int oldfd, const char *oldname, int newfd, const char *newname);
[[reko::service(vector=0x80, regs={rax:265})]] [[reko::convention(amd64kernel)]] long sys_linkat(int oldfd, const char *oldname, int newfd, const char *newname, int flags);
[[reko::service(vector=0x80, regs={rax:266})]] [[reko::convention(amd64kernel)]] long sys_symlinkat(const char *oldname, int newfd, const char *newname);
[[reko::service(vector=0x80, regs={rax:267})]] [[reko::convention(amd64kernel)]] long sys_readlinkat(int dfd, const char *pathname, char *buf, int bufsiz);
[[reko::service(vector=0x80, regs={rax:268})]] [[reko::convention(amd64kernel)]] long sys_fchmodat(int dfd, const char *filename, mode_t mode);
[[reko::service(vector=0x80, regs={rax:269})]] [[reko::convention(amd64kernel)]] long sys_faccessat(int dfd, const char *filename, int mode);
[[reko::service(vector=0x80, regs={rax:270})]] [[reko::convention(amd64kernel)]] long sys_pselect6(int n, fd_set *inp, fd_set *outp, fd_set *exp, struct timespec *tsp, void *sig);
[[reko::service(vector=0x80, regs={rax:271})]] [[reko::convention(amd64kernel)]] long sys_ppoll(struct pollfd *ufds, unsigned int nfds, struct timespec *tsp, const sigset_t *sigmask, size_t sigsetsize);
[[reko::service(vector=0x80, regs={rax:272})]] [[reko::convention(amd64kernel)]] long sys_unshare(unsigned long unshare_flags);
[[reko::service(vector=0x80, regs={rax:273})]] [[reko::convention(amd64kernel)]] long sys_set_robust_list(struct robust_list_head *head, size_t len);
[[reko::service(vector=0x80, regs={rax:274})]] [[reko::convention(amd64kernel)]] long sys_get_robust_list(int pid, struct robust_list_head **head_ptr, size_t *len_ptr);
[[reko::service(vector=0x80, regs={rax:275})]] [[reko::convention(amd64kernel)]] long sys_splice(int fd_in, loff_t *off_in, int fd_out, loff_t *off_out, size_t len, unsigned int flags);
[[reko::service(vector=0x80, regs={rax:276})]] [[reko::convention(amd64kernel)]] long sys_tee(int fdin, int fdout, size_t len, unsigned int flags);
[[reko::service(vector=0x80, regs={rax:277})]] [[reko::convention(amd64kernel)]] long sys_sync_file_range(long fd, loff_t offset, loff_t bytes, long flags);
[[reko::service(vector=0x80, regs={rax:278})]] [[reko::convention(amd64kernel)]] long sys_vmsplice(int fd, const struct iovec *iov, unsigned long nr_segs, unsigned int flags);
[[reko::service(vector=0x80, regs={rax:279})]] [[reko::convention(amd64kernel)]] long sys_move_pages(pid_t pid, unsigned long nr_pages, const void **pages, const int *nodes, int *status, int flags);
[[reko::service(vector=0x80, regs={rax:280})]] [[reko::convention(amd64kernel)]] long sys_utimensat(int dfd, const char *filename, struct timespec *utimes, int flags);
[[reko::service(vector=0x80, regs={rax:281})]] [[reko::convention(amd64kernel)]] long sys_epoll_pwait(int epfd, struct epoll_event *events, int maxevents, int timeout, const sigset_t *sigmask, size_t sigsetsize);
[[reko::service(vector=0x80, regs={rax:282})]] [[reko::convention(amd64kernel)]] long sys_signalfd(int ufd, sigset_t *user_mask, size_t sizemask);
[[reko::service(vector=0x80, regs={rax:283})]] [[reko::convention(amd64kernel)]] long sys_timerfd_create(int clockid, int flags);
[[reko::service(vector=0x80, regs={rax:284})]] [[reko::convention(amd64kernel)]] long sys_eventfd(unsigned int count);
[[reko::service(vector=0x80, regs={rax:285})]] [[reko::convention(amd64kernel)]] long sys_fallocate(long fd, long mode, loff_t offset, loff_t len);
[[reko::service(vector=0x80, regs={rax:286})]] [[reko::convention(amd64kernel)]] long sys_timerfd_settime(int ufd, int flags, const struct itimerspec *utmr, struct itimerspec *otmr);
[[reko::service(vector=0x80, regs={rax:287})]] [[reko::convention(amd64kernel)]] long sys_timerfd_gettime(int ufd, struct itimerspec *otmr);
[[reko::service(vector=0x80, regs={rax:288})]] [[reko::convention(amd64kernel)]] long sys_accept4(int fd, struct sockaddr *upeer_sockaddr, int *upeer_addrlen, int flags);
[[reko::service(vector=0x80, regs={rax:289})]] [[reko::convention(amd64kernel)]] long sys_signalfd4(int ufd, sigset_t *user_mask, size_t sizemask, int flags);
[[reko::service(vector=0x80, regs={rax:290})]] [[reko::convention(amd64kernel)]] long sys_eventfd2(unsigned int count, int flags);
[[reko::service(vector=0x80, regs={rax:291})]] [[reko::convention(amd64kernel)]] long sys_epoll_create1(int flags);
[[reko::service(vector=0x80, regs={rax:292})]] [[reko::convention(amd64kernel)]] long sys_dup3(unsigned int oldfd, unsigned int newfd, int flags);
[[reko::service(vector=0x80, regs={rax:293})]] [[reko::convention(amd64kernel)]] long sys_pipe2(int *filedes, int flags);
[[reko::service(vector=0x80, regs={rax:294})]] [[reko::convention(amd64kernel)]] long sys_inotify_init1(int flags);
[[reko::service(vector=0x80, regs={rax:295})]] [[reko::convention(amd64kernel)]] long sys_preadv(unsigned long fd, const struct iovec *vec, unsigned long vlen, unsigned long pos_l, unsigned long pos_h);
[[reko::service(vector=0x80, regs={rax:296})]] [[reko::convention(amd64kernel)]] long sys_pwritev(unsigned long fd, const struct iovec *vec, unsigned long vlen, unsigned long pos_l, unsigned long pos_h);
[[reko::service(vector=0x80, regs={rax:297})]] [[reko::convention(amd64kernel)]] long sys_rt_tgsigqueueinfo(pid_t tgid, pid_t pid, int sig, siginfo_t *uinfo);
[[reko::service(vector=0x80, regs={rax:298})]] [[reko::convention(amd64kernel)]] long sys_perf_event_open(struct perf_event_attr *attr_uptr, pid_t pid, int cpu, int group_fd, unsigned long flags);
[[reko::service(vector=0x80, regs={rax:299})]] [[reko::convention(amd64kernel)]] long sys_recvmmsg(int fd, struct msghdr *mmsg, unsigned int vlen, unsigned int flags, struct timespec *timeout);
[[reko::service(vector=0x80, regs={rax:300})]] [[reko::convention(amd64kernel)]] long sys_fanotify_init(unsigned int flags, unsigned int event_f_flags);
[[reko::service(vector=0x80, regs={rax:301})]] [[reko::convention(amd64kernel)]] long sys_fanotify_mark(long fanotify_fd, long flags, __u64 mask, long dfd, long pathname);
[[reko::service(vector=0x80, regs={rax:302})]] [[reko::convention(amd64kernel)]] long sys_prlimit64(pid_t pid, unsigned int resource, const struct rlimit64 *new_rlim, struct rlimit64 *old_rlim);
[[reko::service(vector=0x80, regs={rax:303})]] [[reko::convention(amd64kernel)]] long sys_name_to_handle_at(int dfd, const char *name, struct file_handle *handle, int *mnt_id, int flag);
[[reko::service(vector=0x80, regs={rax:304})]] [[reko::convention(amd64kernel)]] long sys_open_by_handle_at(int dfd, const char *name, struct file_handle *handle, int *mnt_id, int flags);
[[reko::service(vector=0x80, regs={rax:305})]] [[reko::convention(amd64kernel)]] long sys_clock_adjtime(clockid_t which_clock, struct timex *tx);
[[reko::service(vector=0x80, regs={rax:306})]] [[reko::convention(amd64kernel)]] long sys_syncfs(int fd);
[[reko::service(vector=0x80, regs={rax:307})]] [[reko::convention(amd64kernel)]] long sys_sendmmsg(int fd, struct mmsghdr *mmsg, unsigned int vlen, unsigned int flags);
[[reko::service(vector=0x80, regs={rax:308})]] [[reko::convention(amd64kernel)]] long sys_setns(int fd, int nstype);
[[reko::service(vector=0x80, regs={rax:309})]] [[reko::convention(amd64kernel)]] long sys_getcpu(unsigned *cpup, unsigned *nodep, struct getcpu_cache *unused);
[[reko::service(vector=0x80, regs={rax:310})]] [[reko::convention(amd64kernel)]] long sys_process_vm_readv(pid_t pid, const struct iovec *lvec, unsigned long liovcnt, const struct iovec *rvec, unsigned long riovcnt, unsigned long flags);
[[reko::service(vector=0x80, regs={rax:311})]] [[reko::convention(amd64kernel)]] long sys_process_vm_writev(pid_t pid, const struct iovec *lvec, unsigned long liovcnt, const struct iovcc *rvec, unsigned long riovcnt, unsigned long flags);
[[reko::service(vector=0x80, regs={rax:312})]] [[reko::convention(amd64kernel)]] long sys_kcmp(pid_t pid1, pid_t pid2, int type, unsigned long idx1, unsigned long idx2);
[[reko::service(vector=0x80, regs={rax:313})]] [[reko::convention(amd64kernel)]] long sys_finit_module(int fd, const char __user *uargs, int flags);
[[reko::service(vector=0x80, regs={rax:314})]] [[reko::convention(amd64kernel)]] long sys_sched_setattr(pid_t pid, struct sched_attr __user *attr, unsigned int flags);
[[reko::service(vector=0x80, regs={rax:315})]] [[reko::convention(amd64kernel)]] long sys_sched_getattr(pid_t pid, struct sched_attr __user *attr, unsigned int size, unsigned int flags);
[[reko::service(vector=0x80, regs={rax:316})]] [[reko::convention(amd64kernel)]] long sys_renameat2(int olddfd, const char __user *oldname, int newdfd, const char __user *newname, unsigned int flags);
[[reko::service(vector=0x80, regs={rax:317})]] [[reko::convention(amd64kernel)]] long sys_seccomp(unsigned int op, unsigned int flags, const char __user *uargs);
[[reko::service(vector=0x80, regs={rax:318})]] [[reko::convention(amd64kernel)]] long sys_getrandom(char __user *buf, size_t count, unsigned int flags);
[[reko::service(vector=0x80, regs={rax:319})]] [[reko::convention(amd64kernel)]] long sys_memfd_create(const char __user *uname_ptr, unsigned
int flags);
[[reko::service(vector=0x80, regs={rax:320})]] [[reko::convention(amd64kernel)]] long sys_kexec_file_load(int kernel_fd, int initrd_fd, unsigned long cmdline_len, const char __user *cmdline_ptr, unsigned long flags);
[[reko::service(vector=0x80, regs={rax:321})]] [[reko::convention(amd64kernel)]] long sys_bpf(int cmd, union bpf_attr *attr, unsigned int size);
[[reko::service(vector=0x80, regs={rax:322})]] [[reko::convention(amd64kernel)]] long stub_execveat(int dfd, const char __user *filename, const char __user *const __user *argv, const char __user *const __user *envp, int flags);
[[reko::service(vector=0x80, regs={rax:323})]] [[reko::convention(amd64kernel)]] long userfaultfd(int flags);
[[reko::service(vector=0x80, regs={rax:324})]] [[reko::convention(amd64kernel)]] long membarrier(int cmd, int flags);
[[reko::service(vector=0x80, regs={rax:325})]] [[reko::convention(amd64kernel)]] long mlock2(unsigned long start, size_t len, int flags);
[[reko::service(vector=0x80, regs={rax:326})]] [[reko::convention(amd64kernel)]] long copy_file_range(int fd_in, loff_t __user *off_in, int fd_out, loff_t __user * off_out, size_t len, unsigned int flags);
[[reko::service(vector=0x80, regs={rax:327})]] [[reko::convention(amd64kernel)]] long preadv2(unsigned long fd, const struct iovec __user *vec, unsigned long vlen, unsigned long pos_l, unsigned long pos_h, int flags);
[[reko::service(vector=0x80, regs={rax:328})]] [[reko::convention(amd64kernel)]] long pwritev2(unsigned long fd, const struct iovec __user *vec, unsigned long vlen, unsigned long pos_l, unsigned long pos_h, int flags);
[[reko::service(vector=0x80, regs={rax:329})]] [[reko::convention(amd64kernel)]] long pkey_mprotect();
[[reko::service(vector=0x80, regs={rax:330})]] [[reko::convention(amd64kernel)]] long pkey_alloc();
[[reko::service(vector=0x80, regs={rax:331})]] [[reko::convention(amd64kernel)]] long pkey_free();
[[reko::service(vector=0x80, regs={rax:332})]] [[reko::convention(amd64kernel)]] long statx();
[[reko::service(vector=0x80, regs={rax:333})]] [[reko::convention(amd64kernel)]] long io_pgetevents();
[[reko::service(vector=0x80, regs={rax:334})]] [[reko::convention(amd64kernel)]] long rseq();
[[reko::service(vector=0x80, regs={rax:335})]] [[reko::convention(amd64kernel)]] long pkey_mprotect();
</library>
