﻿//  https://chromium.googlesource.com/chromiumos/docs/+/HEAD/constants/syscalls.md#x86-32_bit
typedef int gid_t;
typedef int pid_t;
typedef int uid_t;
typedef long __kernel_old_time_t;
typedef int old_sigset_t; //$REVIEW
typedef int sigset_t; //$REVIEW
typedef long loff_t;
typedef int umode_t;
typedef int qid_t;
typedef int siginfo_t;
typedef int key_serial_t;
typedef int rwf_t;

typedef int (*__sighandler_t)();
typedef unsigned int u32;
typedef unsigned long long u64;
typedef int __s32;
typedef int fd_set;
typedef void * cap_user_data_t;
typedef void * cap_user_header_t;
typedef void * aio_context_t;
typedef unsigned int size_t;
typedef int clockid_t;
typedef int timer_t;
typedef int mqd_t;

[[reko::service(vector=0x80, regs={eax:0x00})]] [[reko::convention(i386kernel)]] int sys_restart_syscall();
[[reko::service(vector=0x80, regs={eax:0x01})]] [[reko::convention(i386kernel)]] [[reko::characteristics({terminates:true})]]
	int sys_exit(int error_code);
[[reko::service(vector=0x80, regs={eax:0x02})]] [[reko::convention(i386kernel)]] int sys_fork();
[[reko::service(vector=0x80, regs={eax:0x03})]] [[reko::convention(i386kernel)]] int sys_read(unsigned int fd, char *buf, size_t count);
[[reko::service(vector=0x80, regs={eax:0x04})]] [[reko::convention(i386kernel)]] int sys_write(unsigned int fd, const char *buf, size_t count);
[[reko::service(vector=0x80, regs={eax:0x05})]] [[reko::convention(i386kernel)]] int sys_open(const char *filename, int flags, umode_t mode);
[[reko::service(vector=0x80, regs={eax:0x06})]] [[reko::convention(i386kernel)]] int sys_close(unsigned int fd);
[[reko::service(vector=0x80, regs={eax:0x07})]] [[reko::convention(i386kernel)]] int sys_waitpid(pid_t pid, int *stat_addr, int options);
[[reko::service(vector=0x80, regs={eax:0x08})]] [[reko::convention(i386kernel)]] int sys_creat(const char *pathname, umode_t mode);
[[reko::service(vector=0x80, regs={eax:0x09})]] [[reko::convention(i386kernel)]] int sys_link(const char *oldname, const char *newname);
[[reko::service(vector=0x80, regs={eax:0x0a})]] [[reko::convention(i386kernel)]] int sys_unlink(const char *pathname);
[[reko::service(vector=0x80, regs={eax:0x0b})]] [[reko::convention(i386kernel)]] int sys_execve(const char *filename, const char *const *argv, const char *const *envp);
[[reko::service(vector=0x80, regs={eax:0x0c})]] [[reko::convention(i386kernel)]] int sys_chdir(const char *filename);
[[reko::service(vector=0x80, regs={eax:0x0d})]] [[reko::convention(i386kernel)]] int sys_time(__kernel_old_time_t *tloc);
[[reko::service(vector=0x80, regs={eax:0x0e})]] [[reko::convention(i386kernel)]] int sys_mknod(const char *filename, umode_t mode, unsigned dev);
[[reko::service(vector=0x80, regs={eax:0x0f})]] [[reko::convention(i386kernel)]] int sys_chmod(const char *filename, umode_t mode);
[[reko::service(vector=0x80, regs={eax:0x10})]] [[reko::convention(i386kernel)]] int sys_lchown(const char *filename, uid_t user, gid_t group);
[[reko::service(vector=0x80, regs={eax:0x11})]] [[reko::convention(i386kernel)]] int sys_break();
[[reko::service(vector=0x80, regs={eax:0x12})]] [[reko::convention(i386kernel)]] int sys_oldstat();
[[reko::service(vector=0x80, regs={eax:0x13})]] [[reko::convention(i386kernel)]] int sys_lseek(unsigned int fd, off_t offset, unsigned int whence);
[[reko::service(vector=0x80, regs={eax:0x14})]] [[reko::convention(i386kernel)]] int sys_getpid();
[[reko::service(vector=0x80, regs={eax:0x15})]] [[reko::convention(i386kernel)]] int sys_mount(char *dev_name, char *dir_name, char *type, unsigned long flags, void *data);
[[reko::service(vector=0x80, regs={eax:0x16})]] [[reko::convention(i386kernel)]] int sys_umount(char *name, int flags);
[[reko::service(vector=0x80, regs={eax:0x17})]] [[reko::convention(i386kernel)]] int sys_setuid(uid_t uid);
[[reko::service(vector=0x80, regs={eax:0x18})]] [[reko::convention(i386kernel)]] int sys_getuid();
[[reko::service(vector=0x80, regs={eax:0x19})]] [[reko::convention(i386kernel)]] int sys_stime(__kernel_old_time_t *tptr);
[[reko::service(vector=0x80, regs={eax:0x1a})]] [[reko::convention(i386kernel)]] int sys_ptrace(long request, long pid, unsigned long addr, unsigned long data);
[[reko::service(vector=0x80, regs={eax:0x1b})]] [[reko::convention(i386kernel)]] int sys_alarm(unsigned int seconds);
[[reko::service(vector=0x80, regs={eax:0x1c})]] [[reko::convention(i386kernel)]] int sys_oldfstat();
[[reko::service(vector=0x80, regs={eax:0x1d})]] [[reko::convention(i386kernel)]] int sys_pause();
[[reko::service(vector=0x80, regs={eax:0x1e})]] [[reko::convention(i386kernel)]] int sys_utime(char *filename, struct utimbuf *times);
[[reko::service(vector=0x80, regs={eax:0x1f})]] [[reko::convention(i386kernel)]] int sys_stty();
[[reko::service(vector=0x80, regs={eax:0x20})]] [[reko::convention(i386kernel)]] int sys_gtty();
[[reko::service(vector=0x80, regs={eax:0x21})]] [[reko::convention(i386kernel)]] int sys_access(const char *filename, int mode);
[[reko::service(vector=0x80, regs={eax:0x22})]] [[reko::convention(i386kernel)]] int sys_nice(int increment);
[[reko::service(vector=0x80, regs={eax:0x23})]] [[reko::convention(i386kernel)]] int sys_ftime();
[[reko::service(vector=0x80, regs={eax:0x24})]] [[reko::convention(i386kernel)]] int sys_sync();
[[reko::service(vector=0x80, regs={eax:0x25})]] [[reko::convention(i386kernel)]] int sys_kill(pid_t pid, int sig);
[[reko::service(vector=0x80, regs={eax:0x26})]] [[reko::convention(i386kernel)]] int sys_rename(const char *oldname, const char *newname);
[[reko::service(vector=0x80, regs={eax:0x27})]] [[reko::convention(i386kernel)]] int sys_mkdir(const char *pathname, umode_t mode);
[[reko::service(vector=0x80, regs={eax:0x28})]] [[reko::convention(i386kernel)]] int sys_rmdir(const char *pathname);
[[reko::service(vector=0x80, regs={eax:0x29})]] [[reko::convention(i386kernel)]] int sys_dup(unsigned int fildes);
[[reko::service(vector=0x80, regs={eax:0x2a})]] [[reko::convention(i386kernel)]] int sys_pipe(int *fildes);
[[reko::service(vector=0x80, regs={eax:0x2b})]] [[reko::convention(i386kernel)]] int sys_times(struct tms *tbuf);
[[reko::service(vector=0x80, regs={eax:0x2c})]] [[reko::convention(i386kernel)]] int sys_prof();
[[reko::service(vector=0x80, regs={eax:0x2d})]] [[reko::convention(i386kernel)]] int sys_brk(unsigned long brk);
[[reko::service(vector=0x80, regs={eax:0x2e})]] [[reko::convention(i386kernel)]] int sys_setgid(gid_t gid);
[[reko::service(vector=0x80, regs={eax:0x2f})]] [[reko::convention(i386kernel)]] int sys_getgid();
[[reko::service(vector=0x80, regs={eax:0x30})]] [[reko::convention(i386kernel)]] int sys_signal(int sig, __sighandler_t handler);
[[reko::service(vector=0x80, regs={eax:0x31})]] [[reko::convention(i386kernel)]] int sys_geteuid();
[[reko::service(vector=0x80, regs={eax:0x32})]] [[reko::convention(i386kernel)]] int sys_getegid();
[[reko::service(vector=0x80, regs={eax:0x33})]] [[reko::convention(i386kernel)]] int sys_acct(const char *name);
[[reko::service(vector=0x80, regs={eax:0x34})]] [[reko::convention(i386kernel)]] int sys_umount2();
[[reko::service(vector=0x80, regs={eax:0x35})]] [[reko::convention(i386kernel)]] int sys_lock();
[[reko::service(vector=0x80, regs={eax:0x36})]] [[reko::convention(i386kernel)]] int sys_ioctl(unsigned int fd, unsigned int cmd, unsigned long arg);
[[reko::service(vector=0x80, regs={eax:0x37})]] [[reko::convention(i386kernel)]] int sys_fcntl(unsigned int fd, unsigned int cmd, unsigned long arg);
[[reko::service(vector=0x80, regs={eax:0x38})]] [[reko::convention(i386kernel)]] int sys_mpx();
[[reko::service(vector=0x80, regs={eax:0x39})]] [[reko::convention(i386kernel)]] int sys_setpgid(pid_t pid, pid_t pgid);
[[reko::service(vector=0x80, regs={eax:0x3a})]] [[reko::convention(i386kernel)]] int sys_ulimit();
[[reko::service(vector=0x80, regs={eax:0x3b})]] [[reko::convention(i386kernel)]] int sys_oldolduname();
[[reko::service(vector=0x80, regs={eax:0x3c})]] [[reko::convention(i386kernel)]] int sys_umask(int mask);
[[reko::service(vector=0x80, regs={eax:0x3d})]] [[reko::convention(i386kernel)]] int sys_chroot(const char *filename);
[[reko::service(vector=0x80, regs={eax:0x3e})]] [[reko::convention(i386kernel)]] int sys_ustat(unsigned dev, struct ustat *ubuf);
[[reko::service(vector=0x80, regs={eax:0x3f})]] [[reko::convention(i386kernel)]] int sys_dup2(unsigned int oldfd, unsigned int newfd);
[[reko::service(vector=0x80, regs={eax:0x40})]] [[reko::convention(i386kernel)]] int sys_getppid();
[[reko::service(vector=0x80, regs={eax:0x41})]] [[reko::convention(i386kernel)]] int sys_getpgrp();
[[reko::service(vector=0x80, regs={eax:0x42})]] [[reko::convention(i386kernel)]] int sys_setsid();
[[reko::service(vector=0x80, regs={eax:0x43})]] [[reko::convention(i386kernel)]] int sys_sigaction(int, const struct old_sigaction *, struct old_sigaction *);
[[reko::service(vector=0x80, regs={eax:0x44})]] [[reko::convention(i386kernel)]] int sys_sgetmask();
[[reko::service(vector=0x80, regs={eax:0x45})]] [[reko::convention(i386kernel)]] int sys_ssetmask(int newmask);
[[reko::service(vector=0x80, regs={eax:0x46})]] [[reko::convention(i386kernel)]] int sys_setreuid(uid_t ruid, uid_t euid);
[[reko::service(vector=0x80, regs={eax:0x47})]] [[reko::convention(i386kernel)]] int sys_setregid(gid_t rgid, gid_t egid);
[[reko::service(vector=0x80, regs={eax:0x48})]] [[reko::convention(i386kernel)]] int sys_sigsuspend(int unused1, int unused2, old_sigset_t mask);
[[reko::service(vector=0x80, regs={eax:0x49})]] [[reko::convention(i386kernel)]] int sys_sigpending(old_sigset_t *uset);
[[reko::service(vector=0x80, regs={eax:0x4a})]] [[reko::convention(i386kernel)]] int sys_sethostname(char *name, int len);
[[reko::service(vector=0x80, regs={eax:0x4b})]] [[reko::convention(i386kernel)]] int sys_setrlimit(unsigned int resource, struct rlimit *rlim);
[[reko::service(vector=0x80, regs={eax:0x4c})]] [[reko::convention(i386kernel)]] int sys_getrlimit(unsigned int resource, struct rlimit *rlim);
[[reko::service(vector=0x80, regs={eax:0x4d})]] [[reko::convention(i386kernel)]] int sys_getrusage(int who, struct rusage *ru);
[[reko::service(vector=0x80, regs={eax:0x4e})]] [[reko::convention(i386kernel)]] int sys_gettimeofday(struct __kernel_old_timeval *tv, struct timezone *tz);
[[reko::service(vector=0x80, regs={eax:0x4f})]] [[reko::convention(i386kernel)]] int sys_settimeofday(struct __kernel_old_timeval *tv, struct timezone *tz);
[[reko::service(vector=0x80, regs={eax:0x50})]] [[reko::convention(i386kernel)]] int sys_getgroups(int gidsetsize, gid_t *grouplist);
[[reko::service(vector=0x80, regs={eax:0x51})]] [[reko::convention(i386kernel)]] int sys_setgroups(int gidsetsize, gid_t *grouplist);
[[reko::service(vector=0x80, regs={eax:0x52})]] [[reko::convention(i386kernel)]] int sys_select(int n, fd_set *inp, fd_set *outp, fd_set *exp, struct __kernel_old_timeval *tvp);
[[reko::service(vector=0x80, regs={eax:0x53})]] [[reko::convention(i386kernel)]] int sys_symlink(const char *old, const char *new);
[[reko::service(vector=0x80, regs={eax:0x54})]] [[reko::convention(i386kernel)]] int sys_oldlstat();
[[reko::service(vector=0x80, regs={eax:0x55})]] [[reko::convention(i386kernel)]] int sys_readlink(const char *path, char *buf, int bufsiz);
[[reko::service(vector=0x80, regs={eax:0x56})]] [[reko::convention(i386kernel)]] int sys_uselib(const char *library);
[[reko::service(vector=0x80, regs={eax:0x57})]] [[reko::convention(i386kernel)]] int sys_swapon(const char *specialfile, int swap_flags);
[[reko::service(vector=0x80, regs={eax:0x58})]] [[reko::convention(i386kernel)]] int sys_reboot(int magic1, int magic2, unsigned int cmd, void *arg);
[[reko::service(vector=0x80, regs={eax:0x59})]] [[reko::convention(i386kernel)]] int sys_readdir();
[[reko::service(vector=0x80, regs={eax:0x5a})]] [[reko::convention(i386kernel)]] int sys_mmap();
[[reko::service(vector=0x80, regs={eax:0x5b})]] [[reko::convention(i386kernel)]] int sys_munmap(unsigned long addr, size_t len);
[[reko::service(vector=0x80, regs={eax:0x5c})]] [[reko::convention(i386kernel)]] int sys_truncate(const char *path, long length);
[[reko::service(vector=0x80, regs={eax:0x5d})]] [[reko::convention(i386kernel)]] int sys_ftruncate(unsigned int fd, unsigned long length);
[[reko::service(vector=0x80, regs={eax:0x5e})]] [[reko::convention(i386kernel)]] int sys_fchmod(unsigned int fd, umode_t mode);
[[reko::service(vector=0x80, regs={eax:0x5f})]] [[reko::convention(i386kernel)]] int sys_fchown(unsigned int fd, uid_t user, gid_t group);
[[reko::service(vector=0x80, regs={eax:0x60})]] [[reko::convention(i386kernel)]] int sys_getpriority(int which, int who);
[[reko::service(vector=0x80, regs={eax:0x61})]] [[reko::convention(i386kernel)]] int sys_setpriority(int which, int who, int niceval);
[[reko::service(vector=0x80, regs={eax:0x62})]] [[reko::convention(i386kernel)]] int sys_profil();
[[reko::service(vector=0x80, regs={eax:0x63})]] [[reko::convention(i386kernel)]] int sys_statfs(const char * path, struct statfs *buf);
[[reko::service(vector=0x80, regs={eax:0x64})]] [[reko::convention(i386kernel)]] int sys_fstatfs(unsigned int fd, struct statfs *buf);
[[reko::service(vector=0x80, regs={eax:0x65})]] [[reko::convention(i386kernel)]] int sys_ioperm(unsigned long from, unsigned long num, int on);
[[reko::service(vector=0x80, regs={eax:0x66})]] [[reko::convention(i386kernel)]] int sys_socketcall(int call, unsigned long *args);
[[reko::service(vector=0x80, regs={eax:0x67})]] [[reko::convention(i386kernel)]] int sys_syslog(int type, char *buf, int len);
[[reko::service(vector=0x80, regs={eax:0x68})]] [[reko::convention(i386kernel)]] int sys_setitimer(int which, struct __kernel_old_itimerval *value, struct __kernel_old_itimerval *ovalue);
[[reko::service(vector=0x80, regs={eax:0x69})]] [[reko::convention(i386kernel)]] int sys_getitimer(int which, struct __kernel_old_itimerval *value);
[[reko::service(vector=0x80, regs={eax:0x6a})]] [[reko::convention(i386kernel)]] int sys_stat(const char *filename, struct __old_kernel_stat *statbuf);
[[reko::service(vector=0x80, regs={eax:0x6b})]] [[reko::convention(i386kernel)]] int sys_lstat(const char *filename, struct __old_kernel_stat *statbuf);
[[reko::service(vector=0x80, regs={eax:0x6c})]] [[reko::convention(i386kernel)]] int sys_fstat(unsigned int fd, struct __old_kernel_stat *statbuf);
[[reko::service(vector=0x80, regs={eax:0x6d})]] [[reko::convention(i386kernel)]] int sys_olduname(struct oldold_utsname *);
[[reko::service(vector=0x80, regs={eax:0x6e})]] [[reko::convention(i386kernel)]] int sys_iopl();
[[reko::service(vector=0x80, regs={eax:0x6f})]] [[reko::convention(i386kernel)]] int sys_vhangup();
[[reko::service(vector=0x80, regs={eax:0x70})]] [[reko::convention(i386kernel)]] int sys_idle();
[[reko::service(vector=0x80, regs={eax:0x71})]] [[reko::convention(i386kernel)]] int sys_vm86old();
[[reko::service(vector=0x80, regs={eax:0x72})]] [[reko::convention(i386kernel)]] int sys_wait4(pid_t pid, int *stat_addr, int options, struct rusage *ru);
[[reko::service(vector=0x80, regs={eax:0x73})]] [[reko::convention(i386kernel)]] int sys_swapoff(const char *specialfile);
[[reko::service(vector=0x80, regs={eax:0x74})]] [[reko::convention(i386kernel)]] int sys_sysinfo(struct sysinfo *info);
[[reko::service(vector=0x80, regs={eax:0x75})]] [[reko::convention(i386kernel)]] int sys_ipc(unsigned int call, int first, unsigned long second, unsigned long third, void *ptr, long fifth);
[[reko::service(vector=0x80, regs={eax:0x76})]] [[reko::convention(i386kernel)]] int sys_fsync(unsigned int fd);
[[reko::service(vector=0x80, regs={eax:0x77})]] [[reko::convention(i386kernel)]] int sys_sigreturn();
[[reko::service(vector=0x80, regs={eax:0x78})]] [[reko::convention(i386kernel)]] int sys_clone(unsigned long, unsigned long, int *, int *, unsigned long);
[[reko::service(vector=0x80, regs={eax:0x79})]] [[reko::convention(i386kernel)]] int sys_setdomainname(char *name, int len);
[[reko::service(vector=0x80, regs={eax:0x7a})]] [[reko::convention(i386kernel)]] int sys_uname(struct old_utsname *);
[[reko::service(vector=0x80, regs={eax:0x7b})]] [[reko::convention(i386kernel)]] int sys_modify_ldt();
[[reko::service(vector=0x80, regs={eax:0x7c})]] [[reko::convention(i386kernel)]] int sys_adjtimex(struct __kernel_timex *txc_p);
[[reko::service(vector=0x80, regs={eax:0x7d})]] [[reko::convention(i386kernel)]] int sys_mprotect(unsigned long start, size_t len, unsigned long prot);
[[reko::service(vector=0x80, regs={eax:0x7e})]] [[reko::convention(i386kernel)]] int sys_sigprocmask(int how, old_sigset_t *set, old_sigset_t *oset);
[[reko::service(vector=0x80, regs={eax:0x7f})]] [[reko::convention(i386kernel)]] int sys_create_module();
[[reko::service(vector=0x80, regs={eax:0x80})]] [[reko::convention(i386kernel)]] int sys_init_module(void *umod, unsigned long len, const char *uargs);
[[reko::service(vector=0x80, regs={eax:0x81})]] [[reko::convention(i386kernel)]] int sys_delete_module(const char *name_user, unsigned int flags);
[[reko::service(vector=0x80, regs={eax:0x82})]] [[reko::convention(i386kernel)]] int sys_get_kernel_syms();
[[reko::service(vector=0x80, regs={eax:0x83})]] [[reko::convention(i386kernel)]] int sys_quotactl(unsigned int cmd, const char *special, qid_t id, void *addr);
[[reko::service(vector=0x80, regs={eax:0x84})]] [[reko::convention(i386kernel)]] int sys_getpgid(pid_t pid);
[[reko::service(vector=0x80, regs={eax:0x85})]] [[reko::convention(i386kernel)]] int sys_fchdir(unsigned int fd);
[[reko::service(vector=0x80, regs={eax:0x86})]] [[reko::convention(i386kernel)]] int sys_bdflush();
[[reko::service(vector=0x80, regs={eax:0x87})]] [[reko::convention(i386kernel)]] int sys_sysfs(int option, unsigned long arg1, unsigned long arg2);
[[reko::service(vector=0x80, regs={eax:0x88})]] [[reko::convention(i386kernel)]] int sys_personality(unsigned int personality);
[[reko::service(vector=0x80, regs={eax:0x89})]] [[reko::convention(i386kernel)]] int sys_afs_syscall();
[[reko::service(vector=0x80, regs={eax:0x8a})]] [[reko::convention(i386kernel)]] int sys_setfsuid(uid_t uid);
[[reko::service(vector=0x80, regs={eax:0x8b})]] [[reko::convention(i386kernel)]] int sys_setfsgid(gid_t gid);
[[reko::service(vector=0x80, regs={eax:0x8c})]] [[reko::convention(i386kernel)]] int sys__llseek();
[[reko::service(vector=0x80, regs={eax:0x8d})]] [[reko::convention(i386kernel)]] int sys_getdents(unsigned int fd, struct linux_dirent *dirent, unsigned int count);
[[reko::service(vector=0x80, regs={eax:0x8e})]] [[reko::convention(i386kernel)]] int sys__newselect();
[[reko::service(vector=0x80, regs={eax:0x8f})]] [[reko::convention(i386kernel)]] int sys_flock(unsigned int fd, unsigned int cmd);
[[reko::service(vector=0x80, regs={eax:0x90})]] [[reko::convention(i386kernel)]] int sys_msync(unsigned long start, size_t len, int flags);
[[reko::service(vector=0x80, regs={eax:0x91})]] [[reko::convention(i386kernel)]] int sys_readv(unsigned long fd, const struct iovec *vec, unsigned long vlen);
[[reko::service(vector=0x80, regs={eax:0x92})]] [[reko::convention(i386kernel)]] int sys_writev(unsigned long fd, const struct iovec *vec, unsigned long vlen);
[[reko::service(vector=0x80, regs={eax:0x93})]] [[reko::convention(i386kernel)]] int sys_getsid(pid_t pid);
[[reko::service(vector=0x80, regs={eax:0x94})]] [[reko::convention(i386kernel)]] int sys_fdatasync(unsigned int fd);
[[reko::service(vector=0x80, regs={eax:0x95})]] [[reko::convention(i386kernel)]] int sys__sysctl();
[[reko::service(vector=0x80, regs={eax:0x96})]] [[reko::convention(i386kernel)]] int sys_mlock(unsigned long start, size_t len);
[[reko::service(vector=0x80, regs={eax:0x97})]] [[reko::convention(i386kernel)]] int sys_munlock(unsigned long start, size_t len);
[[reko::service(vector=0x80, regs={eax:0x98})]] [[reko::convention(i386kernel)]] int sys_mlockall(int flags);
[[reko::service(vector=0x80, regs={eax:0x99})]] [[reko::convention(i386kernel)]] int sys_munlockall();
[[reko::service(vector=0x80, regs={eax:0x9a})]] [[reko::convention(i386kernel)]] int sys_sched_setparam(pid_t pid, struct sched_param *param);
[[reko::service(vector=0x80, regs={eax:0x9b})]] [[reko::convention(i386kernel)]] int sys_sched_getparam(pid_t pid, struct sched_param *param);
[[reko::service(vector=0x80, regs={eax:0x9c})]] [[reko::convention(i386kernel)]] int sys_sched_setscheduler(pid_t pid, int policy, struct sched_param *param);
[[reko::service(vector=0x80, regs={eax:0x9d})]] [[reko::convention(i386kernel)]] int sys_sched_getscheduler(pid_t pid);
[[reko::service(vector=0x80, regs={eax:0x9e})]] [[reko::convention(i386kernel)]] int sys_sched_yield();
[[reko::service(vector=0x80, regs={eax:0x9f})]] [[reko::convention(i386kernel)]] int sys_sched_get_priority_max(int policy);
[[reko::service(vector=0x80, regs={eax:0xa0})]] [[reko::convention(i386kernel)]] int sys_sched_get_priority_min(int policy);
[[reko::service(vector=0x80, regs={eax:0xa1})]] [[reko::convention(i386kernel)]] int sys_sched_rr_get_interval(pid_t pid, struct __kernel_timespec *interval);
[[reko::service(vector=0x80, regs={eax:0xa2})]] [[reko::convention(i386kernel)]] int sys_nanosleep(struct __kernel_timespec *rqtp, struct __kernel_timespec *rmtp);
[[reko::service(vector=0x80, regs={eax:0xa3})]] [[reko::convention(i386kernel)]] int sys_mremap(unsigned long addr, unsigned long old_len, unsigned long new_len, unsigned long flags, unsigned long new_addr);
[[reko::service(vector=0x80, regs={eax:0xa4})]] [[reko::convention(i386kernel)]] int sys_setresuid(uid_t ruid, uid_t euid, uid_t suid);
[[reko::service(vector=0x80, regs={eax:0xa5})]] [[reko::convention(i386kernel)]] int sys_getresuid(uid_t *ruid, uid_t *euid, uid_t *suid);
[[reko::service(vector=0x80, regs={eax:0xa6})]] [[reko::convention(i386kernel)]] int sys_vm86();
[[reko::service(vector=0x80, regs={eax:0xa7})]] [[reko::convention(i386kernel)]] int sys_query_module();
[[reko::service(vector=0x80, regs={eax:0xa8})]] [[reko::convention(i386kernel)]] int sys_poll(struct pollfd *ufds, unsigned int nfds, int timeout);
[[reko::service(vector=0x80, regs={eax:0xa9})]] [[reko::convention(i386kernel)]] int sys_nfsservctl();
[[reko::service(vector=0x80, regs={eax:0xaa})]] [[reko::convention(i386kernel)]] int sys_setresgid(gid_t rgid, gid_t egid, gid_t sgid);
[[reko::service(vector=0x80, regs={eax:0xab})]] [[reko::convention(i386kernel)]] int sys_getresgid(gid_t *rgid, gid_t *egid, gid_t *sgid);
[[reko::service(vector=0x80, regs={eax:0xac})]] [[reko::convention(i386kernel)]] int sys_prctl(int option, unsigned long arg2, unsigned long arg3, unsigned long arg4, unsigned long arg5);
[[reko::service(vector=0x80, regs={eax:0xad})]] [[reko::convention(i386kernel)]] int sys_rt_sigreturn();
[[reko::service(vector=0x80, regs={eax:0xae})]] [[reko::convention(i386kernel)]] int sys_rt_sigaction(int, const struct sigaction *, struct sigaction *, size_t);
[[reko::service(vector=0x80, regs={eax:0xaf})]] [[reko::convention(i386kernel)]] int sys_rt_sigprocmask(int how, sigset_t *set, sigset_t *oset, size_t sigsetsize);
[[reko::service(vector=0x80, regs={eax:0xb0})]] [[reko::convention(i386kernel)]] int sys_rt_sigpending(sigset_t *set, size_t sigsetsize);
[[reko::service(vector=0x80, regs={eax:0xb1})]] [[reko::convention(i386kernel)]] int sys_rt_sigtimedwait(const sigset_t *uthese, siginfo_t *uinfo, const struct __kernel_timespec *uts, size_t sigsetsize);
[[reko::service(vector=0x80, regs={eax:0xb2})]] [[reko::convention(i386kernel)]] int sys_rt_sigqueueinfo(pid_t pid, int sig, siginfo_t *uinfo);
[[reko::service(vector=0x80, regs={eax:0xb3})]] [[reko::convention(i386kernel)]] int sys_rt_sigsuspend(sigset_t *unewset, size_t sigsetsize);
[[reko::service(vector=0x80, regs={eax:0xb4})]] [[reko::convention(i386kernel)]] int sys_pread64(unsigned int fd, char *buf, size_t count, loff_t pos);
[[reko::service(vector=0x80, regs={eax:0xb5})]] [[reko::convention(i386kernel)]] int sys_pwrite64(unsigned int fd, const char *buf, size_t count, loff_t pos);
[[reko::service(vector=0x80, regs={eax:0xb6})]] [[reko::convention(i386kernel)]] int sys_chown(const char *filename, uid_t user, gid_t group);
[[reko::service(vector=0x80, regs={eax:0xb7})]] [[reko::convention(i386kernel)]] int sys_getcwd(char *buf, unsigned long size);
[[reko::service(vector=0x80, regs={eax:0xb8})]] [[reko::convention(i386kernel)]] int sys_capget(cap_user_header_t header, cap_user_data_t dataptr);
[[reko::service(vector=0x80, regs={eax:0xb9})]] [[reko::convention(i386kernel)]] int sys_capset(cap_user_header_t header, const cap_user_data_t data);
[[reko::service(vector=0x80, regs={eax:0xba})]] [[reko::convention(i386kernel)]] int sys_sigaltstack(const struct sigaltstack *uss, struct sigaltstack *uoss);
[[reko::service(vector=0x80, regs={eax:0xbb})]] [[reko::convention(i386kernel)]] int sys_sendfile(int out_fd, int in_fd, off_t *offset, size_t count);
[[reko::service(vector=0x80, regs={eax:0xbc})]] [[reko::convention(i386kernel)]] int sys_getpmsg();
[[reko::service(vector=0x80, regs={eax:0xbd})]] [[reko::convention(i386kernel)]] int sys_putpmsg();
[[reko::service(vector=0x80, regs={eax:0xbe})]] [[reko::convention(i386kernel)]] int sys_vfork();
[[reko::service(vector=0x80, regs={eax:0xbf})]] [[reko::convention(i386kernel)]] int sys_ugetrlimit();
[[reko::service(vector=0x80, regs={eax:0xc0})]] [[reko::convention(i386kernel)]] int sys_mmap2();
[[reko::service(vector=0x80, regs={eax:0xc1})]] [[reko::convention(i386kernel)]] int sys_truncate64(const char *path, loff_t length);
[[reko::service(vector=0x80, regs={eax:0xc2})]] [[reko::convention(i386kernel)]] int sys_ftruncate64(unsigned int fd, loff_t length);
[[reko::service(vector=0x80, regs={eax:0xc3})]] [[reko::convention(i386kernel)]] int sys_stat64(const char *filename, struct stat64 *statbuf);
[[reko::service(vector=0x80, regs={eax:0xc4})]] [[reko::convention(i386kernel)]] int sys_lstat64(const char *filename, struct stat64 *statbuf);
[[reko::service(vector=0x80, regs={eax:0xc5})]] [[reko::convention(i386kernel)]] int sys_fstat64(unsigned long fd, struct stat64 *statbuf);
[[reko::service(vector=0x80, regs={eax:0xc6})]] [[reko::convention(i386kernel)]] int sys_lchown32();
[[reko::service(vector=0x80, regs={eax:0xc7})]] [[reko::convention(i386kernel)]] int sys_getuid32();
[[reko::service(vector=0x80, regs={eax:0xc8})]] [[reko::convention(i386kernel)]] int sys_getgid32();
[[reko::service(vector=0x80, regs={eax:0xc9})]] [[reko::convention(i386kernel)]] int sys_geteuid32();
[[reko::service(vector=0x80, regs={eax:0xca})]] [[reko::convention(i386kernel)]] int sys_getegid32();
[[reko::service(vector=0x80, regs={eax:0xcb})]] [[reko::convention(i386kernel)]] int sys_setreuid32();
[[reko::service(vector=0x80, regs={eax:0xcc})]] [[reko::convention(i386kernel)]] int sys_setregid32();
[[reko::service(vector=0x80, regs={eax:0xcd})]] [[reko::convention(i386kernel)]] int sys_getgroups32();
[[reko::service(vector=0x80, regs={eax:0xce})]] [[reko::convention(i386kernel)]] int sys_setgroups32();
[[reko::service(vector=0x80, regs={eax:0xcf})]] [[reko::convention(i386kernel)]] int sys_fchown32();
[[reko::service(vector=0x80, regs={eax:0xd0})]] [[reko::convention(i386kernel)]] int sys_setresuid32();
[[reko::service(vector=0x80, regs={eax:0xd1})]] [[reko::convention(i386kernel)]] int sys_getresuid32();
[[reko::service(vector=0x80, regs={eax:0xd2})]] [[reko::convention(i386kernel)]] int sys_setresgid32();
[[reko::service(vector=0x80, regs={eax:0xd3})]] [[reko::convention(i386kernel)]] int sys_getresgid32();
[[reko::service(vector=0x80, regs={eax:0xd4})]] [[reko::convention(i386kernel)]] int sys_chown32();
[[reko::service(vector=0x80, regs={eax:0xd5})]] [[reko::convention(i386kernel)]] int sys_setuid32();
[[reko::service(vector=0x80, regs={eax:0xd6})]] [[reko::convention(i386kernel)]] int sys_setgid32();
[[reko::service(vector=0x80, regs={eax:0xd7})]] [[reko::convention(i386kernel)]] int sys_setfsuid32();
[[reko::service(vector=0x80, regs={eax:0xd8})]] [[reko::convention(i386kernel)]] int sys_setfsgid32();
[[reko::service(vector=0x80, regs={eax:0xd9})]] [[reko::convention(i386kernel)]] int sys_pivot_root(const char *new_root, const char *put_old);
[[reko::service(vector=0x80, regs={eax:0xda})]] [[reko::convention(i386kernel)]] int sys_mincore(unsigned long start, size_t len, unsigned char * vec);
[[reko::service(vector=0x80, regs={eax:0xdb})]] [[reko::convention(i386kernel)]] int sys_madvise(unsigned long start, size_t len, int behavior);
[[reko::service(vector=0x80, regs={eax:0xdc})]] [[reko::convention(i386kernel)]] int sys_getdents64(unsigned int fd, struct linux_dirent64 *dirent, unsigned int count);
[[reko::service(vector=0x80, regs={eax:0xdd})]] [[reko::convention(i386kernel)]] int sys_fcntl64(unsigned int fd, unsigned int cmd, unsigned long arg);
[[reko::service(vector=0x80, regs={eax:0xe0})]] [[reko::convention(i386kernel)]] int sys_gettid();
[[reko::service(vector=0x80, regs={eax:0xe1})]] [[reko::convention(i386kernel)]] int sys_readahead(int fd, loff_t offset, size_t count);
[[reko::service(vector=0x80, regs={eax:0xe2})]] [[reko::convention(i386kernel)]] int sys_setxattr(const char *path, const char *name, const void *value, size_t size, int flags);
[[reko::service(vector=0x80, regs={eax:0xe3})]] [[reko::convention(i386kernel)]] int sys_lsetxattr(const char *path, const char *name, const void *value, size_t size, int flags);
[[reko::service(vector=0x80, regs={eax:0xe4})]] [[reko::convention(i386kernel)]] int sys_fsetxattr(int fd, const char *name, const void *value, size_t size, int flags);
[[reko::service(vector=0x80, regs={eax:0xe5})]] [[reko::convention(i386kernel)]] int sys_getxattr(const char *path, const char *name, void *value, size_t size);
[[reko::service(vector=0x80, regs={eax:0xe6})]] [[reko::convention(i386kernel)]] int sys_lgetxattr(const char *path, const char *name, void *value, size_t size);
[[reko::service(vector=0x80, regs={eax:0xe7})]] [[reko::convention(i386kernel)]] int sys_fgetxattr(int fd, const char *name, void *value, size_t size);
[[reko::service(vector=0x80, regs={eax:0xe8})]] [[reko::convention(i386kernel)]] int sys_listxattr(const char *path, char *list, size_t size);
[[reko::service(vector=0x80, regs={eax:0xe9})]] [[reko::convention(i386kernel)]] int sys_llistxattr(const char *path, char *list, size_t size);
[[reko::service(vector=0x80, regs={eax:0xea})]] [[reko::convention(i386kernel)]] int sys_flistxattr(int fd, char *list, size_t size);
[[reko::service(vector=0x80, regs={eax:0xeb})]] [[reko::convention(i386kernel)]] int sys_removexattr(const char *path, const char *name);
[[reko::service(vector=0x80, regs={eax:0xec})]] [[reko::convention(i386kernel)]] int sys_lremovexattr(const char *path, const char *name);
[[reko::service(vector=0x80, regs={eax:0xed})]] [[reko::convention(i386kernel)]] int sys_fremovexattr(int fd, const char *name);
[[reko::service(vector=0x80, regs={eax:0xee})]] [[reko::convention(i386kernel)]] int sys_tkill(pid_t pid, int sig);
[[reko::service(vector=0x80, regs={eax:0xef})]] [[reko::convention(i386kernel)]] int sys_sendfile64(int out_fd, int in_fd, loff_t *offset, size_t count);
[[reko::service(vector=0x80, regs={eax:0xf0})]] [[reko::convention(i386kernel)]] int sys_futex(u32 *uaddr, int op, u32 val, const struct __kernel_timespec *utime, u32 *uaddr2, u32 val3);
[[reko::service(vector=0x80, regs={eax:0xf1})]] [[reko::convention(i386kernel)]] int sys_sched_setaffinity(pid_t pid, unsigned int len, unsigned long *user_mask_ptr);
[[reko::service(vector=0x80, regs={eax:0xf2})]] [[reko::convention(i386kernel)]] int sys_sched_getaffinity(pid_t pid, unsigned int len, unsigned long *user_mask_ptr);
[[reko::service(vector=0x80, regs={eax:0xf3})]] [[reko::convention(i386kernel)]] int sys_set_thread_area();
[[reko::service(vector=0x80, regs={eax:0xf4})]] [[reko::convention(i386kernel)]] int sys_get_thread_area();
[[reko::service(vector=0x80, regs={eax:0xf5})]] [[reko::convention(i386kernel)]] int sys_io_setup(unsigned nr_reqs, aio_context_t *ctx);
[[reko::service(vector=0x80, regs={eax:0xf6})]] [[reko::convention(i386kernel)]] int sys_io_destroy(aio_context_t ctx);
[[reko::service(vector=0x80, regs={eax:0xf7})]] [[reko::convention(i386kernel)]] int sys_io_getevents(aio_context_t ctx_id, long min_nr, long nr, struct io_event *events, struct __kernel_timespec *timeout);
[[reko::service(vector=0x80, regs={eax:0xf8})]] [[reko::convention(i386kernel)]] int sys_io_submit(aio_context_t, long, struct iocb * *);
[[reko::service(vector=0x80, regs={eax:0xf9})]] [[reko::convention(i386kernel)]] int sys_io_cancel(aio_context_t ctx_id, struct iocb *iocb, struct io_event *result);
[[reko::service(vector=0x80, regs={eax:0xfa})]] [[reko::convention(i386kernel)]] int sys_fadvise64(int fd, loff_t offset, size_t len, int advice);
[[reko::service(vector=0x80, regs={eax:0xfc})]] [[reko::convention(i386kernel)]] int sys_exit_group(int error_code);
[[reko::service(vector=0x80, regs={eax:0xfd})]] [[reko::convention(i386kernel)]] int sys_lookup_dcookie(u64 cookie64, char *buf, size_t len);
[[reko::service(vector=0x80, regs={eax:0xfe})]] [[reko::convention(i386kernel)]] int sys_epoll_create(int size);
[[reko::service(vector=0x80, regs={eax:0xff})]] [[reko::convention(i386kernel)]] int sys_epoll_ctl(int epfd, int op, int fd, struct epoll_event *event);
[[reko::service(vector=0x80, regs={eax:0x100})]] [[reko::convention(i386kernel)]] int sys_epoll_wait(int epfd, struct epoll_event *events, int maxevents, int timeout);
[[reko::service(vector=0x80, regs={eax:0x101})]] [[reko::convention(i386kernel)]] int sys_remap_file_pages(unsigned long start, unsigned long size, unsigned long prot, unsigned long pgoff, unsigned long flags);
[[reko::service(vector=0x80, regs={eax:0x102})]] [[reko::convention(i386kernel)]] int sys_set_tid_address(int *tidptr);
[[reko::service(vector=0x80, regs={eax:0x103})]] [[reko::convention(i386kernel)]] int sys_timer_create(clockid_t which_clock, struct sigevent *timer_event_spec, timer_t * created_timer_id);
[[reko::service(vector=0x80, regs={eax:0x104})]] [[reko::convention(i386kernel)]] int sys_timer_settime(timer_t timer_id, int flags, const struct __kernel_itimerspec *new_setting, struct __kernel_itimerspec *old_setting);
[[reko::service(vector=0x80, regs={eax:0x105})]] [[reko::convention(i386kernel)]] int sys_timer_gettime(timer_t timer_id, struct __kernel_itimerspec *setting);
[[reko::service(vector=0x80, regs={eax:0x106})]] [[reko::convention(i386kernel)]] int sys_timer_getoverrun(timer_t timer_id);
[[reko::service(vector=0x80, regs={eax:0x107})]] [[reko::convention(i386kernel)]] int sys_timer_delete(timer_t timer_id);
[[reko::service(vector=0x80, regs={eax:0x108})]] [[reko::convention(i386kernel)]] int sys_clock_settime(clockid_t which_clock, const struct __kernel_timespec *tp);
[[reko::service(vector=0x80, regs={eax:0x109})]] [[reko::convention(i386kernel)]] int sys_clock_gettime(clockid_t which_clock, struct __kernel_timespec *tp);
[[reko::service(vector=0x80, regs={eax:0x10a})]] [[reko::convention(i386kernel)]] int sys_clock_getres(clockid_t which_clock, struct __kernel_timespec *tp);
[[reko::service(vector=0x80, regs={eax:0x10b})]] [[reko::convention(i386kernel)]] int sys_clock_nanosleep(clockid_t which_clock, int flags, const struct __kernel_timespec *rqtp, struct __kernel_timespec *rmtp);
[[reko::service(vector=0x80, regs={eax:0x10c})]] [[reko::convention(i386kernel)]] int sys_statfs64(const char *path, size_t sz, struct statfs64 *buf);
[[reko::service(vector=0x80, regs={eax:0x10d})]] [[reko::convention(i386kernel)]] int sys_fstatfs64(unsigned int fd, size_t sz, struct statfs64 *buf);
[[reko::service(vector=0x80, regs={eax:0x10e})]] [[reko::convention(i386kernel)]] int sys_tgkill(pid_t tgid, pid_t pid, int sig);
[[reko::service(vector=0x80, regs={eax:0x10f})]] [[reko::convention(i386kernel)]] int sys_utimes(char *filename, struct __kernel_old_timeval *utimes);
[[reko::service(vector=0x80, regs={eax:0x110})]] [[reko::convention(i386kernel)]] int sys_fadvise64_64(int fd, loff_t offset, loff_t len, int advice);
[[reko::service(vector=0x80, regs={eax:0x111})]] [[reko::convention(i386kernel)]] int sys_vserver();
[[reko::service(vector=0x80, regs={eax:0x112})]] [[reko::convention(i386kernel)]] int sys_mbind(unsigned long start, unsigned long len, unsigned long mode, const unsigned long *nmask, unsigned long maxnode, unsigned flags);
[[reko::service(vector=0x80, regs={eax:0x113})]] [[reko::convention(i386kernel)]] int sys_get_mempolicy(int *policy, unsigned long *nmask, unsigned long maxnode, unsigned long addr, unsigned long flags);
[[reko::service(vector=0x80, regs={eax:0x114})]] [[reko::convention(i386kernel)]] int sys_set_mempolicy(int mode, const unsigned long *nmask, unsigned long maxnode);
[[reko::service(vector=0x80, regs={eax:0x115})]] [[reko::convention(i386kernel)]] int sys_mq_open(const char *name, int oflag, umode_t mode, struct mq_attr *attr);
[[reko::service(vector=0x80, regs={eax:0x116})]] [[reko::convention(i386kernel)]] int sys_mq_unlink(const char *name);
[[reko::service(vector=0x80, regs={eax:0x117})]] [[reko::convention(i386kernel)]] int sys_mq_timedsend(mqd_t mqdes, const char *msg_ptr, size_t msg_len, unsigned int msg_prio, const struct __kernel_timespec *abs_timeout);
[[reko::service(vector=0x80, regs={eax:0x118})]] [[reko::convention(i386kernel)]] int sys_mq_timedreceive(mqd_t mqdes, char *msg_ptr, size_t msg_len, unsigned int *msg_prio, const struct __kernel_timespec *abs_timeout);
[[reko::service(vector=0x80, regs={eax:0x119})]] [[reko::convention(i386kernel)]] int sys_mq_notify(mqd_t mqdes, const struct sigevent *notification);
[[reko::service(vector=0x80, regs={eax:0x11a})]] [[reko::convention(i386kernel)]] int sys_mq_getsetattr(mqd_t mqdes, const struct mq_attr *mqstat, struct mq_attr *omqstat);
[[reko::service(vector=0x80, regs={eax:0x11b})]] [[reko::convention(i386kernel)]] int sys_kexec_load(unsigned long entry, unsigned long nr_segments, struct kexec_segment *segments, unsigned long flags);
[[reko::service(vector=0x80, regs={eax:0x11c})]] [[reko::convention(i386kernel)]] int sys_waitid(int which, pid_t pid, struct siginfo *infop, int options, struct rusage *ru);
[[reko::service(vector=0x80, regs={eax:0x11e})]] [[reko::convention(i386kernel)]] int sys_add_key(const char *_type, const char *_description, const void *_payload, size_t plen, key_serial_t destringid);
[[reko::service(vector=0x80, regs={eax:0x11f})]] [[reko::convention(i386kernel)]] int sys_request_key(const char *_type, const char *_description, const char *_callout_info, key_serial_t destringid);
[[reko::service(vector=0x80, regs={eax:0x120})]] [[reko::convention(i386kernel)]] int sys_keyctl(int cmd, unsigned long arg2, unsigned long arg3, unsigned long arg4, unsigned long arg5);
[[reko::service(vector=0x80, regs={eax:0x121})]] [[reko::convention(i386kernel)]] int sys_ioprio_set(int which, int who, int ioprio);
[[reko::service(vector=0x80, regs={eax:0x122})]] [[reko::convention(i386kernel)]] int sys_ioprio_get(int which, int who);
[[reko::service(vector=0x80, regs={eax:0x123})]] [[reko::convention(i386kernel)]] int sys_inotify_init();
[[reko::service(vector=0x80, regs={eax:0x124})]] [[reko::convention(i386kernel)]] int sys_inotify_add_watch(int fd, const char *path, u32 mask);
[[reko::service(vector=0x80, regs={eax:0x125})]] [[reko::convention(i386kernel)]] int sys_inotify_rm_watch(int fd, __s32 wd);
[[reko::service(vector=0x80, regs={eax:0x126})]] [[reko::convention(i386kernel)]] int sys_migrate_pages(pid_t pid, unsigned long maxnode, const unsigned long *from, const unsigned long *to);
[[reko::service(vector=0x80, regs={eax:0x127})]] [[reko::convention(i386kernel)]] int sys_openat(int dfd, const char *filename, int flags, umode_t mode);
[[reko::service(vector=0x80, regs={eax:0x128})]] [[reko::convention(i386kernel)]] int sys_mkdirat(int dfd, const char * pathname, umode_t mode);
[[reko::service(vector=0x80, regs={eax:0x129})]] [[reko::convention(i386kernel)]] int sys_mknodat(int dfd, const char * filename, umode_t mode, unsigned dev);
[[reko::service(vector=0x80, regs={eax:0x12a})]] [[reko::convention(i386kernel)]] int sys_fchownat(int dfd, const char *filename, uid_t user, gid_t group, int flag);
[[reko::service(vector=0x80, regs={eax:0x12b})]] [[reko::convention(i386kernel)]] int sys_futimesat(int dfd, const char *filename, struct __kernel_old_timeval *utimes);
[[reko::service(vector=0x80, regs={eax:0x12c})]] [[reko::convention(i386kernel)]] int sys_fstatat64(int dfd, const char *filename, struct stat64 *statbuf, int flag);
[[reko::service(vector=0x80, regs={eax:0x12d})]] [[reko::convention(i386kernel)]] int sys_unlinkat(int dfd, const char * pathname, int flag);
[[reko::service(vector=0x80, regs={eax:0x12e})]] [[reko::convention(i386kernel)]] int sys_renameat(int olddfd, const char * oldname, int newdfd, const char * newname);
[[reko::service(vector=0x80, regs={eax:0x12f})]] [[reko::convention(i386kernel)]] int sys_linkat(int olddfd, const char *oldname, int newdfd, const char *newname, int flags);
[[reko::service(vector=0x80, regs={eax:0x130})]] [[reko::convention(i386kernel)]] int sys_symlinkat(const char * oldname, int newdfd, const char * newname);
[[reko::service(vector=0x80, regs={eax:0x131})]] [[reko::convention(i386kernel)]] int sys_readlinkat(int dfd, const char *path, char *buf, int bufsiz);
[[reko::service(vector=0x80, regs={eax:0x132})]] [[reko::convention(i386kernel)]] int sys_fchmodat(int dfd, const char * filename, umode_t mode);
[[reko::service(vector=0x80, regs={eax:0x133})]] [[reko::convention(i386kernel)]] int sys_faccessat(int dfd, const char *filename, int mode);
[[reko::service(vector=0x80, regs={eax:0x134})]] [[reko::convention(i386kernel)]] int sys_pselect6(int, fd_set *, fd_set *, fd_set *, struct __kernel_timespec *, void *);
[[reko::service(vector=0x80, regs={eax:0x135})]] [[reko::convention(i386kernel)]] int sys_ppoll(struct pollfd *, unsigned int, struct __kernel_timespec *, const sigset_t *, size_t);
[[reko::service(vector=0x80, regs={eax:0x136})]] [[reko::convention(i386kernel)]] int sys_unshare(unsigned long unshare_flags);
[[reko::service(vector=0x80, regs={eax:0x137})]] [[reko::convention(i386kernel)]] int sys_set_robust_list(struct robust_list_head *head, size_t len);
[[reko::service(vector=0x80, regs={eax:0x138})]] [[reko::convention(i386kernel)]] int sys_get_robust_list(int pid, struct robust_list_head * *head_ptr, size_t *len_ptr);
[[reko::service(vector=0x80, regs={eax:0x139})]] [[reko::convention(i386kernel)]] int sys_splice(int fd_in, loff_t *off_in, int fd_out, loff_t *off_out, size_t len, unsigned int flags);
[[reko::service(vector=0x80, regs={eax:0x13a})]] [[reko::convention(i386kernel)]] int sys_sync_file_range(int fd, loff_t offset, loff_t nbytes, unsigned int flags);
[[reko::service(vector=0x80, regs={eax:0x13b})]] [[reko::convention(i386kernel)]] int sys_tee(int fdin, int fdout, size_t len, unsigned int flags);
[[reko::service(vector=0x80, regs={eax:0x13c})]] [[reko::convention(i386kernel)]] int sys_vmsplice(int fd, const struct iovec *iov, unsigned long nr_segs, unsigned int flags);
[[reko::service(vector=0x80, regs={eax:0x13d})]] [[reko::convention(i386kernel)]] int sys_move_pages(pid_t pid, unsigned long nr_pages, const void * *pages, const int *nodes, int *status, int flags);
[[reko::service(vector=0x80, regs={eax:0x13e})]] [[reko::convention(i386kernel)]] int sys_getcpu(unsigned *cpu, unsigned *node, struct getcpu_cache *cache);
[[reko::service(vector=0x80, regs={eax:0x13f})]] [[reko::convention(i386kernel)]] int sys_epoll_pwait(int epfd, struct epoll_event *events, int maxevents, int timeout, const sigset_t *sigmask, size_t sigsetsize);
[[reko::service(vector=0x80, regs={eax:0x140})]] [[reko::convention(i386kernel)]] int sys_utimensat(int dfd, const char *filename, struct __kernel_timespec *utimes, int flags);
[[reko::service(vector=0x80, regs={eax:0x141})]] [[reko::convention(i386kernel)]] int sys_signalfd(int ufd, sigset_t *user_mask, size_t sizemask);
[[reko::service(vector=0x80, regs={eax:0x142})]] [[reko::convention(i386kernel)]] int sys_timerfd_create(int clockid, int flags);
[[reko::service(vector=0x80, regs={eax:0x143})]] [[reko::convention(i386kernel)]] int sys_eventfd(unsigned int count);
[[reko::service(vector=0x80, regs={eax:0x144})]] [[reko::convention(i386kernel)]] int sys_fallocate(int fd, int mode, loff_t offset, loff_t len);
[[reko::service(vector=0x80, regs={eax:0x145})]] [[reko::convention(i386kernel)]] int sys_timerfd_settime(int ufd, int flags, const struct __kernel_itimerspec *utmr, struct __kernel_itimerspec *otmr);
[[reko::service(vector=0x80, regs={eax:0x146})]] [[reko::convention(i386kernel)]] int sys_timerfd_gettime(int ufd, struct __kernel_itimerspec *otmr);
[[reko::service(vector=0x80, regs={eax:0x147})]] [[reko::convention(i386kernel)]] int sys_signalfd4(int ufd, sigset_t *user_mask, size_t sizemask, int flags);
[[reko::service(vector=0x80, regs={eax:0x148})]] [[reko::convention(i386kernel)]] int sys_eventfd2(unsigned int count, int flags);
[[reko::service(vector=0x80, regs={eax:0x149})]] [[reko::convention(i386kernel)]] int sys_epoll_create1(int flags);
[[reko::service(vector=0x80, regs={eax:0x14a})]] [[reko::convention(i386kernel)]] int sys_dup3(unsigned int oldfd, unsigned int newfd, int flags);
[[reko::service(vector=0x80, regs={eax:0x14b})]] [[reko::convention(i386kernel)]] int sys_pipe2(int *fildes, int flags);
[[reko::service(vector=0x80, regs={eax:0x14c})]] [[reko::convention(i386kernel)]] int sys_inotify_init1(int flags);
[[reko::service(vector=0x80, regs={eax:0x14d})]] [[reko::convention(i386kernel)]] int sys_preadv(unsigned long fd, const struct iovec *vec, unsigned long vlen, unsigned long pos_l, unsigned long pos_h);
[[reko::service(vector=0x80, regs={eax:0x14e})]] [[reko::convention(i386kernel)]] int sys_pwritev(unsigned long fd, const struct iovec *vec, unsigned long vlen, unsigned long pos_l, unsigned long pos_h);
[[reko::service(vector=0x80, regs={eax:0x14f})]] [[reko::convention(i386kernel)]] int sys_rt_tgsigqueueinfo(pid_t tgid, pid_t pid, int sig, siginfo_t *uinfo);
[[reko::service(vector=0x80, regs={eax:0x150})]] [[reko::convention(i386kernel)]] int sys_perf_event_open(struct perf_event_attr *attr_uptr, pid_t pid, int cpu, int group_fd, unsigned long flags);
[[reko::service(vector=0x80, regs={eax:0x151})]] [[reko::convention(i386kernel)]] int sys_recvmmsg(int fd, struct mmsghdr *msg, unsigned int vlen, unsigned flags, struct __kernel_timespec *timeout);
[[reko::service(vector=0x80, regs={eax:0x152})]] [[reko::convention(i386kernel)]] int sys_fanotify_init(unsigned int flags, unsigned int event_f_flags);
[[reko::service(vector=0x80, regs={eax:0x153})]] [[reko::convention(i386kernel)]] int sys_fanotify_mark(int fanotify_fd, unsigned int flags, u64 mask, int fd, const char *pathname);
[[reko::service(vector=0x80, regs={eax:0x154})]] [[reko::convention(i386kernel)]] int sys_prlimit64(pid_t pid, unsigned int resource, const struct rlimit64 *new_rlim, struct rlimit64 *old_rlim);
[[reko::service(vector=0x80, regs={eax:0x155})]] [[reko::convention(i386kernel)]] int sys_name_to_handle_at(int dfd, const char *name, struct file_handle *handle, int *mnt_id, int flag);
[[reko::service(vector=0x80, regs={eax:0x156})]] [[reko::convention(i386kernel)]] int sys_open_by_handle_at(int mountdirfd, struct file_handle *handle, int flags);
[[reko::service(vector=0x80, regs={eax:0x157})]] [[reko::convention(i386kernel)]] int sys_clock_adjtime(clockid_t which_clock, struct __kernel_timex *tx);
[[reko::service(vector=0x80, regs={eax:0x158})]] [[reko::convention(i386kernel)]] int sys_syncfs(int fd);
[[reko::service(vector=0x80, regs={eax:0x159})]] [[reko::convention(i386kernel)]] int sys_sendmmsg(int fd, struct mmsghdr *msg, unsigned int vlen, unsigned flags);
[[reko::service(vector=0x80, regs={eax:0x15a})]] [[reko::convention(i386kernel)]] int sys_setns(int fd, int nstype);
[[reko::service(vector=0x80, regs={eax:0x15b})]] [[reko::convention(i386kernel)]] int sys_process_vm_readv(pid_t pid, const struct iovec *lvec, unsigned long liovcnt, const struct iovec *rvec, unsigned long riovcnt, unsigned long flags);
[[reko::service(vector=0x80, regs={eax:0x15c})]] [[reko::convention(i386kernel)]] int sys_process_vm_writev(pid_t pid, const struct iovec *lvec, unsigned long liovcnt, const struct iovec *rvec, unsigned long riovcnt, unsigned long flags);
[[reko::service(vector=0x80, regs={eax:0x15d})]] [[reko::convention(i386kernel)]] int sys_kcmp(pid_t pid1, pid_t pid2, int type, unsigned long idx1, unsigned long idx2);
[[reko::service(vector=0x80, regs={eax:0x15e})]] [[reko::convention(i386kernel)]] int sys_finit_module(int fd, const char *uargs, int flags);
[[reko::service(vector=0x80, regs={eax:0x15f})]] [[reko::convention(i386kernel)]] int sys_sched_setattr(pid_t pid, struct sched_attr *attr, unsigned int flags);
[[reko::service(vector=0x80, regs={eax:0x160})]] [[reko::convention(i386kernel)]] int sys_sched_getattr(pid_t pid, struct sched_attr *attr, unsigned int size, unsigned int flags);
[[reko::service(vector=0x80, regs={eax:0x161})]] [[reko::convention(i386kernel)]] int sys_renameat2(int olddfd, const char *oldname, int newdfd, const char *newname, unsigned int flags);
[[reko::service(vector=0x80, regs={eax:0x162})]] [[reko::convention(i386kernel)]] int sys_seccomp(unsigned int op, unsigned int flags, void *uargs);
[[reko::service(vector=0x80, regs={eax:0x163})]] [[reko::convention(i386kernel)]] int sys_getrandom(char *buf, size_t count, unsigned int flags);
[[reko::service(vector=0x80, regs={eax:0x164})]] [[reko::convention(i386kernel)]] int sys_memfd_create(const char *uname_ptr, unsigned int flags);
[[reko::service(vector=0x80, regs={eax:0x165})]] [[reko::convention(i386kernel)]] int sys_bpf(int cmd, union bpf_attr *attr, unsigned int size);
[[reko::service(vector=0x80, regs={eax:0x166})]] [[reko::convention(i386kernel)]] int sys_execveat(int dfd, const char *filename, const char *const *argv, const char *const *envp, int flags);
[[reko::service(vector=0x80, regs={eax:0x167})]] [[reko::convention(i386kernel)]] int sys_socket(int, int, int);
[[reko::service(vector=0x80, regs={eax:0x168})]] [[reko::convention(i386kernel)]] int sys_socketpair(int, int, int, int *);
[[reko::service(vector=0x80, regs={eax:0x169})]] [[reko::convention(i386kernel)]] int sys_bind(int, struct sockaddr *, int);
[[reko::service(vector=0x80, regs={eax:0x16a})]] [[reko::convention(i386kernel)]] int sys_connect(int, struct sockaddr *, int);
[[reko::service(vector=0x80, regs={eax:0x16b})]] [[reko::convention(i386kernel)]] int sys_listen(int, int);
[[reko::service(vector=0x80, regs={eax:0x16c})]] [[reko::convention(i386kernel)]] int sys_accept4(int, struct sockaddr *, int *, int);
[[reko::service(vector=0x80, regs={eax:0x16d})]] [[reko::convention(i386kernel)]] int sys_getsockopt(int fd, int level, int optname, char *optval, int *optlen);
[[reko::service(vector=0x80, regs={eax:0x16e})]] [[reko::convention(i386kernel)]] int sys_setsockopt(int fd, int level, int optname, char *optval, int optlen);
[[reko::service(vector=0x80, regs={eax:0x16f})]] [[reko::convention(i386kernel)]] int sys_getsockname(int, struct sockaddr *, int *);
[[reko::service(vector=0x80, regs={eax:0x170})]] [[reko::convention(i386kernel)]] int sys_getpeername(int, struct sockaddr *, int *);
[[reko::service(vector=0x80, regs={eax:0x171})]] [[reko::convention(i386kernel)]] int sys_sendto(int, void *, size_t, unsigned, struct sockaddr *, int);
[[reko::service(vector=0x80, regs={eax:0x172})]] [[reko::convention(i386kernel)]] int sys_sendmsg(int fd, struct user_msghdr *msg, unsigned flags);
[[reko::service(vector=0x80, regs={eax:0x173})]] [[reko::convention(i386kernel)]] int sys_recvfrom(int, void *, size_t, unsigned, struct sockaddr *, int *);
[[reko::service(vector=0x80, regs={eax:0x174})]] [[reko::convention(i386kernel)]] int sys_recvmsg(int fd, struct user_msghdr *msg, unsigned flags);
[[reko::service(vector=0x80, regs={eax:0x175})]] [[reko::convention(i386kernel)]] int sys_shutdown(int, int);
[[reko::service(vector=0x80, regs={eax:0x176})]] [[reko::convention(i386kernel)]] int sys_userfaultfd(int flags);
[[reko::service(vector=0x80, regs={eax:0x177})]] [[reko::convention(i386kernel)]] int sys_membarrier(int cmd, unsigned int flags, int cpu_id);
[[reko::service(vector=0x80, regs={eax:0x178})]] [[reko::convention(i386kernel)]] int sys_mlock2(unsigned long start, size_t len, int flags);
[[reko::service(vector=0x80, regs={eax:0x179})]] [[reko::convention(i386kernel)]] int sys_copy_file_range(int fd_in, loff_t *off_in, int fd_out, loff_t *off_out, size_t len, unsigned int flags);
[[reko::service(vector=0x80, regs={eax:0x17a})]] [[reko::convention(i386kernel)]] int sys_preadv2(unsigned long fd, const struct iovec *vec, unsigned long vlen, unsigned long pos_l, unsigned long pos_h, rwf_t flags);
[[reko::service(vector=0x80, regs={eax:0x17b})]] [[reko::convention(i386kernel)]] int sys_pwritev2(unsigned long fd, const struct iovec *vec, unsigned long vlen, unsigned long pos_l, unsigned long pos_h, rwf_t flags);
[[reko::service(vector=0x80, regs={eax:0x17c})]] [[reko::convention(i386kernel)]] int sys_pkey_mprotect(unsigned long start, size_t len, unsigned long prot, int pkey);
[[reko::service(vector=0x80, regs={eax:0x17d})]] [[reko::convention(i386kernel)]] int sys_pkey_alloc(unsigned long flags, unsigned long init_val);
[[reko::service(vector=0x80, regs={eax:0x17e})]] [[reko::convention(i386kernel)]] int sys_pkey_free(int pkey);
[[reko::service(vector=0x80, regs={eax:0x17f})]] [[reko::convention(i386kernel)]] int sys_statx(int dfd, const char *path, unsigned flags, unsigned mask, struct statx *buffer);
[[reko::service(vector=0x80, regs={eax:0x180})]] [[reko::convention(i386kernel)]] int sys_arch_prctl();
[[reko::service(vector=0x80, regs={eax:0x193})]] [[reko::convention(i386kernel)]] int sys_clock_gettime64();
[[reko::service(vector=0x80, regs={eax:0x194})]] [[reko::convention(i386kernel)]] int sys_clock_settime64();
[[reko::service(vector=0x80, regs={eax:0x195})]] [[reko::convention(i386kernel)]] int sys_clock_adjtime64();
[[reko::service(vector=0x80, regs={eax:0x196})]] [[reko::convention(i386kernel)]] int sys_clock_getres_time64();
[[reko::service(vector=0x80, regs={eax:0x197})]] [[reko::convention(i386kernel)]] int sys_clock_nanosleep_time64();
[[reko::service(vector=0x80, regs={eax:0x198})]] [[reko::convention(i386kernel)]] int sys_timer_gettime64();
[[reko::service(vector=0x80, regs={eax:0x199})]] [[reko::convention(i386kernel)]] int sys_timer_settime64();
[[reko::service(vector=0x80, regs={eax:0x19a})]] [[reko::convention(i386kernel)]] int sys_timerfd_gettime64();
[[reko::service(vector=0x80, regs={eax:0x19b})]] [[reko::convention(i386kernel)]] int sys_timerfd_settime64();
[[reko::service(vector=0x80, regs={eax:0x19c})]] [[reko::convention(i386kernel)]] int sys_utimensat_time64();
[[reko::service(vector=0x80, regs={eax:0x19d})]] [[reko::convention(i386kernel)]] int sys_pselect6_time64();
[[reko::service(vector=0x80, regs={eax:0x19e})]] [[reko::convention(i386kernel)]] int sys_ppoll_time64();
[[reko::service(vector=0x80, regs={eax:0x1a0})]] [[reko::convention(i386kernel)]] int sys_io_pgetevents_time64();
[[reko::service(vector=0x80, regs={eax:0x1a1})]] [[reko::convention(i386kernel)]] int sys_recvmmsg_time64();
[[reko::service(vector=0x80, regs={eax:0x1a2})]] [[reko::convention(i386kernel)]] int sys_mq_timedsend_time64();
[[reko::service(vector=0x80, regs={eax:0x1a3})]] [[reko::convention(i386kernel)]] int sys_mq_timedreceive_time64();
[[reko::service(vector=0x80, regs={eax:0x1a4})]] [[reko::convention(i386kernel)]] int sys_semtimedop_time64();
[[reko::service(vector=0x80, regs={eax:0x1a5})]] [[reko::convention(i386kernel)]] int sys_rt_sigtimedwait_time64();
[[reko::service(vector=0x80, regs={eax:0x1a6})]] [[reko::convention(i386kernel)]] int sys_futex_time64();
[[reko::service(vector=0x80, regs={eax:0x1a7})]] [[reko::convention(i386kernel)]] int sys_sched_rr_get_interval_time64();
[[reko::service(vector=0x80, regs={eax:0x1a9})]] [[reko::convention(i386kernel)]] int sys_io_uring_setup(u32 entries, struct io_uring_params *p);
[[reko::service(vector=0x80, regs={eax:0x1aa})]] [[reko::convention(i386kernel)]] int sys_io_uring_enter(unsigned int fd, u32 to_submit, u32 min_complete, u32 flags, const void *argp, size_t argsz);
[[reko::service(vector=0x80, regs={eax:0x1b7})]] [[reko::convention(i386kernel)]] int sys_faccessat2(int dfd, const char *filename, int mode, int flags);
